-- Generation time: Sun, 05 Oct 2025 13:48:50 +0300
-- Host: localhost
-- DB name: erbilsystem_fabric
/*!40030 SET NAMES UTF8 */;
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

DROP TABLE IF EXISTS `capital`;
CREATE TABLE `capital` (
  `capital_id` int(11) NOT NULL AUTO_INCREMENT,
  `capital_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `date_of_add` date DEFAULT NULL,
  `amount_owner_staff_id_fk` int(11) NOT NULL DEFAULT 0 COMMENT 'staff_id_fk',
  `is_company` int(1) DEFAULT 0 COMMENT '0:not company; 1: from company profit',
  `capital_usd_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `capital_currency` int(1) DEFAULT 1 COMMENT '0:IDQ; 1:USD',
  `capital_note` text DEFAULT NULL,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`capital_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `capital_withdraw`;
CREATE TABLE `capital_withdraw` (
  `capital_withdraw_id` int(11) NOT NULL AUTO_INCREMENT,
  `withdraw_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `withdraw_date` date DEFAULT NULL,
  `withdraw_by` int(11) NOT NULL DEFAULT 0 COMMENT 'staff_id_fk',
  `for_company` int(1) DEFAULT 0 COMMENT '0:not company; 1: for company profit',
  `withdraw_usd_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `withdraw_currency` int(1) DEFAULT 1 COMMENT '0:IDQ; 1:USD',
  `withdraw_status` int(1) NOT NULL DEFAULT 0 COMMENT '0:not_paid; 1:partially_paid; 2:paid',
  `withdraw_note` text DEFAULT NULL,
  `staff_customer` int(1) NOT NULL DEFAULT 0 COMMENT '0:customer;1:staff',
  `gived_to_id_fk` int(11) NOT NULL DEFAULT 0 COMMENT 'customer_id_fk',
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`capital_withdraw_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `capital_withdraw` VALUES ('1','2207.00','2022-01-10','1','0','1250.00','1','0','من سيستم قديم ','0','5','0','2022-01-10 14:13:40','2022-01-10 14:13:40',NULL,'1','Add New Amount to Capital_withdraw','1'),
('2','9434.00','2022-01-12','1','0','1250.00','1','0','من سيستم قديم ','0','7','0','2022-01-12 08:53:08','2022-01-12 08:53:08',NULL,'1','Add New Amount to Capital_withdraw','1'),
('3','2305.00','2022-01-12','1','0','1250.00','1','0','من سيستم قديم ','0','6','0','2022-01-12 08:54:42','2022-01-12 08:54:42',NULL,'1','Add New Amount to Capital_withdraw','1'),
('4','34.00','2022-01-17','4','0','1250.00','1','0','','0','9','0','2022-01-17 16:09:53','2022-01-17 16:09:53',NULL,'1','Add New Amount to Capital_withdraw','1'),
('5','46722.00','2022-01-19','4','0','1250.00','1','0','من سيستم قديم ','0','8','0','2022-01-19 11:55:54','2022-01-19 11:55:54',NULL,'1','Add New Amount to Capital_withdraw','1'),
('6','37298.00','2022-01-19','4','0','1250.00','1','0','من سيستم قديم ','0','10','0','2022-01-19 12:48:00','2022-01-19 12:48:00',NULL,'1','Add New Amount to Capital_withdraw','1'),
('7','66921.00','2022-01-24','1','0','1250.00','1','0','من سيستم قديم ','0','11','0','2022-01-24 14:37:08','2022-01-24 14:37:08',NULL,'1','Add New Amount to Capital_withdraw','1'),
('8','5308.00','2022-01-24','1','0','1250.00','1','0','من سيستم قديم ','0','12','0','2022-01-24 16:29:32','2022-01-24 16:29:32',NULL,'1','Add New Amount to Capital_withdraw','1'),
('9','9752.00','2022-01-26','1','0','1250.00','1','0','من سيستم قديم ','0','13','0','2022-01-26 14:40:27','2022-01-26 14:40:27',NULL,'1','Add New Amount to Capital_withdraw','1'),
('10','2354.00','2022-01-29','1','0','1250.00','1','0','من سيستم قديم ','0','14','0','2022-01-29 08:53:16','2022-01-29 08:53:16',NULL,'1','Add New Amount to Capital_withdraw','1'),
('11','4664.00','2022-01-29','1','0','1250.00','1','0','من سيستم قديم ','0','15','0','2022-01-29 13:40:00','2022-01-29 13:40:00',NULL,'1','Add New Amount to Capital_withdraw','1'),
('12','2985.00','2022-01-30','1','0','1250.00','1','0','من سيستم قديم ','0','16','0','2022-01-30 13:54:44','2022-01-30 13:54:44',NULL,'1','Add New Amount to Capital_withdraw','1'),
('13','1019.00','2022-02-02','1','0','1250.00','1','0','من سيستم قديم ','0','17','0','2022-02-02 10:59:01','2022-02-02 10:59:01',NULL,'1','Add New Amount to Capital_withdraw','1'),
('14','22062.00','2022-02-16','1','0','1250.00','1','0','من سيستم قديم ','0','22','0','2022-02-16 09:30:34','2022-02-16 09:30:34',NULL,'1','Add New Amount to Capital_withdraw','1'),
('15','1550.00','2022-02-19','1','0','1250.00','1','0','من سيستم قديم','0','23','0','2022-02-19 12:34:54','2022-02-19 12:34:54',NULL,'1','Add New Amount to Capital_withdraw','1'); 


DROP TABLE IF EXISTS `capital_withdraw_archive`;
CREATE TABLE `capital_withdraw_archive` (
  `capital_withdraw_id` int(11) NOT NULL AUTO_INCREMENT,
  `withdraw_amount` decimal(10,2) NOT NULL,
  `withdraw_date` date NOT NULL,
  `withdraw_by` int(11) NOT NULL COMMENT 'staff_id_fk',
  `for_company` int(1) DEFAULT NULL COMMENT '0:not company; 1: for company profit',
  `withdraw_usd_rate` decimal(10,2) NOT NULL,
  `withdraw_currency` int(1) DEFAULT NULL COMMENT '0:IDQ; 1:USD',
  `withdraw_status` int(1) NOT NULL COMMENT '0:not_paid; 1:partially_paid; 2:paid',
  `withdraw_note` text NOT NULL,
  `staff_customer` int(1) NOT NULL COMMENT '0:customer;1:staff',
  `gived_to_id_fk` int(11) NOT NULL COMMENT 'customer_id_fk',
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `last_action` varchar(100) NOT NULL,
  `last_action_by` int(11) NOT NULL,
  PRIMARY KEY (`capital_withdraw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `capital_withdraw_payments`;
CREATE TABLE `capital_withdraw_payments` (
  `capital_withdraw_payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_withdraw_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payment_withdraw_date` date DEFAULT NULL,
  `payment_withdraw_usd_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `payment_withdraw_currency` int(1) DEFAULT 0 COMMENT '0:IDQ; 1:USD',
  `payment_withdraw_note` text DEFAULT NULL,
  `payment_gived_to_id_fk` int(11) NOT NULL DEFAULT 0 COMMENT 'customer_id_fk',
  `group_no` varchar(50) DEFAULT NULL,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`capital_withdraw_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `category_description` varchar(150) DEFAULT NULL,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `color_status`;
CREATE TABLE `color_status` (
  `color_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `status_color` varchar(150) DEFAULT NULL,
  `status_name` varchar(150) DEFAULT NULL,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`color_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `customer`;
CREATE TABLE `customer` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_full_name` varchar(100) DEFAULT NULL,
  `customer_email` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(250) DEFAULT NULL,
  `customer_phone2` varchar(30) DEFAULT NULL,
  `customer_address` varchar(100) DEFAULT NULL,
  `customer_job_title` varchar(40) DEFAULT NULL,
  `city_id_fk` int(11) NOT NULL DEFAULT 0,
  `customer_username` varchar(50) DEFAULT NULL,
  `customer_password` varchar(1024) DEFAULT NULL,
  `profile_img` varchar(256) DEFAULT NULL,
  `cover_img` varchar(256) DEFAULT NULL,
  `login_count` int(11) NOT NULL DEFAULT 0,
  `last_login` datetime DEFAULT NULL,
  `price_profile_id_fk` int(11) NOT NULL DEFAULT 0 COMMENT 'determine this customer belong to which price profile',
  `customer_type` int(1) NOT NULL DEFAULT 0 COMMENT '0: Agent always come; 1:Normal_customer_come_once',
  `language_id_fk` int(11) NOT NULL DEFAULT 0,
  `is_deleted` int(1) NOT NULL DEFAULT 0 COMMENT '0:active; 1:de-active; 2:deleted',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `staff-to-staff_group` (`price_profile_id_fk`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `customer` VALUES ('4','A.T علي احمد نجف ','','07810750078','','نجف ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-09 11:41:25','2022-01-09 11:41:25',NULL,'1','Create New Customer','1'),
('5','A.T صالح البان ','','07504369292','','اربيل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-10 14:11:43','2022-01-10 14:11:43',NULL,'1','Create New Customer','1'),
('6','A.T صلاح رسول','','07504104549','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-12 08:49:46','2022-01-12 08:49:46',NULL,'1','Create New Customer','1'),
('7','A.T ستائر عدنان ','','07503797061','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-12 08:51:00','2022-01-12 08:51:00',NULL,'1','Create New Customer','1'),
('8','A.T كنعان ','','07507922088','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-16 13:29:07','2022-01-16 13:29:07',NULL,'1','Create New Customer','1'),
('9','A.T مصطفي هاوري كركوك ','','07701976966','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-17 16:06:21','2022-01-17 16:06:21',NULL,'1','Create New Customer','1'),
('10','A.T علي ضياء كربلاء ','','07708844618','','كربلاء ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-19 12:45:28','2022-01-19 12:45:28',NULL,'1','Create New Customer','1'),
('11','A.T انيا فرع دهوك ','','07504500747','','دهوك ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-24 14:35:12','2022-01-24 14:35:12',NULL,'1','Create New Customer','1'),
('12','A.T ستائر تاج ','','07504453594','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-24 16:28:32','2022-01-24 16:28:32',NULL,'1','Create New Customer','1'),
('13','A.T ستائر الملك تكريت ','','07705323191','','تكريت','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-26 14:38:34','2022-01-26 14:38:34',NULL,'1','Create New Customer','1'),
('14','A.T بيشانكاي نياز ','','07504512280','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-29 08:52:02','2022-01-29 08:52:02',NULL,'1','Create New Customer','1'),
('15','A.T ئارياس بو بةردة زانا ','','07508902008','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-29 13:38:21','2022-01-29 13:38:21',NULL,'1','Create New Customer','1'),
('16','A.T كومش ','','07504144059','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-01-30 13:53:14','2022-01-30 13:53:14',NULL,'1','Create New Customer','1'),
('17','A.Tهاكار كركوك ','','07701334923','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-02 10:58:07','2022-02-02 10:58:07',NULL,'1','Update Customer','1'),
('18','A.T بدران 60 متري','','07504490570','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-06 12:34:46','2022-02-06 12:34:46',NULL,'1','Create New Customer','1'),
('19','A.T ستاركو ','','07508162888','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-07 15:55:56','2022-02-07 15:55:56',NULL,'1','Create New Customer','1'),
('20','A.T محمد عقراوي','','07504499038','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-13 09:58:57','2022-02-13 09:58:57',NULL,'1','Create New Customer','1'),
('21','A.T ستائر قمر موصل','','07701887633','','موصل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-13 10:38:00','2022-02-13 10:38:00',NULL,'1','Create New Customer','1'),
('22','A.T ايهاب سامراء','','07704947020 ','','سامراء','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-16 09:28:54','2022-02-16 09:28:54',NULL,'1','Create New Customer','1'),
('23','A.T حاتم حةساروك','','07504526118','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-02-19 12:33:42','2022-02-19 12:33:42',NULL,'1','Create New Customer','1'),
('24','ئوسامة دريم ستي','','07504453773','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-06 11:11:26','2022-03-06 11:11:26',NULL,'1','Create New Customer','1'),
('25','علا','','07500333373','','وةزيران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-07 15:25:07','2022-03-07 15:25:07',NULL,'1','Create New Customer','1'),
('26','A.T وليد اكري ','','07504562172','','اكري','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-03-10 14:36:50','2022-03-10 14:36:50',NULL,'1','Create New Customer','1'),
('27','سينك','','07504451499','','كوندي انكليزي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-10 16:01:50','2022-03-10 16:01:50',NULL,'1','Create New Customer','1'),
('28','لانة خان','','07504826749','','هةوليري نوئ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-13 11:22:34','2022-03-13 11:22:34',NULL,'1','Create New Customer','1'),
('29','سامي محمد','','00491729583552','','بةختياري','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-17 10:41:29','2022-03-17 10:41:29',NULL,'1','Create New Customer','1'),
('30','علي خضروي','','07815743335','','لالاف ستي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-17 10:49:38','2022-03-17 10:49:38',NULL,'1','Create New Customer','1'),
('31','ماموستا روخسار','','07504520883','','ايتالي 1','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-19 15:27:34','2022-03-19 15:27:34',NULL,'1','Create New Customer','1'),
('32','محمد ازاد','','07504563800','','وةزيران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-19 15:36:54','2022-03-19 15:36:54',NULL,'1','Create New Customer','1'),
('33','ماموستا محمود','','07503692006','','زانكو','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-19 16:34:35','2022-03-19 16:34:35',NULL,'1','Create New Customer','1'),
('34','داكي مير','','07504788458','','وةزيران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-26 11:23:11','2022-03-26 11:23:11',NULL,'1','Create New Customer','1'),
('35','محمد نجيب','','07504559430','','شوقةي زانياري','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-26 14:35:14','2022-03-26 14:35:14',NULL,'1','Create New Customer','1'),
('36','ريكان','','0000000000','','ئازادي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-26 15:00:35','2022-03-26 15:00:35',NULL,'1','Create New Customer','1'),
('37','حاجي مهدي','','00000000000','','خةبات','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-26 17:11:28','2022-03-26 17:11:28',NULL,'1','Create New Customer','1'),
('38','علي مجيد','','07505556675','','لالاف سيتي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-03-30 13:16:29','2022-03-30 13:16:29',NULL,'1','Create New Customer','1'),
('39','مةريوان','','07504648503','','حاكماوة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-04 14:54:00','2022-04-04 14:54:00',NULL,'1','Create New Customer','1'),
('40','سرمند','','000000000','','كةنجان سيتي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-05 16:44:42','2022-04-05 16:44:42',NULL,'1','Create New Customer','1'),
('41',' حسكو','','07504483667','','ريزان','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-07 13:47:52','2022-04-07 13:47:52',NULL,'1','Create New Customer','1'),
('42','باوكي عمر','','000000000','','كوندي انكليزي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-09 12:06:31','2022-04-09 12:06:31',NULL,'1','Create New Customer','1'),
('43','صفاء','','07723619961','','جيهان سيتي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-09 16:06:21','2022-04-09 16:06:21',NULL,'1','Create New Customer','1'),
('44','دارا','','000000000','','ايطالي 1','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-11 11:57:27','2022-04-11 11:57:27',NULL,'1','Create New Customer','1'),
('45','هيوا','','07504971842','','زين ستي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-17 11:54:12','2022-04-17 11:54:12',NULL,'1','Create New Customer','1'),
('46','رضوان','','07504624814','','جي شعبي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-17 11:58:27','2022-04-17 11:58:27',NULL,'1','Create New Customer','1'),
('47','ام ابراهيم','','07506770560','','نوسةران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-17 12:05:10','2022-04-17 12:05:10',NULL,'1','Create New Customer','1'),
('48','حازم','','000000000','','شةقلاوة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-17 12:32:33','2022-04-17 12:32:33',NULL,'1','Create New Customer','1'),
('49','كوفان','','000000000','','كوندي انكليزي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-18 13:24:36','2022-04-18 13:24:36',NULL,'1','Create New Customer','1'),
('50','A.T ابو عبدالله بغداد مقاول ','','07708992878','','بغداد ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-04-19 19:43:09','2022-04-19 19:43:09',NULL,'1','Update Customer','1'),
('51','مهندس مسعود','','000000000','','32park','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-20 12:06:55','2022-04-20 12:06:55',NULL,'1','Create New Customer','1'),
('52','ماموستا سةيران','','000000000','','وةزيران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-20 12:14:08','2022-04-20 12:14:08',NULL,'1','Create New Customer','1'),
('53','دايكي احمد','','07504692805','','نوسةران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-20 12:17:46','2022-04-20 12:17:46',NULL,'1','Create New Customer','1'),
('54','كاك هوشةنك','','07504460289','','خاني الماني','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-20 12:22:21','2022-04-20 12:22:21',NULL,'1','Create New Customer','1'),
('55','نةوروز','','07504117117','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-20 12:29:50','2022-04-20 12:29:50',NULL,'1','Create New Customer','1'),
('56','نزار ','','000000000','','بةردةرةش','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-23 15:09:25','2022-04-23 15:09:25',NULL,'1','Create New Customer','1'),
('57','هةفال','','07514803215','','زين سيتي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-28 13:42:48','2022-04-28 13:42:48',NULL,'1','Create New Customer','1'),
('58','عزيز','','07504473183','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-30 12:10:36','2022-04-30 12:10:36',NULL,'1','Create New Customer','1'),
('59','موشتةري سةريع','','000000000','','نازانم','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-04-30 12:15:19','2022-04-30 12:15:19',NULL,'1','Create New Customer','1'),
('60','شيرزاد','','07504477171','','32 park','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-12 12:45:25','2022-05-12 12:45:25',NULL,'1','Create New Customer','1'),
('61','سعد جيران','','000000000','','32 بارك','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-12 15:08:27','2022-05-12 15:08:27',NULL,'1','Create New Customer','1'),
('62','برادةري كاروان','','000000000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-12 15:27:04','2022-05-12 15:27:04',NULL,'1','Create New Customer','1'),
('63','هيوا كاروان','','07502551212','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-14 13:51:07','2022-05-14 13:51:07',NULL,'1','Create New Customer','1'),
('64','محمد عيماد','','000000000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-15 11:27:04','2022-05-15 11:27:04',NULL,'1','Create New Customer','1'),
('65','ماركيتي جيرانمان','','000000000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-15 11:31:31','2022-05-15 11:31:31',NULL,'1','Create New Customer','1'),
('66','نريمان','','07504937064','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-15 11:32:58','2022-05-15 11:32:58',NULL,'1','Create New Customer','1'),
('67','فؤاد','','07514404625','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-15 11:43:43','2022-05-15 11:43:43',NULL,'1','Create New Customer','1'),
('68','دانا فرهاد','','000000000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-15 11:54:56','2022-05-15 11:54:56',NULL,'1','Create New Customer','1'),
('69','هدي','','07741138077','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-15 11:58:53','2022-05-15 11:58:53',NULL,'1','Create New Customer','1'),
('70','سامان','','07504658179','','منارة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-17 15:08:27','2022-05-17 15:08:27',NULL,'1','Create New Customer','1'),
('71','سمير','','07501202789','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-22 16:59:03','2022-05-22 16:59:03',NULL,'1','Create New Customer','1'),
('72','علي فحس سيارة','','07504472279','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-24 14:40:06','2022-05-24 14:40:06',NULL,'1','Create New Customer','1'),
('73','نيازي','','07729966749','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-05-26 10:43:43','2022-05-26 10:43:43',NULL,'1','Create New Customer','1'),
('74','بانكي كوردستان','','000000000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-04 11:04:23','2022-06-04 11:04:23',NULL,'1','Create New Customer','1'),
('75','محمد كارةبا','','000000000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-04 11:19:50','2022-06-04 11:19:50',NULL,'1','Create New Customer','1'),
('76','فرهاد شيرن سلات','','07504539743','','اربيل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-06-04 13:15:35','2022-06-04 13:15:35',NULL,'1','Update Customer','1'),
('77','داكي كامةران','','000000000','','حي مهندسين','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-05 14:15:14','2022-06-05 14:15:14',NULL,'1','Create New Customer','1'),
('78','حسن ','','07703896643','','108 عنكاوة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-05 14:27:27','2022-06-05 14:27:27',NULL,'1','Create New Customer','1'),
('79','بروا','','000000000','','شوقةي زانياري','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-08 12:52:41','2022-06-08 12:52:41',NULL,'1','Create New Customer','1'),
('80','روزكار ريكان','','07504140340','','ئازادي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-08 12:58:42','2022-06-08 12:58:42',NULL,'1','Create New Customer','1'),
('81','ئارام','','000000000','','خاريخ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-08 13:31:06','2022-06-08 13:31:06',NULL,'1','Create New Customer','1'),
('82','مزةفةر','','07504546804','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-09 13:07:33','2022-06-09 13:07:33',NULL,'1','Create New Customer','1'),
('83','اوسامة جلبي','','07504812016','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-13 17:48:47','2022-06-13 17:48:47',NULL,'1','Create New Customer','1'),
('84','سعدون ','','00000000','','كةنجان ستي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2022-06-15 15:01:17','2022-06-15 15:01:17',NULL,'1','Create New Customer','1'),
('85','A.T سةركةوت سليماني ','','07701552576','','سليماني','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-07-23 14:18:27','2022-07-23 14:18:27',NULL,'1','Create New Customer','1'),
('86','A.T جيكر تاج شورش','','07505111122','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-08-21 14:45:11','2022-08-21 14:45:11',NULL,'1','Update Customer','1'),
('87','A.T محمود مافي ','','07504480523','','هةولير','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-09-05 14:10:21','2022-09-05 14:10:21',NULL,'1','Create New Customer','1'),
('88','A.T ابو حسين بسمايه ','','07721749372','','بغداد ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-09-17 13:51:47','2022-09-17 13:51:47',NULL,'1','Create New Customer','1'),
('89','A.T قصر فخامة ','','07518105584','','موصل ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-09-18 10:57:44','2022-09-18 10:57:44',NULL,'1','Create New Customer','1'),
('90','صفيان براي فاضل','','07504050910','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-09-19 18:33:50','2022-09-19 18:33:50',NULL,'1','Update Customer','1'),
('91','A.T دةرباز رانية ','','07501663464','','رانية ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-09-20 13:17:23','2022-09-20 13:17:23',NULL,'1','Create New Customer','1'),
('92','A.T ياسين رمادي','','07802668546','','رمادي ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-10-04 11:31:18','2022-10-04 11:31:18',NULL,'1','Create New Customer','1'),
('93','A.T ابو بكر شيخ جولي ','','07504468049','','اربيل ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-10-05 12:55:38','2022-10-05 12:55:38',NULL,'1','Create New Customer','1'),
('94','A.T رعد سامراء ','','07701023081','','سامراء ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-10-09 17:03:15','2022-10-09 17:03:15',NULL,'1','Create New Customer','1'),
('95','A.T زيد ستائر سلام نجف ','','07723805261','','النجف ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2022-12-11 14:14:20','2022-12-11 14:14:20',NULL,'1','Create New Customer','1'),
('96','A.T ستائر امير عنكاو ','','07503144880','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-01-18 15:59:44','2023-01-18 15:59:44',NULL,'1','Create New Customer','1'),
('97','بةرهةم ','','0750','','سليماني','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2023-02-15 10:55:53','2023-02-15 10:55:53',NULL,'1','Create New Customer','1'),
('98','A.T دكتور عباس حلة ','','07712931950','','حلة ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-02-20 11:24:27','2023-02-20 11:24:27',NULL,'1','Create New Customer','1'),
('99','A.T فرحان سوز قماش','','07504779966','','هولير ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-03-04 15:10:59','2023-03-04 15:10:59',NULL,'1','Create New Customer','1'),
('100','A.T ماهر تكريت','','07725671210','','تكريت','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-03-26 13:36:24','2023-03-26 13:36:24',NULL,'1','Update Customer','1'),
('101','A.T فرهاد 32','','07505651254','','32 بارك','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-03-29 10:01:37','2023-03-29 10:01:37',NULL,'1','Create New Customer','1'),
('102','A.T دلاور البان','','07507740974','','البان','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-04-03 11:02:41','2023-04-03 11:02:41',NULL,'1','Create New Customer','1'),
('103','محامي مصطفى','','07504617615','','حديدوخشب','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','1','2023-04-03 13:09:09','2023-04-03 13:09:09','2023-04-08 02:26:51','1','Delete Customer','1'),
('104','A.T مروان كلار','','07702237910','','كلار','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-04-05 14:38:01','2023-04-05 14:38:01',NULL,'1','Create New Customer','1'),
('105','A.T ابو عمر غيث موصل','','07723322112','','موصل ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-04-08 10:37:52','2023-04-08 10:37:52',NULL,'1','Create New Customer','1'),
('106','ايليا اوز تورك','','00000','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','1','0','0','2023-04-19 11:28:16','2023-04-19 11:28:16',NULL,'1','Create New Customer','1'),
('107','A.T نيهاد ابو حسين بغداد','','07713650422','','بغداد','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-05-09 14:38:19','2023-05-09 14:38:19',NULL,'1','Create New Customer','1'),
('108','A.T قصر ملكي موصل محمد','','07508050090','','موصل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-05-15 15:36:19','2023-05-15 15:36:19',NULL,'1','Create New Customer','1'),
('109','A.T محمد قلادزي','','07501583890','','قلادزي','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-05-18 15:22:04','2023-05-18 15:22:04',NULL,'1','Create New Customer','1'),
('110','A.T صديق ليث','','000000000000','','بغداد','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-07-05 16:27:12','2023-07-05 16:27:12',NULL,'1','Create New Customer','1'),
('111','A.T هندرين كوران','','00000000','','كوران','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-07-11 10:41:41','2023-07-11 10:41:41',NULL,'1','Update Customer','1'),
('112','A.T مصطفي سيدار خالص ','','07812184325','','خالص ','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-07-22 14:53:43','2023-07-22 14:53:43',NULL,'1','Create New Customer','1'),
('113','A.T د خالد تكريت','','07702007972','','تكريت','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-08-20 12:43:00','2023-08-20 12:43:00',NULL,'1','Create New Customer','1'),
('114','A.T عمر لةنكة','','07519531464','','لةنكة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-09-13 16:23:37','2023-09-13 16:23:37',NULL,'1','Create New Customer','1'),
('115','A.T شالاو سليمانى','','07702258183','','سليماني','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-10-23 09:49:25','2023-10-23 09:49:25',NULL,'1','Create New Customer','1'),
('116','A.T رامين قةلادزى','','07502056863','','قةلادزى','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-11-13 12:19:03','2023-11-13 12:19:03',NULL,'1','Create New Customer','1'),
('117','A.T بران','','07704474535','','اربيل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-12-07 09:30:20','2023-12-07 09:30:20',NULL,'1','Create New Customer','1'),
('118','A.T لؤي الكبيسي فلوجة','','07809387750','','فلوجة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2023-12-28 09:24:04','2023-12-28 09:24:04',NULL,'1','Update Customer','1'),
('119','A.T كاروان هةلةبجةى شةهيد','','07501245453','','هةلةبجة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-01-09 10:53:30','2024-01-09 10:53:30',NULL,'1','Update Customer','1'),
('120','A.T مصطفى اخو ايهاب سامراء','','07703724566','','سامراء','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-01-11 12:43:28','2024-01-11 12:43:28',NULL,'1','Update Customer','1'),
('121','A.T شاهێز سلێمانى','','07501785254','','سليمانى','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-01-23 14:30:14','2024-01-23 14:30:14',NULL,'1','Update Customer','1'),
('122','A.T هيزة','','07504104191','','حديد و خشب','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-02-08 10:40:11','2024-02-08 10:40:11',NULL,'1','Update Customer','1'),
('123','A.T ايمن حلة','','00000000','','حلة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-02-22 09:43:02','2024-02-22 09:43:02',NULL,'1','Create New Customer','1'),
('124','A.T مرتضى حلة','','07850210672','','حلة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-03-03 11:52:15','2024-03-03 11:52:15',NULL,'1','Create New Customer','1'),
('125','هوشمند سةنكةسةر','','07508510122','','قلادزي / سنكسر','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-05-07 11:34:57','2024-05-07 11:34:57',NULL,'1','Create New Customer','1'),
('126','فراس انبار','','07815991244','','اربيل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-06-06 16:24:00','2024-06-06 16:24:00',NULL,'1','Create New Customer','1'),
('127','هيوا سايق','','07503032210','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','1','2024-06-10 14:42:38','2024-06-10 14:42:38','2024-06-11 12:04:39','1','Delete Customer','1'),
('128','موون قمر','','000000000','','اربيل + موصل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-07-11 09:48:21','2024-07-11 09:48:21',NULL,'1','Update Customer','1'),
('129','سفيان سكاي تاور - عدنان','','07511612004','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-08-04 15:45:19','2024-08-04 15:45:19',NULL,'1','Update Customer','1'),
('130','شوان مدينة','','07504305449','','البان','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-08-04 15:57:36','2024-08-04 15:57:36',NULL,'1','Create New Customer','1'),
('131','ابراهيم سامراء','','07727721204','','سامراء','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-08-06 15:43:45','2024-08-06 15:43:45',NULL,'1','Create New Customer','1'),
('132','شوان نيولاند','','07514944094','','دارةتوو','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-08-07 17:03:08','2024-08-07 17:03:08',NULL,'1','Create New Customer','1'),
('133','ستائر زيرةك','','07501303979','','بنصلاوة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-08-07 17:04:56','2024-08-07 17:04:56',NULL,'1','Create New Customer','1'),
('134','اسماعيل رةوشت','','07504603115','','البان','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-09-12 13:44:15','2024-09-12 13:44:15',NULL,'1','Create New Customer','1'),
('135','بةلين دةنيز','','07508890159','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-10-31 16:12:35','2024-10-31 16:12:35',NULL,'1','Create New Customer','1'),
('136','اسماعيل خوشناو','','07504952728','','','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-11-06 11:30:39','2024-11-06 11:30:39',NULL,'1','Create New Customer','1'),
('137','انيا بغداد DIAMOND','','0707220650','','بغداد','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-11-09 12:48:03','2024-11-09 12:48:03',NULL,'1','Update Customer','1'),
('138','بشتيوان شقلاوة','','07504040704','','شقلاوة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2024-11-19 13:11:42','2024-11-19 13:11:42',NULL,'1','Create New Customer','1'),
('139','اركان قوشتةبة','','0000000000','','قوشتةبة','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-01-11 10:34:32','2025-01-11 10:34:32',NULL,'1','Create New Customer','1'),
('140','عمر اكري فرع دهوك','','07504384454','','دهوك','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-02-08 10:50:32','2025-02-08 10:50:32',NULL,'1','Create New Customer','1'),
('141','ملكة موصل','','07701887242','','موصل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-05-05 12:56:55','2025-05-05 12:56:55',NULL,'1','Create New Customer','1'),
('142','دلف سامراء','','07727721204','','سامراء','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-05-20 13:39:03','2025-05-20 13:39:03',NULL,'1','Create New Customer','1'),
('143','امجد موصل','','07700338958','','موصل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-05-28 16:05:23','2025-05-28 16:05:23',NULL,'1','Create New Customer','1'),
('144','محمد دارةتوو','','07504753912','','دارةتوو','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-07-05 14:09:20','2025-07-05 14:09:20',NULL,'1','Create New Customer','1'),
('145','البيت الذهبي','','07510261834','','الموصل','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-07-26 16:02:31','2025-07-26 16:02:31',NULL,'1','Create New Customer','1'),
('146','مصطفى علوش','','07874742007','','البغداد','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-08-02 13:14:12','2025-08-02 13:14:12',NULL,'1','Create New Customer','1'),
('147','سامان هرير','','07504658463','','هرير','','0',NULL,NULL,NULL,NULL,'0',NULL,'0','0','0','0','2025-09-06 13:44:28','2025-09-06 13:44:28',NULL,'1','Create New Customer','1'); 


DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses` (
  `expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expenses_name` varchar(150) DEFAULT NULL,
  `expenses_quantity` decimal(10,2) NOT NULL DEFAULT 0.00,
  `expenses_unit_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `expenses_date` date DEFAULT NULL,
  `expenses_usd_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `expenses_currency` int(1) DEFAULT 1 COMMENT '0:IDQ; 1:USD',
  `expenses_note` text DEFAULT NULL,
  `expenses_group_id_fk` int(11) DEFAULT 0,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`expenses_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `expenses_group`;
CREATE TABLE `expenses_group` (
  `expenses_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(150) DEFAULT NULL,
  `group_description` varchar(250) DEFAULT NULL,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`expenses_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `invoice`;
CREATE TABLE `invoice` (
  `invoice_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(100) DEFAULT NULL,
  `invoice_date` datetime DEFAULT NULL,
  `invoice_status` int(1) NOT NULL DEFAULT 0 COMMENT '0:not paid, 1:partially paid, 2:paid, 3:returned; 4:offer',
  `invoice_usd_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `invoice_currency` int(1) NOT NULL DEFAULT 1 COMMENT '0: Iraqi Dinar; 1: USD Dollar',
  `invoice_total_price_actual` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'invoice actual price calculated from unit price * quantity',
  `invoice_total_net_balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `invoice_note` text DEFAULT NULL,
  `invoice_type` int(1) DEFAULT NULL COMMENT '0:for_Raw_Materials_(roll_wood_tools_etc); 1:for_Production_materials(curtain_wood_royal_etc); about production_section we may sell wood_slide with curtain or royal slide so we need it and these sold products will consider as Production section not as Raw Materials',
  `is_single` int(1) NOT NULL DEFAULT 0 COMMENT '0:plural; 1:singular',
  `pay_terms` int(11) DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_cost` decimal(10,2) DEFAULT 0.00,
  `offer_number` varchar(100) DEFAULT NULL,
  `request_for_quta_number` varchar(100) DEFAULT NULL COMMENT 'RFQ No.',
  `delivery_time` varchar(20) DEFAULT NULL,
  `date_of_offer` date DEFAULT NULL,
  `po_number` varchar(50) DEFAULT NULL,
  `term_and_conditions` text DEFAULT NULL,
  `customer_id_fk` int(11) NOT NULL DEFAULT 0,
  `is_deleted` int(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  `deleted_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_action` varchar(100) DEFAULT NULL,
  `last_action_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`invoice_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6612 DEFAULT CHARSET=utf8;

INSERT INTO `invoice` VALUES ('1','VR-22-1','2022-01-10 00:00:00','0','1250.00','1','3677.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2022-01-10 13:34:19','2022-01-10 13:34:19',NULL,'1','Add New Invoice','1'),
('2','VR-22-2','2022-01-10 00:00:00','0','1250.00','1','178.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-10 14:19:05','2022-01-15 12:27:34',NULL,'1','Update Invoice','1'),
('3','VR-22-3','2022-01-12 00:00:00','0','1250.00','1','6057.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-01-12 10:10:35','2022-01-12 10:16:02',NULL,'1','Update Invoice','1'),
('4','VR-22-4','2022-01-13 00:00:00','0','1250.00','1','164.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-13 14:35:27','2022-01-13 14:35:27',NULL,'1','Add New Invoice','1'),
('5','VR-22-5','2022-01-15 00:00:00','0','1250.00','1','205.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-01-15 10:06:55','2022-01-15 10:06:55',NULL,'1','Add New Invoice','1'),
('6','VR-22-6','2022-01-15 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-15 12:31:09','2022-01-15 12:31:09',NULL,'1','Add New Invoice','1'),
('7','VR-22-7','2022-01-16 00:00:00','0','1250.00','1','213.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-16 09:50:45','2022-01-16 10:23:49',NULL,'1','Update Invoice','1'),
('8','VR-22-8','2022-01-16 00:00:00','0','1250.00','1','119.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-01-16 09:51:46','2022-01-16 09:51:46',NULL,'1','Add New Invoice','1'),
('9','VR-22-9','2022-01-16 00:00:00','0','1250.00','1','597.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-16 14:05:30','2022-01-16 14:05:30',NULL,'1','Add New Invoice','1'),
('10','VR-22-10','2022-01-17 00:00:00','0','1250.00','1','2005.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-01-17 16:32:19','2022-01-17 16:32:19',NULL,'1','Add New Invoice','1'),
('11','VR-22-11','2022-01-18 00:00:00','0','1250.00','1','148.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-18 15:56:57','2022-01-18 15:56:57',NULL,'1','Add New Invoice','1'),
('12','VR-22-12','2022-01-18 00:00:00','0','1250.00','1','403.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-18 16:19:03','2022-01-19 04:29:59',NULL,'1','Update Invoice','1'),
('13','VR-22-13','2022-01-19 00:00:00','0','1250.00','1','382.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-19 16:51:41','2022-01-19 16:51:41',NULL,'1','Add New Invoice','1'),
('14','VR-22-14','2022-01-20 00:00:00','0','1250.00','1','3544.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-20 13:40:00','2022-01-22 12:51:09',NULL,'1','Update Invoice','1'),
('15','VR-22-15','2022-01-20 00:00:00','0','1250.00','1','1653.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-20 13:47:55','2022-01-22 12:46:13',NULL,'1','Update Invoice','1'),
('16','VR-22-16','2022-01-20 00:00:00','0','1250.00','1','12911.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-01-20 14:44:56','2022-01-20 02:56:37',NULL,'1','Update Invoice','1'),
('17','VR-22-17','2022-01-20 00:00:00','0','1250.00','1','435.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-20 15:35:16','2022-01-20 15:35:16',NULL,'1','Add New Invoice','1'),
('18','VR-22-18','2022-01-22 00:00:00','0','1250.00','1','15577.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-01-22 14:52:40','2022-01-22 14:52:40',NULL,'1','Add New Invoice','1'),
('19','VR-22-19','2022-01-22 00:00:00','0','1250.00','1','537.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-01-22 16:29:19','2022-01-22 04:30:48',NULL,'1','Update Invoice','1'),
('20','VR-22-20','2022-01-23 00:00:00','0','1250.00','1','398.49','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-23 14:06:11','2022-01-23 14:06:11',NULL,'1','Add New Invoice','1'),
('21','VR-22-21','2022-01-23 00:00:00','0','1250.00','1','677.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-01-23 16:11:24','2022-01-27 02:48:00',NULL,'1','Update Invoice','1'),
('22','VR-22-22','2022-01-24 00:00:00','0','1250.00','1','374.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-24 12:32:11','2022-01-26 12:28:33',NULL,'1','Update Invoice','1'),
('23','VR-22-23','2022-01-24 00:00:00','0','1250.00','1','43.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-01-24 16:22:42','2022-01-24 16:22:42',NULL,'1','Add New Invoice','1'),
('24','VR-22-24','2022-01-24 00:00:00','0','1250.00','1','402.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-01-24 16:30:43','2022-01-24 16:30:43',NULL,'1','Add New Invoice','1'),
('25','VR-22-25','2022-01-24 00:00:00','0','1250.00','1','3146.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-01-24 16:40:30','2022-01-24 16:40:30',NULL,'1','Add New Invoice','1'),
('26','VR-22-26','2022-01-26 00:00:00','0','1250.00','1','900.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-26 12:26:27','2022-01-26 12:26:27',NULL,'1','Add New Invoice','1'),
('27','VR-22-27','2022-01-26 00:00:00','0','1250.00','1','197.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-26 12:40:27','2022-01-26 12:40:27',NULL,'1','Add New Invoice','1'),
('28','VR-22-28','2022-01-26 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-01-26 14:46:08','2022-01-26 14:46:08',NULL,'1','Add New Invoice','1'),
('29','VR-22-29','2022-01-26 00:00:00','0','1250.00','1','53.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-01-26 14:51:51','2022-01-27 12:01:49',NULL,'1','Update Invoice','1'),
('30','VR-22-30','2022-01-27 00:00:00','0','1250.00','1','1084.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-27 12:23:38','2022-01-27 02:18:39',NULL,'1','Update Invoice','1'),
('31','VR-22-31','2022-01-27 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-01-27 12:39:30','2022-01-27 12:39:30',NULL,'1','Add New Invoice','1'),
('32','VR-22-32','2022-01-27 00:00:00','0','1250.00','1','15.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-01-27 12:45:38','2022-01-27 02:47:34',NULL,'1','Update Invoice','1'),
('33','VR-22-33','2022-01-29 00:00:00','0','1250.00','1','218.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-01-29 08:56:13','2022-01-29 08:56:13',NULL,'1','Add New Invoice','1'),
('34','VR-22-34','2022-01-29 00:00:00','0','1250.00','1','1097.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-29 11:08:23','2022-01-29 11:08:23',NULL,'1','Add New Invoice','1'),
('35','VR-22-35','2022-01-29 00:00:00','0','1250.00','1','300.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-01-29 13:41:48','2022-01-29 13:41:48',NULL,'1','Add New Invoice','1'),
('36','VR-22-36','2022-01-30 00:00:00','0','1250.00','1','176.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-01-30 13:21:43','2022-01-30 13:21:43',NULL,'1','Add New Invoice','1'),
('37','VR-22-37','2022-01-30 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-01-30 13:24:52','2022-01-30 13:24:52',NULL,'1','Add New Invoice','1'),
('38','VR-22-38','2022-01-30 00:00:00','0','1250.00','1','206.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-01-30 13:49:36','2022-01-30 13:49:36',NULL,'1','Add New Invoice','1'),
('39','VR-22-39','2022-01-30 00:00:00','0','1250.00','1','202.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-01-30 13:57:49','2022-01-30 13:57:49',NULL,'1','Add New Invoice','1'),
('40','VR-22-40','2022-01-30 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-01-30 13:59:54','2022-01-30 13:59:54',NULL,'1','Add New Invoice','1'),
('41','VR-22-41','2022-01-30 00:00:00','0','1250.00','1','557.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-01-30 14:22:31','2022-01-31 02:11:25',NULL,'1','Update Invoice','1'),
('42','VR-22-42','2022-01-30 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-01-30 16:14:46','2022-01-30 16:14:46',NULL,'1','Add New Invoice','1'),
('43','VR-22-43','2022-01-30 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-01-30 16:18:30','2022-01-30 16:18:30',NULL,'1','Add New Invoice','1'),
('44','VR-22-44','2022-01-31 00:00:00','0','1250.00','1','778.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-31 12:36:38','2022-01-31 12:36:38',NULL,'1','Add New Invoice','1'),
('45','VR-22-45','2022-01-31 00:00:00','0','1250.00','1','174.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-01-31 15:36:25','2022-01-31 15:36:25',NULL,'1','Add New Invoice','1'),
('46','VR-22-46','2022-02-01 00:00:00','0','1250.00','1','162.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-02-01 11:53:29','2022-02-01 11:53:29',NULL,'1','Add New Invoice','1'),
('47','VR-22-47','2022-02-01 00:00:00','0','1250.00','1','274.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-01 12:06:31','2022-02-01 12:06:31',NULL,'1','Add New Invoice','1'),
('48','VR-22-48','2022-02-01 00:00:00','0','1250.00','1','163.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-01 13:51:28','2022-02-01 13:51:28',NULL,'1','Add New Invoice','1'),
('49','VR-22-49','2022-02-02 00:00:00','0','1250.00','1','612.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-02-02 11:14:32','2022-03-16 01:45:01',NULL,'1','Update Invoice','1'),
('50','VR-22-50','2022-02-02 00:00:00','0','1250.00','1','366.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-02 14:17:07','2022-02-02 14:17:07',NULL,'1','Add New Invoice','1'),
('51','VR-22-51','2022-02-02 00:00:00','0','1250.00','1','94.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-02 15:53:56','2022-02-02 15:53:56',NULL,'1','Add New Invoice','1'),
('52','VR-22-52','2022-02-03 00:00:00','0','1250.00','1','137.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-02-03 13:49:09','2022-02-24 09:22:34',NULL,'1','Update Invoice','1'),
('53','VR-22-53','2022-02-03 00:00:00','0','1250.00','1','7.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-02-03 14:02:58','2022-02-03 14:02:58',NULL,'1','Add New Invoice','1'),
('54','VR-22-54','2022-02-03 00:00:00','0','1250.00','1','17.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-03 14:06:38','2022-02-03 14:06:38',NULL,'1','Add New Invoice','1'),
('55','VR-22-55','2022-02-03 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-02-03 14:09:28','2022-02-03 14:09:28',NULL,'1','Add New Invoice','1'),
('56','VR-22-56','2022-02-03 00:00:00','0','1250.00','1','328.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-03 14:36:07','2022-02-03 14:36:07',NULL,'1','Add New Invoice','1'),
('57','VR-22-57','2022-02-05 00:00:00','0','1250.00','1','144.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-05 16:05:07','2022-02-05 16:05:07',NULL,'1','Add New Invoice','1'),
('58','VR-22-58','2022-02-05 00:00:00','0','1250.00','1','110.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-05 16:37:58','2022-02-05 05:13:08',NULL,'1','Update Invoice','1'),
('59','VR-22-59','2022-02-05 00:00:00','0','1250.00','1','326.41','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-05 16:41:54','2022-02-05 04:42:12',NULL,'1','Update Invoice','1'),
('60','VR-22-60','2022-02-06 00:00:00','0','1250.00','1','191.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-06 12:21:16','2022-02-06 12:21:16',NULL,'1','Add New Invoice','1'),
('61','VR-22-61','2022-02-06 00:00:00','0','1250.00','1','91.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-02-06 12:24:42','2022-02-06 12:24:42',NULL,'1','Add New Invoice','1'),
('62','VR-22-62','2022-02-06 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-02-06 12:29:44','2022-02-06 12:29:44',NULL,'1','Add New Invoice','1'),
('63','VR-22-63','2022-02-06 00:00:00','0','1250.00','1','149.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-02-06 12:36:19','2022-02-06 12:43:06',NULL,'1','Update Invoice','1'),
('64','VR-22-64','2022-02-06 00:00:00','0','1250.00','1','73.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-06 16:36:19','2022-02-07 04:15:51',NULL,'1','Update Invoice','1'),
('65','VR-22-65','2022-02-06 00:00:00','0','1250.00','1','641.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-06 17:21:49','2022-02-06 17:21:49',NULL,'1','Add New Invoice','1'),
('66','VR-22-66','2022-02-07 00:00:00','0','1250.00','1','214.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-02-07 15:59:09','2022-02-07 15:59:09',NULL,'1','Add New Invoice','1'),
('67','VR-22-67','2022-02-07 00:00:00','0','1250.00','1','602.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-07 16:10:46','2022-02-07 04:12:22',NULL,'1','Update Invoice','1'),
('68','VR-22-68','2022-02-07 00:00:00','0','1250.00','1','209.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-07 16:28:08','2022-02-07 16:28:08',NULL,'1','Add New Invoice','1'),
('69','VR-22-69','2022-02-07 00:00:00','0','1250.00','1','145.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-02-07 16:39:46','2022-02-07 16:39:46',NULL,'1','Add New Invoice','1'),
('70','VR-22-70','2022-02-08 00:00:00','0','1250.00','1','283.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-08 10:53:55','2022-02-08 10:53:55',NULL,'1','Add New Invoice','1'),
('71','VR-22-71','2022-02-08 00:00:00','0','1250.00','1','720.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-02-08 10:55:39','2022-02-08 10:55:39',NULL,'1','Add New Invoice','1'),
('72','VR-22-72','2022-02-08 00:00:00','0','1250.00','1','600.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-08 11:40:41','2022-02-08 11:40:41',NULL,'1','Add New Invoice','1'),
('73','VR-22-73','2022-02-08 00:00:00','0','1250.00','1','256.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-02-08 14:44:15','2022-02-08 14:44:15',NULL,'1','Add New Invoice','1'),
('74','VR-22-74','2022-02-08 00:00:00','0','1250.00','1','392.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-08 14:53:03','2022-02-08 14:53:03',NULL,'1','Add New Invoice','1'),
('75','VR-22-75','2022-02-08 00:00:00','0','1250.00','1','122.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-08 15:03:08','2022-02-08 15:03:08',NULL,'1','Add New Invoice','1'),
('76','VR-22-76','2022-02-08 00:00:00','0','1250.00','1','250.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-08 15:10:58','2022-02-08 15:10:58',NULL,'1','Add New Invoice','1'),
('77','VR-22-77','2022-02-08 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-08 15:20:44','2022-02-08 15:20:44',NULL,'1','Add New Invoice','1'),
('78','VR-22-78','2022-02-08 00:00:00','0','1250.00','1','2697.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-02-08 15:29:30','2022-02-08 15:29:30',NULL,'1','Add New Invoice','1'),
('79','VR-22-79','2022-02-09 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-09 11:41:44','2022-02-09 11:41:44',NULL,'1','Add New Invoice','1'),
('82','VR-22-80','2022-02-09 00:00:00','0','1250.00','1','9.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-09 15:25:44','2022-02-09 15:25:44',NULL,'1','Add New Invoice','1'),
('83','VR-22-83','2022-02-09 00:00:00','0','1250.00','1','5.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-09 15:28:44','2022-02-09 15:28:44',NULL,'1','Add New Invoice','1'),
('84','VR-22-84','2022-02-09 00:00:00','0','1250.00','1','44.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-02-09 15:33:26','2022-02-09 15:33:26',NULL,'1','Add New Invoice','1'),
('85','VR-22-85','2022-02-12 00:00:00','0','1250.00','1','142.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-12 10:20:47','2022-02-12 10:20:47',NULL,'1','Add New Invoice','1'),
('86','VR-22-86','2022-02-12 00:00:00','0','1250.00','1','214.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2022-02-12 11:42:42','2022-02-12 11:42:42',NULL,'1','Add New Invoice','1'),
('87','VR-22-87','2022-02-12 00:00:00','0','1250.00','1','446.41','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-02-12 11:59:06','2022-02-12 11:59:06',NULL,'1','Add New Invoice','1'),
('88','VR-22-88','2022-02-12 00:00:00','0','1250.00','1','195.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-12 12:09:14','2022-02-12 12:09:14',NULL,'1','Add New Invoice','1'),
('89','VR-22-89','2022-02-12 00:00:00','0','1250.00','1','378.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-12 12:13:23','2022-02-12 12:13:23',NULL,'1','Add New Invoice','1'),
('90','VR-22-90','2022-02-12 00:00:00','0','1250.00','1','299.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-12 14:52:20','2022-02-12 14:52:20',NULL,'1','Add New Invoice','1'),
('91','VR-22-91','2022-02-12 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-02-12 16:56:25','2022-02-12 16:56:25',NULL,'1','Add New Invoice','1'),
('92','VR-22-92','2022-02-13 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-02-13 10:00:16','2022-02-13 10:00:16',NULL,'1','Add New Invoice','1'),
('93','VR-22-93','2022-02-13 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-13 10:05:59','2022-02-13 10:05:59',NULL,'1','Add New Invoice','1'),
('94','VR-22-94','2022-02-13 00:00:00','0','1250.00','1','86.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-02-13 10:39:31','2022-02-13 10:39:31',NULL,'1','Add New Invoice','1'),
('95','VR-22-95','2022-02-13 00:00:00','0','1250.00','1','246.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-13 11:11:56','2022-02-13 11:11:56',NULL,'1','Add New Invoice','1'),
('96','VR-22-96','2022-02-13 00:00:00','0','1250.00','1','115.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-02-13 13:55:27','2022-02-13 13:55:27',NULL,'1','Add New Invoice','1'),
('97','VR-22-97','2022-02-13 00:00:00','0','1250.00','1','53.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-13 14:05:55','2022-02-13 14:05:55',NULL,'1','Add New Invoice','1'),
('98','VR-22-98','2022-02-13 00:00:00','0','1250.00','1','321.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-02-13 14:18:17','2022-02-13 14:18:17',NULL,'1','Add New Invoice','1'),
('99','VR-22-99','2022-02-14 00:00:00','0','1250.00','1','652.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-14 12:24:08','2022-02-23 08:54:39',NULL,'1','Update Invoice','1'),
('102','VR-22-100','2022-02-14 00:00:00','0','1250.00','1','121.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-14 12:33:20','2022-02-16 02:42:14',NULL,'1','Update Invoice','1'),
('103','VR-22-103','2022-02-14 00:00:00','0','1250.00','1','136.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-14 14:04:52','2022-02-14 14:04:52',NULL,'1','Add New Invoice','1'),
('104','VR-22-104','2022-02-15 00:00:00','0','1250.00','1','84.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-02-15 10:04:23','2022-02-15 10:04:23',NULL,'1','Add New Invoice','1'),
('105','VR-22-105','2022-02-15 00:00:00','0','1250.00','1','194.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-15 10:29:35','2022-02-15 10:38:30',NULL,'1','Update Invoice','1'),
('106','VR-22-106','2022-02-15 00:00:00','0','1250.00','1','122.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-15 11:03:58','2022-02-15 11:03:58',NULL,'1','Add New Invoice','1'),
('107','VR-22-107','2022-02-15 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-02-15 11:08:35','2022-02-15 11:08:35',NULL,'1','Add New Invoice','1'),
('108','VR-22-108','2022-02-15 00:00:00','0','1250.00','1','861.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-02-15 11:35:53','2022-02-15 11:35:53',NULL,'1','Add New Invoice','1'),
('109','VR-22-109','2022-02-15 00:00:00','0','1250.00','1','210.00','0.00','بلاك اوت ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-15 16:06:10','2022-02-21 09:41:01',NULL,'1','Update Invoice','1'),
('110','VR-22-110','2022-02-15 00:00:00','0','1250.00','1','158.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-15 16:36:48','2022-02-15 16:36:48',NULL,'1','Add New Invoice','1'),
('111','VR-22-111','2022-02-16 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-16 10:31:39','2022-02-16 10:31:39',NULL,'1','Add New Invoice','1'),
('112','VR-22-112','2022-02-16 00:00:00','0','1250.00','1','439.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-16 10:37:10','2022-02-16 10:37:10',NULL,'1','Add New Invoice','1'),
('113','VR-22-113','2022-02-16 00:00:00','0','1250.00','1','40.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-02-16 10:45:15','2022-02-16 10:45:15',NULL,'1','Add New Invoice','1'),
('118','VR-22-114','2022-02-16 00:00:00','0','1250.00','1','5934.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-02-16 13:59:23','2022-02-16 13:59:23',NULL,'1','Add New Invoice','1'),
('121','VR-22-119','2022-02-16 00:00:00','0','1250.00','1','13049.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-02-16 14:42:13','2022-02-16 14:42:13',NULL,'1','Add New Invoice','1'),
('122','VR-22-122','2022-02-16 00:00:00','0','1250.00','1','320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-02-16 15:28:12','2022-02-16 15:28:12',NULL,'1','Add New Invoice','1'),
('123','VR-22-123','2022-02-16 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-02-16 15:30:14','2022-02-16 15:30:14',NULL,'1','Add New Invoice','1'),
('124','VR-22-124','2022-02-16 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-02-16 15:31:40','2022-02-16 15:31:40',NULL,'1','Add New Invoice','1'),
('125','VR-22-125','2022-02-16 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-02-16 15:32:48','2022-02-16 15:32:48',NULL,'1','Add New Invoice','1'),
('126','VR-22-126','2022-02-16 00:00:00','0','1250.00','1','74.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-16 15:34:57','2022-02-16 15:34:57',NULL,'1','Add New Invoice','1'),
('127','VR-22-127','2022-02-16 00:00:00','0','1250.00','1','88.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-16 16:23:25','2022-02-16 16:23:25',NULL,'1','Add New Invoice','1'),
('128','VR-22-128','2022-02-17 00:00:00','0','1250.00','1','810.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-17 10:04:21','2022-02-17 10:04:21',NULL,'1','Add New Invoice','1'),
('129','VR-22-129','2022-02-17 00:00:00','0','1250.00','1','333.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-02-17 10:26:51','2022-02-17 10:26:51',NULL,'1','Add New Invoice','1'),
('130','VR-22-130','2022-02-17 00:00:00','0','1250.00','1','674.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-17 15:05:07','2022-02-17 15:05:07',NULL,'1','Add New Invoice','1'),
('131','VR-22-131','2022-02-19 00:00:00','0','1250.00','1','875.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-02-19 12:40:28','2022-02-19 12:40:28',NULL,'1','Add New Invoice','1'),
('132','VR-22-132','2022-02-19 00:00:00','0','1250.00','1','112.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-19 14:20:25','2022-02-19 14:20:25',NULL,'1','Add New Invoice','1'),
('133','VR-22-133','2022-02-20 00:00:00','0','1250.00','1','15.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-20 12:10:29','2022-02-20 12:10:29',NULL,'1','Add New Invoice','1'),
('134','VR-22-134','2022-02-20 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-02-20 12:17:12','2022-02-20 12:17:12',NULL,'1','Add New Invoice','1'),
('135','VR-22-135','2022-02-20 00:00:00','0','1250.00','1','126.91','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-20 13:15:16','2022-02-20 13:15:16',NULL,'1','Add New Invoice','1'),
('136','VR-22-136','2022-02-20 00:00:00','0','1250.00','1','216.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-20 14:24:53','2022-02-20 14:24:53',NULL,'1','Add New Invoice','1'),
('137','VR-22-137','2022-02-20 00:00:00','0','1250.00','1','787.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-02-20 14:38:21','2022-02-20 14:38:21',NULL,'1','Add New Invoice','1'),
('138','VR-22-138','2022-02-20 00:00:00','0','1250.00','1','197.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-20 14:44:12','2022-02-20 14:44:12',NULL,'1','Add New Invoice','1'),
('139','VR-22-139','2022-02-20 00:00:00','0','1250.00','1','458.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-02-20 17:21:31','2022-02-20 17:21:31',NULL,'1','Add New Invoice','1'),
('140','VR-22-140','2022-02-20 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-02-20 17:27:28','2022-02-20 17:27:28',NULL,'1','Add New Invoice','1'),
('141','VR-22-141','2022-02-21 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-21 09:43:14','2022-02-21 09:43:14',NULL,'1','Add New Invoice','1'),
('142','VR-22-142','2022-02-21 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-02-21 09:52:46','2022-02-21 09:52:46',NULL,'1','Add New Invoice','1'),
('143','VR-22-143','2022-02-21 00:00:00','0','1250.00','1','364.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-21 12:40:50','2022-02-22 10:41:41',NULL,'1','Update Invoice','1'),
('144','VR-22-144','2022-02-21 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-02-21 16:47:24','2022-02-21 16:47:24',NULL,'1','Add New Invoice','1'),
('145','VR-22-145','2022-02-22 00:00:00','0','1250.00','1','76.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-02-22 11:03:16','2022-02-22 11:03:16',NULL,'1','Add New Invoice','1'),
('146','VR-22-146','2022-02-22 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-02-22 11:12:04','2022-02-22 11:12:04',NULL,'1','Add New Invoice','1'),
('147','VR-22-147','2022-02-22 00:00:00','0','1250.00','1','54.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-22 11:28:03','2022-02-22 11:28:03',NULL,'1','Add New Invoice','1'),
('148','VR-22-148','2022-02-22 00:00:00','0','1250.00','1','435.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-22 14:26:01','2022-02-22 14:26:01',NULL,'1','Add New Invoice','1'),
('149','VR-22-149','2022-02-22 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-22 14:31:15','2022-02-22 14:31:15',NULL,'1','Add New Invoice','1'),
('150','VR-22-150','2022-02-22 00:00:00','0','1250.00','1','106.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-22 15:30:52','2022-02-22 15:30:52',NULL,'1','Add New Invoice','1'),
('151','VR-22-151','2022-02-23 00:00:00','0','1250.00','1','198.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-23 09:37:19','2022-02-23 09:37:19',NULL,'1','Add New Invoice','1'),
('152','VR-22-152','2022-02-23 00:00:00','0','1250.00','1','425.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-23 10:35:00','2022-02-27 01:25:20',NULL,'1','Update Invoice','1'),
('153','VR-22-153','2022-02-23 00:00:00','0','1250.00','1','4438.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-23 13:33:20','2022-02-23 13:33:20',NULL,'1','Add New Invoice','1'),
('154','VR-22-154','2022-02-23 00:00:00','0','1250.00','1','88.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-02-23 13:44:00','2022-02-23 13:44:00',NULL,'1','Add New Invoice','1'),
('155','VR-22-155','2022-02-23 00:00:00','0','1250.00','1','342.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-23 14:02:45','2022-02-23 14:02:45',NULL,'1','Add New Invoice','1'),
('156','VR-22-156','2022-02-23 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-23 14:37:09','2022-02-23 14:37:09',NULL,'1','Add New Invoice','1'),
('157','VR-22-157','2022-02-24 00:00:00','0','1250.00','1','55.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-02-24 09:23:24','2022-02-24 09:23:24',NULL,'1','Add New Invoice','1'),
('158','VR-22-158','2022-02-24 00:00:00','0','1250.00','1','824.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-24 09:48:06','2022-02-24 11:35:54',NULL,'1','Update Invoice','1'),
('159','VR-22-159','2022-02-24 00:00:00','0','1250.00','1','59.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','1','2022-02-24 10:03:02','2022-02-24 10:03:02','2022-02-24 10:04:08','1','Delete Invoice','1'),
('160','VR-22-160','2022-02-24 00:00:00','0','1250.00','1','207.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-24 11:49:25','2022-02-24 11:49:25',NULL,'1','Add New Invoice','1'),
('161','VR-22-161','2022-02-26 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-02-26 10:22:26','2022-02-26 10:22:26',NULL,'1','Add New Invoice','1'),
('162','VR-22-162','2022-02-26 00:00:00','0','1250.00','1','74.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-02-26 10:24:04','2022-02-26 10:24:04',NULL,'1','Add New Invoice','1'),
('163','VR-22-163','2022-02-26 00:00:00','0','1250.00','1','14.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-26 14:47:39','2022-02-26 14:47:39',NULL,'1','Add New Invoice','1'),
('164','VR-22-164','2022-02-26 00:00:00','0','1250.00','1','110.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-02-26 18:00:43','2022-02-26 18:00:43',NULL,'1','Add New Invoice','1'),
('165','VR-22-165','2022-02-26 00:00:00','0','1250.00','1','342.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-26 18:01:59','2022-02-26 18:01:59',NULL,'1','Add New Invoice','1'),
('166','VR-22-166','2022-02-27 00:00:00','0','1250.00','1','428.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-02-27 11:47:12','2022-02-27 11:47:12',NULL,'1','Add New Invoice','1'),
('167','VR-22-167','2022-02-27 00:00:00','0','1250.00','1','720.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-02-27 13:27:28','2022-02-27 13:27:28',NULL,'1','Add New Invoice','1'),
('168','VR-22-168','2022-02-27 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-02-27 13:32:20','2022-02-27 13:32:20',NULL,'1','Add New Invoice','1'),
('169','VR-22-169','2022-02-27 00:00:00','0','1250.00','1','532.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-02-27 13:36:50','2022-02-27 13:36:50',NULL,'1','Add New Invoice','1'),
('170','VR-22-170','2022-02-27 00:00:00','0','1250.00','1','1485.69','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-27 13:44:35','2022-02-27 13:44:35',NULL,'1','Add New Invoice','1'),
('171','VR-22-171','2022-02-27 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-02-27 13:52:32','2022-02-27 13:52:32',NULL,'1','Add New Invoice','1'),
('172','VR-22-172','2022-02-28 00:00:00','0','1250.00','1','300.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2022-02-28 08:59:02','2022-02-28 08:59:02','2022-03-01 02:48:59','1','Delete Invoice','1'),
('173','VR-22-173','2022-02-28 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-02-28 15:10:43','2022-02-28 15:10:43',NULL,'1','Add New Invoice','1'),
('174','VR-22-174','2022-02-28 00:00:00','0','1250.00','1','151.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-28 15:12:08','2022-02-28 15:12:08',NULL,'1','Add New Invoice','1'),
('175','VR-22-175','2022-02-28 00:00:00','0','1250.00','1','377.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-02-28 16:01:55','2022-02-28 16:01:55',NULL,'1','Add New Invoice','1'),
('176','VR-22-176','2022-03-01 00:00:00','0','1250.00','1','565.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-01 14:53:57','2022-03-01 14:53:57',NULL,'1','Add New Invoice','1'),
('177','VR-22-177','2022-03-01 00:00:00','0','1250.00','1','53.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-01 15:05:37','2022-03-01 15:05:37',NULL,'1','Add New Invoice','1'),
('178','VR-22-178','2022-03-01 00:00:00','0','1250.00','1','94.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-03-01 15:08:16','2022-03-01 15:08:16',NULL,'1','Add New Invoice','1'),
('179','VR-22-179','2022-03-01 00:00:00','0','1250.00','1','26.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-01 17:12:43','2022-03-01 17:12:43',NULL,'1','Add New Invoice','1'),
('180','VR-22-180','2022-03-01 00:00:00','0','1250.00','1','27.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-01 17:25:17','2022-03-01 17:25:17',NULL,'1','Add New Invoice','1'),
('181','VR-22-181','2022-03-02 00:00:00','0','1250.00','1','180.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-02 12:01:04','2022-03-02 12:01:04',NULL,'1','Add New Invoice','1'),
('182','VR-22-182','2022-03-03 00:00:00','0','1250.00','1','364.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-03 10:59:31','2022-03-03 10:59:31',NULL,'1','Add New Invoice','1'),
('183','VR-22-183','2022-03-03 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-03-03 11:07:40','2022-03-03 11:07:40',NULL,'1','Add New Invoice','1'),
('184','VR-22-184','2022-03-03 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-03 11:10:11','2022-03-03 11:10:11',NULL,'1','Add New Invoice','1'),
('185','VR-22-185','2022-03-03 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-03 15:23:07','2022-03-03 15:23:07',NULL,'1','Add New Invoice','1'),
('186','VR-22-186','2022-03-05 00:00:00','0','1250.00','1','665.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-05 09:25:18','2022-04-04 09:57:04',NULL,'1','Update Invoice','1'),
('187','VR-22-187','2022-03-05 00:00:00','0','1250.00','1','339.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-05 11:37:36','2022-03-05 11:37:36',NULL,'1','Add New Invoice','1'),
('188','VR-22-188','2022-03-05 00:00:00','0','1250.00','1','257.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-05 13:46:50','2022-03-05 13:46:50',NULL,'1','Add New Invoice','1'),
('189','VR-22-189','2022-03-05 00:00:00','0','1250.00','1','529.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-05 15:23:56','2022-03-05 03:27:50',NULL,'1','Update Invoice','1'),
('190','VR-22-190','2022-03-06 00:00:00','0','1250.00','1','201.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-06 10:33:30','2022-04-04 09:58:10',NULL,'1','Update Invoice','1'),
('191','INV-22-191','2022-03-06 00:00:00','0','1250.00','1','2706.86','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','24','0','2022-03-06 11:41:33','2022-03-06 11:44:59',NULL,'1','Update Invoice','1'),
('192','VR-22-192','2022-03-06 00:00:00','0','1250.00','1','2075.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-06 12:30:49','2022-03-06 12:30:49',NULL,'1','Add New Invoice','1'),
('193','VR-22-193','2022-03-06 00:00:00','0','1250.00','1','2702.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-03-06 13:04:23','2022-03-06 13:04:23',NULL,'1','Add New Invoice','1'),
('194','VR-22-194','2022-03-06 00:00:00','0','1250.00','1','170.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-03-06 13:15:05','2022-03-06 13:15:05',NULL,'1','Add New Invoice','1'),
('195','VR-22-195','2022-03-06 00:00:00','0','1250.00','1','202.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-03-06 13:21:15','2022-03-06 13:21:15',NULL,'1','Add New Invoice','1'),
('196','VR-22-196','2022-03-06 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-03-06 13:23:36','2022-03-06 13:23:36',NULL,'1','Add New Invoice','1'),
('197','VR-22-197','2022-03-06 00:00:00','0','1250.00','1','1464.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-06 13:39:04','2022-03-06 13:39:04',NULL,'1','Add New Invoice','1'),
('198','VR-22-198','2022-03-06 00:00:00','0','1250.00','1','103.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-03-06 13:42:23','2022-03-06 13:42:23',NULL,'1','Add New Invoice','1'),
('199','VR-22-199','2022-03-06 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-06 14:13:35','2022-03-06 14:13:35',NULL,'1','Add New Invoice','1'),
('200','VR-22-200','2022-03-06 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-06 15:19:57','2022-03-06 15:19:57',NULL,'1','Add New Invoice','1'),
('201','VR-22-201','2022-03-06 00:00:00','0','1250.00','1','41.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-06 15:23:25','2022-04-04 09:58:23',NULL,'1','Update Invoice','1'),
('202','VR-22-202','2022-03-07 00:00:00','0','1250.00','1','593.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-07 15:24:12','2022-03-09 11:20:30',NULL,'1','Update Invoice','1'),
('203','INV-22-203','2022-03-07 00:00:00','0','1250.00','1','439.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','25','0','2022-03-07 03:35:55','2022-03-07 03:35:55',NULL,'1','Add New Invoice','1'),
('204','VR-22-204','2022-03-07 00:00:00','0','1250.00','1','499.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-07 16:48:01','2022-03-07 04:48:31',NULL,'1','Update Invoice','1'),
('205','VR-22-205','2022-03-08 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-03-08 14:41:15','2022-03-08 14:41:15',NULL,'1','Add New Invoice','1'),
('206','VR-22-206','2022-03-08 00:00:00','0','1250.00','1','345.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-08 15:02:43','2022-03-08 15:02:43',NULL,'1','Add New Invoice','1'),
('207','VR-22-207','2022-03-08 00:00:00','0','1250.00','1','12.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-08 16:22:38','2022-03-08 16:22:38',NULL,'1','Add New Invoice','1'),
('208','VR-22-208','2022-03-08 00:00:00','0','1250.00','1','1777.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-03-08 17:15:27','2022-03-08 17:15:27',NULL,'1','Add New Invoice','1'),
('209','VR-22-209','2022-03-08 00:00:00','0','1250.00','1','341.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-03-08 17:16:51','2022-03-08 17:16:51',NULL,'1','Add New Invoice','1'),
('210','VR-22-210','2022-03-08 00:00:00','0','1250.00','1','310.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-08 17:19:21','2022-03-08 17:19:21',NULL,'1','Add New Invoice','1'),
('211','VR-22-211','2022-03-08 00:00:00','0','1250.00','1','124.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-03-08 17:20:19','2022-03-08 17:20:19',NULL,'1','Add New Invoice','1'),
('212','VR-22-212','2022-03-08 00:00:00','0','1250.00','1','1905.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-08 17:33:23','2022-03-08 17:33:23',NULL,'1','Add New Invoice','1'),
('213','VR-22-213','2022-03-08 00:00:00','0','1250.00','1','627.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-03-08 17:34:49','2022-03-08 17:34:49',NULL,'1','Add New Invoice','1'),
('214','VR-22-214','2022-03-08 00:00:00','0','1250.00','1','289.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-08 17:35:57','2022-03-08 05:37:05',NULL,'1','Update Invoice','1'),
('215','VR-22-215','2022-03-08 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-08 17:52:43','2022-03-08 17:52:43',NULL,'1','Add New Invoice','1'),
('216','VR-22-216','2022-03-09 00:00:00','0','1250.00','1','205.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-09 11:30:47','2022-03-09 11:30:47',NULL,'1','Add New Invoice','1'),
('217','VR-22-217','2022-03-10 00:00:00','0','1250.00','1','104.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-10 14:39:01','2022-03-10 14:39:01',NULL,'1','Add New Invoice','1'),
('218','VR-22-218','2022-03-10 00:00:00','0','1250.00','1','192.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-03-10 15:11:43','2022-03-10 15:11:43',NULL,'1','Add New Invoice','1'),
('219','VR-22-219','2022-03-10 00:00:00','0','1250.00','1','19.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-03-10 15:13:19','2022-03-10 15:13:19',NULL,'1','Add New Invoice','1'),
('220','VR-22-220','2022-03-10 00:00:00','0','1250.00','1','73.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-10 15:14:48','2022-03-10 15:14:48',NULL,'1','Add New Invoice','1'),
('221','VR-22-221','2022-03-10 00:00:00','0','1250.00','1','936.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-03-10 15:19:56','2022-03-10 15:19:56',NULL,'1','Add New Invoice','1'),
('222','VR-22-222','2022-03-12 00:00:00','0','1250.00','1','235.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2022-03-12 12:19:44','2022-03-12 12:19:44','2022-03-12 12:21:41','1','Delete Invoice','1'),
('223','VR-22-223','2022-03-12 00:00:00','0','1250.00','1','235.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-12 12:22:37','2022-03-12 12:22:37',NULL,'1','Add New Invoice','1'),
('224','VR-22-224','2022-03-12 00:00:00','0','1250.00','1','10.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-12 12:27:04','2022-03-12 12:27:04',NULL,'1','Add New Invoice','1'),
('225','VR-22-225','2022-03-12 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-03-12 12:28:19','2022-03-12 12:28:19',NULL,'1','Add New Invoice','1'),
('226','VR-22-226','2022-03-12 00:00:00','0','1250.00','1','140.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-12 12:32:03','2022-03-12 12:32:03',NULL,'1','Add New Invoice','1'),
('227','VR-22-227','2022-03-12 00:00:00','0','1250.00','1','616.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-12 12:36:41','2022-03-12 12:36:41',NULL,'1','Add New Invoice','1'),
('228','INV-22-228','2022-03-13 00:00:00','0','1250.00','1','787.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','28','0','2022-03-13 11:36:06','2022-03-13 11:36:06',NULL,'1','Add New Invoice','1'),
('229','VR-22-229','2022-03-13 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-03-13 15:37:07','2022-03-13 15:37:07',NULL,'1','Add New Invoice','1'),
('230','VR-22-230','2022-03-13 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-13 15:38:16','2022-03-13 15:38:16',NULL,'1','Add New Invoice','1'),
('231','VR-22-231','2022-03-13 00:00:00','0','1250.00','1','418.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-13 15:45:36','2022-03-13 03:47:18',NULL,'1','Update Invoice','1'),
('232','VR-22-232','2022-03-13 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-03-13 15:58:46','2022-03-13 15:58:46',NULL,'1','Add New Invoice','1'),
('233','VR-22-233','2022-03-13 00:00:00','0','1250.00','1','210.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-13 16:01:23','2022-03-13 16:01:23',NULL,'1','Add New Invoice','1'),
('234','VR-22-234','2022-03-13 00:00:00','0','1250.00','1','702.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-13 16:34:16','2022-03-14 09:20:41',NULL,'1','Update Invoice','1'),
('235','VR-22-235','2022-03-14 00:00:00','0','1250.00','1','319.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-14 14:41:38','2022-03-14 14:41:38',NULL,'1','Add New Invoice','1'),
('236','VR-22-236','2022-03-15 00:00:00','0','1250.00','1','530.29','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-15 14:42:16','2022-03-15 14:42:16',NULL,'1','Add New Invoice','1'),
('237','VR-22-237','2022-03-15 00:00:00','0','1250.00','1','157.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-15 14:43:47','2022-03-15 14:43:47',NULL,'1','Add New Invoice','1'),
('238','VR-22-238','2022-03-15 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-03-15 14:52:24','2022-03-15 14:52:24',NULL,'1','Add New Invoice','1'),
('239','VR-22-239','2022-03-15 00:00:00','0','1250.00','1','196.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-15 14:53:45','2022-03-15 14:53:45',NULL,'1','Add New Invoice','1'),
('240','VR-22-240','2022-03-15 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-15 14:55:26','2022-03-15 14:55:26',NULL,'1','Add New Invoice','1'),
('241','VR-22-241','2022-03-15 00:00:00','0','1250.00','1','149.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-03-15 14:56:42','2022-03-15 14:56:42',NULL,'1','Add New Invoice','1'),
('242','VR-22-242','2022-03-15 00:00:00','0','1250.00','1','80.32','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-15 15:01:05','2022-03-15 15:01:05',NULL,'1','Add New Invoice','1'),
('243','VR-22-243','2022-03-15 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-15 15:08:27','2022-03-15 15:08:27',NULL,'1','Add New Invoice','1'),
('244','VR-22-244','2022-03-16 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2022-03-16 11:34:44','2022-03-16 12:11:59',NULL,'1','Update Invoice','1'),
('245','VR-22-245','2022-03-16 00:00:00','0','1250.00','1','841.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-16 16:30:34','2022-03-16 16:30:34',NULL,'1','Add New Invoice','1'),
('246','INV-22-246','2022-03-17 00:00:00','0','1250.00','1','162.50','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','29','0','2022-03-17 10:43:17','2022-03-17 10:43:17',NULL,'1','Add New Invoice','1'),
('247','INV-22-247','2022-03-17 00:00:00','0','1250.00','1','400.01','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','30','0','2022-03-17 10:58:39','2022-03-17 11:28:38',NULL,'1','Update Invoice','1'),
('248','VR-22-248','2022-03-17 00:00:00','0','1250.00','1','74.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-17 11:49:18','2022-03-17 11:49:18',NULL,'1','Add New Invoice','1'),
('249','VR-22-249','2022-03-17 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-03-17 12:03:59','2022-03-17 12:03:59',NULL,'1','Add New Invoice','1'),
('250','VR-22-250','2022-03-17 00:00:00','0','1250.00','1','169.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-17 12:06:14','2022-03-17 12:06:14',NULL,'1','Add New Invoice','1'),
('251','VR-22-251','2022-03-17 00:00:00','0','1250.00','1','294.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-17 12:12:31','2022-03-17 12:12:31',NULL,'1','Add New Invoice','1'),
('252','VR-22-252','2022-03-17 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-03-17 13:30:47','2022-03-17 13:30:47',NULL,'1','Add New Invoice','1'),
('253','VR-22-253','2022-03-17 00:00:00','0','1250.00','1','640.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-03-17 13:43:07','2022-03-17 01:43:58',NULL,'1','Update Invoice','1'),
('254','VR-22-254','2022-03-17 00:00:00','0','1250.00','1','454.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-17 15:20:52','2022-03-17 15:20:52',NULL,'1','Add New Invoice','1'),
('255','VR-22-255','2022-03-17 00:00:00','0','1250.00','1','110.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-17 15:25:17','2022-03-17 15:25:17',NULL,'1','Add New Invoice','1'),
('256','VR-22-256','2022-03-19 00:00:00','0','1250.00','1','157.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-19 09:16:45','2022-03-19 09:16:45',NULL,'1','Add New Invoice','1'),
('257','VR-22-257','2022-03-19 00:00:00','0','1250.00','1','154.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-19 11:46:26','2022-04-04 10:00:45',NULL,'1','Update Invoice','1'),
('258','VR-22-258','2022-03-19 00:00:00','0','1250.00','1','818.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-19 12:52:42','2022-03-19 12:52:42',NULL,'1','Add New Invoice','1'),
('259','VR-22-259','2022-03-19 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-03-19 12:56:03','2022-03-19 12:56:03',NULL,'1','Add New Invoice','1'),
('260','VR-22-260','2022-03-19 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-03-19 13:05:36','2022-03-19 13:05:36',NULL,'1','Add New Invoice','1'),
('261','VR-22-261','2022-03-19 00:00:00','0','1250.00','1','101.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-19 14:35:29','2022-03-19 14:35:29',NULL,'1','Add New Invoice','1'),
('262','INV-22-262','2022-03-19 00:00:00','0','1250.00','1','563.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','31','0','2022-03-19 03:35:13','2022-03-19 03:35:13',NULL,'1','Add New Invoice','1'),
('263','INV-22-263','2022-03-19 00:00:00','0','1250.00','1','600.87','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','32','0','2022-03-19 03:43:06','2022-03-19 03:43:06',NULL,'1','Add New Invoice','1'),
('264','INV-22-264','2022-03-19 00:00:00','0','1250.00','1','2538.10','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','27','0','2022-03-19 04:14:02','2022-04-13 01:39:17',NULL,'1','Update Invoice','1'),
('265','INV-22-265','2022-03-19 00:00:00','0','1250.00','1','300.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','33','0','2022-03-19 04:37:45','2022-03-19 04:37:45',NULL,'1','Add New Invoice','1'),
('266','VR-22-266','2022-03-20 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-03-20 10:52:31','2022-03-20 10:52:31',NULL,'1','Add New Invoice','1'),
('267','VR-22-267','2022-03-20 00:00:00','0','1250.00','1','740.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-20 11:50:00','2022-03-20 11:50:00',NULL,'1','Add New Invoice','1'),
('268','VR-22-268','2022-03-20 00:00:00','0','1250.00','1','361.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-03-20 11:52:28','2022-03-20 11:52:28',NULL,'1','Add New Invoice','1'),
('269','VR-22-269','2022-03-20 00:00:00','0','1250.00','1','3863.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-20 12:24:21','2022-03-20 12:24:21',NULL,'1','Add New Invoice','1'),
('270','INV-22-270','2022-03-26 00:00:00','0','1250.00','1','612.07','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','34','0','2022-03-26 11:30:23','2022-03-26 11:30:23',NULL,'1','Add New Invoice','1'),
('271','INV-22-271','2022-03-26 00:00:00','0','1250.00','1','712.30','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','35','0','2022-03-26 02:39:20','2022-03-26 02:39:20',NULL,'1','Add New Invoice','1'),
('272','INV-22-272','2022-03-26 00:00:00','0','1250.00','1','3099.50','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','36','1','2022-03-26 03:11:36','2022-03-26 05:06:02','2022-04-03 03:17:23','1','Delete Invoice','1'),
('273','INV-22-273','2022-03-26 00:00:00','0','1250.00','1','350.02','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','37','0','2022-03-26 05:17:23','2022-03-26 05:17:23',NULL,'1','Add New Invoice','1'),
('274','VR-22-274','2022-03-28 00:00:00','0','1250.00','1','169.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-28 16:07:41','2022-03-28 16:07:41',NULL,'1','Add New Invoice','1'),
('275','VR-22-275','2022-03-28 00:00:00','0','1250.00','1','427.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 16:25:01','2022-03-28 16:25:01',NULL,'1','Add New Invoice','1'),
('276','VR-22-276','2022-03-28 00:00:00','0','1250.00','1','432.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 16:28:50','2022-03-28 16:28:50',NULL,'1','Add New Invoice','1'),
('277','VR-22-277','2022-03-28 00:00:00','0','1250.00','1','610.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-28 16:36:34','2022-03-28 16:36:34',NULL,'1','Add New Invoice','1'),
('278','VR-22-278','2022-03-28 00:00:00','0','1250.00','1','146.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-28 16:39:45','2022-03-28 16:39:45',NULL,'1','Add New Invoice','1'),
('279','VR-22-279','2022-03-28 00:00:00','0','1250.00','1','261.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-28 16:45:54','2022-03-28 16:45:54',NULL,'1','Add New Invoice','1'),
('280','VR-22-280','2022-03-28 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-03-28 16:49:02','2022-03-28 16:49:02',NULL,'1','Add New Invoice','1'),
('281','VR-22-281','2022-03-28 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-28 16:51:10','2022-03-28 16:51:10',NULL,'1','Add New Invoice','1'),
('282','VR-22-282','2022-03-28 00:00:00','0','1250.00','1','159.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-28 16:54:08','2022-03-28 16:54:08',NULL,'1','Add New Invoice','1'),
('283','VR-22-283','2022-03-28 00:00:00','0','1250.00','1','251.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2022-03-28 16:56:12','2022-03-28 16:56:12',NULL,'1','Add New Invoice','1'),
('284','VR-22-284','2022-03-28 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-03-28 17:04:40','2022-03-28 17:04:40',NULL,'1','Add New Invoice','1'),
('285','VR-22-285','2022-03-28 00:00:00','0','1250.00','1','305.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-28 17:10:44','2022-03-28 17:10:44',NULL,'1','Add New Invoice','1'),
('286','VR-22-286','2022-03-28 00:00:00','0','1250.00','1','476.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 17:21:14','2022-03-28 17:21:14',NULL,'1','Add New Invoice','1'),
('287','VR-22-287','2022-03-28 00:00:00','0','1250.00','1','22.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-03-28 17:23:06','2022-03-28 17:23:06',NULL,'1','Add New Invoice','1'),
('288','VR-22-288','2022-03-28 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-28 17:25:16','2022-03-28 17:25:16',NULL,'1','Add New Invoice','1'),
('289','VR-22-289','2022-03-28 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-03-28 17:28:33','2022-03-28 17:28:33',NULL,'1','Add New Invoice','1'),
('290','VR-22-290','2022-03-28 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 17:36:38','2022-03-28 17:36:38',NULL,'1','Add New Invoice','1'),
('291','VR-22-291','2022-03-28 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-28 17:46:50','2022-03-28 17:46:50',NULL,'1','Add New Invoice','1'),
('292','VR-22-292','2022-03-28 00:00:00','0','1250.00','1','852.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 18:05:02','2022-03-28 18:05:02',NULL,'1','Add New Invoice','1'),
('293','VR-22-293','2022-03-28 00:00:00','0','1250.00','1','707.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 18:14:14','2022-03-28 18:14:14',NULL,'1','Add New Invoice','1'),
('294','VR-22-294','2022-03-28 00:00:00','0','1250.00','1','26.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-28 18:20:38','2022-03-28 18:20:38',NULL,'1','Add New Invoice','1'),
('295','VR-22-295','2022-03-28 00:00:00','0','1250.00','1','257.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-28 18:30:28','2022-03-28 18:30:28',NULL,'1','Add New Invoice','1'),
('296','VR-22-296','2022-03-28 00:00:00','0','1250.00','1','107.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-28 19:00:23','2022-03-28 19:00:23',NULL,'1','Add New Invoice','1'),
('297','VR-22-297','2022-03-28 00:00:00','0','1250.00','1','395.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-03-28 19:04:30','2022-03-28 19:04:30',NULL,'1','Add New Invoice','1'),
('298','VR-22-298','2022-03-28 00:00:00','0','1250.00','1','520.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2022-03-28 19:20:28','2022-03-28 19:20:28',NULL,'1','Add New Invoice','1'),
('299','VR-22-299','2022-03-28 00:00:00','0','1250.00','1','20.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-03-28 19:36:08','2022-03-28 19:36:08',NULL,'1','Add New Invoice','1'),
('300','VR-22-300','2022-03-29 00:00:00','0','1250.00','1','607.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-29 13:19:16','2022-03-30 03:39:47',NULL,'1','Update Invoice','1'),
('301','VR-22-301','2022-03-29 00:00:00','0','1250.00','1','462.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-29 13:22:47','2022-03-29 13:22:47',NULL,'1','Add New Invoice','1'),
('302','VR-22-302','2022-03-29 00:00:00','0','1250.00','1','480.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-03-29 13:27:38','2022-03-29 13:27:38',NULL,'1','Add New Invoice','1'),
('303','VR-22-303','2022-03-29 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-29 13:35:29','2022-03-29 13:35:29',NULL,'1','Add New Invoice','1'),
('304','VR-22-304','2022-03-29 00:00:00','0','1250.00','1','133.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-29 13:38:18','2022-03-29 13:38:18',NULL,'1','Add New Invoice','1'),
('305','VR-22-305','2022-03-29 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-03-29 13:42:28','2022-03-29 13:42:28',NULL,'1','Add New Invoice','1'),
('306','VR-22-306','2022-03-29 00:00:00','0','1250.00','1','217.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2022-03-29 13:45:13','2022-03-29 13:45:13','2022-03-30 03:36:34','1','Delete Invoice','1'),
('307','INV-22-307','2022-03-30 00:00:00','0','1250.00','1','583.45','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','38','0','2022-03-30 01:24:04','2022-03-30 01:24:04',NULL,'1','Add New Invoice','1'),
('308','VR-22-308','2022-03-31 00:00:00','0','1250.00','1','252.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-03-31 11:20:24','2022-03-31 11:20:24',NULL,'1','Add New Invoice','1'),
('309','VR-22-309','2022-03-31 00:00:00','0','1250.00','1','272.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-31 13:32:07','2022-03-31 13:32:07',NULL,'1','Add New Invoice','1'),
('310','VR-22-310','2022-03-31 00:00:00','0','1250.00','1','74.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-03-31 14:41:28','2022-03-31 14:41:28',NULL,'1','Add New Invoice','1'),
('311','VR-22-311','2022-03-31 00:00:00','0','1250.00','1','594.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-03-31 14:47:54','2022-03-31 14:47:54',NULL,'1','Add New Invoice','1'),
('312','VR-22-312','2022-03-31 00:00:00','0','1250.00','1','455.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-03-31 15:02:46','2022-03-31 15:02:46',NULL,'1','Add New Invoice','1'),
('313','VR-22-313','2022-03-31 00:00:00','0','1250.00','1','71.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-03-31 15:16:35','2022-03-31 15:16:35',NULL,'1','Add New Invoice','1'),
('314','VR-22-314','2022-03-31 00:00:00','0','1250.00','1','50.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-31 15:17:46','2022-11-14 11:59:46',NULL,'1','Update Invoice','1'),
('315','VR-22-315','2022-03-31 00:00:00','0','1250.00','1','831.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-03-31 15:41:34','2022-03-31 15:41:34',NULL,'1','Add New Invoice','1'),
('316','VR-22-316','2022-03-31 00:00:00','0','1250.00','1','162.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-03-31 15:44:26','2022-03-31 15:44:26',NULL,'1','Add New Invoice','1'),
('317','VR-22-317','2022-03-31 00:00:00','0','1250.00','1','16.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-03-31 15:46:11','2022-03-31 15:46:11',NULL,'1','Add New Invoice','1'),
('318','VR-22-318','2022-03-31 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','20','0','2022-03-31 15:48:32','2022-03-31 15:48:32',NULL,'1','Add New Invoice','1'),
('319','VR-22-319','2022-03-31 00:00:00','0','1250.00','1','401.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-03-31 15:54:02','2022-03-31 15:54:02',NULL,'1','Add New Invoice','1'),
('320','VR-22-320','2022-04-02 00:00:00','0','1250.00','1','180.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-02 15:29:02','2022-04-02 15:29:02',NULL,'1','Add New Invoice','1'),
('321','VR-22-321','2022-04-03 00:00:00','0','1250.00','1','66.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-03 13:58:31','2022-04-03 13:58:31',NULL,'1','Add New Invoice','1'),
('322','VR-22-322','2022-04-03 00:00:00','0','1250.00','1','29.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-04-03 13:59:26','2022-04-03 13:59:26',NULL,'1','Add New Invoice','1'),
('323','INV-22-323','2022-04-03 00:00:00','0','1250.00','1','4381.05','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','36','0','2022-04-03 04:01:34','2022-04-03 04:01:34',NULL,'1','Add New Invoice','1'),
('324','INV-22-324','2022-04-04 00:00:00','0','1250.00','1','913.07','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','39','0','2022-04-04 03:03:12','2022-04-04 03:11:26',NULL,'1','Update Invoice','1'),
('325','VR-22-325','2022-04-04 00:00:00','0','1250.00','1','156.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-04 21:48:39','2022-04-04 21:48:39',NULL,'1','Add New Invoice','1'),
('326','VR-22-326','2022-04-05 00:00:00','0','1250.00','1','14.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-05 13:28:11','2022-04-05 13:28:11',NULL,'1','Add New Invoice','1'),
('329','INV-22-327','2022-04-05 00:00:00','0','1250.00','1','1334.80','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','40','0','2022-04-05 04:54:10','2022-04-05 04:54:10',NULL,'1','Add New Invoice','1'),
('330','VR-22-330','2022-04-07 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-04-07 10:37:42','2022-04-07 10:37:42',NULL,'1','Add New Invoice','1'),
('331','VR-22-331','2022-04-07 00:00:00','0','1250.00','1','320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-07 10:52:10','2022-04-11 12:18:49',NULL,'1','Update Invoice','1'),
('332','VR-22-332','2022-04-07 00:00:00','0','1250.00','1','1668.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-04-07 10:58:04','2022-04-07 10:58:04',NULL,'1','Add New Invoice','1'),
('333','VR-22-333','2022-04-07 00:00:00','0','1250.00','1','130.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-07 11:00:07','2022-04-07 11:00:07',NULL,'1','Add New Invoice','1'),
('334','VR-22-334','2022-04-07 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-04-07 11:19:00','2022-04-07 11:19:00',NULL,'1','Add New Invoice','1'),
('335','VR-22-335','2022-04-07 00:00:00','0','1250.00','1','39.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-07 11:21:51','2022-04-07 11:21:51',NULL,'1','Add New Invoice','1'),
('336','VR-22-336','2022-04-07 00:00:00','0','1250.00','1','360.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-04-07 11:30:05','2022-04-07 11:30:05',NULL,'1','Add New Invoice','1'),
('337','VR-22-337','2022-04-07 00:00:00','0','1250.00','1','146.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-04-07 12:05:30','2022-04-07 12:05:30',NULL,'1','Add New Invoice','1'),
('338','INV-22-338','2022-04-07 00:00:00','0','1250.00','1','1554.85','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','41','0','2022-04-07 01:53:59','2022-04-07 01:53:59',NULL,'1','Add New Invoice','1'),
('339','INV-22-339','2022-04-09 00:00:00','0','1250.00','1','1462.74','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','43','0','2022-04-09 04:32:09','2022-04-10 12:03:19',NULL,'1','Update Invoice','1'),
('340','INV-22-340','2022-04-09 00:00:00','0','1250.00','1','8272.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','42','0','2022-04-09 05:21:15','2022-05-12 05:22:27',NULL,'1','Update Invoice','1'),
('341','VR-22-341','2022-04-09 00:00:00','0','1250.00','1','53.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-09 20:27:37','2022-04-09 20:27:37',NULL,'1','Add New Invoice','1'),
('342','VR-22-342','2022-04-09 00:00:00','0','1250.00','1','386.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','1','2022-04-09 20:30:58','2022-04-09 20:30:58','2022-04-09 08:31:20','1','Delete Invoice','1'),
('343','VR-22-343','2022-04-09 00:00:00','0','1250.00','1','264.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-04-09 20:32:36','2022-04-10 03:42:52',NULL,'1','Update Invoice','1'),
('344','VR-22-344','2022-04-09 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-09 20:50:34','2022-04-09 08:51:16',NULL,'1','Update Invoice','1'),
('345','VR-22-345','2022-04-09 00:00:00','0','1250.00','1','239.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-09 21:42:36','2022-04-09 21:42:36',NULL,'1','Add New Invoice','1'),
('346','VR-22-346','2022-04-10 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-04-10 10:34:18','2022-04-10 10:34:18',NULL,'1','Add New Invoice','1'),
('347','VR-22-347','2022-04-10 00:00:00','0','1250.00','1','156.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-10 15:41:06','2022-04-10 15:41:06',NULL,'1','Add New Invoice','1'),
('348','INV-22-348','2022-04-11 00:00:00','0','1250.00','1','475.08','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','44','0','2022-04-11 12:05:34','2022-04-11 12:05:34',NULL,'1','Add New Invoice','1'),
('349','VR-22-349','2022-04-11 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-04-11 12:21:17','2022-04-11 12:21:17',NULL,'1','Add New Invoice','1'),
('350','VR-22-350','2022-04-11 00:00:00','0','1250.00','1','85.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-04-11 12:26:52','2022-04-11 12:26:52',NULL,'1','Add New Invoice','1'),
('351','VR-22-351','2022-04-11 00:00:00','0','1250.00','1','127.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-11 12:54:59','2022-04-11 12:54:59',NULL,'1','Add New Invoice','1'),
('352','VR-22-352','2022-04-11 00:00:00','0','1250.00','1','180.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-11 12:59:50','2022-04-11 12:59:50',NULL,'1','Add New Invoice','1'),
('353','VR-22-353','2022-04-11 00:00:00','0','1250.00','1','259.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-11 16:48:39','2022-04-11 16:48:39',NULL,'1','Add New Invoice','1'),
('354','VR-22-354','2022-04-12 00:00:00','0','1250.00','1','406.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-12 11:26:36','2022-04-12 11:26:36',NULL,'1','Add New Invoice','1'),
('355','VR-22-355','2022-04-12 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-04-12 11:38:00','2022-04-12 11:38:00',NULL,'1','Add New Invoice','1'),
('356','VR-22-356','2022-04-12 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-04-12 11:38:59','2022-04-12 11:38:59',NULL,'1','Add New Invoice','1'),
('357','VR-22-357','2022-04-12 00:00:00','0','1250.00','1','27.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-12 11:40:06','2022-04-12 11:40:06',NULL,'1','Add New Invoice','1'),
('358','VR-22-358','2022-04-13 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-13 14:39:35','2022-04-13 14:39:35',NULL,'1','Add New Invoice','1'),
('359','VR-22-359','2022-04-13 00:00:00','0','1250.00','1','832.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-13 17:50:32','2022-04-13 17:50:32',NULL,'1','Add New Invoice','1'),
('360','VR-22-360','2022-04-16 00:00:00','0','1250.00','1','163.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-16 09:50:11','2022-04-16 09:50:11',NULL,'1','Add New Invoice','1'),
('361','VR-22-361','2022-04-16 00:00:00','0','1250.00','1','256.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-16 10:08:22','2022-04-16 10:08:22',NULL,'1','Add New Invoice','1'),
('362','VR-22-362','2022-04-16 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-16 10:30:29','2022-04-16 10:30:29',NULL,'1','Add New Invoice','1'),
('363','VR-22-363','2022-04-16 00:00:00','0','1250.00','1','57.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-16 10:36:02','2022-04-16 10:36:02',NULL,'1','Add New Invoice','1'),
('364','VR-22-364','2022-04-16 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-16 11:03:00','2022-04-16 11:03:00',NULL,'1','Add New Invoice','1'),
('365','VR-22-365','2022-04-16 00:00:00','0','1250.00','1','6.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-16 11:08:51','2022-04-16 11:08:51',NULL,'1','Add New Invoice','1'),
('366','VR-22-366','2022-04-16 00:00:00','0','1250.00','1','9.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-16 11:35:46','2022-04-16 11:35:46',NULL,'1','Add New Invoice','1'),
('367','VR-22-367','2022-04-16 00:00:00','0','1250.00','1','420.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-16 15:04:18','2022-04-16 15:04:18',NULL,'1','Add New Invoice','1'),
('368','VR-22-368','2022-04-17 00:00:00','0','1250.00','1','642.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-17 10:10:03','2022-04-17 10:10:03',NULL,'1','Add New Invoice','1'),
('369','VR-22-369','2022-04-17 00:00:00','0','1250.00','1','114.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-17 11:48:25','2022-04-17 11:48:25',NULL,'1','Add New Invoice','1'),
('370','INV-22-370','2022-04-17 00:00:00','0','1250.00','1','232.80','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','45','0','2022-04-17 11:57:16','2022-04-17 11:57:16',NULL,'1','Add New Invoice','1'),
('371','VR-22-371','2022-04-17 00:00:00','0','1250.00','1','65.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-17 11:58:27','2022-04-17 11:58:27',NULL,'1','Add New Invoice','1'),
('372','INV-22-372','2022-04-17 00:00:00','0','1250.00','1','260.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','46','0','2022-04-17 12:03:41','2022-04-17 12:03:41',NULL,'1','Add New Invoice','1'),
('373','INV-22-373','2022-04-17 00:00:00','0','1250.00','1','99.15','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','47','0','2022-04-17 12:05:58','2022-04-17 12:05:58',NULL,'1','Add New Invoice','1'),
('374','VR-22-374','2022-04-17 00:00:00','0','1250.00','1','805.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-17 12:09:11','2022-04-17 01:21:55',NULL,'1','Update Invoice','1'),
('375','INV-22-375','2022-04-17 00:00:00','0','1250.00','1','5063.94','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','48','0','2022-04-17 12:42:26','2022-05-12 03:06:19',NULL,'1','Update Invoice','1'),
('376','INV-22-376','2022-04-18 00:00:00','0','1250.00','1','4200.04','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','49','0','2022-04-18 01:30:46','2022-04-18 01:42:53',NULL,'1','Update Invoice','1'),
('377','VR-22-377','2022-04-18 00:00:00','0','1250.00','1','517.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-04-18 13:41:28','2022-04-18 13:41:28',NULL,'1','Add New Invoice','1'),
('378','VR-22-378','2022-04-18 00:00:00','0','1250.00','1','82.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-04-18 13:46:30','2022-04-18 13:46:30',NULL,'1','Add New Invoice','1'),
('379','VR-22-379','2022-04-18 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-04-18 13:50:27','2022-04-18 13:50:27',NULL,'1','Add New Invoice','1'),
('380','VR-22-380','2022-04-18 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-18 14:25:36','2022-04-18 14:25:36',NULL,'1','Add New Invoice','1'),
('381','VR-22-381','2022-04-18 00:00:00','0','1250.00','1','530.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-18 21:42:38','2022-04-18 21:42:38',NULL,'1','Add New Invoice','1'),
('382','VR-22-382','2022-04-19 00:00:00','0','1250.00','1','226.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-19 19:27:33','2022-04-19 19:27:33',NULL,'1','Add New Invoice','1'),
('383','VR-22-383','2022-04-19 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-19 19:29:42','2022-04-19 19:29:42',NULL,'1','Add New Invoice','1'),
('384','VR-22-384','2022-04-19 00:00:00','0','1250.00','1','122.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-04-19 19:37:08','2022-04-19 19:37:08',NULL,'1','Add New Invoice','1'),
('385','VR-22-385','2022-04-19 00:00:00','0','1250.00','1','202.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','50','0','2022-04-19 19:46:37','2022-04-19 19:46:37',NULL,'1','Add New Invoice','1'),
('386','VR-22-386','2022-04-19 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-19 19:54:39','2022-04-19 19:54:39',NULL,'1','Add New Invoice','1'),
('387','VR-22-387','2022-04-19 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-19 19:57:22','2022-04-19 19:57:22',NULL,'1','Add New Invoice','1'),
('388','VR-22-388','2022-04-19 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-04-19 19:58:16','2022-04-19 19:58:16',NULL,'1','Add New Invoice','1'),
('389','VR-22-389','2022-04-19 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-19 20:01:39','2022-04-19 20:01:39',NULL,'1','Add New Invoice','1'),
('390','VR-22-390','2022-04-19 00:00:00','0','1250.00','1','213.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-19 20:13:08','2022-04-19 20:13:08',NULL,'1','Add New Invoice','1'),
('391','VR-22-391','2022-04-20 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-04-20 10:27:34','2022-04-20 10:27:34',NULL,'1','Add New Invoice','1'),
('392','INV-22-392','2022-04-20 00:00:00','0','1250.00','1','295.90','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','51','0','2022-04-20 12:12:35','2022-04-20 12:12:35',NULL,'1','Add New Invoice','1'),
('393','INV-22-393','2022-04-20 00:00:00','0','1250.00','1','80.06','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','52','0','2022-04-20 12:15:59','2022-05-12 02:29:36',NULL,'1','Update Invoice','1'),
('394','INV-22-394','2022-04-20 00:00:00','0','1250.00','1','176.60','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','53','0','2022-04-20 12:20:57','2022-04-20 12:20:57',NULL,'1','Add New Invoice','1'),
('395','INV-22-395','2022-04-20 00:00:00','0','1250.00','1','457.94','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','54','0','2022-04-20 12:28:07','2022-04-20 12:28:07',NULL,'1','Add New Invoice','1'),
('396','INV-22-396','2022-04-20 00:00:00','0','1250.00','1','499.62','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','55','0','2022-04-20 12:34:12','2022-05-12 01:08:03',NULL,'1','Update Invoice','1'),
('397','VR-22-397','2022-04-20 00:00:00','0','1250.00','1','125.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-04-20 15:00:48','2022-04-20 04:51:09',NULL,'1','Update Invoice','1'),
('398','VR-22-398','2022-04-20 00:00:00','0','1250.00','1','278.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-20 16:32:40','2022-05-28 01:48:25',NULL,'1','Update Invoice','1'),
('399','VR-22-399','2022-04-21 00:00:00','0','1250.00','1','303.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-21 14:02:36','2022-04-21 02:10:22',NULL,'1','Update Invoice','1'),
('400','VR-22-400','2022-04-23 00:00:00','0','1250.00','1','377.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-04-23 11:31:31','2022-04-23 11:31:31',NULL,'1','Add New Invoice','1'),
('401','INV-22-401','2022-04-23 00:00:00','0','1250.00','1','749.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','56','0','2022-04-23 03:17:38','2022-04-23 03:17:38',NULL,'1','Add New Invoice','1'),
('402','VR-22-402','2022-04-23 00:00:00','0','1250.00','1','206.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-23 21:27:06','2022-04-23 21:27:06',NULL,'1','Add New Invoice','1'),
('403','VR-22-403','2022-04-24 00:00:00','0','1250.00','1','1531.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-24 12:51:47','2022-04-24 12:51:47',NULL,'1','Add New Invoice','1'),
('404','VR-22-404','2022-04-24 00:00:00','0','1250.00','1','469.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-04-24 13:00:23','2022-04-24 13:00:23',NULL,'1','Add New Invoice','1'),
('405','VR-22-405','2022-04-24 00:00:00','0','1250.00','1','327.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-24 13:09:12','2022-04-24 13:09:12',NULL,'1','Add New Invoice','1'),
('406','VR-22-406','2022-04-24 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-04-24 13:11:18','2022-04-24 13:11:18',NULL,'1','Add New Invoice','1'),
('407','VR-22-407','2022-04-24 00:00:00','0','1250.00','1','856.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-24 13:24:14','2022-04-24 13:24:14',NULL,'1','Add New Invoice','1'),
('408','VR-22-408','2022-04-24 00:00:00','0','1250.00','1','52.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-04-24 13:46:31','2022-04-24 13:46:31',NULL,'1','Add New Invoice','1'),
('409','VR-22-409','2022-04-24 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-24 13:56:10','2022-04-24 13:56:10',NULL,'1','Add New Invoice','1'),
('410','VR-22-410','2022-04-24 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-04-24 13:57:19','2022-04-24 13:57:19',NULL,'1','Add New Invoice','1'),
('411','VR-22-411','2022-04-24 00:00:00','0','1250.00','1','186.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-24 15:47:42','2022-04-24 15:47:42',NULL,'1','Add New Invoice','1'),
('412','VR-22-412','2022-04-25 00:00:00','0','1250.00','1','153.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-25 12:42:26','2022-04-25 01:44:03',NULL,'1','Update Invoice','1'),
('413','VR-22-413','2022-04-25 00:00:00','0','1250.00','1','88.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-25 12:51:52','2022-04-26 07:22:07',NULL,'1','Update Invoice','1'),
('414','VR-22-414','2022-04-26 00:00:00','0','1250.00','1','161.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-04-26 11:03:43','2022-04-26 11:03:43',NULL,'1','Add New Invoice','1'),
('415','VR-22-415','2022-04-26 00:00:00','0','1250.00','1','369.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-26 11:19:00','2022-04-26 05:16:38',NULL,'1','Update Invoice','1'),
('416','VR-22-416','2022-04-26 00:00:00','0','1250.00','1','112.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-26 11:32:03','2022-04-26 11:32:03',NULL,'1','Add New Invoice','1'),
('417','VR-22-417','2022-04-26 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-04-26 11:34:49','2022-04-26 11:34:49',NULL,'1','Add New Invoice','1'),
('418','VR-22-418','2022-04-26 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-04-26 11:37:16','2022-04-26 11:37:16',NULL,'1','Add New Invoice','1'),
('419','VR-22-419','2022-04-26 00:00:00','0','1250.00','1','255.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-04-26 11:55:52','2022-04-26 11:55:52',NULL,'1','Add New Invoice','1'),
('420','VR-22-420','2022-04-26 00:00:00','0','1250.00','1','954.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-04-26 12:37:08','2022-04-26 12:37:08',NULL,'1','Add New Invoice','1'),
('421','VR-22-421','2022-04-26 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-26 13:14:19','2022-04-26 13:14:19',NULL,'1','Add New Invoice','1'),
('422','VR-22-422','2022-04-26 00:00:00','0','1250.00','1','471.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-04-26 13:21:48','2022-04-26 13:21:48',NULL,'1','Add New Invoice','1'),
('423','VR-22-423','2022-04-26 00:00:00','0','1250.00','1','151.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-04-26 13:25:23','2022-04-26 13:25:23',NULL,'1','Add New Invoice','1'),
('424','VR-22-424','2022-04-26 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-26 13:27:08','2022-04-26 01:28:44',NULL,'1','Update Invoice','1'),
('425','VR-22-425','2022-04-26 00:00:00','0','1250.00','1','123.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-26 14:46:58','2022-04-26 14:46:58',NULL,'1','Add New Invoice','1'),
('426','VR-22-426','2022-04-26 00:00:00','0','1250.00','1','218.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-26 17:21:17','2022-04-26 05:24:44',NULL,'1','Update Invoice','1'),
('427','VR-22-427','2022-04-27 00:00:00','0','1250.00','1','144.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-27 12:35:32','2022-04-27 12:35:32',NULL,'1','Add New Invoice','1'),
('428','VR-22-428','2022-04-28 00:00:00','0','1250.00','1','21.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-04-28 11:17:21','2022-04-28 11:17:21',NULL,'1','Add New Invoice','1'),
('429','VR-22-429','2022-04-28 00:00:00','0','1250.00','1','99.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-04-28 11:23:33','2022-04-28 11:23:33',NULL,'1','Add New Invoice','1'),
('430','VR-22-430','2022-04-28 00:00:00','0','1250.00','1','4272.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-04-28 11:49:20','2022-04-28 11:49:20',NULL,'1','Add New Invoice','1'),
('431','INV-22-431','2022-04-28 00:00:00','0','1250.00','1','748.53','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','57','0','2022-04-28 01:59:09','2022-04-28 01:59:09',NULL,'1','Add New Invoice','1'),
('432','VR-22-432','2022-04-30 00:00:00','0','1250.00','1','383.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-04-30 10:09:13','2022-04-30 10:11:59',NULL,'1','Update Invoice','1'),
('433','VR-22-433','2022-04-30 00:00:00','0','1250.00','1','600.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-04-30 10:40:58','2022-04-30 10:40:58',NULL,'1','Add New Invoice','1'),
('434','VR-22-434','2022-04-30 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-04-30 11:00:40','2022-04-30 11:00:40',NULL,'1','Add New Invoice','1'),
('435','VR-22-435','2022-04-30 00:00:00','0','1250.00','1','11.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-04-30 11:06:34','2022-04-30 11:06:34',NULL,'1','Add New Invoice','1'),
('436','VR-22-436','2022-04-30 00:00:00','0','1250.00','1','171.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-04-30 11:20:21','2022-04-30 11:20:21',NULL,'1','Add New Invoice','1'),
('437','INV-22-437','2022-04-30 00:00:00','0','1250.00','1','200.40','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','58','0','2022-04-30 12:14:04','2022-04-30 12:14:04',NULL,'1','Add New Invoice','1'),
('438','INV-22-438','2022-04-30 00:00:00','0','1250.00','1','200.90','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','59','0','2022-04-30 12:17:57','2022-04-30 12:17:57',NULL,'1','Add New Invoice','1'),
('439','VR-22-439','2022-05-01 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-05-01 13:38:08','2022-05-01 13:38:08',NULL,'1','Add New Invoice','1'),
('440','VR-22-440','2022-05-01 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-01 13:42:25','2022-05-01 13:42:25',NULL,'1','Add New Invoice','1'),
('441','VR-22-441','2022-05-07 00:00:00','0','1250.00','1','19.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-07 15:25:00','2022-05-07 15:25:00',NULL,'1','Add New Invoice','1'),
('442','VR-22-442','2022-05-10 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-05-10 11:14:08','2022-05-10 11:14:08',NULL,'1','Add New Invoice','1'),
('443','VR-22-443','2022-05-10 00:00:00','0','1250.00','1','473.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-10 13:02:09','2022-05-10 13:02:09',NULL,'1','Add New Invoice','1'),
('444','VR-22-444','2022-05-10 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-10 13:03:38','2022-05-10 13:03:38',NULL,'1','Add New Invoice','1'),
('445','VR-22-445','2022-05-10 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-10 13:14:14','2022-05-10 13:14:14',NULL,'1','Add New Invoice','1'),
('446','VR-22-446','2022-05-10 00:00:00','0','1250.00','1','141.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-05-10 13:20:25','2022-05-10 13:20:25',NULL,'1','Add New Invoice','1'),
('447','VR-22-447','2022-05-10 00:00:00','0','1250.00','1','636.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-05-10 13:32:06','2022-05-10 13:32:06',NULL,'1','Add New Invoice','1'),
('448','VR-22-448','2022-05-10 00:00:00','0','1250.00','1','234.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-10 13:56:28','2022-05-10 13:56:28',NULL,'1','Add New Invoice','1'),
('449','VR-22-449','2022-05-10 00:00:00','0','1250.00','1','112.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-05-10 13:58:31','2022-05-10 13:58:31',NULL,'1','Add New Invoice','1'),
('450','VR-22-450','2022-05-10 00:00:00','0','1250.00','1','5602.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-10 15:10:17','2022-05-25 04:25:38',NULL,'1','Update Invoice','1'),
('451','VR-22-451','2022-05-10 00:00:00','0','1250.00','1','293.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-05-10 15:30:17','2022-05-10 15:30:17',NULL,'1','Add New Invoice','1'),
('452','VR-22-452','2022-05-10 00:00:00','0','1250.00','1','2102.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-05-10 15:36:15','2022-05-10 15:36:15',NULL,'1','Add New Invoice','1'),
('453','VR-22-453','2022-05-12 00:00:00','0','1250.00','1','110.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-05-12 09:50:36','2022-05-12 09:50:36',NULL,'1','Add New Invoice','1'),
('454','VR-22-454','2022-05-12 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-05-12 10:28:23','2022-05-12 10:30:33',NULL,'1','Update Invoice','1'),
('455','VR-22-455','2022-05-12 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2022-05-12 11:17:01','2022-05-12 11:17:01',NULL,'1','Add New Invoice','1'),
('456','INV-22-456','2022-05-12 00:00:00','0','1250.00','1','1523.42','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','60','0','2022-05-12 12:54:22','2022-05-12 12:54:22',NULL,'1','Add New Invoice','1'),
('457','INV-22-457','2022-05-12 00:00:00','0','1250.00','1','331.66','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','61','0','2022-05-12 03:15:52','2022-05-12 03:15:52',NULL,'1','Add New Invoice','1'),
('458','INV-22-458','2022-05-12 00:00:00','0','1250.00','1','30.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','62','0','2022-05-12 03:28:38','2022-05-12 03:28:38',NULL,'1','Add New Invoice','1'),
('459','INV-22-459','2022-05-14 00:00:00','0','1250.00','1','1683.60','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','63','0','2022-05-14 02:05:37','2022-05-14 02:05:37',NULL,'1','Add New Invoice','1'),
('460','INV-22-460','2022-05-15 00:00:00','0','1250.00','1','177.60','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','64','0','2022-05-15 11:28:53','2022-05-15 11:28:53',NULL,'1','Add New Invoice','1'),
('461','INV-22-461','2022-05-15 00:00:00','0','1250.00','1','143.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','65','0','2022-05-15 11:32:01','2022-05-15 11:32:01',NULL,'1','Add New Invoice','1'),
('462','INV-22-462','2022-05-15 00:00:00','0','1250.00','1','67.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','66','0','2022-05-15 11:33:58','2022-05-15 11:33:58',NULL,'1','Add New Invoice','1'),
('463','INV-22-463','2022-05-15 00:00:00','0','1250.00','1','485.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','67','0','2022-05-15 11:48:58','2022-05-15 11:48:58',NULL,'1','Add New Invoice','1'),
('464','INV-22-464','2022-05-15 00:00:00','0','1250.00','1','124.50','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','68','0','2022-05-15 11:55:54','2022-05-15 11:55:54',NULL,'1','Add New Invoice','1'),
('465','INV-22-465','2022-05-15 00:00:00','0','1250.00','1','480.70','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','69','0','2022-05-15 12:04:20','2022-05-15 12:04:20',NULL,'1','Add New Invoice','1'),
('466','VR-22-466','2022-05-15 00:00:00','0','1250.00','1','420.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-15 15:21:26','2022-05-15 15:21:26',NULL,'1','Add New Invoice','1'),
('467','VR-22-467','2022-05-16 00:00:00','0','1250.00','1','482.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-16 12:09:10','2022-05-16 12:09:10',NULL,'1','Add New Invoice','1'),
('468','VR-22-468','2022-05-16 00:00:00','0','1250.00','1','250.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-05-16 12:38:22','2022-05-16 12:38:22',NULL,'1','Add New Invoice','1'),
('469','VR-22-469','2022-05-16 00:00:00','0','1250.00','1','283.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-05-16 13:08:13','2022-05-16 13:08:13',NULL,'1','Add New Invoice','1'),
('470','VR-22-470','2022-05-16 00:00:00','0','1250.00','1','720.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-05-16 13:09:56','2022-05-16 13:09:56',NULL,'1','Add New Invoice','1'),
('471','VR-22-471','2022-05-16 00:00:00','0','1250.00','1','3546.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-16 13:52:18','2022-05-17 01:46:30',NULL,'1','Update Invoice','1'),
('472','VR-22-472','2022-05-16 00:00:00','0','1250.00','1','318.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-05-16 14:31:42','2022-05-16 14:31:42',NULL,'1','Add New Invoice','1'),
('473','INV-22-473','2022-05-17 00:00:00','0','1250.00','1','40.25','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','70','0','2022-05-17 03:09:30','2022-05-17 03:09:30',NULL,'1','Add New Invoice','1'),
('474','VR-22-474','2022-05-18 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-05-18 15:18:22','2022-05-18 15:18:22',NULL,'1','Add New Invoice','1'),
('475','VR-22-475','2022-05-18 00:00:00','0','1250.00','1','172.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-18 15:24:39','2022-05-19 03:21:34',NULL,'1','Update Invoice','1'),
('476','VR-22-476','2022-05-18 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-05-18 15:29:35','2022-05-18 15:29:35',NULL,'1','Add New Invoice','1'),
('477','VR-22-477','2022-05-18 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-18 15:33:09','2022-05-18 15:33:09',NULL,'1','Add New Invoice','1'),
('478','VR-22-478','2022-05-18 00:00:00','0','1250.00','1','31.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-18 15:35:55','2022-05-19 10:30:41',NULL,'1','Update Invoice','1'),
('479','VR-22-479','2022-05-18 00:00:00','0','1250.00','1','91.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-05-18 15:46:31','2022-05-18 15:46:31',NULL,'1','Add New Invoice','1'),
('480','VR-22-480','2022-05-18 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-05-18 15:59:17','2022-05-18 15:59:17',NULL,'1','Add New Invoice','1'),
('481','VR-22-481','2022-05-18 00:00:00','0','1250.00','1','103.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-05-18 16:10:20','2022-05-18 16:10:20',NULL,'1','Add New Invoice','1'),
('482','VR-22-482','2022-05-18 00:00:00','0','1250.00','1','187.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-05-18 16:12:48','2022-05-18 16:12:48',NULL,'1','Add New Invoice','1'),
('483','VR-22-483','2022-05-18 00:00:00','0','1250.00','1','165.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-18 16:20:46','2022-05-18 16:20:46',NULL,'1','Add New Invoice','1'),
('484','VR-22-484','2022-05-19 00:00:00','0','1250.00','1','176.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-19 10:37:10','2022-05-19 03:22:01',NULL,'1','Update Invoice','1'),
('485','INV-22-485','2022-05-19 00:00:00','0','1250.00','1','280.80','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','32','0','2022-05-19 11:58:00','2022-05-19 11:58:00',NULL,'1','Add New Invoice','1'),
('486','INV-22-486','2022-05-19 00:00:00','0','1250.00','1','191.48','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','48','0','2022-05-19 12:07:03','2022-05-19 12:07:03',NULL,'1','Add New Invoice','1'),
('487','VR-22-487','2022-05-21 00:00:00','0','1250.00','1','221.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-21 11:17:23','2022-05-21 11:19:47',NULL,'1','Update Invoice','1'),
('488','VR-22-488','2022-05-21 00:00:00','0','1250.00','1','123.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-21 13:45:59','2022-05-21 13:45:59',NULL,'1','Add New Invoice','1'),
('489','VR-22-489','2022-05-21 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-05-21 13:48:34','2022-05-21 13:48:34',NULL,'1','Add New Invoice','1'),
('490','VR-22-490','2022-05-22 00:00:00','0','1250.00','1','156.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-22 16:36:33','2022-05-22 16:36:33',NULL,'1','Add New Invoice','1'),
('491','INV-22-491','2022-05-22 00:00:00','0','1250.00','1','70.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','58','0','2022-05-22 04:45:00','2022-05-22 04:45:00',NULL,'1','Add New Invoice','1'),
('492','INV-22-492','2022-05-22 00:00:00','0','1250.00','1','30.03','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','71','0','2022-05-22 05:00:47','2022-05-22 05:00:47',NULL,'1','Add New Invoice','1'),
('493','VR-22-493','2022-05-23 00:00:00','0','1250.00','1','488.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-23 14:51:37','2022-05-23 14:51:37',NULL,'1','Add New Invoice','1'),
('494','VR-22-494','2022-05-23 00:00:00','0','1250.00','1','173.46','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-05-23 14:53:51','2022-05-23 14:53:51',NULL,'1','Add New Invoice','1'),
('495','VR-22-495','2022-05-23 00:00:00','0','1250.00','1','293.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-23 15:19:11','2022-05-23 15:19:11',NULL,'1','Add New Invoice','1'),
('496','VR-22-496','2022-05-23 00:00:00','0','1250.00','1','10.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-05-23 15:21:52','2022-05-23 15:21:52',NULL,'1','Add New Invoice','1'),
('497','VR-22-497','2022-05-23 00:00:00','0','1250.00','1','171.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-05-23 15:23:18','2022-05-23 15:23:18',NULL,'1','Add New Invoice','1'),
('498','VR-22-498','2022-05-24 00:00:00','0','1250.00','1','110.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-05-24 10:44:13','2022-05-24 10:44:13',NULL,'1','Add New Invoice','1'),
('499','INV-22-499','2022-05-24 00:00:00','0','1250.00','1','61.60','0.00','طبع','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','50','0','2022-05-24 01:18:11','2022-05-24 01:18:11',NULL,'1','Add New Invoice','1'),
('500','VR-22-500','2022-05-24 00:00:00','0','1250.00','1','377.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-24 14:00:02','2022-05-24 14:00:02',NULL,'1','Add New Invoice','1'),
('501','INV-22-501','2022-05-24 00:00:00','0','1250.00','1','613.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','72','0','2022-05-24 02:43:35','2022-05-24 02:43:35',NULL,'1','Add New Invoice','1'),
('502','VR-22-502','2022-05-25 00:00:00','0','1250.00','1','400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-05-25 11:13:57','2022-05-25 11:13:57',NULL,'1','Add New Invoice','1'),
('503','VR-22-503','2022-05-25 00:00:00','0','1250.00','1','175.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-25 11:17:02','2022-05-25 11:17:02',NULL,'1','Add New Invoice','1'),
('504','VR-22-504','2022-05-25 00:00:00','0','1250.00','1','338.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-05-25 13:16:49','2022-05-25 01:23:32',NULL,'1','Update Invoice','1'),
('505','VR-22-505','2022-05-25 00:00:00','0','1250.00','1','62.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-05-25 15:41:20','2022-05-25 15:41:20',NULL,'1','Add New Invoice','1'),
('506','VR-22-506','2022-05-25 00:00:00','0','1250.00','1','37.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-05-25 15:47:17','2022-05-25 15:47:17',NULL,'1','Add New Invoice','1'),
('507','VR-22-507','2022-05-25 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-05-25 15:58:52','2022-05-25 15:58:52',NULL,'1','Add New Invoice','1'),
('508','VR-22-508','2022-05-25 00:00:00','0','1250.00','1','265.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-05-25 18:23:33','2022-05-25 18:23:33',NULL,'1','Add New Invoice','1'),
('509','INV-22-509','2022-05-26 00:00:00','0','1250.00','1','279.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','73','0','2022-05-26 10:47:52','2022-05-26 10:47:52',NULL,'1','Add New Invoice','1'),
('510','VR-22-510','2022-05-28 00:00:00','0','1250.00','1','382.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-28 12:02:32','2022-05-28 12:02:32',NULL,'1','Add New Invoice','1'),
('511','VR-22-511','2022-05-28 00:00:00','0','1250.00','1','302.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-05-28 14:23:58','2022-05-28 14:23:58',NULL,'1','Add New Invoice','1'),
('512','VR-22-512','2022-05-28 00:00:00','0','1250.00','1','1851.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-28 16:28:44','2022-05-28 16:28:44',NULL,'1','Add New Invoice','1'),
('513','VR-22-513','2022-05-28 00:00:00','0','1250.00','1','360.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-28 16:36:18','2022-05-28 16:36:18',NULL,'1','Add New Invoice','1'),
('514','VR-22-514','2022-05-28 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-05-28 16:39:08','2022-05-28 16:39:08',NULL,'1','Add New Invoice','1'),
('515','VR-22-515','2022-05-28 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-05-28 16:41:28','2022-05-28 16:41:28',NULL,'1','Add New Invoice','1'),
('516','VR-22-516','2022-05-28 00:00:00','0','1250.00','1','366.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-28 16:46:36','2022-05-28 16:46:36',NULL,'1','Add New Invoice','1'),
('517','VR-22-517','2022-05-28 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-05-28 16:56:37','2022-05-28 16:56:37',NULL,'1','Add New Invoice','1'),
('518','VR-22-518','2022-05-28 00:00:00','0','1250.00','1','375.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-05-28 17:24:39','2022-05-29 03:04:17',NULL,'1','Update Invoice','1'),
('519','VR-22-519','2022-05-30 00:00:00','0','1250.00','1','94.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-05-30 15:27:54','2022-05-30 15:27:54',NULL,'1','Add New Invoice','1'),
('520','VR-22-520','2022-06-01 00:00:00','0','1250.00','1','158.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-01 16:43:24','2022-06-01 16:43:24',NULL,'1','Add New Invoice','1'),
('521','VR-22-521','2022-06-01 00:00:00','0','1250.00','1','109.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-01 17:16:07','2022-06-01 17:16:07',NULL,'1','Add New Invoice','1'),
('522','VR-22-522','2022-06-01 00:00:00','0','1250.00','1','368.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-06-01 17:28:36','2022-06-01 17:28:36',NULL,'1','Add New Invoice','1'),
('523','VR-22-523','2022-06-01 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-06-01 17:52:09','2022-06-01 17:52:09',NULL,'1','Add New Invoice','1'),
('524','VR-22-524','2022-06-01 00:00:00','0','1250.00','1','382.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-01 18:04:35','2022-06-01 18:04:35',NULL,'1','Add New Invoice','1'),
('525','VR-22-525','2022-06-01 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-06-01 18:20:40','2022-06-01 18:20:40',NULL,'1','Add New Invoice','1'),
('526','INV-22-526','2022-06-04 00:00:00','0','1250.00','1','472.95','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','74','0','2022-06-04 11:12:29','2022-06-04 11:12:29',NULL,'1','Add New Invoice','1'),
('527','INV-22-527','2022-06-04 00:00:00','0','1250.00','1','132.50','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','75','0','2022-06-04 11:21:38','2022-06-04 11:21:38',NULL,'1','Add New Invoice','1'),
('528','INV-22-528','2022-06-04 00:00:00','0','1250.00','1','571.50','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','76','0','2022-06-04 01:19:18','2022-06-08 05:08:16',NULL,'1','Update Invoice','1'),
('529','VR-22-529','2022-06-04 00:00:00','0','1250.00','1','624.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-06-04 17:30:59','2022-06-08 03:55:50',NULL,'1','Update Invoice','1'),
('530','VR-22-530','2022-06-04 00:00:00','0','1250.00','1','5.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-04 17:34:02','2022-06-04 17:34:02',NULL,'1','Add New Invoice','1'),
('531','VR-22-531','2022-06-04 00:00:00','0','1250.00','1','109.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-06-04 17:35:03','2022-06-04 17:35:03',NULL,'1','Add New Invoice','1'),
('532','VR-22-532','2022-06-04 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-06-04 17:36:07','2022-06-04 17:36:07',NULL,'1','Add New Invoice','1'),
('533','VR-22-533','2022-06-04 00:00:00','0','1250.00','1','122.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-04 17:37:35','2022-06-04 17:37:35',NULL,'1','Add New Invoice','1'),
('534','VR-22-534','2022-06-04 00:00:00','0','1250.00','1','6912.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-04 17:47:52','2022-06-04 05:50:29',NULL,'1','Update Invoice','1'),
('535','VR-22-535','2022-06-04 00:00:00','0','1250.00','1','313.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-06-04 17:59:03','2022-06-04 17:59:03',NULL,'1','Add New Invoice','1'),
('536','INV-22-536','2022-06-05 00:00:00','0','1250.00','1','315.70','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','77','0','2022-06-05 02:19:21','2022-06-05 02:19:21',NULL,'1','Add New Invoice','1'),
('537','INV-22-537','2022-06-05 00:00:00','0','1250.00','1','570.80','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','78','0','2022-06-05 02:34:24','2022-06-05 02:34:24',NULL,'1','Add New Invoice','1'),
('538','VR-22-538','2022-06-06 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-06-06 09:51:01','2022-06-06 09:51:01',NULL,'1','Add New Invoice','1'),
('539','VR-22-539','2022-06-06 00:00:00','0','1250.00','1','661.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-06 12:24:17','2022-06-06 12:24:17',NULL,'1','Add New Invoice','1'),
('540','VR-22-540','2022-06-06 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-06 12:25:41','2022-06-06 12:25:41',NULL,'1','Add New Invoice','1'),
('541','VR-22-541','2022-06-06 00:00:00','0','1250.00','1','168.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-06-06 12:26:50','2022-06-06 12:26:50',NULL,'1','Add New Invoice','1'),
('542','VR-22-542','2022-06-06 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-06-06 12:27:28','2022-06-06 12:27:28',NULL,'1','Add New Invoice','1'),
('543','VR-22-543','2022-06-06 00:00:00','0','1250.00','1','260.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-06 17:18:33','2022-06-06 17:18:33',NULL,'1','Add New Invoice','1'),
('544','INV-22-544','2022-06-08 00:00:00','0','1250.00','1','103.10','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','79','0','2022-06-08 12:53:58','2022-06-08 12:53:58',NULL,'1','Add New Invoice','1'),
('545','INV-22-545','2022-06-08 00:00:00','0','1250.00','1','2063.20','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','80','0','2022-06-08 01:29:20','2022-06-08 02:17:23',NULL,'1','Update Invoice','1'),
('546','INV-22-546','2022-06-08 00:00:00','0','1250.00','1','650.11','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','81','0','2022-06-08 01:36:53','2022-06-08 01:36:53',NULL,'1','Add New Invoice','1'),
('547','VR-22-547','2022-06-08 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-06-08 14:42:13','2022-06-08 14:42:13',NULL,'1','Add New Invoice','1'),
('548','VR-22-548','2022-06-08 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-08 14:47:31','2022-06-08 14:47:31',NULL,'1','Add New Invoice','1'),
('549','VR-22-549','2022-06-08 00:00:00','0','1250.00','1','165.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-08 15:54:09','2022-06-08 15:54:09',NULL,'1','Add New Invoice','1'),
('550','VR-22-550','2022-06-08 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','1','2022-06-08 16:07:53','2022-06-08 16:07:53','2022-06-08 04:51:13','1','Delete Invoice','1'),
('551','VR-22-551','2022-06-08 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-06-08 19:47:03','2022-06-08 19:47:03',NULL,'1','Add New Invoice','1'),
('552','INV-22-552','2022-06-09 00:00:00','0','1250.00','1','2580.30','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','74','0','2022-06-09 11:14:25','2022-06-09 11:14:25',NULL,'1','Add New Invoice','1'),
('553','VR-22-553','2022-06-09 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-06-09 11:20:16','2022-06-09 11:20:16',NULL,'1','Add New Invoice','1'),
('554','VR-22-554','2022-06-09 00:00:00','0','1250.00','1','137.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-09 12:25:47','2022-06-09 12:25:47',NULL,'1','Add New Invoice','1'),
('555','INV-22-555','2022-06-09 00:00:00','0','1250.00','1','320.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','82','0','2022-06-09 01:13:37','2022-06-09 01:13:37',NULL,'1','Add New Invoice','1'),
('556','VR-22-556','2022-06-12 00:00:00','0','1250.00','1','1320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-06-12 11:17:03','2022-06-12 11:17:03',NULL,'1','Add New Invoice','1'),
('557','VR-22-557','2022-06-12 00:00:00','0','1250.00','1','1320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-06-12 16:58:36','2022-06-12 16:58:36',NULL,'1','Add New Invoice','1'),
('558','VR-22-558','2022-06-12 00:00:00','0','1250.00','1','71.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-12 19:06:21','2022-06-12 19:06:21',NULL,'1','Add New Invoice','1'),
('559','VR-22-559','2022-06-12 00:00:00','0','1250.00','1','378.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-12 19:15:06','2022-06-12 19:15:06',NULL,'1','Add New Invoice','1'),
('560','VR-22-560','2022-06-12 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-06-12 19:16:26','2022-06-12 19:16:26',NULL,'1','Add New Invoice','1'),
('561','VR-22-561','2022-06-13 00:00:00','0','1250.00','1','194.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-13 15:54:48','2022-06-13 15:54:48',NULL,'1','Add New Invoice','1'),
('563','INV-22-562','2022-06-13 00:00:00','0','1250.00','1','855.25','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','83','0','2022-06-13 05:55:36','2022-06-13 05:55:36',NULL,'1','Add New Invoice','1'),
('564','VR-22-564','2022-06-13 00:00:00','0','1250.00','1','428.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-13 18:08:28','2022-06-13 18:08:28',NULL,'1','Add New Invoice','1'),
('565','VR-22-565','2022-06-14 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-06-14 12:07:25','2022-06-14 12:07:25',NULL,'1','Add New Invoice','1'),
('566','VR-22-566','2022-06-14 00:00:00','0','1250.00','1','2195.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-06-14 12:15:00','2022-06-14 12:15:00',NULL,'1','Add New Invoice','1'),
('567','VR-22-567','2022-06-14 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-14 12:38:00','2022-06-14 12:38:00',NULL,'1','Add New Invoice','1'),
('568','VR-22-568','2022-06-15 00:00:00','0','1250.00','1','167.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-06-15 10:07:54','2022-06-15 10:07:54',NULL,'1','Add New Invoice','1'),
('569','VR-22-569','2022-06-15 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-15 10:12:05','2022-06-15 10:12:05',NULL,'1','Add New Invoice','1'),
('570','INV-22-570','2022-06-15 00:00:00','0','1250.00','1','850.02','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','84','0','2022-06-15 03:22:28','2022-06-15 03:22:28',NULL,'1','Add New Invoice','1'),
('571','VR-22-571','2022-06-15 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-06-15 17:41:53','2022-06-15 17:41:53',NULL,'1','Add New Invoice','1'),
('572','VR-22-572','2022-06-15 00:00:00','0','1250.00','1','1741.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-06-15 18:15:52','2022-06-15 18:15:52',NULL,'1','Add New Invoice','1'),
('573','VR-22-573','2022-06-16 00:00:00','0','1250.00','1','1074.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-06-16 16:30:17','2022-06-16 16:30:17',NULL,'1','Add New Invoice','1'),
('574','VR-22-574','2022-06-18 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-06-18 09:46:18','2022-06-18 09:46:18',NULL,'1','Add New Invoice','1'),
('575','VR-22-575','2022-06-18 00:00:00','0','1250.00','1','540.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-18 09:53:33','2022-06-18 09:53:33',NULL,'1','Add New Invoice','1'),
('576','VR-22-576','2022-06-18 00:00:00','0','1250.00','1','1561.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-06-18 10:02:49','2022-06-18 10:02:49',NULL,'1','Add New Invoice','1'),
('577','VR-22-577','2022-06-18 00:00:00','0','1250.00','1','218.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-06-18 13:38:19','2022-06-18 13:38:19',NULL,'1','Add New Invoice','1'),
('578','VR-22-578','2022-06-20 00:00:00','0','1250.00','1','365.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-20 10:53:07','2022-06-20 10:53:07',NULL,'1','Add New Invoice','1'),
('579','VR-22-579','2022-06-20 00:00:00','0','1250.00','1','168.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-20 13:51:31','2022-06-20 13:51:31',NULL,'1','Add New Invoice','1'),
('580','VR-22-580','2022-06-20 00:00:00','0','1250.00','1','660.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-06-20 13:57:13','2022-06-20 13:57:13',NULL,'1','Add New Invoice','1'),
('581','VR-22-581','2022-06-20 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-20 13:57:42','2022-06-20 13:57:42',NULL,'1','Add New Invoice','1'),
('582','VR-22-582','2022-06-20 00:00:00','0','1250.00','1','155.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-06-20 16:18:09','2022-06-20 16:18:09',NULL,'1','Add New Invoice','1'),
('583','VR-22-583','2022-06-20 00:00:00','0','1250.00','1','14.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2022-06-20 16:21:56','2022-06-20 16:21:56','2022-06-27 03:39:21','1','Delete Invoice','1'),
('584','VR-22-584','2022-06-22 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-06-22 18:31:24','2022-06-22 18:31:24',NULL,'1','Add New Invoice','1'),
('585','VR-22-585','2022-06-22 00:00:00','0','1250.00','1','636.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-22 18:48:10','2022-06-22 18:48:10',NULL,'1','Add New Invoice','1'),
('586','VR-22-586','2022-06-22 00:00:00','0','1250.00','1','601.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-22 18:50:51','2022-06-22 09:30:14',NULL,'1','Update Invoice','1'),
('587','VR-22-587','2022-06-23 00:00:00','0','1250.00','1','624.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-23 14:15:37','2022-06-23 02:46:16',NULL,'1','Update Invoice','1'),
('588','VR-22-588','2022-06-25 00:00:00','0','1250.00','1','261.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-25 15:33:17','2022-06-25 15:33:17',NULL,'1','Add New Invoice','1'),
('589','VR-22-589','2022-06-25 00:00:00','0','1250.00','1','642.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-06-25 17:01:18','2022-06-25 17:01:18',NULL,'1','Add New Invoice','1'),
('590','VR-22-590','2022-06-26 00:00:00','0','1250.00','1','1067.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-26 13:55:55','2022-06-26 13:55:55',NULL,'1','Add New Invoice','1'),
('591','VR-22-591','2022-06-26 00:00:00','0','1250.00','1','171.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-06-26 13:57:05','2022-06-26 13:57:05',NULL,'1','Add New Invoice','1'),
('592','VR-22-592','2022-06-26 00:00:00','0','1250.00','1','26.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-06-26 13:57:51','2022-06-26 13:57:51',NULL,'1','Add New Invoice','1'),
('593','VR-22-593','2022-06-27 00:00:00','0','1250.00','1','148.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-27 11:05:37','2022-06-28 09:35:59',NULL,'1','Update Invoice','1'),
('594','VR-22-594','2022-06-27 00:00:00','0','1250.00','1','380.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-06-27 11:15:43','2022-06-27 11:15:43',NULL,'1','Add New Invoice','1'),
('595','VR-22-595','2022-06-27 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-06-27 11:16:12','2022-06-27 11:16:12',NULL,'1','Add New Invoice','1'),
('596','VR-22-596','2022-06-28 00:00:00','0','1250.00','1','743.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-06-28 09:28:29','2022-06-28 12:14:56',NULL,'1','Update Invoice','1'),
('597','VR-22-597','2022-06-28 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-06-28 21:04:08','2022-06-28 21:04:08',NULL,'1','Add New Invoice','1'),
('598','VR-22-598','2022-06-28 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-06-28 21:08:22','2022-06-28 21:08:22',NULL,'1','Add New Invoice','1'),
('599','VR-22-599','2022-06-28 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-06-28 21:12:54','2022-06-28 21:12:54',NULL,'1','Add New Invoice','1'),
('600','VR-22-600','2022-06-28 00:00:00','0','1250.00','1','596.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-06-28 21:22:43','2022-06-28 09:23:37',NULL,'1','Update Invoice','1'),
('601','VR-22-601','2022-06-28 00:00:00','0','1250.00','1','270.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-06-28 21:35:34','2022-06-28 21:35:34',NULL,'1','Add New Invoice','1'),
('602','VR-22-602','2022-06-28 00:00:00','0','1250.00','1','11117.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-06-28 22:05:00','2022-06-28 22:05:00',NULL,'1','Add New Invoice','1'),
('603','VR-22-603','2022-06-29 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-06-29 11:42:10','2022-06-29 11:42:10',NULL,'1','Add New Invoice','1'),
('604','VR-22-604','2022-06-29 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','1','2022-06-29 13:11:42','2022-06-29 13:11:42','2022-06-29 01:12:38','1','Delete Invoice','1'),
('605','VR-22-605','2022-06-29 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-06-29 13:13:29','2022-06-29 13:13:29',NULL,'1','Add New Invoice','1'),
('606','VR-22-606','2022-06-29 00:00:00','0','1250.00','1','180.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-06-29 14:19:05','2022-06-29 14:19:05',NULL,'1','Add New Invoice','1'),
('607','VR-22-607','2022-07-02 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-07-02 12:24:14','2022-07-02 12:24:14',NULL,'1','Add New Invoice','1'),
('608','VR-22-608','2022-07-02 00:00:00','0','1250.00','1','155.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-07-02 14:36:47','2022-07-04 11:55:11',NULL,'1','Update Invoice','1'),
('609','VR-22-609','2022-07-02 00:00:00','0','1250.00','1','434.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-07-02 19:54:27','2022-07-02 19:54:27',NULL,'1','Add New Invoice','1'),
('610','VR-22-610','2022-07-02 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-07-02 19:55:35','2022-07-02 19:55:35',NULL,'1','Add New Invoice','1'),
('611','VR-22-611','2022-07-02 00:00:00','0','1250.00','1','259.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-02 20:04:40','2022-07-02 20:04:40',NULL,'1','Add New Invoice','1'),
('612','VR-22-612','2022-07-02 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-07-02 20:07:03','2022-07-02 20:07:03',NULL,'1','Add New Invoice','1'),
('613','VR-22-613','2022-07-02 00:00:00','0','1250.00','1','2144.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-07-02 20:11:54','2022-07-02 20:11:54',NULL,'1','Add New Invoice','1'),
('614','VR-22-614','2022-07-02 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-07-02 21:06:01','2022-07-02 21:06:01',NULL,'1','Add New Invoice','1'),
('615','VR-22-615','2022-07-03 00:00:00','0','1250.00','1','660.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-07-03 13:38:43','2022-07-03 13:38:43',NULL,'1','Add New Invoice','1'),
('616','VR-22-616','2022-07-03 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-07-03 13:49:59','2022-07-03 13:49:59',NULL,'1','Add New Invoice','1'),
('617','VR-22-617','2022-07-03 00:00:00','0','1250.00','1','303.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','1','2022-07-03 14:44:52','2022-07-03 14:44:52','2022-07-04 11:52:37','1','Delete Invoice','1'),
('618','VR-22-618','2022-07-03 00:00:00','0','1250.00','1','358.29','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-03 15:35:09','2022-07-03 15:35:09',NULL,'1','Add New Invoice','1'),
('619','VR-22-619','2022-07-03 00:00:00','0','1250.00','1','380.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-07-03 16:58:06','2022-07-03 16:58:06',NULL,'1','Add New Invoice','1'),
('620','VR-22-620','2022-07-03 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-03 16:58:35','2022-07-03 16:58:35',NULL,'1','Add New Invoice','1'),
('621','VR-22-621','2022-07-04 00:00:00','0','1250.00','1','311.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-07-04 11:59:14','2022-07-04 11:59:14',NULL,'1','Add New Invoice','1'),
('622','VR-22-622','2022-07-04 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-07-04 12:07:32','2022-07-04 12:07:32',NULL,'1','Add New Invoice','1'),
('623','VR-22-623','2022-07-04 00:00:00','0','1250.00','1','319.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-07-04 12:28:38','2022-07-04 12:28:38',NULL,'1','Add New Invoice','1'),
('624','VR-22-624','2022-07-04 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-07-04 19:58:26','2022-07-04 19:58:26',NULL,'1','Add New Invoice','1'),
('625','VR-22-625','2022-07-05 00:00:00','0','1250.00','1','173.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-07-05 10:00:26','2022-07-05 10:00:26',NULL,'1','Add New Invoice','1'),
('626','VR-22-626','2022-07-05 00:00:00','0','1250.00','1','194.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-07-05 19:47:08','2022-07-05 19:47:08',NULL,'1','Add New Invoice','1'),
('627','VR-22-627','2022-07-05 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-07-05 19:52:33','2022-07-05 19:52:33',NULL,'1','Add New Invoice','1'),
('628','VR-22-628','2022-07-05 00:00:00','0','1250.00','1','107.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-07-05 19:54:09','2022-07-05 19:54:09',NULL,'1','Add New Invoice','1'),
('629','VR-22-629','2022-07-05 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-07-05 19:57:32','2022-07-05 19:57:32',NULL,'1','Add New Invoice','1'),
('630','VR-22-630','2022-07-06 00:00:00','0','1250.00','1','203.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-07-06 11:27:16','2022-07-06 11:27:16',NULL,'1','Add New Invoice','1'),
('631','VR-22-631','2022-07-06 00:00:00','0','1250.00','1','366.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-06 13:30:33','2022-07-06 13:30:33',NULL,'1','Add New Invoice','1'),
('632','VR-22-632','2022-07-06 00:00:00','0','1250.00','1','350.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-07-06 16:23:32','2022-07-06 16:23:32',NULL,'1','Add New Invoice','1'),
('633','VR-22-633','2022-07-07 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-07-07 16:50:56','2022-07-07 16:50:56',NULL,'1','Add New Invoice','1'),
('634','VR-22-634','2022-07-07 00:00:00','0','1250.00','1','302.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-07-07 20:38:08','2022-07-07 20:38:08',NULL,'1','Add New Invoice','1'),
('635','VR-22-635','2022-07-07 00:00:00','0','1250.00','1','294.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-07-07 20:38:58','2022-07-07 20:38:58',NULL,'1','Add New Invoice','1'),
('636','VR-22-636','2022-07-07 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-07 20:50:49','2022-07-07 20:50:49',NULL,'1','Add New Invoice','1'),
('637','VR-22-637','2022-07-13 00:00:00','0','1250.00','1','207.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-13 15:29:20','2022-07-13 15:29:20',NULL,'1','Add New Invoice','1'),
('638','VR-22-638','2022-07-14 00:00:00','0','1250.00','1','283.29','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-07-14 11:39:08','2022-07-14 11:39:08',NULL,'1','Add New Invoice','1'),
('639','VR-22-639','2022-07-16 00:00:00','0','1250.00','1','389.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-16 15:04:26','2022-07-16 15:04:26',NULL,'1','Add New Invoice','1'),
('640','VR-22-640','2022-07-16 00:00:00','0','1250.00','1','220.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-07-16 19:51:07','2022-07-16 19:51:07',NULL,'1','Add New Invoice','1'),
('641','VR-22-641','2022-07-17 00:00:00','0','1250.00','1','94.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-07-17 16:53:50','2022-07-17 16:53:50',NULL,'1','Add New Invoice','1'),
('642','VR-22-642','2022-07-18 00:00:00','0','1250.00','1','337.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-18 14:29:46','2022-07-18 14:29:46',NULL,'1','Add New Invoice','1'),
('643','VR-22-643','2022-07-18 00:00:00','0','1250.00','1','254.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-07-18 17:55:21','2022-07-18 17:55:21',NULL,'1','Add New Invoice','1'),
('644','VR-22-644','2022-07-18 00:00:00','0','1250.00','1','6807.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-07-18 19:15:56','2022-07-18 07:19:57',NULL,'1','Update Invoice','1'),
('645','VR-22-645','2022-07-19 00:00:00','0','1250.00','1','1100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-07-19 17:48:31','2022-07-19 17:48:31',NULL,'1','Add New Invoice','1'),
('646','VR-22-646','2022-07-19 00:00:00','0','1250.00','1','660.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-07-19 17:49:25','2022-07-19 17:49:25',NULL,'1','Add New Invoice','1'),
('647','VR-22-647','2022-07-19 00:00:00','0','1250.00','1','91.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-07-19 18:28:19','2022-07-19 18:28:19',NULL,'1','Add New Invoice','1'),
('648','VR-22-648','2022-07-19 00:00:00','0','1250.00','1','364.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-07-19 21:04:14','2022-07-19 21:04:14',NULL,'1','Add New Invoice','1'),
('649','VR-22-649','2022-07-20 00:00:00','0','1250.00','1','495.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-07-20 10:15:38','2022-07-20 10:15:38',NULL,'1','Add New Invoice','1'),
('650','VR-22-650','2022-07-20 00:00:00','0','1250.00','1','796.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-20 11:29:28','2022-07-20 11:42:23',NULL,'1','Update Invoice','1'),
('651','VR-22-651','2022-07-20 00:00:00','0','1250.00','1','186.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-20 16:08:51','2022-07-20 16:08:51',NULL,'1','Add New Invoice','1'),
('652','VR-22-652','2022-07-20 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-07-20 16:31:23','2022-07-20 16:31:23',NULL,'1','Add New Invoice','1'),
('653','VR-22-653','2022-07-20 00:00:00','0','1250.00','1','190.74','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-07-20 16:32:06','2022-07-20 16:32:06',NULL,'1','Add New Invoice','1'),
('654','VR-22-654','2022-07-23 00:00:00','0','1250.00','1','15298.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-07-23 15:04:32','2023-03-07 03:56:49',NULL,'1','Update Invoice','1'),
('655','VR-22-655','2022-07-23 00:00:00','0','1250.00','1','1326.46','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-07-23 19:08:09','2022-07-23 19:08:09',NULL,'1','Add New Invoice','1'),
('656','VR-22-656','2022-07-24 00:00:00','0','1250.00','1','413.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-24 11:07:02','2022-07-24 11:07:02',NULL,'1','Add New Invoice','1'),
('657','VR-22-657','2022-07-24 00:00:00','0','1250.00','1','42.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-07-24 12:01:24','2022-07-24 12:01:24',NULL,'1','Add New Invoice','1'),
('658','VR-22-658','2022-07-24 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-07-24 12:02:10','2022-07-24 12:02:10',NULL,'1','Add New Invoice','1'),
('659','VR-22-659','2022-07-24 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-07-24 12:06:11','2022-07-24 12:06:11',NULL,'1','Add New Invoice','1'),
('660','VR-22-660','2022-07-25 00:00:00','0','1250.00','1','1018.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-25 17:26:55','2022-07-26 11:23:45',NULL,'1','Update Invoice','1'),
('661','VR-22-661','2022-07-26 00:00:00','0','1250.00','1','880.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-07-26 14:35:25','2022-07-26 14:35:25',NULL,'1','Add New Invoice','1'),
('662','VR-22-662','2022-07-26 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-07-26 19:14:04','2022-07-26 19:14:04',NULL,'1','Add New Invoice','1'),
('663','VR-22-663','2022-07-28 00:00:00','0','1250.00','1','1397.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-07-28 12:51:31','2022-07-28 01:11:24',NULL,'1','Update Invoice','1'),
('664','VR-22-664','2022-07-28 00:00:00','0','1250.00','1','180.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-28 15:19:28','2022-07-28 15:19:28',NULL,'1','Add New Invoice','1'),
('665','VR-22-665','2022-07-28 00:00:00','0','1250.00','1','279.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-07-28 15:23:33','2022-07-28 15:23:33',NULL,'1','Add New Invoice','1'),
('666','VR-22-666','2022-07-28 00:00:00','0','1250.00','1','524.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-07-28 16:37:24','2022-07-31 11:33:31',NULL,'1','Update Invoice','1'),
('667','VR-22-667','2022-07-28 00:00:00','0','1250.00','1','31.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-28 19:58:53','2022-07-28 08:01:35',NULL,'1','Update Invoice','1'),
('668','VR-22-668','2022-07-28 00:00:00','0','1250.00','1','5813.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-07-28 20:38:21','2022-07-28 20:38:21',NULL,'1','Add New Invoice','1'),
('669','VR-22-669','2022-07-30 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-07-30 12:59:18','2022-07-30 12:59:18',NULL,'1','Add New Invoice','1'),
('670','VR-22-670','2022-07-30 00:00:00','0','1250.00','1','2400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-07-30 13:00:20','2022-07-30 13:00:20',NULL,'1','Add New Invoice','1'),
('671','VR-22-671','2022-07-31 00:00:00','0','1250.00','1','607.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-07-31 11:51:13','2022-07-31 11:51:13',NULL,'1','Add New Invoice','1'),
('672','VR-22-672','2022-07-31 00:00:00','0','1250.00','1','106.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-07-31 12:26:10','2022-07-31 12:26:10',NULL,'1','Add New Invoice','1'),
('673','VR-22-673','2022-08-01 00:00:00','0','1250.00','1','298.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-01 13:57:12','2022-08-01 13:57:12',NULL,'1','Add New Invoice','1'),
('674','VR-22-674','2022-08-01 00:00:00','0','1250.00','1','341.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-08-01 15:43:26','2022-08-01 15:43:26',NULL,'1','Add New Invoice','1'),
('675','VR-22-675','2022-08-01 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-01 16:28:28','2022-08-01 16:28:28',NULL,'1','Add New Invoice','1'),
('676','VR-22-676','2022-08-01 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-08-01 17:33:46','2022-08-01 17:33:46',NULL,'1','Add New Invoice','1'),
('677','VR-22-677','2022-08-03 00:00:00','0','1250.00','1','175.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-08-03 15:03:36','2022-08-03 15:03:36',NULL,'1','Add New Invoice','1'),
('678','VR-22-678','2022-08-03 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-03 16:32:53','2022-08-03 16:32:53',NULL,'1','Add New Invoice','1'),
('679','VR-22-679','2022-08-03 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-08-03 17:03:20','2022-08-03 17:03:20',NULL,'1','Add New Invoice','1'),
('680','VR-22-680','2022-08-04 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-04 13:39:43','2022-08-04 13:39:43',NULL,'1','Add New Invoice','1'),
('681','VR-22-681','2022-08-04 00:00:00','0','1250.00','1','50.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-04 13:41:20','2022-08-04 13:41:20',NULL,'1','Add New Invoice','1'),
('682','VR-22-682','2022-08-04 00:00:00','0','1250.00','1','55.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-04 18:31:50','2022-08-04 18:31:50',NULL,'1','Add New Invoice','1'),
('683','VR-22-683','2022-08-04 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-08-04 18:33:07','2022-08-04 18:33:07',NULL,'1','Add New Invoice','1'),
('684','VR-22-684','2022-08-04 00:00:00','0','1250.00','1','42.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','1','2022-08-04 18:40:06','2022-08-04 18:40:06','2022-08-04 06:54:17','1','Delete Invoice','1'),
('685','VR-22-685','2022-08-04 00:00:00','0','1250.00','1','20.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-04 20:00:10','2022-08-04 20:00:10',NULL,'1','Add New Invoice','1'),
('686','VR-22-686','2022-08-07 00:00:00','0','1250.00','1','66.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-08-07 11:08:45','2022-08-07 11:08:45',NULL,'1','Add New Invoice','1'),
('687','INV-22-687','2022-08-07 00:00:00','0','1250.00','1','383.92','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','50','0','2022-08-07 11:38:06','2022-08-07 11:38:06',NULL,'1','Add New Invoice','1'),
('688','VR-22-688','2022-08-07 00:00:00','0','1250.00','1','345.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-07 18:31:55','2022-08-07 18:31:55',NULL,'1','Add New Invoice','1'),
('689','VR-22-689','2022-08-07 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-07 18:47:24','2022-08-07 18:47:24',NULL,'1','Add New Invoice','1'),
('690','VR-22-690','2022-08-08 00:00:00','0','1250.00','1','429.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-08 17:28:59','2022-08-08 17:28:59',NULL,'1','Add New Invoice','1'),
('691','VR-22-691','2022-08-08 00:00:00','0','1250.00','1','490.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-08-08 17:32:54','2022-08-08 17:32:54',NULL,'1','Add New Invoice','1'),
('692','VR-22-692','2022-08-09 00:00:00','0','1250.00','1','201.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-09 12:03:32','2022-08-09 12:03:32',NULL,'1','Add New Invoice','1'),
('693','VR-22-693','2022-08-09 00:00:00','0','1250.00','1','38.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-08-09 20:50:57','2022-08-09 20:50:57',NULL,'1','Add New Invoice','1'),
('694','VR-22-694','2022-08-09 00:00:00','0','1250.00','1','402.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-09 20:52:49','2022-08-09 20:52:49',NULL,'1','Add New Invoice','1'),
('695','VR-22-695','2022-08-09 00:00:00','0','1250.00','1','254.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-08-09 21:14:33','2022-08-18 10:30:31',NULL,'1','Update Invoice','1'),
('696','VR-22-696','2022-08-14 00:00:00','0','1250.00','1','60.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-14 10:39:27','2022-08-14 10:39:27',NULL,'1','Add New Invoice','1'),
('697','VR-22-697','2022-08-14 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-14 11:59:13','2022-08-14 11:59:13',NULL,'1','Add New Invoice','1'),
('698','VR-22-698','2022-08-14 00:00:00','0','1250.00','1','98.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-08-14 12:10:50','2022-08-14 12:10:50',NULL,'1','Add New Invoice','1'),
('699','VR-22-699','2022-08-14 00:00:00','0','1250.00','1','855.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-08-14 12:25:38','2022-08-14 12:25:38',NULL,'1','Add New Invoice','1'),
('700','VR-22-700','2022-08-14 00:00:00','0','1250.00','1','67.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-08-14 13:17:38','2022-08-14 13:17:38',NULL,'1','Add New Invoice','1'),
('701','VR-22-701','2022-08-14 00:00:00','0','1250.00','1','180.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-14 14:49:15','2022-08-14 14:49:15',NULL,'1','Add New Invoice','1'),
('702','VR-22-702','2022-08-14 00:00:00','0','1250.00','1','330.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-14 19:40:19','2022-08-14 19:40:19',NULL,'1','Add New Invoice','1'),
('703','VR-22-703','2022-08-14 00:00:00','0','1250.00','1','17330.69','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-08-14 20:51:01','2022-08-14 09:03:11',NULL,'1','Update Invoice','1'),
('704','VR-22-704','2022-08-14 00:00:00','0','1250.00','1','7492.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-08-14 21:56:46','2022-08-14 10:36:32',NULL,'1','Update Invoice','1'),
('705','VR-22-705','2022-08-15 00:00:00','0','1250.00','1','547.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-08-15 10:59:37','2022-08-15 10:59:37',NULL,'1','Add New Invoice','1'),
('706','VR-22-706','2022-08-15 00:00:00','0','1250.00','1','849.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-08-15 11:41:13','2022-08-15 11:41:13',NULL,'1','Add New Invoice','1'),
('707','VR-22-707','2022-08-15 00:00:00','0','1250.00','1','396.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-15 16:23:43','2022-08-15 16:23:43',NULL,'1','Add New Invoice','1'),
('708','VR-22-708','2022-08-15 00:00:00','0','1250.00','1','180.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-15 16:32:17','2022-08-15 16:32:17',NULL,'1','Add New Invoice','1'),
('709','VR-22-709','2022-08-16 00:00:00','0','1250.00','1','271.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-08-16 14:56:47','2022-08-16 14:56:47',NULL,'1','Add New Invoice','1'),
('710','VR-22-710','2022-08-16 00:00:00','0','1250.00','1','187.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-16 20:01:07','2022-08-16 20:01:07',NULL,'1','Add New Invoice','1'),
('711','VR-22-711','2022-08-17 00:00:00','0','1250.00','1','358.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-17 09:25:11','2022-08-17 09:25:11',NULL,'1','Add New Invoice','1'),
('712','VR-22-712','2022-08-17 00:00:00','0','1250.00','1','155.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-17 14:37:00','2022-08-17 14:37:00',NULL,'1','Add New Invoice','1'),
('713','VR-22-713','2022-08-17 00:00:00','0','1250.00','1','3242.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-17 20:11:33','2022-08-17 20:11:33',NULL,'1','Add New Invoice','1'),
('714','VR-22-714','2022-08-17 00:00:00','0','1250.00','1','16813.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-17 21:03:49','2022-08-17 21:03:49',NULL,'1','Add New Invoice','1'),
('715','VR-22-715','2022-08-17 00:00:00','0','1250.00','1','7691.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-17 21:38:44','2022-08-17 09:40:56',NULL,'1','Update Invoice','1'),
('716','VR-22-716','2022-08-17 00:00:00','0','1250.00','1','1406.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-17 21:44:01','2022-08-17 21:44:01',NULL,'1','Add New Invoice','1'),
('717','VR-22-717','2022-08-17 00:00:00','0','1250.00','1','6266.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-17 22:09:11','2022-08-17 22:09:11',NULL,'1','Add New Invoice','1'),
('718','VR-22-718','2022-08-18 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-08-18 14:44:04','2022-08-18 14:44:04',NULL,'1','Add New Invoice','1'),
('719','VR-22-719','2022-08-18 00:00:00','0','1250.00','1','4430.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-08-18 15:14:36','2022-08-18 15:14:36',NULL,'1','Add New Invoice','1'),
('720','VR-22-720','2022-08-18 00:00:00','0','1250.00','1','75.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-18 17:22:34','2022-08-18 05:38:07',NULL,'1','Update Invoice','1'),
('721','VR-22-721','2022-08-18 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-08-18 17:25:06','2022-08-18 17:25:06',NULL,'1','Add New Invoice','1'),
('722','VR-22-722','2022-08-18 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-08-18 18:15:50','2022-08-18 18:15:50',NULL,'1','Add New Invoice','1'),
('723','VR-22-723','2022-08-20 00:00:00','0','1250.00','1','1100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-08-20 10:00:06','2022-08-20 10:00:06',NULL,'1','Add New Invoice','1'),
('724','VR-22-724','2022-08-20 00:00:00','0','1250.00','1','222.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-20 13:21:52','2022-08-20 13:21:52',NULL,'1','Add New Invoice','1'),
('725','VR-22-725','2022-08-20 00:00:00','0','1250.00','1','176.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-20 14:46:15','2022-08-20 14:46:15',NULL,'1','Add New Invoice','1'),
('726','VR-22-726','2022-08-20 00:00:00','0','1250.00','1','6636.29','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-20 17:56:19','2022-08-21 01:12:52',NULL,'1','Update Invoice','1'),
('727','VR-22-727','2022-08-20 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-08-20 20:35:08','2022-08-20 20:35:08',NULL,'1','Add New Invoice','1'),
('728','VR-22-728','2022-08-20 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-20 20:36:37','2022-08-20 20:36:37',NULL,'1','Add New Invoice','1'),
('729','VR-22-729','2022-08-20 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-20 20:41:10','2022-08-20 20:41:10',NULL,'1','Add New Invoice','1'),
('730','VR-22-730','2022-08-20 00:00:00','0','1250.00','1','113.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-20 20:43:00','2022-08-20 08:44:11',NULL,'1','Update Invoice','1'),
('731','VR-22-731','2022-08-20 00:00:00','0','1250.00','1','957.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-08-20 20:50:19','2022-08-20 20:50:19',NULL,'1','Add New Invoice','1'),
('732','VR-22-732','2022-08-20 00:00:00','0','1250.00','1','20.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-20 20:53:59','2022-08-20 20:53:59',NULL,'1','Add New Invoice','1'),
('733','VR-22-733','2022-08-21 00:00:00','0','1250.00','1','124.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-08-21 14:46:51','2022-08-21 14:46:51',NULL,'1','Add New Invoice','1'),
('734','VR-22-734','2022-08-21 00:00:00','0','1250.00','1','6519.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-08-21 23:04:19','2022-08-21 11:06:19',NULL,'1','Update Invoice','1'),
('735','VR-22-735','2022-08-22 00:00:00','0','1250.00','1','154.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-08-22 12:52:08','2022-08-22 12:52:08',NULL,'1','Add New Invoice','1'),
('736','VR-22-736','2022-08-22 00:00:00','0','1250.00','1','691.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-08-22 13:22:05','2022-08-22 13:22:05',NULL,'1','Add New Invoice','1'),
('737','VR-22-737','2022-08-22 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-08-22 17:21:50','2022-08-22 17:21:50',NULL,'1','Add New Invoice','1'),
('738','VR-22-738','2022-08-22 00:00:00','0','1250.00','1','194.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-08-22 17:58:14','2022-08-22 17:58:14',NULL,'1','Add New Invoice','1'),
('739','VR-22-739','2022-08-23 00:00:00','0','1250.00','1','502.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-23 15:21:24','2022-08-23 15:21:24',NULL,'1','Add New Invoice','1'),
('740','VR-22-740','2022-08-23 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','1','2022-08-23 16:10:12','2022-08-23 16:10:12','2022-08-23 04:28:08','1','Delete Invoice','1'),
('748','VR-22-741','2022-08-23 00:00:00','0','1250.00','1','3366.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-08-23 20:39:57','2023-02-28 12:01:27',NULL,'1','Update Invoice','1'),
('752','VR-22-749','2022-08-23 00:00:00','0','1250.00','1','4359.29','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-08-23 20:51:25','2023-02-28 11:57:29',NULL,'1','Update Invoice','1'),
('753','VR-22-753','2022-08-23 00:00:00','0','1250.00','1','6260.34','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-08-23 21:03:02','2023-02-28 11:51:54',NULL,'1','Update Invoice','1'),
('754','VR-22-754','2022-08-23 00:00:00','0','1250.00','1','6448.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-08-23 21:35:41','2023-02-28 11:26:59',NULL,'1','Update Invoice','1'),
('755','VR-22-755','2022-08-24 00:00:00','0','1250.00','1','400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-08-24 13:51:06','2022-08-24 13:51:06',NULL,'1','Add New Invoice','1'),
('756','VR-22-756','2022-08-25 00:00:00','0','1250.00','1','383.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-08-25 14:23:49','2023-02-28 01:21:12',NULL,'1','Update Invoice','1'),
('757','VR-22-757','2022-08-25 00:00:00','0','1250.00','1','162.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-25 14:30:01','2022-08-25 14:30:01',NULL,'1','Add New Invoice','1'),
('758','VR-22-758','2022-08-26 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-08-26 14:49:30','2022-08-26 14:49:30',NULL,'1','Add New Invoice','1'),
('759','VR-22-759','2022-08-27 00:00:00','0','1250.00','1','538.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-08-27 13:40:00','2022-08-27 13:40:00',NULL,'1','Add New Invoice','1'),
('760','VR-22-760','2022-08-27 00:00:00','0','1250.00','1','168.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-27 13:56:02','2022-08-27 13:56:02',NULL,'1','Add New Invoice','1'),
('761','VR-22-761','2022-08-27 00:00:00','0','1250.00','1','148.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-27 16:20:43','2022-08-27 16:20:43',NULL,'1','Add New Invoice','1'),
('762','VR-22-762','2022-08-27 00:00:00','0','1250.00','1','816.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-08-27 20:25:43','2022-08-27 20:25:43',NULL,'1','Add New Invoice','1'),
('763','VR-22-763','2022-08-28 00:00:00','0','1250.00','1','67.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-28 14:29:12','2022-08-28 14:29:12',NULL,'1','Add New Invoice','1'),
('764','VR-22-764','2022-08-28 00:00:00','0','1250.00','1','171.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-28 16:12:01','2022-08-28 16:12:01',NULL,'1','Add New Invoice','1'),
('765','VR-22-765','2022-08-28 00:00:00','0','1250.00','1','1924.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-08-28 18:35:28','2022-08-28 18:35:28',NULL,'1','Add New Invoice','1'),
('766','VR-22-766','2022-08-28 00:00:00','0','1250.00','1','67.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-08-28 20:26:29','2022-08-28 20:26:29',NULL,'1','Add New Invoice','1'),
('767','VR-22-767','2022-08-29 00:00:00','0','1250.00','1','660.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-29 11:24:51','2022-08-29 11:24:51',NULL,'1','Add New Invoice','1'),
('768','VR-22-768','2022-08-29 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-29 11:46:34','2022-08-29 11:46:34',NULL,'1','Add New Invoice','1'),
('769','VR-22-769','2022-08-30 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-08-30 11:44:46','2022-08-30 11:44:46',NULL,'1','Add New Invoice','1'),
('770','VR-22-770','2022-08-30 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-08-30 11:47:02','2022-08-30 11:47:02',NULL,'1','Add New Invoice','1'),
('771','VR-22-771','2022-08-30 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-08-30 12:52:43','2022-08-30 12:52:43',NULL,'1','Add New Invoice','1'),
('772','VR-22-772','2022-08-30 00:00:00','0','1250.00','1','267.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-08-30 14:15:34','2022-08-30 14:15:34',NULL,'1','Add New Invoice','1'),
('773','VR-22-773','2022-08-31 00:00:00','0','1250.00','1','488.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-08-31 09:44:23','2022-08-31 10:01:15',NULL,'1','Update Invoice','1'),
('774','VR-22-774','2022-08-31 00:00:00','0','1250.00','1','1100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-08-31 14:58:50','2022-08-31 14:58:50',NULL,'1','Add New Invoice','1'),
('775','VR-22-775','2022-09-01 00:00:00','0','1250.00','1','318.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-01 12:09:44','2022-09-01 01:27:02',NULL,'1','Update Invoice','1'),
('776','VR-22-776','2022-09-01 00:00:00','0','1250.00','1','302.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-01 13:29:20','2022-09-01 13:29:20',NULL,'1','Add New Invoice','1'),
('777','VR-22-777','2022-09-01 00:00:00','0','1250.00','1','880.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-09-01 14:30:55','2022-09-01 14:30:55',NULL,'1','Add New Invoice','1'),
('778','VR-22-778','2022-09-01 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-01 14:31:30','2022-09-01 14:31:30',NULL,'1','Add New Invoice','1'),
('779','VR-22-779','2022-09-01 00:00:00','0','1250.00','1','89.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-09-01 16:24:38','2022-09-01 16:24:38',NULL,'1','Add New Invoice','1'),
('780','VR-22-780','2022-09-01 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-09-01 20:46:54','2022-09-01 20:46:54',NULL,'1','Add New Invoice','1'),
('781','VR-22-781','2022-09-03 00:00:00','0','1250.00','1','29.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-09-03 09:47:41','2022-09-03 09:47:41',NULL,'1','Add New Invoice','1'),
('782','VR-22-782','2022-09-03 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-03 10:14:40','2022-09-03 10:14:40',NULL,'1','Add New Invoice','1'),
('783','VR-22-783','2022-09-03 00:00:00','0','1250.00','1','125.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-03 15:37:35','2022-09-03 15:37:35',NULL,'1','Add New Invoice','1'),
('784','VR-22-784','2022-09-03 00:00:00','0','1250.00','1','384.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-03 16:16:55','2022-09-03 05:13:08',NULL,'1','Update Invoice','1'),
('785','VR-22-785','2022-09-04 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-04 11:09:22','2022-09-04 11:09:22',NULL,'1','Add New Invoice','1'),
('786','VR-22-786','2022-09-04 00:00:00','0','1250.00','1','286.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-04 12:04:11','2022-09-04 12:04:11',NULL,'1','Add New Invoice','1'),
('787','VR-22-787','2022-09-04 00:00:00','0','1250.00','1','734.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-04 12:44:11','2022-09-19 08:08:01',NULL,'1','Update Invoice','1'),
('788','VR-22-788','2022-09-04 00:00:00','0','1250.00','1','5443.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-04 13:58:44','2022-09-04 13:58:44',NULL,'1','Add New Invoice','1'),
('789','VR-22-789','2022-09-04 00:00:00','0','1250.00','1','8661.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-09-04 15:04:13','2022-09-04 15:04:13',NULL,'1','Add New Invoice','1'),
('790','VR-22-790','2022-09-04 00:00:00','0','1250.00','1','1625.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-04 16:29:09','2022-09-04 16:29:09',NULL,'1','Add New Invoice','1'),
('791','VR-22-791','2022-09-05 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-09-05 14:12:23','2022-09-05 14:12:23',NULL,'1','Add New Invoice','1'),
('792','VR-22-792','2022-09-05 00:00:00','0','1250.00','1','523.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-09-05 14:42:56','2022-09-05 14:42:56',NULL,'1','Add New Invoice','1'),
('793','VR-22-793','2022-09-06 00:00:00','0','1250.00','1','670.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-06 10:31:13','2022-09-19 08:09:55',NULL,'1','Update Invoice','1'),
('794','VR-22-794','2022-09-06 00:00:00','0','1250.00','1','204.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-06 11:17:11','2022-09-06 11:17:11',NULL,'1','Add New Invoice','1'),
('795','VR-22-795','2022-09-06 00:00:00','0','1250.00','1','495.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-09-06 11:21:03','2022-09-06 11:21:03',NULL,'1','Add New Invoice','1'),
('796','VR-22-796','2022-09-06 00:00:00','0','1250.00','1','905.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-06 11:28:48','2022-09-06 11:28:48',NULL,'1','Add New Invoice','1'),
('797','VR-22-797','2022-09-06 00:00:00','0','1250.00','1','46.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-09-06 12:10:45','2022-09-06 12:10:45',NULL,'1','Add New Invoice','1'),
('798','VR-22-798','2022-09-06 00:00:00','0','1250.00','1','346.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-06 13:03:36','2022-09-06 13:03:36',NULL,'1','Add New Invoice','1'),
('799','VR-22-799','2022-09-06 00:00:00','0','1250.00','1','67.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-06 15:45:46','2022-09-06 15:45:46',NULL,'1','Add New Invoice','1'),
('800','VR-22-800','2022-09-06 00:00:00','0','1250.00','1','140.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-09-06 15:47:15','2022-09-06 15:47:15',NULL,'1','Add New Invoice','1'),
('801','VR-22-801','2022-09-07 00:00:00','0','1250.00','1','149.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-07 10:07:07','2022-09-07 10:07:07',NULL,'1','Add New Invoice','1'),
('802','VR-22-802','2022-09-07 00:00:00','0','1250.00','1','816.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-07 11:51:57','2022-09-07 11:51:57',NULL,'1','Add New Invoice','1'),
('803','VR-22-803','2022-09-07 00:00:00','0','1250.00','1','1338.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-07 11:55:08','2022-09-07 11:55:08',NULL,'1','Add New Invoice','1'),
('804','VR-22-804','2022-09-07 00:00:00','0','1250.00','1','156.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-09-07 13:19:14','2022-09-07 13:19:14',NULL,'1','Add New Invoice','1'),
('805','VR-22-805','2022-09-07 00:00:00','0','1250.00','1','131.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-09-07 15:07:25','2022-09-07 15:07:25',NULL,'1','Add New Invoice','1'),
('806','VR-22-806','2022-09-07 00:00:00','0','1250.00','1','306.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-07 16:09:53','2022-09-07 16:09:53',NULL,'1','Add New Invoice','1'),
('807','VR-22-807','2022-09-08 00:00:00','0','1250.00','1','26.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-09-08 10:25:11','2022-09-08 10:25:11',NULL,'1','Add New Invoice','1'),
('808','VR-22-808','2022-09-08 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-09-08 11:40:36','2022-09-08 11:41:56',NULL,'1','Update Invoice','1'),
('809','VR-22-809','2022-09-08 00:00:00','0','1250.00','1','153.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-09-08 13:25:43','2022-09-08 13:25:43',NULL,'1','Add New Invoice','1'),
('810','VR-22-810','2022-09-10 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-10 12:56:58','2022-09-10 12:56:58',NULL,'1','Add New Invoice','1'),
('811','VR-22-811','2022-09-10 00:00:00','0','1250.00','1','25.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-09-10 12:59:41','2022-09-10 12:59:41',NULL,'1','Add New Invoice','1'),
('812','VR-22-812','2022-09-10 00:00:00','0','1250.00','1','95.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-10 13:17:37','2022-09-10 13:17:37',NULL,'1','Add New Invoice','1'),
('813','VR-22-813','2022-09-10 00:00:00','0','1250.00','1','10.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-10 13:27:26','2022-09-19 08:11:05',NULL,'1','Update Invoice','1'),
('814','VR-22-814','2022-09-11 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-11 10:17:18','2022-09-11 10:17:18',NULL,'1','Add New Invoice','1'),
('815','VR-22-815','2022-09-11 00:00:00','0','1250.00','1','279.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-11 12:22:27','2022-09-11 12:22:27',NULL,'1','Add New Invoice','1'),
('816','VR-22-816','2022-09-11 00:00:00','0','1250.00','1','631.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-11 13:18:42','2022-09-11 13:18:42',NULL,'1','Add New Invoice','1'),
('817','VR-22-817','2022-09-11 00:00:00','0','1250.00','1','660.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-09-11 14:41:48','2022-09-11 14:41:48',NULL,'1','Add New Invoice','1'),
('818','VR-22-818','2022-09-11 00:00:00','0','1250.00','1','165.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-09-11 14:54:29','2022-09-11 14:54:29',NULL,'1','Add New Invoice','1'),
('819','VR-22-819','2022-09-11 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-11 14:56:49','2022-09-11 14:56:49',NULL,'1','Add New Invoice','1'),
('820','VR-22-820','2022-09-11 00:00:00','0','1250.00','1','76.00','0.00','تول','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-09-11 14:58:09','2022-09-11 14:58:09',NULL,'1','Add New Invoice','1'),
('821','VR-22-821','2022-09-17 00:00:00','0','1250.00','1','156.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-17 09:18:14','2022-09-19 08:15:48',NULL,'1','Update Invoice','1'),
('823','VR-22-822','2022-09-17 00:00:00','0','1250.00','1','1262.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-17 09:49:38','2022-09-19 08:15:00',NULL,'1','Update Invoice','1'),
('824','VR-22-824','2022-09-17 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-09-17 09:58:14','2022-09-17 09:58:14',NULL,'1','Add New Invoice','1'),
('825','VR-22-825','2022-09-17 00:00:00','0','1250.00','1','72.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-09-17 09:59:39','2022-09-17 09:59:39',NULL,'1','Add New Invoice','1'),
('826','VR-22-826','2022-09-17 00:00:00','0','1250.00','1','281.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-17 10:00:38','2022-09-17 10:00:38',NULL,'1','Add New Invoice','1'),
('827','VR-22-827','2022-09-17 00:00:00','0','1250.00','1','289.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-09-17 10:08:58','2022-09-17 10:08:58',NULL,'1','Add New Invoice','1'),
('828','VR-22-828','2022-09-17 00:00:00','0','1250.00','1','221.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-17 11:08:15','2022-09-17 11:08:15',NULL,'1','Add New Invoice','1'),
('829','VR-22-829','2022-09-17 00:00:00','0','1250.00','1','116.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-09-17 11:10:22','2022-09-17 11:10:22',NULL,'1','Add New Invoice','1'),
('830','VR-22-830','2022-09-17 00:00:00','0','1250.00','1','248.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-17 11:11:19','2022-09-17 11:11:19',NULL,'1','Add New Invoice','1'),
('831','VR-22-831','2022-09-17 00:00:00','0','1250.00','1','163.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-17 11:17:32','2022-09-17 11:17:32',NULL,'1','Add New Invoice','1'),
('832','VR-22-832','2022-09-17 00:00:00','0','1250.00','1','1160.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-17 11:29:21','2022-09-17 04:15:12',NULL,'1','Update Invoice','1'),
('833','VR-22-833','2022-09-17 00:00:00','0','1250.00','1','15.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-09-17 11:32:34','2022-09-17 11:32:34',NULL,'1','Add New Invoice','1'),
('834','VR-22-834','2022-09-17 00:00:00','0','1250.00','1','212.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-09-17 11:39:47','2022-09-17 11:39:47',NULL,'1','Add New Invoice','1'),
('835','VR-22-835','2022-09-17 00:00:00','0','1250.00','1','277.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-17 11:41:57','2022-09-17 11:41:57',NULL,'1','Add New Invoice','1'),
('836','VR-22-836','2022-09-17 00:00:00','0','1250.00','1','245.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-09-17 11:51:09','2022-09-17 11:51:57',NULL,'1','Update Invoice','1'),
('837','VR-22-837','2022-09-17 00:00:00','0','1250.00','1','137.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-17 11:52:55','2022-09-17 11:52:55',NULL,'1','Add New Invoice','1'),
('838','VR-22-838','2022-09-17 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-09-17 11:53:26','2022-09-17 11:53:26',NULL,'1','Add New Invoice','1'),
('839','VR-22-839','2022-09-17 00:00:00','0','1250.00','1','1439.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-17 11:58:20','2022-09-17 11:58:20',NULL,'1','Add New Invoice','1'),
('840','VR-22-840','2022-09-17 00:00:00','0','1250.00','1','2309.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2022-09-17 14:01:13','2022-09-17 02:08:27',NULL,'1','Update Invoice','1'),
('841','VR-22-841','2022-09-17 00:00:00','0','1250.00','1','326.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-09-17 14:51:24','2022-09-17 14:51:24',NULL,'1','Add New Invoice','1'),
('842','VR-22-842','2022-09-17 00:00:00','0','1250.00','1','265.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-17 16:12:12','2022-09-17 16:12:12',NULL,'1','Add New Invoice','1'),
('843','VR-22-843','2022-09-17 00:00:00','0','1250.00','1','500.20','0.00','A2','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-09-17 16:17:35','2022-09-17 16:17:35',NULL,'1','Add New Invoice','1'),
('844','VR-22-844','2022-09-18 00:00:00','0','1250.00','1','159.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-09-18 11:02:16','2022-09-18 11:32:49',NULL,'1','Update Invoice','1'),
('845','VR-22-845','2022-09-18 00:00:00','0','1250.00','1','287.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-09-18 11:13:46','2022-09-18 11:13:46',NULL,'1','Add New Invoice','1'),
('846','VR-22-846','2022-09-18 00:00:00','0','1250.00','1','195.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-09-18 11:49:01','2022-09-18 11:49:01',NULL,'1','Add New Invoice','1'),
('847','VR-22-847','2022-09-18 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-09-18 12:04:35','2022-09-18 12:04:35',NULL,'1','Add New Invoice','1'),
('848','VR-22-848','2022-09-18 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-18 12:06:18','2022-09-18 12:06:18',NULL,'1','Add New Invoice','1'),
('849','VR-22-849','2022-09-18 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-09-18 15:10:54','2022-09-18 15:10:54',NULL,'1','Add New Invoice','1'),
('850','VR-22-850','2022-09-18 00:00:00','0','1250.00','1','593.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-18 15:16:58','2022-09-18 15:16:58',NULL,'1','Add New Invoice','1'),
('851','VR-22-851','2022-09-18 00:00:00','0','1250.00','1','99.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-18 16:04:00','2022-09-18 16:04:00',NULL,'1','Add New Invoice','1'),
('852','VR-22-852','2022-09-19 00:00:00','0','1250.00','1','275.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-09-19 10:28:16','2022-09-19 10:28:16',NULL,'1','Add New Invoice','1'),
('853','VR-22-853','2022-09-19 00:00:00','0','1250.00','1','206.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-09-19 11:03:21','2022-09-19 11:03:21',NULL,'1','Add New Invoice','1'),
('854','VR-22-854','2022-09-19 00:00:00','0','1250.00','1','264.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-19 17:36:28','2022-09-19 17:36:28',NULL,'1','Add New Invoice','1'),
('855','VR-22-855','2022-09-19 00:00:00','0','1250.00','1','331.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-09-19 18:39:01','2022-09-19 18:39:01',NULL,'1','Add New Invoice','1'),
('856','VR-22-856','2022-09-19 00:00:00','0','1250.00','1','182.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-19 20:27:47','2022-09-19 20:27:47',NULL,'1','Add New Invoice','1'),
('857','VR-22-857','2022-09-20 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-20 12:58:45','2022-09-20 12:58:45',NULL,'1','Add New Invoice','1'),
('858','VR-22-858','2022-09-20 00:00:00','0','1250.00','1','380.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-09-20 13:23:47','2022-09-20 13:23:47',NULL,'1','Add New Invoice','1'),
('859','VR-22-859','2022-09-20 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-09-20 13:29:04','2022-09-20 13:29:04',NULL,'1','Add New Invoice','1'),
('860','VR-22-860','2022-09-20 00:00:00','0','1250.00','1','78.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-09-20 13:36:40','2022-09-20 13:36:40',NULL,'1','Add New Invoice','1'),
('861','VR-22-861','2022-09-20 00:00:00','0','1250.00','1','169.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-09-20 13:38:14','2022-09-20 13:38:14',NULL,'1','Add New Invoice','1'),
('862','VR-22-862','2022-09-20 00:00:00','0','1250.00','1','260.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-20 13:39:57','2022-09-20 13:39:57',NULL,'1','Add New Invoice','1'),
('863','VR-22-863','2022-09-20 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-20 13:47:55','2022-09-20 13:47:55',NULL,'1','Add New Invoice','1'),
('864','VR-22-864','2022-09-20 00:00:00','0','1250.00','1','250.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-20 13:55:24','2022-09-20 13:55:24',NULL,'1','Add New Invoice','1'),
('865','VR-22-865','2022-09-20 00:00:00','0','1250.00','1','586.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-20 13:59:35','2022-09-20 13:59:35',NULL,'1','Add New Invoice','1'),
('866','VR-22-866','2022-09-20 00:00:00','0','1250.00','1','175.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-20 14:22:16','2022-09-20 14:22:16',NULL,'1','Add New Invoice','1'),
('867','VR-22-867','2022-09-21 00:00:00','0','1250.00','1','169.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-21 15:08:23','2022-09-21 15:08:23',NULL,'1','Add New Invoice','1'),
('868','VR-22-868','2022-09-21 00:00:00','0','1250.00','1','281.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-21 17:50:03','2022-09-21 17:50:03',NULL,'1','Add New Invoice','1'),
('869','VR-22-869','2022-09-22 00:00:00','0','1250.00','1','198.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-09-22 11:04:21','2022-09-22 11:04:21',NULL,'1','Add New Invoice','1'),
('870','VR-22-870','2022-09-22 00:00:00','0','1250.00','1','335.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-22 11:55:10','2022-09-22 11:55:10',NULL,'1','Add New Invoice','1'),
('871','VR-22-871','2022-09-22 00:00:00','0','1250.00','1','175.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-09-22 12:23:10','2022-09-22 12:23:10',NULL,'1','Add New Invoice','1'),
('872','VR-22-872','2022-09-22 00:00:00','0','1250.00','1','400.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-22 13:57:09','2022-09-22 13:57:09',NULL,'1','Add New Invoice','1'),
('873','VR-22-873','2022-09-22 00:00:00','0','1250.00','1','175.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-09-22 14:26:10','2022-09-22 14:26:10',NULL,'1','Add New Invoice','1'),
('874','VR-22-874','2022-09-22 00:00:00','0','1250.00','1','243.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-22 16:35:48','2022-09-22 16:35:48',NULL,'1','Add New Invoice','1'),
('875','VR-22-875','2022-09-23 00:00:00','0','1250.00','1','812.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-09-23 17:00:42','2022-09-23 17:00:42',NULL,'1','Add New Invoice','1'),
('876','VR-22-876','2022-09-24 00:00:00','0','1250.00','1','345.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-24 12:29:03','2022-09-24 12:29:03',NULL,'1','Add New Invoice','1'),
('877','VR-22-877','2022-09-24 00:00:00','0','1250.00','1','346.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-24 13:00:46','2022-09-24 13:00:46',NULL,'1','Add New Invoice','1'),
('878','VR-22-878','2022-09-24 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-24 13:09:23','2022-09-24 13:09:23',NULL,'1','Add New Invoice','1'),
('879','VR-22-879','2022-09-24 00:00:00','0','1250.00','1','157.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-09-24 15:19:17','2022-09-24 15:19:17',NULL,'1','Add New Invoice','1'),
('880','VR-22-880','2022-09-24 00:00:00','0','1250.00','1','543.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-24 16:28:07','2022-09-24 16:28:07',NULL,'1','Add New Invoice','1'),
('881','VR-22-881','2022-09-24 00:00:00','0','1250.00','1','181.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-24 16:38:22','2022-09-24 16:38:22',NULL,'1','Add New Invoice','1'),
('882','VR-22-882','2022-09-24 00:00:00','0','1250.00','1','2632.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-24 16:49:28','2022-09-24 16:49:28',NULL,'1','Add New Invoice','1'),
('883','VR-22-883','2022-09-24 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-09-24 18:25:21','2022-09-24 18:25:21',NULL,'1','Add New Invoice','1'),
('884','VR-22-884','2022-09-25 00:00:00','0','1250.00','1','527.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-25 15:25:47','2022-09-25 15:25:47',NULL,'1','Add New Invoice','1'),
('885','VR-22-885','2022-09-25 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-09-25 17:54:03','2022-09-25 17:54:03',NULL,'1','Add New Invoice','1'),
('886','VR-22-886','2022-09-26 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-09-26 12:12:36','2022-09-26 12:12:36',NULL,'1','Add New Invoice','1'),
('887','VR-22-887','2022-09-26 00:00:00','0','1250.00','1','331.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-09-26 12:44:56','2022-09-26 12:44:56',NULL,'1','Add New Invoice','1'),
('888','VR-22-888','2022-09-26 00:00:00','0','1250.00','1','276.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-09-26 12:54:22','2022-09-26 12:54:22',NULL,'1','Add New Invoice','1'),
('889','VR-22-889','2022-09-26 00:00:00','0','1250.00','1','172.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-26 13:00:33','2022-09-26 13:00:33',NULL,'1','Add New Invoice','1'),
('890','VR-22-890','2022-09-26 00:00:00','0','1250.00','1','6.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-09-26 13:04:06','2022-09-26 13:04:06',NULL,'1','Add New Invoice','1'),
('891','VR-22-891','2022-09-26 00:00:00','0','1250.00','1','370.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-09-26 14:43:42','2022-09-26 02:50:39',NULL,'1','Update Invoice','1'),
('892','VR-22-892','2022-09-26 00:00:00','0','1250.00','1','420.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-09-26 15:58:55','2022-09-26 15:58:55',NULL,'1','Add New Invoice','1'),
('893','VR-22-893','2022-09-26 00:00:00','0','1250.00','1','1900.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-26 16:01:06','2022-09-26 16:01:06',NULL,'1','Add New Invoice','1'),
('894','VR-22-894','2022-09-26 00:00:00','0','1250.00','1','258.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-26 18:15:56','2022-09-26 18:15:56',NULL,'1','Add New Invoice','1'),
('895','VR-22-895','2022-09-27 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','1','2022-09-27 09:43:22','2022-09-27 09:43:22','2022-10-03 10:11:15','1','Delete Invoice','1'),
('896','VR-22-896','2022-09-27 00:00:00','0','1250.00','1','1960.59','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-27 10:56:37','2022-09-27 10:56:37',NULL,'1','Add New Invoice','1'),
('897','VR-22-897','2022-09-27 00:00:00','0','1250.00','1','1228.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-27 14:29:30','2022-09-27 14:29:30',NULL,'1','Add New Invoice','1'),
('898','VR-22-898','2022-09-27 00:00:00','0','1250.00','1','204.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-09-27 14:32:40','2022-09-27 14:32:40',NULL,'1','Add New Invoice','1'),
('899','VR-22-899','2022-09-28 00:00:00','0','1250.00','1','278.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-28 16:27:52','2022-09-28 16:27:52',NULL,'1','Add New Invoice','1'),
('900','VR-22-900','2022-09-28 00:00:00','0','1250.00','1','665.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-09-28 16:42:33','2022-09-28 16:42:33',NULL,'1','Add New Invoice','1'),
('901','VR-22-901','2022-09-28 00:00:00','0','1250.00','1','140.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-09-28 16:58:55','2022-09-28 16:58:55',NULL,'1','Add New Invoice','1'),
('902','VR-22-902','2022-09-28 00:00:00','0','1250.00','1','352.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-28 18:00:12','2022-09-28 18:00:12',NULL,'1','Add New Invoice','1'),
('903','VR-22-903','2022-09-29 00:00:00','0','1250.00','1','84.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-09-29 10:16:49','2022-09-29 10:16:49',NULL,'1','Add New Invoice','1'),
('904','VR-22-904','2022-09-29 00:00:00','0','1250.00','1','97.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-09-29 11:00:36','2022-09-29 11:00:36',NULL,'1','Add New Invoice','1'),
('905','VR-22-905','2022-09-29 00:00:00','0','1250.00','1','181.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-09-29 16:36:23','2022-09-29 16:36:23',NULL,'1','Add New Invoice','1'),
('906','VR-22-906','2022-09-29 00:00:00','0','1250.00','1','193.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-09-29 16:48:52','2022-09-29 16:48:52',NULL,'1','Add New Invoice','1'),
('907','VR-22-907','2022-09-29 00:00:00','0','1250.00','1','321.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-09-29 16:52:53','2022-10-03 10:11:31',NULL,'1','Update Invoice','1'),
('908','VR-22-908','2022-09-29 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2022-09-29 17:23:13','2022-09-29 17:23:13',NULL,'1','Add New Invoice','1'),
('909','VR-22-909','2022-09-29 00:00:00','0','1250.00','1','61.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-09-29 18:17:01','2022-09-29 18:17:01',NULL,'1','Add New Invoice','1'),
('910','VR-22-910','2022-09-29 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-09-29 18:23:11','2022-09-29 18:23:11',NULL,'1','Add New Invoice','1'),
('911','VR-22-911','2022-09-29 00:00:00','0','1250.00','1','55.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-09-29 18:30:37','2022-09-29 18:30:37',NULL,'1','Add New Invoice','1'),
('912','VR-22-912','2022-10-01 00:00:00','0','1250.00','1','368.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-01 15:37:23','2022-10-01 15:37:23',NULL,'1','Add New Invoice','1'),
('913','VR-22-913','2022-10-01 00:00:00','0','1250.00','1','247.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-01 16:40:58','2022-10-01 16:40:58',NULL,'1','Add New Invoice','1'),
('914','VR-22-914','2022-10-01 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-10-01 18:22:18','2022-10-01 18:22:18',NULL,'1','Add New Invoice','1'),
('915','VR-22-915','2022-10-01 00:00:00','0','1250.00','1','363.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-01 18:38:08','2022-10-01 18:38:08',NULL,'1','Add New Invoice','1'),
('916','VR-22-916','2022-10-02 00:00:00','0','1250.00','1','965.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-02 11:20:28','2022-10-02 11:20:28',NULL,'1','Add New Invoice','1'),
('917','VR-22-917','2022-10-02 00:00:00','0','1250.00','1','226.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-02 15:02:56','2022-10-02 15:02:56',NULL,'1','Add New Invoice','1'),
('918','VR-22-918','2022-10-02 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-10-02 15:08:16','2022-10-02 15:08:16',NULL,'1','Add New Invoice','1'),
('919','VR-22-919','2022-10-02 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-02 16:32:58','2022-10-02 16:32:58',NULL,'1','Add New Invoice','1'),
('920','VR-22-920','2022-10-02 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-02 18:17:44','2022-10-02 18:17:44',NULL,'1','Add New Invoice','1'),
('921','VR-22-921','2022-10-02 00:00:00','0','1250.00','1','219.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-02 18:22:45','2022-10-02 18:22:45',NULL,'1','Add New Invoice','1'),
('922','VR-22-922','2022-10-03 00:00:00','0','1250.00','1','128.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-03 10:22:48','2022-10-03 10:22:48',NULL,'1','Add New Invoice','1'),
('923','VR-22-923','2022-10-03 00:00:00','0','1250.00','1','472.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-03 11:35:50','2022-10-03 11:35:50',NULL,'1','Add New Invoice','1'),
('924','VR-22-924','2022-10-03 00:00:00','0','1250.00','1','402.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-03 11:55:28','2022-10-03 11:55:28',NULL,'1','Add New Invoice','1'),
('925','VR-22-925','2022-10-03 00:00:00','0','1250.00','1','268.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-03 14:13:43','2022-10-03 14:13:43',NULL,'1','Add New Invoice','1'),
('926','VR-22-926','2022-10-03 00:00:00','0','1250.00','1','250.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-10-03 15:02:52','2022-10-03 15:02:52',NULL,'1','Add New Invoice','1'),
('927','VR-22-927','2022-10-03 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-10-03 16:12:15','2022-10-03 16:12:15',NULL,'1','Add New Invoice','1'),
('928','VR-22-928','2022-10-03 00:00:00','0','1250.00','1','281.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-03 17:30:50','2022-10-03 05:32:54',NULL,'1','Update Invoice','1'),
('929','VR-22-929','2022-10-03 00:00:00','0','1250.00','1','82.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-10-03 17:34:15','2022-10-03 17:34:15',NULL,'1','Add New Invoice','1'),
('930','VR-22-930','2022-10-03 00:00:00','0','1250.00','1','31.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-03 17:41:28','2022-10-03 17:41:28',NULL,'1','Add New Invoice','1'),
('931','VR-22-931','2022-10-04 00:00:00','0','1250.00','1','198.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-04 11:32:36','2022-10-04 11:32:36',NULL,'1','Add New Invoice','1'),
('932','VR-22-932','2022-10-04 00:00:00','0','1250.00','1','1100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-10-04 11:59:49','2022-10-04 11:59:49',NULL,'1','Add New Invoice','1'),
('933','VR-22-933','2022-10-04 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-10-04 12:00:58','2022-10-04 12:00:58',NULL,'1','Add New Invoice','1'),
('934','VR-22-934','2022-10-04 00:00:00','0','1250.00','1','96.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-10-04 16:54:24','2022-10-04 16:54:24',NULL,'1','Add New Invoice','1'),
('935','VR-22-935','2022-10-05 00:00:00','0','1250.00','1','290.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-10-05 11:02:12','2022-10-05 11:02:12',NULL,'1','Add New Invoice','1'),
('936','VR-22-936','2022-10-05 00:00:00','0','1250.00','1','1058.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-05 12:35:08','2022-10-05 12:35:08',NULL,'1','Add New Invoice','1'),
('937','VR-22-937','2022-10-05 00:00:00','0','1250.00','1','4500.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','93','0','2022-10-05 12:57:36','2022-10-05 12:57:36',NULL,'1','Add New Invoice','1'),
('938','VR-22-938','2022-10-05 00:00:00','0','1250.00','1','1808.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-05 13:46:41','2022-10-05 01:47:24',NULL,'1','Update Invoice','1'),
('939','VR-22-939','2022-10-05 00:00:00','0','1250.00','1','133.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-05 14:28:21','2022-10-05 14:28:21',NULL,'1','Add New Invoice','1'),
('940','VR-22-940','2022-10-05 00:00:00','0','1250.00','1','166.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-05 15:38:12','2022-10-05 15:38:12',NULL,'1','Add New Invoice','1'),
('941','VR-22-941','2022-10-05 00:00:00','0','1250.00','1','115.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-10-05 16:56:02','2022-10-05 16:56:02',NULL,'1','Add New Invoice','1'),
('942','VR-22-942','2022-10-05 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-05 16:58:24','2022-10-05 16:58:24',NULL,'1','Add New Invoice','1'),
('943','VR-22-943','2022-10-05 00:00:00','0','1250.00','1','93.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2022-10-05 17:05:05','2022-10-05 17:05:05',NULL,'1','Add New Invoice','1'),
('944','VR-22-944','2022-10-05 00:00:00','0','1250.00','1','161.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-05 17:14:10','2022-10-05 17:14:10',NULL,'1','Add New Invoice','1'),
('945','VR-22-945','2022-10-05 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-10-05 18:42:34','2022-10-05 18:42:34',NULL,'1','Add New Invoice','1'),
('946','VR-22-946','2022-10-05 00:00:00','0','1250.00','1','142.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-05 19:11:01','2022-10-05 19:11:01',NULL,'1','Add New Invoice','1'),
('947','VR-22-947','2022-10-06 00:00:00','0','1250.00','1','1473.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-06 10:16:31','2022-10-06 05:01:44',NULL,'1','Update Invoice','1'),
('948','VR-22-948','2022-10-06 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-06 15:51:41','2022-10-06 15:51:41',NULL,'1','Add New Invoice','1'),
('949','VR-22-949','2022-10-06 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-10-06 15:53:28','2022-10-06 15:53:28',NULL,'1','Add New Invoice','1'),
('950','VR-22-950','2022-10-08 00:00:00','0','1250.00','1','273.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-08 11:39:47','2022-10-08 11:39:47',NULL,'1','Add New Invoice','1'),
('951','VR-22-951','2022-10-08 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-08 11:45:31','2022-10-08 11:45:31',NULL,'1','Add New Invoice','1'),
('952','VR-22-952','2022-10-08 00:00:00','0','1250.00','1','1202.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-08 11:57:06','2022-10-08 11:57:06',NULL,'1','Add New Invoice','1'),
('953','VR-22-953','2022-10-08 00:00:00','0','1250.00','1','1374.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-08 12:03:42','2022-10-13 09:19:16',NULL,'1','Update Invoice','1'),
('954','VR-22-954','2022-10-09 00:00:00','0','1250.00','1','186.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-09 14:38:29','2022-10-09 14:38:29',NULL,'1','Add New Invoice','1'),
('955','VR-22-955','2022-10-09 00:00:00','0','1250.00','1','121.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-09 14:54:39','2022-10-09 14:54:39',NULL,'1','Add New Invoice','1'),
('956','VR-22-956','2022-10-09 00:00:00','0','1250.00','1','562.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-09 16:35:08','2022-10-09 16:35:08',NULL,'1','Add New Invoice','1'),
('957','VR-22-957','2022-10-09 00:00:00','0','1250.00','1','140.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-10-09 17:08:39','2022-10-09 17:08:39',NULL,'1','Add New Invoice','1'),
('958','VR-22-958','2022-10-10 00:00:00','0','1250.00','1','191.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-10-10 10:29:50','2022-10-10 10:29:50',NULL,'1','Add New Invoice','1'),
('959','VR-22-959','2022-10-10 00:00:00','0','1250.00','1','23.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-10 10:56:06','2022-10-10 10:56:06',NULL,'1','Add New Invoice','1'),
('960','VR-22-960','2022-10-11 00:00:00','0','1250.00','1','419.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-11 11:28:09','2022-10-11 11:28:09',NULL,'1','Add New Invoice','1'),
('961','VR-22-961','2022-10-11 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-11 11:41:22','2022-10-11 11:41:22',NULL,'1','Add New Invoice','1'),
('962','VR-22-962','2022-10-11 00:00:00','0','1250.00','1','275.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-10-11 12:37:39','2023-02-28 01:21:40',NULL,'1','Update Invoice','1'),
('963','VR-22-963','2022-10-11 00:00:00','0','1250.00','1','229.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-10-11 15:49:19','2022-10-11 15:49:19',NULL,'1','Add New Invoice','1'),
('964','VR-22-964','2022-10-11 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-11 15:54:10','2022-10-11 15:54:10',NULL,'1','Add New Invoice','1'),
('965','VR-22-965','2022-10-12 00:00:00','0','1250.00','1','143.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-12 10:17:52','2022-10-12 10:17:52',NULL,'1','Add New Invoice','1'),
('966','VR-22-966','2022-10-12 00:00:00','0','1250.00','1','297.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-12 16:25:38','2022-10-12 16:25:38',NULL,'1','Add New Invoice','1'),
('967','VR-22-967','2022-10-13 00:00:00','0','1250.00','1','1038.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-13 21:25:23','2022-10-13 21:25:23',NULL,'1','Add New Invoice','1'),
('968','VR-22-968','2022-10-13 00:00:00','0','1250.00','1','2218.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-10-13 21:52:27','2023-02-28 01:22:11',NULL,'1','Update Invoice','1'),
('969','VR-22-969','2022-10-13 00:00:00','0','1250.00','1','40.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-13 22:22:40','2022-10-13 22:22:40',NULL,'1','Add New Invoice','1'),
('970','VR-22-970','2022-10-14 00:00:00','0','1250.00','1','3100.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-14 15:42:32','2022-10-14 15:42:32',NULL,'1','Add New Invoice','1'),
('971','VR-22-971','2022-10-15 00:00:00','0','1250.00','1','503.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-15 10:37:59','2022-10-15 10:37:59',NULL,'1','Add New Invoice','1'),
('972','VR-22-972','2022-10-15 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-15 12:00:04','2022-10-15 12:00:04',NULL,'1','Add New Invoice','1'),
('973','VR-22-973','2022-10-15 00:00:00','0','1250.00','1','156.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-15 13:10:44','2022-10-15 13:10:44',NULL,'1','Add New Invoice','1'),
('974','VR-22-974','2022-10-15 00:00:00','0','1250.00','1','241.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-10-15 15:58:32','2022-10-15 15:58:32',NULL,'1','Add New Invoice','1'),
('975','VR-22-975','2022-10-15 00:00:00','0','1250.00','1','243.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-10-15 16:00:44','2022-10-15 16:00:44',NULL,'1','Add New Invoice','1'),
('976','VR-22-976','2022-10-15 00:00:00','0','1250.00','1','77.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-15 16:01:25','2022-10-15 04:23:42',NULL,'1','Update Invoice','1'),
('977','VR-22-977','2022-10-15 00:00:00','0','1250.00','1','473.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-15 16:08:43','2022-10-15 16:08:43',NULL,'1','Add New Invoice','1'),
('978','VR-22-978','2022-10-15 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-15 16:22:19','2022-10-15 16:22:19',NULL,'1','Add New Invoice','1'),
('979','VR-22-979','2022-10-15 00:00:00','0','1250.00','1','6.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-10-15 16:24:18','2022-10-15 16:24:18',NULL,'1','Add New Invoice','1'),
('980','VR-22-980','2022-10-15 00:00:00','0','1250.00','1','263.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-10-15 16:25:52','2022-10-15 04:42:32',NULL,'1','Update Invoice','1'),
('981','VR-22-981','2022-10-15 00:00:00','0','1250.00','1','410.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-15 16:53:49','2022-10-15 16:53:49',NULL,'1','Add New Invoice','1'),
('982','VR-22-982','2022-10-15 00:00:00','0','1250.00','1','212.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-10-15 17:01:28','2022-10-19 05:01:52',NULL,'1','Update Invoice','1'),
('983','VR-22-983','2022-10-16 00:00:00','0','1250.00','1','170.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-16 10:29:23','2022-10-16 10:29:23',NULL,'1','Add New Invoice','1'),
('984','VR-22-984','2022-10-16 00:00:00','0','1250.00','1','346.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-16 11:40:24','2022-10-16 11:40:24',NULL,'1','Add New Invoice','1'),
('985','VR-22-985','2022-10-17 00:00:00','0','1250.00','1','155.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-10-17 13:51:58','2022-10-17 13:51:58',NULL,'1','Add New Invoice','1'),
('986','VR-22-986','2022-10-17 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-17 14:22:27','2022-10-17 14:22:27',NULL,'1','Add New Invoice','1'),
('987','VR-22-987','2022-10-17 00:00:00','0','1250.00','1','41.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-10-17 14:30:36','2022-10-17 14:30:36',NULL,'1','Add New Invoice','1'),
('988','VR-22-988','2022-10-17 00:00:00','0','1250.00','1','63.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-17 14:33:39','2022-10-17 14:33:39',NULL,'1','Add New Invoice','1'),
('989','VR-22-989','2022-10-17 00:00:00','0','1250.00','1','89.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-10-17 14:36:55','2022-10-17 14:36:55',NULL,'1','Add New Invoice','1'),
('990','VR-22-990','2022-10-17 00:00:00','0','1250.00','1','644.80','0.00','مدينة الصدر','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-17 14:59:10','2022-10-17 14:59:10',NULL,'1','Add New Invoice','1'),
('991','VR-22-991','2022-10-17 00:00:00','0','1250.00','1','745.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-17 15:03:43','2022-10-17 15:03:43',NULL,'1','Add New Invoice','1'),
('992','VR-22-992','2022-10-17 00:00:00','0','1250.00','1','1559.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-17 15:07:25','2022-10-17 15:07:25',NULL,'1','Add New Invoice','1'),
('993','VR-22-993','2022-10-18 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-18 15:00:10','2022-10-18 15:00:10',NULL,'1','Add New Invoice','1'),
('994','VR-22-994','2022-10-18 00:00:00','0','1250.00','1','787.32','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-18 15:04:29','2022-10-18 15:04:29',NULL,'1','Add New Invoice','1'),
('995','VR-22-995','2022-10-18 00:00:00','0','1250.00','1','298.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-18 16:33:07','2022-10-18 16:33:07',NULL,'1','Add New Invoice','1'),
('996','VR-22-996','2022-10-19 00:00:00','0','1250.00','1','1204.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-19 14:39:48','2022-10-19 14:39:48',NULL,'1','Add New Invoice','1'),
('997','VR-22-997','2022-10-19 00:00:00','0','1250.00','1','417.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-19 14:43:17','2022-10-19 14:43:17',NULL,'1','Add New Invoice','1'),
('998','VR-22-998','2022-10-19 00:00:00','0','1250.00','1','88.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-10-19 17:01:19','2022-10-19 17:01:19',NULL,'1','Add New Invoice','1'),
('999','VR-22-999','2022-10-19 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-19 17:03:36','2022-10-19 17:03:36',NULL,'1','Add New Invoice','1'),
('1000','VR-22-1000','2022-10-19 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-10-19 17:17:45','2022-10-19 17:17:45',NULL,'1','Add New Invoice','1'),
('1001','VR-22-1001','2022-10-19 00:00:00','0','1250.00','1','46.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-19 17:18:44','2022-10-19 17:18:44',NULL,'1','Add New Invoice','1'),
('1002','VR-22-1002','2022-10-19 00:00:00','0','1250.00','1','110.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-10-19 17:20:07','2022-10-19 17:20:07',NULL,'1','Add New Invoice','1'),
('1003','VR-22-1003','2022-10-19 00:00:00','0','1250.00','1','123.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-10-19 17:26:53','2023-02-28 01:22:54',NULL,'1','Update Invoice','1'),
('1004','VR-22-1004','2022-10-19 00:00:00','0','1250.00','1','490.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-19 17:41:26','2022-10-19 17:41:26',NULL,'1','Add New Invoice','1'),
('1005','VR-22-1005','2022-10-20 00:00:00','0','1250.00','1','1067.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-20 11:57:09','2022-10-20 11:57:09',NULL,'1','Add New Invoice','1'),
('1006','VR-22-1006','2022-10-20 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-10-20 11:59:42','2022-10-20 11:59:42',NULL,'1','Add New Invoice','1'),
('1007','VR-22-1007','2022-10-20 00:00:00','0','1250.00','1','554.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-20 12:09:36','2022-10-20 12:09:36',NULL,'1','Add New Invoice','1'),
('1008','VR-22-1008','2022-10-20 00:00:00','0','1250.00','1','210.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-20 14:57:11','2022-10-20 14:57:11',NULL,'1','Add New Invoice','1'),
('1009','VR-22-1009','2022-10-20 00:00:00','0','1250.00','1','284.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-10-20 15:00:23','2023-02-28 01:23:51',NULL,'1','Update Invoice','1'),
('1010','VR-22-1010','2022-10-20 00:00:00','0','1250.00','1','729.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-20 16:11:45','2022-10-24 04:20:03',NULL,'1','Update Invoice','1'),
('1011','VR-22-1011','2022-10-20 00:00:00','0','1250.00','1','974.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-10-20 16:39:04','2022-10-20 16:39:04',NULL,'1','Add New Invoice','1'),
('1012','VR-22-1012','2022-10-22 00:00:00','0','1250.00','1','258.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-22 16:31:14','2022-10-22 16:31:14',NULL,'1','Add New Invoice','1'),
('1013','VR-22-1013','2022-10-22 00:00:00','0','1250.00','1','232.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-22 18:09:39','2022-10-22 18:09:39',NULL,'1','Add New Invoice','1'),
('1014','VR-22-1014','2022-10-22 00:00:00','0','1250.00','1','791.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-22 18:20:29','2022-10-22 18:20:29',NULL,'1','Add New Invoice','1'),
('1015','VR-22-1015','2022-10-22 00:00:00','0','1250.00','1','292.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-10-22 18:36:33','2022-10-22 18:36:33',NULL,'1','Add New Invoice','1'),
('1016','VR-22-1016','2022-10-22 00:00:00','0','1250.00','1','218.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-22 18:41:16','2022-10-22 18:41:16',NULL,'1','Add New Invoice','1'),
('1017','VR-22-1017','2022-10-22 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-22 18:43:08','2022-10-22 18:43:08',NULL,'1','Add New Invoice','1'),
('1018','VR-22-1018','2022-10-23 00:00:00','0','1250.00','1','289.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-23 09:32:44','2022-10-23 09:41:01',NULL,'1','Update Invoice','1'),
('1019','VR-22-1019','2022-10-23 00:00:00','0','1250.00','1','159.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-23 09:34:33','2022-10-23 09:34:33',NULL,'1','Add New Invoice','1'),
('1020','VR-22-1020','2022-10-23 00:00:00','0','1250.00','1','343.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-10-23 10:19:35','2023-02-28 01:24:22',NULL,'1','Update Invoice','1'),
('1021','VR-22-1021','2022-10-23 00:00:00','0','1250.00','1','2382.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-23 10:28:44','2022-10-23 10:28:44',NULL,'1','Add New Invoice','1'),
('1022','VR-22-1022','2022-10-23 00:00:00','0','1250.00','1','225.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-23 10:32:06','2022-10-23 10:32:06',NULL,'1','Add New Invoice','1'),
('1023','VR-22-1023','2022-10-23 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-23 12:12:20','2022-10-23 12:12:20',NULL,'1','Add New Invoice','1'),
('1024','VR-22-1024','2022-10-23 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-10-23 12:53:46','2022-10-23 12:53:46',NULL,'1','Add New Invoice','1'),
('1025','VR-22-1025','2022-10-23 00:00:00','0','1250.00','1','668.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-10-23 13:07:28','2023-02-28 01:25:30',NULL,'1','Update Invoice','1'),
('1026','VR-22-1026','2022-10-23 00:00:00','0','1250.00','1','258.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-23 13:10:07','2022-10-23 13:10:07',NULL,'1','Add New Invoice','1'),
('1027','VR-22-1027','2022-10-23 00:00:00','0','1250.00','1','117.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-23 13:45:39','2022-10-23 13:45:39',NULL,'1','Add New Invoice','1'),
('1028','VR-22-1028','2022-10-23 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-23 13:57:57','2022-10-23 13:57:57',NULL,'1','Add New Invoice','1'),
('1029','VR-22-1029','2022-10-23 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-23 14:09:47','2022-10-23 14:09:47',NULL,'1','Add New Invoice','1'),
('1030','VR-22-1030','2022-10-23 00:00:00','0','1250.00','1','1091.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-23 14:26:44','2022-10-23 14:26:44',NULL,'1','Add New Invoice','1'),
('1031','VR-22-1031','2022-10-23 00:00:00','0','1250.00','1','219.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-23 15:05:20','2022-10-23 15:05:20',NULL,'1','Add New Invoice','1'),
('1032','VR-22-1032','2022-10-23 00:00:00','0','1250.00','1','16.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-23 15:19:42','2022-10-23 15:19:42',NULL,'1','Add New Invoice','1'),
('1033','VR-22-1033','2022-10-23 00:00:00','0','1250.00','1','124.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-23 17:39:47','2022-10-23 17:39:47',NULL,'1','Add New Invoice','1'),
('1034','VR-22-1034','2022-10-24 00:00:00','0','1250.00','1','119.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-24 10:35:26','2022-10-24 10:35:26',NULL,'1','Add New Invoice','1'),
('1035','VR-22-1035','2022-10-24 00:00:00','0','1250.00','1','469.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-10-24 12:38:34','2022-10-24 12:38:34',NULL,'1','Add New Invoice','1'),
('1036','VR-22-1036','2022-10-24 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-24 12:44:27','2022-10-24 12:44:27',NULL,'1','Add New Invoice','1'),
('1037','VR-22-1037','2022-10-24 00:00:00','0','1250.00','1','135.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-10-24 13:11:36','2022-10-24 13:11:36',NULL,'1','Add New Invoice','1'),
('1038','VR-22-1038','2022-10-24 00:00:00','0','1250.00','1','351.90','0.00','احمد ستائر الياسمين نجف ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-24 15:20:56','2022-10-24 15:20:56',NULL,'1','Add New Invoice','1'),
('1039','VR-22-1039','2022-10-24 00:00:00','0','1250.00','1','1474.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-24 15:26:16','2022-10-24 15:26:16',NULL,'1','Add New Invoice','1'),
('1040','VR-22-1040','2022-10-24 00:00:00','0','1250.00','1','71.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-24 16:46:22','2022-10-24 16:46:22',NULL,'1','Add New Invoice','1'),
('1041','VR-22-1041','2022-10-25 00:00:00','0','1250.00','1','178.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-25 10:32:51','2022-10-25 10:32:51',NULL,'1','Add New Invoice','1'),
('1042','VR-22-1042','2022-10-25 00:00:00','0','1250.00','1','136.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-10-25 10:44:45','2022-10-25 10:44:45',NULL,'1','Add New Invoice','1'),
('1043','VR-22-1043','2022-10-25 00:00:00','0','1250.00','1','55.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-25 10:50:53','2022-10-25 10:50:53',NULL,'1','Add New Invoice','1'),
('1044','VR-22-1044','2022-10-25 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-10-25 10:55:43','2022-10-25 10:55:43',NULL,'1','Add New Invoice','1'),
('1045','VR-22-1045','2022-10-25 00:00:00','0','1250.00','1','467.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-10-25 14:49:08','2022-10-25 14:49:08',NULL,'1','Add New Invoice','1'),
('1046','VR-22-1046','2022-10-25 00:00:00','0','1250.00','1','1000.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-25 15:01:53','2022-10-25 15:01:53',NULL,'1','Add New Invoice','1'),
('1047','VR-22-1047','2022-10-25 00:00:00','0','1250.00','1','2045.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-25 15:12:49','2022-10-25 15:12:49',NULL,'1','Add New Invoice','1'),
('1048','VR-22-1048','2022-10-25 00:00:00','0','1250.00','1','479.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-25 17:00:35','2022-10-25 05:59:43',NULL,'1','Update Invoice','1'),
('1049','VR-22-1049','2022-10-26 00:00:00','0','1250.00','1','272.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-10-26 11:38:04','2022-10-26 11:38:04',NULL,'1','Add New Invoice','1'),
('1050','VR-22-1050','2022-10-26 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-10-26 11:45:07','2022-10-26 11:45:07',NULL,'1','Add New Invoice','1'),
('1051','VR-22-1051','2022-10-26 00:00:00','0','1250.00','1','74.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-26 17:34:23','2022-10-26 17:34:23',NULL,'1','Add New Invoice','1'),
('1052','VR-22-1052','2022-10-26 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-10-26 17:36:20','2022-10-26 17:36:20',NULL,'1','Add New Invoice','1'),
('1053','VR-22-1053','2022-10-26 00:00:00','0','1250.00','1','76.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-26 17:39:25','2022-10-26 17:39:25',NULL,'1','Add New Invoice','1'),
('1054','VR-22-1054','2022-10-26 00:00:00','0','1250.00','1','1548.79','0.00','ناصرية سوق الشيوخ  صادق الحاج غازي ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-26 17:58:56','2022-10-26 17:58:56',NULL,'1','Add New Invoice','1'),
('1055','VR-22-1055','2022-10-27 00:00:00','0','1250.00','1','303.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','1','2022-10-27 12:34:14','2022-10-27 12:34:14','2022-10-27 12:35:03','1','Delete Invoice','1'),
('1056','VR-22-1056','2022-10-27 00:00:00','0','1250.00','1','50.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-10-27 14:18:51','2022-10-27 14:18:51',NULL,'1','Add New Invoice','1'),
('1057','VR-22-1057','2022-10-27 00:00:00','0','1250.00','1','65.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-27 17:01:22','2022-10-27 17:01:22',NULL,'1','Add New Invoice','1'),
('1058','VR-22-1058','2022-10-27 00:00:00','0','1250.00','1','784.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-27 19:04:45','2022-10-27 19:04:45',NULL,'1','Add New Invoice','1'),
('1059','VR-22-1059','2022-10-29 00:00:00','0','1250.00','1','217.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-10-29 11:55:28','2022-10-29 11:55:28',NULL,'1','Add New Invoice','1'),
('1060','VR-22-1060','2022-10-29 00:00:00','0','1250.00','1','233.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-29 13:10:30','2022-10-29 13:10:30',NULL,'1','Add New Invoice','1'),
('1061','VR-22-1061','2022-10-29 00:00:00','0','1250.00','1','387.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-29 14:36:40','2022-10-29 14:36:40',NULL,'1','Add New Invoice','1'),
('1062','VR-22-1062','2022-10-29 00:00:00','0','1250.00','1','124.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-10-29 15:03:28','2022-10-29 15:03:28',NULL,'1','Add New Invoice','1'),
('1063','VR-22-1063','2022-10-29 00:00:00','0','1250.00','1','65.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-29 22:08:30','2022-10-29 22:08:30',NULL,'1','Add New Invoice','1'),
('1064','VR-22-1064','2022-10-29 00:00:00','0','1250.00','1','138.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-10-29 22:17:03','2022-10-29 22:17:03',NULL,'1','Add New Invoice','1'),
('1065','VR-22-1065','2022-10-29 00:00:00','0','1250.00','1','76.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-10-29 22:18:05','2022-10-29 22:18:05',NULL,'1','Add New Invoice','1'),
('1066','VR-22-1066','2022-10-29 00:00:00','0','1250.00','1','116.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-10-29 22:24:49','2022-10-29 22:24:49',NULL,'1','Add New Invoice','1'),
('1067','VR-22-1067','2022-10-30 00:00:00','0','1250.00','1','259.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-30 12:36:29','2022-10-30 07:10:22',NULL,'1','Update Invoice','1'),
('1068','VR-22-1068','2022-10-30 00:00:00','0','1250.00','1','376.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-10-30 15:09:40','2022-10-30 15:09:40',NULL,'1','Add New Invoice','1'),
('1069','VR-22-1069','2022-10-30 00:00:00','0','1250.00','1','352.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-10-30 17:37:31','2022-10-30 17:37:31',NULL,'1','Add New Invoice','1'),
('1070','VR-22-1070','2022-10-30 00:00:00','0','1250.00','1','112.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-30 18:52:24','2022-10-30 18:52:24',NULL,'1','Add New Invoice','1'),
('1071','VR-22-1071','2022-10-30 00:00:00','0','1250.00','1','127.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-30 19:13:41','2022-10-30 19:13:41',NULL,'1','Add New Invoice','1'),
('1072','VR-22-1072','2022-10-30 00:00:00','0','1250.00','1','2014.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-30 19:40:29','2022-10-30 19:40:29',NULL,'1','Add New Invoice','1'),
('1073','VR-22-1073','2022-10-30 00:00:00','0','1250.00','1','162.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-30 19:44:07','2022-10-30 19:44:07',NULL,'1','Add New Invoice','1'),
('1074','VR-22-1074','2022-10-30 00:00:00','0','1250.00','1','516.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-10-30 19:52:41','2022-10-30 19:52:41',NULL,'1','Add New Invoice','1'),
('1075','VR-22-1075','2022-10-30 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-30 20:02:42','2022-10-30 20:02:42',NULL,'1','Add New Invoice','1'),
('1076','VR-22-1076','2022-10-30 00:00:00','0','1250.00','1','3080.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-10-30 20:29:37','2022-10-30 20:29:37',NULL,'1','Add New Invoice','1'),
('1077','VR-22-1077','2022-10-31 00:00:00','0','1250.00','1','19530.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-10-31 16:22:19','2022-10-31 16:22:19',NULL,'1','Add New Invoice','1'),
('1078','VR-22-1078','2022-10-31 00:00:00','0','1250.00','1','658.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-10-31 17:05:48','2022-10-31 17:05:48',NULL,'1','Add New Invoice','1'),
('1079','VR-22-1079','2022-10-31 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','1','2022-10-31 17:55:42','2022-10-31 17:55:42','2022-10-31 05:56:38','1','Delete Invoice','1'),
('1080','VR-22-1080','2022-10-31 00:00:00','0','1250.00','1','76.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-10-31 17:57:18','2022-11-01 04:02:52',NULL,'1','Update Invoice','1'),
('1081','VR-22-1081','2022-11-01 00:00:00','0','1250.00','1','134.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-11-01 14:24:19','2022-11-01 14:24:19',NULL,'1','Add New Invoice','1'),
('1086','VR-22-1082','2022-11-01 00:00:00','0','1250.00','1','1947.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-01 18:25:30','2022-11-01 18:25:30',NULL,'1','Add New Invoice','1'),
('1089','VR-22-1087','2022-11-01 00:00:00','0','1250.00','1','773.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-01 18:31:47','2022-11-01 18:31:47',NULL,'1','Add New Invoice','1'),
('1090','VR-22-1090','2022-11-01 00:00:00','0','1250.00','1','800.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-01 18:33:53','2022-11-01 18:33:53',NULL,'1','Add New Invoice','1'),
('1091','VR-22-1091','2022-11-01 00:00:00','0','1250.00','1','774.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-01 18:39:12','2022-11-01 18:39:12',NULL,'1','Add New Invoice','1'),
('1092','VR-22-1092','2022-11-01 00:00:00','0','1250.00','1','1300.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-01 18:41:54','2022-11-01 18:41:54',NULL,'1','Add New Invoice','1'),
('1093','VR-22-1093','2022-11-01 00:00:00','0','1250.00','1','4703.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-01 18:48:17','2022-11-01 18:48:17',NULL,'1','Add New Invoice','1'),
('1094','VR-22-1094','2022-11-01 00:00:00','0','1250.00','1','136.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-11-01 18:54:29','2022-11-01 18:54:29',NULL,'1','Add New Invoice','1'),
('1095','VR-22-1095','2022-11-01 00:00:00','0','1250.00','1','1939.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-01 21:08:01','2022-11-01 21:08:01',NULL,'1','Add New Invoice','1'),
('1096','VR-22-1096','2022-11-02 00:00:00','0','1250.00','1','139.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2022-11-02 12:02:39','2022-11-02 12:02:39','2022-12-07 05:45:37','1','Delete Invoice','1'),
('1097','VR-22-1097','2022-11-02 00:00:00','0','1250.00','1','50.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-11-02 14:07:58','2022-11-02 14:07:58',NULL,'1','Add New Invoice','1'),
('1098','VR-22-1098','2022-11-02 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-11-02 15:10:37','2022-11-02 15:10:37',NULL,'1','Add New Invoice','1'),
('1099','VR-22-1099','2022-11-02 00:00:00','0','1250.00','1','6747.99','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-02 15:19:25','2022-11-09 02:20:15',NULL,'1','Update Invoice','1'),
('1100','VR-22-1100','2022-11-02 00:00:00','0','1250.00','1','122.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-02 15:21:35','2022-11-02 15:21:35',NULL,'1','Add New Invoice','1'),
('1101','VR-22-1101','2022-11-02 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-11-02 16:54:49','2022-11-02 16:54:49',NULL,'1','Add New Invoice','1'),
('1102','VR-22-1102','2022-11-02 00:00:00','0','1250.00','1','247.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-11-02 17:01:31','2022-11-02 17:01:31',NULL,'1','Add New Invoice','1'),
('1103','VR-22-1103','2022-11-03 00:00:00','0','1250.00','1','1100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-11-03 14:41:39','2022-11-03 14:41:39',NULL,'1','Add New Invoice','1'),
('1104','VR-22-1104','2022-11-03 00:00:00','0','1250.00','1','139.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-11-03 16:24:12','2022-11-03 16:24:12',NULL,'1','Add New Invoice','1'),
('1105','VR-22-1105','2022-11-05 00:00:00','0','1250.00','1','1217.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-05 11:28:32','2022-11-05 11:28:32',NULL,'1','Add New Invoice','1'),
('1106','VR-22-1106','2022-11-05 00:00:00','0','1250.00','1','185.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-11-05 11:42:25','2022-11-05 11:42:25',NULL,'1','Add New Invoice','1'),
('1107','VR-22-1107','2022-11-05 00:00:00','0','1250.00','1','898.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2022-11-05 14:02:18','2022-11-05 02:15:42','2022-11-12 04:19:47','1','Delete Invoice','1'),
('1108','VR-22-1108','2022-11-05 00:00:00','0','1250.00','1','436.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-05 14:22:24','2022-11-05 14:22:24',NULL,'1','Add New Invoice','1'),
('1109','VR-22-1109','2022-11-05 00:00:00','0','1250.00','1','137.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-11-05 16:17:20','2022-11-05 16:17:20',NULL,'1','Add New Invoice','1'),
('1110','VR-22-1110','2022-11-05 00:00:00','0','1250.00','1','61.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-11-05 16:18:56','2022-11-05 16:18:56',NULL,'1','Add New Invoice','1'),
('1111','VR-22-1111','2022-11-05 00:00:00','0','1250.00','1','54.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-11-05 16:47:20','2022-11-05 16:47:20',NULL,'1','Add New Invoice','1'),
('1112','VR-22-1112','2022-11-05 00:00:00','0','1250.00','1','43.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-11-05 16:51:11','2022-11-08 04:18:17',NULL,'1','Update Invoice','1'),
('1113','VR-22-1113','2022-11-05 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-11-05 17:25:28','2022-11-05 17:25:28',NULL,'1','Add New Invoice','1'),
('1114','VR-22-1114','2022-11-05 00:00:00','0','1250.00','1','142.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-05 17:33:39','2022-11-05 17:33:39',NULL,'1','Add New Invoice','1'),
('1115','VR-22-1115','2022-11-05 00:00:00','0','1250.00','1','26.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-11-05 17:53:31','2022-11-05 17:53:31',NULL,'1','Add New Invoice','1'),
('1116','VR-22-1116','2022-11-05 00:00:00','0','1250.00','1','828.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-05 18:14:26','2022-11-05 18:14:26',NULL,'1','Add New Invoice','1'),
('1117','VR-22-1117','2022-11-05 00:00:00','0','1250.00','1','175.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-11-05 18:23:29','2022-11-05 18:23:29',NULL,'1','Add New Invoice','1'),
('1118','VR-22-1118','2022-11-06 00:00:00','0','1250.00','1','264.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-11-06 10:01:22','2022-11-06 10:01:22',NULL,'1','Add New Invoice','1'),
('1119','VR-22-1119','2022-11-06 00:00:00','0','1250.00','1','473.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-06 10:05:54','2022-11-06 10:05:54',NULL,'1','Add New Invoice','1'),
('1120','VR-22-1120','2022-11-06 00:00:00','0','1250.00','1','90.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2022-11-06 10:08:49','2022-11-06 10:08:49','2022-11-06 10:31:38','1','Delete Invoice','1'),
('1121','VR-22-1121','2022-11-07 00:00:00','0','1250.00','1','232.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-11-07 18:51:18','2022-11-07 18:51:18',NULL,'1','Add New Invoice','1'),
('1122','VR-22-1122','2022-11-07 00:00:00','0','1250.00','1','66.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-07 18:53:05','2022-11-07 18:53:05',NULL,'1','Add New Invoice','1'),
('1123','VR-22-1123','2022-11-07 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-07 19:13:49','2022-11-07 19:13:49',NULL,'1','Add New Invoice','1'),
('1124','VR-22-1124','2022-11-07 00:00:00','0','1250.00','1','2872.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','9','0','2022-11-07 19:23:29','2022-11-08 02:45:28',NULL,'1','Update Invoice','1'),
('1125','VR-22-1125','2022-11-08 00:00:00','0','1250.00','1','409.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-08 13:58:11','2022-11-08 01:58:24',NULL,'1','Update Invoice','1'),
('1126','VR-22-1126','2022-11-08 00:00:00','0','1250.00','1','1859.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-08 14:26:46','2022-11-08 14:26:46',NULL,'1','Add New Invoice','1'),
('1127','VR-22-1127','2022-11-08 00:00:00','0','1250.00','1','712.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-08 14:52:45','2022-11-08 14:52:45',NULL,'1','Add New Invoice','1'),
('1128','VR-22-1128','2022-11-08 00:00:00','0','1250.00','1','55.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-11-08 15:06:39','2022-11-08 15:06:39',NULL,'1','Add New Invoice','1'),
('1129','VR-22-1129','2022-11-08 00:00:00','0','1250.00','1','195.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','1','2022-11-08 15:17:19','2022-11-08 15:17:19','2022-11-08 03:17:33','1','Delete Invoice','1'),
('1130','VR-22-1130','2022-11-08 00:00:00','0','1250.00','1','209.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-08 15:18:30','2022-11-08 15:18:30',NULL,'1','Add New Invoice','1'),
('1131','VR-22-1131','2022-11-09 00:00:00','0','1250.00','1','493.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','1','2022-11-09 13:03:07','2022-11-09 13:03:07','2022-11-09 01:03:17','1','Delete Invoice','1'),
('1132','VR-22-1132','2022-11-09 00:00:00','0','1250.00','1','493.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-09 13:05:33','2022-11-09 13:05:33',NULL,'1','Add New Invoice','1'),
('1133','VR-22-1133','2022-11-09 00:00:00','0','1250.00','1','1023.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-11-09 13:41:17','2022-11-09 13:41:17',NULL,'1','Add New Invoice','1'),
('1134','VR-22-1134','2022-11-09 00:00:00','0','1250.00','1','140.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-09 14:17:01','2022-11-09 14:17:01',NULL,'1','Add New Invoice','1'),
('1135','VR-22-1135','2022-11-09 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-09 14:21:59','2022-11-09 14:21:59',NULL,'1','Add New Invoice','1'),
('1136','VR-22-1136','2022-11-09 00:00:00','0','1250.00','1','858.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-11-09 17:02:17','2022-11-09 17:02:17',NULL,'1','Add New Invoice','1'),
('1137','VR-22-1137','2022-11-10 00:00:00','0','1250.00','1','252.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-10 11:04:50','2022-11-10 11:05:36',NULL,'1','Update Invoice','1'),
('1138','VR-22-1138','2022-11-10 00:00:00','0','1250.00','1','367.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-10 12:00:22','2022-11-10 12:00:22',NULL,'1','Add New Invoice','1'),
('1139','VR-22-1139','2022-11-10 00:00:00','0','1250.00','1','198.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-11-10 14:39:53','2022-11-10 14:39:53',NULL,'1','Add New Invoice','1'),
('1140','VR-22-1140','2022-11-12 00:00:00','0','1250.00','1','177.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-11-12 15:40:51','2022-11-12 15:40:51',NULL,'1','Add New Invoice','1'),
('1141','VR-22-1141','2022-11-12 00:00:00','0','1250.00','1','173.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2022-11-12 19:43:37','2022-11-12 19:43:37','2022-12-07 05:45:52','1','Delete Invoice','1'),
('1142','VR-22-1142','2022-11-12 00:00:00','0','1250.00','1','2126.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-12 20:11:14','2022-11-12 20:11:14',NULL,'1','Add New Invoice','1'),
('1143','VR-22-1143','2022-11-13 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-11-13 14:36:10','2022-11-13 14:36:10',NULL,'1','Add New Invoice','1'),
('1144','VR-22-1144','2022-11-13 00:00:00','0','1250.00','1','92.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-11-13 15:39:20','2022-11-13 15:39:20',NULL,'1','Add New Invoice','1'),
('1145','VR-22-1145','2022-11-13 00:00:00','0','1250.00','1','270.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-13 15:40:55','2022-11-13 15:40:55',NULL,'1','Add New Invoice','1'),
('1146','VR-22-1146','2022-11-13 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2022-11-13 15:46:19','2022-11-13 15:46:19',NULL,'1','Add New Invoice','1'),
('1147','VR-22-1147','2022-11-13 00:00:00','0','1250.00','1','161.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-11-13 15:47:34','2022-11-13 03:49:04',NULL,'1','Update Invoice','1'),
('1148','VR-22-1148','2022-11-13 00:00:00','0','1250.00','1','204.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-11-13 15:54:34','2022-11-13 15:54:34',NULL,'1','Add New Invoice','1'),
('1149','VR-22-1149','2022-11-13 00:00:00','0','1250.00','1','42.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-11-13 16:00:14','2022-11-13 16:00:14',NULL,'1','Add New Invoice','1'),
('1150','VR-22-1150','2022-11-13 00:00:00','0','1250.00','1','76.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-13 16:03:18','2022-11-13 16:03:18',NULL,'1','Add New Invoice','1'),
('1151','VR-22-1151','2022-11-13 00:00:00','0','1250.00','1','375.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-13 16:05:31','2022-11-13 16:05:31',NULL,'1','Add New Invoice','1'),
('1152','VR-22-1152','2022-11-13 00:00:00','0','1250.00','1','2690.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-13 16:27:43','2022-11-13 16:27:43',NULL,'1','Add New Invoice','1'),
('1153','VR-22-1153','2022-11-13 00:00:00','0','1250.00','1','178.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-13 20:10:57','2022-11-13 20:10:57',NULL,'1','Add New Invoice','1'),
('1154','VR-22-1154','2022-11-14 00:00:00','0','1250.00','1','79.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2022-11-14 12:05:53','2022-11-14 12:05:53','2022-11-14 12:10:12','1','Delete Invoice','1'),
('1155','VR-22-1155','2022-11-14 00:00:00','0','1250.00','1','172.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-11-14 12:07:59','2022-11-14 12:11:25',NULL,'1','Update Invoice','1'),
('1156','VR-22-1156','2022-11-14 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-11-14 14:37:08','2022-11-14 14:37:08',NULL,'1','Add New Invoice','1'),
('1157','VR-22-1157','2022-11-15 00:00:00','0','1250.00','1','379.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-15 13:55:32','2022-11-15 13:55:32',NULL,'1','Add New Invoice','1'),
('1158','VR-22-1158','2022-11-15 00:00:00','0','1250.00','1','286.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-15 22:19:56','2022-11-15 22:19:56',NULL,'1','Add New Invoice','1'),
('1159','VR-22-1159','2022-11-16 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-11-16 18:48:30','2022-11-16 18:48:30',NULL,'1','Add New Invoice','1'),
('1160','VR-22-1160','2022-11-16 00:00:00','0','1250.00','1','276.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-11-16 18:55:59','2022-11-16 18:55:59',NULL,'1','Add New Invoice','1'),
('1161','VR-22-1161','2022-11-16 00:00:00','0','1250.00','1','657.83','0.00','مهدي اسدي بغداد مدينة الصدر ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-16 18:59:27','2022-11-16 18:59:27',NULL,'1','Add New Invoice','1'),
('1162','VR-22-1162','2022-11-16 00:00:00','0','1250.00','1','325.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-16 19:17:45','2022-11-16 19:17:45',NULL,'1','Add New Invoice','1'),
('1163','VR-22-1163','2022-11-19 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-11-19 14:26:00','2022-11-19 14:26:00',NULL,'1','Add New Invoice','1'),
('1164','VR-22-1164','2022-11-19 00:00:00','0','1250.00','1','237.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-11-19 14:28:59','2022-11-19 14:28:59',NULL,'1','Add New Invoice','1'),
('1165','VR-22-1165','2022-11-19 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-11-19 14:33:39','2022-11-19 14:33:39',NULL,'1','Add New Invoice','1'),
('1166','VR-22-1166','2022-11-19 00:00:00','0','1250.00','1','259.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-19 14:38:10','2022-11-19 14:38:10',NULL,'1','Add New Invoice','1'),
('1167','VR-22-1167','2022-11-19 00:00:00','0','1250.00','1','41.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-11-19 14:39:57','2022-11-19 14:39:57',NULL,'1','Add New Invoice','1'),
('1168','VR-22-1168','2022-11-19 00:00:00','0','1250.00','1','204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-11-19 14:41:01','2022-11-19 14:41:01',NULL,'1','Add New Invoice','1'),
('1169','VR-22-1169','2022-11-19 00:00:00','0','1250.00','1','89.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-11-19 14:58:19','2022-11-19 14:58:19',NULL,'1','Add New Invoice','1'),
('1170','VR-22-1170','2022-11-19 00:00:00','0','1250.00','1','3855.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-19 15:24:49','2022-11-19 15:24:49',NULL,'1','Add New Invoice','1'),
('1171','VR-22-1171','2022-11-19 00:00:00','0','1250.00','1','156.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-19 20:18:02','2022-11-19 20:18:02',NULL,'1','Add New Invoice','1'),
('1175','VR-22-1172','2022-11-20 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-20 11:01:56','2022-11-20 11:01:56',NULL,'1','Add New Invoice','1'),
('1176','VR-22-1176','2022-11-20 00:00:00','0','1250.00','1','748.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-20 11:03:39','2022-11-20 11:03:39',NULL,'1','Add New Invoice','1'),
('1177','VR-22-1177','2022-11-20 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-11-20 11:42:39','2022-11-20 11:42:39',NULL,'1','Add New Invoice','1'),
('1178','VR-22-1178','2022-11-20 00:00:00','0','1250.00','1','61.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-11-20 12:04:50','2022-11-20 12:04:50',NULL,'1','Add New Invoice','1'),
('1179','VR-22-1179','2022-11-20 00:00:00','0','1250.00','1','179.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-20 12:25:09','2022-11-20 12:30:52',NULL,'1','Update Invoice','1'),
('1180','VR-22-1180','2022-11-20 00:00:00','0','1250.00','1','82.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-20 16:04:37','2022-11-20 16:04:37',NULL,'1','Add New Invoice','1'),
('1181','VR-22-1181','2022-11-21 00:00:00','0','1250.00','1','277.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-21 17:34:33','2022-11-21 17:34:33',NULL,'1','Add New Invoice','1'),
('1182','VR-22-1182','2022-11-21 00:00:00','0','1250.00','1','128.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-11-21 17:38:38','2022-11-21 17:38:38',NULL,'1','Add New Invoice','1'),
('1183','VR-22-1183','2022-11-21 00:00:00','0','1250.00','1','165.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-21 17:45:16','2022-11-21 05:48:16',NULL,'1','Update Invoice','1'),
('1184','VR-22-1184','2022-11-21 00:00:00','0','1250.00','1','217.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-11-21 17:47:34','2022-11-21 17:47:34',NULL,'1','Add New Invoice','1'),
('1185','VR-22-1185','2022-11-21 00:00:00','0','1250.00','1','92.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-11-21 17:49:44','2022-11-21 17:49:44',NULL,'1','Add New Invoice','1'),
('1186','VR-22-1186','2022-11-21 00:00:00','0','1250.00','1','82.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-21 17:53:53','2022-11-21 17:53:53',NULL,'1','Add New Invoice','1'),
('1187','VR-22-1187','2022-11-23 00:00:00','0','1250.00','1','48.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-23 11:29:18','2022-11-23 11:29:18',NULL,'1','Add New Invoice','1'),
('1188','VR-22-1188','2022-11-23 00:00:00','0','1250.00','1','123.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-11-23 11:38:42','2022-11-23 11:38:42',NULL,'1','Add New Invoice','1'),
('1189','VR-22-1189','2022-11-24 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-11-24 20:19:39','2022-11-24 20:19:39',NULL,'1','Add New Invoice','1'),
('1190','VR-22-1190','2022-11-24 00:00:00','0','1250.00','1','2185.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-11-24 20:23:45','2022-11-24 20:23:45',NULL,'1','Add New Invoice','1'),
('1191','VR-22-1191','2022-11-24 00:00:00','0','1250.00','1','36.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-11-24 20:31:15','2022-11-24 20:31:15',NULL,'1','Add New Invoice','1'),
('1192','VR-22-1192','2022-11-24 00:00:00','0','1250.00','1','157.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-24 20:31:57','2022-11-24 20:31:57',NULL,'1','Add New Invoice','1'),
('1193','VR-22-1193','2022-11-24 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-11-24 20:36:04','2022-11-24 20:36:04',NULL,'1','Add New Invoice','1'),
('1194','VR-22-1194','2022-11-24 00:00:00','0','1250.00','1','49.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-11-24 20:37:23','2022-11-24 20:37:23',NULL,'1','Add New Invoice','1'),
('1195','VR-22-1195','2022-11-24 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-11-24 20:57:34','2022-11-24 20:57:34',NULL,'1','Add New Invoice','1'),
('1196','VR-22-1196','2022-11-26 00:00:00','0','1250.00','1','18.00','0.00','','0','0','3',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-11-26 21:21:15','2022-11-26 21:21:15',NULL,'1','Add New Invoice','1'),
('1197','VR-22-1197','2022-11-26 00:00:00','0','1250.00','1','39.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-26 21:23:44','2022-11-26 21:23:44',NULL,'1','Add New Invoice','1'),
('1198','VR-22-1198','2022-11-26 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-11-26 21:27:13','2022-11-26 21:27:13',NULL,'1','Add New Invoice','1'),
('1199','VR-22-1199','2022-11-26 00:00:00','0','1250.00','1','233.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-11-26 21:31:37','2023-02-28 01:26:35',NULL,'1','Update Invoice','1'),
('1200','VR-22-1200','2022-11-26 00:00:00','0','1250.00','1','550.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-11-26 21:42:53','2022-11-26 09:44:31',NULL,'1','Update Invoice','1'),
('1201','VR-22-1201','2022-11-28 00:00:00','0','1250.00','1','340.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-11-28 10:20:58','2022-11-28 10:20:58',NULL,'1','Add New Invoice','1'),
('1202','VR-22-1202','2022-11-28 00:00:00','0','1250.00','1','212.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-28 10:21:54','2022-11-28 10:21:54',NULL,'1','Add New Invoice','1'),
('1203','VR-22-1203','2022-11-28 00:00:00','0','1250.00','1','272.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-11-28 10:24:19','2022-11-28 10:24:19',NULL,'1','Add New Invoice','1'),
('1204','VR-22-1204','2022-11-28 00:00:00','0','1250.00','1','531.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-11-28 10:25:59','2022-11-28 10:37:14',NULL,'1','Update Invoice','1'),
('1205','VR-22-1205','2022-11-28 00:00:00','0','1250.00','1','655.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-28 10:28:28','2022-12-01 04:41:16',NULL,'1','Update Invoice','1'),
('1206','VR-22-1206','2022-11-28 00:00:00','0','1250.00','1','157.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','1','2022-11-28 10:39:26','2022-11-28 10:39:26','2022-11-30 04:09:27','1','Delete Invoice','1'),
('1207','VR-22-1207','2022-11-28 00:00:00','0','1250.00','1','247.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-11-28 10:58:07','2022-11-28 10:58:07',NULL,'1','Add New Invoice','1'),
('1208','VR-22-1208','2022-11-28 00:00:00','0','1250.00','1','124.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-28 11:01:53','2022-11-28 11:01:53',NULL,'1','Add New Invoice','1'),
('1209','VR-22-1209','2022-11-30 00:00:00','0','1250.00','1','176.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-11-30 11:33:04','2022-11-30 11:33:04',NULL,'1','Add New Invoice','1'),
('1210','VR-22-1210','2022-11-30 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2022-11-30 12:51:15','2022-11-30 12:51:15',NULL,'1','Add New Invoice','1'),
('1211','VR-22-1211','2022-11-30 00:00:00','0','1250.00','1','64.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-11-30 12:54:31','2022-11-30 12:54:31',NULL,'1','Add New Invoice','1'),
('1212','VR-22-1212','2022-11-30 00:00:00','0','1250.00','1','102.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-11-30 12:58:02','2022-11-30 12:58:02',NULL,'1','Add New Invoice','1'),
('1213','VR-22-1213','2022-11-30 00:00:00','0','1250.00','1','119.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-11-30 13:17:15','2022-11-30 13:17:15',NULL,'1','Add New Invoice','1'),
('1214','VR-22-1214','2022-11-30 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-11-30 13:20:13','2022-11-30 13:20:13',NULL,'1','Add New Invoice','1'),
('1215','VR-22-1215','2022-11-30 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-11-30 13:33:55','2022-11-30 13:33:55',NULL,'1','Add New Invoice','1'),
('1216','VR-22-1216','2022-11-30 00:00:00','0','1250.00','1','292.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-11-30 14:07:51','2022-11-30 14:07:51',NULL,'1','Add New Invoice','1'),
('1217','VR-22-1217','2022-11-30 00:00:00','0','1250.00','1','158.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-30 14:11:18','2022-11-30 14:11:18',NULL,'1','Add New Invoice','1'),
('1218','VR-22-1218','2022-11-30 00:00:00','0','1250.00','1','5769.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-11-30 14:45:30','2022-11-30 14:45:30',NULL,'1','Add New Invoice','1'),
('1219','VR-22-1219','2022-11-30 00:00:00','0','1250.00','1','1745.11','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-11-30 16:21:15','2022-11-30 16:21:15',NULL,'1','Add New Invoice','1'),
('1220','VR-22-1220','2022-11-30 00:00:00','0','1250.00','1','647.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-11-30 16:28:38','2022-11-30 16:28:38',NULL,'1','Add New Invoice','1'),
('1221','VR-22-1221','2022-12-01 00:00:00','0','1250.00','1','1287.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-01 18:50:47','2022-12-01 07:01:11',NULL,'1','Update Invoice','1'),
('1222','VR-22-1222','2022-12-03 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-03 11:34:25','2022-12-03 11:34:25',NULL,'1','Add New Invoice','1'),
('1223','VR-22-1223','2022-12-03 00:00:00','0','1250.00','1','1038.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-03 12:00:57','2022-12-03 12:00:57',NULL,'1','Add New Invoice','1'),
('1224','VR-22-1224','2022-12-03 00:00:00','0','1250.00','1','88.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-12-03 12:52:35','2022-12-03 12:52:35',NULL,'1','Add New Invoice','1'),
('1225','VR-22-1225','2022-12-03 00:00:00','0','1250.00','1','88.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2022-12-03 17:54:14','2022-12-03 17:54:14',NULL,'1','Add New Invoice','1'),
('1226','VR-22-1226','2022-12-04 00:00:00','0','1250.00','1','185.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-04 10:54:35','2022-12-04 10:54:35',NULL,'1','Add New Invoice','1'),
('1227','VR-22-1227','2022-12-04 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-12-04 10:58:16','2022-12-04 10:58:16',NULL,'1','Add New Invoice','1'),
('1228','VR-22-1228','2022-12-04 00:00:00','0','1250.00','1','80.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-04 11:01:40','2022-12-04 11:01:40',NULL,'1','Add New Invoice','1'),
('1229','VR-22-1229','2022-12-04 00:00:00','0','1250.00','1','930.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-12-04 11:07:48','2022-12-04 11:07:48',NULL,'1','Add New Invoice','1'),
('1230','VR-22-1230','2022-12-04 00:00:00','0','1250.00','1','81.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-04 11:09:52','2022-12-04 11:09:52',NULL,'1','Add New Invoice','1'),
('1231','VR-22-1231','2022-12-04 00:00:00','0','1250.00','1','9594.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-04 16:08:02','2022-12-05 12:16:19',NULL,'1','Update Invoice','1'),
('1232','VR-22-1232','2022-12-04 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-12-04 16:15:47','2022-12-04 16:15:47',NULL,'1','Add New Invoice','1'),
('1233','VR-22-1233','2022-12-04 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-04 16:27:13','2022-12-04 16:27:13',NULL,'1','Add New Invoice','1'),
('1234','VR-22-1234','2022-12-05 00:00:00','0','1250.00','1','81.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-12-05 10:40:10','2022-12-05 10:40:10',NULL,'1','Add New Invoice','1'),
('1235','VR-22-1235','2022-12-05 00:00:00','0','1250.00','1','623.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2022-12-05 12:49:12','2022-12-05 12:49:12',NULL,'1','Add New Invoice','1'),
('1236','VR-22-1236','2022-12-05 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-12-05 15:03:37','2022-12-05 15:03:37',NULL,'1','Add New Invoice','1'),
('1237','VR-22-1237','2022-12-06 00:00:00','0','1250.00','1','213.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-06 10:29:12','2022-12-06 10:29:12',NULL,'1','Add New Invoice','1'),
('1238','VR-22-1238','2022-12-06 00:00:00','0','1250.00','1','301.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2022-12-06 11:41:01','2022-12-06 11:41:01',NULL,'1','Add New Invoice','1'),
('1239','VR-22-1239','2022-12-06 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-12-06 15:44:22','2022-12-06 15:44:22',NULL,'1','Add New Invoice','1'),
('1240','VR-22-1240','2022-12-06 00:00:00','0','1250.00','1','216.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-12-06 16:21:45','2022-12-06 16:21:45',NULL,'1','Add New Invoice','1'),
('1241','VR-22-1241','2022-12-06 00:00:00','0','1250.00','1','4426.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-06 18:50:38','2022-12-06 18:50:38',NULL,'1','Add New Invoice','1'),
('1242','VR-22-1242','2022-12-07 00:00:00','0','1250.00','1','1320.80','0.00','سوق شيوخ  جعفر فليح ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-07 12:49:37','2022-12-07 12:49:37',NULL,'1','Add New Invoice','1'),
('1243','VR-22-1243','2022-12-07 00:00:00','0','1250.00','1','2931.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-07 13:33:07','2022-12-08 03:19:59',NULL,'1','Update Invoice','1'),
('1244','VR-22-1244','2022-12-07 00:00:00','0','1250.00','1','1360.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-07 13:38:19','2022-12-08 04:57:41',NULL,'1','Update Invoice','1'),
('1245','VR-22-1245','2022-12-07 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-07 14:57:24','2022-12-07 14:57:24',NULL,'1','Add New Invoice','1'),
('1246','VR-22-1246','2022-12-07 00:00:00','0','1250.00','1','1151.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-07 15:05:12','2022-12-07 03:17:30',NULL,'1','Update Invoice','1'),
('1248','VR-22-1247','2022-12-08 00:00:00','0','1250.00','1','7293.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-08 11:00:08','2022-12-08 11:00:08',NULL,'1','Add New Invoice','1'),
('1249','VR-22-1249','2022-12-08 00:00:00','0','1250.00','1','247.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-08 11:04:50','2022-12-08 11:04:50',NULL,'1','Add New Invoice','1'),
('1250','VR-22-1250','2022-12-08 00:00:00','0','1250.00','1','454.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-08 11:54:50','2022-12-08 11:54:50',NULL,'1','Add New Invoice','1'),
('1251','VR-22-1251','2022-12-08 00:00:00','0','1250.00','1','153.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-12-08 12:52:45','2022-12-08 12:52:45',NULL,'1','Add New Invoice','1'),
('1252','VR-22-1252','2022-12-08 00:00:00','0','1250.00','1','2223.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-08 13:44:48','2022-12-08 04:53:22',NULL,'1','Update Invoice','1'),
('1253','VR-22-1253','2022-12-08 00:00:00','0','1250.00','1','174.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-12-08 13:51:41','2023-02-28 01:26:55',NULL,'1','Update Invoice','1'),
('1254','VR-22-1254','2022-12-08 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-08 16:27:35','2022-12-08 16:27:35',NULL,'1','Add New Invoice','1'),
('1255','VR-22-1255','2022-12-08 00:00:00','0','1250.00','1','139.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-08 16:51:55','2022-12-08 16:51:55',NULL,'1','Add New Invoice','1'),
('1256','VR-22-1256','2022-12-08 00:00:00','0','1250.00','1','37.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-12-08 16:54:56','2022-12-08 16:54:56',NULL,'1','Add New Invoice','1'),
('1257','VR-22-1257','2022-12-08 00:00:00','0','1250.00','1','27.31','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-08 17:01:46','2022-12-08 17:01:46',NULL,'1','Add New Invoice','1'),
('1258','VR-22-1258','2022-12-10 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-12-10 10:26:52','2022-12-10 10:26:52',NULL,'1','Add New Invoice','1'),
('1259','VR-22-1259','2022-12-10 00:00:00','0','1250.00','1','4430.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-10 11:44:09','2023-01-18 01:10:54',NULL,'1','Update Invoice','1'),
('1260','VR-22-1260','2022-12-10 00:00:00','0','1250.00','1','45.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-10 12:42:06','2022-12-10 12:42:06',NULL,'1','Add New Invoice','1'),
('1261','VR-22-1261','2022-12-10 00:00:00','0','1250.00','1','440.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-12-10 13:11:36','2022-12-10 13:11:36',NULL,'1','Add New Invoice','1'),
('1262','VR-22-1262','2022-12-10 00:00:00','0','1250.00','1','344.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-10 13:21:34','2022-12-10 04:32:37',NULL,'1','Update Invoice','1'),
('1263','VR-22-1263','2022-12-10 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-10 14:14:14','2022-12-10 14:14:14',NULL,'1','Add New Invoice','1'),
('1264','VR-22-1264','2022-12-10 00:00:00','0','1250.00','1','107.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-10 15:48:38','2022-12-10 15:48:38',NULL,'1','Add New Invoice','1'),
('1265','VR-22-1265','2022-12-10 00:00:00','0','1250.00','1','106.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-10 16:28:19','2022-12-10 16:28:19',NULL,'1','Add New Invoice','1'),
('1266','VR-22-1266','2022-12-11 00:00:00','0','1250.00','1','39.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-11 10:15:04','2022-12-11 10:15:04',NULL,'1','Add New Invoice','1'),
('1267','VR-22-1267','2022-12-11 00:00:00','0','1250.00','1','162.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-11 13:38:20','2022-12-11 13:38:20',NULL,'1','Add New Invoice','1'),
('1268','VR-22-1268','2022-12-11 00:00:00','0','1250.00','1','1563.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2022-12-11 14:21:55','2022-12-11 14:21:55',NULL,'1','Add New Invoice','1'),
('1269','VR-22-1269','2022-12-11 00:00:00','0','1250.00','1','89.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-12-11 15:21:44','2022-12-11 15:21:44',NULL,'1','Add New Invoice','1'),
('1270','VR-22-1270','2022-12-11 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-11 15:30:44','2022-12-11 15:30:44',NULL,'1','Add New Invoice','1'),
('1271','VR-22-1271','2022-12-11 00:00:00','0','1250.00','1','86.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-11 16:41:01','2022-12-11 16:41:01',NULL,'1','Add New Invoice','1'),
('1272','VR-22-1272','2022-12-12 00:00:00','0','1250.00','1','80.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-12 14:33:14','2022-12-12 14:33:14',NULL,'1','Add New Invoice','1'),
('1273','VR-22-1273','2022-12-12 00:00:00','0','1250.00','1','697.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-12 18:00:00','2022-12-12 18:00:00',NULL,'1','Add New Invoice','1'),
('1274','VR-22-1274','2022-12-13 00:00:00','0','1250.00','1','1379.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-13 09:01:58','2022-12-13 09:01:58',NULL,'1','Add New Invoice','1'),
('1275','VR-22-1275','2022-12-13 00:00:00','0','1250.00','1','176.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-12-13 14:32:54','2022-12-13 14:32:54',NULL,'1','Add New Invoice','1'),
('1276','VR-22-1276','2022-12-13 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-12-13 16:14:51','2022-12-13 16:14:51',NULL,'1','Add New Invoice','1'),
('1277','VR-22-1277','2022-12-13 00:00:00','0','1250.00','1','151.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2022-12-13 16:16:27','2022-12-13 16:16:27',NULL,'1','Add New Invoice','1'),
('1278','VR-22-1278','2022-12-13 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-13 17:01:34','2022-12-13 17:01:34',NULL,'1','Add New Invoice','1'),
('1279','VR-22-1279','2022-12-14 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-14 11:32:12','2022-12-14 11:32:12',NULL,'1','Add New Invoice','1'),
('1280','VR-22-1280','2022-12-14 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-14 11:35:19','2022-12-14 11:35:19',NULL,'1','Add New Invoice','1'),
('1281','VR-22-1281','2022-12-14 00:00:00','0','1250.00','1','106.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-14 12:24:00','2022-12-14 12:24:00',NULL,'1','Add New Invoice','1'),
('1282','VR-22-1282','2022-12-14 00:00:00','0','1250.00','1','53.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-14 12:38:12','2022-12-14 12:38:12',NULL,'1','Add New Invoice','1'),
('1283','VR-22-1283','2022-12-14 00:00:00','0','1250.00','1','50.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-14 12:46:46','2022-12-14 12:46:46',NULL,'1','Add New Invoice','1'),
('1284','VR-22-1284','2022-12-14 00:00:00','0','1250.00','1','83.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-14 16:06:04','2022-12-14 16:06:04',NULL,'1','Add New Invoice','1'),
('1285','VR-22-1285','2022-12-14 00:00:00','0','1250.00','1','356.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-14 16:09:38','2022-12-14 16:09:38',NULL,'1','Add New Invoice','1'),
('1286','VR-22-1286','2022-12-15 00:00:00','0','1250.00','1','234.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-15 12:06:06','2022-12-15 12:06:06',NULL,'1','Add New Invoice','1'),
('1287','VR-22-1287','2022-12-15 00:00:00','0','1250.00','1','61.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-15 17:21:59','2022-12-15 17:21:59',NULL,'1','Add New Invoice','1'),
('1288','VR-22-1288','2022-12-15 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-15 17:23:34','2022-12-15 17:23:34',NULL,'1','Add New Invoice','1'),
('1289','VR-22-1289','2022-12-17 00:00:00','0','1250.00','1','535.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2022-12-17 11:57:17','2023-02-28 01:27:12',NULL,'1','Update Invoice','1'),
('1290','VR-22-1290','2022-12-18 00:00:00','0','1250.00','1','143.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-18 11:27:48','2022-12-18 11:27:48',NULL,'1','Add New Invoice','1'),
('1291','VR-22-1291','2022-12-18 00:00:00','0','1250.00','1','4324.39','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-18 13:49:05','2022-12-18 13:49:05',NULL,'1','Add New Invoice','1'),
('1292','VR-22-1292','2022-12-18 00:00:00','0','1250.00','1','114.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-12-18 14:21:47','2022-12-18 14:21:47',NULL,'1','Add New Invoice','1'),
('1293','VR-22-1293','2022-12-19 00:00:00','0','1250.00','1','800.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2022-12-19 13:17:43','2022-12-19 13:17:43',NULL,'1','Add New Invoice','1'),
('1294','VR-22-1294','2022-12-19 00:00:00','0','1250.00','1','50.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','1','2022-12-19 15:52:19','2022-12-19 15:52:19','2022-12-19 03:52:50','1','Delete Invoice','1'),
('1295','VR-22-1295','2022-12-19 00:00:00','0','1250.00','1','526.32','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-19 16:01:17','2022-12-19 16:01:17',NULL,'1','Add New Invoice','1'),
('1296','VR-22-1296','2022-12-19 00:00:00','0','1250.00','1','175.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2022-12-19 17:07:01','2022-12-19 17:07:01',NULL,'1','Add New Invoice','1'),
('1297','VR-22-1297','2022-12-20 00:00:00','0','1250.00','1','93.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-20 10:43:00','2022-12-20 10:43:00',NULL,'1','Add New Invoice','1'),
('1298','VR-22-1298','2022-12-20 00:00:00','0','1250.00','1','246.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-20 11:04:05','2022-12-20 11:04:05',NULL,'1','Add New Invoice','1'),
('1299','VR-22-1299','2022-12-20 00:00:00','0','1250.00','1','31.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2022-12-20 11:46:47','2022-12-20 11:46:47','2022-12-20 08:19:31','1','Delete Invoice','1'),
('1300','VR-22-1300','2022-12-20 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-12-20 11:52:18','2022-12-20 11:52:18',NULL,'1','Add New Invoice','1'),
('1301','VR-22-1301','2022-12-20 00:00:00','0','1250.00','1','405.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-20 15:12:47','2022-12-20 15:12:47',NULL,'1','Add New Invoice','1'),
('1302','VR-22-1302','2022-12-20 00:00:00','0','1250.00','1','143.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2022-12-20 17:10:57','2022-12-20 17:10:57',NULL,'1','Add New Invoice','1'),
('1303','VR-22-1303','2022-12-20 00:00:00','0','1250.00','1','70.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-12-20 19:30:26','2022-12-20 19:30:26',NULL,'1','Add New Invoice','1'),
('1304','VR-22-1304','2022-12-20 00:00:00','0','1250.00','1','1828.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-20 19:37:05','2022-12-20 19:37:05',NULL,'1','Add New Invoice','1'),
('1305','VR-22-1305','2022-12-20 00:00:00','0','1250.00','1','1219.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-20 19:39:01','2022-12-20 19:39:01',NULL,'1','Add New Invoice','1'),
('1306','VR-22-1306','2022-12-21 00:00:00','0','1250.00','1','264.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-21 11:10:21','2022-12-21 11:10:21',NULL,'1','Add New Invoice','1'),
('1307','VR-22-1307','2022-12-21 00:00:00','0','1250.00','1','591.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-21 13:00:12','2022-12-21 13:00:12',NULL,'1','Add New Invoice','1'),
('1308','VR-22-1308','2022-12-21 00:00:00','0','1250.00','1','360.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-21 13:03:57','2022-12-21 13:03:57',NULL,'1','Add New Invoice','1'),
('1309','VR-22-1309','2022-12-21 00:00:00','0','1250.00','1','4349.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2022-12-21 15:30:59','2022-12-21 15:30:59',NULL,'1','Add New Invoice','1'),
('1310','VR-22-1310','2022-12-21 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-12-21 15:38:40','2022-12-21 15:38:40',NULL,'1','Add New Invoice','1'),
('1311','VR-22-1311','2022-12-21 00:00:00','0','1250.00','1','52.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-21 15:56:06','2022-12-21 15:56:06',NULL,'1','Add New Invoice','1'),
('1312','VR-22-1312','2022-12-21 00:00:00','0','1250.00','1','229.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-12-21 16:05:55','2022-12-21 16:05:55',NULL,'1','Add New Invoice','1'),
('1313','VR-22-1313','2022-12-21 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-21 16:07:36','2022-12-21 16:07:36',NULL,'1','Add New Invoice','1'),
('1314','VR-22-1314','2022-12-21 00:00:00','0','1250.00','1','114.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-21 16:10:16','2022-12-21 16:10:16',NULL,'1','Add New Invoice','1'),
('1315','VR-22-1315','2022-12-22 00:00:00','0','1250.00','1','143.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-22 10:45:06','2022-12-22 10:45:06',NULL,'1','Add New Invoice','1'),
('1316','VR-22-1316','2022-12-22 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-22 13:24:09','2022-12-22 13:24:09',NULL,'1','Add New Invoice','1'),
('1317','VR-22-1317','2022-12-22 00:00:00','0','1250.00','1','57.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-12-22 15:36:00','2022-12-22 15:36:00',NULL,'1','Add New Invoice','1'),
('1318','VR-22-1318','2022-12-24 00:00:00','0','1250.00','1','69.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-24 10:29:11','2022-12-24 10:29:11',NULL,'1','Add New Invoice','1'),
('1319','VR-22-1319','2022-12-24 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-24 10:34:23','2022-12-24 10:34:23',NULL,'1','Add New Invoice','1'),
('1320','VR-22-1320','2022-12-24 00:00:00','0','1250.00','1','77.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-12-24 14:30:32','2022-12-24 14:30:32',NULL,'1','Add New Invoice','1'),
('1321','VR-22-1321','2022-12-24 00:00:00','0','1250.00','1','157.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-24 17:49:44','2022-12-24 17:49:44',NULL,'1','Add New Invoice','1'),
('1322','VR-22-1322','2022-12-24 00:00:00','0','1250.00','1','76.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2022-12-24 17:56:46','2022-12-24 17:56:46',NULL,'1','Add New Invoice','1'),
('1323','VR-22-1323','2022-12-25 00:00:00','0','1250.00','1','153.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2022-12-25 11:41:12','2022-12-25 11:41:12',NULL,'1','Add New Invoice','1'),
('1324','VR-22-1324','2022-12-25 00:00:00','0','1250.00','1','489.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-25 14:39:25','2022-12-25 14:39:25',NULL,'1','Add New Invoice','1'),
('1325','VR-22-1325','2022-12-25 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-25 14:39:52','2022-12-25 14:39:52',NULL,'1','Add New Invoice','1'),
('1326','VR-22-1326','2022-12-25 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-25 16:37:21','2022-12-25 16:37:21',NULL,'1','Add New Invoice','1'),
('1327','VR-22-1327','2022-12-25 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2022-12-25 17:02:47','2022-12-25 17:02:47',NULL,'1','Add New Invoice','1'),
('1328','VR-22-1328','2022-12-26 00:00:00','0','1250.00','1','195.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-12-26 16:07:42','2022-12-26 16:07:42',NULL,'1','Add New Invoice','1'),
('1329','VR-22-1329','2022-12-26 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-26 16:19:58','2022-12-26 16:19:58',NULL,'1','Add New Invoice','1'),
('1330','VR-22-1330','2022-12-26 00:00:00','0','1250.00','1','1309.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2022-12-26 16:24:58','2022-12-26 16:24:58',NULL,'1','Add New Invoice','1'),
('1331','VR-22-1331','2022-12-26 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2022-12-26 16:28:17','2022-12-26 16:28:17',NULL,'1','Add New Invoice','1'),
('1332','VR-22-1332','2022-12-27 00:00:00','0','1250.00','1','200.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-27 14:20:40','2022-12-27 14:20:40',NULL,'1','Add New Invoice','1'),
('1333','VR-22-1333','2022-12-27 00:00:00','0','1250.00','1','44.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2022-12-27 15:09:46','2022-12-27 15:09:46',NULL,'1','Add New Invoice','1'),
('1334','VR-22-1334','2022-12-27 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2022-12-27 15:37:00','2022-12-27 15:37:00',NULL,'1','Add New Invoice','1'),
('1335','VR-22-1335','2022-12-28 00:00:00','0','1250.00','1','212.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2022-12-28 10:20:02','2022-12-28 10:20:02',NULL,'1','Add New Invoice','1'),
('1336','VR-22-1336','2022-12-28 00:00:00','0','1250.00','1','636.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-28 10:32:24','2022-12-28 10:32:24',NULL,'1','Add New Invoice','1'),
('1337','VR-22-1337','2022-12-28 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2022-12-28 11:55:50','2022-12-28 01:44:23',NULL,'1','Update Invoice','1'),
('1342','VR-22-1338','2022-12-28 00:00:00','0','1250.00','1','2834.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-28 13:31:47','2022-12-28 13:31:47',NULL,'1','Add New Invoice','1'),
('1343','VR-22-1343','2022-12-28 00:00:00','0','1250.00','1','340.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2022-12-28 15:34:30','2022-12-28 15:34:30',NULL,'1','Add New Invoice','1'),
('1344','VR-22-1344','2022-12-29 00:00:00','0','1250.00','1','735.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-29 13:39:35','2022-12-29 13:39:35',NULL,'1','Add New Invoice','1'),
('1345','VR-22-1345','2022-12-29 00:00:00','0','1250.00','1','70.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2022-12-29 13:48:34','2022-12-29 13:48:34',NULL,'1','Add New Invoice','1'),
('1346','VR-22-1346','2022-12-29 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2022-12-29 13:50:36','2022-12-29 13:50:36',NULL,'1','Add New Invoice','1'),
('1347','VR-22-1347','2022-12-29 00:00:00','0','1250.00','1','35.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2022-12-29 13:58:17','2022-12-29 13:58:17',NULL,'1','Add New Invoice','1'),
('1348','VR-22-1348','2022-12-29 00:00:00','0','1250.00','1','80.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2022-12-29 14:01:53','2022-12-29 14:01:53',NULL,'1','Add New Invoice','1'),
('1349','VR-22-1349','2022-12-29 00:00:00','0','1250.00','1','62.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2022-12-29 14:02:50','2022-12-29 14:02:50',NULL,'1','Add New Invoice','1'),
('1350','VR-22-1350','2022-12-29 00:00:00','0','1250.00','1','68.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2022-12-29 14:04:41','2022-12-29 14:04:41',NULL,'1','Add New Invoice','1'),
('1351','VR-22-1351','2022-12-31 00:00:00','0','1250.00','1','1899.95','0.00','سيد حيدر حلة ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2022-12-31 15:25:55','2022-12-31 15:25:55',NULL,'1','Add New Invoice','1'),
('1352','VR-23-1352','2023-01-01 00:00:00','0','1250.00','1','42.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-01-01 11:27:11','2023-01-01 11:27:11',NULL,'1','Add New Invoice','1'),
('1353','VR-23-1353','2023-01-01 00:00:00','0','1250.00','1','297.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-01-01 11:29:58','2023-01-01 11:29:58',NULL,'1','Add New Invoice','1'),
('1354','VR-23-1354','2023-01-01 00:00:00','0','1250.00','1','41.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-01-01 11:34:26','2023-01-01 11:34:26',NULL,'1','Add New Invoice','1'),
('1355','VR-23-1355','2023-01-01 00:00:00','0','1250.00','1','19.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-01-01 12:58:47','2023-01-01 12:58:47',NULL,'1','Add New Invoice','1'),
('1356','VR-23-1356','2023-01-03 00:00:00','0','1250.00','1','166.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-01-03 15:04:49','2023-01-03 15:04:49',NULL,'1','Add New Invoice','1'),
('1357','VR-23-1357','2023-01-04 00:00:00','0','1250.00','1','80.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-01-04 09:46:43','2023-01-04 09:46:43',NULL,'1','Add New Invoice','1'),
('1358','VR-23-1358','2023-01-04 00:00:00','0','1250.00','1','82.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-01-04 09:47:42','2023-01-04 09:47:42',NULL,'1','Add New Invoice','1'),
('1359','VR-23-1359','2023-01-04 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-01-04 09:48:38','2023-01-04 09:48:38',NULL,'1','Add New Invoice','1'),
('1360','VR-23-1360','2023-01-04 00:00:00','0','1250.00','1','152.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-01-04 09:50:24','2023-01-04 09:52:48',NULL,'1','Update Invoice','1'),
('1361','VR-23-1361','2023-01-04 00:00:00','0','1250.00','1','1517.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-04 10:35:15','2023-01-04 10:35:15',NULL,'1','Add New Invoice','1'),
('1362','VR-23-1362','2023-01-04 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-01-04 10:43:12','2023-01-04 10:43:12',NULL,'1','Add New Invoice','1'),
('1363','VR-23-1363','2023-01-05 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-01-05 09:15:07','2023-01-05 09:15:07',NULL,'1','Add New Invoice','1'),
('1364','VR-23-1364','2023-01-05 00:00:00','0','1250.00','1','216.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-01-05 11:09:16','2023-01-05 11:09:16',NULL,'1','Add New Invoice','1'),
('1365','VR-23-1365','2023-01-05 00:00:00','0','1250.00','1','147.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-01-05 16:29:37','2023-01-05 16:29:37',NULL,'1','Add New Invoice','1'),
('1366','VR-23-1366','2023-01-05 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-01-05 16:31:13','2023-01-05 16:31:13',NULL,'1','Add New Invoice','1'),
('1367','VR-23-1367','2023-01-05 00:00:00','0','1250.00','1','184.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-05 16:32:38','2023-01-05 16:32:38',NULL,'1','Add New Invoice','1'),
('1368','VR-23-1368','2023-01-07 00:00:00','0','1250.00','1','176.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-01-07 10:32:05','2023-01-07 10:32:05',NULL,'1','Add New Invoice','1'),
('1369','VR-23-1369','2023-01-07 00:00:00','0','1250.00','1','1526.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-01-07 11:27:09','2023-01-07 11:27:43',NULL,'1','Update Invoice','1'),
('1370','VR-23-1370','2023-01-07 00:00:00','0','1250.00','1','200.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-01-07 14:12:11','2023-01-07 14:12:11',NULL,'1','Add New Invoice','1'),
('1371','VR-23-1371','2023-01-07 00:00:00','0','1250.00','1','460.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-01-07 14:48:41','2023-01-07 14:48:41',NULL,'1','Add New Invoice','1'),
('1372','VR-23-1372','2023-01-07 00:00:00','0','1250.00','1','101.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-07 15:49:48','2023-01-07 15:49:48',NULL,'1','Add New Invoice','1'),
('1373','VR-23-1373','2023-01-07 00:00:00','0','1250.00','1','76.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-01-07 16:11:14','2023-01-07 16:11:14',NULL,'1','Add New Invoice','1'),
('1374','VR-23-1374','2023-01-08 00:00:00','0','1250.00','1','25.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-01-08 10:15:05','2023-01-08 10:15:05',NULL,'1','Add New Invoice','1'),
('1375','VR-23-1375','2023-01-08 00:00:00','0','1250.00','1','232.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-01-08 10:23:24','2023-01-08 10:23:24',NULL,'1','Add New Invoice','1'),
('1376','VR-23-1376','2023-01-08 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-01-08 10:25:28','2023-01-08 10:25:28',NULL,'1','Add New Invoice','1'),
('1377','VR-23-1377','2023-01-08 00:00:00','0','1250.00','1','248.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-08 13:26:00','2023-01-08 13:26:00',NULL,'1','Add New Invoice','1'),
('1378','VR-23-1378','2023-01-08 00:00:00','0','1250.00','1','430.52','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-08 13:38:18','2023-01-08 13:38:18',NULL,'1','Add New Invoice','1'),
('1379','VR-23-1379','2023-01-08 00:00:00','0','1250.00','1','342.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-01-08 13:39:05','2023-01-08 13:39:05',NULL,'1','Add New Invoice','1'),
('1380','VR-23-1380','2023-01-08 00:00:00','0','1250.00','1','119.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-08 14:00:48','2023-01-08 14:00:48',NULL,'1','Add New Invoice','1'),
('1381','VR-23-1381','2023-01-08 00:00:00','0','1250.00','1','76.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-01-08 15:25:49','2023-01-08 15:25:49',NULL,'1','Add New Invoice','1'),
('1382','VR-23-1382','2023-01-09 00:00:00','0','1250.00','1','1280.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-01-09 11:34:45','2023-03-08 04:13:19',NULL,'1','Update Invoice','1'),
('1383','VR-23-1383','2023-01-09 00:00:00','0','1250.00','1','211.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-01-09 14:52:48','2023-01-09 14:52:48',NULL,'1','Add New Invoice','1'),
('1384','VR-23-1384','2023-01-09 00:00:00','0','1250.00','1','234.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-09 18:44:50','2023-01-09 18:44:50',NULL,'1','Add New Invoice','1'),
('1385','VR-23-1385','2023-01-10 00:00:00','0','1250.00','1','136.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-01-10 11:43:24','2023-01-10 11:43:24',NULL,'1','Add New Invoice','1'),
('1386','VR-23-1386','2023-01-11 00:00:00','0','1250.00','1','2164.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-11 09:49:07','2023-01-11 09:49:07',NULL,'1','Add New Invoice','1'),
('1387','VR-23-1387','2023-01-11 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-11 10:04:22','2023-01-11 10:04:22',NULL,'1','Add New Invoice','1'),
('1388','VR-23-1388','2023-01-11 00:00:00','0','1250.00','1','157.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-01-11 11:47:42','2023-01-11 11:47:42',NULL,'1','Add New Invoice','1'),
('1389','VR-23-1389','2023-01-11 00:00:00','0','1250.00','1','465.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-01-11 17:40:03','2023-01-11 17:40:03',NULL,'1','Add New Invoice','1'),
('1390','INV-23-1390','2023-01-14 00:00:00','0','1250.00','1','146.52','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-01-14 10:09:36','2023-01-14 10:09:36',NULL,'1','Add New Invoice','1'),
('1391','VR-23-1391','2023-01-14 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-01-14 13:45:26','2023-01-16 10:49:57',NULL,'1','Update Invoice','1'),
('1392','VR-23-1392','2023-01-16 00:00:00','0','1250.00','1','236.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-01-16 11:54:28','2023-01-16 12:15:33',NULL,'1','Update Invoice','1'),
('1393','VR-23-1393','2023-01-16 00:00:00','0','1250.00','1','184.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-01-16 14:20:52','2023-01-16 02:31:14',NULL,'1','Update Invoice','1'),
('1394','VR-23-1394','2023-01-16 00:00:00','0','1250.00','1','325.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2023-01-16 14:45:27','2023-01-16 02:51:43','2023-01-17 04:07:38','1','Delete Invoice','1'),
('1395','VR-23-1395','2023-01-16 00:00:00','0','1250.00','1','4126.39','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-16 16:18:59','2023-01-16 16:18:59',NULL,'1','Add New Invoice','1'),
('1396','VR-23-1396','2023-01-16 00:00:00','0','1250.00','1','246.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-16 16:27:15','2023-01-16 16:27:15',NULL,'1','Add New Invoice','1'),
('1397','VR-23-1397','2023-01-16 00:00:00','0','1250.00','1','155.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-01-16 17:25:41','2023-01-16 17:25:41',NULL,'1','Add New Invoice','1'),
('1398','VR-23-1398','2023-01-16 00:00:00','0','1250.00','1','238.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-01-16 17:44:31','2023-01-16 17:44:31',NULL,'1','Add New Invoice','1'),
('1399','VR-23-1399','2023-01-16 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-01-16 18:00:39','2023-01-16 18:00:39',NULL,'1','Add New Invoice','1'),
('1400','VR-23-1400','2023-01-16 00:00:00','0','1250.00','1','188.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-01-16 18:08:49','2023-01-16 18:08:49',NULL,'1','Add New Invoice','1'),
('1401','VR-23-1401','2023-01-17 00:00:00','0','1250.00','1','336.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-17 10:10:29','2023-01-17 10:10:29',NULL,'1','Add New Invoice','1'),
('1402','VR-23-1402','2023-01-17 00:00:00','0','1250.00','1','561.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-01-17 11:03:41','2023-01-17 11:03:41',NULL,'1','Add New Invoice','1'),
('1403','VR-23-1403','2023-01-18 00:00:00','0','1250.00','1','88.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-01-18 11:01:57','2023-01-30 01:07:16',NULL,'1','Update Invoice','1'),
('1404','VR-23-1404','2023-01-18 00:00:00','0','1250.00','1','130.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-18 11:05:45','2023-01-18 11:05:45',NULL,'1','Add New Invoice','1'),
('1405','VR-23-1405','2023-01-18 00:00:00','0','1250.00','1','200.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-18 11:08:43','2023-01-18 11:08:43',NULL,'1','Add New Invoice','1'),
('1406','VR-23-1406','2023-01-18 00:00:00','0','1250.00','1','100.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-01-18 12:04:43','2023-01-18 12:04:43',NULL,'1','Add New Invoice','1'),
('1407','VR-23-1407','2023-01-18 00:00:00','0','1250.00','1','1034.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-01-18 13:43:22','2023-03-27 04:47:52',NULL,'1','Update Invoice','1'),
('1408','VR-23-1408','2023-01-18 00:00:00','0','1250.00','1','5084.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-01-18 14:01:14','2023-01-19 01:55:49',NULL,'1','Update Invoice','1'),
('1409','VR-23-1409','2023-01-18 00:00:00','0','1250.00','1','1298.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-18 14:05:46','2023-01-18 14:05:46',NULL,'1','Add New Invoice','1'),
('1410','VR-23-1410','2023-01-18 00:00:00','0','1250.00','1','136.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-01-18 16:02:09','2023-01-18 16:02:09',NULL,'1','Add New Invoice','1'),
('1411','VR-23-1411','2023-01-18 00:00:00','0','1250.00','1','140.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-01-18 16:17:29','2023-01-18 16:17:29',NULL,'1','Add New Invoice','1'),
('1412','VR-23-1412','2023-01-18 00:00:00','0','1250.00','1','147.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','1','2023-01-18 16:33:34','2023-01-18 04:52:37','2023-03-18 09:46:12','1','Delete Invoice','1'),
('1413','VR-23-1413','2023-01-19 00:00:00','0','1250.00','1','332.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-19 09:46:49','2023-01-19 09:46:49',NULL,'1','Add New Invoice','1'),
('1414','VR-23-1414','2023-01-19 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-01-19 09:55:38','2023-01-19 10:12:18',NULL,'1','Update Invoice','1'),
('1415','VR-23-1415','2023-01-19 00:00:00','0','1250.00','1','3761.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-01-19 13:18:13','2023-01-19 13:18:13',NULL,'1','Add New Invoice','1'),
('1416','VR-23-1416','2023-01-19 00:00:00','0','1250.00','1','71.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-01-19 13:53:17','2023-01-19 13:53:17',NULL,'1','Add New Invoice','1'),
('1417','VR-23-1417','2023-01-19 00:00:00','0','1250.00','1','103.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-01-19 13:58:01','2023-01-19 13:58:01',NULL,'1','Add New Invoice','1'),
('1418','VR-23-1418','2023-01-19 00:00:00','0','1250.00','1','57.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-01-19 14:12:22','2023-01-19 14:12:22',NULL,'1','Add New Invoice','1'),
('1419','VR-23-1419','2023-01-19 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-01-19 16:42:17','2023-01-19 16:42:17',NULL,'1','Add New Invoice','1'),
('1420','VR-23-1420','2023-01-21 00:00:00','0','1250.00','1','164.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-21 10:30:19','2023-01-21 10:30:19',NULL,'1','Add New Invoice','1'),
('1421','VR-23-1421','2023-01-21 00:00:00','0','1250.00','1','325.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-01-21 12:32:45','2023-01-21 12:32:45',NULL,'1','Add New Invoice','1'),
('1422','VR-23-1422','2023-01-21 00:00:00','0','1250.00','1','315.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-21 13:57:58','2023-01-21 13:57:58',NULL,'1','Add New Invoice','1'),
('1423','VR-23-1423','2023-01-21 00:00:00','0','1250.00','1','246.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-01-21 14:29:00','2023-01-21 14:29:00',NULL,'1','Add New Invoice','1'),
('1424','VR-23-1424','2023-01-21 00:00:00','0','1250.00','1','8.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-01-21 14:46:25','2023-01-21 14:46:25',NULL,'1','Add New Invoice','1'),
('1425','VR-23-1425','2023-01-21 00:00:00','0','1250.00','1','460.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-01-21 15:07:40','2023-01-21 15:07:40',NULL,'1','Add New Invoice','1'),
('1426','VR-23-1426','2023-01-22 00:00:00','0','1250.00','1','389.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-22 09:45:58','2023-01-22 09:45:58',NULL,'1','Add New Invoice','1'),
('1427','VR-23-1427','2023-01-22 00:00:00','0','1250.00','1','144.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-22 09:53:40','2023-01-22 09:53:40',NULL,'1','Add New Invoice','1'),
('1428','VR-23-1428','2023-01-22 00:00:00','0','1250.00','1','292.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-01-22 10:02:18','2023-01-22 10:02:18',NULL,'1','Add New Invoice','1'),
('1429','VR-23-1429','2023-01-22 00:00:00','0','1250.00','1','176.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-01-22 14:39:09','2023-01-22 14:39:09',NULL,'1','Add New Invoice','1'),
('1430','VR-23-1430','2023-01-22 00:00:00','0','1250.00','1','292.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-01-22 14:41:33','2023-01-22 14:41:33',NULL,'1','Add New Invoice','1'),
('1431','VR-23-1431','2023-01-22 00:00:00','0','1250.00','1','127.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-01-22 15:14:19','2023-01-22 15:14:19',NULL,'1','Add New Invoice','1'),
('1432','VR-23-1432','2023-01-23 00:00:00','0','1250.00','1','261.89','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-23 10:04:20','2023-01-23 10:04:20',NULL,'1','Add New Invoice','1'),
('1433','VR-23-1433','2023-01-23 00:00:00','0','1250.00','1','563.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-23 15:20:21','2023-01-23 15:20:21',NULL,'1','Add New Invoice','1'),
('1434','VR-23-1434','2023-01-24 00:00:00','0','1250.00','1','345.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-01-24 10:37:15','2023-01-24 10:37:15',NULL,'1','Add New Invoice','1'),
('1435','VR-23-1435','2023-01-25 00:00:00','0','1250.00','1','67.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-01-25 11:07:32','2023-01-25 11:07:32',NULL,'1','Add New Invoice','1'),
('1436','VR-23-1436','2023-01-25 00:00:00','0','1250.00','1','400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-01-25 11:19:32','2023-01-25 11:19:32',NULL,'1','Add New Invoice','1'),
('1437','VR-23-1437','2023-01-25 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-01-25 13:22:19','2023-01-25 13:22:19',NULL,'1','Add New Invoice','1'),
('1438','VR-23-1438','2023-01-25 00:00:00','0','1250.00','1','93.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-01-25 13:31:31','2023-01-25 13:31:31',NULL,'1','Add New Invoice','1'),
('1439','VR-23-1439','2023-01-25 00:00:00','0','1250.00','1','35.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-01-25 13:32:53','2023-01-25 13:32:53',NULL,'1','Add New Invoice','1'),
('1440','VR-23-1440','2023-01-25 00:00:00','0','1250.00','1','13.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-01-25 13:40:50','2023-01-25 13:40:50',NULL,'1','Add New Invoice','1'),
('1441','VR-23-1441','2023-01-25 00:00:00','0','1250.00','1','33.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-01-25 13:45:06','2023-01-25 13:45:06',NULL,'1','Add New Invoice','1'),
('1442','VR-23-1442','2023-01-25 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-25 16:50:59','2023-01-25 16:50:59',NULL,'1','Add New Invoice','1'),
('1443','VR-23-1443','2023-01-26 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-01-26 10:05:14','2023-01-26 10:05:14',NULL,'1','Add New Invoice','1'),
('1444','VR-23-1444','2023-01-26 00:00:00','0','1250.00','1','54.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-26 10:11:04','2023-01-26 10:11:04',NULL,'1','Add New Invoice','1'),
('1445','VR-23-1445','2023-01-26 00:00:00','0','1250.00','1','46.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-01-26 10:16:08','2023-01-26 10:16:08',NULL,'1','Add New Invoice','1'),
('1446','VR-23-1446','2023-01-26 00:00:00','0','1250.00','1','200.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-26 13:18:55','2023-01-26 13:18:55',NULL,'1','Add New Invoice','1'),
('1447','VR-23-1447','2023-01-26 00:00:00','0','1250.00','1','147.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-26 14:00:27','2023-01-26 14:00:27',NULL,'1','Add New Invoice','1'),
('1448','VR-23-1448','2023-01-26 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-01-26 14:04:28','2023-01-26 14:04:28',NULL,'1','Add New Invoice','1'),
('1449','VR-23-1449','2023-01-26 00:00:00','0','1250.00','1','59.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','1','2023-01-26 14:13:12','2023-01-26 14:13:12','2023-02-07 04:38:58','1','Delete Invoice','1'),
('1450','VR-23-1450','2023-01-26 00:00:00','0','1250.00','1','40.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-01-26 14:21:18','2023-01-26 14:21:18',NULL,'1','Add New Invoice','1'),
('1451','VR-23-1451','2023-01-28 00:00:00','0','1250.00','1','400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-01-28 15:39:02','2023-01-28 15:39:02',NULL,'1','Add New Invoice','1'),
('1452','VR-23-1452','2023-01-30 00:00:00','0','1250.00','1','957.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-01-30 09:47:35','2023-01-30 09:47:35',NULL,'1','Add New Invoice','1'),
('1453','VR-23-1453','2023-01-30 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-01-30 11:00:15','2023-01-30 11:00:15',NULL,'1','Add New Invoice','1'),
('1454','VR-23-1454','2023-01-30 00:00:00','0','1250.00','1','9.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-01-30 11:38:37','2023-01-30 11:38:37',NULL,'1','Add New Invoice','1'),
('1455','VR-23-1455','2023-01-30 00:00:00','0','1250.00','1','1393.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-30 11:50:02','2023-01-30 11:50:02',NULL,'1','Add New Invoice','1'),
('1456','VR-23-1456','2023-01-30 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-01-30 11:53:55','2023-01-30 11:53:55',NULL,'1','Add New Invoice','1'),
('1457','VR-23-1457','2023-01-30 00:00:00','0','1250.00','1','250.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','1','2023-01-30 12:00:34','2023-01-30 12:00:34','2023-02-25 04:23:49','1','Delete Invoice','1'),
('1458','VR-23-1458','2023-01-30 00:00:00','0','1250.00','1','30.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-01-30 12:01:54','2023-01-30 12:02:48',NULL,'1','Update Invoice','1'),
('1459','VR-23-1459','2023-01-30 00:00:00','0','1250.00','1','529.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-01-30 12:10:39','2023-01-30 12:10:39',NULL,'1','Add New Invoice','1'),
('1460','VR-23-1460','2023-01-31 00:00:00','0','1250.00','1','316.51','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-01-31 10:27:03','2023-01-31 10:27:03',NULL,'1','Add New Invoice','1'),
('1461','VR-23-1461','2023-01-31 00:00:00','0','1250.00','1','59.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-01-31 10:31:29','2023-01-31 10:31:29',NULL,'1','Add New Invoice','1'),
('1462','VR-23-1462','2023-01-31 00:00:00','0','1250.00','1','165.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-01-31 10:37:16','2023-01-31 10:37:16',NULL,'1','Add New Invoice','1'),
('1463','VR-23-1463','2023-01-31 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-01-31 10:38:48','2023-01-31 10:38:48',NULL,'1','Add New Invoice','1'),
('1464','VR-23-1464','2023-01-31 00:00:00','0','1250.00','1','416.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-01-31 10:50:05','2023-01-31 10:53:27',NULL,'1','Update Invoice','1'),
('1465','VR-23-1465','2023-01-31 00:00:00','0','1250.00','1','1968.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-01-31 16:08:32','2023-01-31 16:08:32',NULL,'1','Add New Invoice','1'),
('1466','VR-23-1466','2023-01-31 00:00:00','0','1250.00','1','17.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-01-31 16:24:35','2023-01-31 16:24:35',NULL,'1','Add New Invoice','1'),
('1467','VR-23-1467','2023-01-31 00:00:00','0','1250.00','1','313.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-01-31 16:30:51','2023-01-31 16:30:51',NULL,'1','Add New Invoice','1'),
('1468','VR-23-1468','2023-02-01 00:00:00','0','1250.00','1','774.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-01 16:29:51','2023-02-01 16:29:51',NULL,'1','Add New Invoice','1'),
('1469','VR-23-1469','2023-02-02 00:00:00','0','1250.00','1','1367.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-02-02 10:17:19','2023-02-02 10:17:19',NULL,'1','Add New Invoice','1'),
('1470','VR-23-1470','2023-02-02 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-02-02 14:18:33','2023-02-02 14:18:33',NULL,'1','Add New Invoice','1'),
('1471','VR-23-1471','2023-02-02 00:00:00','0','1250.00','1','272.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-02-02 15:51:02','2023-02-02 15:51:02',NULL,'1','Add New Invoice','1'),
('1472','VR-23-1472','2023-02-02 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-02-02 16:31:31','2023-02-02 04:41:46',NULL,'1','Update Invoice','1'),
('1473','VR-23-1473','2023-02-02 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-02-02 16:47:30','2023-02-04 11:22:25',NULL,'1','Update Invoice','1'),
('1474','VR-23-1474','2023-02-04 00:00:00','0','1250.00','1','1529.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-02-04 09:40:47','2023-02-04 09:40:47',NULL,'1','Add New Invoice','1'),
('1475','VR-23-1475','2023-02-04 00:00:00','0','1250.00','1','268.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-02-04 09:55:55','2023-02-04 09:55:55',NULL,'1','Add New Invoice','1'),
('1476','VR-23-1476','2023-02-04 00:00:00','0','1250.00','1','175.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-02-04 10:01:51','2023-02-04 10:01:51',NULL,'1','Add New Invoice','1'),
('1477','VR-23-1477','2023-02-04 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-02-04 11:33:51','2023-02-04 11:33:51',NULL,'1','Add New Invoice','1'),
('1478','VR-23-1478','2023-02-04 00:00:00','0','1250.00','1','1244.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-04 12:08:41','2023-02-04 12:08:41',NULL,'1','Add New Invoice','1'),
('1479','VR-23-1479','2023-02-04 00:00:00','0','1250.00','1','440.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-02-04 12:20:03','2023-02-04 12:20:03',NULL,'1','Add New Invoice','1'),
('1480','VR-23-1480','2023-02-04 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-02-04 13:38:31','2023-02-04 03:35:51',NULL,'1','Update Invoice','1'),
('1481','VR-23-1481','2023-02-04 00:00:00','0','1250.00','1','326.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-02-04 14:58:00','2023-02-04 14:58:00',NULL,'1','Add New Invoice','1'),
('1482','VR-23-1482','2023-02-05 00:00:00','0','1250.00','1','247.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-02-05 10:00:19','2023-02-05 10:00:19',NULL,'1','Add New Invoice','1'),
('1483','VR-23-1483','2023-02-05 00:00:00','0','1250.00','1','250.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-02-05 10:04:01','2023-02-05 10:04:01',NULL,'1','Add New Invoice','1'),
('1484','VR-23-1484','2023-02-05 00:00:00','0','1250.00','1','466.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-02-05 11:14:02','2023-02-05 11:14:02',NULL,'1','Add New Invoice','1'),
('1485','VR-23-1485','2023-02-05 00:00:00','0','1250.00','1','940.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-02-05 11:24:58','2023-02-05 11:24:58',NULL,'1','Add New Invoice','1'),
('1486','VR-23-1486','2023-02-05 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-02-05 11:36:14','2023-02-05 11:36:14',NULL,'1','Add New Invoice','1'),
('1487','VR-23-1487','2023-02-05 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-02-05 11:49:09','2023-02-05 11:49:09',NULL,'1','Add New Invoice','1'),
('1488','VR-23-1488','2023-02-06 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-06 15:17:51','2023-02-06 15:17:51',NULL,'1','Add New Invoice','1'),
('1489','VR-23-1489','2023-02-07 00:00:00','0','1250.00','1','247.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-07 15:16:42','2023-02-07 15:16:42',NULL,'1','Add New Invoice','1'),
('1490','VR-23-1490','2023-02-07 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','1','2023-02-07 15:37:07','2023-02-07 15:37:07','2023-02-07 04:41:48','1','Delete Invoice','1'),
('1491','VR-23-1491','2023-02-07 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-02-07 17:07:42','2023-02-07 17:07:42',NULL,'1','Add New Invoice','1'),
('1492','VR-23-1492','2023-02-07 00:00:00','0','1250.00','1','371.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-02-07 17:13:24','2023-02-07 17:13:24',NULL,'1','Add New Invoice','1'),
('1493','VR-23-1493','2023-02-08 00:00:00','0','1250.00','1','186.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-02-08 10:11:31','2023-02-08 10:11:31',NULL,'1','Add New Invoice','1'),
('1494','VR-23-1494','2023-02-08 00:00:00','0','1250.00','1','163.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-02-08 10:15:31','2023-02-08 10:15:31',NULL,'1','Add New Invoice','1'),
('1495','VR-23-1495','2023-02-08 00:00:00','0','1250.00','1','147.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2023-02-08 10:38:44','2023-02-08 10:38:44',NULL,'1','Add New Invoice','1'),
('1496','VR-23-1496','2023-02-08 00:00:00','0','1250.00','1','111.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-08 11:27:35','2023-02-08 11:27:35',NULL,'1','Add New Invoice','1'),
('1497','VR-23-1497','2023-02-08 00:00:00','0','1250.00','1','170.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-08 13:37:58','2023-02-08 13:37:58',NULL,'1','Add New Invoice','1'),
('1498','VR-23-1498','2023-02-08 00:00:00','0','1250.00','1','488.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-02-08 14:30:51','2023-02-08 02:32:25',NULL,'1','Update Invoice','1'),
('1499','VR-23-1499','2023-02-09 00:00:00','0','1250.00','1','42.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-02-09 10:11:55','2023-02-09 10:11:55',NULL,'1','Add New Invoice','1'),
('1500','VR-23-1500','2023-02-09 00:00:00','0','1250.00','1','65.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-02-09 14:42:10','2023-02-09 14:42:10',NULL,'1','Add New Invoice','1'),
('1501','VR-23-1501','2023-02-09 00:00:00','0','1250.00','1','204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-02-09 15:38:53','2023-02-09 15:38:53',NULL,'1','Add New Invoice','1'),
('1502','VR-23-1502','2023-02-11 00:00:00','0','1250.00','1','286.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-11 11:26:18','2023-02-11 11:26:18',NULL,'1','Add New Invoice','1'),
('1503','VR-23-1503','2023-02-12 00:00:00','0','1250.00','1','280.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-02-12 11:38:33','2023-02-12 11:38:33',NULL,'1','Add New Invoice','1'),
('1504','VR-23-1504','2023-02-12 00:00:00','0','1250.00','1','138.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-02-12 11:41:38','2023-02-12 11:41:38',NULL,'1','Add New Invoice','1'),
('1505','VR-23-1505','2023-02-12 00:00:00','0','1250.00','1','121.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-02-12 11:47:49','2023-02-12 11:47:49',NULL,'1','Add New Invoice','1'),
('1506','INV-23-1506','2023-02-15 00:00:00','0','1250.00','1','2.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','97','1','2023-02-15 10:58:02','2023-02-15 10:58:02','2023-02-15 11:03:11','1','Delete Invoice','1'),
('1507','VR-23-1507','2023-02-15 00:00:00','0','1250.00','1','1694.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-15 12:12:33','2023-02-15 12:12:33',NULL,'1','Add New Invoice','1'),
('1508','VR-23-1508','2023-02-15 00:00:00','0','1250.00','1','469.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-02-15 12:19:36','2023-02-15 12:19:36',NULL,'1','Add New Invoice','1'),
('1509','VR-23-1509','2023-02-15 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-15 13:11:53','2023-02-15 13:11:53',NULL,'1','Add New Invoice','1'),
('1510','VR-23-1510','2023-02-15 00:00:00','0','1250.00','1','160.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-02-15 14:50:33','2023-02-15 14:50:33',NULL,'1','Add New Invoice','1'),
('1511','VR-23-1511','2023-02-16 00:00:00','0','1250.00','1','394.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-16 13:21:23','2023-02-16 01:28:48',NULL,'1','Update Invoice','1'),
('1512','VR-23-1512','2023-02-18 00:00:00','0','1250.00','1','199.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-18 09:32:06','2023-02-18 09:32:06',NULL,'1','Add New Invoice','1'),
('1513','VR-23-1513','2023-02-18 00:00:00','0','1250.00','1','206.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-02-18 10:24:46','2023-02-18 10:24:46',NULL,'1','Add New Invoice','1'),
('1514','VR-23-1514','2023-02-18 00:00:00','0','1250.00','1','25.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-02-18 10:30:49','2023-02-18 10:30:49',NULL,'1','Add New Invoice','1'),
('1515','VR-23-1515','2023-02-18 00:00:00','0','1250.00','1','3131.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-02-18 10:40:43','2023-02-18 10:40:43',NULL,'1','Add New Invoice','1'),
('1516','VR-23-1516','2023-02-18 00:00:00','0','1250.00','1','12.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-02-18 10:47:56','2023-02-18 10:47:56',NULL,'1','Add New Invoice','1'),
('1517','VR-23-1517','2023-02-18 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-02-18 10:56:23','2023-02-18 10:56:23',NULL,'1','Add New Invoice','1'),
('1518','VR-23-1518','2023-02-19 00:00:00','0','1250.00','1','136.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-02-19 17:56:38','2023-02-19 17:56:38',NULL,'1','Add New Invoice','1'),
('1519','VR-23-1519','2023-02-20 00:00:00','0','1250.00','1','1204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','98','1','2023-02-20 11:26:26','2023-02-20 11:26:26','2023-02-20 11:26:58','1','Delete Invoice','1'),
('1520','VR-23-1520','2023-02-20 00:00:00','0','1250.00','1','1204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','98','0','2023-02-20 11:26:34','2023-02-20 11:26:34',NULL,'1','Add New Invoice','1'),
('1521','VR-23-1521','2023-02-20 00:00:00','0','1250.00','1','329.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-20 12:39:34','2023-02-20 12:39:34',NULL,'1','Add New Invoice','1'),
('1522','VR-23-1522','2023-02-20 00:00:00','0','1250.00','1','17567.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-20 16:49:49','2023-02-20 16:49:49',NULL,'1','Add New Invoice','1'),
('1523','VR-23-1523','2023-02-21 00:00:00','0','1250.00','1','1006.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-21 09:43:32','2023-02-21 09:43:32',NULL,'1','Add New Invoice','1'),
('1524','VR-23-1524','2023-02-21 00:00:00','0','1250.00','1','42.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-02-21 11:05:10','2023-02-21 11:05:10',NULL,'1','Add New Invoice','1'),
('1525','VR-23-1525','2023-02-21 00:00:00','0','1250.00','1','320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-02-21 11:11:28','2023-02-21 11:11:28',NULL,'1','Add New Invoice','1'),
('1526','VR-23-1526','2023-02-21 00:00:00','0','1250.00','1','228.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-02-21 11:22:37','2023-03-06 10:19:11',NULL,'1','Update Invoice','1'),
('1527','VR-23-1527','2023-02-21 00:00:00','0','1250.00','1','4128.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-02-21 12:02:18','2023-02-21 12:02:18',NULL,'1','Add New Invoice','1'),
('1528','VR-23-1528','2023-02-21 00:00:00','0','1250.00','1','348.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-02-21 16:22:09','2023-02-21 16:22:09',NULL,'1','Add New Invoice','1'),
('1529','VR-23-1529','2023-02-22 00:00:00','0','1250.00','1','1384.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-02-22 10:02:27','2023-03-15 03:56:17',NULL,'1','Update Invoice','1'),
('1530','VR-23-1530','2023-02-22 00:00:00','0','1250.00','1','380.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-02-22 10:49:34','2023-02-22 10:49:34',NULL,'1','Add New Invoice','1'),
('1531','VR-23-1531','2023-02-22 00:00:00','0','1250.00','1','3111.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-02-22 14:08:16','2023-02-22 14:08:16',NULL,'1','Add New Invoice','1'),
('1532','VR-23-1532','2023-02-22 00:00:00','0','1250.00','1','775.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-02-22 14:16:06','2023-02-22 14:16:06',NULL,'1','Add New Invoice','1'),
('1533','VR-23-1533','2023-02-22 00:00:00','0','1250.00','1','72.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-02-22 14:52:07','2023-02-22 14:52:07',NULL,'1','Add New Invoice','1'),
('1534','VR-23-1534','2023-02-23 00:00:00','0','1250.00','1','1716.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-02-23 14:35:31','2023-02-23 02:49:53',NULL,'1','Update Invoice','1'),
('1535','VR-23-1535','2023-02-23 00:00:00','0','1250.00','1','125.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-23 14:55:02','2023-02-23 14:55:02',NULL,'1','Add New Invoice','1'),
('1536','VR-23-1536','2023-02-23 00:00:00','0','1250.00','1','245.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-02-23 15:01:29','2023-02-28 01:27:58',NULL,'1','Update Invoice','1'),
('1537','VR-23-1537','2023-02-23 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-02-23 15:04:11','2023-02-23 15:04:11',NULL,'1','Add New Invoice','1'),
('1538','VR-23-1538','2023-02-23 00:00:00','0','1250.00','1','119.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-02-23 15:22:02','2023-02-23 15:22:02',NULL,'1','Add New Invoice','1'),
('1539','VR-23-1539','2023-02-23 00:00:00','0','1250.00','1','91.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-02-23 15:33:37','2023-02-23 15:33:37',NULL,'1','Add New Invoice','1'),
('1540','VR-23-1540','2023-02-23 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','1','2023-02-23 16:49:53','2023-02-23 16:49:53','2023-02-23 05:18:59','1','Delete Invoice','1'),
('1541','VR-23-1541','2023-02-25 00:00:00','0','1250.00','1','287.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-02-25 09:09:10','2023-02-25 09:09:57',NULL,'1','Update Invoice','1'),
('1542','VR-23-1542','2023-02-25 00:00:00','0','1250.00','1','419.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-02-25 14:00:30','2023-02-25 14:00:30',NULL,'1','Add New Invoice','1'),
('1543','VR-23-1543','2023-02-25 00:00:00','0','1250.00','1','197.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-02-25 14:04:18','2023-02-25 14:04:18',NULL,'1','Add New Invoice','1'),
('1544','VR-23-1544','2023-02-25 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-02-25 14:11:45','2023-02-25 14:11:45',NULL,'1','Add New Invoice','1'),
('1545','VR-23-1545','2023-02-25 00:00:00','0','1250.00','1','92.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-02-25 14:16:09','2023-02-25 14:16:09',NULL,'1','Add New Invoice','1'),
('1546','VR-23-1546','2023-02-25 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-02-25 15:04:30','2023-02-25 15:04:30',NULL,'1','Add New Invoice','1'),
('1547','VR-23-1547','2023-02-25 00:00:00','0','1250.00','1','760.00','0.00','ط','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-02-25 15:22:32','2023-02-25 15:22:32',NULL,'1','Add New Invoice','1'),
('1548','VR-23-1548','2023-02-25 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-02-25 16:06:47','2023-02-25 16:06:47',NULL,'1','Add New Invoice','1'),
('1549','VR-23-1549','2023-02-26 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-02-26 09:59:17','2023-02-26 09:59:17',NULL,'1','Add New Invoice','1'),
('1550','VR-23-1550','2023-02-26 00:00:00','0','1250.00','1','71.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-02-26 10:26:22','2023-02-26 02:56:39',NULL,'1','Update Invoice','1'),
('1551','VR-23-1551','2023-02-26 00:00:00','0','1250.00','1','601.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-02-26 11:27:15','2023-02-26 11:27:15',NULL,'1','Add New Invoice','1'),
('1552','VR-23-1552','2023-02-26 00:00:00','0','1250.00','1','905.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-02-26 14:24:25','2023-02-26 14:24:25',NULL,'1','Add New Invoice','1'),
('1553','VR-23-1553','2023-02-27 00:00:00','0','1250.00','1','266.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-02-27 16:22:57','2023-02-27 16:22:57',NULL,'1','Add New Invoice','1'),
('1554','VR-23-1554','2023-02-27 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-02-27 16:30:01','2023-03-01 02:49:55',NULL,'1','Update Invoice','1'),
('1555','VR-23-1555','2023-03-01 00:00:00','0','1250.00','1','492.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-01 15:35:52','2023-03-01 15:35:52',NULL,'1','Add New Invoice','1'),
('1556','VR-23-1556','2023-03-01 00:00:00','0','1250.00','1','186.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-03-01 15:38:49','2023-03-01 15:38:49',NULL,'1','Add New Invoice','1'),
('1557','VR-23-1557','2023-03-02 00:00:00','0','1250.00','1','7719.39','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-03-02 14:46:55','2023-03-04 11:17:20',NULL,'1','Update Invoice','1'),
('1558','VR-23-1558','2023-03-02 00:00:00','0','1250.00','1','392.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-02 16:37:25','2023-03-02 16:37:25',NULL,'1','Add New Invoice','1'),
('1559','VR-23-1559','2023-03-04 00:00:00','0','1250.00','1','12252.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-03-04 10:25:59','2023-03-04 10:46:47',NULL,'1','Update Invoice','1'),
('1560','VR-23-1560','2023-03-04 00:00:00','0','1250.00','1','2912.99','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-03-04 11:40:05','2023-03-04 11:40:05',NULL,'1','Add New Invoice','1'),
('1561','VR-23-1561','2023-03-04 00:00:00','0','1250.00','1','268.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-03-04 12:50:21','2023-03-04 12:50:21',NULL,'1','Add New Invoice','1'),
('1562','VR-23-1562','2023-03-04 00:00:00','0','1250.00','1','47.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-03-04 15:28:09','2023-03-04 15:28:09',NULL,'1','Add New Invoice','1'),
('1563','VR-23-1563','2023-03-05 00:00:00','0','1250.00','1','147.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-05 10:46:16','2023-03-05 10:46:16',NULL,'1','Add New Invoice','1'),
('1564','VR-23-1564','2023-03-05 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-03-05 15:08:11','2023-03-05 15:08:11',NULL,'1','Add New Invoice','1'),
('1565','VR-23-1565','2023-03-05 00:00:00','0','1250.00','1','149.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-03-05 15:36:57','2023-03-06 10:18:21',NULL,'1','Update Invoice','1'),
('1566','VR-23-1566','2023-03-05 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-03-05 15:42:09','2023-03-05 15:42:09',NULL,'1','Add New Invoice','1'),
('1567','VR-23-1567','2023-03-05 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-03-05 15:51:57','2023-03-05 15:51:57',NULL,'1','Add New Invoice','1'),
('1568','VR-23-1568','2023-03-05 00:00:00','0','1250.00','1','479.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-03-05 16:04:44','2023-03-05 16:04:44',NULL,'1','Add New Invoice','1'),
('1569','VR-23-1569','2023-03-05 00:00:00','0','1250.00','1','152.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-03-05 17:24:39','2023-03-05 17:24:39',NULL,'1','Add New Invoice','1'),
('1570','VR-23-1570','2023-03-05 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-03-05 17:26:06','2023-03-05 17:26:06',NULL,'1','Add New Invoice','1'),
('1571','VR-23-1571','2023-03-06 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-03-06 11:18:15','2023-03-06 11:27:44',NULL,'1','Update Invoice','1'),
('1572','VR-23-1572','2023-03-06 00:00:00','0','1250.00','1','245.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-03-06 16:14:57','2023-03-06 16:14:57',NULL,'1','Add New Invoice','1'),
('1573','VR-23-1573','2023-03-07 00:00:00','0','1250.00','1','337.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-07 10:12:48','2023-03-07 10:12:48',NULL,'1','Add New Invoice','1'),
('1574','VR-23-1574','2023-03-07 00:00:00','0','1250.00','1','1069.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-03-07 10:55:24','2023-03-07 10:55:24',NULL,'1','Add New Invoice','1'),
('1575','VR-23-1575','2023-03-08 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-03-08 09:18:34','2023-03-08 09:18:34',NULL,'1','Add New Invoice','1'),
('1576','VR-23-1576','2023-03-08 00:00:00','0','1250.00','1','72.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-03-08 09:21:31','2023-03-08 09:21:31',NULL,'1','Add New Invoice','1'),
('1577','VR-23-1577','2023-03-08 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-03-08 09:24:05','2023-03-08 09:24:05',NULL,'1','Add New Invoice','1'),
('1578','VR-23-1578','2023-03-08 00:00:00','0','1250.00','1','28.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-03-08 09:31:39','2023-03-08 09:31:39',NULL,'1','Add New Invoice','1'),
('1579','VR-23-1579','2023-03-08 00:00:00','0','1250.00','1','1192.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-03-08 11:30:17','2023-03-08 11:30:17',NULL,'1','Add New Invoice','1'),
('1580','VR-23-1580','2023-03-08 00:00:00','0','1250.00','1','1950.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-03-08 14:13:30','2023-03-13 10:00:32',NULL,'1','Update Invoice','1'),
('1581','VR-23-1581','2023-03-09 00:00:00','0','1250.00','1','265.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-03-09 10:38:40','2023-03-09 10:38:40',NULL,'1','Add New Invoice','1'),
('1582','VR-23-1582','2023-03-09 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-03-09 10:46:32','2023-03-09 10:46:32',NULL,'1','Add New Invoice','1'),
('1583','VR-23-1583','2023-03-09 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-03-09 13:42:57','2023-03-09 13:42:57',NULL,'1','Add New Invoice','1'),
('1584','VR-23-1584','2023-03-12 00:00:00','0','1250.00','1','224.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-12 11:06:07','2023-03-12 11:06:07',NULL,'1','Add New Invoice','1'),
('1585','VR-23-1585','2023-03-12 00:00:00','0','1250.00','1','222.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-03-12 11:11:27','2023-03-12 11:11:27',NULL,'1','Add New Invoice','1'),
('1586','VR-23-1586','2023-03-12 00:00:00','0','1250.00','1','15.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-12 13:03:59','2023-03-12 13:03:59',NULL,'1','Add New Invoice','1'),
('1587','VR-23-1587','2023-03-12 00:00:00','0','1250.00','1','51.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-03-12 13:09:53','2023-03-12 13:09:53',NULL,'1','Add New Invoice','1'),
('1588','VR-23-1588','2023-03-14 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-03-14 09:32:48','2023-03-14 09:32:48',NULL,'1','Add New Invoice','1'),
('1589','VR-23-1589','2023-03-14 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-03-14 10:30:25','2023-03-14 10:30:25',NULL,'1','Add New Invoice','1'),
('1590','VR-23-1590','2023-03-15 00:00:00','0','1250.00','1','467.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-03-15 12:20:02','2023-03-15 12:20:02',NULL,'1','Add New Invoice','1'),
('1591','VR-23-1591','2023-03-15 00:00:00','0','1250.00','1','204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-03-15 12:27:42','2023-03-15 12:27:42',NULL,'1','Add New Invoice','1'),
('1592','VR-23-1592','2023-03-15 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-03-15 15:00:53','2023-03-15 04:33:04',NULL,'1','Update Invoice','1'),
('1593','VR-23-1593','2023-03-15 00:00:00','0','1250.00','1','55.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-03-15 15:08:52','2023-03-15 15:08:52',NULL,'1','Add New Invoice','1'),
('1594','VR-23-1594','2023-03-15 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-03-15 15:20:49','2023-03-15 15:20:49',NULL,'1','Add New Invoice','1'),
('1595','VR-23-1595','2023-03-15 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-03-15 15:29:07','2023-03-15 15:29:07',NULL,'1','Add New Invoice','1'),
('1596','VR-23-1596','2023-03-15 00:00:00','0','1250.00','1','13.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-03-15 15:30:31','2023-03-15 15:30:31',NULL,'1','Add New Invoice','1'),
('1597','VR-23-1597','2023-03-15 00:00:00','0','1250.00','1','375.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-03-15 15:37:08','2023-03-15 15:37:08',NULL,'1','Add New Invoice','1'),
('1598','VR-23-1598','2023-03-15 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-03-15 15:46:42','2023-03-15 15:46:42',NULL,'1','Add New Invoice','1'),
('1599','VR-23-1599','2023-03-15 00:00:00','0','1250.00','1','289.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-03-15 15:49:28','2023-03-15 15:49:28',NULL,'1','Add New Invoice','1'),
('1600','VR-23-1600','2023-03-16 00:00:00','0','1250.00','1','280.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-03-16 09:23:34','2023-03-16 09:23:34',NULL,'1','Add New Invoice','1'),
('1601','VR-23-1601','2023-03-18 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-03-18 17:08:00','2023-03-18 17:08:00',NULL,'1','Add New Invoice','1'),
('1602','VR-23-1602','2023-03-18 00:00:00','0','1250.00','1','148.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-03-18 17:19:29','2023-03-18 17:19:29',NULL,'1','Add New Invoice','1'),
('1603','VR-23-1603','2023-03-18 00:00:00','0','1250.00','1','131.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-03-18 17:22:51','2023-03-19 10:18:37',NULL,'1','Update Invoice','1'),
('1604','VR-23-1604','2023-03-20 00:00:00','0','1250.00','1','360.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-03-20 09:46:29','2023-03-20 09:46:29',NULL,'1','Add New Invoice','1'),
('1605','VR-23-1605','2023-03-20 00:00:00','0','1250.00','1','221.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-20 16:06:33','2023-03-20 16:06:33',NULL,'1','Add New Invoice','1'),
('1606','VR-23-1606','2023-03-20 00:00:00','0','1250.00','1','139.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-03-20 17:32:33','2023-03-20 05:49:16',NULL,'1','Update Invoice','1'),
('1607','VR-23-1607','2023-03-20 00:00:00','0','1250.00','1','99.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-03-20 17:34:20','2023-03-20 17:34:20',NULL,'1','Add New Invoice','1'),
('1608','VR-23-1608','2023-03-25 00:00:00','0','1250.00','1','2533.11','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-03-25 15:53:20','2023-03-25 04:19:51',NULL,'1','Update Invoice','1'),
('1609','VR-23-1609','2023-03-25 00:00:00','0','1250.00','1','468.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-03-25 16:32:52','2023-03-25 16:32:52',NULL,'1','Add New Invoice','1'),
('1610','VR-23-1610','2023-03-25 00:00:00','0','1250.00','1','1487.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-03-25 17:14:25','2023-03-25 17:14:25',NULL,'1','Add New Invoice','1'),
('1611','VR-23-1611','2023-03-26 00:00:00','0','1250.00','1','314.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-26 10:47:21','2023-03-26 10:47:21',NULL,'1','Add New Invoice','1'),
('1612','VR-23-1612','2023-03-26 00:00:00','0','1250.00','1','2128.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-03-26 13:44:22','2023-03-26 13:44:22',NULL,'1','Add New Invoice','1'),
('1613','VR-23-1613','2023-03-26 00:00:00','0','1250.00','1','3173.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-03-26 14:08:25','2023-03-30 01:23:46',NULL,'1','Update Invoice','1'),
('1614','VR-23-1614','2023-03-26 00:00:00','0','1250.00','1','123.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-03-26 16:05:08','2023-03-29 03:15:05',NULL,'1','Update Invoice','1'),
('1615','VR-23-1615','2023-03-26 00:00:00','0','1250.00','1','246.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-03-26 16:07:48','2023-03-26 16:07:48',NULL,'1','Add New Invoice','1'),
('1616','VR-23-1616','2023-03-26 00:00:00','0','1250.00','1','978.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-03-26 16:20:51','2023-05-02 04:11:59',NULL,'1','Update Invoice','1'),
('1617','VR-23-1617','2023-03-27 00:00:00','0','1250.00','1','38.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-03-27 11:55:34','2023-03-27 11:55:34',NULL,'1','Add New Invoice','1'),
('1618','VR-23-1618','2023-03-27 00:00:00','0','1250.00','1','135.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-03-27 12:02:31','2023-03-27 12:02:31',NULL,'1','Add New Invoice','1'),
('1619','VR-23-1619','2023-03-27 00:00:00','0','1250.00','1','151.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-03-27 12:40:05','2023-03-27 12:40:05',NULL,'1','Add New Invoice','1'),
('1620','VR-23-1620','2023-03-27 00:00:00','0','1250.00','1','111.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-03-27 12:47:56','2023-03-27 12:47:56',NULL,'1','Add New Invoice','1'),
('1621','VR-23-1621','2023-03-27 00:00:00','0','1250.00','1','1130.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-03-27 14:41:11','2023-03-27 14:41:11',NULL,'1','Add New Invoice','1'),
('1622','VR-23-1622','2023-03-27 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-03-27 14:48:09','2023-03-27 14:48:09',NULL,'1','Add New Invoice','1'),
('1623','VR-23-1623','2023-03-27 00:00:00','0','1250.00','1','166.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-03-27 15:00:44','2023-03-27 15:00:44',NULL,'1','Add New Invoice','1'),
('1624','VR-23-1624','2023-03-27 00:00:00','0','1250.00','1','248.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-03-27 15:28:26','2023-03-27 15:28:26',NULL,'1','Add New Invoice','1'),
('1625','VR-23-1625','2023-03-27 00:00:00','0','1250.00','1','111.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-03-27 15:31:38','2023-03-27 04:52:00',NULL,'1','Update Invoice','1'),
('1626','VR-23-1626','2023-03-27 00:00:00','0','1250.00','1','78.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-03-27 15:45:22','2023-03-27 15:45:22',NULL,'1','Add New Invoice','1'),
('1627','VR-23-1627','2023-03-27 00:00:00','0','1250.00','1','40.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-03-27 16:03:44','2023-03-27 16:03:44',NULL,'1','Add New Invoice','1'),
('1628','VR-23-1628','2023-03-27 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-03-27 16:04:44','2023-03-27 16:04:44',NULL,'1','Add New Invoice','1'),
('1629','VR-23-1629','2023-03-29 00:00:00','0','1250.00','1','245.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-03-29 10:02:58','2023-03-29 10:02:58',NULL,'1','Add New Invoice','1'),
('1630','VR-23-1630','2023-03-29 00:00:00','0','1250.00','1','36.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-03-29 11:39:21','2023-03-29 11:39:21',NULL,'1','Add New Invoice','1'),
('1631','VR-23-1631','2023-03-30 00:00:00','0','1250.00','1','7603.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-03-30 16:25:57','2023-03-30 16:25:57',NULL,'1','Add New Invoice','1'),
('1632','VR-23-1632','2023-04-01 00:00:00','0','1250.00','1','5833.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-01 11:14:08','2023-04-01 11:14:08',NULL,'1','Add New Invoice','1'),
('1633','VR-23-1633','2023-04-01 00:00:00','0','1250.00','1','110.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-04-01 11:29:47','2023-04-01 11:29:47',NULL,'1','Add New Invoice','1'),
('1634','VR-23-1634','2023-04-01 00:00:00','0','1250.00','1','199.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-04-01 11:37:55','2023-04-01 11:37:55',NULL,'1','Add New Invoice','1'),
('1635','VR-23-1635','2023-04-01 00:00:00','0','1250.00','1','766.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-04-01 11:40:19','2023-04-01 11:40:19',NULL,'1','Add New Invoice','1'),
('1636','VR-23-1636','2023-04-01 00:00:00','0','1250.00','1','540.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-01 11:42:34','2023-04-01 11:51:07',NULL,'1','Update Invoice','1'),
('1637','VR-23-1637','2023-04-01 00:00:00','0','1250.00','1','10.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-01 11:43:42','2023-04-01 11:43:42',NULL,'1','Add New Invoice','1'),
('1638','VR-23-1638','2023-04-01 00:00:00','0','1250.00','1','16283.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-01 12:40:31','2023-04-01 12:40:31',NULL,'1','Add New Invoice','1'),
('1639','VR-23-1639','2023-04-01 00:00:00','0','1250.00','1','15622.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-01 14:47:41','2023-04-01 14:47:41',NULL,'1','Add New Invoice','1'),
('1640','VR-23-1640','2023-04-01 00:00:00','0','1250.00','1','9635.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-01 16:47:11','2023-07-14 09:41:18',NULL,'1','Update Invoice','1'),
('1641','VR-23-1641','2023-04-02 00:00:00','0','1250.00','1','1053.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-04-02 16:01:27','2023-04-03 11:08:32',NULL,'1','Update Invoice','1'),
('1642','VR-23-1642','2023-04-02 00:00:00','0','1250.00','1','378.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-02 16:06:18','2023-04-02 16:06:18',NULL,'1','Add New Invoice','1'),
('1643','VR-23-1643','2023-04-02 00:00:00','0','1250.00','1','1965.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-02 16:11:48','2023-09-07 09:37:11',NULL,'1','Update Invoice','1'),
('1644','VR-23-1644','2023-04-02 00:00:00','0','1250.00','1','5176.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-04-02 16:44:31','2023-04-02 16:44:31',NULL,'1','Add New Invoice','1'),
('1645','VR-23-1645','2023-04-02 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-04-02 16:54:17','2023-04-02 16:54:17',NULL,'1','Add New Invoice','1'),
('1646','VR-23-1646','2023-04-03 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-04-03 09:36:30','2023-04-03 09:36:30',NULL,'1','Add New Invoice','1'),
('1647','VR-23-1647','2023-04-03 00:00:00','0','1250.00','1','281.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2023-04-03 10:51:15','2023-04-03 10:51:15',NULL,'1','Add New Invoice','1'),
('1648','VR-23-1648','2023-04-03 00:00:00','0','1250.00','1','1657.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-04-03 11:07:08','2023-04-03 11:07:08',NULL,'1','Add New Invoice','1'),
('1649','VR-23-1649','2023-04-03 00:00:00','0','1250.00','1','427.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','103','1','2023-04-03 13:17:07','2023-04-03 13:17:07','2023-04-08 02:26:20','1','Delete Invoice','1'),
('1650','VR-23-1650','2023-04-03 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-04-03 13:27:49','2023-04-03 13:27:49',NULL,'1','Add New Invoice','1'),
('1651','VR-23-1651','2023-04-03 00:00:00','0','1250.00','1','541.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-04-03 13:34:29','2023-04-03 13:34:29',NULL,'1','Add New Invoice','1'),
('1652','VR-23-1652','2023-04-03 00:00:00','0','1250.00','1','243.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-03 14:57:29','2023-04-03 14:57:29',NULL,'1','Add New Invoice','1'),
('1653','VR-23-1653','2023-04-03 00:00:00','0','1250.00','1','121.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-04-03 15:11:38','2023-04-04 03:51:13',NULL,'1','Update Invoice','1'),
('1654','VR-23-1654','2023-04-03 00:00:00','0','1250.00','1','8202.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-03 16:22:32','2023-04-26 05:02:32',NULL,'1','Update Invoice','1'),
('1655','VR-23-1655','2023-04-04 00:00:00','0','1250.00','1','2046.05','0.00','رياض محمد حي العدل','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-04 10:11:43','2023-04-04 10:11:43',NULL,'1','Add New Invoice','1'),
('1656','VR-23-1656','2023-04-04 00:00:00','0','1250.00','1','562.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-04 10:22:04','2023-04-04 10:22:04',NULL,'1','Add New Invoice','1'),
('1657','VR-23-1657','2023-04-04 00:00:00','0','1250.00','1','784.55','0.00','مهدي اسدي مدينة الصدر ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-04 15:40:43','2023-04-04 15:40:43',NULL,'1','Add New Invoice','1'),
('1658','VR-23-1658','2023-04-04 00:00:00','0','1250.00','1','354.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-04-04 15:52:39','2023-04-04 15:52:39',NULL,'1','Add New Invoice','1'),
('1659','VR-23-1659','2023-04-04 00:00:00','0','1250.00','1','415.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-04-04 16:07:09','2023-04-04 16:07:09',NULL,'1','Add New Invoice','1'),
('1660','VR-23-1660','2023-04-05 00:00:00','0','1250.00','1','687.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-04-05 13:20:11','2023-04-05 02:35:46',NULL,'1','Update Invoice','1'),
('1661','VR-23-1661','2023-04-05 00:00:00','0','1250.00','1','395.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-05 13:25:56','2023-04-05 13:25:56',NULL,'1','Add New Invoice','1'),
('1662','VR-23-1662','2023-04-05 00:00:00','0','1250.00','1','806.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-05 15:00:42','2023-04-05 15:00:42',NULL,'1','Add New Invoice','1'),
('1663','VR-23-1663','2023-04-06 00:00:00','0','1250.00','1','317.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-06 12:47:32','2023-04-06 12:47:32',NULL,'1','Add New Invoice','1'),
('1664','VR-23-1664','2023-04-06 00:00:00','0','1250.00','1','582.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-04-06 15:07:52','2023-04-10 03:51:47',NULL,'1','Update Invoice','1'),
('1665','VR-23-1665','2023-04-06 00:00:00','0','1250.00','1','1380.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-04-06 15:32:43','2023-04-06 15:32:43',NULL,'1','Add New Invoice','1'),
('1666','VR-23-1666','2023-04-06 00:00:00','0','1250.00','1','412.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-04-06 15:41:36','2023-04-13 12:48:44',NULL,'1','Update Invoice','1'),
('1667','VR-23-1667','2023-04-06 00:00:00','0','1250.00','1','372.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-04-06 15:44:24','2023-04-06 15:44:24',NULL,'1','Add New Invoice','1'),
('1668','VR-23-1668','2023-04-06 00:00:00','0','1250.00','1','6018.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-06 15:52:53','2023-04-06 04:12:12',NULL,'1','Update Invoice','1'),
('1669','VR-23-1669','2023-04-06 00:00:00','0','1250.00','1','27.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-04-06 16:20:09','2023-04-06 16:20:09',NULL,'1','Add New Invoice','1'),
('1670','VR-23-1670','2023-04-06 00:00:00','0','1250.00','1','180.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-04-06 16:22:29','2023-04-06 16:22:29',NULL,'1','Add New Invoice','1'),
('1671','VR-23-1671','2023-04-06 00:00:00','0','1250.00','1','126.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-04-06 16:26:55','2023-04-06 16:26:55',NULL,'1','Add New Invoice','1'),
('1672','VR-23-1672','2023-04-08 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-08 09:57:17','2023-04-08 09:57:17',NULL,'1','Add New Invoice','1'),
('1673','VR-23-1673','2023-04-08 00:00:00','0','1250.00','1','150.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-04-08 10:02:12','2023-04-08 10:02:12',NULL,'1','Add New Invoice','1'),
('1674','VR-23-1674','2023-04-08 00:00:00','0','1250.00','1','9121.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-04-08 11:04:30','2023-04-08 11:04:30',NULL,'1','Add New Invoice','1'),
('1675','VR-23-1675','2023-04-08 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-08 13:24:57','2023-04-08 13:24:57',NULL,'1','Add New Invoice','1'),
('1676','VR-23-1676','2023-04-08 00:00:00','0','1250.00','1','139.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-04-08 15:23:05','2023-04-08 15:23:05',NULL,'1','Add New Invoice','1'),
('1677','VR-23-1677','2023-04-08 00:00:00','0','1250.00','1','27.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-04-08 15:28:33','2023-04-08 15:28:33',NULL,'1','Add New Invoice','1'),
('1678','VR-23-1678','2023-04-08 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-04-08 15:35:40','2023-04-08 15:35:40',NULL,'1','Add New Invoice','1'),
('1679','VR-23-1679','2023-04-08 00:00:00','0','1250.00','1','76.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-08 16:30:26','2023-04-08 16:30:26',NULL,'1','Add New Invoice','1'),
('1680','VR-23-1680','2023-04-08 00:00:00','0','1250.00','1','237.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-08 16:31:26','2023-04-08 16:31:26',NULL,'1','Add New Invoice','1'),
('1681','VR-23-1681','2023-04-09 00:00:00','0','1250.00','1','513.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-09 14:57:54','2023-04-09 14:57:54',NULL,'1','Add New Invoice','1'),
('1682','VR-23-1682','2023-04-09 00:00:00','0','1250.00','1','249.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-04-09 15:05:28','2023-04-09 15:05:28',NULL,'1','Add New Invoice','1'),
('1683','VR-23-1683','2023-04-09 00:00:00','0','1250.00','1','177.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-04-09 15:21:25','2023-04-09 15:21:25',NULL,'1','Add New Invoice','1'),
('1684','VR-23-1684','2023-04-10 00:00:00','0','1250.00','1','577.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-10 15:12:09','2023-04-10 15:12:09',NULL,'1','Add New Invoice','1'),
('1685','VR-23-1685','2023-04-10 00:00:00','0','1250.00','1','57.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-04-10 15:13:45','2023-04-10 15:13:45',NULL,'1','Add New Invoice','1'),
('1686','VR-23-1686','2023-04-10 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-04-10 15:19:39','2023-04-10 15:19:39',NULL,'1','Add New Invoice','1'),
('1687','VR-23-1687','2023-04-10 00:00:00','0','1250.00','1','128.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-04-10 15:55:06','2023-04-10 15:55:06',NULL,'1','Add New Invoice','1'),
('1688','VR-23-1688','2023-04-11 00:00:00','0','1250.00','1','142.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-04-11 10:07:40','2023-04-11 10:07:40',NULL,'1','Add New Invoice','1'),
('1689','VR-23-1689','2023-04-11 00:00:00','0','1250.00','1','6382.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-11 16:48:04','2023-04-11 16:48:04',NULL,'1','Add New Invoice','1'),
('1690','VR-23-1690','2023-04-11 00:00:00','0','1250.00','1','222.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-11 16:56:58','2023-04-12 02:43:27',NULL,'1','Update Invoice','1'),
('1691','VR-23-1691','2023-04-12 00:00:00','0','1250.00','1','967.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-12 10:36:20','2023-04-12 10:36:20',NULL,'1','Add New Invoice','1'),
('1692','VR-23-1692','2023-04-12 00:00:00','0','1250.00','1','41.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-04-12 10:49:33','2023-04-12 10:49:33',NULL,'1','Add New Invoice','1'),
('1693','VR-23-1693','2023-04-12 00:00:00','0','1250.00','1','96.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-04-12 10:52:16','2023-04-12 10:52:16',NULL,'1','Add New Invoice','1'),
('1694','VR-23-1694','2023-04-12 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-04-12 11:07:46','2023-04-12 11:07:46',NULL,'1','Add New Invoice','1'),
('1695','VR-23-1695','2023-04-12 00:00:00','0','1250.00','1','162.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-12 11:12:20','2023-04-12 11:12:20',NULL,'1','Add New Invoice','1'),
('1696','VR-23-1696','2023-04-12 00:00:00','0','1250.00','1','105.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-04-12 11:21:11','2023-04-12 11:21:11',NULL,'1','Add New Invoice','1'),
('1697','VR-23-1697','2023-04-12 00:00:00','0','1250.00','1','993.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-12 14:13:10','2023-04-12 14:13:10',NULL,'1','Add New Invoice','1'),
('1698','VR-23-1698','2023-04-12 00:00:00','0','1250.00','1','78.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-04-12 14:20:56','2023-04-12 14:20:56',NULL,'1','Add New Invoice','1'),
('1699','VR-23-1699','2023-04-12 00:00:00','0','1250.00','1','958.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-04-12 14:58:00','2023-05-09 11:47:52',NULL,'1','Update Invoice','1'),
('1700','VR-23-1700','2023-04-12 00:00:00','0','1250.00','1','515.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-04-12 15:54:03','2023-04-12 15:54:03',NULL,'1','Add New Invoice','1'),
('1701','VR-23-1701','2023-04-12 00:00:00','0','1250.00','1','117.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-04-12 16:05:04','2023-04-12 16:05:04',NULL,'1','Add New Invoice','1'),
('1702','VR-23-1702','2023-04-12 00:00:00','0','1250.00','1','1224.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-04-12 16:09:53','2023-04-12 16:09:53',NULL,'1','Add New Invoice','1'),
('1703','VR-23-1703','2023-04-12 00:00:00','0','1250.00','1','1335.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-12 16:12:28','2023-04-12 16:12:28',NULL,'1','Add New Invoice','1'),
('1704','VR-23-1704','2023-04-12 00:00:00','0','1250.00','1','196.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-04-12 16:42:38','2023-04-12 16:42:38',NULL,'1','Add New Invoice','1'),
('1705','VR-23-1705','2023-04-12 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-04-12 16:44:19','2023-04-12 16:44:19',NULL,'1','Add New Invoice','1'),
('1706','VR-23-1706','2023-04-12 00:00:00','0','1250.00','1','226.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-04-12 16:54:32','2023-04-17 11:14:36',NULL,'1','Update Invoice','1'),
('1707','VR-23-1707','2023-04-13 00:00:00','0','1250.00','1','14.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-04-13 13:06:02','2023-04-13 13:06:02',NULL,'1','Add New Invoice','1'),
('1708','VR-23-1708','2023-04-13 00:00:00','0','1250.00','1','130.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-04-13 13:13:37','2023-04-13 13:13:37',NULL,'1','Add New Invoice','1'),
('1709','VR-23-1709','2023-04-13 00:00:00','0','1250.00','1','141.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-04-13 13:18:11','2023-04-13 13:18:11',NULL,'1','Add New Invoice','1'),
('1710','VR-23-1710','2023-04-13 00:00:00','0','1250.00','1','456.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-04-13 13:30:27','2023-04-13 13:30:27',NULL,'1','Add New Invoice','1'),
('1711','VR-23-1711','2023-04-13 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-04-13 13:43:59','2023-04-13 13:43:59',NULL,'1','Add New Invoice','1'),
('1712','VR-23-1712','2023-04-13 00:00:00','0','1250.00','1','260.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','1','2023-04-13 13:58:50','2023-04-13 13:58:50','2023-04-13 02:48:42','1','Delete Invoice','1'),
('1713','VR-23-1713','2023-04-13 00:00:00','0','1250.00','1','122.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-13 14:17:10','2023-04-13 14:17:10',NULL,'1','Add New Invoice','1'),
('1714','VR-23-1714','2023-04-13 00:00:00','0','1250.00','1','114.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-04-13 14:21:48','2023-04-17 02:54:04',NULL,'1','Update Invoice','1'),
('1715','VR-23-1715','2023-04-13 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-04-13 14:23:09','2023-04-13 14:23:09',NULL,'1','Add New Invoice','1'),
('1716','VR-23-1716','2023-04-13 00:00:00','0','1250.00','1','3488.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-04-13 15:55:07','2023-04-13 15:55:07',NULL,'1','Add New Invoice','1'),
('1717','VR-23-1717','2023-04-13 00:00:00','0','1250.00','1','937.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-04-13 16:23:33','2023-04-13 16:23:33',NULL,'1','Add New Invoice','1'),
('1718','INV-23-1718','2023-04-16 00:00:00','0','1250.00','1','202.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-04-16 10:44:27','2023-04-16 10:44:27',NULL,'1','Add New Invoice','1'),
('1719','VR-23-1719','2023-04-17 00:00:00','0','1250.00','1','389.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-04-17 11:13:33','2023-05-10 02:16:47',NULL,'1','Update Invoice','1'),
('1720','INV-23-1720','2023-04-17 00:00:00','0','1250.00','1','200.70','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2023-04-17 11:28:22','2023-04-17 11:28:22','2023-04-17 02:04:36','1','Delete Invoice','1'),
('1721','VR-23-1721','2023-04-17 00:00:00','0','1250.00','1','575.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-17 12:24:32','2023-04-18 12:21:20',NULL,'1','Update Invoice','1'),
('1722','VR-23-1722','2023-04-17 00:00:00','0','1250.00','1','119.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-04-17 12:28:19','2023-04-17 12:28:19',NULL,'1','Add New Invoice','1'),
('1723','VR-23-1723','2023-04-17 00:00:00','0','1250.00','1','55.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-04-17 12:31:15','2023-04-17 12:31:15',NULL,'1','Add New Invoice','1'),
('1724','VR-23-1724','2023-04-17 00:00:00','0','1250.00','1','121.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-04-17 12:34:51','2023-04-18 12:43:03',NULL,'1','Update Invoice','1'),
('1725','VR-23-1725','2023-04-17 00:00:00','0','1250.00','1','23.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-04-17 12:47:39','2023-04-17 12:47:39',NULL,'1','Add New Invoice','1'),
('1726','VR-23-1726','2023-04-17 00:00:00','0','1250.00','1','107.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-04-17 15:06:46','2023-04-17 15:06:46',NULL,'1','Add New Invoice','1'),
('1727','VR-23-1727','2023-04-17 00:00:00','0','1250.00','1','446.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-17 15:09:28','2023-04-17 15:09:28',NULL,'1','Add New Invoice','1'),
('1728','VR-23-1728','2023-04-17 00:00:00','0','1250.00','1','480.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-04-17 15:13:38','2023-04-17 15:13:38',NULL,'1','Add New Invoice','1'),
('1729','VR-23-1729','2023-04-17 00:00:00','0','1250.00','1','8237.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-17 15:41:28','2023-04-17 15:41:28',NULL,'1','Add New Invoice','1'),
('1730','VR-23-1730','2023-04-17 00:00:00','0','1250.00','1','372.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-04-17 15:48:51','2023-04-17 04:38:55',NULL,'1','Update Invoice','1'),
('1731','VR-23-1731','2023-04-17 00:00:00','0','1250.00','1','191.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-04-17 16:02:31','2023-04-19 12:18:46',NULL,'1','Update Invoice','1'),
('1732','VR-23-1732','2023-04-17 00:00:00','0','1250.00','1','120.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-17 16:14:00','2023-05-02 03:32:26',NULL,'1','Update Invoice','1'),
('1733','VR-23-1733','2023-04-17 00:00:00','0','1250.00','1','94.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-04-17 16:54:28','2023-04-17 16:54:28',NULL,'1','Add New Invoice','1'),
('1734','VR-23-1734','2023-04-17 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-04-17 17:01:00','2023-04-17 17:01:00',NULL,'1','Add New Invoice','1'),
('1735','VR-23-1735','2023-04-18 00:00:00','0','1250.00','1','368.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-18 12:34:16','2023-04-18 12:34:16',NULL,'1','Add New Invoice','1'),
('1736','VR-23-1736','2023-04-18 00:00:00','0','1250.00','1','88.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-18 12:39:36','2023-04-18 12:39:36',NULL,'1','Add New Invoice','1'),
('1737','VR-23-1737','2023-04-18 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-04-18 15:37:04','2023-04-18 15:37:04',NULL,'1','Add New Invoice','1'),
('1738','VR-23-1738','2023-04-18 00:00:00','0','1250.00','1','97.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2023-04-18 15:39:55','2023-04-18 15:39:55',NULL,'1','Add New Invoice','1'),
('1739','VR-23-1739','2023-04-18 00:00:00','0','1250.00','1','14.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-04-18 15:41:09','2023-04-18 15:41:09',NULL,'1','Add New Invoice','1'),
('1740','VR-23-1740','2023-04-18 00:00:00','0','1250.00','1','2070.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-18 15:58:20','2023-04-18 15:58:20',NULL,'1','Add New Invoice','1'),
('1741','VR-23-1741','2023-04-18 00:00:00','0','1250.00','1','2179.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-18 16:02:30','2023-09-07 09:36:11',NULL,'1','Update Invoice','1'),
('1742','VR-23-1742','2023-04-18 00:00:00','0','1250.00','1','224.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-04-18 16:04:09','2023-04-18 16:04:09',NULL,'1','Add New Invoice','1'),
('1743','VR-23-1743','2023-04-18 00:00:00','0','1250.00','1','64.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-04-18 16:08:29','2023-04-18 16:08:29',NULL,'1','Add New Invoice','1'),
('1744','VR-23-1744','2023-04-19 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-04-19 11:24:06','2023-04-19 11:24:06',NULL,'1','Add New Invoice','1'),
('1745','INV-23-1745','2023-04-19 00:00:00','0','1250.00','1','282.00','0.00','','1','1','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','106','0','2023-04-19 11:36:10','2023-04-19 11:36:10',NULL,'1','Add New Invoice','1'),
('1746','VR-23-1746','2023-04-19 00:00:00','0','1250.00','1','1122.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-04-19 11:54:52','2023-04-19 11:54:52',NULL,'1','Add New Invoice','1'),
('1747','VR-23-1747','2023-04-19 00:00:00','0','1250.00','1','861.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-04-19 12:16:03','2023-04-19 12:16:03',NULL,'1','Add New Invoice','1'),
('1748','VR-23-1748','2023-04-19 00:00:00','0','1250.00','1','25.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-04-19 12:19:40','2023-04-19 12:19:40',NULL,'1','Add New Invoice','1'),
('1749','VR-23-1749','2023-04-19 00:00:00','0','1250.00','1','364.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-19 12:22:00','2023-04-19 12:22:00',NULL,'1','Add New Invoice','1'),
('1750','VR-23-1750','2023-04-19 00:00:00','0','1250.00','1','26.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-04-19 12:30:07','2023-04-19 12:30:07',NULL,'1','Add New Invoice','1'),
('1751','VR-23-1751','2023-04-19 00:00:00','0','1250.00','1','17.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-19 12:32:51','2023-04-19 12:32:51',NULL,'1','Add New Invoice','1'),
('1752','VR-23-1752','2023-04-19 00:00:00','0','1250.00','1','16.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-04-19 14:06:57','2023-04-19 14:06:57',NULL,'1','Add New Invoice','1'),
('1753','VR-23-1753','2023-04-20 00:00:00','0','1250.00','1','3258.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-20 12:57:11','2023-04-20 12:57:11',NULL,'1','Add New Invoice','1'),
('1754','VR-23-1754','2023-04-24 00:00:00','0','1250.00','1','123.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-04-24 15:41:20','2023-04-24 15:41:20',NULL,'1','Add New Invoice','1'),
('1755','VR-23-1755','2023-04-24 00:00:00','0','1250.00','1','59.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-04-24 15:44:21','2023-04-24 15:44:21',NULL,'1','Add New Invoice','1'),
('1756','VR-23-1756','2023-04-25 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-04-25 17:08:18','2023-04-25 17:08:18',NULL,'1','Add New Invoice','1'),
('1757','VR-23-1757','2023-04-26 00:00:00','0','1250.00','1','92.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-04-26 11:07:39','2023-04-26 11:07:39',NULL,'1','Add New Invoice','1'),
('1758','VR-23-1758','2023-04-26 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-04-26 11:16:49','2023-04-26 11:16:49',NULL,'1','Add New Invoice','1'),
('1759','VR-23-1759','2023-04-26 00:00:00','0','1250.00','1','29.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-04-26 11:22:14','2023-04-26 11:22:14',NULL,'1','Add New Invoice','1'),
('1760','VR-23-1760','2023-04-26 00:00:00','0','1250.00','1','489.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-04-26 11:27:19','2023-04-26 11:27:19',NULL,'1','Add New Invoice','1'),
('1761','VR-23-1761','2023-04-26 00:00:00','0','1250.00','1','357.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-26 11:38:20','2023-04-26 11:38:20',NULL,'1','Add New Invoice','1'),
('1762','VR-23-1762','2023-04-26 00:00:00','0','1250.00','1','12.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-04-26 13:45:00','2023-04-26 13:45:00',NULL,'1','Add New Invoice','1'),
('1763','VR-23-1763','2023-04-26 00:00:00','0','1250.00','1','122.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-04-26 13:47:16','2023-04-26 01:47:36',NULL,'1','Update Invoice','1'),
('1764','VR-23-1764','2023-04-26 00:00:00','0','1250.00','1','33.75','0.00','تول','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-26 13:49:35','2023-04-26 13:49:35',NULL,'1','Add New Invoice','1'),
('1765','VR-23-1765','2023-04-26 00:00:00','0','1250.00','1','6182.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-26 15:21:50','2023-04-26 15:21:50',NULL,'1','Add New Invoice','1'),
('1766','VR-23-1766','2023-04-26 00:00:00','0','1250.00','1','1335.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-26 16:28:35','2023-04-26 16:28:35',NULL,'1','Add New Invoice','1'),
('1767','VR-23-1767','2023-04-26 00:00:00','0','1250.00','1','195.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-04-26 17:51:38','2023-05-10 02:16:14',NULL,'1','Update Invoice','1'),
('1768','VR-23-1768','2023-04-27 00:00:00','0','1250.00','1','365.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-27 10:49:23','2023-04-27 10:49:23',NULL,'1','Add New Invoice','1'),
('1769','VR-23-1769','2023-04-27 00:00:00','0','1250.00','1','945.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-04-27 11:14:16','2023-05-06 02:58:16',NULL,'1','Update Invoice','1'),
('1770','VR-23-1770','2023-04-27 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-27 11:25:37','2023-04-27 11:25:37',NULL,'1','Add New Invoice','1'),
('1771','VR-23-1771','2023-04-27 00:00:00','0','1250.00','1','70.20','0.00','فاضل','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-04-27 15:49:43','2023-04-27 15:49:43',NULL,'1','Add New Invoice','1'),
('1772','VR-23-1772','2023-04-29 00:00:00','0','1250.00','1','500.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-29 14:26:27','2023-05-01 09:58:50',NULL,'1','Update Invoice','1'),
('1773','VR-23-1773','2023-04-30 00:00:00','0','1250.00','1','250.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','1','2023-04-30 11:20:01','2023-04-30 11:20:01','2023-05-10 01:20:37','1','Delete Invoice','1'),
('1774','VR-23-1774','2023-04-30 00:00:00','0','1250.00','1','494.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-04-30 16:01:45','2023-04-30 16:01:45',NULL,'1','Add New Invoice','1'),
('1775','VR-23-1775','2023-04-30 00:00:00','0','1250.00','1','254.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-04-30 17:16:39','2023-04-30 17:16:39',NULL,'1','Add New Invoice','1'),
('1776','VR-23-1776','2023-04-30 00:00:00','0','1250.00','1','861.32','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-04-30 17:22:01','2023-04-30 17:22:01',NULL,'1','Add New Invoice','1'),
('1777','VR-23-1777','2023-04-30 00:00:00','0','1250.00','1','1134.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-04-30 17:42:21','2023-04-30 17:42:21',NULL,'1','Add New Invoice','1'),
('1778','VR-23-1778','2023-04-30 00:00:00','0','1250.00','1','584.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-04-30 17:46:02','2023-04-30 17:46:02',NULL,'1','Add New Invoice','1'),
('1779','VR-23-1779','2023-04-30 00:00:00','0','1250.00','1','1612.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-04-30 17:51:02','2023-05-01 03:19:51',NULL,'1','Update Invoice','1'),
('1780','VR-23-1780','2023-05-01 00:00:00','0','1250.00','1','351.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-01 09:31:24','2023-05-01 09:31:24',NULL,'1','Add New Invoice','1'),
('1781','VR-23-1781','2023-05-01 00:00:00','0','1250.00','1','511.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-01 10:07:31','2023-05-01 10:07:31',NULL,'1','Add New Invoice','1'),
('1782','VR-23-1782','2023-05-01 00:00:00','0','1250.00','1','674.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-01 10:13:32','2023-05-01 10:13:32',NULL,'1','Add New Invoice','1'),
('1783','VR-23-1783','2023-05-01 00:00:00','0','1250.00','1','483.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-05-01 15:24:07','2023-05-01 15:24:07',NULL,'1','Add New Invoice','1'),
('1784','VR-23-1784','2023-05-01 00:00:00','0','1250.00','1','198.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-01 15:49:14','2023-05-01 15:49:14',NULL,'1','Add New Invoice','1'),
('1785','VR-23-1785','2023-05-01 00:00:00','0','1250.00','1','200.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-01 15:52:36','2023-05-01 15:52:36',NULL,'1','Add New Invoice','1'),
('1786','VR-23-1786','2023-05-01 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-05-01 15:56:18','2023-05-01 15:56:18',NULL,'1','Add New Invoice','1'),
('1787','VR-23-1787','2023-05-01 00:00:00','0','1250.00','1','319.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-05-01 16:03:59','2023-05-02 10:34:06',NULL,'1','Update Invoice','1'),
('1788','VR-23-1788','2023-05-01 00:00:00','0','1250.00','1','128.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-01 16:26:15','2023-05-01 16:26:15',NULL,'1','Add New Invoice','1'),
('1789','VR-23-1789','2023-05-02 00:00:00','0','1250.00','1','242.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-02 11:39:56','2023-05-10 02:14:22',NULL,'1','Update Invoice','1'),
('1790','VR-23-1790','2023-05-02 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-02 14:22:47','2023-05-02 14:22:47',NULL,'1','Add New Invoice','1'),
('1791','VR-23-1791','2023-05-02 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-05-02 14:42:50','2023-05-02 14:42:50',NULL,'1','Add New Invoice','1'),
('1792','VR-23-1792','2023-05-02 00:00:00','0','1250.00','1','61.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-05-02 14:45:10','2023-05-02 14:45:10',NULL,'1','Add New Invoice','1'),
('1793','VR-23-1793','2023-05-02 00:00:00','0','1250.00','1','852.54','0.00','رياض محمد حي عدل','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-02 14:56:18','2023-05-02 14:56:18',NULL,'1','Add New Invoice','1'),
('1794','VR-23-1794','2023-05-02 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-02 15:02:09','2023-05-02 15:02:09',NULL,'1','Add New Invoice','1'),
('1795','VR-23-1795','2023-05-03 00:00:00','0','1250.00','1','150.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-03 13:54:30','2023-05-03 13:54:30',NULL,'1','Add New Invoice','1'),
('1796','VR-23-1796','2023-05-03 00:00:00','0','1250.00','1','3204.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-03 15:38:04','2023-05-03 15:38:04',NULL,'1','Add New Invoice','1'),
('1797','VR-23-1797','2023-05-04 00:00:00','0','1250.00','1','1153.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-05-04 09:32:29','2023-05-04 09:38:27',NULL,'1','Update Invoice','1'),
('1798','VR-23-1798','2023-05-04 00:00:00','0','1250.00','1','111.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-05-04 09:41:39','2023-05-04 09:41:39',NULL,'1','Add New Invoice','1'),
('1799','VR-23-1799','2023-05-04 00:00:00','0','1250.00','1','120.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-05-04 10:12:58','2023-05-04 10:12:58',NULL,'1','Add New Invoice','1'),
('1800','VR-23-1800','2023-05-04 00:00:00','0','1250.00','1','15.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-04 10:17:20','2023-05-04 10:17:20',NULL,'1','Add New Invoice','1'),
('1801','VR-23-1801','2023-05-04 00:00:00','0','1250.00','1','94.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-04 10:23:57','2023-05-04 10:23:57',NULL,'1','Add New Invoice','1'),
('1802','VR-23-1802','2023-05-04 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-05-04 16:39:39','2023-05-04 16:39:39',NULL,'1','Add New Invoice','1'),
('1803','VR-23-1803','2023-05-04 00:00:00','0','1250.00','1','131.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-04 16:41:40','2023-05-04 16:41:40',NULL,'1','Add New Invoice','1'),
('1804','VR-23-1804','2023-05-04 00:00:00','0','1250.00','1','57.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-05-04 16:46:33','2023-05-04 16:46:33',NULL,'1','Add New Invoice','1'),
('1805','VR-23-1805','2023-05-04 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-05-04 16:50:09','2023-05-04 16:50:09',NULL,'1','Add New Invoice','1'),
('1806','VR-23-1806','2023-05-06 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-05-06 11:39:55','2023-05-06 11:39:55',NULL,'1','Add New Invoice','1'),
('1807','VR-23-1807','2023-05-06 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-06 12:02:51','2023-05-06 12:02:51',NULL,'1','Add New Invoice','1'),
('1808','VR-23-1808','2023-05-06 00:00:00','0','1250.00','1','355.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','1','2023-05-06 12:07:10','2023-05-06 12:07:10','2023-05-20 09:38:14','1','Delete Invoice','1'),
('1809','VR-23-1809','2023-05-06 00:00:00','0','1250.00','1','1470.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-05-06 12:12:01','2023-05-06 12:12:01',NULL,'1','Add New Invoice','1'),
('1810','VR-23-1810','2023-05-07 00:00:00','0','1250.00','1','133.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-07 11:47:07','2023-05-07 11:47:07',NULL,'1','Add New Invoice','1'),
('1811','VR-23-1811','2023-05-07 00:00:00','0','1250.00','1','38.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-07 14:47:07','2023-05-07 14:47:07',NULL,'1','Add New Invoice','1'),
('1812','VR-23-1812','2023-05-07 00:00:00','0','1250.00','1','208.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-07 15:17:48','2023-05-07 15:17:48',NULL,'1','Add New Invoice','1'),
('1813','VR-23-1813','2023-05-07 00:00:00','0','1250.00','1','105.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-07 15:21:33','2023-05-10 02:13:38',NULL,'1','Update Invoice','1'),
('1814','VR-23-1814','2023-05-07 00:00:00','0','1250.00','1','103.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-05-07 15:36:26','2023-05-07 15:36:26',NULL,'1','Add New Invoice','1'),
('1815','VR-23-1815','2023-05-07 00:00:00','0','1250.00','1','323.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-07 15:40:56','2023-05-07 15:40:56',NULL,'1','Add New Invoice','1'),
('1816','VR-23-1816','2023-05-07 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-05-07 15:42:57','2023-05-07 15:42:57',NULL,'1','Add New Invoice','1'),
('1817','VR-23-1817','2023-05-07 00:00:00','0','1250.00','1','167.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-05-07 15:48:03','2023-05-07 15:48:03',NULL,'1','Add New Invoice','1'),
('1818','VR-23-1818','2023-05-08 00:00:00','0','1250.00','1','819.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-08 14:59:44','2023-05-14 10:55:16',NULL,'1','Update Invoice','1'),
('1819','VR-23-1819','2023-05-08 00:00:00','0','1250.00','1','2416.65','0.00','بغداد جديدة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-08 15:24:36','2023-05-08 15:24:36',NULL,'1','Add New Invoice','1'),
('1820','VR-23-1820','2023-05-08 00:00:00','0','1250.00','1','2736.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-08 15:32:17','2023-05-08 15:32:17',NULL,'1','Add New Invoice','1'),
('1821','VR-23-1821','2023-05-08 00:00:00','0','1250.00','1','2250.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-05-08 16:23:25','2023-05-09 11:44:58',NULL,'1','Update Invoice','1'),
('1822','VR-23-1822','2023-05-09 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-09 13:24:16','2023-05-09 13:24:16',NULL,'1','Add New Invoice','1'),
('1823','VR-23-1823','2023-05-09 00:00:00','0','1250.00','1','6812.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-05-09 14:58:43','2023-06-20 09:53:57',NULL,'1','Update Invoice','1'),
('1824','VR-23-1824','2023-05-09 00:00:00','0','1250.00','1','1283.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-05-09 15:05:15','2023-05-10 10:42:50',NULL,'1','Update Invoice','1'),
('1825','VR-23-1825','2023-05-09 00:00:00','0','1250.00','1','171.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-05-09 15:06:46','2023-05-09 15:06:46',NULL,'1','Add New Invoice','1'),
('1826','VR-23-1826','2023-05-09 00:00:00','0','1250.00','1','566.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-09 15:12:53','2023-05-09 15:12:53',NULL,'1','Add New Invoice','1'),
('1827','VR-23-1827','2023-05-10 00:00:00','0','1250.00','1','111.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-05-10 10:19:39','2023-05-10 10:19:39',NULL,'1','Add New Invoice','1'),
('1828','VR-23-1828','2023-05-10 00:00:00','0','1250.00','1','389.87','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-10 16:09:55','2023-05-10 16:09:55',NULL,'1','Add New Invoice','1'),
('1829','VR-23-1829','2023-05-10 00:00:00','0','1250.00','1','683.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-10 16:17:08','2023-05-10 16:17:08',NULL,'1','Add New Invoice','1'),
('1830','VR-23-1830','2023-05-10 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-10 16:19:01','2023-05-10 04:54:35',NULL,'1','Update Invoice','1'),
('1831','VR-23-1831','2023-05-11 00:00:00','0','1250.00','1','707.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-05-11 14:36:20','2023-05-11 14:36:20',NULL,'1','Add New Invoice','1'),
('1832','VR-23-1832','2023-05-11 00:00:00','0','1250.00','1','109.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','1','2023-05-11 14:41:44','2023-05-11 14:41:44','2023-05-13 10:49:11','1','Delete Invoice','1'),
('1833','VR-23-1833','2023-05-11 00:00:00','0','1250.00','1','6.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-11 14:55:43','2023-05-11 14:55:43',NULL,'1','Add New Invoice','1'),
('1834','VR-23-1834','2023-05-11 00:00:00','0','1250.00','1','142.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-11 15:05:58','2023-05-11 15:05:58',NULL,'1','Add New Invoice','1'),
('1835','VR-23-1835','2023-05-11 00:00:00','0','1250.00','1','47.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-11 15:07:05','2023-05-11 15:07:05',NULL,'1','Add New Invoice','1'),
('1836','VR-23-1836','2023-05-11 00:00:00','0','1250.00','1','242.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-05-11 15:09:09','2023-05-11 15:09:09',NULL,'1','Add New Invoice','1'),
('1837','VR-23-1837','2023-05-11 00:00:00','0','1250.00','1','5056.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-11 15:58:41','2023-05-11 15:58:41',NULL,'1','Add New Invoice','1'),
('1838','VR-23-1838','2023-05-13 00:00:00','0','1250.00','1','1952.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-13 09:52:39','2023-05-14 11:23:19',NULL,'1','Update Invoice','1'),
('1839','VR-23-1839','2023-05-13 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-05-13 12:51:49','2023-05-13 12:51:49',NULL,'1','Add New Invoice','1'),
('1840','VR-23-1840','2023-05-13 00:00:00','0','1250.00','1','99.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-13 16:05:40','2023-05-13 16:05:40',NULL,'1','Add New Invoice','1'),
('1841','VR-23-1841','2023-05-14 00:00:00','0','1250.00','1','6092.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-14 11:55:44','2023-05-14 12:12:17',NULL,'1','Update Invoice','1'),
('1842','VR-23-1842','2023-05-14 00:00:00','0','1250.00','1','174.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-14 12:00:13','2023-05-14 12:00:13',NULL,'1','Add New Invoice','1'),
('1843','VR-23-1843','2023-05-15 00:00:00','0','1250.00','1','992.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-15 11:04:49','2023-05-15 11:04:49',NULL,'1','Add New Invoice','1'),
('1844','VR-23-1844','2023-05-15 00:00:00','0','1250.00','1','841.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-05-15 11:10:54','2023-05-15 11:13:29',NULL,'1','Update Invoice','1'),
('1845','VR-23-1845','2023-05-15 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-05-15 13:12:45','2023-05-15 13:12:45',NULL,'1','Add New Invoice','1'),
('1846','VR-23-1846','2023-05-15 00:00:00','0','1250.00','1','1064.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-15 13:53:49','2023-05-21 01:52:49',NULL,'1','Update Invoice','1'),
('1847','VR-23-1847','2023-05-15 00:00:00','0','1250.00','1','404.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-15 14:11:29','2023-05-15 14:11:29',NULL,'1','Add New Invoice','1'),
('1848','VR-23-1848','2023-05-15 00:00:00','0','1250.00','1','1892.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-15 14:15:37','2023-05-16 10:04:43',NULL,'1','Update Invoice','1'),
('1849','VR-23-1849','2023-05-15 00:00:00','0','1250.00','1','50.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-15 14:16:54','2023-05-15 14:16:54',NULL,'1','Add New Invoice','1'),
('1850','VR-23-1850','2023-05-15 00:00:00','0','1250.00','1','815.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-05-15 14:26:36','2023-05-15 02:34:12',NULL,'1','Update Invoice','1'),
('1851','VR-23-1851','2023-05-15 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-05-15 14:28:23','2023-05-15 14:28:23',NULL,'1','Add New Invoice','1'),
('1852','VR-23-1852','2023-05-15 00:00:00','0','1250.00','1','204.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-05-15 14:32:43','2023-05-15 14:32:43',NULL,'1','Add New Invoice','1'),
('1853','VR-23-1853','2023-05-15 00:00:00','0','1250.00','1','40.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-05-15 14:53:08','2023-05-15 14:53:08',NULL,'1','Add New Invoice','1'),
('1854','VR-23-1854','2023-05-15 00:00:00','0','1250.00','1','74.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-05-15 14:57:23','2023-05-15 14:57:23',NULL,'1','Add New Invoice','1'),
('1855','VR-23-1855','2023-05-15 00:00:00','0','1250.00','1','668.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-05-15 15:06:20','2023-05-16 12:14:17',NULL,'1','Update Invoice','1'),
('1856','VR-23-1856','2023-05-15 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-05-15 15:37:09','2023-05-15 15:37:09',NULL,'1','Add New Invoice','1'),
('1857','VR-23-1857','2023-05-15 00:00:00','0','1250.00','1','2121.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-05-15 16:10:20','2023-05-16 10:27:49',NULL,'1','Update Invoice','1'),
('1858','VR-23-1858','2023-05-15 00:00:00','0','1250.00','1','1553.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-15 17:09:48','2023-05-15 05:13:20',NULL,'1','Update Invoice','1'),
('1859','VR-23-1859','2023-05-16 00:00:00','0','1250.00','1','145.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-05-16 10:08:54','2023-05-16 10:08:54',NULL,'1','Add New Invoice','1'),
('1860','VR-23-1860','2023-05-16 00:00:00','0','1250.00','1','195.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-16 10:10:57','2023-05-16 10:10:57',NULL,'1','Add New Invoice','1'),
('1861','VR-23-1861','2023-05-16 00:00:00','0','1250.00','1','341.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','1','2023-05-16 10:18:57','2023-05-16 12:09:57','2023-05-16 12:12:56','1','Delete Invoice','1'),
('1862','VR-23-1862','2023-05-16 00:00:00','0','1250.00','1','290.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-16 12:17:04','2023-05-16 12:17:04',NULL,'1','Add New Invoice','1'),
('1863','VR-23-1863','2023-05-16 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-05-16 14:48:00','2023-05-16 14:48:00',NULL,'1','Add New Invoice','1'),
('1864','VR-23-1864','2023-05-17 00:00:00','0','1250.00','1','225.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-17 14:40:08','2023-05-17 14:40:08',NULL,'1','Add New Invoice','1'),
('1865','VR-23-1865','2023-05-17 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-17 14:43:39','2023-05-17 14:43:39',NULL,'1','Add New Invoice','1'),
('1866','VR-23-1866','2023-05-17 00:00:00','0','1250.00','1','101.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-05-17 15:47:32','2023-05-17 15:47:32',NULL,'1','Add New Invoice','1'),
('1867','VR-23-1867','2023-05-17 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-17 17:36:21','2023-05-17 17:36:21',NULL,'1','Add New Invoice','1'),
('1868','VR-23-1868','2023-05-18 00:00:00','0','1250.00','1','2012.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-18 14:19:36','2023-05-18 14:19:36',NULL,'1','Add New Invoice','1'),
('1869','VR-23-1869','2023-05-18 00:00:00','0','1250.00','1','584.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-18 14:37:08','2023-05-21 11:07:19',NULL,'1','Update Invoice','1'),
('1870','VR-23-1870','2023-05-18 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-05-18 14:50:55','2023-05-18 14:50:55',NULL,'1','Add New Invoice','1'),
('1871','VR-23-1871','2023-05-18 00:00:00','0','1250.00','1','106.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','109','0','2023-05-18 15:24:26','2023-05-18 15:24:26',NULL,'1','Add New Invoice','1'),
('1872','VR-23-1872','2023-05-20 00:00:00','0','1250.00','1','27.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-20 10:28:32','2023-05-20 10:28:44',NULL,'1','Update Invoice','1'),
('1873','VR-23-1873','2023-05-20 00:00:00','0','1250.00','1','265.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-05-20 10:51:49','2023-05-20 10:51:49',NULL,'1','Add New Invoice','1'),
('1874','VR-23-1874','2023-05-21 00:00:00','0','1250.00','1','337.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-21 10:39:03','2023-05-21 10:39:03',NULL,'1','Add New Invoice','1'),
('1875','VR-23-1875','2023-05-21 00:00:00','0','1250.00','1','91.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-05-21 11:01:10','2023-05-21 11:01:10',NULL,'1','Add New Invoice','1'),
('1876','VR-23-1876','2023-05-21 00:00:00','0','1250.00','1','205.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-21 11:17:55','2023-05-21 11:17:55',NULL,'1','Add New Invoice','1'),
('1877','VR-23-1877','2023-05-21 00:00:00','0','1250.00','1','153.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-05-21 11:19:58','2023-05-21 12:07:49',NULL,'1','Update Invoice','1'),
('1878','VR-23-1878','2023-05-21 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-05-21 11:26:24','2023-05-21 11:26:24',NULL,'1','Add New Invoice','1'),
('1879','VR-23-1879','2023-05-21 00:00:00','0','1250.00','1','98.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-21 11:28:20','2023-05-21 11:28:20',NULL,'1','Add New Invoice','1'),
('1880','VR-23-1880','2023-05-21 00:00:00','0','1250.00','1','241.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-05-21 11:48:15','2023-05-21 11:48:15',NULL,'1','Add New Invoice','1'),
('1881','VR-23-1881','2023-05-21 00:00:00','0','1250.00','1','40.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-21 11:57:41','2023-05-21 11:57:41',NULL,'1','Add New Invoice','1'),
('1882','VR-23-1882','2023-05-21 00:00:00','0','1250.00','1','76.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-21 16:08:56','2023-05-21 16:08:56',NULL,'1','Add New Invoice','1'),
('1883','VR-23-1883','2023-05-22 00:00:00','0','1250.00','1','195.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-05-22 10:14:44','2023-05-22 10:15:57',NULL,'1','Update Invoice','1'),
('1884','VR-23-1884','2023-05-22 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-05-22 10:23:52','2023-05-22 10:23:52',NULL,'1','Add New Invoice','1'),
('1885','VR-23-1885','2023-05-22 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-22 10:32:35','2023-05-22 10:32:35',NULL,'1','Add New Invoice','1'),
('1886','VR-23-1886','2023-05-22 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','1','2023-05-22 10:38:33','2023-05-22 10:38:33','2023-05-31 02:36:11','1','Delete Invoice','1'),
('1887','VR-23-1887','2023-05-22 00:00:00','0','1250.00','1','271.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-22 10:45:23','2023-05-22 10:45:23',NULL,'1','Add New Invoice','1'),
('1888','VR-23-1888','2023-05-22 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-05-22 10:47:06','2023-05-22 10:47:06',NULL,'1','Add New Invoice','1'),
('1889','VR-23-1889','2023-05-22 00:00:00','0','1250.00','1','124.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-22 10:48:17','2023-05-22 10:48:17',NULL,'1','Add New Invoice','1'),
('1890','VR-23-1890','2023-05-22 00:00:00','0','1250.00','1','97.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-05-22 15:08:55','2023-05-22 15:08:55',NULL,'1','Add New Invoice','1'),
('1891','VR-23-1891','2023-05-22 00:00:00','0','1250.00','1','196.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-22 15:09:50','2023-05-22 15:09:50',NULL,'1','Add New Invoice','1'),
('1892','VR-23-1892','2023-05-23 00:00:00','0','1250.00','1','879.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-23 14:25:46','2023-05-23 02:31:50',NULL,'1','Update Invoice','1'),
('1893','VR-23-1893','2023-05-23 00:00:00','0','1250.00','1','94.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-05-23 14:36:45','2023-05-23 14:36:45',NULL,'1','Add New Invoice','1'),
('1894','VR-23-1894','2023-05-23 00:00:00','0','1250.00','1','81.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-05-23 14:39:06','2023-05-24 10:46:11',NULL,'1','Update Invoice','1'),
('1895','VR-23-1895','2023-05-23 00:00:00','0','1250.00','1','198.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-23 14:42:12','2023-05-23 14:42:12',NULL,'1','Add New Invoice','1'),
('1896','VR-23-1896','2023-05-23 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-23 14:43:21','2023-05-23 14:43:21',NULL,'1','Add New Invoice','1'),
('1897','VR-23-1897','2023-05-23 00:00:00','0','1250.00','1','24.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-05-23 14:48:59','2023-05-25 03:47:31',NULL,'1','Update Invoice','1'),
('1898','VR-23-1898','2023-05-23 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-05-23 14:51:19','2023-05-23 14:51:19',NULL,'1','Add New Invoice','1'),
('1899','VR-23-1899','2023-05-23 00:00:00','0','1250.00','1','136.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-05-23 15:50:57','2023-05-23 15:50:57',NULL,'1','Add New Invoice','1'),
('1900','VR-23-1900','2023-05-24 00:00:00','0','1250.00','1','1936.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-05-24 10:58:52','2023-05-24 10:58:52',NULL,'1','Add New Invoice','1'),
('1901','VR-23-1901','2023-05-24 00:00:00','0','1250.00','1','176.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-24 11:33:16','2023-05-24 11:33:16',NULL,'1','Add New Invoice','1'),
('1902','VR-23-1902','2023-05-24 00:00:00','0','1250.00','1','489.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-05-24 11:53:58','2023-05-24 03:48:32',NULL,'1','Update Invoice','1'),
('1903','VR-23-1903','2023-05-24 00:00:00','0','1250.00','1','165.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-24 11:55:16','2023-05-24 11:55:16',NULL,'1','Add New Invoice','1'),
('1904','VR-23-1904','2023-05-25 00:00:00','0','1250.00','1','711.74','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-25 14:39:54','2023-05-25 14:39:54',NULL,'1','Add New Invoice','1'),
('1905','VR-23-1905','2023-05-25 00:00:00','0','1250.00','1','494.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-05-25 14:46:10','2023-05-25 14:46:10',NULL,'1','Add New Invoice','1'),
('1906','VR-23-1906','2023-05-25 00:00:00','0','1250.00','1','380.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-05-25 14:50:24','2023-05-25 02:52:51',NULL,'1','Update Invoice','1'),
('1907','VR-23-1907','2023-05-25 00:00:00','0','1250.00','1','46.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-25 14:56:15','2023-05-25 14:56:15',NULL,'1','Add New Invoice','1'),
('1908','VR-23-1908','2023-05-25 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-05-25 14:58:43','2023-05-25 14:58:43',NULL,'1','Add New Invoice','1'),
('1909','VR-23-1909','2023-05-25 00:00:00','0','1250.00','1','94.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-05-25 15:03:22','2023-05-25 15:03:22',NULL,'1','Add New Invoice','1'),
('1910','VR-23-1910','2023-05-27 00:00:00','0','1250.00','1','25.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-05-27 09:57:28','2023-05-27 09:57:28',NULL,'1','Add New Invoice','1'),
('1911','VR-23-1911','2023-05-27 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-27 10:52:03','2023-05-27 10:52:03',NULL,'1','Add New Invoice','1'),
('1912','VR-23-1912','2023-05-27 00:00:00','0','1250.00','1','187.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-27 15:40:25','2023-06-10 12:20:31',NULL,'1','Update Invoice','1'),
('1913','VR-23-1913','2023-05-27 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-27 15:42:17','2023-05-27 15:42:17',NULL,'1','Add New Invoice','1'),
('1914','VR-23-1914','2023-05-27 00:00:00','0','1250.00','1','109.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-27 15:43:10','2023-05-27 15:43:10',NULL,'1','Add New Invoice','1'),
('1915','VR-23-1915','2023-05-27 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-05-27 15:45:30','2023-05-27 03:48:34',NULL,'1','Update Invoice','1'),
('1916','VR-23-1916','2023-05-27 00:00:00','0','1250.00','1','55.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-05-27 17:13:24','2023-05-27 17:13:24',NULL,'1','Add New Invoice','1'),
('1917','VR-23-1917','2023-05-28 00:00:00','0','1250.00','1','215.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-28 10:00:19','2023-05-28 10:00:19',NULL,'1','Add New Invoice','1'),
('1918','VR-23-1918','2023-05-28 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-28 10:51:07','2023-05-28 10:51:07',NULL,'1','Add New Invoice','1'),
('1919','VR-23-1919','2023-05-28 00:00:00','0','1250.00','1','250.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-05-28 10:56:03','2023-05-28 10:56:03',NULL,'1','Add New Invoice','1'),
('1920','VR-23-1920','2023-05-28 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-05-28 10:58:16','2023-05-28 10:58:16',NULL,'1','Add New Invoice','1'),
('1921','VR-23-1921','2023-05-28 00:00:00','0','1250.00','1','77.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-05-28 15:04:58','2023-05-28 15:04:58',NULL,'1','Add New Invoice','1'),
('1922','VR-23-1922','2023-05-28 00:00:00','0','1250.00','1','101.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-05-28 15:06:18','2023-05-28 15:06:18',NULL,'1','Add New Invoice','1'),
('1923','INV-23-1923','2023-05-29 00:00:00','0','1250.00','1','92.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-29 02:42:59','2023-05-29 02:42:59',NULL,'1','Add New Invoice','1'),
('1924','VR-23-1924','2023-05-30 00:00:00','0','1250.00','1','237.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-05-30 13:44:42','2023-05-30 13:44:42',NULL,'1','Add New Invoice','1'),
('1925','VR-23-1925','2023-05-31 00:00:00','0','1250.00','1','1027.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2023-05-31 10:47:03','2023-05-31 10:47:03',NULL,'1','Add New Invoice','1'),
('1926','VR-23-1926','2023-05-31 00:00:00','0','1250.00','1','355.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-05-31 10:49:40','2023-05-31 10:49:40',NULL,'1','Add New Invoice','1'),
('1927','VR-23-1927','2023-05-31 00:00:00','0','1250.00','1','130.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-05-31 10:58:12','2023-05-31 10:58:12',NULL,'1','Add New Invoice','1'),
('1928','VR-23-1928','2023-05-31 00:00:00','0','1250.00','1','443.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-05-31 11:07:53','2023-06-13 09:24:45',NULL,'1','Update Invoice','1'),
('1929','VR-23-1929','2023-05-31 00:00:00','0','1250.00','1','51.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-05-31 11:11:59','2023-05-31 11:11:59',NULL,'1','Add New Invoice','1'),
('1930','VR-23-1930','2023-05-31 00:00:00','0','1250.00','1','379.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-05-31 11:19:03','2023-05-31 11:19:03',NULL,'1','Add New Invoice','1'),
('1931','VR-23-1931','2023-05-31 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-31 11:21:56','2023-05-31 11:21:56',NULL,'1','Add New Invoice','1'),
('1932','VR-23-1932','2023-05-31 00:00:00','0','1250.00','1','309.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-05-31 11:29:22','2023-05-31 11:29:22',NULL,'1','Add New Invoice','1'),
('1933','VR-23-1933','2023-05-31 00:00:00','0','1250.00','1','330.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-05-31 11:36:18','2023-05-31 11:36:18',NULL,'1','Add New Invoice','1'),
('1934','VR-23-1934','2023-05-31 00:00:00','0','1250.00','1','159.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-05-31 11:38:54','2023-05-31 01:42:37',NULL,'1','Update Invoice','1'),
('1935','VR-23-1935','2023-05-31 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-05-31 11:40:24','2023-05-31 11:40:24',NULL,'1','Add New Invoice','1'),
('1936','VR-23-1936','2023-05-31 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-05-31 11:43:14','2023-05-31 11:43:14',NULL,'1','Add New Invoice','1'),
('1937','VR-23-1937','2023-05-31 00:00:00','0','1250.00','1','98.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-05-31 11:52:19','2023-05-31 11:52:19',NULL,'1','Add New Invoice','1'),
('1938','VR-23-1938','2023-05-31 00:00:00','0','1250.00','1','161.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-05-31 12:08:16','2023-05-31 12:08:16',NULL,'1','Add New Invoice','1'),
('1939','VR-23-1939','2023-05-31 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-05-31 12:09:29','2023-05-31 12:09:29',NULL,'1','Add New Invoice','1'),
('1940','VR-23-1940','2023-05-31 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-05-31 12:14:07','2023-05-31 12:14:07',NULL,'1','Add New Invoice','1'),
('1941','VR-23-1941','2023-05-31 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-05-31 12:19:41','2023-05-31 12:19:41',NULL,'1','Add New Invoice','1'),
('1942','VR-23-1942','2023-05-31 00:00:00','0','1250.00','1','834.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-05-31 13:50:48','2023-05-31 13:50:48',NULL,'1','Add New Invoice','1'),
('1943','VR-23-1943','2023-05-31 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-05-31 17:14:06','2023-05-31 17:14:06',NULL,'1','Add New Invoice','1'),
('1944','VR-23-1944','2023-06-01 00:00:00','0','1250.00','1','26.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-06-01 10:01:33','2023-06-01 10:01:33',NULL,'1','Add New Invoice','1'),
('1945','VR-23-1945','2023-06-01 00:00:00','0','1250.00','1','9580.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-01 16:35:57','2023-06-01 16:35:57',NULL,'1','Add New Invoice','1'),
('1946','VR-23-1946','2023-06-01 00:00:00','0','1250.00','1','940.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-06-01 16:38:00','2023-06-01 16:38:00',NULL,'1','Add New Invoice','1'),
('1947','VR-23-1947','2023-06-01 00:00:00','0','1250.00','1','110.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-06-01 16:48:32','2023-06-01 16:48:32',NULL,'1','Add New Invoice','1'),
('1948','VR-23-1948','2023-06-01 00:00:00','0','1250.00','1','97.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-01 16:57:46','2023-06-01 16:57:46',NULL,'1','Add New Invoice','1'),
('1949','VR-23-1949','2023-06-03 00:00:00','0','1250.00','1','15808.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','93','0','2023-06-03 10:02:25','2023-06-03 10:02:25',NULL,'1','Add New Invoice','1'),
('1950','VR-23-1950','2023-06-03 00:00:00','0','1250.00','1','2220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-06-03 14:54:08','2023-06-03 14:54:08',NULL,'1','Add New Invoice','1'),
('1951','VR-23-1951','2023-06-03 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-06-03 15:02:03','2023-06-03 03:09:40',NULL,'1','Update Invoice','1'),
('1952','VR-23-1952','2023-06-03 00:00:00','0','1250.00','1','40.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-06-03 15:08:46','2023-06-03 15:08:46',NULL,'1','Add New Invoice','1'),
('1953','VR-23-1953','2023-06-03 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-06-03 15:12:22','2023-06-03 15:12:22',NULL,'1','Add New Invoice','1'),
('1954','VR-23-1954','2023-06-03 00:00:00','0','1250.00','1','130.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-03 15:16:33','2023-06-03 15:16:33',NULL,'1','Add New Invoice','1'),
('1955','VR-23-1955','2023-06-03 00:00:00','0','1250.00','1','91.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-03 15:40:58','2023-06-03 15:40:58',NULL,'1','Add New Invoice','1'),
('1956','VR-23-1956','2023-06-03 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-06-03 15:50:07','2023-06-03 15:50:07',NULL,'1','Add New Invoice','1'),
('1957','VR-23-1957','2023-06-03 00:00:00','0','1250.00','1','68.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-06-03 15:52:11','2023-06-03 15:52:11',NULL,'1','Add New Invoice','1'),
('1958','VR-23-1958','2023-06-03 00:00:00','0','1250.00','1','158.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-03 15:56:47','2023-06-03 15:56:47',NULL,'1','Add New Invoice','1'),
('1959','VR-23-1959','2023-06-03 00:00:00','0','1250.00','1','93.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-03 15:58:30','2023-06-03 15:58:30',NULL,'1','Add New Invoice','1'),
('1960','VR-23-1960','2023-06-03 00:00:00','0','1250.00','1','241.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-03 16:07:31','2023-06-03 16:07:31',NULL,'1','Add New Invoice','1'),
('1961','VR-23-1961','2023-06-03 00:00:00','0','1250.00','1','4684.59','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-03 17:03:42','2023-06-04 11:49:27',NULL,'1','Update Invoice','1'),
('1962','VR-23-1962','2023-06-04 00:00:00','0','1250.00','1','578.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-06-04 12:12:16','2023-06-04 12:12:16',NULL,'1','Add New Invoice','1'),
('1963','VR-23-1963','2023-06-04 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-06-04 14:43:12','2023-06-04 14:43:12',NULL,'1','Add New Invoice','1'),
('1964','VR-23-1964','2023-06-04 00:00:00','0','1250.00','1','74.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-06-04 16:08:26','2023-06-04 16:08:26',NULL,'1','Add New Invoice','1'),
('1965','VR-23-1965','2023-06-04 00:00:00','0','1250.00','1','30.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-04 16:26:10','2023-06-04 16:26:10',NULL,'1','Add New Invoice','1'),
('1966','VR-23-1966','2023-06-04 00:00:00','0','1250.00','1','10.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-06-04 16:29:41','2023-06-04 16:29:41',NULL,'1','Add New Invoice','1'),
('1967','VR-23-1967','2023-06-04 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-04 16:40:54','2023-06-04 16:40:54',NULL,'1','Add New Invoice','1'),
('1968','VR-23-1968','2023-06-04 00:00:00','0','1250.00','1','164.41','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-04 16:47:18','2023-06-04 16:47:18',NULL,'1','Add New Invoice','1'),
('1969','VR-23-1969','2023-06-04 00:00:00','0','1250.00','1','125.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-06-04 16:49:30','2023-06-04 16:49:30',NULL,'1','Add New Invoice','1'),
('1970','VR-23-1970','2023-06-05 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-05 10:21:40','2023-06-05 10:21:40',NULL,'1','Add New Invoice','1'),
('1971','VR-23-1971','2023-06-05 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-05 14:20:40','2023-06-05 14:20:40',NULL,'1','Add New Invoice','1'),
('1972','VR-23-1972','2023-06-05 00:00:00','0','1250.00','1','77.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-06-05 14:25:34','2023-06-05 14:25:34',NULL,'1','Add New Invoice','1'),
('1973','VR-23-1973','2023-06-05 00:00:00','0','1250.00','1','115.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-05 14:31:03','2023-06-05 14:31:03',NULL,'1','Add New Invoice','1'),
('1974','VR-23-1974','2023-06-05 00:00:00','0','1250.00','1','232.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-06-05 14:32:17','2023-06-05 14:32:17',NULL,'1','Add New Invoice','1'),
('1975','VR-23-1975','2023-06-05 00:00:00','0','1250.00','1','399.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-05 14:39:24','2023-06-05 05:37:04',NULL,'1','Update Invoice','1'),
('1976','INV-23-1976','2023-06-05 00:00:00','0','1250.00','1','59.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-05 04:42:16','2023-06-05 04:42:16',NULL,'1','Add New Invoice','1'),
('1977','VR-23-1977','2023-06-06 00:00:00','0','1250.00','1','145.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-06 16:13:10','2023-06-06 16:13:10',NULL,'1','Add New Invoice','1'),
('1978','VR-23-1978','2023-06-06 00:00:00','0','1250.00','1','46.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-06-06 16:51:09','2023-06-06 16:51:09',NULL,'1','Add New Invoice','1'),
('1979','VR-23-1979','2023-06-06 00:00:00','0','1250.00','1','194.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-06 16:54:21','2023-06-06 16:54:21',NULL,'1','Add New Invoice','1'),
('1980','VR-23-1980','2023-06-06 00:00:00','0','1250.00','1','378.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-06-06 17:00:26','2023-06-11 02:48:10',NULL,'1','Update Invoice','1'),
('1981','VR-23-1981','2023-06-08 00:00:00','0','1250.00','1','234.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-06-08 15:19:54','2023-06-08 05:16:37',NULL,'1','Update Invoice','1'),
('1982','VR-23-1982','2023-06-08 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-06-08 16:06:25','2023-06-08 16:06:25',NULL,'1','Add New Invoice','1'),
('1983','VR-23-1983','2023-06-08 00:00:00','0','1250.00','1','26.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-06-08 16:34:46','2023-06-08 16:34:46',NULL,'1','Add New Invoice','1'),
('1984','VR-23-1984','2023-06-08 00:00:00','0','1250.00','1','189.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-08 16:42:42','2023-06-08 16:42:42',NULL,'1','Add New Invoice','1'),
('1985','VR-23-1985','2023-06-08 00:00:00','0','1250.00','1','158.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-06-08 16:48:53','2023-06-08 16:48:53',NULL,'1','Add New Invoice','1'),
('1986','VR-23-1986','2023-06-08 00:00:00','0','1250.00','1','600.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-08 16:55:47','2023-06-08 16:55:47',NULL,'1','Add New Invoice','1'),
('1987','VR-23-1987','2023-06-10 00:00:00','0','1250.00','1','1610.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','4','0','2023-06-10 15:36:04','2023-06-10 15:36:04',NULL,'1','Add New Invoice','1'),
('1988','VR-23-1988','2023-06-10 00:00:00','0','1250.00','1','884.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-06-10 16:07:38','2023-06-10 16:07:38',NULL,'1','Add New Invoice','1'),
('1989','VR-23-1989','2023-06-10 00:00:00','0','1250.00','1','12972.59','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-10 16:36:07','2023-06-10 16:36:07',NULL,'1','Add New Invoice','1'),
('1990','VR-23-1990','2023-06-10 00:00:00','0','1250.00','1','5703.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-06-10 17:25:24','2023-06-10 17:25:24',NULL,'1','Add New Invoice','1'),
('1991','VR-23-1991','2023-06-11 00:00:00','0','1250.00','1','550.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-11 09:44:28','2023-06-19 03:48:45',NULL,'1','Update Invoice','1'),
('1992','VR-23-1992','2023-06-11 00:00:00','0','1250.00','1','875.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-11 11:42:33','2023-06-11 11:42:33',NULL,'1','Add New Invoice','1'),
('1993','VR-23-1993','2023-06-11 00:00:00','0','1250.00','1','281.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-06-11 11:51:14','2023-06-11 11:51:14',NULL,'1','Add New Invoice','1'),
('1994','VR-23-1994','2023-06-11 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-06-11 11:52:53','2023-06-11 11:52:53',NULL,'1','Add New Invoice','1'),
('1995','VR-23-1995','2023-06-11 00:00:00','0','1250.00','1','491.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-06-11 13:11:19','2023-06-11 13:11:19',NULL,'1','Add New Invoice','1'),
('1996','VR-23-1996','2023-06-11 00:00:00','0','1250.00','1','258.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-06-11 13:44:08','2023-06-11 13:44:08',NULL,'1','Add New Invoice','1'),
('1997','VR-23-1997','2023-06-11 00:00:00','0','1250.00','1','188.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-06-11 14:50:18','2023-06-11 14:50:18',NULL,'1','Add New Invoice','1'),
('1998','VR-23-1998','2023-06-11 00:00:00','0','1250.00','1','129.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-11 15:55:52','2023-06-13 02:00:47',NULL,'1','Update Invoice','1'),
('1999','VR-23-1999','2023-06-11 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-06-11 16:08:51','2023-06-11 16:08:51',NULL,'1','Add New Invoice','1'),
('2000','VR-23-2000','2023-06-11 00:00:00','0','1250.00','1','232.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-06-11 16:18:03','2023-06-11 16:18:03',NULL,'1','Add New Invoice','1'),
('2001','VR-23-2001','2023-06-11 00:00:00','0','1250.00','1','232.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-06-11 16:25:56','2023-06-11 16:25:56',NULL,'1','Add New Invoice','1'),
('2002','VR-23-2002','2023-06-11 00:00:00','0','1250.00','1','27.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-06-11 16:28:34','2023-06-11 16:28:34',NULL,'1','Add New Invoice','1'),
('2003','VR-23-2003','2023-06-11 00:00:00','0','1250.00','1','218.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-11 17:08:35','2023-06-11 17:08:35',NULL,'1','Add New Invoice','1'),
('2004','VR-23-2004','2023-06-11 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-06-11 17:35:53','2023-06-11 17:35:53',NULL,'1','Add New Invoice','1'),
('2005','VR-23-2005','2023-06-11 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-11 17:37:46','2023-06-11 17:37:46',NULL,'1','Add New Invoice','1'),
('2006','VR-23-2006','2023-06-11 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-06-11 17:41:16','2023-06-14 02:13:13',NULL,'1','Update Invoice','1'),
('2007','VR-23-2007','2023-06-12 00:00:00','0','1250.00','1','31.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-06-12 09:46:53','2023-06-12 09:46:53',NULL,'1','Add New Invoice','1'),
('2008','VR-23-2008','2023-06-12 00:00:00','0','1250.00','1','1114.91','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-12 10:19:39','2023-06-12 10:19:39',NULL,'1','Add New Invoice','1'),
('2009','VR-23-2009','2023-06-12 00:00:00','0','1250.00','1','458.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-12 10:24:05','2023-06-12 10:24:05',NULL,'1','Add New Invoice','1'),
('2010','VR-23-2010','2023-06-12 00:00:00','0','1250.00','1','530.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-12 11:03:45','2023-06-12 11:03:45',NULL,'1','Add New Invoice','1'),
('2011','VR-23-2011','2023-06-12 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-06-12 11:58:28','2023-06-12 11:58:28',NULL,'1','Add New Invoice','1'),
('2012','VR-23-2012','2023-06-12 00:00:00','0','1250.00','1','121.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-06-12 15:59:44','2023-06-12 15:59:44',NULL,'1','Add New Invoice','1'),
('2013','VR-23-2013','2023-06-12 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-12 16:02:10','2023-06-12 16:02:10',NULL,'1','Add New Invoice','1'),
('2014','VR-23-2014','2023-06-13 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-06-13 10:47:33','2023-06-13 10:47:33',NULL,'1','Add New Invoice','1'),
('2015','VR-23-2015','2023-06-13 00:00:00','0','1250.00','1','1196.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-06-13 10:49:48','2023-06-13 10:49:48',NULL,'1','Add New Invoice','1'),
('2016','VR-23-2016','2023-06-13 00:00:00','0','1250.00','1','112.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-13 11:04:31','2023-06-13 11:04:31',NULL,'1','Add New Invoice','1'),
('2017','VR-23-2017','2023-06-13 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-06-13 11:05:49','2023-06-13 11:05:49',NULL,'1','Add New Invoice','1'),
('2018','VR-23-2018','2023-06-14 00:00:00','0','1250.00','1','508.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-14 09:48:17','2023-06-14 09:48:17',NULL,'1','Add New Invoice','1'),
('2019','VR-23-2019','2023-06-14 00:00:00','0','1250.00','1','2423.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-14 15:52:58','2023-06-14 15:52:58',NULL,'1','Add New Invoice','1'),
('2020','VR-23-2020','2023-06-14 00:00:00','0','1250.00','1','720.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-14 16:04:57','2023-06-14 16:04:57',NULL,'1','Add New Invoice','1'),
('2021','INV-23-2021','2023-06-15 00:00:00','0','1250.00','1','406.32','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-15 09:18:51','2023-06-15 09:18:51',NULL,'1','Add New Invoice','1'),
('2022','INV-23-2022','2023-06-15 00:00:00','0','1250.00','1','117.30','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-15 01:31:28','2023-06-15 01:31:28',NULL,'1','Add New Invoice','1'),
('2023','VR-23-2023','2023-06-15 00:00:00','0','1250.00','1','365.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-06-15 14:52:53','2023-06-15 14:52:53',NULL,'1','Add New Invoice','1'),
('2024','VR-23-2024','2023-06-15 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-06-15 14:54:51','2023-06-15 14:54:51',NULL,'1','Add New Invoice','1'),
('2025','VR-23-2025','2023-06-15 00:00:00','0','1250.00','1','75.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-15 14:59:08','2023-06-15 14:59:08',NULL,'1','Add New Invoice','1'),
('2026','VR-23-2026','2023-06-15 00:00:00','0','1250.00','1','223.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-15 15:01:51','2023-06-15 15:01:51',NULL,'1','Add New Invoice','1'),
('2027','VR-23-2027','2023-06-15 00:00:00','0','1250.00','1','55.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-06-15 15:03:04','2023-06-15 15:03:04',NULL,'1','Add New Invoice','1'),
('2028','VR-23-2028','2023-06-15 00:00:00','0','1250.00','1','587.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-15 15:11:53','2023-06-15 15:11:53',NULL,'1','Add New Invoice','1'),
('2029','VR-23-2029','2023-06-15 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-06-15 15:20:02','2023-06-15 15:20:02',NULL,'1','Add New Invoice','1'),
('2030','VR-23-2030','2023-06-15 00:00:00','0','1250.00','1','269.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-15 15:27:16','2023-06-15 15:27:16',NULL,'1','Add New Invoice','1'),
('2031','VR-23-2031','2023-06-15 00:00:00','0','1250.00','1','94.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-06-15 15:28:57','2023-06-15 15:28:57',NULL,'1','Add New Invoice','1'),
('2032','VR-23-2032','2023-06-15 00:00:00','0','1250.00','1','110.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-06-15 15:33:35','2023-06-15 15:33:35',NULL,'1','Add New Invoice','1'),
('2033','VR-23-2033','2023-06-15 00:00:00','0','1250.00','1','240.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-15 15:34:19','2023-06-15 15:34:19',NULL,'1','Add New Invoice','1'),
('2034','VR-23-2034','2023-06-17 00:00:00','0','1250.00','1','531.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-17 16:54:20','2023-06-17 05:32:29',NULL,'1','Update Invoice','1'),
('2035','VR-23-2035','2023-06-17 00:00:00','0','1250.00','1','185.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-17 17:03:42','2023-06-17 17:03:42',NULL,'1','Add New Invoice','1'),
('2036','VR-23-2036','2023-06-17 00:00:00','0','1250.00','1','42.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-06-17 17:11:35','2023-06-17 17:11:35',NULL,'1','Add New Invoice','1'),
('2037','VR-23-2037','2023-06-17 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-17 17:24:17','2023-06-17 17:24:17',NULL,'1','Add New Invoice','1'),
('2038','VR-23-2038','2023-06-18 00:00:00','0','1250.00','1','397.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-18 10:10:35','2023-06-18 10:10:35',NULL,'1','Add New Invoice','1'),
('2039','VR-23-2039','2023-06-18 00:00:00','0','1250.00','1','353.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-18 10:22:19','2023-06-18 10:22:19',NULL,'1','Add New Invoice','1'),
('2040','VR-23-2040','2023-06-18 00:00:00','0','1250.00','1','1352.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-18 15:46:01','2023-06-18 15:46:01',NULL,'1','Add New Invoice','1'),
('2041','VR-23-2041','2023-06-18 00:00:00','0','1250.00','1','232.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-18 15:58:10','2023-06-18 15:58:10',NULL,'1','Add New Invoice','1'),
('2042','VR-23-2042','2023-06-18 00:00:00','0','1250.00','1','69.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-18 16:07:28','2023-06-18 16:07:28',NULL,'1','Add New Invoice','1'),
('2043','VR-23-2043','2023-06-18 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-06-18 16:11:42','2023-06-18 16:11:42',NULL,'1','Add New Invoice','1'),
('2044','VR-23-2044','2023-06-18 00:00:00','0','1250.00','1','55.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-06-18 16:23:21','2023-06-18 16:23:21',NULL,'1','Add New Invoice','1'),
('2045','VR-23-2045','2023-06-19 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-06-19 09:35:48','2023-06-19 09:35:48',NULL,'1','Add New Invoice','1'),
('2046','VR-23-2046','2023-06-19 00:00:00','0','1250.00','1','290.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-06-19 09:37:19','2023-06-19 09:37:19',NULL,'1','Add New Invoice','1'),
('2047','VR-23-2047','2023-06-20 00:00:00','0','1250.00','1','371.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-20 10:05:01','2023-06-20 10:05:01',NULL,'1','Add New Invoice','1'),
('2048','VR-23-2048','2023-06-20 00:00:00','0','1250.00','1','103.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-20 10:48:52','2023-06-20 10:48:52',NULL,'1','Add New Invoice','1'),
('2049','VR-23-2049','2023-06-20 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-06-20 10:51:45','2023-06-20 10:51:45',NULL,'1','Add New Invoice','1'),
('2050','VR-23-2050','2023-06-20 00:00:00','0','1250.00','1','52.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-20 11:22:54','2023-06-20 11:22:54',NULL,'1','Add New Invoice','1'),
('2051','VR-23-2051','2023-06-20 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-06-20 11:26:12','2023-06-20 11:26:12',NULL,'1','Add New Invoice','1'),
('2052','VR-23-2052','2023-06-20 00:00:00','0','1250.00','1','156.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-20 11:43:19','2023-06-20 11:43:19',NULL,'1','Add New Invoice','1'),
('2053','VR-23-2053','2023-06-20 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-20 11:59:25','2023-06-20 11:59:25',NULL,'1','Add New Invoice','1'),
('2054','VR-23-2054','2023-06-20 00:00:00','0','1250.00','1','270.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-06-20 12:14:20','2023-06-20 12:14:20',NULL,'1','Add New Invoice','1'),
('2055','VR-23-2055','2023-06-20 00:00:00','0','1250.00','1','544.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-06-20 12:19:25','2023-06-20 12:19:25',NULL,'1','Add New Invoice','1'),
('2056','INV-23-2056','2023-06-20 00:00:00','0','1250.00','1','95.15','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-20 02:12:34','2023-06-20 02:21:24',NULL,'1','Update Invoice','1'),
('2057','VR-23-2057','2023-06-20 00:00:00','0','1250.00','1','2022.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-20 15:21:52','2023-06-20 15:21:52',NULL,'1','Add New Invoice','1'),
('2058','VR-23-2058','2023-06-20 00:00:00','0','1250.00','1','81.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-20 15:37:07','2023-06-20 15:37:07',NULL,'1','Add New Invoice','1'),
('2059','VR-23-2059','2023-06-20 00:00:00','0','1250.00','1','869.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-06-20 16:07:07','2023-06-20 16:07:07',NULL,'1','Add New Invoice','1'),
('2060','VR-23-2060','2023-06-21 00:00:00','0','1250.00','1','85.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-06-21 15:47:55','2023-06-21 15:47:55',NULL,'1','Add New Invoice','1'),
('2061','VR-23-2061','2023-06-21 00:00:00','0','1250.00','1','118.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-06-21 16:10:20','2023-06-21 16:10:20',NULL,'1','Add New Invoice','1'),
('2062','VR-23-2062','2023-06-21 00:00:00','0','1250.00','1','290.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-06-21 16:18:16','2023-06-21 16:18:16',NULL,'1','Add New Invoice','1'),
('2063','VR-23-2063','2023-06-21 00:00:00','0','1250.00','1','2.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-21 17:16:39','2023-06-21 17:16:39',NULL,'1','Add New Invoice','1'),
('2064','VR-23-2064','2023-06-21 00:00:00','0','1250.00','1','211.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-21 17:19:02','2023-06-21 17:19:02',NULL,'1','Add New Invoice','1'),
('2065','VR-23-2065','2023-06-21 00:00:00','0','1250.00','1','280.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-21 17:22:44','2023-06-21 17:22:44',NULL,'1','Add New Invoice','1'),
('2066','VR-23-2066','2023-06-22 00:00:00','0','1250.00','1','316.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-22 13:13:48','2023-06-22 13:13:48',NULL,'1','Add New Invoice','1'),
('2067','VR-23-2067','2023-06-22 00:00:00','0','1250.00','1','547.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-06-22 14:48:22','2023-06-22 14:48:22',NULL,'1','Add New Invoice','1'),
('2068','VR-23-2068','2023-06-22 00:00:00','0','1250.00','1','95.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-06-22 14:57:05','2023-06-22 14:57:05',NULL,'1','Add New Invoice','1'),
('2069','VR-23-2069','2023-06-22 00:00:00','0','1250.00','1','31.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-22 14:58:35','2023-06-22 14:58:35',NULL,'1','Add New Invoice','1'),
('2070','VR-23-2070','2023-06-22 00:00:00','0','1250.00','1','52.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-06-22 14:59:17','2023-06-22 14:59:17',NULL,'1','Add New Invoice','1'),
('2071','VR-23-2071','2023-06-22 00:00:00','0','1250.00','1','138.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-06-22 15:12:49','2023-06-22 15:12:49',NULL,'1','Add New Invoice','1'),
('2072','VR-23-2072','2023-06-22 00:00:00','0','1250.00','1','54.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-22 15:15:03','2023-06-22 15:15:03',NULL,'1','Add New Invoice','1'),
('2073','VR-23-2073','2023-06-22 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-06-22 15:55:29','2023-06-22 15:55:29',NULL,'1','Add New Invoice','1'),
('2074','VR-23-2074','2023-06-22 00:00:00','0','1250.00','1','38.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-06-22 16:01:45','2023-06-22 16:01:45',NULL,'1','Add New Invoice','1'),
('2075','VR-23-2075','2023-06-22 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-06-22 16:20:58','2023-06-22 16:20:58',NULL,'1','Add New Invoice','1'),
('2076','VR-23-2076','2023-06-22 00:00:00','0','1250.00','1','685.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-22 16:26:54','2023-06-22 16:26:54',NULL,'1','Add New Invoice','1'),
('2077','VR-23-2077','2023-06-24 00:00:00','0','1250.00','1','414.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-06-24 16:01:47','2023-06-24 16:01:47',NULL,'1','Add New Invoice','1'),
('2078','VR-23-2078','2023-06-24 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-06-24 16:04:48','2023-07-20 10:52:26',NULL,'1','Update Invoice','1'),
('2079','VR-23-2079','2023-06-24 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-06-24 16:08:46','2023-06-24 16:08:46',NULL,'1','Add New Invoice','1'),
('2080','VR-23-2080','2023-06-24 00:00:00','0','1250.00','1','288.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-24 16:11:23','2023-06-24 16:11:23',NULL,'1','Add New Invoice','1'),
('2081','VR-23-2081','2023-06-24 00:00:00','0','1250.00','1','380.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-24 16:40:54','2023-06-24 16:40:54',NULL,'1','Add New Invoice','1'),
('2082','VR-23-2082','2023-06-24 00:00:00','0','1250.00','1','275.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-06-24 16:42:40','2023-06-24 16:42:40',NULL,'1','Add New Invoice','1'),
('2083','VR-23-2083','2023-06-24 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-06-24 16:44:38','2023-06-24 16:44:38',NULL,'1','Add New Invoice','1'),
('2084','VR-23-2084','2023-06-24 00:00:00','0','1250.00','1','156.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-06-24 16:57:01','2023-06-24 16:57:01',NULL,'1','Add New Invoice','1'),
('2085','VR-23-2085','2023-06-24 00:00:00','0','1250.00','1','52.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-24 17:11:37','2023-06-24 17:11:37',NULL,'1','Add New Invoice','1'),
('2086','INV-23-2086','2023-06-24 00:00:00','0','1250.00','1','65.70','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2023-06-24 05:21:17','2023-06-24 05:23:55','2023-06-24 05:24:33','1','Delete Invoice','1'),
('2087','INV-23-2087','2023-06-24 00:00:00','0','1250.00','1','110.70','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-06-24 05:26:16','2023-06-24 05:27:12',NULL,'1','Update Invoice','1'),
('2088','INV-23-2088','2023-06-25 00:00:00','0','1250.00','1','132.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-06-25 03:23:10','2023-06-25 03:23:10',NULL,'1','Add New Invoice','1'),
('2089','VR-23-2089','2023-06-25 00:00:00','0','1250.00','1','7818.31','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-06-25 16:11:27','2023-06-25 16:11:27',NULL,'1','Add New Invoice','1'),
('2090','VR-23-2090','2023-06-25 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-06-25 16:39:53','2023-06-25 16:39:53',NULL,'1','Add New Invoice','1'),
('2091','VR-23-2091','2023-06-25 00:00:00','0','1250.00','1','118.57','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-25 16:51:44','2023-06-25 16:51:44',NULL,'1','Add New Invoice','1'),
('2092','VR-23-2092','2023-06-25 00:00:00','0','1250.00','1','71.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-06-25 16:57:24','2023-07-02 04:23:54',NULL,'1','Update Invoice','1'),
('2093','VR-23-2093','2023-06-25 00:00:00','0','1250.00','1','136.29','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-06-25 16:58:45','2023-06-25 16:58:45',NULL,'1','Add New Invoice','1'),
('2094','VR-23-2094','2023-06-25 00:00:00','0','1250.00','1','232.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-25 17:00:04','2023-06-25 17:00:04',NULL,'1','Add New Invoice','1'),
('2095','VR-23-2095','2023-06-25 00:00:00','0','1250.00','1','106.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-06-25 17:03:39','2023-06-25 17:03:39',NULL,'1','Add New Invoice','1'),
('2096','VR-23-2096','2023-06-25 00:00:00','0','1250.00','1','324.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-06-25 17:06:19','2023-06-25 17:06:19',NULL,'1','Add New Invoice','1'),
('2097','VR-23-2097','2023-06-26 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-06-26 09:50:30','2023-06-26 09:50:30',NULL,'1','Add New Invoice','1'),
('2098','VR-23-2098','2023-06-26 00:00:00','0','1250.00','1','139.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-06-26 10:38:21','2023-06-26 10:38:21',NULL,'1','Add New Invoice','1'),
('2099','VR-23-2099','2023-07-02 00:00:00','0','1250.00','1','26.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-02 14:06:00','2023-07-02 14:06:00',NULL,'1','Add New Invoice','1'),
('2100','VR-23-2100','2023-07-02 00:00:00','0','1250.00','1','2416.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-02 14:55:43','2023-07-02 14:55:43',NULL,'1','Add New Invoice','1'),
('2101','VR-23-2101','2023-07-02 00:00:00','0','1250.00','1','873.91','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-07-02 15:14:00','2023-07-02 15:14:00',NULL,'1','Add New Invoice','1'),
('2102','VR-23-2102','2023-07-02 00:00:00','0','1250.00','1','521.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-07-02 15:40:22','2023-07-02 15:40:22',NULL,'1','Add New Invoice','1'),
('2103','VR-23-2103','2023-07-02 00:00:00','0','1250.00','1','347.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-02 15:42:53','2023-07-02 15:42:53',NULL,'1','Add New Invoice','1'),
('2104','VR-23-2104','2023-07-02 00:00:00','0','1250.00','1','348.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-07-02 15:44:16','2023-07-02 15:44:16',NULL,'1','Add New Invoice','1'),
('2105','VR-23-2105','2023-07-04 00:00:00','0','1250.00','1','532.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-04 17:27:54','2023-07-04 17:27:54',NULL,'1','Add New Invoice','1'),
('2106','VR-23-2106','2023-07-04 00:00:00','0','1250.00','1','40.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-04 17:29:28','2023-07-04 17:29:28',NULL,'1','Add New Invoice','1'),
('2107','VR-23-2107','2023-07-04 00:00:00','0','1250.00','1','123.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-04 17:30:35','2023-07-04 17:30:35',NULL,'1','Add New Invoice','1'),
('2108','VR-23-2108','2023-07-04 00:00:00','0','1250.00','1','125.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-07-04 17:32:43','2023-07-04 17:32:43',NULL,'1','Add New Invoice','1'),
('2109','VR-23-2109','2023-07-04 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-07-04 17:46:19','2023-07-04 17:46:19',NULL,'1','Add New Invoice','1'),
('2110','VR-23-2110','2023-07-05 00:00:00','0','1250.00','1','1565.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-07-05 11:39:39','2023-07-13 04:46:41',NULL,'1','Update Invoice','1'),
('2111','VR-23-2111','2023-07-05 00:00:00','0','1250.00','1','1062.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-07-05 15:06:54','2023-07-05 15:06:54',NULL,'1','Add New Invoice','1'),
('2112','VR-23-2112','2023-07-05 00:00:00','0','1250.00','1','101.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-05 15:49:15','2023-07-05 15:49:15',NULL,'1','Add New Invoice','1'),
('2113','VR-23-2113','2023-07-05 00:00:00','0','1250.00','1','6556.99','0.00','CE','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2023-07-05 17:07:13','2023-07-05 17:07:13',NULL,'1','Add New Invoice','1'),
('2114','VR-23-2114','2023-07-05 00:00:00','0','1250.00','1','467.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-07-05 17:20:45','2023-07-05 17:20:45',NULL,'1','Add New Invoice','1'),
('2115','VR-23-2115','2023-07-06 00:00:00','0','1250.00','1','291.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-07-06 14:42:31','2023-07-06 14:42:31',NULL,'1','Add New Invoice','1'),
('2116','VR-23-2116','2023-07-06 00:00:00','0','1250.00','1','220.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-07-06 14:43:35','2023-07-06 14:43:35',NULL,'1','Add New Invoice','1'),
('2117','VR-23-2117','2023-07-06 00:00:00','0','1250.00','1','133.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-06 14:50:05','2023-07-06 14:50:05',NULL,'1','Add New Invoice','1'),
('2118','VR-23-2118','2023-07-06 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-07-06 14:58:26','2023-07-06 14:58:26',NULL,'1','Add New Invoice','1'),
('2119','VR-23-2119','2023-07-06 00:00:00','0','1250.00','1','38.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-07-06 15:11:26','2023-07-06 15:11:26',NULL,'1','Add New Invoice','1'),
('2120','VR-23-2120','2023-07-06 00:00:00','0','1250.00','1','287.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-06 15:20:06','2023-07-06 15:20:06',NULL,'1','Add New Invoice','1'),
('2121','VR-23-2121','2023-07-06 00:00:00','0','1250.00','1','466.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-06 15:30:32','2023-07-06 15:30:32',NULL,'1','Add New Invoice','1'),
('2122','VR-23-2122','2023-07-06 00:00:00','0','1250.00','1','362.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-07-06 15:36:39','2023-07-06 15:36:39',NULL,'1','Add New Invoice','1'),
('2123','VR-23-2123','2023-07-06 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-07-06 15:39:38','2023-07-06 15:39:38',NULL,'1','Add New Invoice','1'),
('2124','VR-23-2124','2023-07-06 00:00:00','0','1250.00','1','78.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-07-06 15:48:04','2023-07-06 15:48:04',NULL,'1','Add New Invoice','1'),
('2125','VR-23-2125','2023-07-06 00:00:00','0','1250.00','1','169.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-07-06 15:49:17','2023-07-06 15:49:17',NULL,'1','Add New Invoice','1'),
('2126','VR-23-2126','2023-07-06 00:00:00','0','1250.00','1','220.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-07-06 15:50:52','2023-07-06 15:50:52',NULL,'1','Add New Invoice','1'),
('2127','VR-23-2127','2023-07-06 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-07-06 15:52:44','2023-07-06 15:52:44',NULL,'1','Add New Invoice','1'),
('2128','VR-23-2128','2023-07-11 00:00:00','0','1250.00','1','420.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','98','0','2023-07-11 10:17:19','2023-07-11 10:17:19',NULL,'1','Add New Invoice','1'),
('2129','VR-23-2129','2023-07-11 00:00:00','0','1250.00','1','8288.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','111','0','2023-07-11 11:02:55','2023-07-11 11:02:55',NULL,'1','Add New Invoice','1'),
('2130','VR-23-2130','2023-07-11 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-07-11 14:28:14','2023-07-11 14:28:14',NULL,'1','Add New Invoice','1'),
('2131','VR-23-2131','2023-07-11 00:00:00','0','1250.00','1','1639.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-07-11 14:49:33','2023-07-11 14:49:33',NULL,'1','Add New Invoice','1'),
('2132','VR-23-2132','2023-07-12 00:00:00','0','1250.00','1','408.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-12 09:40:03','2023-07-12 09:40:03',NULL,'1','Add New Invoice','1'),
('2133','VR-23-2133','2023-07-12 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-07-12 09:41:13','2023-07-12 09:41:13',NULL,'1','Add New Invoice','1'),
('2134','INV-23-2134','2023-07-12 00:00:00','0','1250.00','1','17.04','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-12 09:43:45','2023-07-12 12:05:34',NULL,'1','Update Invoice','1'),
('2135','VR-23-2135','2023-07-12 00:00:00','0','1250.00','1','182.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-12 09:48:38','2023-07-12 09:48:38',NULL,'1','Add New Invoice','1'),
('2136','VR-23-2136','2023-07-12 00:00:00','0','1250.00','1','746.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-12 09:53:54','2023-07-12 09:53:54',NULL,'1','Add New Invoice','1'),
('2137','VR-23-2137','2023-07-12 00:00:00','0','1250.00','1','344.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-07-12 09:57:50','2023-07-12 09:57:50',NULL,'1','Add New Invoice','1'),
('2138','INV-23-2138','2023-07-12 00:00:00','0','1250.00','1','45.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-07-12 10:02:47','2023-07-12 10:02:47',NULL,'1','Add New Invoice','1'),
('2139','VR-23-2139','2023-07-12 00:00:00','0','1250.00','1','7801.28','0.00','5/','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-12 13:36:43','2023-07-13 04:32:28',NULL,'1','Update Invoice','1'),
('2140','VR-23-2140','2023-07-12 00:00:00','0','1250.00','1','987.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-07-12 13:44:42','2023-07-12 13:44:42',NULL,'1','Add New Invoice','1'),
('2141','VR-23-2141','2023-07-12 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-07-12 14:03:52','2023-07-12 14:03:52',NULL,'1','Add New Invoice','1'),
('2142','VR-23-2142','2023-07-12 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-07-12 14:04:47','2023-07-12 14:04:47',NULL,'1','Add New Invoice','1'),
('2143','VR-23-2143','2023-07-12 00:00:00','0','1250.00','1','72.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-12 14:08:59','2023-07-12 14:08:59',NULL,'1','Add New Invoice','1'),
('2144','VR-23-2144','2023-07-13 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-07-13 09:45:40','2023-07-13 09:45:40',NULL,'1','Add New Invoice','1'),
('2145','VR-23-2145','2023-07-13 00:00:00','0','1250.00','1','390.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-07-13 09:47:17','2023-07-13 09:47:17',NULL,'1','Add New Invoice','1'),
('2146','VR-23-2146','2023-07-13 00:00:00','0','1250.00','1','324.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-07-13 09:49:51','2023-07-13 09:49:51',NULL,'1','Add New Invoice','1'),
('2147','VR-23-2147','2023-07-13 00:00:00','0','1250.00','1','1063.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-07-13 10:18:58','2023-07-13 10:18:58',NULL,'1','Add New Invoice','1'),
('2148','VR-23-2148','2023-07-13 00:00:00','0','1250.00','1','767.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-13 10:27:04','2023-07-13 10:27:04',NULL,'1','Add New Invoice','1'),
('2149','VR-23-2149','2023-07-13 00:00:00','0','1250.00','1','204.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-13 16:35:38','2023-07-13 16:35:38',NULL,'1','Add New Invoice','1'),
('2150','VR-23-2150','2023-07-13 00:00:00','0','1250.00','1','177.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-13 16:38:30','2023-07-13 16:38:30',NULL,'1','Add New Invoice','1'),
('2151','VR-23-2151','2023-07-13 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-07-13 16:39:47','2023-07-13 16:39:47',NULL,'1','Add New Invoice','1'),
('2152','VR-23-2152','2023-07-13 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-07-13 16:43:53','2023-07-13 16:43:53',NULL,'1','Add New Invoice','1'),
('2153','VR-23-2153','2023-07-13 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-07-13 16:44:47','2023-07-13 16:44:47',NULL,'1','Add New Invoice','1'),
('2154','VR-23-2154','2023-07-13 00:00:00','0','1250.00','1','172.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-07-13 17:03:25','2023-07-13 17:03:25',NULL,'1','Add New Invoice','1'),
('2155','VR-23-2155','2023-07-13 00:00:00','0','1250.00','1','296.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-07-13 17:04:29','2023-07-13 17:04:29',NULL,'1','Add New Invoice','1'),
('2156','VR-23-2156','2023-07-15 00:00:00','0','1250.00','1','1275.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-07-15 16:08:51','2023-07-15 16:08:51',NULL,'1','Add New Invoice','1'),
('2157','VR-23-2157','2023-07-15 00:00:00','0','1250.00','1','199.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-15 16:11:33','2023-07-15 16:11:33',NULL,'1','Add New Invoice','1'),
('2158','VR-23-2158','2023-07-15 00:00:00','0','1250.00','1','322.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-07-15 16:13:31','2023-07-15 16:13:31',NULL,'1','Add New Invoice','1'),
('2159','VR-23-2159','2023-07-15 00:00:00','0','1250.00','1','76.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-07-15 16:18:03','2023-07-15 16:18:03',NULL,'1','Add New Invoice','1'),
('2160','VR-23-2160','2023-07-15 00:00:00','0','1250.00','1','176.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-07-15 16:19:21','2023-07-15 16:19:21',NULL,'1','Add New Invoice','1'),
('2161','VR-23-2161','2023-07-15 00:00:00','0','1250.00','1','52.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-15 16:20:39','2023-07-15 16:20:39',NULL,'1','Add New Invoice','1'),
('2162','VR-23-2162','2023-07-15 00:00:00','0','1250.00','1','19.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-07-15 16:25:52','2023-07-15 16:25:52',NULL,'1','Add New Invoice','1'),
('2163','VR-23-2163','2023-07-15 00:00:00','0','1250.00','1','92.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-07-15 16:39:39','2023-07-15 16:39:39',NULL,'1','Add New Invoice','1'),
('2164','VR-23-2164','2023-07-15 00:00:00','0','1250.00','1','41.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-15 16:46:24','2023-07-15 16:46:24',NULL,'1','Add New Invoice','1'),
('2165','VR-23-2165','2023-07-15 00:00:00','0','1250.00','1','365.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-15 16:47:48','2023-07-15 16:47:48',NULL,'1','Add New Invoice','1'),
('2166','VR-23-2166','2023-07-15 00:00:00','0','1250.00','1','3953.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-15 17:19:28','2023-07-15 17:19:28',NULL,'1','Add New Invoice','1'),
('2167','INV-23-2167','2023-07-16 00:00:00','0','1250.00','1','66.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-07-16 04:17:21','2023-07-16 04:17:21',NULL,'1','Add New Invoice','1'),
('2168','VR-23-2168','2023-07-17 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-07-17 11:06:47','2023-07-17 11:06:47',NULL,'1','Add New Invoice','1'),
('2169','VR-23-2169','2023-07-17 00:00:00','0','1250.00','1','187.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-17 11:11:41','2023-07-17 11:11:41',NULL,'1','Add New Invoice','1'),
('2170','VR-23-2170','2023-07-17 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-17 11:18:20','2023-07-17 11:18:20',NULL,'1','Add New Invoice','1'),
('2171','VR-23-2171','2023-07-17 00:00:00','0','1250.00','1','229.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-17 11:20:30','2023-07-17 04:52:54',NULL,'1','Update Invoice','1'),
('2172','VR-23-2172','2023-07-17 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-07-17 11:39:40','2023-07-17 11:39:40',NULL,'1','Add New Invoice','1'),
('2173','VR-23-2173','2023-07-17 00:00:00','0','1250.00','1','149.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-17 12:20:59','2023-07-17 12:20:59',NULL,'1','Add New Invoice','1'),
('2174','VR-23-2174','2023-07-17 00:00:00','0','1250.00','1','253.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-07-17 12:21:57','2023-07-17 12:21:57',NULL,'1','Add New Invoice','1'),
('2175','VR-23-2175','2023-07-17 00:00:00','0','1250.00','1','559.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-07-17 14:29:34','2023-07-17 14:29:34',NULL,'1','Add New Invoice','1'),
('2176','VR-23-2176','2023-07-17 00:00:00','0','1250.00','1','322.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-07-17 14:39:32','2023-07-17 14:39:32',NULL,'1','Add New Invoice','1'),
('2177','VR-23-2177','2023-07-17 00:00:00','0','1250.00','1','102.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-07-17 14:52:24','2023-07-17 05:09:41',NULL,'1','Update Invoice','1'),
('2178','VR-23-2178','2023-07-17 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-07-17 15:03:10','2023-07-17 15:03:10',NULL,'1','Add New Invoice','1'),
('2179','VR-23-2179','2023-07-17 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-17 15:03:56','2023-07-17 15:03:56',NULL,'1','Add New Invoice','1'),
('2180','VR-23-2180','2023-07-17 00:00:00','0','1250.00','1','173.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-17 15:05:54','2023-07-17 15:05:54',NULL,'1','Add New Invoice','1'),
('2181','VR-23-2181','2023-07-17 00:00:00','0','1250.00','1','256.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-17 15:09:25','2023-07-17 15:09:25',NULL,'1','Add New Invoice','1'),
('2182','VR-23-2182','2023-07-17 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-07-17 15:31:07','2023-07-17 15:31:07',NULL,'1','Add New Invoice','1'),
('2183','VR-23-2183','2023-07-17 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-17 15:40:59','2023-07-17 15:40:59',NULL,'1','Add New Invoice','1'),
('2184','VR-23-2184','2023-07-17 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-17 16:10:27','2023-07-17 16:10:27',NULL,'1','Add New Invoice','1'),
('2185','VR-23-2185','2023-07-18 00:00:00','0','1250.00','1','847.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-07-18 14:53:14','2023-07-18 05:08:53',NULL,'1','Update Invoice','1'),
('2186','VR-23-2186','2023-07-18 00:00:00','0','1250.00','1','141.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-07-18 14:55:05','2023-07-18 14:55:05',NULL,'1','Add New Invoice','1'),
('2187','VR-23-2187','2023-07-18 00:00:00','0','1250.00','1','68.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-18 15:00:10','2023-07-18 15:00:10',NULL,'1','Add New Invoice','1'),
('2188','VR-23-2188','2023-07-18 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-18 15:11:18','2023-07-18 15:11:18',NULL,'1','Add New Invoice','1'),
('2189','VR-23-2189','2023-07-18 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-07-18 15:12:01','2023-07-18 15:12:01',NULL,'1','Add New Invoice','1'),
('2190','VR-23-2190','2023-07-18 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-07-18 15:13:40','2023-07-18 15:13:40',NULL,'1','Add New Invoice','1'),
('2191','VR-23-2191','2023-07-18 00:00:00','0','1250.00','1','1382.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-18 17:06:17','2023-07-18 17:06:17',NULL,'1','Add New Invoice','1'),
('2192','VR-23-2192','2023-07-19 00:00:00','0','1250.00','1','461.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-19 10:28:57','2023-07-19 11:26:56',NULL,'1','Update Invoice','1'),
('2193','VR-23-2193','2023-07-19 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-19 14:27:30','2023-07-19 14:27:30',NULL,'1','Add New Invoice','1'),
('2194','VR-23-2194','2023-07-19 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-07-19 14:35:08','2023-07-19 14:35:08',NULL,'1','Add New Invoice','1'),
('2195','VR-23-2195','2023-07-19 00:00:00','0','1250.00','1','46.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-07-19 14:53:13','2023-07-19 14:53:13',NULL,'1','Add New Invoice','1'),
('2196','VR-23-2196','2023-07-20 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-07-20 12:07:57','2023-07-20 12:08:15',NULL,'1','Update Invoice','1'),
('2197','VR-23-2197','2023-07-20 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-07-20 14:48:32','2023-07-20 14:48:32',NULL,'1','Add New Invoice','1'),
('2198','VR-23-2198','2023-07-20 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-07-20 14:49:47','2023-07-20 14:49:47',NULL,'1','Add New Invoice','1'),
('2199','VR-23-2199','2023-07-20 00:00:00','0','1250.00','1','403.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-20 14:53:55','2023-07-20 14:53:55',NULL,'1','Add New Invoice','1'),
('2200','VR-23-2200','2023-07-20 00:00:00','0','1250.00','1','27.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-20 14:56:41','2023-07-20 14:56:41',NULL,'1','Add New Invoice','1'),
('2201','VR-23-2201','2023-07-20 00:00:00','0','1250.00','1','424.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-07-20 15:18:20','2023-07-20 15:18:20',NULL,'1','Add New Invoice','1'),
('2202','VR-23-2202','2023-07-22 00:00:00','0','1250.00','1','1092.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-22 11:05:42','2023-07-22 11:05:42',NULL,'1','Add New Invoice','1'),
('2203','VR-23-2203','2023-07-22 00:00:00','0','1250.00','1','1462.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','112','0','2023-07-22 14:57:53','2023-07-24 11:10:52',NULL,'1','Update Invoice','1'),
('2204','VR-23-2204','2023-07-22 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-07-22 15:52:52','2023-07-22 15:52:52',NULL,'1','Add New Invoice','1'),
('2205','VR-23-2205','2023-07-22 00:00:00','0','1250.00','1','309.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-07-22 16:42:03','2023-07-22 16:42:03',NULL,'1','Add New Invoice','1'),
('2206','VR-23-2206','2023-07-22 00:00:00','0','1250.00','1','208.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-22 16:51:13','2023-07-22 16:51:13',NULL,'1','Add New Invoice','1'),
('2207','VR-23-2207','2023-07-22 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-07-22 16:52:02','2023-07-22 16:52:02',NULL,'1','Add New Invoice','1'),
('2208','VR-23-2208','2023-07-23 00:00:00','0','1250.00','1','573.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-23 09:38:06','2023-07-23 09:38:06',NULL,'1','Add New Invoice','1'),
('2209','VR-23-2209','2023-07-23 00:00:00','0','1250.00','1','283.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-23 09:52:52','2023-07-23 09:52:52',NULL,'1','Add New Invoice','1'),
('2210','VR-23-2210','2023-07-23 00:00:00','0','1250.00','1','254.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-07-23 10:14:17','2023-07-23 10:14:17',NULL,'1','Add New Invoice','1'),
('2211','VR-23-2211','2023-07-23 00:00:00','0','1250.00','1','5.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-23 10:32:31','2023-07-23 10:32:31',NULL,'1','Add New Invoice','1'),
('2212','VR-23-2212','2023-07-23 00:00:00','0','1250.00','1','71.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-23 10:44:48','2023-07-23 10:44:48',NULL,'1','Add New Invoice','1'),
('2213','VR-23-2213','2023-07-23 00:00:00','0','1250.00','1','314.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-07-23 16:59:53','2023-07-23 16:59:53',NULL,'1','Add New Invoice','1'),
('2214','VR-23-2214','2023-07-23 00:00:00','0','1250.00','1','322.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-23 17:07:12','2023-07-23 17:07:12',NULL,'1','Add New Invoice','1'),
('2215','VR-23-2215','2023-07-24 00:00:00','0','1250.00','1','928.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2023-07-24 10:25:02','2023-07-24 10:25:52',NULL,'1','Update Invoice','1'),
('2216','VR-23-2216','2023-07-24 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-24 14:56:14','2023-07-24 14:56:14',NULL,'1','Add New Invoice','1'),
('2217','VR-23-2217','2023-07-24 00:00:00','0','1250.00','1','43.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-24 15:02:46','2023-07-24 15:02:46',NULL,'1','Add New Invoice','1'),
('2218','VR-23-2218','2023-07-24 00:00:00','0','1250.00','1','98.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-07-24 15:06:40','2023-07-24 04:41:38',NULL,'1','Update Invoice','1'),
('2219','VR-23-2219','2023-07-24 00:00:00','0','1250.00','1','345.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-07-24 15:16:56','2023-07-24 03:25:45',NULL,'1','Update Invoice','1'),
('2220','VR-23-2220','2023-07-24 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-07-24 15:23:58','2023-07-24 15:23:58',NULL,'1','Add New Invoice','1'),
('2221','VR-23-2221','2023-07-24 00:00:00','0','1250.00','1','122.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-24 15:31:54','2023-07-24 15:31:54',NULL,'1','Add New Invoice','1'),
('2222','VR-23-2222','2023-07-24 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-24 15:33:30','2023-07-24 15:33:30',NULL,'1','Add New Invoice','1'),
('2223','VR-23-2223','2023-07-24 00:00:00','0','1250.00','1','262.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-24 15:43:33','2023-07-24 15:43:33',NULL,'1','Add New Invoice','1'),
('2224','VR-23-2224','2023-07-24 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-07-24 16:38:08','2023-07-24 16:38:08',NULL,'1','Add New Invoice','1'),
('2225','VR-23-2225','2023-07-24 00:00:00','0','1250.00','1','119.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-24 16:43:13','2023-07-25 04:10:42',NULL,'1','Update Invoice','1'),
('2226','VR-23-2226','2023-07-24 00:00:00','0','1250.00','1','304.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-07-24 16:52:29','2023-07-24 16:52:29',NULL,'1','Add New Invoice','1'),
('2227','VR-23-2227','2023-07-25 00:00:00','0','1250.00','1','57.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-07-25 14:20:09','2023-07-25 14:20:09',NULL,'1','Add New Invoice','1'),
('2228','VR-23-2228','2023-07-25 00:00:00','0','1250.00','1','167.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-07-25 14:30:15','2023-07-25 14:30:15',NULL,'1','Add New Invoice','1'),
('2229','VR-23-2229','2023-07-25 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-07-25 14:34:03','2023-07-25 14:34:03',NULL,'1','Add New Invoice','1'),
('2230','VR-23-2230','2023-07-25 00:00:00','0','1250.00','1','19.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-07-25 14:36:47','2023-07-25 14:36:47',NULL,'1','Add New Invoice','1'),
('2231','VR-23-2231','2023-07-25 00:00:00','0','1250.00','1','84.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-25 14:44:52','2023-07-25 14:44:52',NULL,'1','Add New Invoice','1'),
('2232','VR-23-2232','2023-07-26 00:00:00','0','1250.00','1','400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-07-26 15:44:16','2023-07-26 15:44:16',NULL,'1','Add New Invoice','1'),
('2233','VR-23-2233','2023-07-26 00:00:00','0','1250.00','1','109.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-07-26 15:46:07','2023-07-26 15:46:07',NULL,'1','Add New Invoice','1'),
('2234','VR-23-2234','2023-07-26 00:00:00','0','1250.00','1','343.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-26 15:48:57','2023-07-26 15:48:57',NULL,'1','Add New Invoice','1'),
('2235','VR-23-2235','2023-07-26 00:00:00','0','1250.00','1','806.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-07-26 16:00:59','2023-07-26 04:04:05',NULL,'1','Update Invoice','1'),
('2236','VR-23-2236','2023-07-26 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-07-26 16:04:58','2023-07-26 16:04:58',NULL,'1','Add New Invoice','1'),
('2237','VR-23-2237','2023-07-26 00:00:00','0','1250.00','1','556.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-26 16:19:19','2023-07-26 04:26:25',NULL,'1','Update Invoice','1'),
('2238','VR-23-2238','2023-07-27 00:00:00','0','1250.00','1','264.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-07-27 14:24:50','2023-07-27 14:24:50',NULL,'1','Add New Invoice','1'),
('2239','VR-23-2239','2023-07-27 00:00:00','0','1250.00','1','3861.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-27 15:25:31','2023-07-27 15:25:31',NULL,'1','Add New Invoice','1'),
('2240','VR-23-2240','2023-07-27 00:00:00','0','1250.00','1','6653.46','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-07-27 15:47:32','2023-07-27 15:47:32',NULL,'1','Add New Invoice','1'),
('2241','VR-23-2241','2023-07-27 00:00:00','0','1250.00','1','142.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-07-27 16:19:14','2023-07-27 16:19:14',NULL,'1','Add New Invoice','1'),
('2242','VR-23-2242','2023-07-27 00:00:00','0','1250.00','1','227.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-07-27 16:20:14','2023-07-27 16:20:14',NULL,'1','Add New Invoice','1'),
('2243','VR-23-2243','2023-07-27 00:00:00','0','1250.00','1','25.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-07-27 16:25:03','2023-07-27 16:25:03',NULL,'1','Add New Invoice','1'),
('2244','VR-23-2244','2023-07-27 00:00:00','0','1250.00','1','21.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-07-27 16:28:49','2023-07-27 16:28:49',NULL,'1','Add New Invoice','1'),
('2245','VR-23-2245','2023-07-31 00:00:00','0','1250.00','1','3899.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-07-31 11:06:09','2023-07-31 11:06:09',NULL,'1','Add New Invoice','1'),
('2246','VR-23-2246','2023-08-01 00:00:00','0','1250.00','1','365.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-08-01 09:46:27','2023-08-01 05:09:46',NULL,'1','Update Invoice','1'),
('2247','VR-23-2247','2023-08-01 00:00:00','0','1250.00','1','430.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-08-01 09:51:22','2023-08-01 09:51:22',NULL,'1','Add New Invoice','1'),
('2248','VR-23-2248','2023-08-01 00:00:00','0','1250.00','1','294.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-01 10:36:02','2023-08-01 10:36:02',NULL,'1','Add New Invoice','1'),
('2249','VR-23-2249','2023-08-01 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-08-01 12:00:52','2023-08-01 12:00:52',NULL,'1','Add New Invoice','1'),
('2250','VR-23-2250','2023-08-01 00:00:00','0','1250.00','1','8.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-08-01 14:07:10','2023-08-01 14:07:10',NULL,'1','Add New Invoice','1'),
('2251','VR-23-2251','2023-08-01 00:00:00','0','1250.00','1','454.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-01 14:10:24','2023-08-02 10:02:45',NULL,'1','Update Invoice','1'),
('2252','VR-23-2252','2023-08-01 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-01 14:11:44','2023-08-01 14:11:44',NULL,'1','Add New Invoice','1'),
('2253','VR-23-2253','2023-08-01 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-08-01 14:12:52','2023-08-01 14:12:52',NULL,'1','Add New Invoice','1'),
('2254','VR-23-2254','2023-08-01 00:00:00','0','1250.00','1','197.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-08-01 14:22:13','2023-08-01 14:22:13',NULL,'1','Add New Invoice','1'),
('2255','VR-23-2255','2023-08-01 00:00:00','0','1250.00','1','117.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-01 14:27:33','2023-08-02 10:00:48',NULL,'1','Update Invoice','1'),
('2256','VR-23-2256','2023-08-01 00:00:00','0','1250.00','1','79.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-08-01 14:29:41','2023-08-01 14:29:41',NULL,'1','Add New Invoice','1'),
('2257','VR-23-2257','2023-08-01 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-08-01 16:30:32','2023-08-01 16:30:32',NULL,'1','Add New Invoice','1'),
('2258','VR-23-2258','2023-08-01 00:00:00','0','1250.00','1','176.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-01 16:31:57','2023-08-01 16:31:57',NULL,'1','Add New Invoice','1'),
('2259','VR-23-2259','2023-08-01 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-01 16:35:36','2023-08-01 16:35:36',NULL,'1','Add New Invoice','1'),
('2260','VR-23-2260','2023-08-01 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-08-01 16:36:49','2023-08-01 16:36:49',NULL,'1','Add New Invoice','1'),
('2261','VR-23-2261','2023-08-01 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-01 16:40:31','2023-08-01 16:40:31',NULL,'1','Add New Invoice','1'),
('2262','VR-23-2262','2023-08-01 00:00:00','0','1250.00','1','128.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-08-01 17:03:46','2023-08-01 17:03:46',NULL,'1','Add New Invoice','1'),
('2263','VR-23-2263','2023-08-02 00:00:00','0','1250.00','1','1318.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-02 12:02:09','2023-08-02 12:02:09',NULL,'1','Add New Invoice','1'),
('2264','VR-23-2264','2023-08-02 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-02 12:12:15','2023-08-02 12:12:15',NULL,'1','Add New Invoice','1'),
('2265','VR-23-2265','2023-08-02 00:00:00','0','1250.00','1','89.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-02 12:14:02','2023-08-02 12:14:02',NULL,'1','Add New Invoice','1'),
('2266','VR-23-2266','2023-08-02 00:00:00','0','1250.00','1','30.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-02 12:16:03','2023-08-02 12:16:03',NULL,'1','Add New Invoice','1'),
('2267','VR-23-2267','2023-08-03 00:00:00','0','1250.00','1','295.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-03 15:19:59','2023-08-03 15:19:59',NULL,'1','Add New Invoice','1'),
('2268','VR-23-2268','2023-08-03 00:00:00','0','1250.00','1','140.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-03 15:24:23','2023-08-05 09:49:22',NULL,'1','Update Invoice','1'),
('2269','VR-23-2269','2023-08-03 00:00:00','0','1250.00','1','63.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-03 15:27:38','2023-08-03 15:27:38',NULL,'1','Add New Invoice','1'),
('2270','VR-23-2270','2023-08-03 00:00:00','0','1250.00','1','344.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-03 15:53:16','2023-08-03 15:53:16',NULL,'1','Add New Invoice','1'),
('2271','VR-23-2271','2023-08-03 00:00:00','0','1250.00','1','88.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-03 16:00:06','2023-08-03 16:00:06',NULL,'1','Add New Invoice','1'),
('2272','VR-23-2272','2023-08-03 00:00:00','0','1250.00','1','994.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-08-03 16:05:25','2023-08-03 16:05:25',NULL,'1','Add New Invoice','1'),
('2273','VR-23-2273','2023-08-05 00:00:00','0','1250.00','1','1970.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-08-05 16:58:06','2023-08-05 16:58:06',NULL,'1','Add New Invoice','1'),
('2274','VR-23-2274','2023-08-05 00:00:00','0','1250.00','1','45.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-08-05 17:28:01','2023-08-05 17:28:01',NULL,'1','Add New Invoice','1'),
('2275','VR-23-2275','2023-08-05 00:00:00','0','1250.00','1','43.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-05 17:31:41','2023-08-05 17:31:41',NULL,'1','Add New Invoice','1'),
('2276','VR-23-2276','2023-08-06 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-08-06 11:39:20','2023-08-06 11:39:20',NULL,'1','Add New Invoice','1'),
('2277','VR-23-2277','2023-08-06 00:00:00','0','1250.00','1','18722.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-06 15:49:11','2023-08-06 15:49:11',NULL,'1','Add New Invoice','1'),
('2278','VR-23-2278','2023-08-06 00:00:00','0','1250.00','1','1020.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-08-06 16:27:49','2023-08-06 16:27:49',NULL,'1','Add New Invoice','1'),
('2279','VR-23-2279','2023-08-06 00:00:00','0','1250.00','1','24741.49','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-06 16:47:48','2023-08-06 16:47:48',NULL,'1','Add New Invoice','1'),
('2280','VR-23-2280','2023-08-06 00:00:00','0','1250.00','1','8458.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-06 17:21:28','2023-08-23 04:04:23',NULL,'1','Update Invoice','1'),
('2281','VR-23-2281','2023-08-07 00:00:00','0','1250.00','1','2529.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-07 11:26:56','2023-08-07 12:20:11',NULL,'1','Update Invoice','1'),
('2282','VR-23-2282','2023-08-07 00:00:00','0','1250.00','1','480.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-08-07 14:43:20','2023-08-07 14:43:20',NULL,'1','Add New Invoice','1'),
('2283','VR-23-2283','2023-08-07 00:00:00','0','1250.00','1','2620.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-07 16:17:16','2023-08-07 16:17:16',NULL,'1','Add New Invoice','1'),
('2284','VR-23-2284','2023-08-07 00:00:00','0','1250.00','1','131.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-08-07 17:03:16','2023-08-07 17:03:16',NULL,'1','Add New Invoice','1'),
('2285','VR-23-2285','2023-08-07 00:00:00','0','1250.00','1','228.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-08-07 17:04:28','2023-08-07 05:21:57',NULL,'1','Update Invoice','1'),
('2286','VR-23-2286','2023-08-07 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-08-07 17:19:27','2023-08-07 17:19:27',NULL,'1','Add New Invoice','1'),
('2287','VR-23-2287','2023-08-07 00:00:00','0','1250.00','1','240.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-08-07 17:23:09','2023-08-07 17:23:09',NULL,'1','Add New Invoice','1'),
('2288','VR-23-2288','2023-08-07 00:00:00','0','1250.00','1','600.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-07 17:24:26','2023-08-07 05:26:02',NULL,'1','Update Invoice','1'),
('2289','VR-23-2289','2023-08-07 00:00:00','0','1250.00','1','253.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-07 17:30:23','2023-08-10 10:32:40',NULL,'1','Update Invoice','1'),
('2290','VR-23-2290','2023-08-08 00:00:00','0','1250.00','1','2561.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-08 15:58:09','2023-08-09 09:29:15',NULL,'1','Update Invoice','1'),
('2291','VR-23-2291','2023-08-08 00:00:00','0','1250.00','1','34.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-08-08 16:41:02','2023-08-09 02:22:35',NULL,'1','Update Invoice','1'),
('2292','VR-23-2292','2023-08-08 00:00:00','0','1250.00','1','666.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-08 16:44:28','2023-08-08 16:44:28',NULL,'1','Add New Invoice','1'),
('2294','VR-23-2293','2023-08-08 00:00:00','0','1250.00','1','7519.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-08 17:04:05','2023-08-08 17:04:05',NULL,'1','Add New Invoice','1'),
('2295','VR-23-2295','2023-08-09 00:00:00','0','1250.00','1','467.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-08-09 11:21:39','2023-08-09 11:21:39',NULL,'1','Add New Invoice','1'),
('2296','VR-23-2296','2023-08-09 00:00:00','0','1250.00','1','105.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-09 14:12:03','2023-08-09 14:12:03',NULL,'1','Add New Invoice','1'),
('2297','VR-23-2297','2023-08-09 00:00:00','0','1250.00','1','225.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-09 15:19:05','2023-08-09 15:19:05',NULL,'1','Add New Invoice','1'),
('2298','VR-23-2298','2023-08-10 00:00:00','0','1250.00','1','275.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-10 09:48:35','2023-08-10 09:48:35',NULL,'1','Add New Invoice','1'),
('2299','VR-23-2299','2023-08-10 00:00:00','0','1250.00','1','22.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-08-10 10:03:30','2023-08-10 10:03:30',NULL,'1','Add New Invoice','1'),
('2300','VR-23-2300','2023-08-10 00:00:00','0','1250.00','1','250.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-08-10 10:25:43','2023-08-10 10:25:43',NULL,'1','Add New Invoice','1'),
('2301','VR-23-2301','2023-08-10 00:00:00','0','1250.00','1','83.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-10 10:28:18','2023-08-10 10:28:18',NULL,'1','Add New Invoice','1'),
('2302','VR-23-2302','2023-08-10 00:00:00','0','1250.00','1','332.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-08-10 10:49:56','2023-08-10 10:49:56',NULL,'1','Add New Invoice','1'),
('2303','VR-23-2303','2023-08-10 00:00:00','0','1250.00','1','487.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-08-10 11:00:48','2023-08-24 12:05:51',NULL,'1','Update Invoice','1'),
('2304','VR-23-2304','2023-08-10 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-10 11:23:34','2023-08-10 11:23:34',NULL,'1','Add New Invoice','1'),
('2305','VR-23-2305','2023-08-10 00:00:00','0','1250.00','1','123.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-08-10 11:24:33','2023-08-10 11:24:33',NULL,'1','Add New Invoice','1'),
('2306','VR-23-2306','2023-08-10 00:00:00','0','1250.00','1','444.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-08-10 14:08:46','2023-08-22 04:31:04',NULL,'1','Update Invoice','1'),
('2307','VR-23-2307','2023-08-10 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-08-10 14:11:15','2023-08-10 14:11:15',NULL,'1','Add New Invoice','1'),
('2308','VR-23-2308','2023-08-10 00:00:00','0','1250.00','1','416.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-10 14:16:44','2023-08-10 14:16:44',NULL,'1','Add New Invoice','1'),
('2309','VR-23-2309','2023-08-10 00:00:00','0','1250.00','1','138.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-10 14:18:09','2023-08-10 14:18:09',NULL,'1','Add New Invoice','1'),
('2310','VR-23-2310','2023-08-10 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-08-10 14:20:18','2023-08-10 14:20:18',NULL,'1','Add New Invoice','1'),
('2311','VR-23-2311','2023-08-10 00:00:00','0','1250.00','1','438.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-10 14:26:39','2023-08-10 14:26:39',NULL,'1','Add New Invoice','1'),
('2312','VR-23-2312','2023-08-10 00:00:00','0','1250.00','1','362.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-08-10 15:32:52','2023-08-10 15:32:52',NULL,'1','Add New Invoice','1'),
('2313','VR-23-2313','2023-08-10 00:00:00','0','1250.00','1','151.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-10 16:07:45','2023-08-10 16:07:45',NULL,'1','Add New Invoice','1'),
('2314','VR-23-2314','2023-08-10 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-10 16:10:39','2023-08-10 16:10:39',NULL,'1','Add New Invoice','1'),
('2315','VR-23-2315','2023-08-10 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-08-10 16:12:44','2023-08-10 16:12:44',NULL,'1','Add New Invoice','1'),
('2316','VR-23-2316','2023-08-14 00:00:00','0','1250.00','1','54.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-08-14 11:33:10','2023-08-14 11:33:10',NULL,'1','Add New Invoice','1'),
('2317','VR-23-2317','2023-08-14 00:00:00','0','1250.00','1','221.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-14 11:38:30','2023-08-14 11:38:30',NULL,'1','Add New Invoice','1'),
('2318','VR-23-2318','2023-08-14 00:00:00','0','1250.00','1','393.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-14 14:35:27','2023-08-15 05:30:40',NULL,'1','Update Invoice','1'),
('2319','VR-23-2319','2023-08-14 00:00:00','0','1250.00','1','449.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-14 14:40:49','2023-08-14 14:40:49',NULL,'1','Add New Invoice','1'),
('2320','VR-23-2320','2023-08-14 00:00:00','0','1250.00','1','182.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-14 14:53:50','2023-08-14 14:53:50',NULL,'1','Add New Invoice','1'),
('2321','VR-23-2321','2023-08-14 00:00:00','0','1250.00','1','156.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-08-14 14:56:40','2023-08-14 14:56:40',NULL,'1','Add New Invoice','1'),
('2322','VR-23-2322','2023-08-14 00:00:00','0','1250.00','1','270.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-14 14:59:06','2023-08-14 14:59:06',NULL,'1','Add New Invoice','1'),
('2323','VR-23-2323','2023-08-14 00:00:00','0','1250.00','1','161.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-14 15:02:11','2023-08-14 15:02:11',NULL,'1','Add New Invoice','1'),
('2324','VR-23-2324','2023-08-14 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-08-14 15:37:57','2023-08-14 15:37:57',NULL,'1','Add New Invoice','1'),
('2325','VR-23-2325','2023-08-14 00:00:00','0','1250.00','1','607.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-08-14 15:50:00','2023-08-14 15:50:00',NULL,'1','Add New Invoice','1'),
('2326','VR-23-2326','2023-08-14 00:00:00','0','1250.00','1','104.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-08-14 15:51:28','2023-08-14 15:51:28',NULL,'1','Add New Invoice','1'),
('2327','VR-23-2327','2023-08-14 00:00:00','0','1250.00','1','1379.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-14 16:06:09','2023-08-14 04:06:48',NULL,'1','Update Invoice','1'),
('2328','VR-23-2328','2023-08-14 00:00:00','0','1250.00','1','202.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-08-14 16:08:43','2023-08-14 16:08:43',NULL,'1','Add New Invoice','1'),
('2329','VR-23-2329','2023-08-14 00:00:00','0','1250.00','1','86.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-14 16:11:21','2023-08-14 16:11:21',NULL,'1','Add New Invoice','1'),
('2330','VR-23-2330','2023-08-14 00:00:00','0','1250.00','1','359.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-14 16:16:44','2023-08-14 16:16:44',NULL,'1','Add New Invoice','1'),
('2331','VR-23-2331','2023-08-14 00:00:00','0','1250.00','1','440.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-14 16:19:13','2023-08-14 16:19:13',NULL,'1','Add New Invoice','1'),
('2332','VR-23-2332','2023-08-14 00:00:00','0','1250.00','1','184.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-08-14 16:33:54','2023-08-14 16:33:54',NULL,'1','Add New Invoice','1'),
('2333','VR-23-2333','2023-08-14 00:00:00','0','1250.00','1','182.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-08-14 16:52:48','2023-08-14 16:52:48',NULL,'1','Add New Invoice','1'),
('2334','VR-23-2334','2023-08-14 00:00:00','0','1250.00','1','619.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-14 16:56:18','2023-08-19 12:27:13',NULL,'1','Update Invoice','1'),
('2335','VR-23-2335','2023-08-14 00:00:00','0','1250.00','1','1874.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-08-14 17:02:48','2023-08-14 17:02:48',NULL,'1','Add New Invoice','1'),
('2336','VR-23-2336','2023-08-15 00:00:00','0','1250.00','1','62.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-08-15 12:20:16','2023-08-15 12:20:16',NULL,'1','Add New Invoice','1'),
('2337','VR-23-2337','2023-08-15 00:00:00','0','1250.00','1','211.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-15 14:43:33','2023-08-15 14:43:33',NULL,'1','Add New Invoice','1'),
('2338','VR-23-2338','2023-08-16 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-16 16:38:26','2023-08-16 16:38:26',NULL,'1','Add New Invoice','1'),
('2339','VR-23-2339','2023-08-17 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-08-17 11:03:22','2023-08-17 11:03:22',NULL,'1','Add New Invoice','1'),
('2340','VR-23-2340','2023-08-17 00:00:00','0','1250.00','1','225.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-17 11:11:04','2023-08-21 10:18:12',NULL,'1','Update Invoice','1'),
('2341','VR-23-2341','2023-08-17 00:00:00','0','1250.00','1','2500.51','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-08-17 14:24:32','2023-08-17 14:24:32',NULL,'1','Add New Invoice','1'),
('2342','VR-23-2342','2023-08-17 00:00:00','0','1250.00','1','4834.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-17 15:14:25','2023-08-17 15:14:25',NULL,'1','Add New Invoice','1'),
('2343','VR-23-2343','2023-08-17 00:00:00','0','1250.00','1','7550.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-08-17 15:24:12','2023-08-30 09:08:39',NULL,'1','Update Invoice','1'),
('2344','VR-23-2344','2023-08-17 00:00:00','0','1250.00','1','38.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-08-17 16:11:28','2023-08-17 05:20:49',NULL,'1','Update Invoice','1'),
('2345','VR-23-2345','2023-08-17 00:00:00','0','1250.00','1','487.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-08-17 16:13:48','2023-08-17 16:13:48',NULL,'1','Add New Invoice','1'),
('2346','VR-23-2346','2023-08-17 00:00:00','0','1250.00','1','141.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-08-17 16:28:01','2023-08-17 16:28:01',NULL,'1','Add New Invoice','1'),
('2347','VR-23-2347','2023-08-17 00:00:00','0','1250.00','1','146.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-17 16:31:33','2023-08-17 16:31:33',NULL,'1','Add New Invoice','1'),
('2348','VR-23-2348','2023-08-17 00:00:00','0','1250.00','1','352.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-17 16:34:08','2023-08-17 16:34:08',NULL,'1','Add New Invoice','1'),
('2349','VR-23-2349','2023-08-17 00:00:00','0','1250.00','1','724.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-08-17 16:35:53','2023-08-17 16:35:53',NULL,'1','Add New Invoice','1'),
('2350','VR-23-2350','2023-08-17 00:00:00','0','1250.00','1','179.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-08-17 16:44:53','2023-08-22 04:28:05',NULL,'1','Update Invoice','1'),
('2351','VR-23-2351','2023-08-17 00:00:00','0','1250.00','1','232.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-17 16:50:27','2023-08-17 16:50:27',NULL,'1','Add New Invoice','1'),
('2352','VR-23-2352','2023-08-17 00:00:00','0','1250.00','1','138.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-08-17 16:53:33','2023-08-17 16:53:33',NULL,'1','Add New Invoice','1'),
('2353','VR-23-2353','2023-08-17 00:00:00','0','1250.00','1','158.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-08-17 17:00:17','2023-08-17 17:00:17',NULL,'1','Add New Invoice','1'),
('2354','VR-23-2354','2023-08-17 00:00:00','0','1250.00','1','128.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-17 17:03:40','2023-08-17 17:03:40',NULL,'1','Add New Invoice','1'),
('2355','VR-23-2355','2023-08-17 00:00:00','0','1250.00','1','42.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-08-17 17:04:31','2023-08-17 17:04:31',NULL,'1','Add New Invoice','1'),
('2356','INV-23-2356','2023-08-19 00:00:00','0','1250.00','1','99.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-19 05:27:03','2023-08-19 05:27:03',NULL,'1','Add New Invoice','1'),
('2357','VR-23-2357','2023-08-20 00:00:00','0','1250.00','1','593.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-08-20 11:48:15','2023-08-20 11:48:15',NULL,'1','Add New Invoice','1'),
('2358','VR-23-2358','2023-08-20 00:00:00','0','1250.00','1','132.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','112','0','2023-08-20 11:51:52','2023-08-20 11:51:52',NULL,'1','Add New Invoice','1'),
('2359','VR-23-2359','2023-08-20 00:00:00','0','1250.00','1','1147.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-08-20 12:46:32','2023-08-20 12:46:32',NULL,'1','Add New Invoice','1'),
('2360','VR-23-2360','2023-08-21 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-21 16:20:45','2023-08-21 04:46:50',NULL,'1','Update Invoice','1'),
('2361','VR-23-2361','2023-08-21 00:00:00','0','1250.00','1','54.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-21 16:22:28','2023-08-21 16:22:28',NULL,'1','Add New Invoice','1'),
('2362','VR-23-2362','2023-08-21 00:00:00','0','1250.00','1','167.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-21 16:45:30','2023-08-21 16:45:30',NULL,'1','Add New Invoice','1'),
('2363','VR-23-2363','2023-08-21 00:00:00','0','1250.00','1','570.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-21 16:50:26','2023-08-23 11:45:26',NULL,'1','Update Invoice','1'),
('2364','VR-23-2364','2023-08-21 00:00:00','0','1250.00','1','97.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-21 16:53:42','2023-08-21 16:53:42',NULL,'1','Add New Invoice','1'),
('2365','VR-23-2365','2023-08-21 00:00:00','0','1250.00','1','244.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-21 17:12:48','2023-08-21 17:12:48',NULL,'1','Add New Invoice','1'),
('2366','VR-23-2366','2023-08-21 00:00:00','0','1250.00','1','126.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-08-21 17:16:14','2023-08-21 17:16:14',NULL,'1','Add New Invoice','1'),
('2367','VR-23-2367','2023-08-21 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-08-21 17:19:47','2023-08-21 17:19:47',NULL,'1','Add New Invoice','1'),
('2368','INV-23-2368','2023-08-22 00:00:00','0','1250.00','1','138.48','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-22 09:53:54','2023-08-22 09:53:54',NULL,'1','Add New Invoice','1'),
('2369','VR-23-2369','2023-08-23 00:00:00','0','1250.00','1','397.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-08-23 09:55:49','2023-08-23 09:55:49',NULL,'1','Add New Invoice','1'),
('2370','VR-23-2370','2023-08-23 00:00:00','0','1250.00','1','496.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-08-23 10:06:14','2023-08-23 10:19:41',NULL,'1','Update Invoice','1'),
('2371','VR-23-2371','2023-08-23 00:00:00','0','1250.00','1','294.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-08-23 10:11:19','2023-08-23 03:39:38',NULL,'1','Update Invoice','1'),
('2372','VR-23-2372','2023-08-23 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-23 10:16:00','2023-08-23 10:16:00',NULL,'1','Add New Invoice','1'),
('2373','VR-23-2373','2023-08-23 00:00:00','0','1250.00','1','678.16','0.00','علي نجف','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-23 11:03:18','2023-08-23 11:03:51',NULL,'1','Update Invoice','1'),
('2374','VR-23-2374','2023-08-23 00:00:00','0','1250.00','1','950.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-23 11:05:50','2023-08-23 11:05:50',NULL,'1','Add New Invoice','1'),
('2375','VR-23-2375','2023-08-23 00:00:00','0','1250.00','1','320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-08-23 11:09:08','2023-08-23 11:55:20',NULL,'1','Update Invoice','1'),
('2376','VR-23-2376','2023-08-23 00:00:00','0','1250.00','1','45.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-08-23 11:10:35','2023-08-23 11:10:35',NULL,'1','Add New Invoice','1'),
('2377','VR-23-2377','2023-08-23 00:00:00','0','1250.00','1','181.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-23 11:17:40','2023-08-23 04:09:11',NULL,'1','Update Invoice','1'),
('2378','VR-23-2378','2023-08-23 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-08-23 11:36:51','2023-08-23 11:41:41',NULL,'1','Update Invoice','1'),
('2379','VR-23-2379','2023-08-23 00:00:00','0','1250.00','1','660.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-08-23 11:52:16','2023-08-23 11:52:16',NULL,'1','Add New Invoice','1'),
('2380','VR-23-2380','2023-08-23 00:00:00','0','1250.00','1','109.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-23 15:15:49','2024-08-05 04:35:49',NULL,'1','Update Invoice','1'),
('2381','VR-23-2381','2023-08-23 00:00:00','0','1250.00','1','204.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','109','0','2023-08-23 15:20:18','2023-08-23 15:20:18',NULL,'1','Add New Invoice','1'),
('2382','VR-23-2382','2023-08-23 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-23 15:48:35','2023-08-23 15:48:35',NULL,'1','Add New Invoice','1'),
('2383','VR-23-2383','2023-08-23 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-23 15:52:24','2023-08-23 15:52:24',NULL,'1','Add New Invoice','1'),
('2385','VR-23-2384','2023-08-24 00:00:00','0','1250.00','1','7901.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-08-24 14:48:50','2023-08-24 14:48:50',NULL,'1','Add New Invoice','1'),
('2386','VR-23-2386','2023-08-24 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-24 15:16:48','2023-08-24 15:16:48',NULL,'1','Add New Invoice','1'),
('2387','VR-23-2387','2023-08-24 00:00:00','0','1250.00','1','90.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-08-24 15:18:12','2023-08-24 15:18:12',NULL,'1','Add New Invoice','1'),
('2388','VR-23-2388','2023-08-24 00:00:00','0','1250.00','1','185.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-08-24 15:19:56','2023-08-24 15:19:56',NULL,'1','Add New Invoice','1'),
('2389','VR-23-2389','2023-08-24 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-08-24 15:27:08','2023-08-24 15:27:08',NULL,'1','Add New Invoice','1'),
('2390','VR-23-2390','2023-08-24 00:00:00','0','1250.00','1','52.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-24 15:40:38','2023-08-24 15:40:38',NULL,'1','Add New Invoice','1'),
('2391','VR-23-2391','2023-08-24 00:00:00','0','1250.00','1','416.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-24 15:46:31','2023-08-24 15:46:31',NULL,'1','Add New Invoice','1'),
('2392','VR-23-2392','2023-08-24 00:00:00','0','1250.00','1','128.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-08-24 15:54:00','2023-08-24 15:54:00',NULL,'1','Add New Invoice','1'),
('2393','VR-23-2393','2023-08-24 00:00:00','0','1250.00','1','104.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-24 16:35:04','2023-08-24 16:35:04',NULL,'1','Add New Invoice','1'),
('2394','VR-23-2394','2023-08-24 00:00:00','0','1250.00','1','479.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-24 16:37:06','2023-08-24 16:37:06',NULL,'1','Add New Invoice','1'),
('2395','VR-23-2395','2023-08-24 00:00:00','0','1250.00','1','162.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-24 16:38:30','2023-08-24 16:38:30',NULL,'1','Add New Invoice','1'),
('2396','INV-23-2396','2023-08-24 00:00:00','0','1250.00','1','99.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-08-24 05:06:36','2023-08-24 05:06:36',NULL,'1','Add New Invoice','1'),
('2397','VR-23-2397','2023-08-26 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-08-26 10:35:55','2023-08-26 10:35:55',NULL,'1','Add New Invoice','1'),
('2398','VR-23-2398','2023-08-26 00:00:00','0','1250.00','1','826.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-08-26 14:32:12','2023-08-26 14:32:12',NULL,'1','Add New Invoice','1'),
('2399','VR-23-2399','2023-08-27 00:00:00','0','1250.00','1','29.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-08-27 10:15:12','2023-08-27 10:15:12',NULL,'1','Add New Invoice','1'),
('2400','VR-23-2400','2023-08-27 00:00:00','0','1250.00','1','414.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-27 10:22:19','2023-08-27 10:22:19',NULL,'1','Add New Invoice','1'),
('2401','VR-23-2401','2023-08-27 00:00:00','0','1250.00','1','192.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-08-27 10:24:48','2023-08-27 10:24:48',NULL,'1','Add New Invoice','1'),
('2402','VR-23-2402','2023-08-27 00:00:00','0','1250.00','1','115.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-08-27 10:28:39','2023-08-27 10:28:39',NULL,'1','Add New Invoice','1'),
('2403','INV-23-2403','2023-08-27 00:00:00','0','1250.00','1','60.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-27 10:45:18','2023-08-27 10:45:18',NULL,'1','Add New Invoice','1'),
('2404','VR-23-2404','2023-08-27 00:00:00','0','1250.00','1','187.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-08-27 11:43:02','2023-08-28 04:50:54',NULL,'1','Update Invoice','1'),
('2405','VR-23-2405','2023-08-27 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-08-27 11:45:37','2023-08-27 11:45:37',NULL,'1','Add New Invoice','1'),
('2406','VR-23-2406','2023-08-27 00:00:00','0','1250.00','1','105.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-27 11:51:48','2023-08-27 11:51:48',NULL,'1','Add New Invoice','1'),
('2407','VR-23-2407','2023-08-27 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-08-27 12:12:22','2023-08-27 12:12:22',NULL,'1','Add New Invoice','1'),
('2408','VR-23-2408','2023-08-28 00:00:00','0','1250.00','1','224.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-08-28 10:20:16','2023-08-28 10:20:16',NULL,'1','Add New Invoice','1'),
('2409','VR-23-2409','2023-08-28 00:00:00','0','1250.00','1','298.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-28 15:41:24','2023-08-28 15:41:24',NULL,'1','Add New Invoice','1'),
('2410','VR-23-2410','2023-08-28 00:00:00','0','1250.00','1','226.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-08-28 15:45:55','2023-08-28 15:45:55',NULL,'1','Add New Invoice','1'),
('2411','VR-23-2411','2023-08-28 00:00:00','0','1250.00','1','248.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-28 15:58:45','2023-08-28 15:58:45',NULL,'1','Add New Invoice','1'),
('2412','VR-23-2412','2023-08-28 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-08-28 16:04:32','2023-08-28 16:04:32',NULL,'1','Add New Invoice','1'),
('2413','VR-23-2413','2023-08-28 00:00:00','0','1250.00','1','58.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-08-28 16:10:31','2023-08-28 04:46:02',NULL,'1','Update Invoice','1'),
('2414','VR-23-2414','2023-08-28 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-08-28 16:16:47','2023-08-28 16:16:47',NULL,'1','Add New Invoice','1'),
('2415','VR-23-2415','2023-08-28 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-28 17:14:44','2023-08-28 17:14:44',NULL,'1','Add New Invoice','1'),
('2416','VR-23-2416','2023-08-28 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-08-28 17:15:53','2023-08-28 17:15:53',NULL,'1','Add New Invoice','1'),
('2417','VR-23-2417','2023-08-28 00:00:00','0','1250.00','1','290.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-08-28 17:17:09','2023-08-28 17:17:09',NULL,'1','Add New Invoice','1'),
('2418','VR-23-2418','2023-08-29 00:00:00','0','1250.00','1','2632.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-08-29 15:22:46','2023-08-29 15:22:46',NULL,'1','Add New Invoice','1'),
('2419','VR-23-2419','2023-08-30 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-08-30 16:47:29','2023-08-30 16:47:29',NULL,'1','Add New Invoice','1'),
('2420','VR-23-2420','2023-08-30 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-08-30 16:54:22','2023-08-30 16:54:22',NULL,'1','Add New Invoice','1'),
('2421','VR-23-2421','2023-08-30 00:00:00','0','1250.00','1','252.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-08-30 17:00:04','2023-08-30 17:00:04',NULL,'1','Add New Invoice','1'),
('2422','VR-23-2422','2023-08-30 00:00:00','0','1250.00','1','1022.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-08-30 17:12:48','2024-08-05 04:36:50',NULL,'1','Update Invoice','1'),
('2423','VR-23-2423','2023-08-30 00:00:00','0','1250.00','1','229.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-08-30 17:22:07','2023-08-30 17:22:07',NULL,'1','Add New Invoice','1'),
('2424','VR-23-2424','2023-08-31 00:00:00','0','1250.00','1','172.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-08-31 15:34:29','2023-08-31 03:43:19',NULL,'1','Update Invoice','1'),
('2425','VR-23-2425','2023-09-02 00:00:00','0','1250.00','1','60.00','0.00','عرض','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-09-02 11:12:52','2023-09-02 11:14:33',NULL,'1','Update Invoice','1'),
('2426','VR-23-2426','2023-09-02 00:00:00','0','1250.00','1','94.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-09-02 11:33:54','2023-09-02 11:33:54',NULL,'1','Add New Invoice','1'),
('2427','VR-23-2427','2023-09-02 00:00:00','0','1250.00','1','24.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-09-02 16:49:55','2023-09-02 16:49:55',NULL,'1','Add New Invoice','1'),
('2428','VR-23-2428','2023-09-02 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-09-02 16:54:42','2023-09-02 16:54:42',NULL,'1','Add New Invoice','1'),
('2429','VR-23-2429','2023-09-02 00:00:00','0','1250.00','1','237.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-09-02 16:57:25','2023-09-02 16:57:25',NULL,'1','Add New Invoice','1'),
('2430','VR-23-2430','2023-09-02 00:00:00','0','1250.00','1','85.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-09-02 16:59:05','2023-09-02 16:59:05',NULL,'1','Add New Invoice','1'),
('2431','VR-23-2431','2023-09-02 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-09-02 17:01:31','2023-09-02 17:01:31',NULL,'1','Add New Invoice','1'),
('2432','VR-23-2432','2023-09-02 00:00:00','0','1250.00','1','426.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-09-02 17:03:04','2023-09-02 17:03:04',NULL,'1','Add New Invoice','1'),
('2433','VR-23-2433','2023-09-02 00:00:00','0','1250.00','1','79.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-09-02 17:21:11','2023-09-02 17:21:11',NULL,'1','Add New Invoice','1'),
('2434','VR-23-2434','2023-09-03 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-03 09:32:45','2023-09-03 09:32:45',NULL,'1','Add New Invoice','1'),
('2435','VR-23-2435','2023-09-03 00:00:00','0','1250.00','1','717.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-09-03 09:45:24','2023-09-03 09:47:16',NULL,'1','Update Invoice','1'),
('2436','INV-23-2436','2023-09-03 00:00:00','0','1250.00','1','81.92','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-03 09:46:28','2023-09-03 09:46:28',NULL,'1','Add New Invoice','1'),
('2437','VR-23-2437','2023-09-03 00:00:00','0','1250.00','1','148.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-03 09:52:14','2023-09-03 09:52:14',NULL,'1','Add New Invoice','1'),
('2438','VR-23-2438','2023-09-03 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-03 09:58:18','2023-09-03 09:58:18',NULL,'1','Add New Invoice','1'),
('2439','VR-23-2439','2023-09-03 00:00:00','0','1250.00','1','228.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-09-03 10:06:25','2023-09-03 10:06:25',NULL,'1','Add New Invoice','1'),
('2440','VR-23-2440','2023-09-03 00:00:00','0','1250.00','1','74.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-09-03 10:10:56','2023-09-03 10:10:56',NULL,'1','Add New Invoice','1'),
('2441','VR-23-2441','2023-09-03 00:00:00','0','1250.00','1','38.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-03 10:25:10','2023-09-03 10:25:10',NULL,'1','Add New Invoice','1'),
('2442','VR-23-2442','2023-09-03 00:00:00','0','1250.00','1','592.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-09-03 15:42:17','2023-09-03 15:42:17',NULL,'1','Add New Invoice','1'),
('2443','VR-23-2443','2023-09-04 00:00:00','0','1250.00','1','49.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-04 16:32:31','2023-09-04 16:32:31',NULL,'1','Add New Invoice','1'),
('2444','VR-23-2444','2023-09-04 00:00:00','0','1250.00','1','1457.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-09-04 16:51:59','2023-09-04 16:51:59',NULL,'1','Add New Invoice','1'),
('2445','VR-23-2445','2023-09-05 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-09-05 09:59:35','2023-09-05 09:59:35',NULL,'1','Add New Invoice','1'),
('2446','VR-23-2446','2023-09-05 00:00:00','0','1250.00','1','229.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-05 10:03:29','2023-09-05 10:03:29',NULL,'1','Add New Invoice','1'),
('2447','VR-23-2447','2023-09-05 00:00:00','0','1250.00','1','71.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-09-05 10:32:56','2023-09-05 10:32:56',NULL,'1','Add New Invoice','1'),
('2448','VR-23-2448','2023-09-05 00:00:00','0','1250.00','1','147.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-05 10:38:24','2024-08-05 04:37:20',NULL,'1','Update Invoice','1'),
('2449','VR-23-2449','2023-09-05 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-05 10:46:05','2023-09-05 10:46:05',NULL,'1','Add New Invoice','1'),
('2450','VR-23-2450','2023-09-05 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-05 10:46:58','2023-09-05 10:46:58',NULL,'1','Add New Invoice','1'),
('2451','VR-23-2451','2023-09-05 00:00:00','0','1250.00','1','155.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-09-05 10:52:28','2023-09-05 10:52:28',NULL,'1','Add New Invoice','1'),
('2452','VR-23-2452','2023-09-05 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-05 13:26:42','2023-09-05 13:26:42',NULL,'1','Add New Invoice','1'),
('2453','VR-23-2453','2023-09-05 00:00:00','0','1250.00','1','120.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-09-05 15:42:57','2023-09-05 15:42:57',NULL,'1','Add New Invoice','1'),
('2454','VR-23-2454','2023-09-05 00:00:00','0','1250.00','1','434.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-09-05 15:55:06','2023-09-05 04:00:19',NULL,'1','Update Invoice','1'),
('2455','VR-23-2455','2023-09-05 00:00:00','0','1250.00','1','242.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-05 16:08:41','2023-09-05 16:08:41',NULL,'1','Add New Invoice','1'),
('2456','VR-23-2456','2023-09-05 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-05 16:09:56','2023-09-05 16:09:56',NULL,'1','Add New Invoice','1'),
('2457','VR-23-2457','2023-09-06 00:00:00','0','1250.00','1','417.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-06 10:18:07','2023-09-06 10:18:07',NULL,'1','Add New Invoice','1'),
('2458','VR-23-2458','2023-09-06 00:00:00','0','1250.00','1','347.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-09-06 10:22:17','2023-09-07 09:39:32',NULL,'1','Update Invoice','1'),
('2459','VR-23-2459','2023-09-06 00:00:00','0','1250.00','1','196.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-06 10:28:37','2023-09-06 10:28:37',NULL,'1','Add New Invoice','1'),
('2460','VR-23-2460','2023-09-06 00:00:00','0','1250.00','1','226.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-06 10:39:37','2023-09-06 10:39:37',NULL,'1','Add New Invoice','1'),
('2461','VR-23-2461','2023-09-06 00:00:00','0','1250.00','1','86.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-09-06 10:42:10','2023-09-06 10:42:10',NULL,'1','Add New Invoice','1'),
('2462','VR-23-2462','2023-09-06 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-09-06 11:13:11','2023-09-06 11:13:11',NULL,'1','Add New Invoice','1'),
('2463','VR-23-2463','2023-09-06 00:00:00','0','1250.00','1','182.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-09-06 15:38:15','2023-09-06 15:38:15',NULL,'1','Add New Invoice','1'),
('2464','VR-23-2464','2023-09-06 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-09-06 15:47:07','2023-09-06 15:47:07',NULL,'1','Add New Invoice','1'),
('2465','VR-23-2465','2023-09-06 00:00:00','0','1250.00','1','30.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-09-06 15:59:08','2023-09-06 15:59:08',NULL,'1','Add New Invoice','1'),
('2466','VR-23-2466','2023-09-06 00:00:00','0','1250.00','1','608.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-09-06 16:09:41','2023-09-06 16:09:41',NULL,'1','Add New Invoice','1'),
('2467','VR-23-2467','2023-09-06 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-06 16:25:27','2023-09-06 16:25:27',NULL,'1','Add New Invoice','1'),
('2468','VR-23-2468','2023-09-06 00:00:00','0','1250.00','1','898.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-06 16:30:30','2023-09-06 16:30:30',NULL,'1','Add New Invoice','1'),
('2469','VR-23-2469','2023-09-06 00:00:00','0','1250.00','1','1248.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-06 16:35:37','2023-09-06 04:37:31',NULL,'1','Update Invoice','1'),
('2470','VR-23-2470','2023-09-06 00:00:00','0','1250.00','1','362.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-06 16:43:09','2023-09-06 16:43:09',NULL,'1','Add New Invoice','1'),
('2471','VR-23-2471','2023-09-06 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-06 16:47:44','2023-09-06 16:47:44',NULL,'1','Add New Invoice','1'),
('2472','VR-23-2472','2023-09-06 00:00:00','0','1250.00','1','96.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-06 16:50:31','2023-09-06 16:50:31',NULL,'1','Add New Invoice','1'),
('2473','VR-23-2473','2023-09-06 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-09-06 16:51:30','2023-09-06 16:51:30',NULL,'1','Add New Invoice','1'),
('2474','VR-23-2474','2023-09-06 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-06 16:52:49','2023-09-06 16:52:49',NULL,'1','Add New Invoice','1'),
('2475','VR-23-2475','2023-09-07 00:00:00','0','1250.00','1','124.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-07 10:50:33','2023-09-07 10:50:33',NULL,'1','Add New Invoice','1'),
('2476','VR-23-2476','2023-09-07 00:00:00','0','1250.00','1','114.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-09-07 10:52:13','2023-09-07 10:52:13',NULL,'1','Add New Invoice','1'),
('2477','VR-23-2477','2023-09-07 00:00:00','0','1250.00','1','29.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-09-07 13:55:44','2023-09-07 13:55:44',NULL,'1','Add New Invoice','1'),
('2478','INV-23-2478','2023-09-09 00:00:00','0','1250.00','1','222.28','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-09 12:47:51','2023-09-09 12:47:51',NULL,'1','Add New Invoice','1'),
('2479','VR-23-2479','2023-09-09 00:00:00','0','1250.00','1','3259.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-09 15:06:56','2023-09-10 09:47:42',NULL,'1','Update Invoice','1'),
('2480','VR-23-2480','2023-09-09 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-09-09 15:49:48','2023-09-09 15:49:48',NULL,'1','Add New Invoice','1'),
('2481','VR-23-2481','2023-09-09 00:00:00','0','1250.00','1','311.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-09 15:54:58','2023-09-09 15:54:58',NULL,'1','Add New Invoice','1'),
('2482','VR-23-2482','2023-09-09 00:00:00','0','1250.00','1','550.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-09-09 16:06:05','2023-09-09 16:06:05',NULL,'1','Add New Invoice','1'),
('2483','VR-23-2483','2023-09-09 00:00:00','0','1250.00','1','261.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-09 16:17:39','2023-09-09 16:17:39',NULL,'1','Add New Invoice','1'),
('2484','VR-23-2484','2023-09-09 00:00:00','0','1250.00','1','51.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-09-09 16:29:59','2023-09-09 16:29:59',NULL,'1','Add New Invoice','1'),
('2485','VR-23-2485','2023-09-09 00:00:00','0','1250.00','1','32.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-09 16:36:18','2024-08-05 04:37:48',NULL,'1','Update Invoice','1'),
('2486','VR-23-2486','2023-09-09 00:00:00','0','1250.00','1','140.14','0.00','حيدر شبر حلة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-09-09 17:26:24','2023-09-09 17:26:24',NULL,'1','Add New Invoice','1'),
('2487','VR-23-2487','2023-09-10 00:00:00','0','1250.00','1','861.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-10 14:51:09','2023-09-11 03:54:14',NULL,'1','Update Invoice','1'),
('2488','VR-23-2488','2023-09-10 00:00:00','0','1250.00','1','135.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-10 14:54:25','2023-09-10 14:54:25',NULL,'1','Add New Invoice','1'),
('2489','VR-23-2489','2023-09-10 00:00:00','0','1250.00','1','152.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-09-10 14:57:20','2023-09-10 14:57:20',NULL,'1','Add New Invoice','1'),
('2490','VR-23-2490','2023-09-10 00:00:00','0','1250.00','1','24.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-10 14:58:24','2023-09-10 14:58:24',NULL,'1','Add New Invoice','1'),
('2491','VR-23-2491','2023-09-10 00:00:00','0','1250.00','1','171.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-10 15:19:43','2023-09-10 15:19:43',NULL,'1','Add New Invoice','1'),
('2492','VR-23-2492','2023-09-10 00:00:00','0','1250.00','1','102.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-09-10 15:32:23','2023-09-10 15:32:23',NULL,'1','Add New Invoice','1'),
('2493','VR-23-2493','2023-09-10 00:00:00','0','1250.00','1','105.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-09-10 15:34:57','2023-09-10 15:34:57',NULL,'1','Add New Invoice','1'),
('2494','VR-23-2494','2023-09-10 00:00:00','0','1250.00','1','390.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-09-10 15:51:25','2023-09-10 15:51:25',NULL,'1','Add New Invoice','1'),
('2495','VR-23-2495','2023-09-11 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-11 13:57:04','2023-09-11 13:57:04',NULL,'1','Add New Invoice','1'),
('2496','VR-23-2496','2023-09-11 00:00:00','0','1250.00','1','19.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-11 14:01:32','2023-09-11 14:01:32',NULL,'1','Add New Invoice','1'),
('2497','VR-23-2497','2023-09-11 00:00:00','0','1250.00','1','1056.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2023-09-11 14:23:34','2023-09-11 14:23:34','2023-12-04 02:10:17','1','Delete Invoice','1'),
('2498','VR-23-2498','2023-09-11 00:00:00','0','1250.00','1','1618.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-09-11 14:29:20','2023-09-11 14:29:20',NULL,'1','Add New Invoice','1'),
('2499','VR-23-2499','2023-09-11 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-11 14:40:50','2023-09-11 14:40:50',NULL,'1','Add New Invoice','1'),
('2500','VR-23-2500','2023-09-11 00:00:00','0','1250.00','1','807.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-11 15:53:11','2023-09-11 15:53:11',NULL,'1','Add New Invoice','1'),
('2501','VR-23-2501','2023-09-11 00:00:00','0','1250.00','1','101.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-11 15:56:04','2023-09-11 04:22:15',NULL,'1','Update Invoice','1'),
('2502','VR-23-2502','2023-09-11 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-11 15:57:55','2023-09-11 15:57:55',NULL,'1','Add New Invoice','1'),
('2503','VR-23-2503','2023-09-11 00:00:00','0','1250.00','1','36.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-09-11 16:00:44','2023-09-11 16:00:44',NULL,'1','Add New Invoice','1'),
('2504','VR-23-2504','2023-09-11 00:00:00','0','1250.00','1','27.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-11 16:01:49','2023-09-11 16:01:49',NULL,'1','Add New Invoice','1'),
('2505','VR-23-2505','2023-09-11 00:00:00','0','1250.00','1','338.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2023-09-11 16:19:35','2023-09-11 16:19:35','2023-12-04 11:10:59','1','Delete Invoice','1'),
('2506','VR-23-2506','2023-09-11 00:00:00','0','1250.00','1','134.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2023-09-11 16:28:40','2023-09-11 16:28:40','2023-10-02 02:02:47','1','Delete Invoice','1'),
('2507','VR-23-2507','2023-09-12 00:00:00','0','1250.00','1','4020.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','93','0','2023-09-12 11:33:40','2023-09-12 11:33:40',NULL,'1','Add New Invoice','1'),
('2508','VR-23-2508','2023-09-12 00:00:00','0','1250.00','1','121.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-12 15:03:45','2023-09-14 12:59:36',NULL,'1','Update Invoice','1'),
('2509','VR-23-2509','2023-09-12 00:00:00','0','1250.00','1','20.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-12 15:20:12','2023-09-12 15:20:12',NULL,'1','Add New Invoice','1'),
('2510','VR-23-2510','2023-09-12 00:00:00','0','1250.00','1','136.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-09-12 15:54:39','2023-09-12 15:54:39',NULL,'1','Add New Invoice','1'),
('2511','VR-23-2511','2023-09-12 00:00:00','0','1250.00','1','119.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-09-12 16:00:27','2023-09-12 16:00:27',NULL,'1','Add New Invoice','1'),
('2512','VR-23-2512','2023-09-12 00:00:00','0','1250.00','1','529.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-09-12 16:08:50','2023-09-12 16:08:50',NULL,'1','Add New Invoice','1'),
('2513','VR-23-2513','2023-09-12 00:00:00','0','1250.00','1','115.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-12 16:14:00','2023-09-12 16:14:00',NULL,'1','Add New Invoice','1'),
('2514','VR-23-2514','2023-09-12 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-12 16:14:43','2023-09-12 16:14:43',NULL,'1','Add New Invoice','1'),
('2515','INV-23-2515','2023-09-12 00:00:00','0','1250.00','1','472.82','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-09-12 05:08:50','2023-09-12 05:08:50',NULL,'1','Add New Invoice','1'),
('2516','VR-23-2516','2023-09-13 00:00:00','0','1250.00','1','392.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-09-13 11:50:13','2023-09-13 11:50:13',NULL,'1','Add New Invoice','1'),
('2517','VR-23-2517','2023-09-13 00:00:00','0','1250.00','1','221.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','1','2023-09-13 16:21:00','2023-09-13 16:21:00','2023-11-01 12:57:55','1','Delete Invoice','1'),
('2518','VR-23-2518','2023-09-13 00:00:00','0','1250.00','1','263.57','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-13 16:22:34','2023-09-13 16:22:34',NULL,'1','Add New Invoice','1'),
('2519','VR-23-2519','2023-09-13 00:00:00','0','1250.00','1','1412.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-09-13 16:28:40','2023-09-16 09:43:28',NULL,'1','Update Invoice','1'),
('2520','VR-23-2520','2023-09-13 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-09-13 16:37:04','2023-09-13 16:37:04',NULL,'1','Add New Invoice','1'),
('2521','VR-23-2521','2023-09-13 00:00:00','0','1250.00','1','105.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2023-09-13 16:38:00','2023-09-13 16:38:00',NULL,'1','Add New Invoice','1'),
('2522','VR-23-2522','2023-09-13 00:00:00','0','1250.00','1','84.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-09-13 16:52:35','2023-09-13 16:52:35',NULL,'1','Add New Invoice','1'),
('2523','VR-23-2523','2023-09-13 00:00:00','0','1250.00','1','420.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-09-13 16:56:01','2023-09-13 16:56:01',NULL,'1','Add New Invoice','1'),
('2524','VR-23-2524','2023-09-13 00:00:00','0','1250.00','1','109.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-13 16:58:34','2023-09-13 16:58:34',NULL,'1','Add New Invoice','1'),
('2525','VR-23-2525','2023-09-13 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-09-13 17:00:17','2023-09-17 05:12:51',NULL,'1','Update Invoice','1'),
('2526','VR-23-2526','2023-09-13 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-09-13 17:03:00','2023-09-16 10:16:38',NULL,'1','Update Invoice','1'),
('2527','VR-23-2527','2023-09-13 00:00:00','0','1250.00','1','43.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-13 17:06:42','2023-09-13 17:06:42',NULL,'1','Add New Invoice','1'),
('2528','VR-23-2528','2023-09-13 00:00:00','0','1250.00','1','387.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-09-13 17:11:19','2023-09-14 09:33:25',NULL,'1','Update Invoice','1'),
('2529','VR-23-2529','2023-09-14 00:00:00','0','1250.00','1','41.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-14 13:13:38','2023-09-14 13:13:38',NULL,'1','Add New Invoice','1'),
('2530','VR-23-2530','2023-09-14 00:00:00','0','1250.00','1','57.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-14 13:23:14','2023-09-14 13:23:14',NULL,'1','Add New Invoice','1'),
('2531','INV-23-2531','2023-09-16 00:00:00','0','1250.00','1','82.67','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-16 11:07:21','2023-09-16 11:07:21',NULL,'1','Add New Invoice','1'),
('2532','VR-23-2532','2023-09-16 00:00:00','0','1250.00','1','130.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2023-09-16 16:42:36','2023-09-16 16:42:36','2023-09-17 03:03:27','1','Delete Invoice','1'),
('2533','VR-23-2533','2023-09-16 00:00:00','0','1250.00','1','44.50','0.00','عرض','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-16 16:47:12','2023-09-16 16:47:12',NULL,'1','Add New Invoice','1'),
('2534','VR-23-2534','2023-09-16 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-09-16 16:53:08','2023-09-16 16:53:08',NULL,'1','Add New Invoice','1'),
('2535','VR-23-2535','2023-09-16 00:00:00','0','1250.00','1','519.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-09-16 17:02:47','2023-09-16 17:02:47',NULL,'1','Add New Invoice','1'),
('2536','VR-23-2536','2023-09-17 00:00:00','0','1250.00','1','258.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-17 10:02:15','2023-09-17 10:02:15',NULL,'1','Add New Invoice','1'),
('2537','VR-23-2537','2023-09-17 00:00:00','0','1250.00','1','4606.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-09-17 14:55:15','2023-09-17 05:10:24',NULL,'1','Update Invoice','1'),
('2538','VR-23-2538','2023-09-17 00:00:00','0','1250.00','1','661.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-17 15:12:37','2023-09-20 03:06:52',NULL,'1','Update Invoice','1'),
('2539','VR-23-2539','2023-09-17 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-09-17 16:52:43','2023-09-17 16:52:43',NULL,'1','Add New Invoice','1'),
('2540','VR-23-2540','2023-09-17 00:00:00','0','1250.00','1','89.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-09-17 16:55:43','2023-09-17 16:55:43',NULL,'1','Add New Invoice','1'),
('2541','VR-23-2541','2023-09-17 00:00:00','0','1250.00','1','285.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-09-17 16:59:57','2023-09-17 16:59:57',NULL,'1','Add New Invoice','1'),
('2542','VR-23-2542','2023-09-17 00:00:00','0','1250.00','1','299.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-17 17:06:15','2023-09-17 17:06:15',NULL,'1','Add New Invoice','1'),
('2543','VR-23-2543','2023-09-18 00:00:00','0','1250.00','1','6092.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-18 10:23:41','2023-09-18 10:23:41',NULL,'1','Add New Invoice','1'),
('2544','INV-23-2544','2023-09-18 00:00:00','0','1250.00','1','67.76','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-09-18 11:20:59','2023-09-18 11:20:59',NULL,'1','Add New Invoice','1'),
('2545','VR-23-2545','2023-09-19 00:00:00','0','1250.00','1','568.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-19 10:18:52','2023-09-19 01:06:47',NULL,'1','Update Invoice','1'),
('2546','VR-23-2546','2023-09-19 00:00:00','0','1250.00','1','482.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-09-19 10:25:00','2023-09-19 10:25:00',NULL,'1','Add New Invoice','1'),
('2547','VR-23-2547','2023-09-19 00:00:00','0','1250.00','1','170.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-09-19 10:28:59','2023-09-28 04:19:52',NULL,'1','Update Invoice','1'),
('2548','VR-23-2548','2023-09-19 00:00:00','0','1250.00','1','204.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-19 10:34:35','2023-09-19 12:05:05',NULL,'1','Update Invoice','1'),
('2549','VR-23-2549','2023-09-19 00:00:00','0','1250.00','1','25.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-19 10:44:27','2023-09-19 10:44:27',NULL,'1','Add New Invoice','1'),
('2550','VR-23-2550','2023-09-19 00:00:00','0','1250.00','1','419.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-19 10:54:16','2023-09-19 10:54:16',NULL,'1','Add New Invoice','1'),
('2551','VR-23-2551','2023-09-19 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-09-19 10:58:11','2023-09-19 10:58:11',NULL,'1','Add New Invoice','1'),
('2552','VR-23-2552','2023-09-19 00:00:00','0','1250.00','1','306.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-19 11:09:06','2023-09-19 03:31:21',NULL,'1','Update Invoice','1'),
('2553','VR-23-2553','2023-09-19 00:00:00','0','1250.00','1','252.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-19 11:24:47','2023-09-19 11:30:24',NULL,'1','Update Invoice','1'),
('2554','VR-23-2554','2023-09-19 00:00:00','0','1250.00','1','164.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-09-19 11:57:16','2023-09-19 11:58:01',NULL,'1','Update Invoice','1'),
('2555','VR-23-2555','2023-09-19 00:00:00','0','1250.00','1','24.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-19 12:18:58','2023-09-19 12:18:58',NULL,'1','Add New Invoice','1'),
('2556','VR-23-2556','2023-09-19 00:00:00','0','1250.00','1','9.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-09-19 12:19:57','2023-09-19 12:19:57',NULL,'1','Add New Invoice','1'),
('2557','VR-23-2557','2023-09-19 00:00:00','0','1250.00','1','503.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-09-19 12:25:09','2023-09-19 12:25:09',NULL,'1','Add New Invoice','1'),
('2558','VR-23-2558','2023-09-19 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-09-19 12:26:29','2023-09-19 12:26:29',NULL,'1','Add New Invoice','1'),
('2559','VR-23-2559','2023-09-19 00:00:00','0','1250.00','1','198.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-09-19 12:29:29','2023-09-19 12:29:29',NULL,'1','Add New Invoice','1'),
('2560','VR-23-2560','2023-09-19 00:00:00','0','1250.00','1','457.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-09-19 12:34:36','2023-09-20 03:10:55',NULL,'1','Update Invoice','1'),
('2561','VR-23-2561','2023-09-19 00:00:00','0','1250.00','1','40.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-09-19 12:38:47','2023-09-19 12:38:47',NULL,'1','Add New Invoice','1'),
('2562','VR-23-2562','2023-09-19 00:00:00','0','1250.00','1','94.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-19 14:23:17','2023-09-19 14:23:17',NULL,'1','Add New Invoice','1'),
('2563','VR-23-2563','2023-09-19 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-19 15:36:15','2023-09-19 15:36:15',NULL,'1','Add New Invoice','1'),
('2564','VR-23-2564','2023-09-20 00:00:00','0','1250.00','1','273.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-09-20 15:38:01','2023-09-20 15:38:01',NULL,'1','Add New Invoice','1'),
('2565','VR-23-2565','2023-09-20 00:00:00','0','1250.00','1','213.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-20 15:39:49','2024-08-05 04:38:26',NULL,'1','Update Invoice','1'),
('2566','VR-23-2566','2023-09-20 00:00:00','0','1250.00','1','46.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-20 15:50:53','2023-09-20 15:50:53',NULL,'1','Add New Invoice','1'),
('2567','VR-23-2567','2023-09-20 00:00:00','0','1250.00','1','75.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-09-20 16:00:22','2023-09-20 16:00:22',NULL,'1','Add New Invoice','1'),
('2568','VR-23-2568','2023-09-20 00:00:00','0','1250.00','1','52.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-09-20 16:03:14','2023-09-20 16:03:14',NULL,'1','Add New Invoice','1'),
('2569','VR-23-2569','2023-09-20 00:00:00','0','1250.00','1','91.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-20 16:04:26','2023-09-20 16:04:26',NULL,'1','Add New Invoice','1'),
('2570','VR-23-2570','2023-09-20 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-09-20 16:19:33','2023-09-20 16:19:33',NULL,'1','Add New Invoice','1'),
('2571','VR-23-2571','2023-09-21 00:00:00','0','1250.00','1','151.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-09-21 12:20:30','2023-09-21 12:20:30',NULL,'1','Add New Invoice','1'),
('2572','VR-23-2572','2023-09-21 00:00:00','0','1250.00','1','773.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-09-21 12:22:53','2023-09-21 12:22:53',NULL,'1','Add New Invoice','1'),
('2573','VR-23-2573','2023-09-23 00:00:00','0','1250.00','1','288.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-23 16:38:36','2023-09-23 16:38:36',NULL,'1','Add New Invoice','1'),
('2574','VR-23-2574','2023-09-23 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-09-23 16:42:57','2023-09-23 16:42:57',NULL,'1','Add New Invoice','1'),
('2575','VR-23-2575','2023-09-23 00:00:00','0','1250.00','1','127.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-23 16:44:03','2023-09-23 16:44:03',NULL,'1','Add New Invoice','1'),
('2576','VR-23-2576','2023-09-23 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-09-23 16:45:27','2023-09-23 16:45:27',NULL,'1','Add New Invoice','1'),
('2577','VR-23-2577','2023-09-23 00:00:00','0','1250.00','1','111.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-23 16:47:42','2023-09-23 16:47:42',NULL,'1','Add New Invoice','1'),
('2578','VR-23-2578','2023-09-23 00:00:00','0','1250.00','1','208.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-23 16:57:38','2023-09-23 16:57:38',NULL,'1','Add New Invoice','1'),
('2579','VR-23-2579','2023-09-23 00:00:00','0','1250.00','1','435.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-09-23 17:02:28','2023-09-23 17:02:28',NULL,'1','Add New Invoice','1'),
('2580','VR-23-2580','2023-09-23 00:00:00','0','1250.00','1','355.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-23 17:05:03','2023-09-23 17:05:03',NULL,'1','Add New Invoice','1'),
('2581','VR-23-2581','2023-09-24 00:00:00','0','1250.00','1','153.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-24 15:23:29','2023-09-24 15:23:29',NULL,'1','Add New Invoice','1'),
('2582','VR-23-2582','2023-09-24 00:00:00','0','1250.00','1','1797.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2023-09-24 15:38:35','2023-09-24 15:38:35',NULL,'1','Add New Invoice','1'),
('2583','VR-23-2583','2023-09-25 00:00:00','0','1250.00','1','435.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-25 10:58:47','2023-09-25 11:26:45',NULL,'1','Update Invoice','1'),
('2584','VR-23-2584','2023-09-25 00:00:00','0','1250.00','1','8.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-09-25 12:02:48','2023-09-25 12:02:48',NULL,'1','Add New Invoice','1'),
('2585','VR-23-2585','2023-09-25 00:00:00','0','1250.00','1','1088.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-09-25 14:42:57','2023-09-25 14:42:57',NULL,'1','Add New Invoice','1'),
('2586','VR-23-2586','2023-09-25 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-25 14:48:00','2023-09-26 11:01:30',NULL,'1','Update Invoice','1'),
('2587','VR-23-2587','2023-09-25 00:00:00','0','1250.00','1','466.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-25 15:13:00','2023-09-25 15:13:00',NULL,'1','Add New Invoice','1'),
('2588','VR-23-2588','2023-09-25 00:00:00','0','1250.00','1','270.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-25 15:19:00','2023-09-25 15:19:00',NULL,'1','Add New Invoice','1'),
('2589','VR-23-2589','2023-09-25 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-09-25 15:22:57','2023-09-25 15:22:57',NULL,'1','Add New Invoice','1'),
('2590','VR-23-2590','2023-09-25 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-09-25 15:25:41','2023-09-25 15:25:41',NULL,'1','Add New Invoice','1'),
('2591','VR-23-2591','2023-09-25 00:00:00','0','1250.00','1','402.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-25 15:35:41','2023-09-25 15:35:41',NULL,'1','Add New Invoice','1'),
('2592','VR-23-2592','2023-09-25 00:00:00','0','1250.00','1','494.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-25 16:06:40','2023-09-26 01:49:52',NULL,'1','Update Invoice','1'),
('2593','VR-23-2593','2023-09-25 00:00:00','0','1250.00','1','181.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-09-25 16:17:41','2023-09-25 16:17:41',NULL,'1','Add New Invoice','1'),
('2594','INV-23-2594','2023-09-26 00:00:00','0','1250.00','1','351.30','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-09-26 03:06:36','2023-09-26 03:06:36',NULL,'1','Add New Invoice','1'),
('2595','INV-23-2595','2023-09-26 00:00:00','0','1250.00','1','22.72','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-26 04:11:53','2023-09-26 04:11:53',NULL,'1','Add New Invoice','1'),
('2596','VR-23-2596','2023-09-26 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-09-26 16:14:40','2023-09-26 16:14:40',NULL,'1','Add New Invoice','1'),
('2597','VR-23-2597','2023-09-26 00:00:00','0','1250.00','1','37.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-09-26 16:15:28','2023-09-26 16:15:28',NULL,'1','Add New Invoice','1'),
('2598','VR-23-2598','2023-09-26 00:00:00','0','1250.00','1','27.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-09-26 16:17:02','2023-09-26 16:17:02',NULL,'1','Add New Invoice','1'),
('2599','VR-23-2599','2023-09-26 00:00:00','0','1250.00','1','369.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-26 16:25:03','2023-09-26 16:25:03',NULL,'1','Add New Invoice','1'),
('2600','VR-23-2600','2023-09-26 00:00:00','0','1250.00','1','512.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-09-26 16:59:47','2023-09-26 05:07:08',NULL,'1','Update Invoice','1'),
('2601','VR-23-2601','2023-09-28 00:00:00','0','1250.00','1','68.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-09-28 13:44:10','2023-09-28 13:44:10',NULL,'1','Add New Invoice','1'),
('2602','VR-23-2602','2023-09-28 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-09-28 13:45:02','2023-09-28 13:45:02',NULL,'1','Add New Invoice','1'),
('2603','VR-23-2603','2023-09-28 00:00:00','0','1250.00','1','255.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-09-28 14:05:53','2023-09-28 14:05:53',NULL,'1','Add New Invoice','1'),
('2604','VR-23-2604','2023-09-28 00:00:00','0','1250.00','1','1853.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-09-28 14:20:23','2023-09-28 14:20:23',NULL,'1','Add New Invoice','1'),
('2605','VR-23-2605','2023-09-28 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-09-28 14:21:32','2023-09-28 14:21:32',NULL,'1','Add New Invoice','1'),
('2606','VR-23-2606','2023-09-28 00:00:00','0','1250.00','1','312.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-09-28 14:27:48','2023-09-28 14:27:48',NULL,'1','Add New Invoice','1'),
('2607','VR-23-2607','2023-09-28 00:00:00','0','1250.00','1','584.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-09-28 15:02:59','2023-09-28 15:02:59',NULL,'1','Add New Invoice','1'),
('2608','VR-23-2608','2023-09-28 00:00:00','0','1250.00','1','1002.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-28 15:13:53','2023-09-28 15:13:53',NULL,'1','Add New Invoice','1'),
('2609','VR-23-2609','2023-09-28 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-09-28 15:37:48','2023-09-28 15:37:48',NULL,'1','Add New Invoice','1'),
('2610','VR-23-2610','2023-09-28 00:00:00','0','1250.00','1','245.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-09-28 16:02:30','2023-09-28 04:17:23',NULL,'1','Update Invoice','1'),
('2611','VR-23-2611','2023-09-28 00:00:00','0','1250.00','1','244.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-09-28 16:05:17','2023-10-17 01:58:43',NULL,'1','Update Invoice','1'),
('2612','VR-23-2612','2023-09-28 00:00:00','0','1250.00','1','210.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-09-28 16:06:16','2023-09-28 16:06:16',NULL,'1','Add New Invoice','1'),
('2613','VR-23-2613','2023-09-28 00:00:00','0','1250.00','1','5471.49','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-09-28 16:15:03','2023-10-01 05:10:16',NULL,'1','Update Invoice','1'),
('2614','VR-23-2614','2023-09-28 00:00:00','0','1250.00','1','257.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-09-28 16:25:06','2023-09-28 16:25:06',NULL,'1','Add New Invoice','1'),
('2615','VR-23-2615','2023-09-28 00:00:00','0','1250.00','1','14.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-09-28 16:27:06','2023-09-28 16:27:06',NULL,'1','Add New Invoice','1'),
('2616','VR-23-2616','2023-09-28 00:00:00','0','1250.00','1','432.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-09-28 16:29:11','2023-09-28 16:29:11',NULL,'1','Add New Invoice','1'),
('2617','VR-23-2617','2023-09-28 00:00:00','0','1250.00','1','65.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-09-28 16:39:10','2023-09-28 16:39:10',NULL,'1','Add New Invoice','1'),
('2618','VR-23-2618','2023-09-30 00:00:00','0','1250.00','1','1511.64','0.00','احمد ناصرية سوق شيوخ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-09-30 16:08:59','2023-09-30 16:08:59',NULL,'1','Add New Invoice','1'),
('2619','VR-23-2619','2023-09-30 00:00:00','0','1250.00','1','4163.34','0.00','زهير عيونات كربل','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-09-30 16:16:47','2023-09-30 16:16:47',NULL,'1','Add New Invoice','1'),
('2620','VR-23-2620','2023-09-30 00:00:00','0','1250.00','1','1291.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-09-30 16:22:27','2023-09-30 16:22:27',NULL,'1','Add New Invoice','1'),
('2621','VR-23-2621','2023-09-30 00:00:00','0','1250.00','1','196.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-09-30 16:24:35','2023-09-30 16:24:35',NULL,'1','Add New Invoice','1'),
('2622','VR-23-2622','2023-10-01 00:00:00','0','1250.00','1','133.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-10-01 14:30:49','2023-10-01 14:30:49',NULL,'1','Add New Invoice','1'),
('2623','VR-23-2623','2023-10-01 00:00:00','0','1250.00','1','840.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-01 16:51:31','2023-10-01 05:08:59',NULL,'1','Update Invoice','1'),
('2624','VR-23-2624','2023-10-01 00:00:00','0','1250.00','1','1074.57','0.00','محمد احمد قضاء الخالص','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-01 16:54:33','2023-10-01 16:54:33',NULL,'1','Add New Invoice','1'),
('2625','VR-23-2625','2023-10-01 00:00:00','0','1250.00','1','374.44','0.00','مشخاب','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-01 16:56:15','2023-10-01 16:56:15',NULL,'1','Add New Invoice','1'),
('2626','VR-23-2626','2023-10-02 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-10-02 15:33:35','2023-10-02 15:33:35',NULL,'1','Add New Invoice','1'),
('2627','VR-23-2627','2023-10-02 00:00:00','0','1250.00','1','45.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-02 15:41:48','2023-10-02 15:41:48',NULL,'1','Add New Invoice','1'),
('2628','VR-23-2628','2023-10-02 00:00:00','0','1250.00','1','249.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-10-02 16:36:42','2023-10-02 16:36:42',NULL,'1','Add New Invoice','1'),
('2629','VR-23-2629','2023-10-02 00:00:00','0','1250.00','1','11625.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-02 16:56:35','2023-10-03 10:55:10',NULL,'1','Update Invoice','1'),
('2630','VR-23-2630','2023-10-03 00:00:00','0','1250.00','1','140.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-03 10:48:00','2023-10-03 10:48:00',NULL,'1','Add New Invoice','1'),
('2631','VR-23-2631','2023-10-03 00:00:00','0','1250.00','1','94.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-10-03 10:52:45','2023-10-03 10:52:45',NULL,'1','Add New Invoice','1'),
('2632','VR-23-2632','2023-10-03 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-10-03 10:56:44','2023-10-03 10:56:44',NULL,'1','Add New Invoice','1'),
('2633','INV-23-2633','2023-10-03 00:00:00','0','1250.00','1','19.12','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-03 11:11:35','2023-10-03 11:11:35',NULL,'1','Add New Invoice','1'),
('2634','VR-23-2634','2023-10-03 00:00:00','0','1250.00','1','519.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-10-03 11:27:04','2023-10-07 09:26:53',NULL,'1','Update Invoice','1'),
('2635','VR-23-2635','2023-10-03 00:00:00','0','1250.00','1','187.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-03 11:30:45','2023-10-03 11:30:45',NULL,'1','Add New Invoice','1'),
('2636','VR-23-2636','2023-10-03 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-10-03 11:37:20','2023-10-03 11:37:20',NULL,'1','Add New Invoice','1'),
('2637','VR-23-2637','2023-10-03 00:00:00','0','1250.00','1','883.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-03 16:10:50','2023-10-04 05:38:39',NULL,'1','Update Invoice','1'),
('2638','VR-23-2638','2023-10-03 00:00:00','0','1250.00','1','213.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-03 16:14:30','2023-10-03 16:14:30',NULL,'1','Add New Invoice','1'),
('2639','VR-23-2639','2023-10-03 00:00:00','0','1250.00','1','366.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-03 16:22:32','2023-10-03 16:22:32',NULL,'1','Add New Invoice','1'),
('2640','VR-23-2640','2023-10-03 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-10-03 16:39:09','2023-10-03 16:39:09',NULL,'1','Add New Invoice','1'),
('2641','VR-23-2641','2023-10-04 00:00:00','0','1250.00','1','233.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-04 15:56:48','2023-10-04 15:56:48',NULL,'1','Add New Invoice','1'),
('2642','VR-23-2642','2023-10-04 00:00:00','0','1250.00','1','59.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-10-04 15:57:46','2023-10-04 15:57:46',NULL,'1','Add New Invoice','1'),
('2643','VR-23-2643','2023-10-04 00:00:00','0','1250.00','1','6114.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-04 16:30:39','2023-10-04 16:30:39',NULL,'1','Add New Invoice','1'),
('2644','VR-23-2644','2023-10-04 00:00:00','0','1250.00','1','14843.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-04 17:00:41','2023-10-04 17:00:41',NULL,'1','Add New Invoice','1'),
('2645','VR-23-2645','2023-10-04 00:00:00','0','1250.00','1','576.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-04 17:52:34','2023-10-04 17:52:34',NULL,'1','Add New Invoice','1'),
('2646','VR-23-2646','2023-10-04 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-10-04 17:59:14','2023-10-04 17:59:14',NULL,'1','Add New Invoice','1'),
('2647','VR-23-2647','2023-10-04 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-10-04 18:01:14','2023-10-04 18:01:14',NULL,'1','Add New Invoice','1'),
('2648','VR-23-2648','2023-10-04 00:00:00','0','1250.00','1','139.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','1','2023-10-04 18:03:50','2023-10-04 18:03:50','2023-10-14 09:27:43','1','Delete Invoice','1'),
('2649','VR-23-2649','2023-10-04 00:00:00','0','1250.00','1','645.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-10-04 18:11:05','2023-10-04 18:11:05',NULL,'1','Add New Invoice','1'),
('2650','VR-23-2650','2023-10-04 00:00:00','0','1250.00','1','752.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-10-04 18:21:11','2023-10-04 18:21:11',NULL,'1','Add New Invoice','1'),
('2651','VR-23-2651','2023-10-04 00:00:00','0','1250.00','1','283.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-10-04 18:22:53','2023-10-04 18:22:53',NULL,'1','Add New Invoice','1'),
('2652','VR-23-2652','2023-10-04 00:00:00','0','1250.00','1','506.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-04 18:32:07','2023-10-04 18:32:07',NULL,'1','Add New Invoice','1'),
('2653','VR-23-2653','2023-10-04 00:00:00','0','1250.00','1','251.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-04 18:35:41','2023-10-08 12:11:33',NULL,'1','Update Invoice','1'),
('2654','VR-23-2654','2023-10-04 00:00:00','0','1250.00','1','293.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-10-04 18:45:29','2023-10-04 18:45:29',NULL,'1','Add New Invoice','1'),
('2655','VR-23-2655','2023-10-04 00:00:00','0','1250.00','1','155.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-10-04 19:11:07','2023-10-04 19:11:07',NULL,'1','Add New Invoice','1'),
('2656','INV-23-2656','2023-10-05 00:00:00','0','1250.00','1','138.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-10-05 02:30:56','2023-10-05 02:30:56',NULL,'1','Add New Invoice','1'),
('2657','VR-23-2657','2023-10-07 00:00:00','0','1250.00','1','3908.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-07 19:10:11','2023-10-07 07:21:04',NULL,'1','Update Invoice','1'),
('2658','VR-23-2658','2023-10-08 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-08 09:38:35','2023-10-08 09:38:35',NULL,'1','Add New Invoice','1'),
('2659','VR-23-2659','2023-10-08 00:00:00','0','1250.00','1','154.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-08 09:41:07','2023-10-08 09:41:07',NULL,'1','Add New Invoice','1'),
('2660','VR-23-2660','2023-10-08 00:00:00','0','1250.00','1','360.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-10-08 09:44:45','2023-10-08 09:44:45',NULL,'1','Add New Invoice','1'),
('2661','VR-23-2661','2023-10-08 00:00:00','0','1250.00','1','423.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-10-08 10:04:10','2023-10-08 10:04:10',NULL,'1','Add New Invoice','1'),
('2662','INV-23-2662','2023-10-08 00:00:00','0','1250.00','1','35.56','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-08 03:32:23','2023-10-08 03:32:23',NULL,'1','Add New Invoice','1'),
('2663','VR-23-2663','2023-10-08 00:00:00','0','1250.00','1','491.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-10-08 16:17:30','2023-10-08 16:17:30',NULL,'1','Add New Invoice','1'),
('2664','VR-23-2664','2023-10-08 00:00:00','0','1250.00','1','1133.59','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-08 16:33:10','2023-10-17 01:58:03',NULL,'1','Update Invoice','1'),
('2665','VR-23-2665','2023-10-08 00:00:00','0','1250.00','1','1308.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-08 16:51:30','2023-10-08 16:51:30',NULL,'1','Add New Invoice','1'),
('2666','VR-23-2666','2023-10-08 00:00:00','0','1250.00','1','402.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-08 17:10:53','2023-10-08 17:10:53',NULL,'1','Add New Invoice','1'),
('2667','VR-23-2667','2023-10-09 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-10-09 10:13:46','2023-10-09 10:13:46',NULL,'1','Add New Invoice','1'),
('2668','VR-23-2668','2023-10-09 00:00:00','0','1250.00','1','178.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-09 10:14:51','2023-10-09 10:14:51',NULL,'1','Add New Invoice','1'),
('2669','VR-23-2669','2023-10-09 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-10-09 10:20:11','2023-10-09 10:20:11',NULL,'1','Add New Invoice','1'),
('2670','VR-23-2670','2023-10-09 00:00:00','0','1250.00','1','272.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-09 10:23:28','2023-10-09 10:23:28',NULL,'1','Add New Invoice','1'),
('2671','VR-23-2671','2023-10-09 00:00:00','0','1250.00','1','230.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-10-09 10:39:11','2023-10-09 10:39:11',NULL,'1','Add New Invoice','1'),
('2672','VR-23-2672','2023-10-09 00:00:00','0','1250.00','1','311.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-10-09 10:42:38','2023-10-09 10:42:38',NULL,'1','Add New Invoice','1'),
('2673','VR-23-2673','2023-10-09 00:00:00','0','1250.00','1','215.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-09 12:25:46','2023-10-09 12:25:46',NULL,'1','Add New Invoice','1'),
('2674','VR-23-2674','2023-10-09 00:00:00','0','1250.00','1','160.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-10-09 12:57:40','2023-10-09 12:57:40',NULL,'1','Add New Invoice','1'),
('2675','VR-23-2675','2023-10-09 00:00:00','0','1250.00','1','87.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-09 12:58:56','2023-10-09 01:03:07',NULL,'1','Update Invoice','1'),
('2676','VR-23-2676','2023-10-09 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-10-09 13:08:05','2023-10-09 13:08:05',NULL,'1','Add New Invoice','1'),
('2677','VR-23-2677','2023-10-09 00:00:00','0','1250.00','1','739.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-09 13:15:12','2023-10-09 13:15:12',NULL,'1','Add New Invoice','1'),
('2678','VR-23-2678','2023-10-09 00:00:00','0','1250.00','1','486.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','109','0','2023-10-09 16:12:33','2023-10-14 02:46:10',NULL,'1','Update Invoice','1'),
('2679','VR-23-2679','2023-10-09 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-09 16:43:50','2023-10-09 16:43:50',NULL,'1','Add New Invoice','1'),
('2680','VR-23-2680','2023-10-09 00:00:00','0','1250.00','1','494.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-09 16:46:02','2023-10-09 16:46:02',NULL,'1','Add New Invoice','1'),
('2681','VR-23-2681','2023-10-09 00:00:00','0','1250.00','1','97.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-09 17:10:19','2023-10-09 17:10:19',NULL,'1','Add New Invoice','1'),
('2682','VR-23-2682','2023-10-09 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-10-09 17:24:00','2023-10-09 17:24:00',NULL,'1','Add New Invoice','1'),
('2683','VR-23-2683','2023-10-09 00:00:00','0','1250.00','1','153.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-09 17:28:47','2023-10-09 17:28:47',NULL,'1','Add New Invoice','1'),
('2684','VR-23-2684','2023-10-09 00:00:00','0','1250.00','1','598.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-10-09 17:33:38','2023-10-09 17:33:38',NULL,'1','Add New Invoice','1'),
('2685','VR-23-2685','2023-10-09 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-10-09 17:36:10','2023-10-09 17:36:10',NULL,'1','Add New Invoice','1'),
('2686','VR-23-2686','2023-10-09 00:00:00','0','1250.00','1','88.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-09 17:37:33','2023-10-09 17:37:33',NULL,'1','Add New Invoice','1'),
('2687','VR-23-2687','2023-10-10 00:00:00','0','1250.00','1','1480.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-10 09:37:00','2023-10-10 09:37:00',NULL,'1','Add New Invoice','1'),
('2688','VR-23-2688','2023-10-10 00:00:00','0','1250.00','1','3885.17','0.00','انور ناصرية','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-10 10:07:47','2023-10-10 10:07:47',NULL,'1','Add New Invoice','1'),
('2689','VR-23-2689','2023-10-10 00:00:00','0','1250.00','1','818.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-10 10:19:29','2023-10-10 10:19:29',NULL,'1','Add New Invoice','1'),
('2690','VR-23-2690','2023-10-10 00:00:00','0','1250.00','1','41.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-10-10 10:34:54','2023-10-10 10:34:54',NULL,'1','Add New Invoice','1'),
('2691','VR-23-2691','2023-10-10 00:00:00','0','1250.00','1','79.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-10-10 19:15:28','2023-10-10 19:15:28',NULL,'1','Add New Invoice','1'),
('2692','VR-23-2692','2023-10-11 00:00:00','0','1250.00','1','789.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-11 10:08:23','2023-10-16 12:12:46',NULL,'1','Update Invoice','1'),
('2693','VR-23-2693','2023-10-12 00:00:00','0','1250.00','1','6018.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-12 15:58:59','2023-10-12 15:58:59',NULL,'1','Add New Invoice','1'),
('2694','INV-23-2694','2023-10-12 00:00:00','0','1250.00','1','67.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-10-12 04:09:08','2023-10-12 04:09:08',NULL,'1','Add New Invoice','1'),
('2695','VR-23-2695','2023-10-12 00:00:00','0','1250.00','1','2739.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-10-12 16:09:41','2023-10-12 16:09:41',NULL,'1','Add New Invoice','1'),
('2696','VR-23-2696','2023-10-14 00:00:00','0','1250.00','1','3198.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2023-10-14 13:04:16','2023-10-23 03:39:11','2023-11-19 09:24:23','1','Delete Invoice','1'),
('2697','VR-23-2697','2023-10-14 00:00:00','0','1250.00','1','486.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-14 15:23:01','2023-10-14 15:23:01',NULL,'1','Add New Invoice','1'),
('2698','VR-23-2698','2023-10-14 00:00:00','0','1250.00','1','574.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-14 15:34:31','2023-10-14 03:47:09',NULL,'1','Update Invoice','1'),
('2699','VR-23-2699','2023-10-14 00:00:00','0','1250.00','1','366.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-10-14 15:52:19','2023-10-14 15:52:19',NULL,'1','Add New Invoice','1'),
('2700','VR-23-2700','2023-10-14 00:00:00','0','1250.00','1','556.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-14 17:10:55','2023-10-14 05:11:46',NULL,'1','Update Invoice','1'),
('2701','VR-23-2701','2023-10-15 00:00:00','0','1250.00','1','109.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-10-15 11:10:44','2023-10-15 11:10:44',NULL,'1','Add New Invoice','1'),
('2702','VR-23-2702','2023-10-15 00:00:00','0','1250.00','1','2240.89','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-15 11:31:20','2023-10-15 03:57:50',NULL,'1','Update Invoice','1'),
('2703','VR-23-2703','2023-10-15 00:00:00','0','1250.00','1','379.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-10-15 15:13:10','2023-10-15 15:13:10',NULL,'1','Add New Invoice','1'),
('2704','VR-23-2704','2023-10-15 00:00:00','0','1250.00','1','293.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-15 16:25:43','2023-10-15 16:25:43',NULL,'1','Add New Invoice','1'),
('2705','VR-23-2705','2023-10-16 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-16 09:40:22','2023-10-16 09:40:22',NULL,'1','Add New Invoice','1'),
('2706','VR-23-2706','2023-10-16 00:00:00','0','1250.00','1','576.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-16 10:03:18','2023-10-16 10:03:18',NULL,'1','Add New Invoice','1'),
('2707','VR-23-2707','2023-10-16 00:00:00','0','1250.00','1','2963.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-16 10:17:41','2023-10-16 10:23:36',NULL,'1','Update Invoice','1'),
('2708','VR-23-2708','2023-10-16 00:00:00','0','1250.00','1','1550.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-10-16 11:37:18','2023-10-16 11:37:18',NULL,'1','Add New Invoice','1'),
('2709','VR-23-2709','2023-10-16 00:00:00','0','1250.00','1','153.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-16 11:45:19','2023-10-16 11:45:19',NULL,'1','Add New Invoice','1'),
('2710','VR-23-2710','2023-10-16 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-16 12:16:28','2023-10-16 12:16:28',NULL,'1','Add New Invoice','1'),
('2711','VR-23-2711','2023-10-16 00:00:00','0','1250.00','1','53.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-10-16 15:18:53','2023-10-16 15:18:53',NULL,'1','Add New Invoice','1'),
('2712','VR-23-2712','2023-10-16 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-10-16 15:37:47','2023-10-16 15:37:47',NULL,'1','Add New Invoice','1'),
('2713','VR-23-2713','2023-10-17 00:00:00','0','1250.00','1','173.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-10-17 15:06:10','2023-10-21 12:18:36',NULL,'1','Update Invoice','1'),
('2714','VR-23-2714','2023-10-17 00:00:00','0','1250.00','1','1025.99','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-10-17 17:05:22','2023-10-18 09:14:41',NULL,'1','Update Invoice','1'),
('2715','VR-23-2715','2023-10-17 00:00:00','0','1250.00','1','350.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-10-17 17:12:23','2023-10-17 17:12:23',NULL,'1','Add New Invoice','1'),
('2716','VR-23-2716','2023-10-17 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-10-17 17:14:27','2023-10-17 17:14:27',NULL,'1','Add New Invoice','1'),
('2717','VR-23-2717','2023-10-17 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-10-17 17:20:33','2023-10-17 17:20:33',NULL,'1','Add New Invoice','1'),
('2718','VR-23-2718','2023-10-18 00:00:00','0','1250.00','1','1520.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-18 12:06:48','2023-10-21 12:12:02',NULL,'1','Update Invoice','1'),
('2719','VR-23-2719','2023-10-18 00:00:00','0','1250.00','1','415.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-18 16:44:33','2023-10-18 16:44:33',NULL,'1','Add New Invoice','1'),
('2720','VR-23-2720','2023-10-19 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-10-19 09:49:11','2023-10-19 09:49:11',NULL,'1','Add New Invoice','1'),
('2721','VR-23-2721','2023-10-19 00:00:00','0','1250.00','1','62.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-10-19 10:00:42','2023-10-19 10:00:42',NULL,'1','Add New Invoice','1'),
('2722','VR-23-2722','2023-10-19 00:00:00','0','1250.00','1','598.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-19 10:12:18','2023-10-19 10:12:18',NULL,'1','Add New Invoice','1'),
('2723','VR-23-2723','2023-10-19 00:00:00','0','1250.00','1','215.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-10-19 10:47:04','2023-10-19 10:47:04',NULL,'1','Add New Invoice','1'),
('2724','VR-23-2724','2023-10-19 00:00:00','0','1250.00','1','43.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-10-19 10:58:27','2023-10-19 10:58:27',NULL,'1','Add New Invoice','1'),
('2725','VR-23-2725','2023-10-19 00:00:00','0','1250.00','1','595.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-19 11:04:34','2023-10-19 11:04:34',NULL,'1','Add New Invoice','1'),
('2726','VR-23-2726','2023-10-19 00:00:00','0','1250.00','1','477.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-10-19 13:03:41','2023-10-19 13:03:41',NULL,'1','Add New Invoice','1'),
('2727','VR-23-2727','2023-10-19 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-10-19 13:06:42','2023-10-19 13:06:42',NULL,'1','Add New Invoice','1'),
('2728','VR-23-2728','2023-10-19 00:00:00','0','1250.00','1','292.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-10-19 13:09:16','2023-10-19 03:21:52',NULL,'1','Update Invoice','1'),
('2729','VR-23-2729','2023-10-19 00:00:00','0','1250.00','1','244.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-10-19 13:14:01','2023-11-05 09:36:13',NULL,'1','Update Invoice','1'),
('2730','VR-23-2730','2023-10-19 00:00:00','0','1250.00','1','376.64','0.00','مهد الاسدي مدينة صدر','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-19 14:36:52','2023-10-19 02:38:44',NULL,'1','Update Invoice','1'),
('2731','VR-23-2731','2023-10-19 00:00:00','0','1250.00','1','1320.04','0.00','ارشد حلة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-19 14:46:17','2023-10-19 14:46:17',NULL,'1','Add New Invoice','1'),
('2732','VR-23-2732','2023-10-19 00:00:00','0','1250.00','1','289.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-19 15:27:33','2023-10-19 15:27:33',NULL,'1','Add New Invoice','1'),
('2733','VR-23-2733','2023-10-19 00:00:00','0','1250.00','1','2533.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-19 15:36:29','2023-10-21 09:54:47',NULL,'1','Update Invoice','1'),
('2734','VR-23-2734','2023-10-19 00:00:00','0','1250.00','1','192.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-10-19 15:49:52','2023-10-19 15:49:52',NULL,'1','Add New Invoice','1'),
('2735','VR-23-2735','2023-10-19 00:00:00','0','1250.00','1','33.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-10-19 15:51:56','2023-10-19 15:51:56',NULL,'1','Add New Invoice','1'),
('2736','VR-23-2736','2023-10-19 00:00:00','0','1250.00','1','199.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-19 15:55:17','2023-10-19 15:55:17',NULL,'1','Add New Invoice','1'),
('2737','VR-23-2737','2023-10-19 00:00:00','0','1250.00','1','434.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-19 15:59:04','2023-10-21 12:54:13',NULL,'1','Update Invoice','1'),
('2738','VR-23-2738','2023-10-19 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-10-19 16:04:16','2023-10-19 04:04:25',NULL,'1','Update Invoice','1'),
('2739','VR-23-2739','2023-10-19 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-19 16:06:26','2023-10-19 16:06:26',NULL,'1','Add New Invoice','1'),
('2740','VR-23-2740','2023-10-19 00:00:00','0','1250.00','1','25.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-19 16:07:05','2023-10-19 16:07:05',NULL,'1','Add New Invoice','1'),
('2741','VR-23-2741','2023-10-19 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-10-19 16:10:14','2023-10-19 16:10:14',NULL,'1','Add New Invoice','1'),
('2742','VR-23-2742','2023-10-19 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-10-19 16:11:47','2023-10-19 16:11:47',NULL,'1','Add New Invoice','1'),
('2743','VR-23-2743','2023-10-19 00:00:00','0','1250.00','1','230.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-19 16:12:46','2023-10-19 16:12:46',NULL,'1','Add New Invoice','1'),
('2744','VR-23-2744','2023-10-21 00:00:00','0','1250.00','1','215.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-21 21:09:44','2023-10-21 21:09:44',NULL,'1','Add New Invoice','1'),
('2745','VR-23-2745','2023-10-21 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-21 21:12:29','2023-10-21 21:12:29',NULL,'1','Add New Invoice','1'),
('2746','VR-23-2746','2023-10-21 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-21 21:14:26','2023-10-21 21:14:26',NULL,'1','Add New Invoice','1'),
('2747','VR-23-2747','2023-10-21 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-10-21 21:16:20','2023-10-21 21:16:20',NULL,'1','Add New Invoice','1'),
('2748','VR-23-2748','2023-10-21 00:00:00','0','1250.00','1','605.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-21 21:18:30','2023-10-21 09:19:05',NULL,'1','Update Invoice','1'),
('2749','VR-23-2749','2023-10-22 00:00:00','0','1250.00','1','9529.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-22 10:00:56','2023-10-23 10:43:05',NULL,'1','Update Invoice','1'),
('2750','VR-23-2750','2023-10-22 00:00:00','0','1250.00','1','8916.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-22 12:18:33','2023-10-23 11:12:27',NULL,'1','Update Invoice','1'),
('2751','VR-23-2751','2023-10-22 00:00:00','0','1250.00','1','9681.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-22 12:26:54','2023-10-24 09:33:37',NULL,'1','Update Invoice','1'),
('2752','VR-23-2752','2023-10-22 00:00:00','0','1250.00','1','504.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-22 15:24:41','2023-10-22 15:24:41',NULL,'1','Add New Invoice','1'),
('2753','VR-23-2753','2023-10-22 00:00:00','0','1250.00','1','303.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-22 15:27:55','2023-10-22 15:27:55',NULL,'1','Add New Invoice','1'),
('2754','VR-23-2754','2023-10-22 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-10-22 15:31:20','2023-10-22 03:31:38',NULL,'1','Update Invoice','1'),
('2755','VR-23-2755','2023-10-22 00:00:00','0','1250.00','1','307.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-22 15:33:47','2023-10-22 15:33:47',NULL,'1','Add New Invoice','1'),
('2756','VR-23-2756','2023-10-22 00:00:00','0','1250.00','1','464.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-10-22 15:48:32','2023-10-22 15:48:32',NULL,'1','Add New Invoice','1'),
('2757','VR-23-2757','2023-10-22 00:00:00','0','1250.00','1','160.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-10-22 15:52:12','2023-10-22 15:52:12',NULL,'1','Add New Invoice','1'),
('2758','VR-23-2758','2023-10-22 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-10-22 15:54:52','2023-10-22 15:54:52',NULL,'1','Add New Invoice','1'),
('2759','VR-23-2759','2023-10-22 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-10-22 15:56:59','2023-10-22 15:56:59',NULL,'1','Add New Invoice','1'),
('2760','VR-23-2760','2023-10-22 00:00:00','0','1250.00','1','63.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-22 15:57:58','2023-10-22 15:57:58',NULL,'1','Add New Invoice','1'),
('2761','VR-23-2761','2023-10-22 00:00:00','0','1250.00','1','168.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-22 15:59:37','2023-10-22 15:59:37',NULL,'1','Add New Invoice','1'),
('2762','VR-23-2762','2023-10-22 00:00:00','0','1250.00','1','75.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-22 16:05:20','2023-10-22 16:05:20',NULL,'1','Add New Invoice','1'),
('2763','VR-23-2763','2023-10-23 00:00:00','0','1250.00','1','12220.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-10-23 10:18:01','2023-10-31 09:29:24',NULL,'1','Update Invoice','1'),
('2764','VR-23-2764','2023-10-23 00:00:00','0','1250.00','1','10107.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-23 11:45:35','2023-10-23 11:45:35',NULL,'1','Add New Invoice','1'),
('2765','VR-23-2765','2023-10-23 00:00:00','0','1250.00','1','11046.74','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-23 12:07:12','2023-10-24 09:32:18',NULL,'1','Update Invoice','1'),
('2766','VR-23-2766','2023-10-23 00:00:00','0','1250.00','1','2323.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-10-23 12:42:28','2023-10-23 12:42:28',NULL,'1','Add New Invoice','1'),
('2767','VR-23-2767','2023-10-23 00:00:00','0','1250.00','1','970.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-23 16:03:08','2023-10-23 16:03:08',NULL,'1','Add New Invoice','1'),
('2768','VR-23-2768','2023-10-23 00:00:00','0','1250.00','1','19.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-10-23 16:10:05','2023-10-23 16:10:05',NULL,'1','Add New Invoice','1'),
('2769','VR-23-2769','2023-10-23 00:00:00','0','1250.00','1','131.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-10-23 16:12:24','2023-10-23 16:12:24',NULL,'1','Add New Invoice','1'),
('2770','VR-23-2770','2023-10-23 00:00:00','0','1250.00','1','387.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-23 16:18:59','2023-10-23 16:18:59',NULL,'1','Add New Invoice','1'),
('2771','VR-23-2771','2023-10-23 00:00:00','0','1250.00','1','198.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-23 16:20:20','2023-10-23 16:20:20',NULL,'1','Add New Invoice','1'),
('2772','VR-23-2772','2023-10-23 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-10-23 16:22:39','2023-10-23 16:22:39',NULL,'1','Add New Invoice','1'),
('2773','VR-23-2773','2023-10-23 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-10-23 16:25:00','2023-10-23 16:25:00',NULL,'1','Add New Invoice','1'),
('2774','VR-23-2774','2023-10-23 00:00:00','0','1250.00','1','195.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-23 16:26:15','2023-10-28 03:46:58',NULL,'1','Update Invoice','1'),
('2775','VR-23-2775','2023-10-23 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-10-23 16:29:17','2023-10-23 16:29:17',NULL,'1','Add New Invoice','1'),
('2776','VR-23-2776','2023-10-24 00:00:00','0','1250.00','1','602.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-24 10:25:52','2023-10-24 10:25:52',NULL,'1','Add New Invoice','1'),
('2777','VR-23-2777','2023-10-24 00:00:00','0','1250.00','1','105.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-10-24 10:52:02','2023-10-24 10:52:02',NULL,'1','Add New Invoice','1'),
('2778','VR-23-2778','2023-10-24 00:00:00','0','1250.00','1','480.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-24 16:04:05','2023-10-24 16:04:05',NULL,'1','Add New Invoice','1'),
('2779','VR-23-2779','2023-10-24 00:00:00','0','1250.00','1','239.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-24 16:20:58','2023-10-24 16:20:58',NULL,'1','Add New Invoice','1'),
('2780','VR-23-2780','2023-10-24 00:00:00','0','1250.00','1','116.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-10-24 16:22:51','2023-10-24 16:22:51',NULL,'1','Add New Invoice','1'),
('2781','VR-23-2781','2023-10-24 00:00:00','0','1250.00','1','101.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-10-24 16:26:14','2023-10-24 16:26:14',NULL,'1','Add New Invoice','1'),
('2782','VR-23-2782','2023-10-24 00:00:00','0','1250.00','1','224.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-24 16:27:19','2023-10-24 16:27:19',NULL,'1','Add New Invoice','1'),
('2783','VR-23-2783','2023-10-24 00:00:00','0','1250.00','1','931.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-10-24 16:30:37','2023-10-24 16:30:37',NULL,'1','Add New Invoice','1'),
('2784','VR-23-2784','2023-10-24 00:00:00','0','1250.00','1','166.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-10-24 16:36:08','2023-10-24 16:36:08',NULL,'1','Add New Invoice','1'),
('2785','VR-23-2785','2023-10-24 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-24 16:37:33','2023-10-24 16:37:33',NULL,'1','Add New Invoice','1'),
('2786','VR-23-2786','2023-10-25 00:00:00','0','1250.00','1','340.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-10-25 15:41:07','2023-10-25 15:41:07',NULL,'1','Add New Invoice','1'),
('2787','VR-23-2787','2023-10-25 00:00:00','0','1250.00','1','105.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-10-25 15:45:15','2023-10-25 15:45:15',NULL,'1','Add New Invoice','1'),
('2788','VR-23-2788','2023-10-25 00:00:00','0','1250.00','1','93.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-25 16:08:09','2023-10-25 16:08:09',NULL,'1','Add New Invoice','1'),
('2789','VR-23-2789','2023-10-25 00:00:00','0','1250.00','1','559.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-10-25 16:13:59','2023-10-25 16:13:59',NULL,'1','Add New Invoice','1'),
('2790','VR-23-2790','2023-10-25 00:00:00','0','1250.00','1','1508.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-10-25 16:15:40','2023-10-25 16:15:40',NULL,'1','Add New Invoice','1'),
('2791','VR-23-2791','2023-10-25 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-25 16:18:27','2023-10-25 16:18:27',NULL,'1','Add New Invoice','1'),
('2792','VR-23-2792','2023-10-25 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-10-25 16:20:53','2023-10-25 16:20:53',NULL,'1','Add New Invoice','1'),
('2793','VR-23-2793','2023-10-25 00:00:00','0','1250.00','1','183.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-25 16:23:20','2023-10-25 16:23:20',NULL,'1','Add New Invoice','1'),
('2794','VR-23-2794','2023-10-25 00:00:00','0','1250.00','1','138.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-10-25 16:32:00','2023-10-26 10:12:34',NULL,'1','Update Invoice','1'),
('2795','VR-23-2795','2023-10-25 00:00:00','0','1250.00','1','159.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-25 16:33:27','2023-10-25 16:33:27',NULL,'1','Add New Invoice','1'),
('2796','VR-23-2796','2023-10-25 00:00:00','0','1250.00','1','88.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-10-25 16:37:30','2023-10-25 16:37:30',NULL,'1','Add New Invoice','1'),
('2797','VR-23-2797','2023-10-28 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-28 10:10:49','2023-10-28 10:10:49',NULL,'1','Add New Invoice','1'),
('2798','VR-23-2798','2023-10-28 00:00:00','0','1250.00','1','419.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-28 10:47:58','2023-10-28 10:47:58',NULL,'1','Add New Invoice','1'),
('2799','VR-23-2799','2023-10-28 00:00:00','0','1250.00','1','93.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-10-28 10:56:35','2023-10-28 10:56:35',NULL,'1','Add New Invoice','1'),
('2800','VR-23-2800','2023-10-28 00:00:00','0','1250.00','1','38.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-28 15:07:57','2023-10-28 15:07:57',NULL,'1','Add New Invoice','1'),
('2801','VR-23-2801','2023-10-28 00:00:00','0','1250.00','1','69.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-10-28 15:14:11','2023-10-28 15:14:11',NULL,'1','Add New Invoice','1'),
('2802','VR-23-2802','2023-10-28 00:00:00','0','1250.00','1','146.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-28 15:18:03','2023-10-28 15:18:03',NULL,'1','Add New Invoice','1'),
('2803','VR-23-2803','2023-10-28 00:00:00','0','1250.00','1','219.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-10-28 15:24:15','2023-10-28 03:43:13',NULL,'1','Update Invoice','1'),
('2804','VR-23-2804','2023-10-28 00:00:00','0','1250.00','1','247.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-10-28 15:29:26','2023-10-28 15:29:26',NULL,'1','Add New Invoice','1'),
('2805','INV-23-2805','2023-10-29 00:00:00','0','1250.00','1','69.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-10-29 10:13:13','2023-10-29 10:13:13',NULL,'1','Add New Invoice','1'),
('2806','VR-23-2806','2023-10-29 00:00:00','0','1250.00','1','3343.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-29 10:21:44','2023-10-29 10:21:44',NULL,'1','Add New Invoice','1'),
('2807','INV-23-2807','2023-10-29 00:00:00','0','1250.00','1','48.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-10-29 10:22:07','2023-10-29 10:22:07',NULL,'1','Add New Invoice','1'),
('2808','VR-23-2808','2023-10-29 00:00:00','0','1250.00','1','10365.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-29 11:32:28','2023-10-29 11:32:28',NULL,'1','Add New Invoice','1'),
('2809','VR-23-2809','2023-10-29 00:00:00','0','1250.00','1','2096.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-29 15:49:29','2023-10-29 15:49:29',NULL,'1','Add New Invoice','1'),
('2810','VR-23-2810','2023-10-29 00:00:00','0','1250.00','1','14863.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-29 16:16:07','2023-10-29 16:16:07',NULL,'1','Add New Invoice','1'),
('2811','VR-23-2811','2023-10-30 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-10-30 09:59:53','2023-10-30 09:59:53',NULL,'1','Add New Invoice','1'),
('2812','VR-23-2812','2023-10-30 00:00:00','0','1250.00','1','1423.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-10-30 10:15:29','2023-10-30 10:47:45',NULL,'1','Update Invoice','1'),
('2813','VR-23-2813','2023-10-30 00:00:00','0','1250.00','1','227.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-30 10:56:06','2023-10-30 10:56:06',NULL,'1','Add New Invoice','1'),
('2814','VR-23-2814','2023-10-30 00:00:00','0','1250.00','1','120.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-10-30 10:56:51','2023-10-30 10:56:51',NULL,'1','Add New Invoice','1'),
('2815','VR-23-2815','2023-10-30 00:00:00','0','1250.00','1','562.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-10-30 11:01:34','2023-10-30 11:01:34',NULL,'1','Add New Invoice','1'),
('2816','VR-23-2816','2023-10-30 00:00:00','0','1250.00','1','235.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-10-30 13:31:45','2023-10-30 13:31:45',NULL,'1','Add New Invoice','1'),
('2817','INV-23-2817','2023-10-30 00:00:00','0','1250.00','1','406.98','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-10-31 08:35:24','2023-10-31 08:35:24',NULL,'1','Add New Invoice','1'),
('2818','VR-23-2818','2023-10-31 00:00:00','0','1250.00','1','187.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-10-31 15:57:24','2023-10-31 15:57:24',NULL,'1','Add New Invoice','1'),
('2819','VR-23-2819','2023-10-31 00:00:00','0','1250.00','1','27.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-10-31 15:58:14','2023-10-31 15:58:14',NULL,'1','Add New Invoice','1'),
('2820','VR-23-2820','2023-10-31 00:00:00','0','1250.00','1','249.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-10-31 16:01:13','2023-10-31 04:05:26',NULL,'1','Update Invoice','1'),
('2821','VR-23-2821','2023-10-31 00:00:00','0','1250.00','1','78.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-10-31 16:02:09','2023-10-31 16:02:09',NULL,'1','Add New Invoice','1'),
('2822','VR-23-2822','2023-10-31 00:00:00','0','1250.00','1','73.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-10-31 16:03:13','2023-10-31 16:03:13',NULL,'1','Add New Invoice','1'),
('2823','VR-23-2823','2023-11-01 00:00:00','0','1250.00','1','1944.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-01 15:04:31','2023-11-01 15:04:31',NULL,'1','Add New Invoice','1'),
('2824','VR-23-2824','2023-11-01 00:00:00','0','1250.00','1','382.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-01 15:20:09','2023-11-02 09:57:14',NULL,'1','Update Invoice','1'),
('2825','VR-23-2825','2023-11-01 00:00:00','0','1250.00','1','1268.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-01 15:38:48','2023-11-02 10:06:10',NULL,'1','Update Invoice','1'),
('2826','VR-23-2826','2023-11-01 00:00:00','0','1250.00','1','825.34','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-01 16:10:44','2023-11-01 16:10:44',NULL,'1','Add New Invoice','1'),
('2827','INV-23-2827','2023-11-02 00:00:00','0','1250.00','1','107.32','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-11-02 10:56:48','2023-11-02 10:56:48',NULL,'1','Add New Invoice','1'),
('2828','VR-23-2828','2023-11-02 00:00:00','0','1250.00','1','2043.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-02 12:11:38','2023-11-02 12:11:38',NULL,'1','Add New Invoice','1'),
('2829','VR-23-2829','2023-11-02 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-11-02 13:55:40','2023-11-02 13:55:40',NULL,'1','Add New Invoice','1'),
('2830','VR-23-2830','2023-11-02 00:00:00','0','1250.00','1','200.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-11-02 14:06:07','2023-11-02 14:06:07',NULL,'1','Add New Invoice','1'),
('2831','VR-23-2831','2023-11-02 00:00:00','0','1250.00','1','274.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-11-02 14:10:35','2023-11-05 09:35:43',NULL,'1','Update Invoice','1'),
('2832','VR-23-2832','2023-11-02 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-11-02 14:19:58','2023-11-02 14:19:58',NULL,'1','Add New Invoice','1'),
('2833','VR-23-2833','2023-11-02 00:00:00','0','1250.00','1','1456.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-11-02 14:31:25','2023-11-02 14:31:25',NULL,'1','Add New Invoice','1'),
('2834','VR-23-2834','2023-11-02 00:00:00','0','1250.00','1','341.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-02 14:36:35','2023-11-02 14:36:35',NULL,'1','Add New Invoice','1'),
('2835','VR-23-2835','2023-11-02 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-11-02 14:48:39','2023-11-02 14:48:39',NULL,'1','Add New Invoice','1'),
('2836','VR-23-2836','2023-11-02 00:00:00','0','1250.00','1','409.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-02 15:04:16','2023-11-02 15:04:16',NULL,'1','Add New Invoice','1'),
('2837','VR-23-2837','2023-11-02 00:00:00','0','1250.00','1','16.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-11-02 15:06:11','2023-11-02 15:06:11',NULL,'1','Add New Invoice','1'),
('2838','VR-23-2838','2023-11-02 00:00:00','0','1250.00','1','94.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-11-02 15:08:18','2023-11-02 15:08:18',NULL,'1','Add New Invoice','1'),
('2839','VR-23-2839','2023-11-02 00:00:00','0','1250.00','1','731.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-02 15:17:28','2023-11-02 15:17:28',NULL,'1','Add New Invoice','1'),
('2840','VR-23-2840','2023-11-02 00:00:00','0','1250.00','1','286.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-02 15:19:08','2023-11-13 03:15:16',NULL,'1','Update Invoice','1'),
('2841','VR-23-2841','2023-11-04 00:00:00','0','1250.00','1','167.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-04 11:54:37','2023-11-04 11:54:37',NULL,'1','Add New Invoice','1'),
('2842','VR-23-2842','2023-11-04 00:00:00','0','1250.00','1','110.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-11-04 15:30:18','2023-11-04 15:30:18',NULL,'1','Add New Invoice','1'),
('2843','VR-23-2843','2023-11-04 00:00:00','0','1250.00','1','174.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-11-04 15:31:28','2023-11-04 15:31:28',NULL,'1','Add New Invoice','1'),
('2844','VR-23-2844','2023-11-04 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-04 15:33:46','2023-11-04 15:33:46',NULL,'1','Add New Invoice','1'),
('2845','VR-23-2845','2023-11-04 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-11-04 15:40:35','2023-11-04 15:40:35',NULL,'1','Add New Invoice','1'),
('2846','VR-23-2846','2023-11-04 00:00:00','0','1250.00','1','477.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-04 15:50:33','2023-11-04 15:50:33',NULL,'1','Add New Invoice','1'),
('2847','VR-23-2847','2023-11-04 00:00:00','0','1250.00','1','43.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-11-04 16:19:50','2023-11-04 16:19:50',NULL,'1','Add New Invoice','1'),
('2848','VR-23-2848','2023-11-05 00:00:00','0','1250.00','1','276.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-05 11:38:55','2023-11-05 11:38:55',NULL,'1','Add New Invoice','1'),
('2849','VR-23-2849','2023-11-06 00:00:00','0','1250.00','1','1305.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-11-06 11:12:16','2023-11-06 11:12:16',NULL,'1','Add New Invoice','1'),
('2850','VR-23-2850','2023-11-06 00:00:00','0','1250.00','1','255.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-11-06 12:07:16','2023-11-06 12:07:16',NULL,'1','Add New Invoice','1'),
('2851','VR-23-2851','2023-11-06 00:00:00','0','1250.00','1','240.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-11-06 12:18:05','2023-11-06 12:37:41',NULL,'1','Update Invoice','1'),
('2852','VR-23-2852','2023-11-06 00:00:00','0','1250.00','1','36.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-11-06 12:19:13','2023-11-06 12:19:13',NULL,'1','Add New Invoice','1'),
('2853','VR-23-2853','2023-11-06 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-06 12:45:55','2023-11-06 12:45:55',NULL,'1','Add New Invoice','1'),
('2854','VR-23-2854','2023-11-07 00:00:00','0','1250.00','1','55.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-11-07 11:26:50','2023-11-07 11:26:50',NULL,'1','Add New Invoice','1'),
('2855','VR-23-2855','2023-11-07 00:00:00','0','1250.00','1','164.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-11-07 12:03:17','2023-11-07 12:03:17',NULL,'1','Add New Invoice','1'),
('2856','VR-23-2856','2023-11-08 00:00:00','0','1250.00','1','660.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-08 10:19:43','2023-11-08 10:19:43',NULL,'1','Add New Invoice','1'),
('2857','VR-23-2857','2023-11-08 00:00:00','0','1250.00','1','2034.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-11-08 10:50:54','2023-11-08 10:50:54',NULL,'1','Add New Invoice','1'),
('2858','VR-23-2858','2023-11-08 00:00:00','0','1250.00','1','1724.52','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-08 11:14:27','2023-11-08 03:11:49',NULL,'1','Update Invoice','1'),
('2859','VR-23-2859','2023-11-08 00:00:00','0','1250.00','1','127.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-11-08 13:56:29','2023-11-08 13:56:29',NULL,'1','Add New Invoice','1'),
('2860','VR-23-2860','2023-11-08 00:00:00','0','1250.00','1','81.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-11-08 14:55:14','2023-11-08 02:59:11',NULL,'1','Update Invoice','1'),
('2861','VR-23-2861','2023-11-08 00:00:00','0','1250.00','1','473.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-08 15:05:25','2023-11-08 15:05:25',NULL,'1','Add New Invoice','1'),
('2862','VR-23-2862','2023-11-08 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-11-08 15:06:42','2023-11-08 15:06:42',NULL,'1','Add New Invoice','1'),
('2863','VR-23-2863','2023-11-09 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-11-09 11:55:10','2023-11-09 11:55:10',NULL,'1','Add New Invoice','1'),
('2864','VR-23-2864','2023-11-09 00:00:00','0','1250.00','1','729.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-11-09 12:08:39','2023-11-22 10:18:54',NULL,'1','Update Invoice','1'),
('2865','VR-23-2865','2023-11-09 00:00:00','0','1250.00','1','279.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-11-09 14:14:02','2023-11-09 02:24:41',NULL,'1','Update Invoice','1'),
('2866','VR-23-2866','2023-11-09 00:00:00','0','1250.00','1','32.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-11-09 14:32:35','2023-11-09 14:32:35',NULL,'1','Add New Invoice','1'),
('2867','VR-23-2867','2023-11-09 00:00:00','0','1250.00','1','112.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-09 14:35:35','2023-11-09 14:35:35',NULL,'1','Add New Invoice','1'),
('2868','VR-23-2868','2023-11-09 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-11-09 14:40:19','2023-11-09 14:40:19',NULL,'1','Add New Invoice','1'),
('2869','VR-23-2869','2023-11-09 00:00:00','0','1250.00','1','613.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-09 14:49:01','2023-11-09 14:49:01',NULL,'1','Add New Invoice','1'),
('2870','INV-23-2870','2023-11-11 00:00:00','0','1250.00','1','117.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-11 11:03:14','2023-11-11 11:03:14',NULL,'1','Add New Invoice','1'),
('2871','VR-23-2871','2023-11-11 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-11 12:07:02','2023-11-11 12:07:02',NULL,'1','Add New Invoice','1'),
('2872','INV-23-2872','2023-11-11 00:00:00','0','1250.00','1','132.27','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-11 01:44:59','2023-11-11 01:44:59',NULL,'1','Add New Invoice','1'),
('2873','VR-23-2873','2023-11-12 00:00:00','0','1250.00','1','260.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-12 13:32:12','2023-11-12 13:32:12',NULL,'1','Add New Invoice','1'),
('2874','VR-23-2874','2023-11-12 00:00:00','0','1250.00','1','1395.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-11-12 16:16:09','2023-11-12 05:09:31',NULL,'1','Update Invoice','1'),
('2875','VR-23-2875','2023-11-12 00:00:00','0','1250.00','1','528.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-11-12 16:28:33','2023-11-12 16:28:33',NULL,'1','Add New Invoice','1'),
('2876','VR-23-2876','2023-11-12 00:00:00','0','1250.00','1','242.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-12 16:42:08','2023-11-12 16:42:08',NULL,'1','Add New Invoice','1'),
('2877','VR-23-2877','2023-11-12 00:00:00','0','1250.00','1','1999.06','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-11-12 16:47:27','2023-11-12 16:47:27',NULL,'1','Add New Invoice','1'),
('2878','VR-23-2878','2023-11-12 00:00:00','0','1250.00','1','51.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-11-12 16:56:31','2023-11-12 16:56:31',NULL,'1','Add New Invoice','1'),
('2879','VR-23-2879','2023-11-12 00:00:00','0','1250.00','1','2024.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-11-12 17:02:10','2023-11-13 10:34:31',NULL,'1','Update Invoice','1'),
('2880','VR-23-2880','2023-11-12 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-11-12 17:13:03','2023-11-12 17:13:03',NULL,'1','Add New Invoice','1'),
('2881','VR-23-2881','2023-11-12 00:00:00','0','1250.00','1','124.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-11-12 17:13:52','2023-11-12 17:13:52',NULL,'1','Add New Invoice','1'),
('2882','VR-23-2882','2023-11-12 00:00:00','0','1250.00','1','200.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-12 17:17:31','2023-11-12 17:17:31',NULL,'1','Add New Invoice','1'),
('2883','VR-23-2883','2023-11-13 00:00:00','0','1250.00','1','481.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2023-11-13 12:21:55','2023-11-13 12:21:55',NULL,'1','Add New Invoice','1'),
('2884','VR-23-2884','2023-11-13 00:00:00','0','1250.00','1','303.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-11-13 12:37:34','2023-11-13 12:37:34',NULL,'1','Add New Invoice','1'),
('2885','VR-23-2885','2023-11-13 00:00:00','0','1250.00','1','11786.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-13 13:25:44','2023-11-13 13:25:44',NULL,'1','Add New Invoice','1'),
('2886','VR-23-2886','2023-11-13 00:00:00','0','1250.00','1','5813.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-11-13 13:47:46','2023-11-13 13:47:46',NULL,'1','Add New Invoice','1'),
('2887','VR-23-2887','2023-11-13 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2023-11-13 16:15:24','2023-11-13 16:15:24',NULL,'1','Add New Invoice','1'),
('2888','VR-23-2888','2023-11-13 00:00:00','0','1250.00','1','179.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-13 16:19:49','2023-11-15 02:03:15',NULL,'1','Update Invoice','1'),
('2889','VR-23-2889','2023-11-14 00:00:00','0','1250.00','1','1845.87','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-14 10:00:55','2023-11-14 10:00:55',NULL,'1','Add New Invoice','1'),
('2890','VR-23-2890','2023-11-14 00:00:00','0','1250.00','1','187.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-11-14 11:40:35','2023-11-14 11:40:35',NULL,'1','Add New Invoice','1'),
('2891','VR-23-2891','2023-11-14 00:00:00','0','1250.00','1','148.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-11-14 11:58:29','2023-11-14 11:58:29',NULL,'1','Add New Invoice','1'),
('2892','VR-23-2892','2023-11-14 00:00:00','0','1250.00','1','106.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-14 14:29:10','2023-11-14 14:29:10',NULL,'1','Add New Invoice','1'),
('2893','VR-23-2893','2023-11-14 00:00:00','0','1250.00','1','663.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-11-14 14:36:25','2023-11-14 14:36:25',NULL,'1','Add New Invoice','1'),
('2894','VR-23-2894','2023-11-14 00:00:00','0','1250.00','1','1392.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-14 15:32:23','2023-11-14 03:43:51',NULL,'1','Update Invoice','1'),
('2895','INV-23-2895','2023-11-14 00:00:00','0','1250.00','1','382.63','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-14 03:35:06','2023-11-14 03:35:06',NULL,'1','Add New Invoice','1'),
('2896','VR-23-2896','2023-11-14 00:00:00','0','1250.00','1','95.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-14 15:59:02','2023-11-14 15:59:02',NULL,'1','Add New Invoice','1'),
('2897','VR-23-2897','2023-11-14 00:00:00','0','1250.00','1','160.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-14 16:03:38','2023-11-14 16:03:38',NULL,'1','Add New Invoice','1'),
('2898','VR-23-2898','2023-11-14 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','1','2023-11-14 16:08:28','2023-11-14 16:08:28','2023-11-15 12:00:09','1','Delete Invoice','1'),
('2899','VR-23-2899','2023-11-14 00:00:00','0','1250.00','1','481.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-14 16:15:06','2023-11-14 16:15:06',NULL,'1','Add New Invoice','1'),
('2900','VR-23-2900','2023-11-14 00:00:00','0','1250.00','1','54.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-14 16:16:28','2023-11-14 16:16:28',NULL,'1','Add New Invoice','1'),
('2901','VR-23-2901','2023-11-14 00:00:00','0','1250.00','1','90.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-11-14 16:22:35','2023-11-14 16:22:35',NULL,'1','Add New Invoice','1'),
('2902','VR-23-2902','2023-11-14 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2023-11-14 16:23:33','2023-11-14 16:23:33',NULL,'1','Add New Invoice','1'),
('2903','VR-23-2903','2023-11-14 00:00:00','0','1250.00','1','57.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-11-14 16:24:36','2023-11-14 16:24:36',NULL,'1','Add New Invoice','1'),
('2906','VR-23-2904','2023-11-15 00:00:00','0','1250.00','1','4067.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-15 11:37:08','2023-11-15 11:44:00',NULL,'1','Update Invoice','1'),
('2907','VR-23-2907','2023-11-15 00:00:00','0','1250.00','1','653.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-11-15 15:16:15','2023-11-15 15:16:15',NULL,'1','Add New Invoice','1'),
('2908','VR-23-2908','2023-11-15 00:00:00','0','1250.00','1','529.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-11-15 15:31:25','2023-11-15 15:31:25',NULL,'1','Add New Invoice','1'),
('2909','VR-23-2909','2023-11-15 00:00:00','0','1250.00','1','372.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-11-15 15:36:06','2023-11-15 15:36:06',NULL,'1','Add New Invoice','1'),
('2910','VR-23-2910','2023-11-15 00:00:00','0','1250.00','1','136.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-11-15 15:42:46','2023-11-19 09:25:30',NULL,'1','Update Invoice','1'),
('2911','VR-23-2911','2023-11-15 00:00:00','0','1250.00','1','450.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-11-15 15:45:31','2023-11-15 15:45:31',NULL,'1','Add New Invoice','1'),
('2912','VR-23-2912','2023-11-15 00:00:00','0','1250.00','1','292.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-15 15:47:35','2023-11-15 15:47:35',NULL,'1','Add New Invoice','1'),
('2913','VR-23-2913','2023-11-15 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-11-15 15:50:29','2023-11-15 15:50:29',NULL,'1','Add New Invoice','1'),
('2914','VR-23-2914','2023-11-15 00:00:00','0','1250.00','1','88.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-15 15:51:14','2023-11-15 15:51:14',NULL,'1','Add New Invoice','1'),
('2915','VR-23-2915','2023-11-15 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-11-15 15:52:00','2023-11-15 15:52:00',NULL,'1','Add New Invoice','1'),
('2916','VR-23-2916','2023-11-15 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-11-15 15:53:48','2023-11-16 09:48:59',NULL,'1','Update Invoice','1'),
('2917','VR-23-2917','2023-11-15 00:00:00','0','1250.00','1','267.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-11-15 15:59:19','2023-11-15 15:59:19',NULL,'1','Add New Invoice','1'),
('2918','VR-23-2918','2023-11-15 00:00:00','0','1250.00','1','179.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-11-15 16:02:18','2023-11-15 16:02:18',NULL,'1','Add New Invoice','1'),
('2919','VR-23-2919','2023-11-15 00:00:00','0','1250.00','1','103.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-11-15 16:08:06','2023-11-15 16:08:06',NULL,'1','Add New Invoice','1'),
('2920','VR-23-2920','2023-11-16 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-11-16 10:05:35','2023-11-16 10:05:35',NULL,'1','Add New Invoice','1'),
('2921','VR-23-2921','2023-11-16 00:00:00','0','1250.00','1','231.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-16 10:07:44','2023-11-16 10:07:44',NULL,'1','Add New Invoice','1'),
('2922','VR-23-2922','2023-11-16 00:00:00','0','1250.00','1','690.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-16 10:12:50','2023-12-03 12:49:35',NULL,'1','Update Invoice','1'),
('2923','VR-23-2923','2023-11-19 00:00:00','0','1250.00','1','937.48','0.00','اياد عشار بصرة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-19 09:49:52','2023-11-19 09:49:52',NULL,'1','Add New Invoice','1'),
('2924','VR-23-2924','2023-11-19 00:00:00','0','1250.00','1','207.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-11-19 09:51:20','2023-11-19 09:51:20',NULL,'1','Add New Invoice','1'),
('2925','VR-23-2925','2023-11-19 00:00:00','0','1250.00','1','409.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-19 09:55:39','2023-11-19 09:55:39',NULL,'1','Add New Invoice','1'),
('2926','VR-23-2926','2023-11-19 00:00:00','0','1250.00','1','894.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-19 10:06:58','2023-11-19 10:06:58',NULL,'1','Add New Invoice','1'),
('2927','VR-23-2927','2023-11-19 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','1','2023-11-19 10:14:55','2023-11-19 10:14:55','2023-11-20 01:58:09','1','Delete Invoice','1'),
('2928','VR-23-2928','2023-11-19 00:00:00','0','1250.00','1','369.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-19 10:37:26','2023-11-19 10:37:26',NULL,'1','Add New Invoice','1'),
('2929','VR-23-2929','2023-11-19 00:00:00','0','1250.00','1','201.00','0.00','جاسم محسن كوت','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-19 10:40:19','2023-11-19 10:40:19',NULL,'1','Add New Invoice','1'),
('2930','VR-23-2930','2023-11-19 00:00:00','0','1250.00','1','34.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-11-19 10:49:30','2023-11-19 10:49:30',NULL,'1','Add New Invoice','1'),
('2931','INV-23-2931','2023-11-19 00:00:00','0','1250.00','1','239.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-19 03:34:39','2023-11-19 03:34:39',NULL,'1','Add New Invoice','1'),
('2932','INV-23-2932','2023-11-19 00:00:00','0','1250.00','1','486.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-19 03:37:13','2023-11-19 03:37:13',NULL,'1','Add New Invoice','1'),
('2933','VR-23-2933','2023-11-20 00:00:00','0','1250.00','1','689.69','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-20 10:29:09','2023-11-20 10:29:09',NULL,'1','Add New Invoice','1'),
('2934','VR-23-2934','2023-11-20 00:00:00','0','1250.00','1','55.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-11-20 10:48:25','2023-11-20 10:48:25',NULL,'1','Add New Invoice','1'),
('2935','VR-23-2935','2023-11-20 00:00:00','0','1250.00','1','166.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-11-20 12:01:46','2023-11-20 12:01:46',NULL,'1','Add New Invoice','1'),
('2936','VR-23-2936','2023-11-20 00:00:00','0','1250.00','1','374.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-11-20 12:12:52','2023-11-20 12:15:11',NULL,'1','Update Invoice','1'),
('2937','VR-23-2937','2023-11-20 00:00:00','0','1250.00','1','171.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-20 12:17:50','2023-11-20 12:17:50',NULL,'1','Add New Invoice','1'),
('2938','VR-23-2938','2023-11-20 00:00:00','0','1250.00','1','413.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-11-20 12:20:53','2023-11-20 12:20:53',NULL,'1','Add New Invoice','1'),
('2939','VR-23-2939','2023-11-20 00:00:00','0','1250.00','1','420.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-11-20 12:22:15','2023-11-20 12:22:15',NULL,'1','Add New Invoice','1'),
('2940','VR-23-2940','2023-11-21 00:00:00','0','1250.00','1','6013.90','0.00','ناصرية سوق شيوخ صادق حاج غازي','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-21 10:11:54','2023-11-27 09:45:18',NULL,'1','Update Invoice','1'),
('2941','VR-23-2941','2023-11-21 00:00:00','0','1250.00','1','5476.65','0.00','هاني ناصرية سوق شيوخ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-21 10:51:06','2023-11-21 10:51:06',NULL,'1','Add New Invoice','1'),
('2942','VR-23-2942','2023-11-22 00:00:00','0','1250.00','1','68.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-11-22 10:29:07','2023-11-22 10:29:07',NULL,'1','Add New Invoice','1'),
('2943','VR-23-2943','2023-11-22 00:00:00','0','1250.00','1','198.49','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-22 10:33:08','2023-11-22 10:33:08',NULL,'1','Add New Invoice','1'),
('2944','VR-23-2944','2023-11-23 00:00:00','0','1250.00','1','5643.91','0.00','د. عباس حلة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-23 09:42:49','2025-05-12 08:43:05',NULL,'1','Update Invoice','1'),
('2945','VR-23-2945','2023-11-23 00:00:00','0','1250.00','1','998.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-23 10:07:42','2023-11-23 10:07:42',NULL,'1','Add New Invoice','1'),
('2946','VR-23-2946','2023-11-23 00:00:00','0','1250.00','1','60.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-11-23 14:28:17','2023-11-23 14:28:17',NULL,'1','Add New Invoice','1'),
('2947','VR-23-2947','2023-11-23 00:00:00','0','1250.00','1','70.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-11-23 14:31:48','2023-11-23 14:31:48',NULL,'1','Add New Invoice','1'),
('2948','VR-23-2948','2023-11-23 00:00:00','0','1250.00','1','974.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-11-23 14:39:46','2023-11-23 14:39:46',NULL,'1','Add New Invoice','1'),
('2949','VR-23-2949','2023-11-23 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-11-23 14:40:39','2023-11-23 14:40:39',NULL,'1','Add New Invoice','1'),
('2950','VR-23-2950','2023-11-23 00:00:00','0','1250.00','1','581.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-23 14:48:02','2023-11-23 14:48:02',NULL,'1','Add New Invoice','1'),
('2951','VR-23-2951','2023-11-23 00:00:00','0','1250.00','1','705.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-23 14:59:20','2023-11-23 14:59:20',NULL,'1','Add New Invoice','1'),
('2952','VR-23-2952','2023-11-23 00:00:00','0','1250.00','1','159.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-11-23 15:02:24','2023-11-23 15:02:24',NULL,'1','Add New Invoice','1'),
('2953','VR-23-2953','2023-11-23 00:00:00','0','1250.00','1','271.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-11-23 15:06:32','2023-11-23 03:06:56',NULL,'1','Update Invoice','1'),
('2954','VR-23-2954','2023-11-23 00:00:00','0','1250.00','1','142.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-11-23 15:09:43','2023-11-23 15:09:43',NULL,'1','Add New Invoice','1'),
('2955','VR-23-2955','2023-11-23 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-11-23 15:10:50','2023-11-25 09:17:53',NULL,'1','Update Invoice','1'),
('2956','VR-23-2956','2023-11-25 00:00:00','0','1250.00','1','438.12','0.00','محمد دويب كوت ستائر','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-25 09:54:53','2023-11-27 09:42:41',NULL,'1','Update Invoice','1'),
('2957','VR-23-2957','2023-11-25 00:00:00','0','1250.00','1','418.32','0.00','علي اياد نجف','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-25 09:57:29','2023-11-27 09:42:19',NULL,'1','Update Invoice','1'),
('2958','VR-23-2958','2023-11-25 00:00:00','0','1250.00','1','32.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-11-25 10:03:57','2023-11-25 10:03:57',NULL,'1','Add New Invoice','1'),
('2959','VR-23-2959','2023-11-25 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-11-25 10:04:55','2023-11-25 10:04:55',NULL,'1','Add New Invoice','1'),
('2960','VR-23-2960','2023-11-25 00:00:00','0','1250.00','1','303.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-25 10:06:41','2023-11-25 10:06:41',NULL,'1','Add New Invoice','1'),
('2961','VR-23-2961','2023-11-25 00:00:00','0','1250.00','1','1500.49','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-11-25 10:21:20','2023-11-25 10:21:20',NULL,'1','Add New Invoice','1'),
('2962','VR-23-2962','2023-11-25 00:00:00','0','1250.00','1','279.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-11-25 10:39:03','2023-11-25 12:07:10',NULL,'1','Update Invoice','1'),
('2963','VR-23-2963','2023-11-25 00:00:00','0','1250.00','1','221.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-25 10:45:18','2023-11-25 10:45:18',NULL,'1','Add New Invoice','1'),
('2964','VR-23-2964','2023-11-26 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-11-26 10:46:49','2023-11-26 10:46:49',NULL,'1','Add New Invoice','1'),
('2965','VR-23-2965','2023-11-26 00:00:00','0','1250.00','1','358.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2023-11-26 10:49:30','2023-11-27 02:08:40',NULL,'1','Update Invoice','1'),
('2966','VR-23-2966','2023-11-26 00:00:00','0','1250.00','1','296.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-11-26 10:51:18','2023-11-26 10:51:18',NULL,'1','Add New Invoice','1'),
('2967','VR-23-2967','2023-11-26 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-11-26 10:53:52','2023-11-26 10:53:52',NULL,'1','Add New Invoice','1'),
('2968','VR-23-2968','2023-11-26 00:00:00','0','1250.00','1','2365.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-11-26 11:00:46','2023-11-26 11:00:46',NULL,'1','Add New Invoice','1'),
('2969','VR-23-2969','2023-11-26 00:00:00','0','1250.00','1','389.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-26 11:12:41','2023-11-26 11:12:41',NULL,'1','Add New Invoice','1'),
('2970','VR-23-2970','2023-11-26 00:00:00','0','1250.00','1','117.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-11-26 11:16:53','2023-11-26 11:16:53',NULL,'1','Add New Invoice','1'),
('2971','VR-23-2971','2023-11-26 00:00:00','0','1250.00','1','276.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-26 11:25:12','2023-11-26 11:25:12',NULL,'1','Add New Invoice','1'),
('2972','VR-23-2972','2023-11-26 00:00:00','0','1250.00','1','410.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-11-26 11:28:09','2023-11-26 11:28:42',NULL,'1','Update Invoice','1'),
('2973','VR-23-2973','2023-11-26 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-11-26 11:41:28','2023-11-26 11:41:28',NULL,'1','Add New Invoice','1'),
('2974','VR-23-2974','2023-11-26 00:00:00','0','1250.00','1','191.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-11-26 11:45:56','2023-11-26 11:45:56',NULL,'1','Add New Invoice','1'),
('2975','VR-23-2975','2023-11-26 00:00:00','0','1250.00','1','350.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-26 11:51:43','2023-11-26 11:51:43',NULL,'1','Add New Invoice','1'),
('2976','VR-23-2976','2023-11-26 00:00:00','0','1250.00','1','201.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-11-26 12:03:10','2023-11-26 12:03:10',NULL,'1','Add New Invoice','1'),
('2977','INV-23-2977','2023-11-27 00:00:00','0','1250.00','1','192.78','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-11-27 03:36:28','2023-11-27 03:36:28',NULL,'1','Add New Invoice','1'),
('2978','INV-23-2978','2023-11-27 00:00:00','0','1250.00','1','45.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-27 03:40:43','2023-11-27 03:40:43',NULL,'1','Add New Invoice','1'),
('2979','INV-23-2979','2023-11-27 00:00:00','0','1250.00','1','87.12','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-27 03:45:38','2023-11-27 03:45:38',NULL,'1','Add New Invoice','1'),
('2980','VR-23-2980','2023-11-28 00:00:00','0','1250.00','1','9970.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-28 12:37:10','2023-11-28 12:37:10',NULL,'1','Add New Invoice','1'),
('2981','VR-23-2981','2023-11-28 00:00:00','0','1250.00','1','13233.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-28 13:45:12','2023-11-28 13:45:12',NULL,'1','Add New Invoice','1'),
('2982','VR-23-2982','2023-11-28 00:00:00','0','1250.00','1','4641.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-28 14:02:11','2023-12-06 10:32:46',NULL,'1','Update Invoice','1'),
('2983','VR-23-2983','2023-11-28 00:00:00','0','1250.00','1','1176.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-28 14:21:17','2023-11-30 02:48:03',NULL,'1','Update Invoice','1'),
('2984','VR-23-2984','2023-11-29 00:00:00','0','1250.00','1','2922.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-29 12:06:57','2023-11-29 12:06:57',NULL,'1','Add New Invoice','1'),
('2985','VR-23-2985','2023-11-29 00:00:00','0','1250.00','1','666.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-29 14:40:51','2023-11-29 14:40:51',NULL,'1','Add New Invoice','1'),
('2986','VR-23-2986','2023-11-29 00:00:00','0','1250.00','1','199.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-11-29 14:48:47','2023-11-29 14:48:47',NULL,'1','Add New Invoice','1'),
('2987','VR-23-2987','2023-11-29 00:00:00','0','1250.00','1','156.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-11-29 14:55:17','2023-11-29 14:55:17',NULL,'1','Add New Invoice','1'),
('2988','VR-23-2988','2023-11-29 00:00:00','0','1250.00','1','310.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-11-29 14:58:59','2023-11-29 14:58:59',NULL,'1','Add New Invoice','1'),
('2989','VR-23-2989','2023-11-29 00:00:00','0','1250.00','1','777.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-29 15:11:22','2023-11-29 15:11:22',NULL,'1','Add New Invoice','1'),
('2990','VR-23-2990','2023-11-29 00:00:00','0','1250.00','1','874.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-11-29 15:14:52','2023-11-29 15:14:52',NULL,'1','Add New Invoice','1'),
('2991','VR-23-2991','2023-11-29 00:00:00','0','1250.00','1','491.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-11-29 15:25:55','2023-11-29 15:25:55',NULL,'1','Add New Invoice','1'),
('2992','VR-23-2992','2023-11-29 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-11-29 15:35:07','2023-11-29 15:35:07',NULL,'1','Add New Invoice','1'),
('2993','VR-23-2993','2023-11-29 00:00:00','0','1250.00','1','279.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-11-29 15:46:57','2023-11-29 15:46:57',NULL,'1','Add New Invoice','1'),
('2994','VR-23-2994','2023-11-29 00:00:00','0','1250.00','1','124.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-11-29 15:55:45','2023-11-29 15:55:45',NULL,'1','Add New Invoice','1'),
('2995','VR-23-2995','2023-11-30 00:00:00','0','1250.00','1','54.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','1','2023-11-30 10:36:37','2023-11-30 10:36:37','2023-11-30 02:45:08','1','Delete Invoice','1'),
('2996','VR-23-2996','2023-11-30 00:00:00','0','1250.00','1','1439.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-11-30 10:43:41','2023-11-30 10:43:41',NULL,'1','Add New Invoice','1'),
('2997','VR-23-2997','2023-11-30 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-11-30 11:30:33','2023-11-30 11:30:33',NULL,'1','Add New Invoice','1'),
('2998','VR-23-2998','2023-11-30 00:00:00','0','1250.00','1','488.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-11-30 11:31:58','2023-11-30 02:52:21',NULL,'1','Update Invoice','1'),
('2999','VR-23-2999','2023-11-30 00:00:00','0','1250.00','1','263.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-11-30 11:48:46','2023-11-30 11:48:46',NULL,'1','Add New Invoice','1'),
('3000','VR-23-3000','2023-11-30 00:00:00','0','1250.00','1','188.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-11-30 14:03:59','2023-11-30 14:03:59',NULL,'1','Add New Invoice','1'),
('3001','VR-23-3001','2023-11-30 00:00:00','0','1250.00','1','161.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-11-30 14:06:45','2023-11-30 14:06:45',NULL,'1','Add New Invoice','1'),
('3002','VR-23-3002','2023-11-30 00:00:00','0','1250.00','1','616.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-11-30 14:12:02','2023-11-30 02:50:03',NULL,'1','Update Invoice','1'),
('3003','VR-23-3003','2023-11-30 00:00:00','0','1250.00','1','29.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-11-30 14:13:20','2023-11-30 14:13:20',NULL,'1','Add New Invoice','1'),
('3004','VR-23-3004','2023-11-30 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-11-30 14:13:53','2023-11-30 14:13:53',NULL,'1','Add New Invoice','1'),
('3005','VR-23-3005','2023-11-30 00:00:00','0','1250.00','1','264.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-11-30 14:17:48','2023-11-30 14:17:48',NULL,'1','Add New Invoice','1'),
('3006','VR-23-3006','2023-11-30 00:00:00','0','1250.00','1','119.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-11-30 14:20:12','2023-11-30 14:20:12',NULL,'1','Add New Invoice','1'),
('3007','VR-23-3007','2023-11-30 00:00:00','0','1250.00','1','3069.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-11-30 14:25:24','2023-11-30 14:25:24',NULL,'1','Add New Invoice','1'),
('3008','VR-23-3008','2023-11-30 00:00:00','0','1250.00','1','1087.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-11-30 14:33:03','2023-11-30 14:33:03',NULL,'1','Add New Invoice','1'),
('3009','VR-23-3009','2023-11-30 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-11-30 14:35:41','2023-11-30 14:35:41',NULL,'1','Add New Invoice','1'),
('3010','VR-23-3010','2023-11-30 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-11-30 14:36:50','2023-11-30 14:36:50',NULL,'1','Add New Invoice','1'),
('3011','VR-23-3011','2023-11-30 00:00:00','0','1250.00','1','86.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-11-30 14:39:56','2023-11-30 14:39:56',NULL,'1','Add New Invoice','1'),
('3012','VR-23-3012','2023-12-02 00:00:00','0','1250.00','1','215.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','109','0','2023-12-02 11:16:13','2023-12-02 11:16:13',NULL,'1','Add New Invoice','1'),
('3013','VR-23-3013','2023-12-02 00:00:00','0','1250.00','1','516.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-12-02 11:45:49','2023-12-03 12:49:00',NULL,'1','Update Invoice','1'),
('3014','VR-23-3014','2023-12-02 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-12-02 11:46:48','2023-12-03 10:57:01',NULL,'1','Update Invoice','1'),
('3015','VR-23-3015','2023-12-02 00:00:00','0','1250.00','1','163.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-02 11:50:04','2023-12-02 11:50:04',NULL,'1','Add New Invoice','1'),
('3016','VR-23-3016','2023-12-02 00:00:00','0','1250.00','1','54.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-12-02 11:52:37','2023-12-02 11:52:37',NULL,'1','Add New Invoice','1'),
('3017','VR-23-3017','2023-12-02 00:00:00','0','1250.00','1','104.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-02 12:09:37','2023-12-02 12:09:37',NULL,'1','Add New Invoice','1'),
('3018','VR-23-3018','2023-12-03 00:00:00','0','1250.00','1','741.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-03 10:27:25','2023-12-03 10:45:44',NULL,'1','Update Invoice','1'),
('3019','VR-23-3019','2023-12-03 00:00:00','0','1250.00','1','750.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-03 10:33:06','2023-12-03 10:33:06',NULL,'1','Add New Invoice','1'),
('3020','VR-23-3020','2023-12-03 00:00:00','0','1250.00','1','264.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-03 10:35:44','2023-12-03 10:35:44',NULL,'1','Add New Invoice','1'),
('3021','VR-23-3021','2023-12-03 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-12-03 10:36:41','2023-12-03 10:36:41',NULL,'1','Add New Invoice','1'),
('3022','VR-23-3022','2023-12-03 00:00:00','0','1250.00','1','613.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-03 10:38:39','2023-12-03 10:38:39',NULL,'1','Add New Invoice','1'),
('3023','VR-23-3023','2023-12-03 00:00:00','0','1250.00','1','120.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-03 10:53:45','2023-12-03 10:53:45',NULL,'1','Add New Invoice','1'),
('3024','VR-23-3024','2023-12-03 00:00:00','0','1250.00','1','204.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-03 10:55:52','2023-12-03 10:55:52',NULL,'1','Add New Invoice','1'),
('3025','VR-23-3025','2023-12-03 00:00:00','0','1250.00','1','507.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-12-03 11:13:37','2023-12-03 11:13:37',NULL,'1','Add New Invoice','1'),
('3026','VR-23-3026','2023-12-03 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-12-03 13:24:45','2023-12-03 13:24:45',NULL,'1','Add New Invoice','1'),
('3027','INV-23-3027','2023-12-03 00:00:00','0','1250.00','1','508.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-12-03 04:35:53','2023-12-03 04:35:53',NULL,'1','Add New Invoice','1'),
('3028','VR-23-3028','2023-12-04 00:00:00','0','1250.00','1','338.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-04 14:26:50','2023-12-04 14:26:50',NULL,'1','Add New Invoice','1'),
('3029','VR-23-3029','2023-12-05 00:00:00','0','1250.00','1','840.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-12-05 10:34:38','2023-12-05 10:34:38',NULL,'1','Add New Invoice','1'),
('3030','VR-23-3030','2023-12-05 00:00:00','0','1250.00','1','94.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-05 10:37:45','2023-12-05 10:37:45',NULL,'1','Add New Invoice','1'),
('3031','VR-23-3031','2023-12-05 00:00:00','0','1250.00','1','350.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-12-05 10:50:20','2023-12-05 10:50:20',NULL,'1','Add New Invoice','1'),
('3032','VR-23-3032','2023-12-05 00:00:00','0','1250.00','1','381.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-05 15:12:38','2023-12-05 15:12:38',NULL,'1','Add New Invoice','1'),
('3033','VR-23-3033','2023-12-05 00:00:00','0','1250.00','1','799.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-05 15:38:32','2023-12-05 15:38:32',NULL,'1','Add New Invoice','1'),
('3034','VR-23-3034','2023-12-06 00:00:00','0','1250.00','1','324.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-12-06 10:57:26','2023-12-06 10:57:26',NULL,'1','Add New Invoice','1'),
('3035','VR-23-3035','2023-12-06 00:00:00','0','1250.00','1','269.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-06 11:57:46','2023-12-06 11:57:46',NULL,'1','Add New Invoice','1'),
('3036','VR-23-3036','2023-12-06 00:00:00','0','1250.00','1','190.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-12-06 12:04:04','2023-12-06 12:04:04',NULL,'1','Add New Invoice','1'),
('3037','VR-23-3037','2023-12-06 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-12-06 12:10:19','2023-12-06 12:10:19',NULL,'1','Add New Invoice','1'),
('3038','VR-23-3038','2023-12-06 00:00:00','0','1250.00','1','125.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-06 12:11:12','2023-12-06 12:21:42',NULL,'1','Update Invoice','1'),
('3039','VR-23-3039','2023-12-06 00:00:00','0','1250.00','1','691.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-06 12:20:31','2023-12-06 12:20:31',NULL,'1','Add New Invoice','1'),
('3040','VR-23-3040','2023-12-06 00:00:00','0','1250.00','1','457.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2023-12-06 12:24:08','2023-12-09 02:16:49',NULL,'1','Update Invoice','1'),
('3041','VR-23-3041','2023-12-07 00:00:00','0','1250.00','1','166.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','117','1','2023-12-07 09:35:06','2023-12-07 09:35:06','2023-12-09 01:23:54','1','Delete Invoice','1'),
('3042','INV-23-3042','2023-12-07 00:00:00','0','1250.00','1','192.15','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-12-07 09:56:12','2023-12-07 09:56:12',NULL,'1','Add New Invoice','1'),
('3043','VR-23-3043','2023-12-07 00:00:00','0','1250.00','1','6711.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-07 13:06:51','2023-12-07 13:06:51',NULL,'1','Add New Invoice','1'),
('3044','VR-23-3044','2023-12-07 00:00:00','0','1250.00','1','6640.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-07 13:38:55','2023-12-07 13:38:55',NULL,'1','Add New Invoice','1'),
('3045','VR-23-3045','2023-12-07 00:00:00','0','1250.00','1','3297.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-12-07 13:47:25','2023-12-07 13:47:25',NULL,'1','Add New Invoice','1'),
('3046','VR-23-3046','2023-12-07 00:00:00','0','1250.00','1','117.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-12-07 15:20:52','2023-12-07 15:20:52',NULL,'1','Add New Invoice','1'),
('3047','VR-23-3047','2023-12-09 00:00:00','0','1250.00','1','1081.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-09 12:58:05','2023-12-09 12:58:05',NULL,'1','Add New Invoice','1'),
('3048','VR-23-3048','2023-12-09 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-12-09 13:10:36','2023-12-09 13:10:36',NULL,'1','Add New Invoice','1'),
('3049','VR-23-3049','2023-12-09 00:00:00','0','1250.00','1','622.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-09 13:23:11','2023-12-09 13:23:11',NULL,'1','Add New Invoice','1'),
('3050','VR-23-3050','2023-12-09 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-09 14:12:15','2023-12-09 14:12:15',NULL,'1','Add New Invoice','1'),
('3051','VR-23-3051','2023-12-09 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2023-12-10 15:51:47','2023-12-12 09:18:22',NULL,'1','Update Invoice','1'),
('3052','VR-23-3052','2023-12-10 00:00:00','0','1250.00','1','44.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-12-10 16:14:57','2023-12-10 16:14:57',NULL,'1','Add New Invoice','1'),
('3053','VR-23-3053','2023-12-10 00:00:00','0','1250.00','1','260.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-10 16:24:42','2023-12-24 09:48:13',NULL,'1','Update Invoice','1'),
('3054','VR-23-3054','2023-12-11 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-11 09:41:21','2023-12-11 09:41:21',NULL,'1','Add New Invoice','1'),
('3055','VR-23-3055','2023-12-11 00:00:00','0','1250.00','1','2990.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-11 09:59:28','2023-12-11 09:59:28',NULL,'1','Add New Invoice','1'),
('3056','VR-23-3056','2023-12-11 00:00:00','0','1250.00','1','341.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-12-11 10:04:01','2023-12-11 10:04:01',NULL,'1','Add New Invoice','1'),
('3057','VR-23-3057','2023-12-11 00:00:00','0','1250.00','1','160.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-12-11 10:18:37','2023-12-11 10:18:37',NULL,'1','Add New Invoice','1'),
('3058','VR-23-3058','2023-12-11 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-11 11:50:32','2023-12-11 11:50:32',NULL,'1','Add New Invoice','1'),
('3059','VR-23-3059','2023-12-12 00:00:00','0','1250.00','1','436.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-12 10:06:54','2023-12-12 10:06:54',NULL,'1','Add New Invoice','1'),
('3060','VR-23-3060','2023-12-12 00:00:00','0','1250.00','1','1042.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-12-12 10:14:26','2023-12-12 10:14:26',NULL,'1','Add New Invoice','1'),
('3061','VR-23-3061','2023-12-12 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-12 11:08:49','2023-12-12 11:08:49',NULL,'1','Add New Invoice','1'),
('3062','VR-23-3062','2023-12-12 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-12-12 11:12:34','2023-12-12 11:12:34',NULL,'1','Add New Invoice','1'),
('3063','VR-23-3063','2023-12-12 00:00:00','0','1250.00','1','160.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','107','0','2023-12-12 11:14:20','2023-12-12 11:14:20',NULL,'1','Add New Invoice','1'),
('3064','VR-23-3064','2023-12-12 00:00:00','0','1250.00','1','629.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-12 11:19:38','2023-12-12 11:19:38',NULL,'1','Add New Invoice','1'),
('3065','INV-23-3065','2023-12-12 00:00:00','0','1250.00','1','88.77','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-12-12 11:24:53','2023-12-12 11:24:53',NULL,'1','Add New Invoice','1'),
('3066','INV-23-3066','2023-12-12 00:00:00','0','1250.00','1','51.12','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-12 11:26:52','2023-12-12 11:26:52',NULL,'1','Add New Invoice','1'),
('3067','VR-23-3067','2023-12-13 00:00:00','0','1250.00','1','460.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-12-13 10:15:27','2023-12-13 10:15:27',NULL,'1','Add New Invoice','1'),
('3068','VR-23-3068','2023-12-13 00:00:00','0','1250.00','1','96.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-12-13 10:16:36','2023-12-13 10:19:32',NULL,'1','Update Invoice','1'),
('3069','VR-23-3069','2023-12-13 00:00:00','0','1250.00','1','212.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-13 10:21:33','2023-12-13 10:46:47',NULL,'1','Update Invoice','1'),
('3070','VR-23-3070','2023-12-13 00:00:00','0','1250.00','1','298.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-13 10:33:49','2023-12-13 10:33:49',NULL,'1','Add New Invoice','1'),
('3071','VR-23-3071','2023-12-13 00:00:00','0','1250.00','1','1763.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-13 10:52:32','2023-12-13 10:52:32',NULL,'1','Add New Invoice','1'),
('3072','VR-23-3072','2023-12-13 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2023-12-13 10:54:03','2023-12-13 10:54:03',NULL,'1','Add New Invoice','1'),
('3073','VR-23-3073','2023-12-13 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-12-13 12:02:58','2023-12-13 12:02:58',NULL,'1','Add New Invoice','1'),
('3074','VR-23-3074','2023-12-13 00:00:00','0','1250.00','1','135.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-12-13 15:38:23','2023-12-14 11:37:37',NULL,'1','Update Invoice','1'),
('3075','VR-23-3075','2023-12-13 00:00:00','0','1250.00','1','1280.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-13 15:43:17','2023-12-13 04:05:46',NULL,'1','Update Invoice','1'),
('3076','VR-23-3076','2023-12-13 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-12-13 16:04:42','2023-12-13 16:04:42',NULL,'1','Add New Invoice','1'),
('3077','VR-23-3077','2023-12-13 00:00:00','0','1250.00','1','167.40','0.00','محمد دويب كوت ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-13 16:08:05','2023-12-13 16:08:05',NULL,'1','Add New Invoice','1'),
('3078','VR-23-3078','2023-12-13 00:00:00','0','1250.00','1','251.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-13 16:27:19','2023-12-13 16:27:19',NULL,'1','Add New Invoice','1'),
('3079','VR-23-3079','2023-12-13 00:00:00','0','1250.00','1','539.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-12-13 16:33:49','2023-12-13 16:33:49',NULL,'1','Add New Invoice','1'),
('3080','VR-23-3080','2023-12-13 00:00:00','0','1250.00','1','2974.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-12-13 16:37:44','2023-12-13 16:37:44',NULL,'1','Add New Invoice','1'),
('3081','VR-23-3081','2023-12-13 00:00:00','0','1250.00','1','1659.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-13 16:45:45','2023-12-13 16:45:45',NULL,'1','Add New Invoice','1'),
('3082','VR-23-3082','2023-12-13 00:00:00','0','1250.00','1','53.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-13 16:46:54','2023-12-13 04:48:47',NULL,'1','Update Invoice','1'),
('3083','VR-23-3083','2023-12-13 00:00:00','0','1250.00','1','688.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','1','2023-12-13 16:49:02','2023-12-13 16:49:02','2023-12-14 11:58:00','1','Delete Invoice','1'),
('3084','VR-23-3084','2023-12-13 00:00:00','0','1250.00','1','92.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-12-13 16:50:00','2023-12-13 16:50:00',NULL,'1','Add New Invoice','1'),
('3085','VR-23-3085','2023-12-13 00:00:00','0','1250.00','1','346.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-12-13 16:53:21','2023-12-13 16:53:21',NULL,'1','Add New Invoice','1'),
('3086','VR-23-3086','2023-12-13 00:00:00','0','1250.00','1','490.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-12-13 16:56:58','2023-12-13 16:56:58',NULL,'1','Add New Invoice','1'),
('3087','VR-23-3087','2023-12-13 00:00:00','0','1250.00','1','134.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-13 17:02:57','2023-12-13 17:02:57',NULL,'1','Add New Invoice','1'),
('3088','VR-23-3088','2023-12-13 00:00:00','0','1250.00','1','64.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-13 17:05:21','2023-12-13 17:05:21',NULL,'1','Add New Invoice','1'),
('3089','VR-23-3089','2023-12-13 00:00:00','0','1250.00','1','172.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-12-13 17:09:39','2023-12-13 05:12:30',NULL,'1','Update Invoice','1'),
('3090','VR-23-3090','2023-12-13 00:00:00','0','1250.00','1','659.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-12-13 17:10:57','2023-12-13 17:10:57',NULL,'1','Add New Invoice','1'),
('3091','VR-23-3091','2023-12-13 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-12-13 17:11:40','2023-12-13 17:11:40',NULL,'1','Add New Invoice','1'),
('3092','VR-23-3092','2023-12-13 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-12-13 17:13:52','2023-12-13 17:13:52',NULL,'1','Add New Invoice','1'),
('3093','VR-23-3093','2023-12-13 00:00:00','0','1250.00','1','56.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-12-13 17:16:26','2023-12-13 17:16:26',NULL,'1','Add New Invoice','1'),
('3094','VR-23-3094','2023-12-13 00:00:00','0','1250.00','1','241.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2023-12-13 17:18:08','2023-12-13 17:18:08',NULL,'1','Add New Invoice','1'),
('3095','VR-23-3095','2023-12-13 00:00:00','0','1250.00','1','182.32','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-12-13 17:19:57','2023-12-14 01:48:35',NULL,'1','Update Invoice','1'),
('3096','VR-23-3096','2023-12-13 00:00:00','0','1250.00','1','101.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-13 17:20:36','2023-12-13 17:20:36',NULL,'1','Add New Invoice','1'),
('3097','VR-23-3097','2023-12-13 00:00:00','0','1250.00','1','417.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-12-13 17:22:16','2023-12-13 17:22:16',NULL,'1','Add New Invoice','1'),
('3098','VR-23-3098','2023-12-14 00:00:00','0','1250.00','1','170.34','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-14 10:19:06','2023-12-14 10:38:37',NULL,'1','Update Invoice','1'),
('3099','VR-23-3099','2023-12-14 00:00:00','0','1250.00','1','111.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-14 10:40:51','2023-12-14 11:49:29',NULL,'1','Update Invoice','1'),
('3100','VR-23-3100','2023-12-14 00:00:00','0','1250.00','1','141.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-14 11:46:33','2023-12-14 11:46:33',NULL,'1','Add New Invoice','1'),
('3101','VR-23-3101','2023-12-14 00:00:00','0','1250.00','1','198.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-12-14 11:52:05','2023-12-14 11:52:05',NULL,'1','Add New Invoice','1'),
('3102','VR-23-3102','2023-12-14 00:00:00','0','1250.00','1','283.15','0.00','امير سيدار الكرادة ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-14 12:39:53','2023-12-14 12:39:53',NULL,'1','Add New Invoice','1'),
('3103','VR-23-3103','2023-12-14 00:00:00','0','1250.00','1','791.70','0.00','دكتور عباس حلة ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-14 13:42:06','2023-12-14 13:42:06',NULL,'1','Add New Invoice','1'),
('3104','VR-23-3104','2023-12-14 00:00:00','0','1250.00','1','1918.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-12-14 13:47:19','2023-12-14 13:47:19',NULL,'1','Add New Invoice','1'),
('3105','VR-23-3105','2023-12-14 00:00:00','0','1250.00','1','127.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-12-14 14:39:42','2023-12-14 14:39:42',NULL,'1','Add New Invoice','1'),
('3106','VR-23-3106','2023-12-16 00:00:00','0','1250.00','1','2321.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-12-16 10:55:49','2023-12-16 10:55:49',NULL,'1','Add New Invoice','1'),
('3107','VR-23-3107','2023-12-16 00:00:00','0','1250.00','1','124.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-16 12:17:49','2023-12-16 12:17:49',NULL,'1','Add New Invoice','1'),
('3108','VR-23-3108','2023-12-16 00:00:00','0','1250.00','1','96.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-16 12:59:38','2024-08-05 04:38:48',NULL,'1','Update Invoice','1'),
('3109','VR-23-3109','2023-12-16 00:00:00','0','1250.00','1','194.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2023-12-16 13:17:44','2023-12-16 13:17:44',NULL,'1','Add New Invoice','1'),
('3110','VR-23-3110','2023-12-16 00:00:00','0','1250.00','1','1005.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2023-12-16 13:24:40','2023-12-16 13:24:40',NULL,'1','Add New Invoice','1'),
('3111','VR-23-3111','2023-12-17 00:00:00','0','1250.00','1','255.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-17 09:55:49','2023-12-24 09:10:31',NULL,'1','Update Invoice','1'),
('3112','VR-23-3112','2023-12-17 00:00:00','0','1250.00','1','45.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2023-12-17 10:50:31','2023-12-17 10:50:31',NULL,'1','Add New Invoice','1'),
('3113','VR-23-3113','2023-12-17 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2023-12-17 11:04:54','2023-12-17 11:04:54',NULL,'1','Add New Invoice','1'),
('3114','VR-23-3114','2023-12-17 00:00:00','0','1250.00','1','447.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-17 11:44:21','2023-12-17 11:44:21',NULL,'1','Add New Invoice','1'),
('3115','VR-23-3115','2023-12-17 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-12-17 11:45:06','2023-12-17 11:45:06',NULL,'1','Add New Invoice','1'),
('3116','VR-23-3116','2023-12-17 00:00:00','0','1250.00','1','54.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2023-12-17 12:02:23','2023-12-17 12:02:23',NULL,'1','Add New Invoice','1'),
('3117','VR-23-3117','2023-12-17 00:00:00','0','1250.00','1','135.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-17 12:10:14','2023-12-17 12:10:14',NULL,'1','Add New Invoice','1'),
('3118','VR-23-3118','2023-12-17 00:00:00','0','1250.00','1','218.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-17 12:30:08','2023-12-17 12:31:01',NULL,'1','Update Invoice','1'),
('3119','VR-23-3119','2023-12-17 00:00:00','0','1250.00','1','24.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-12-17 12:34:45','2023-12-17 12:34:45',NULL,'1','Add New Invoice','1'),
('3120','VR-23-3120','2023-12-17 00:00:00','0','1250.00','1','55.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-12-17 12:56:13','2023-12-17 01:00:01',NULL,'1','Update Invoice','1'),
('3121','VR-23-3121','2023-12-17 00:00:00','0','1250.00','1','259.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-17 13:03:50','2023-12-17 13:03:50',NULL,'1','Add New Invoice','1'),
('3122','VR-23-3122','2023-12-17 00:00:00','0','1250.00','1','103.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-17 14:24:03','2023-12-17 14:24:03',NULL,'1','Add New Invoice','1'),
('3123','VR-23-3123','2023-12-17 00:00:00','0','1250.00','1','133.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-17 15:36:13','2023-12-17 15:36:13',NULL,'1','Add New Invoice','1'),
('3124','VR-23-3124','2023-12-18 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-12-18 10:01:25','2023-12-18 10:01:25',NULL,'1','Add New Invoice','1'),
('3125','VR-23-3125','2023-12-18 00:00:00','0','1250.00','1','107.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-18 10:07:02','2023-12-18 10:07:02',NULL,'1','Add New Invoice','1'),
('3126','VR-23-3126','2023-12-18 00:00:00','0','1250.00','1','500.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-18 10:59:22','2023-12-18 10:59:22',NULL,'1','Add New Invoice','1'),
('3127','VR-23-3127','2023-12-18 00:00:00','0','1250.00','1','380.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-12-18 11:22:53','2023-12-18 11:22:53',NULL,'1','Add New Invoice','1'),
('3128','VR-23-3128','2023-12-18 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-18 11:27:22','2023-12-18 11:27:22',NULL,'1','Add New Invoice','1'),
('3129','VR-23-3129','2023-12-18 00:00:00','0','1250.00','1','562.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2023-12-18 11:55:51','2023-12-18 11:55:51',NULL,'1','Add New Invoice','1'),
('3130','VR-23-3130','2023-12-18 00:00:00','0','1250.00','1','170.80','0.00','حسين عليوي ناصرية','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-18 13:38:19','2023-12-18 13:38:19',NULL,'1','Add New Invoice','1'),
('3131','VR-23-3131','2023-12-18 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-18 13:54:33','2023-12-18 13:54:33',NULL,'1','Add New Invoice','1'),
('3132','VR-23-3132','2023-12-18 00:00:00','0','1250.00','1','79.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-18 14:07:59','2024-08-05 04:39:19',NULL,'1','Update Invoice','1'),
('3133','VR-23-3133','2023-12-18 00:00:00','0','1250.00','1','140.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2023-12-18 14:27:29','2023-12-18 14:27:29',NULL,'1','Add New Invoice','1'),
('3134','VR-23-3134','2023-12-18 00:00:00','0','1250.00','1','30.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-18 14:30:00','2023-12-18 14:30:00',NULL,'1','Add New Invoice','1'),
('3135','VR-23-3135','2023-12-18 00:00:00','0','1250.00','1','115.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-18 14:50:50','2023-12-18 14:50:50',NULL,'1','Add New Invoice','1'),
('3136','VR-23-3136','2023-12-18 00:00:00','0','1250.00','1','95.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-12-18 14:58:35','2023-12-19 10:14:59',NULL,'1','Update Invoice','1'),
('3137','VR-23-3137','2023-12-19 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-19 10:11:55','2023-12-19 10:11:55',NULL,'1','Add New Invoice','1'),
('3138','VR-23-3138','2023-12-19 00:00:00','0','1250.00','1','238.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-19 14:52:10','2023-12-19 03:08:15',NULL,'1','Update Invoice','1'),
('3139','VR-23-3139','2023-12-21 00:00:00','0','1250.00','1','161.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-21 09:05:49','2023-12-24 09:46:43',NULL,'1','Update Invoice','1'),
('3140','VR-23-3140','2023-12-21 00:00:00','0','1250.00','1','189.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2023-12-21 09:09:47','2023-12-21 09:09:47','2023-12-21 09:10:05','1','Delete Invoice','1'),
('3141','VR-23-3141','2023-12-21 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-12-21 09:12:22','2023-12-21 09:12:22',NULL,'1','Add New Invoice','1'),
('3142','VR-23-3142','2023-12-21 00:00:00','0','1250.00','1','468.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-21 09:22:22','2023-12-21 09:22:48',NULL,'1','Update Invoice','1'),
('3143','VR-23-3143','2023-12-21 00:00:00','0','1250.00','1','8.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-21 09:39:54','2023-12-21 09:39:54',NULL,'1','Add New Invoice','1'),
('3144','VR-23-3144','2023-12-21 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2023-12-21 09:44:54','2023-12-21 09:44:54',NULL,'1','Add New Invoice','1'),
('3145','VR-23-3145','2023-12-21 00:00:00','0','1250.00','1','458.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-21 09:58:00','2023-12-21 09:58:00',NULL,'1','Add New Invoice','1'),
('3146','VR-23-3146','2023-12-21 00:00:00','0','1250.00','1','104.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-21 10:10:38','2023-12-21 10:10:38',NULL,'1','Add New Invoice','1'),
('3147','VR-23-3147','2023-12-21 00:00:00','0','1250.00','1','311.10','0.00','عمار عبدالستار سماوة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-21 10:37:28','2023-12-21 10:37:28',NULL,'1','Add New Invoice','1'),
('3148','VR-23-3148','2023-12-21 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-12-21 10:52:39','2023-12-21 10:52:39',NULL,'1','Add New Invoice','1'),
('3149','VR-23-3149','2023-12-21 00:00:00','0','1250.00','1','147.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-21 12:36:04','2023-12-21 12:36:04',NULL,'1','Add New Invoice','1'),
('3150','VR-23-3150','2023-12-21 00:00:00','0','1250.00','1','47.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2023-12-21 13:54:39','2023-12-21 13:54:39',NULL,'1','Add New Invoice','1'),
('3151','VR-23-3151','2023-12-21 00:00:00','0','1250.00','1','181.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-21 14:06:49','2023-12-21 14:06:49',NULL,'1','Add New Invoice','1'),
('3152','VR-23-3152','2023-12-21 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-21 14:16:21','2023-12-21 14:16:21',NULL,'1','Add New Invoice','1'),
('3153','INV-23-3153','2023-12-21 00:00:00','0','1250.00','1','1367.84','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-21 03:08:26','2023-12-21 03:08:26',NULL,'1','Add New Invoice','1'),
('3154','VR-23-3154','2023-12-21 00:00:00','0','1250.00','1','117.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-21 15:28:45','2023-12-21 15:28:45',NULL,'1','Add New Invoice','1'),
('3155','VR-23-3155','2023-12-21 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2023-12-21 16:53:55','2023-12-21 16:53:55',NULL,'1','Add New Invoice','1'),
('3156','VR-23-3156','2023-12-23 00:00:00','0','1250.00','1','557.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-12-23 14:25:05','2023-12-23 14:25:05',NULL,'1','Add New Invoice','1'),
('3157','VR-23-3157','2023-12-24 00:00:00','0','1250.00','1','65.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-24 11:59:39','2023-12-24 11:59:39',NULL,'1','Add New Invoice','1'),
('3158','VR-23-3158','2023-12-24 00:00:00','0','1250.00','1','16175.34','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-24 16:05:05','2023-12-24 16:05:05',NULL,'1','Add New Invoice','1'),
('3159','VR-23-3159','2023-12-25 00:00:00','0','1250.00','1','118.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2023-12-25 10:44:03','2023-12-25 10:44:03',NULL,'1','Add New Invoice','1'),
('3160','VR-23-3160','2023-12-25 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-25 10:47:25','2023-12-25 10:47:25',NULL,'1','Add New Invoice','1'),
('3161','VR-23-3161','2023-12-25 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-25 10:58:36','2023-12-25 10:58:36',NULL,'1','Add New Invoice','1'),
('3162','VR-23-3162','2023-12-25 00:00:00','0','1250.00','1','44.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-12-25 12:05:42','2023-12-25 12:05:42',NULL,'1','Add New Invoice','1'),
('3163','VR-23-3163','2023-12-25 00:00:00','0','1250.00','1','433.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2023-12-25 12:13:40','2023-12-26 10:45:03',NULL,'1','Update Invoice','1'),
('3164','VR-23-3164','2023-12-25 00:00:00','0','1250.00','1','176.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-25 12:14:58','2023-12-25 12:14:58',NULL,'1','Add New Invoice','1'),
('3165','VR-23-3165','2023-12-25 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-25 12:16:09','2023-12-25 12:16:09',NULL,'1','Add New Invoice','1'),
('3166','VR-23-3166','2023-12-25 00:00:00','0','1250.00','1','162.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-12-25 14:25:15','2023-12-25 14:25:15',NULL,'1','Add New Invoice','1'),
('3167','VR-23-3167','2023-12-26 00:00:00','0','1250.00','1','93.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-26 10:44:28','2023-12-26 10:51:28',NULL,'1','Update Invoice','1'),
('3168','VR-23-3168','2023-12-26 00:00:00','0','1250.00','1','95.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-26 11:51:03','2023-12-26 11:51:03',NULL,'1','Add New Invoice','1'),
('3169','VR-23-3169','2023-12-26 00:00:00','0','1250.00','1','207.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2023-12-26 11:52:47','2023-12-26 11:52:47',NULL,'1','Add New Invoice','1'),
('3170','VR-23-3170','2023-12-26 00:00:00','0','1250.00','1','372.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-26 11:54:34','2023-12-26 11:54:34',NULL,'1','Add New Invoice','1'),
('3171','VR-23-3171','2023-12-26 00:00:00','0','1250.00','1','173.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2023-12-26 14:30:54','2023-12-26 14:30:54',NULL,'1','Add New Invoice','1'),
('3172','VR-23-3172','2023-12-26 00:00:00','0','1250.00','1','49.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2023-12-26 14:34:08','2023-12-26 14:34:08',NULL,'1','Add New Invoice','1'),
('3173','VR-23-3173','2023-12-26 00:00:00','0','1250.00','1','1474.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-26 16:13:49','2023-12-27 01:43:54',NULL,'1','Update Invoice','1'),
('3174','VR-23-3174','2023-12-26 00:00:00','0','1250.00','1','27.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2023-12-26 16:17:35','2023-12-26 16:17:35',NULL,'1','Add New Invoice','1'),
('3175','VR-23-3175','2023-12-26 00:00:00','0','1250.00','1','78.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-12-26 16:18:26','2023-12-26 16:18:26',NULL,'1','Add New Invoice','1'),
('3176','VR-23-3176','2023-12-26 00:00:00','0','1250.00','1','198.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-26 16:20:06','2023-12-26 16:20:06',NULL,'1','Add New Invoice','1'),
('3177','VR-23-3177','2023-12-26 00:00:00','0','1250.00','1','154.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2023-12-26 16:21:06','2023-12-26 16:21:06',NULL,'1','Add New Invoice','1'),
('3178','VR-23-3178','2023-12-26 00:00:00','0','1250.00','1','43.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-26 16:22:46','2023-12-26 16:22:46',NULL,'1','Add New Invoice','1'),
('3179','VR-23-3179','2023-12-26 00:00:00','0','1250.00','1','101.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-26 16:24:28','2023-12-26 16:24:28',NULL,'1','Add New Invoice','1'),
('3180','VR-23-3180','2023-12-27 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-27 15:57:37','2023-12-27 15:57:37',NULL,'1','Add New Invoice','1'),
('3181','VR-23-3181','2023-12-27 00:00:00','0','1250.00','1','81.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2023-12-27 15:58:49','2023-12-27 15:58:49',NULL,'1','Add New Invoice','1'),
('3182','VR-23-3182','2023-12-27 00:00:00','0','1250.00','1','523.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2023-12-27 16:04:32','2023-12-27 16:04:32',NULL,'1','Add New Invoice','1'),
('3183','VR-23-3183','2023-12-27 00:00:00','0','1250.00','1','1541.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-27 16:16:20','2023-12-30 11:30:59',NULL,'1','Update Invoice','1'),
('3184','VR-23-3184','2023-12-27 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-27 16:22:02','2023-12-27 16:22:02',NULL,'1','Add New Invoice','1'),
('3185','VR-23-3185','2023-12-27 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-27 16:22:52','2023-12-27 16:22:52',NULL,'1','Add New Invoice','1'),
('3186','VR-23-3186','2023-12-27 00:00:00','0','1250.00','1','125.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2023-12-27 16:28:46','2023-12-27 16:28:46',NULL,'1','Add New Invoice','1'),
('3187','VR-23-3187','2023-12-28 00:00:00','0','1250.00','1','1032.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2023-12-28 10:37:42','2023-12-28 10:37:42',NULL,'1','Add New Invoice','1'),
('3188','VR-23-3188','2023-12-28 00:00:00','0','1250.00','1','1599.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-28 10:56:34','2023-12-28 10:56:34',NULL,'1','Add New Invoice','1'),
('3189','VR-23-3189','2023-12-28 00:00:00','0','1250.00','1','517.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-28 11:07:41','2023-12-28 11:07:41',NULL,'1','Add New Invoice','1'),
('3190','VR-23-3190','2023-12-28 00:00:00','0','1250.00','1','487.35','0.00','985/0','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2023-12-28 11:49:40','2023-12-28 11:49:40',NULL,'1','Add New Invoice','1'),
('3191','INV-23-3191','2023-12-28 00:00:00','0','1250.00','1','64.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2023-12-28 02:01:26','2023-12-28 02:01:26',NULL,'1','Add New Invoice','1'),
('3192','VR-23-3192','2023-12-28 00:00:00','0','1250.00','1','657.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-28 14:48:02','2023-12-28 14:48:02',NULL,'1','Add New Invoice','1'),
('3193','VR-23-3193','2023-12-28 00:00:00','0','1250.00','1','138.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-28 14:52:50','2023-12-28 14:52:50',NULL,'1','Add New Invoice','1'),
('3194','VR-23-3194','2023-12-28 00:00:00','0','1250.00','1','358.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-28 14:58:21','2023-12-28 14:58:21',NULL,'1','Add New Invoice','1'),
('3195','VR-23-3195','2023-12-28 00:00:00','0','1250.00','1','90.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2023-12-28 15:00:39','2023-12-28 15:00:39',NULL,'1','Add New Invoice','1'),
('3196','VR-23-3196','2023-12-28 00:00:00','0','1250.00','1','271.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2023-12-28 15:02:30','2023-12-28 15:02:30',NULL,'1','Add New Invoice','1'),
('3197','VR-23-3197','2023-12-28 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2023-12-28 15:11:09','2023-12-28 15:11:09',NULL,'1','Add New Invoice','1'),
('3198','VR-23-3198','2023-12-30 00:00:00','0','1250.00','1','881.51','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2023-12-30 09:03:15','2024-01-22 11:50:45',NULL,'1','Update Invoice','1'),
('3199','VR-23-3199','2023-12-30 00:00:00','0','1250.00','1','1903.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-30 16:03:49','2023-12-30 16:03:49',NULL,'1','Add New Invoice','1'),
('3200','VR-23-3200','2023-12-30 00:00:00','0','1250.00','1','535.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2023-12-30 16:12:15','2023-12-30 16:12:15',NULL,'1','Add New Invoice','1'),
('3201','VR-23-3201','2023-12-30 00:00:00','0','1250.00','1','168.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-30 16:13:10','2023-12-30 16:13:10',NULL,'1','Add New Invoice','1'),
('3202','VR-23-3202','2023-12-30 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2023-12-30 16:13:59','2023-12-30 16:13:59',NULL,'1','Add New Invoice','1'),
('3203','VR-23-3203','2023-12-30 00:00:00','0','1250.00','1','147.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-30 16:17:34','2023-12-30 16:17:34',NULL,'1','Add New Invoice','1'),
('3204','VR-23-3204','2023-12-30 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','92','0','2023-12-30 16:25:33','2023-12-30 16:25:33',NULL,'1','Add New Invoice','1'),
('3205','VR-23-3205','2023-12-31 00:00:00','0','1250.00','1','189.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2023-12-31 09:04:57','2023-12-31 09:04:57',NULL,'1','Add New Invoice','1'),
('3206','VR-23-3206','2023-12-31 00:00:00','0','1250.00','1','68.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2023-12-31 09:06:49','2023-12-31 09:06:49',NULL,'1','Add New Invoice','1'),
('3207','VR-23-3207','2023-12-31 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2023-12-31 09:23:37','2023-12-31 09:23:37',NULL,'1','Add New Invoice','1'),
('3208','VR-23-3208','2023-12-31 00:00:00','0','1250.00','1','145.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2023-12-31 09:24:20','2023-12-31 09:24:20',NULL,'1','Add New Invoice','1'),
('3209','VR-23-3209','2023-12-31 00:00:00','0','1250.00','1','146.25','0.00','رياض محمد حي عدل','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2023-12-31 09:25:33','2023-12-31 09:25:33',NULL,'1','Add New Invoice','1'),
('3210','VR-23-3210','2023-12-31 00:00:00','0','1250.00','1','840.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2023-12-31 11:59:05','2023-12-31 11:59:05',NULL,'1','Add New Invoice','1'),
('3211','VR-23-3211','2023-12-31 00:00:00','0','1250.00','1','85.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2023-12-31 16:17:04','2023-12-31 16:17:04',NULL,'1','Add New Invoice','1'),
('3212','VR-24-3212','2024-01-01 00:00:00','0','1250.00','1','241.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-01 14:32:32','2024-01-01 14:32:32',NULL,'1','Add New Invoice','1'),
('3213','VR-24-3213','2024-01-02 00:00:00','0','1250.00','1','272.89','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-02 12:09:53','2024-01-02 12:09:53',NULL,'1','Add New Invoice','1'),
('3214','VR-24-3214','2024-01-02 00:00:00','0','1250.00','1','7104.32','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-01-02 16:04:33','2024-02-01 09:37:10',NULL,'1','Update Invoice','1'),
('3215','VR-24-3215','2024-01-03 00:00:00','0','1250.00','1','714.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-01-03 11:45:10','2024-01-03 11:45:10',NULL,'1','Add New Invoice','1'),
('3216','VR-24-3216','2024-01-03 00:00:00','0','1250.00','1','248.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-03 14:49:17','2024-01-03 14:49:17',NULL,'1','Add New Invoice','1'),
('3217','VR-24-3217','2024-01-04 00:00:00','0','1250.00','1','131.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-04 10:54:17','2024-01-04 10:54:17',NULL,'1','Add New Invoice','1'),
('3218','VR-24-3218','2024-01-04 00:00:00','0','1250.00','1','106.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-01-04 11:13:29','2024-01-04 11:13:29',NULL,'1','Add New Invoice','1'),
('3219','VR-24-3219','2024-01-04 00:00:00','0','1250.00','1','1283.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-04 11:34:43','2024-01-04 11:34:43',NULL,'1','Add New Invoice','1'),
('3220','VR-24-3220','2024-01-04 00:00:00','0','1250.00','1','232.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2024-01-04 11:37:11','2024-01-04 11:37:11',NULL,'1','Add New Invoice','1'),
('3221','VR-24-3221','2024-01-04 00:00:00','0','1250.00','1','49.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-04 14:35:15','2024-01-04 14:35:15',NULL,'1','Add New Invoice','1'),
('3224','INV-24-3222','2024-01-04 00:00:00','0','1250.00','1','251.79','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-06 09:25:29','2024-01-06 09:25:29',NULL,'1','Add New Invoice','1'),
('3225','INV-24-3225','2024-01-04 00:00:00','0','1250.00','1','98.70','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-01-06 09:32:59','2024-01-06 09:32:59',NULL,'1','Add New Invoice','1'),
('3226','VR-24-3226','2024-01-06 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','1','2024-01-06 09:59:41','2024-01-06 09:59:41','2024-01-06 10:21:30','1','Delete Invoice','1'),
('3227','VR-24-3227','2024-01-04 00:00:00','0','1250.00','1','739.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-01-06 10:20:38','2024-01-06 10:20:38',NULL,'1','Add New Invoice','1'),
('3228','VR-24-3228','2024-01-06 00:00:00','0','1250.00','1','8557.89','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-06 14:31:20','2024-01-06 14:31:20',NULL,'1','Add New Invoice','1'),
('3229','VR-24-3229','2024-01-06 00:00:00','0','1250.00','1','9731.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-06 14:59:28','2024-01-06 14:59:28',NULL,'1','Add New Invoice','1'),
('3230','VR-24-3230','2024-01-06 00:00:00','0','1250.00','1','398.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-06 16:13:57','2024-01-06 16:13:57',NULL,'1','Add New Invoice','1'),
('3231','VR-24-3231','2024-01-06 00:00:00','0','1250.00','1','769.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-01-06 16:20:27','2024-01-06 16:20:27',NULL,'1','Add New Invoice','1'),
('3232','VR-24-3232','2024-01-07 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-01-07 09:17:31','2024-01-07 09:17:31',NULL,'1','Add New Invoice','1'),
('3233','VR-24-3233','2024-01-07 00:00:00','0','1250.00','1','880.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-01-07 12:04:49','2024-01-07 12:04:49',NULL,'1','Add New Invoice','1'),
('3234','VR-24-3234','2024-01-07 00:00:00','0','1250.00','1','121.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-01-07 14:20:42','2024-01-07 14:20:42',NULL,'1','Add New Invoice','1'),
('3235','VR-24-3235','2024-01-07 00:00:00','0','1250.00','1','90.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-07 15:08:17','2024-01-07 15:08:17',NULL,'1','Add New Invoice','1'),
('3236','VR-24-3236','2024-01-08 00:00:00','0','1250.00','1','2026.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-01-08 10:42:43','2024-03-05 10:08:09',NULL,'1','Update Invoice','1'),
('3237','VR-24-3237','2024-01-08 00:00:00','0','1250.00','1','222.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-08 11:11:26','2024-01-08 11:11:26',NULL,'1','Add New Invoice','1'),
('3238','VR-24-3238','2024-01-08 00:00:00','0','1250.00','1','425.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-01-08 12:16:10','2024-01-08 03:12:32',NULL,'1','Update Invoice','1'),
('3239','VR-24-3239','2024-01-09 00:00:00','0','1250.00','1','1174.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','119','0','2024-01-09 11:04:03','2024-01-09 11:04:03',NULL,'1','Add New Invoice','1'),
('3240','VR-24-3240','2024-01-09 00:00:00','0','1250.00','1','11296.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-01-09 11:42:28','2024-01-11 12:57:58',NULL,'1','Update Invoice','1'),
('3241','VR-24-3241','2024-01-09 00:00:00','0','1250.00','1','163.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-01-09 11:58:32','2024-01-09 11:58:32',NULL,'1','Add New Invoice','1'),
('3242','VR-24-3242','2024-01-09 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-01-09 12:06:48','2024-01-09 12:06:48',NULL,'1','Add New Invoice','1'),
('3243','VR-24-3243','2024-01-10 00:00:00','0','1250.00','1','320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-01-10 09:10:51','2024-01-10 09:10:51',NULL,'1','Add New Invoice','1'),
('3244','VR-24-3244','2024-01-10 00:00:00','0','1250.00','1','124.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-01-10 09:20:39','2024-01-10 09:20:39',NULL,'1','Add New Invoice','1'),
('3245','VR-24-3245','2024-01-10 00:00:00','0','1250.00','1','467.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-01-10 11:29:46','2024-01-10 03:56:58',NULL,'1','Update Invoice','1'),
('3246','VR-24-3246','2024-01-10 00:00:00','0','1250.00','1','146.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-01-10 12:16:35','2024-01-10 01:10:32',NULL,'1','Update Invoice','1'),
('3247','VR-24-3247','2024-01-10 00:00:00','0','1250.00','1','142.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-01-10 12:21:29','2024-01-10 01:10:00',NULL,'1','Update Invoice','1'),
('3248','VR-24-3248','2024-01-10 00:00:00','0','1250.00','1','115.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-01-10 12:22:52','2024-01-10 01:34:10',NULL,'1','Update Invoice','1'),
('3249','VR-24-3249','2024-01-10 00:00:00','0','1250.00','1','1939.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-10 13:29:21','2024-01-10 01:32:53',NULL,'1','Update Invoice','1'),
('3250','VR-24-3250','2024-01-10 00:00:00','0','1250.00','1','2852.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-10 13:45:25','2024-01-10 13:45:25',NULL,'1','Add New Invoice','1'),
('3251','VR-24-3251','2024-01-10 00:00:00','0','1250.00','1','292.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-10 15:22:41','2024-01-10 15:22:41',NULL,'1','Add New Invoice','1'),
('3252','VR-24-3252','2024-01-10 00:00:00','0','1250.00','1','837.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-01-10 15:34:16','2024-01-11 09:03:37',NULL,'1','Update Invoice','1'),
('3254','VR-24-3253','2024-01-10 00:00:00','0','1250.00','1','1234.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-10 15:54:11','2024-01-10 15:54:11',NULL,'1','Add New Invoice','1'),
('3255','VR-24-3255','2024-01-11 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-01-11 09:53:31','2024-01-11 09:53:31',NULL,'1','Add New Invoice','1'),
('3256','VR-24-3256','2024-01-11 00:00:00','0','1250.00','1','124.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-01-11 09:56:30','2024-01-11 09:56:30',NULL,'1','Add New Invoice','1'),
('3257','VR-24-3257','2024-01-11 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-01-11 09:58:29','2024-01-11 09:58:29',NULL,'1','Add New Invoice','1'),
('3258','VR-24-3258','2024-01-11 00:00:00','0','1250.00','1','137.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-01-11 10:05:19','2024-01-11 10:05:19',NULL,'1','Add New Invoice','1'),
('3259','VR-24-3259','2024-01-11 00:00:00','0','1250.00','1','124.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-01-11 10:07:45','2024-01-11 10:07:45',NULL,'1','Add New Invoice','1'),
('3260','VR-24-3260','2024-01-11 00:00:00','0','1250.00','1','22.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-01-11 10:28:52','2024-01-11 10:28:52',NULL,'1','Add New Invoice','1'),
('3261','VR-24-3261','2024-01-11 00:00:00','0','1250.00','1','7138.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-01-11 10:48:14','2024-01-11 11:02:21',NULL,'1','Update Invoice','1'),
('3262','VR-24-3262','2024-01-11 00:00:00','0','1250.00','1','1846.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-01-11 11:27:22','2024-01-11 11:27:22',NULL,'1','Add New Invoice','1'),
('3263','VR-24-3263','2024-01-11 00:00:00','0','1250.00','1','304.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-01-11 11:55:14','2024-01-11 11:55:14',NULL,'1','Add New Invoice','1'),
('3264','VR-24-3264','2024-01-11 00:00:00','0','1250.00','1','156.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-11 11:58:03','2024-01-11 11:58:03',NULL,'1','Add New Invoice','1'),
('3265','VR-24-3265','2024-01-11 00:00:00','0','1250.00','1','424.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-01-11 12:02:41','2024-01-11 01:08:42',NULL,'1','Update Invoice','1'),
('3266','VR-24-3266','2024-01-11 00:00:00','0','1250.00','1','98.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-01-11 12:10:26','2024-01-11 12:10:26',NULL,'1','Add New Invoice','1'),
('3267','VR-24-3267','2024-01-11 00:00:00','0','1250.00','1','220.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-01-11 12:11:46','2024-01-11 12:11:46',NULL,'1','Add New Invoice','1'),
('3268','VR-24-3268','2024-01-11 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-01-11 12:13:38','2024-01-11 12:13:38',NULL,'1','Add New Invoice','1'),
('3269','VR-24-3269','2024-01-11 00:00:00','0','1250.00','1','724.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-01-11 12:46:13','2024-01-11 12:46:13',NULL,'1','Add New Invoice','1'),
('3270','VR-24-3270','2024-01-11 00:00:00','0','1250.00','1','152.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-11 12:47:23','2024-01-11 12:47:23',NULL,'1','Add New Invoice','1'),
('3271','VR-24-3271','2024-01-11 00:00:00','0','1250.00','1','159.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-01-11 12:50:37','2024-01-11 12:50:37',NULL,'1','Add New Invoice','1'),
('3272','VR-24-3272','2024-01-11 00:00:00','0','1250.00','1','192.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-01-11 12:58:51','2024-01-11 12:58:51',NULL,'1','Add New Invoice','1'),
('3273','VR-24-3273','2024-01-11 00:00:00','0','1250.00','1','53.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-01-11 12:59:48','2024-01-11 12:59:48',NULL,'1','Add New Invoice','1'),
('3274','VR-24-3274','2024-01-13 00:00:00','0','1250.00','1','1582.86','0.00','د عباس حلة','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-13 12:04:41','2024-01-13 12:04:41',NULL,'1','Add New Invoice','1'),
('3275','VR-24-3275','2024-01-13 00:00:00','0','1250.00','1','282.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-01-13 12:17:48','2024-01-13 12:17:48',NULL,'1','Add New Invoice','1'),
('3276','VR-24-3276','2024-01-13 00:00:00','0','1250.00','1','46.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-01-13 12:20:12','2024-01-13 12:20:12',NULL,'1','Add New Invoice','1'),
('3277','VR-24-3277','2024-01-13 00:00:00','0','1250.00','1','1095.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-01-13 12:22:17','2024-01-13 12:22:17',NULL,'1','Add New Invoice','1'),
('3278','INV-24-3278','2024-01-14 00:00:00','0','1250.00','1','42.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-14 10:07:40','2024-01-24 02:36:29',NULL,'1','Update Invoice','1'),
('3279','INV-24-3279','2024-01-14 00:00:00','0','1250.00','1','42.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-14 10:07:40','2024-01-24 02:36:40',NULL,'1','Update Invoice','1'),
('3280','VR-24-3280','2024-01-14 00:00:00','0','1250.00','1','52.54','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-01-14 15:46:37','2024-01-14 15:46:37',NULL,'1','Add New Invoice','1'),
('3281','VR-24-3281','2024-01-14 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-01-14 15:47:29','2024-01-14 15:47:29',NULL,'1','Add New Invoice','1'),
('3282','VR-24-3282','2024-01-14 00:00:00','0','1250.00','1','1248.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-14 15:52:11','2024-01-14 15:52:11',NULL,'1','Add New Invoice','1'),
('3283','VR-24-3283','2024-01-15 00:00:00','0','1250.00','1','264.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-15 14:51:28','2024-01-15 14:51:28',NULL,'1','Add New Invoice','1'),
('3284','VR-24-3284','2024-01-16 00:00:00','0','1250.00','1','111.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-01-16 09:19:01','2024-01-16 09:19:01',NULL,'1','Add New Invoice','1'),
('3285','INV-24-3285','2024-01-16 00:00:00','0','1250.00','1','191.71','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-16 09:23:32','2024-01-16 09:23:32',NULL,'1','Add New Invoice','1'),
('3286','VR-24-3286','2024-01-16 00:00:00','0','1250.00','1','401.83','0.00','947','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-16 15:45:24','2024-01-16 15:45:24',NULL,'1','Add New Invoice','1'),
('3288','VR-24-3287','2024-01-17 00:00:00','0','1250.00','1','1329.91','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-17 09:30:59','2024-01-17 09:54:18',NULL,'1','Update Invoice','1'),
('3289','VR-24-3289','2024-01-17 00:00:00','0','1250.00','1','133.69','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-17 10:17:12','2024-01-17 02:28:47',NULL,'1','Update Invoice','1'),
('3290','VR-24-3290','2024-01-17 00:00:00','0','1250.00','1','123.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-01-17 10:46:07','2024-01-17 10:46:07',NULL,'1','Add New Invoice','1'),
('3291','VR-24-3291','2024-01-17 00:00:00','0','1250.00','1','217.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-01-17 10:50:58','2024-01-17 10:50:58',NULL,'1','Add New Invoice','1'),
('3292','VR-24-3292','2024-01-17 00:00:00','0','1250.00','1','360.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-17 10:59:31','2024-01-18 09:19:01',NULL,'1','Update Invoice','1'),
('3293','VR-24-3293','2024-01-17 00:00:00','0','1250.00','1','176.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-01-17 11:12:55','2024-01-17 11:12:55',NULL,'1','Add New Invoice','1'),
('3294','VR-24-3294','2024-01-17 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-01-17 11:56:57','2024-01-17 11:56:57',NULL,'1','Add New Invoice','1'),
('3295','VR-24-3295','2024-01-17 00:00:00','0','1250.00','1','213.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-01-17 14:36:17','2024-01-17 14:36:17',NULL,'1','Add New Invoice','1'),
('3296','VR-24-3296','2024-01-17 00:00:00','0','1250.00','1','380.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-17 15:19:59','2024-01-17 15:19:59',NULL,'1','Add New Invoice','1'),
('3297','VR-24-3297','2024-01-17 00:00:00','0','1250.00','1','255.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-01-17 15:33:42','2024-01-17 15:33:42',NULL,'1','Add New Invoice','1'),
('3298','VR-24-3298','2024-01-17 00:00:00','0','1250.00','1','459.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-01-17 15:40:46','2024-01-17 15:40:46',NULL,'1','Add New Invoice','1'),
('3299','VR-24-3299','2024-01-17 00:00:00','0','1250.00','1','161.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-01-17 15:57:12','2024-01-17 15:57:12',NULL,'1','Add New Invoice','1'),
('3300','VR-24-3300','2024-01-17 00:00:00','0','1250.00','1','140.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-01-17 15:59:52','2024-01-17 15:59:52',NULL,'1','Add New Invoice','1'),
('3301','VR-24-3301','2024-01-17 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-01-17 16:02:35','2024-01-17 16:02:35',NULL,'1','Add New Invoice','1'),
('3302','VR-24-3302','2024-01-17 00:00:00','0','1250.00','1','118.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-01-17 16:03:34','2024-01-17 16:03:34',NULL,'1','Add New Invoice','1'),
('3303','VR-24-3303','2024-01-17 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-01-17 16:05:40','2024-01-17 16:05:40',NULL,'1','Add New Invoice','1'),
('3304','VR-24-3304','2024-01-17 00:00:00','0','1250.00','1','593.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','1','2024-01-17 16:07:28','2024-01-17 16:07:28','2024-01-18 03:16:14','1','Delete Invoice','1'),
('3305','VR-24-3305','2024-01-18 00:00:00','0','1250.00','1','93.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-01-18 09:05:36','2024-01-18 09:05:36',NULL,'1','Add New Invoice','1'),
('3306','VR-24-3306','2024-01-18 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2024-01-18 09:17:48','2024-01-18 09:17:48','2024-01-18 09:18:23','1','Delete Invoice','1'),
('3307','VR-24-3307','2024-01-18 00:00:00','0','1250.00','1','90.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-18 14:40:44','2024-01-18 14:40:44',NULL,'1','Add New Invoice','1'),
('3308','VR-24-3308','2024-01-18 00:00:00','0','1250.00','1','495.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-01-18 14:48:43','2024-01-18 14:48:43',NULL,'1','Add New Invoice','1'),
('3309','VR-24-3309','2024-01-18 00:00:00','0','1250.00','1','127.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-01-18 14:51:43','2024-01-18 14:51:43',NULL,'1','Add New Invoice','1'),
('3310','VR-24-3310','2024-01-18 00:00:00','0','1250.00','1','122.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-01-18 14:53:00','2024-01-20 09:07:20',NULL,'1','Update Invoice','1'),
('3311','VR-24-3311','2024-01-18 00:00:00','0','1250.00','1','38.11','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-01-18 14:53:43','2024-01-18 14:53:43',NULL,'1','Add New Invoice','1'),
('3312','INV-24-3312','2024-01-18 00:00:00','0','1250.00','1','168.21','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-18 02:59:26','2024-01-24 02:36:51',NULL,'1','Update Invoice','1'),
('3313','VR-24-3313','2024-01-18 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-01-18 15:08:52','2024-01-18 03:09:15',NULL,'1','Update Invoice','1'),
('3314','VR-24-3314','2024-01-18 00:00:00','0','1250.00','1','92.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-18 15:13:44','2024-01-18 15:13:44',NULL,'1','Add New Invoice','1'),
('3315','VR-24-3315','2024-01-18 00:00:00','0','1250.00','1','593.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-01-18 15:18:38','2024-01-18 15:18:38',NULL,'1','Add New Invoice','1'),
('3316','VR-24-3316','2024-01-18 00:00:00','0','1250.00','1','93.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-01-18 15:22:57','2024-01-18 15:22:57',NULL,'1','Add New Invoice','1'),
('3317','VR-24-3317','2024-01-20 00:00:00','0','1250.00','1','347.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-20 14:53:00','2024-01-20 14:53:00',NULL,'1','Add New Invoice','1'),
('3318','VR-24-3318','2024-01-20 00:00:00','0','1250.00','1','126.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-20 15:00:20','2024-01-20 15:00:20',NULL,'1','Add New Invoice','1'),
('3319','VR-24-3319','2024-01-20 00:00:00','0','1250.00','1','438.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-20 15:13:13','2024-01-20 15:13:13',NULL,'1','Add New Invoice','1'),
('3320','VR-24-3320','2024-01-20 00:00:00','0','1250.00','1','183.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-01-20 15:15:00','2024-01-20 15:15:00',NULL,'1','Add New Invoice','1'),
('3321','VR-24-3321','2024-01-20 00:00:00','0','1250.00','1','262.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-01-20 15:21:25','2024-01-20 15:21:25',NULL,'1','Add New Invoice','1'),
('3322','VR-24-3322','2024-01-21 00:00:00','0','1250.00','1','6133.39','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-21 08:51:21','2024-01-22 11:54:25',NULL,'1','Update Invoice','1'),
('3323','VR-24-3323','2024-01-22 00:00:00','0','1250.00','1','34.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-22 12:00:45','2024-01-22 12:00:45',NULL,'1','Add New Invoice','1'),
('3324','VR-24-3324','2024-01-22 00:00:00','0','1250.00','1','155.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-22 12:26:20','2024-01-22 12:26:20',NULL,'1','Add New Invoice','1'),
('3325','VR-24-3325','2024-01-22 00:00:00','0','1250.00','1','156.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-01-22 14:04:48','2024-01-22 14:04:48',NULL,'1','Add New Invoice','1'),
('3326','VR-24-3326','2024-01-22 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-01-22 14:13:45','2024-01-22 14:13:45',NULL,'1','Add New Invoice','1'),
('3327','VR-24-3327','2024-01-22 00:00:00','0','1250.00','1','265.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-22 14:17:29','2024-01-22 03:27:32',NULL,'1','Update Invoice','1'),
('3328','VR-24-3328','2024-01-22 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-01-22 14:18:19','2024-01-22 14:18:19',NULL,'1','Add New Invoice','1'),
('3329','VR-24-3329','2024-01-22 00:00:00','0','1250.00','1','174.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-01-22 14:31:17','2024-01-22 14:31:17',NULL,'1','Add New Invoice','1'),
('3330','VR-24-3330','2024-01-22 00:00:00','0','1250.00','1','297.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-01-22 14:33:48','2024-01-22 03:27:01',NULL,'1','Update Invoice','1'),
('3331','VR-24-3331','2024-01-22 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-22 14:40:02','2024-01-22 14:40:02',NULL,'1','Add New Invoice','1'),
('3332','VR-24-3332','2024-01-22 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-01-22 14:43:05','2024-01-22 14:43:05',NULL,'1','Add New Invoice','1'),
('3333','VR-24-3333','2024-01-22 00:00:00','0','1250.00','1','53.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-22 14:44:04','2024-01-22 14:44:04',NULL,'1','Add New Invoice','1'),
('3334','VR-24-3334','2024-01-22 00:00:00','0','1250.00','1','332.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-01-22 14:58:29','2024-01-22 14:58:29',NULL,'1','Add New Invoice','1'),
('3335','VR-24-3335','2024-01-22 00:00:00','0','1250.00','1','879.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-01-22 15:03:39','2024-01-24 12:35:41',NULL,'1','Update Invoice','1'),
('3336','VR-24-3336','2024-01-22 00:00:00','0','1250.00','1','373.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-01-22 15:18:27','2024-01-22 15:18:27',NULL,'1','Add New Invoice','1'),
('3337','VR-24-3337','2024-01-22 00:00:00','0','1250.00','1','113.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-01-22 15:28:31','2024-01-22 15:28:31',NULL,'1','Add New Invoice','1'),
('3338','INV-24-3338','2024-01-22 00:00:00','0','1250.00','1','22.68','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-22 04:16:03','2024-01-24 02:37:01',NULL,'1','Update Invoice','1'),
('3339','VR-24-3339','2024-01-23 00:00:00','0','1250.00','1','98.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-01-23 14:54:04','2024-01-23 14:54:04',NULL,'1','Add New Invoice','1'),
('3340','VR-24-3340','2024-01-24 00:00:00','0','1250.00','1','122.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-24 14:52:22','2024-01-24 14:52:22',NULL,'1','Add New Invoice','1'),
('3341','VR-24-3341','2024-01-24 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-01-25 10:05:07','2024-01-25 10:05:07',NULL,'1','Add New Invoice','1'),
('3342','VR-24-3342','2024-01-25 00:00:00','0','1250.00','1','419.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-25 10:18:53','2024-01-25 10:26:40',NULL,'1','Update Invoice','1'),
('3343','VR-24-3343','2024-01-25 00:00:00','0','1250.00','1','2079.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-25 11:13:42','2024-01-25 11:13:42',NULL,'1','Add New Invoice','1'),
('3344','VR-24-3344','2024-01-25 00:00:00','0','1250.00','1','572.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-25 15:01:30','2024-01-25 15:01:30',NULL,'1','Add New Invoice','1'),
('3345','VR-24-3345','2024-01-25 00:00:00','0','1250.00','1','76.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-01-25 15:02:32','2024-01-25 15:02:32',NULL,'1','Add New Invoice','1'),
('3346','VR-24-3346','2024-01-25 00:00:00','0','1250.00','1','24.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-01-25 15:03:24','2024-01-25 15:03:24',NULL,'1','Add New Invoice','1'),
('3347','VR-24-3347','2024-01-25 00:00:00','0','1250.00','1','360.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-01-25 15:05:57','2024-01-25 15:05:57',NULL,'1','Add New Invoice','1'),
('3348','VR-24-3348','2024-01-25 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-01-25 15:07:42','2024-01-25 15:07:42',NULL,'1','Add New Invoice','1'),
('3349','VR-24-3349','2024-01-25 00:00:00','0','1250.00','1','339.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-01-25 15:12:07','2024-01-29 08:55:17',NULL,'1','Update Invoice','1'),
('3350','VR-24-3350','2024-01-25 00:00:00','0','1250.00','1','148.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-01-25 16:00:20','2024-01-25 16:00:20',NULL,'1','Add New Invoice','1'),
('3351','VR-24-3351','2024-01-25 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-25 16:02:16','2024-01-25 16:02:16',NULL,'1','Add New Invoice','1'),
('3352','INV-24-3352','2024-01-28 00:00:00','0','1250.00','1','489.30','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-01-28 01:47:08','2024-01-28 01:47:08',NULL,'1','Add New Invoice','1'),
('3353','VR-24-3353','2024-01-28 00:00:00','0','1250.00','1','183.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-01-28 16:18:25','2024-01-28 16:18:25',NULL,'1','Add New Invoice','1'),
('3354','VR-24-3354','2024-01-29 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-01-29 14:43:04','2024-01-29 14:43:04',NULL,'1','Add New Invoice','1'),
('3355','VR-24-3355','2024-01-30 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-01-30 10:44:35','2024-01-30 10:44:35',NULL,'1','Add New Invoice','1'),
('3356','VR-24-3356','2024-01-30 00:00:00','0','1250.00','1','270.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-30 10:53:54','2024-01-30 10:53:54',NULL,'1','Add New Invoice','1'),
('3357','VR-24-3357','2024-01-30 00:00:00','0','1250.00','1','292.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-30 10:59:15','2024-01-30 10:59:15',NULL,'1','Add New Invoice','1'),
('3358','VR-24-3358','2024-01-30 00:00:00','0','1250.00','1','164.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-30 11:05:24','2024-04-03 02:36:40',NULL,'1','Update Invoice','1'),
('3359','VR-24-3359','2024-01-30 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','1','2024-01-30 11:06:55','2024-01-30 11:06:55','2024-02-06 03:44:39','1','Delete Invoice','1'),
('3360','VR-24-3360','2024-01-30 00:00:00','0','1250.00','1','59.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-01-30 11:08:11','2024-01-30 11:08:11',NULL,'1','Add New Invoice','1'),
('3361','VR-24-3361','2024-01-30 00:00:00','0','1250.00','1','276.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-30 12:08:51','2024-01-30 12:08:51',NULL,'1','Add New Invoice','1'),
('3362','VR-24-3362','2024-01-31 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-01-31 12:49:41','2024-01-31 12:49:41',NULL,'1','Add New Invoice','1'),
('3363','VR-24-3363','2024-01-31 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-01-31 13:06:48','2024-01-31 13:06:48',NULL,'1','Add New Invoice','1'),
('3364','VR-24-3364','2024-01-31 00:00:00','0','1250.00','1','142.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-31 13:16:42','2024-01-31 13:16:42',NULL,'1','Add New Invoice','1'),
('3365','VR-24-3365','2024-01-31 00:00:00','0','1250.00','1','288.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-01-31 18:33:31','2024-01-31 18:33:31',NULL,'1','Add New Invoice','1'),
('3366','VR-24-3366','2024-01-31 00:00:00','0','1250.00','1','1053.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-31 18:40:39','2024-01-31 18:40:39',NULL,'1','Add New Invoice','1'),
('3367','VR-24-3367','2024-01-31 00:00:00','0','1250.00','1','3315.52','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','119','0','2024-01-31 20:16:47','2024-01-31 20:16:47',NULL,'1','Add New Invoice','1'),
('3368','VR-24-3368','2024-01-31 00:00:00','0','1250.00','1','6469.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-31 20:44:40','2024-02-12 11:08:58',NULL,'1','Update Invoice','1'),
('3369','VR-24-3369','2024-01-31 00:00:00','0','1250.00','1','1672.87','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-01-31 21:16:10','2024-01-31 21:16:10',NULL,'1','Add New Invoice','1'),
('3370','VR-24-3370','2024-01-31 00:00:00','0','1250.00','1','113.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-01-31 23:04:45','2024-01-31 23:04:45',NULL,'1','Add New Invoice','1'),
('3371','VR-24-3371','2024-01-31 00:00:00','0','1250.00','1','151.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-01-31 23:06:32','2024-02-01 12:16:50',NULL,'1','Update Invoice','1'),
('3372','VR-24-3372','2024-01-31 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-01-31 23:07:26','2024-01-31 23:07:26',NULL,'1','Add New Invoice','1'),
('3373','VR-24-3373','2024-01-31 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-01-31 23:11:48','2024-01-31 23:11:48',NULL,'1','Add New Invoice','1'),
('3374','VR-24-3374','2024-01-31 00:00:00','0','1250.00','1','149.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-01-31 23:12:56','2024-02-06 10:45:09',NULL,'1','Update Invoice','1'),
('3375','VR-24-3375','2024-01-31 00:00:00','0','1250.00','1','59.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','1','2024-01-31 23:14:12','2024-01-31 23:14:12','2024-02-01 10:18:11','1','Delete Invoice','1'),
('3376','VR-24-3376','2024-01-31 00:00:00','0','1250.00','1','365.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-01-31 23:29:30','2024-01-31 23:29:30',NULL,'1','Add New Invoice','1'),
('3377','VR-24-3377','2024-01-31 00:00:00','0','1250.00','1','104.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-01-31 23:33:07','2024-01-31 23:33:07',NULL,'1','Add New Invoice','1'),
('3378','VR-24-3378','2024-01-31 00:00:00','0','1250.00','1','344.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-01-31 23:38:34','2024-01-31 23:38:34',NULL,'1','Add New Invoice','1'),
('3379','VR-24-3379','2024-01-31 00:00:00','0','1250.00','1','144.00','0.00','f','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-01-31 23:49:50','2024-01-31 23:49:50',NULL,'1','Add New Invoice','1'),
('3380','VR-24-3380','2024-01-31 00:00:00','0','1250.00','1','948.57','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-01 00:10:02','2024-02-01 00:10:02',NULL,'1','Add New Invoice','1'),
('3381','VR-24-3381','2024-02-01 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-02-01 00:18:04','2024-02-01 00:18:04',NULL,'1','Add New Invoice','1'),
('3382','VR-24-3382','2024-02-01 00:00:00','0','1250.00','1','602.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-02-01 00:23:43','2024-02-01 00:23:43',NULL,'1','Add New Invoice','1'),
('3383','VR-24-3383','2024-02-01 00:00:00','0','1250.00','1','576.11','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-02-01 00:27:43','2024-02-01 09:19:22',NULL,'1','Update Invoice','1'),
('3384','VR-24-3384','2024-02-01 00:00:00','0','1250.00','1','187.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','1','2024-02-01 12:32:06','2024-02-01 12:32:06','2024-04-03 02:36:01','1','Delete Invoice','1'),
('3385','VR-24-3385','2024-02-03 00:00:00','0','1250.00','1','131.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-02-03 11:17:02','2024-02-03 11:17:02',NULL,'1','Add New Invoice','1'),
('3386','VR-24-3386','2024-02-03 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-02-03 11:39:36','2024-02-03 11:39:36',NULL,'1','Add New Invoice','1'),
('3387','VR-24-3387','2024-02-03 00:00:00','0','1250.00','1','43.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2024-02-03 11:42:00','2024-02-03 11:42:00',NULL,'1','Add New Invoice','1'),
('3388','VR-24-3388','2024-02-03 00:00:00','0','1250.00','1','48.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-02-03 11:43:39','2024-02-03 11:43:39',NULL,'1','Add New Invoice','1'),
('3389','VR-24-3389','2024-02-03 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-03 12:40:07','2024-02-03 12:40:07',NULL,'1','Add New Invoice','1'),
('3390','VR-24-3390','2024-02-03 00:00:00','0','1250.00','1','88.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-02-03 12:46:01','2024-02-03 12:46:01',NULL,'1','Add New Invoice','1'),
('3391','VR-24-3391','2024-02-03 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-03 13:22:22','2024-02-03 13:22:22',NULL,'1','Add New Invoice','1'),
('3392','VR-24-3392','2024-02-03 00:00:00','0','1250.00','1','191.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-02-03 13:29:15','2024-02-03 13:29:15',NULL,'1','Add New Invoice','1'),
('3393','VR-24-3393','2024-02-03 00:00:00','0','1250.00','1','207.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-02-03 14:15:06','2024-02-03 14:15:06',NULL,'1','Add New Invoice','1'),
('3394','VR-24-3394','2024-02-03 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-03 14:19:27','2024-02-03 14:19:27',NULL,'1','Add New Invoice','1'),
('3395','VR-24-3395','2024-02-04 00:00:00','0','1250.00','1','245.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','1','2024-02-04 15:24:54','2024-02-04 15:24:54','2024-02-28 10:31:38','1','Delete Invoice','1'),
('3396','VR-24-3396','2024-02-04 00:00:00','0','1250.00','1','330.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-02-04 15:26:38','2024-02-04 15:26:38',NULL,'1','Add New Invoice','1'),
('3397','VR-24-3397','2024-02-04 00:00:00','0','1250.00','1','116.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-04 15:28:53','2024-02-04 15:28:53',NULL,'1','Add New Invoice','1'),
('3398','INV-24-3398','2024-02-05 00:00:00','0','1250.00','1','38.89','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-02-05 01:55:59','2024-02-05 01:55:59',NULL,'1','Add New Invoice','1'),
('3399','INV-24-3399','2024-02-05 00:00:00','0','1250.00','1','273.95','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-05 02:00:48','2024-02-05 02:00:48',NULL,'1','Add New Invoice','1'),
('3400','VR-24-3400','2024-02-05 00:00:00','0','1250.00','1','545.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-05 14:42:48','2024-02-15 09:43:42',NULL,'1','Update Invoice','1'),
('3401','VR-24-3401','2024-02-05 00:00:00','0','1250.00','1','337.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-02-05 14:44:21','2024-02-05 14:44:21',NULL,'1','Add New Invoice','1'),
('3402','VR-24-3402','2024-02-05 00:00:00','0','1250.00','1','420.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-05 14:47:18','2024-02-05 14:47:18',NULL,'1','Add New Invoice','1'),
('3403','VR-24-3403','2024-02-05 00:00:00','0','1250.00','1','160.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-02-05 14:57:22','2024-02-05 14:57:22',NULL,'1','Add New Invoice','1'),
('3404','VR-24-3404','2024-02-05 00:00:00','0','1250.00','1','392.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-02-05 15:04:13','2024-02-05 15:04:13',NULL,'1','Add New Invoice','1'),
('3405','VR-24-3405','2024-02-05 00:00:00','0','1250.00','1','366.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-05 15:14:43','2024-02-05 15:14:43',NULL,'1','Add New Invoice','1'),
('3406','VR-24-3406','2024-02-05 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-02-05 15:30:07','2024-02-05 15:30:07',NULL,'1','Add New Invoice','1'),
('3407','VR-24-3407','2024-02-06 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-02-06 12:15:13','2024-02-06 12:15:13',NULL,'1','Add New Invoice','1'),
('3408','VR-24-3408','2024-02-06 00:00:00','0','1250.00','1','379.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-06 13:16:52','2024-02-06 13:16:52',NULL,'1','Add New Invoice','1'),
('3409','VR-24-3409','2024-02-06 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-02-06 15:31:53','2024-02-06 15:31:53',NULL,'1','Add New Invoice','1'),
('3410','VR-24-3410','2024-02-07 00:00:00','0','1250.00','1','216.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-07 14:45:44','2024-02-07 14:45:44',NULL,'1','Add New Invoice','1'),
('3411','VR-24-3411','2024-02-07 00:00:00','0','1250.00','1','12.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-07 14:47:00','2024-02-07 14:47:00',NULL,'1','Add New Invoice','1'),
('3412','VR-24-3412','2024-02-07 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-07 14:50:27','2024-02-07 14:50:27',NULL,'1','Add New Invoice','1'),
('3413','VR-24-3413','2024-02-07 00:00:00','0','1250.00','1','239.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-02-07 14:51:12','2024-02-07 14:51:12',NULL,'1','Add New Invoice','1'),
('3414','VR-24-3414','2024-02-07 00:00:00','0','1250.00','1','16.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-02-07 14:52:43','2024-02-07 14:52:43',NULL,'1','Add New Invoice','1'),
('3415','VR-24-3415','2024-02-08 00:00:00','0','1250.00','1','1537.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-08 09:54:16','2024-02-08 10:17:59',NULL,'1','Update Invoice','1'),
('3416','VR-24-3416','2024-02-08 00:00:00','0','1250.00','1','617.39','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-08 10:08:51','2024-02-08 12:52:27',NULL,'1','Update Invoice','1'),
('3417','VR-24-3417','2024-02-08 00:00:00','0','1250.00','1','107.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-02-08 10:09:41','2024-02-08 10:09:41',NULL,'1','Add New Invoice','1'),
('3418','VR-24-3418','2024-02-08 00:00:00','0','1250.00','1','294.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-08 10:26:00','2024-02-08 10:26:00',NULL,'1','Add New Invoice','1'),
('3419','VR-24-3419','2024-02-08 00:00:00','0','1250.00','1','59.31','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-08 10:30:06','2024-02-08 10:30:06',NULL,'1','Add New Invoice','1'),
('3420','VR-24-3420','2024-02-08 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-02-08 10:42:23','2024-02-08 10:42:23',NULL,'1','Add New Invoice','1'),
('3421','VR-24-3421','2024-02-08 00:00:00','0','1250.00','1','111.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-02-08 13:41:14','2024-02-08 13:41:14',NULL,'1','Add New Invoice','1'),
('3422','VR-24-3422','2024-02-08 00:00:00','0','1250.00','1','226.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-08 13:45:49','2024-02-08 13:45:49',NULL,'1','Add New Invoice','1'),
('3423','VR-24-3423','2024-02-08 00:00:00','0','1250.00','1','41.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-08 13:46:45','2024-02-08 13:46:45',NULL,'1','Add New Invoice','1'),
('3424','VR-24-3424','2024-02-08 00:00:00','0','1250.00','1','38.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-08 13:47:59','2024-02-08 13:47:59',NULL,'1','Add New Invoice','1'),
('3425','VR-24-3425','2024-02-08 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-08 13:49:07','2024-02-08 13:49:07',NULL,'1','Add New Invoice','1'),
('3426','VR-24-3426','2024-02-08 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-08 13:52:37','2024-02-08 13:52:37',NULL,'1','Add New Invoice','1'),
('3427','VR-24-3427','2024-02-10 00:00:00','0','1250.00','1','108.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-02-10 09:58:08','2024-02-10 09:58:08',NULL,'1','Add New Invoice','1'),
('3428','VR-24-3428','2024-02-11 00:00:00','0','1250.00','1','106.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-02-11 12:03:59','2024-02-11 12:03:59',NULL,'1','Add New Invoice','1'),
('3429','VR-24-3429','2024-02-11 00:00:00','0','1250.00','1','500.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-11 12:24:08','2024-02-11 12:24:08',NULL,'1','Add New Invoice','1'),
('3430','VR-24-3430','2024-02-11 00:00:00','0','1250.00','1','55.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-11 12:46:29','2024-02-11 12:46:29',NULL,'1','Add New Invoice','1'),
('3431','VR-24-3431','2024-02-11 00:00:00','0','1250.00','1','159.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-11 12:54:48','2024-02-11 12:54:48',NULL,'1','Add New Invoice','1'),
('3432','VR-24-3432','2024-02-11 00:00:00','0','1250.00','1','412.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-11 12:57:08','2024-02-11 12:57:08',NULL,'1','Add New Invoice','1'),
('3433','VR-24-3433','2024-02-11 00:00:00','0','1250.00','1','306.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-02-11 13:04:28','2024-02-11 13:04:28',NULL,'1','Add New Invoice','1'),
('3434','VR-24-3434','2024-02-11 00:00:00','0','1250.00','1','180.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-02-11 13:05:16','2024-02-11 13:05:16',NULL,'1','Add New Invoice','1'),
('3435','VR-24-3435','2024-02-11 00:00:00','0','1250.00','1','1077.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-02-11 13:19:01','2024-02-11 13:19:01',NULL,'1','Add New Invoice','1'),
('3436','INV-24-3436','2024-02-11 00:00:00','0','1250.00','1','30.88','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-11 03:21:56','2024-02-11 03:21:56',NULL,'1','Add New Invoice','1'),
('3437','VR-24-3437','2024-02-12 00:00:00','0','1250.00','1','205.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-12 12:48:05','2024-02-12 12:48:05',NULL,'1','Add New Invoice','1'),
('3438','VR-24-3438','2024-02-12 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-02-12 15:59:15','2024-02-12 15:59:15',NULL,'1','Add New Invoice','1'),
('3439','VR-24-3439','2024-02-12 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-12 16:00:03','2024-02-12 16:00:03',NULL,'1','Add New Invoice','1'),
('3440','VR-24-3440','2024-02-13 00:00:00','0','1250.00','1','463.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-13 10:07:36','2024-02-13 10:07:36',NULL,'1','Add New Invoice','1'),
('3441','VR-24-3441','2024-02-13 00:00:00','0','1250.00','1','80.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-13 10:12:02','2024-02-13 10:12:02',NULL,'1','Add New Invoice','1'),
('3442','VR-24-3442','2024-02-13 00:00:00','0','1250.00','1','151.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-02-13 11:41:54','2024-02-13 11:41:54',NULL,'1','Add New Invoice','1'),
('3443','VR-24-3443','2024-02-13 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-02-13 11:45:21','2024-02-13 11:45:21',NULL,'1','Add New Invoice','1'),
('3444','VR-24-3444','2024-02-13 00:00:00','0','1250.00','1','1177.57','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-02-13 11:50:14','2024-02-13 01:06:58',NULL,'1','Update Invoice','1'),
('3445','VR-24-3445','2024-02-13 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-02-13 11:57:40','2024-02-13 11:57:40',NULL,'1','Add New Invoice','1'),
('3446','VR-24-3446','2024-02-13 00:00:00','0','1250.00','1','27.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','1','2024-02-13 11:59:51','2024-02-13 11:59:51','2024-02-13 01:06:32','1','Delete Invoice','1'),
('3447','VR-24-3447','2024-02-13 00:00:00','0','1250.00','1','107.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-13 12:01:22','2024-02-13 12:01:22',NULL,'1','Add New Invoice','1'),
('3448','VR-24-3448','2024-02-13 00:00:00','0','1250.00','1','76.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-02-13 13:09:33','2024-02-13 13:09:33',NULL,'1','Add New Invoice','1'),
('3449','VR-24-3449','2024-02-13 00:00:00','0','1250.00','1','285.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-13 13:11:27','2024-02-14 01:27:49',NULL,'1','Update Invoice','1'),
('3450','VR-24-3450','2024-02-14 00:00:00','0','1250.00','1','970.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-14 11:55:59','2024-02-14 11:55:59',NULL,'1','Add New Invoice','1'),
('3451','VR-24-3451','2024-02-14 00:00:00','0','1250.00','1','471.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-02-14 15:06:46','2024-02-14 15:06:46',NULL,'1','Add New Invoice','1'),
('3452','VR-24-3452','2024-02-14 00:00:00','0','1250.00','1','198.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-14 15:29:43','2024-02-24 09:38:16',NULL,'1','Update Invoice','1'),
('3453','VR-24-3453','2024-02-14 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-02-14 15:30:23','2024-02-14 15:30:23',NULL,'1','Add New Invoice','1'),
('3454','VR-24-3454','2024-02-14 00:00:00','0','1250.00','1','771.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-14 15:35:33','2024-02-17 11:46:51',NULL,'1','Update Invoice','1'),
('3455','VR-24-3455','2024-02-14 00:00:00','0','1250.00','1','231.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-02-14 15:38:28','2024-02-14 15:38:28',NULL,'1','Add New Invoice','1'),
('3456','VR-24-3456','2024-02-14 00:00:00','0','1250.00','1','1413.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-02-14 15:41:01','2024-02-14 15:41:01',NULL,'1','Add New Invoice','1'),
('3457','VR-24-3457','2024-02-14 00:00:00','0','1250.00','1','474.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-02-14 15:45:02','2024-02-14 15:45:02',NULL,'1','Add New Invoice','1'),
('3458','VR-24-3458','2024-02-14 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-02-14 15:52:54','2024-02-14 15:52:54',NULL,'1','Add New Invoice','1'),
('3459','VR-24-3459','2024-02-14 00:00:00','0','1250.00','1','26.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-02-14 16:02:35','2024-02-14 16:02:35',NULL,'1','Add New Invoice','1'),
('3460','VR-24-3460','2024-02-14 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-02-14 16:03:14','2024-02-14 16:03:14',NULL,'1','Add New Invoice','1'),
('3461','VR-24-3461','2024-02-15 00:00:00','0','1250.00','1','630.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-15 13:57:36','2024-02-15 13:57:36',NULL,'1','Add New Invoice','1'),
('3462','VR-24-3462','2024-02-15 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-15 14:06:58','2024-02-15 14:06:58',NULL,'1','Add New Invoice','1'),
('3463','VR-24-3463','2024-02-15 00:00:00','0','1250.00','1','354.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-02-15 14:57:58','2024-02-15 14:57:58',NULL,'1','Add New Invoice','1'),
('3464','VR-24-3464','2024-02-17 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2024-02-17 11:54:54','2024-02-17 11:54:54',NULL,'1','Add New Invoice','1'),
('3465','VR-24-3465','2024-02-17 00:00:00','0','1250.00','1','363.31','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-17 13:55:39','2024-02-17 13:55:39',NULL,'1','Add New Invoice','1'),
('3466','VR-24-3466','2024-02-18 00:00:00','0','1250.00','1','9.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-18 14:35:24','2024-02-18 04:03:04',NULL,'1','Update Invoice','1'),
('3467','VR-24-3467','2024-02-19 00:00:00','0','1250.00','1','156.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-19 08:57:07','2024-02-19 08:57:07',NULL,'1','Add New Invoice','1'),
('3468','VR-24-3468','2024-02-19 00:00:00','0','1250.00','1','148.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-19 11:02:52','2024-02-19 11:02:52',NULL,'1','Add New Invoice','1'),
('3469','VR-24-3469','2024-02-19 00:00:00','0','1250.00','1','176.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-19 13:40:40','2024-02-19 13:40:40',NULL,'1','Add New Invoice','1'),
('3470','VR-24-3470','2024-02-19 00:00:00','0','1250.00','1','3869.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-19 14:00:40','2024-02-24 09:19:21',NULL,'1','Update Invoice','1'),
('3471','VR-24-3471','2024-02-20 00:00:00','0','1250.00','1','350.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-20 11:03:25','2024-02-20 11:03:25',NULL,'1','Add New Invoice','1'),
('3472','VR-24-3472','2024-02-20 00:00:00','0','1250.00','1','939.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-20 11:38:38','2024-04-03 02:34:16',NULL,'1','Update Invoice','1'),
('3473','VR-24-3473','2024-02-20 00:00:00','0','1250.00','1','1011.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-02-20 12:21:09','2024-02-20 12:32:35',NULL,'1','Update Invoice','1'),
('3474','VR-24-3474','2024-02-20 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-02-20 12:22:36','2024-02-20 12:22:36',NULL,'1','Add New Invoice','1'),
('3475','VR-24-3475','2024-02-20 00:00:00','0','1250.00','1','209.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-20 12:30:54','2024-02-20 12:30:54',NULL,'1','Add New Invoice','1'),
('3476','VR-24-3476','2024-02-20 00:00:00','0','1250.00','1','747.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-02-20 12:36:38','2024-02-20 12:36:38',NULL,'1','Add New Invoice','1'),
('3477','VR-24-3477','2024-02-20 00:00:00','0','1250.00','1','238.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-20 13:17:10','2024-02-21 09:42:40',NULL,'1','Update Invoice','1'),
('3478','VR-24-3478','2024-02-20 00:00:00','0','1250.00','1','26.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-20 13:29:55','2024-02-20 13:29:55',NULL,'1','Add New Invoice','1'),
('3479','VR-24-3479','2024-02-20 00:00:00','0','1250.00','1','137.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-02-20 13:45:22','2024-02-20 01:49:41',NULL,'1','Update Invoice','1'),
('3480','VR-24-3480','2024-02-20 00:00:00','0','1250.00','1','270.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-02-20 13:46:49','2024-02-20 01:51:50',NULL,'1','Update Invoice','1'),
('3481','VR-24-3481','2024-02-20 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-20 13:47:26','2024-02-20 13:47:26',NULL,'1','Add New Invoice','1'),
('3482','VR-24-3482','2024-02-20 00:00:00','0','1250.00','1','26.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-02-20 13:52:50','2024-02-20 13:52:50',NULL,'1','Add New Invoice','1'),
('3483','VR-24-3483','2024-02-20 00:00:00','0','1250.00','1','49.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-02-20 13:57:13','2024-02-20 13:57:13',NULL,'1','Add New Invoice','1'),
('3484','VR-24-3484','2024-02-20 00:00:00','0','1250.00','1','26.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-20 13:57:53','2024-02-20 13:57:53',NULL,'1','Add New Invoice','1'),
('3485','VR-24-3485','2024-02-20 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-02-20 14:00:57','2024-02-20 14:00:57',NULL,'1','Add New Invoice','1'),
('3486','VR-24-3486','2024-02-21 00:00:00','0','1250.00','1','47.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-02-21 10:02:31','2024-02-21 10:02:31',NULL,'1','Add New Invoice','1'),
('3487','VR-24-3487','2024-02-21 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-02-21 10:04:12','2024-02-21 10:04:12',NULL,'1','Add New Invoice','1'),
('3488','VR-24-3488','2024-02-21 00:00:00','0','1250.00','1','72.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-02-21 10:05:19','2024-02-21 10:05:19',NULL,'1','Add New Invoice','1'),
('3489','VR-24-3489','2024-02-21 00:00:00','0','1250.00','1','24.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-21 10:06:46','2024-02-21 10:06:46',NULL,'1','Add New Invoice','1'),
('3490','VR-24-3490','2024-02-21 00:00:00','0','1250.00','1','357.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-21 10:25:47','2024-02-21 10:25:47',NULL,'1','Add New Invoice','1'),
('3491','VR-24-3491','2024-02-21 00:00:00','0','1250.00','1','1044.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-21 10:34:12','2024-02-21 10:34:12',NULL,'1','Add New Invoice','1'),
('3492','VR-24-3492','2024-02-22 00:00:00','0','1250.00','1','46.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-02-22 09:58:48','2024-02-22 09:58:48',NULL,'1','Add New Invoice','1'),
('3493','INV-24-3493','2024-02-22 00:00:00','0','1250.00','1','452.69','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-22 10:34:55','2024-02-22 10:34:55',NULL,'1','Add New Invoice','1'),
('3494','VR-24-3494','2024-02-22 00:00:00','0','1250.00','1','195.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-02-22 11:28:47','2024-02-22 11:28:47',NULL,'1','Add New Invoice','1'),
('3495','VR-24-3495','2024-02-22 00:00:00','0','1250.00','1','490.50','0.00','علي اياد نجف','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-22 11:31:05','2024-02-22 11:31:40',NULL,'1','Update Invoice','1'),
('3496','VR-24-3496','2024-02-22 00:00:00','0','1250.00','1','1050.66','0.00','زيد نجف','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-22 11:38:22','2024-02-22 11:38:22',NULL,'1','Add New Invoice','1'),
('3497','VR-24-3497','2024-02-22 00:00:00','0','1250.00','1','2183.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2024-02-22 11:56:27','2024-02-22 11:56:27',NULL,'1','Add New Invoice','1'),
('3498','VR-24-3498','2024-02-22 00:00:00','0','1250.00','1','258.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-02-22 12:05:00','2024-02-22 12:05:00',NULL,'1','Add New Invoice','1'),
('3499','VR-24-3499','2024-02-22 00:00:00','0','1250.00','1','140.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-22 12:05:58','2024-02-22 12:05:58',NULL,'1','Add New Invoice','1'),
('3500','VR-24-3500','2024-02-22 00:00:00','0','1250.00','1','99.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-02-22 12:06:48','2024-02-22 12:06:48',NULL,'1','Add New Invoice','1'),
('3501','VR-24-3501','2024-02-22 00:00:00','0','1250.00','1','197.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-22 12:12:58','2024-02-22 12:12:58',NULL,'1','Add New Invoice','1'),
('3502','VR-24-3502','2024-02-22 00:00:00','0','1250.00','1','1024.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-02-22 12:17:12','2024-02-22 12:17:12',NULL,'1','Add New Invoice','1'),
('3503','VR-24-3503','2024-02-22 00:00:00','0','1250.00','1','257.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-22 12:18:53','2024-02-28 11:47:53',NULL,'1','Update Invoice','1'),
('3504','VR-24-3504','2024-02-22 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-02-22 12:28:06','2024-02-22 12:28:06',NULL,'1','Add New Invoice','1'),
('3505','VR-24-3505','2024-02-22 00:00:00','0','1250.00','1','382.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-22 12:44:07','2024-02-22 12:44:07',NULL,'1','Add New Invoice','1'),
('3506','VR-24-3506','2024-02-22 00:00:00','0','1250.00','1','160.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-22 12:55:08','2024-02-22 12:55:08',NULL,'1','Add New Invoice','1'),
('3507','VR-24-3507','2024-02-22 00:00:00','0','1250.00','1','110.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-02-22 13:17:28','2024-02-22 13:17:28',NULL,'1','Add New Invoice','1'),
('3508','VR-24-3508','2024-02-22 00:00:00','0','1250.00','1','124.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-02-22 13:35:34','2024-02-22 13:35:34',NULL,'1','Add New Invoice','1'),
('3509','VR-24-3509','2024-02-24 00:00:00','0','1250.00','1','682.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-02-24 11:57:11','2024-02-24 11:57:11',NULL,'1','Add New Invoice','1'),
('3510','INV-24-3510','2024-02-24 00:00:00','0','1250.00','1','162.47','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-02-24 03:14:41','2024-02-24 03:14:41',NULL,'1','Add New Invoice','1'),
('3511','VR-24-3511','2024-02-25 00:00:00','0','1250.00','1','1367.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','123','0','2024-02-25 09:46:00','2024-02-25 09:46:00',NULL,'1','Add New Invoice','1'),
('3512','VR-24-3512','2024-02-25 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-02-25 09:49:24','2024-02-25 09:49:24',NULL,'1','Add New Invoice','1'),
('3513','VR-24-3513','2024-02-25 00:00:00','0','1250.00','1','53.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','100','0','2024-02-25 09:57:07','2024-02-25 09:57:07',NULL,'1','Add New Invoice','1'),
('3514','VR-24-3514','2024-02-25 00:00:00','0','1250.00','1','1277.27','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','113','0','2024-02-25 11:21:16','2024-02-25 11:21:16',NULL,'1','Add New Invoice','1'),
('3515','INV-24-3515','2024-02-25 00:00:00','0','1250.00','1','554.11','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-02-25 12:48:53','2024-02-25 12:48:53',NULL,'1','Add New Invoice','1'),
('3516','VR-24-3516','2024-02-25 00:00:00','0','1250.00','1','96.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-25 13:38:35','2024-02-25 13:38:35',NULL,'1','Add New Invoice','1'),
('3517','VR-24-3517','2024-02-26 00:00:00','0','1250.00','1','88.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-26 10:07:04','2024-02-26 10:07:04',NULL,'1','Add New Invoice','1'),
('3518','VR-24-3518','2024-02-26 00:00:00','0','1250.00','1','2651.64','0.00','1','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-26 10:20:58','2024-02-26 10:20:58',NULL,'1','Add New Invoice','1'),
('3519','VR-24-3519','2024-02-27 00:00:00','0','1250.00','1','4937.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-02-27 09:35:15','2024-02-27 11:22:51',NULL,'1','Update Invoice','1'),
('3520','VR-24-3520','2024-02-27 00:00:00','0','1250.00','1','7618.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-02-27 10:06:15','2024-02-27 10:06:15',NULL,'1','Add New Invoice','1'),
('3521','VR-24-3521','2024-02-27 00:00:00','0','1250.00','1','102.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-02-27 10:21:46','2024-02-27 10:21:46',NULL,'1','Add New Invoice','1'),
('3522','VR-24-3522','2024-02-27 00:00:00','0','1250.00','1','485.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-27 10:28:25','2024-02-27 10:28:25',NULL,'1','Add New Invoice','1'),
('3523','VR-24-3523','2024-02-27 00:00:00','0','1250.00','1','105.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-02-27 10:51:16','2024-02-27 10:51:16',NULL,'1','Add New Invoice','1'),
('3524','VR-24-3524','2024-02-27 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-02-27 10:53:39','2024-02-27 10:53:39',NULL,'1','Add New Invoice','1'),
('3525','VR-24-3525','2024-02-27 00:00:00','0','1250.00','1','378.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-02-27 10:54:42','2024-02-27 10:54:42',NULL,'1','Add New Invoice','1'),
('3526','VR-24-3526','2024-02-27 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-02-27 11:31:55','2024-02-27 11:31:55',NULL,'1','Add New Invoice','1'),
('3527','VR-24-3527','2024-02-27 00:00:00','0','1250.00','1','425.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-02-27 11:38:34','2024-02-27 11:38:34',NULL,'1','Add New Invoice','1'),
('3528','VR-24-3528','2024-02-27 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-02-27 11:52:05','2024-02-27 11:52:05',NULL,'1','Add New Invoice','1'),
('3529','VR-24-3529','2024-02-27 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-02-27 11:55:15','2024-02-27 11:55:15',NULL,'1','Add New Invoice','1'),
('3530','VR-24-3530','2024-02-27 00:00:00','0','1250.00','1','119.31','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-02-27 12:51:43','2024-02-27 12:51:43',NULL,'1','Add New Invoice','1'),
('3531','VR-24-3531','2024-02-27 00:00:00','0','1250.00','1','216.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-02-27 18:42:34','2024-02-27 18:42:34',NULL,'1','Add New Invoice','1'),
('3532','VR-24-3532','2024-02-28 00:00:00','0','1250.00','1','159.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-28 10:18:47','2024-02-28 10:18:47',NULL,'1','Add New Invoice','1'),
('3533','VR-24-3533','2024-02-28 00:00:00','0','1250.00','1','226.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-02-28 10:29:59','2024-02-28 10:29:59',NULL,'1','Add New Invoice','1'),
('3534','VR-24-3534','2024-02-28 00:00:00','0','1250.00','1','518.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-28 11:24:13','2024-02-28 11:24:13',NULL,'1','Add New Invoice','1'),
('3535','VR-24-3535','2024-02-28 00:00:00','0','1250.00','1','295.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-02-28 12:11:22','2024-02-28 12:11:22',NULL,'1','Add New Invoice','1'),
('3536','VR-24-3536','2024-02-28 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-02-28 12:17:32','2024-02-28 12:17:32',NULL,'1','Add New Invoice','1'),
('3537','VR-24-3537','2024-02-28 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-02-28 13:52:33','2024-02-28 13:52:33',NULL,'1','Add New Invoice','1'),
('3538','VR-24-3538','2024-02-28 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-28 13:53:49','2024-02-28 13:53:49',NULL,'1','Add New Invoice','1'),
('3539','VR-24-3539','2024-02-28 00:00:00','0','1250.00','1','20.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-02-28 13:57:36','2024-02-28 13:57:36',NULL,'1','Add New Invoice','1'),
('3540','VR-24-3540','2024-02-28 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-02-28 14:01:11','2024-02-28 14:01:11',NULL,'1','Add New Invoice','1'),
('3541','VR-24-3541','2024-02-29 00:00:00','0','1250.00','1','608.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-02-29 11:01:28','2024-02-29 11:01:28',NULL,'1','Add New Invoice','1'),
('3542','VR-24-3542','2024-02-29 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-02-29 11:07:45','2024-02-29 11:07:45',NULL,'1','Add New Invoice','1'),
('3543','VR-24-3543','2024-02-29 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-02-29 11:09:12','2024-02-29 11:09:12',NULL,'1','Add New Invoice','1'),
('3544','VR-24-3544','2024-02-29 00:00:00','0','1250.00','1','160.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-02-29 11:11:41','2024-02-29 11:11:41',NULL,'1','Add New Invoice','1'),
('3545','VR-24-3545','2024-02-29 00:00:00','0','1250.00','1','72.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-02-29 11:13:31','2024-02-29 11:13:31',NULL,'1','Add New Invoice','1'),
('3546','VR-24-3546','2024-02-29 00:00:00','0','1250.00','1','20.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-02-29 11:20:15','2024-02-29 11:20:15',NULL,'1','Add New Invoice','1'),
('3547','VR-24-3547','2024-02-29 00:00:00','0','1250.00','1','123.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-02-29 12:02:51','2024-02-29 12:02:51',NULL,'1','Add New Invoice','1'),
('3548','VR-24-3548','2024-03-02 00:00:00','0','1250.00','1','755.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-02 15:58:47','2024-03-28 12:40:25',NULL,'1','Update Invoice','1'),
('3549','VR-24-3549','2024-03-03 00:00:00','0','1250.00','1','72.52','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-03 10:57:58','2024-03-03 10:57:58',NULL,'1','Add New Invoice','1'),
('3550','VR-24-3550','2024-03-03 00:00:00','0','1250.00','1','47.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-03 11:05:05','2024-03-03 11:05:05',NULL,'1','Add New Invoice','1'),
('3551','VR-24-3551','2024-03-03 00:00:00','0','1250.00','1','461.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-03 11:34:50','2024-03-03 11:34:50',NULL,'1','Add New Invoice','1'),
('3552','VR-24-3552','2024-03-03 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-03-03 11:35:56','2024-03-03 11:35:56',NULL,'1','Add New Invoice','1'),
('3553','VR-24-3553','2024-03-03 00:00:00','0','1250.00','1','311.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','124','0','2024-03-03 11:54:47','2024-03-03 11:54:47',NULL,'1','Add New Invoice','1'),
('3554','VR-24-3554','2024-03-03 00:00:00','0','1250.00','1','325.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-03 15:00:43','2024-03-03 03:02:33',NULL,'1','Update Invoice','1'),
('3555','VR-24-3555','2024-03-03 00:00:00','0','1250.00','1','2282.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-03 15:14:14','2024-03-03 15:14:14',NULL,'1','Add New Invoice','1'),
('3556','VR-24-3556','2024-03-03 00:00:00','0','1250.00','1','51.99','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-03 15:19:16','2024-03-03 15:19:16',NULL,'1','Add New Invoice','1'),
('3557','VR-24-3557','2024-03-03 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-03-03 15:27:43','2024-03-03 15:27:43',NULL,'1','Add New Invoice','1'),
('3558','VR-24-3558','2024-03-03 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-03-03 15:54:28','2024-03-03 15:54:28',NULL,'1','Add New Invoice','1'),
('3559','VR-24-3559','2024-03-03 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-03-03 16:00:54','2024-03-03 16:00:54',NULL,'1','Add New Invoice','1'),
('3560','VR-24-3560','2024-03-03 00:00:00','0','1250.00','1','37.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-03-03 16:02:57','2024-03-03 16:02:57',NULL,'1','Add New Invoice','1'),
('3561','VR-24-3561','2024-03-03 00:00:00','0','1250.00','1','965.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-03-03 16:05:29','2024-04-04 11:14:08',NULL,'1','Update Invoice','1'),
('3562','VR-24-3562','2024-03-04 00:00:00','0','1250.00','1','151.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-03-04 15:18:38','2024-03-04 15:18:38',NULL,'1','Add New Invoice','1'),
('3563','VR-24-3563','2024-03-04 00:00:00','0','1250.00','1','111.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-03-04 15:27:01','2024-03-04 15:27:01',NULL,'1','Add New Invoice','1'),
('3564','VR-24-3564','2024-03-04 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-04 15:54:34','2024-03-04 15:54:34',NULL,'1','Add New Invoice','1'),
('3565','VR-24-3565','2024-03-04 00:00:00','0','1250.00','1','134.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2024-03-04 15:56:08','2024-03-04 15:56:08',NULL,'1','Add New Invoice','1'),
('3566','VR-24-3566','2024-03-04 00:00:00','0','1250.00','1','33.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-03-04 15:57:48','2024-03-04 15:57:48',NULL,'1','Add New Invoice','1'),
('3567','VR-24-3567','2024-03-04 00:00:00','0','1250.00','1','235.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-04 16:01:48','2024-03-04 04:12:18',NULL,'1','Update Invoice','1'),
('3568','VR-24-3568','2024-03-05 00:00:00','0','1250.00','1','203.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-03-05 11:08:43','2024-03-05 11:08:43',NULL,'1','Add New Invoice','1'),
('3569','VR-24-3569','2024-03-05 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-03-05 12:28:23','2024-03-05 12:28:23',NULL,'1','Add New Invoice','1'),
('3570','VR-24-3570','2024-03-05 00:00:00','0','1250.00','1','84.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-03-05 12:35:25','2024-03-06 10:53:02',NULL,'1','Update Invoice','1'),
('3571','VR-24-3571','2024-03-06 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-03-06 09:52:51','2024-03-06 09:52:51',NULL,'1','Add New Invoice','1'),
('3572','VR-24-3572','2024-03-06 00:00:00','0','1250.00','1','200.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-06 10:18:40','2024-03-06 10:18:40',NULL,'1','Add New Invoice','1'),
('3573','VR-24-3573','2024-03-06 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-03-06 10:24:46','2024-03-06 10:24:46',NULL,'1','Add New Invoice','1'),
('3574','VR-24-3574','2024-03-06 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-06 10:25:49','2024-03-06 10:25:49',NULL,'1','Add New Invoice','1'),
('3575','VR-24-3575','2024-03-06 00:00:00','0','1250.00','1','212.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-06 10:29:56','2024-03-06 10:29:56',NULL,'1','Add New Invoice','1'),
('3576','VR-24-3576','2024-03-06 00:00:00','0','1250.00','1','290.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-03-06 10:40:32','2024-03-06 10:40:32',NULL,'1','Add New Invoice','1'),
('3577','VR-24-3577','2024-03-06 00:00:00','0','1250.00','1','444.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-06 11:34:37','2024-03-06 11:34:37',NULL,'1','Add New Invoice','1'),
('3578','VR-24-3578','2024-03-06 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-03-06 11:40:35','2024-03-06 11:40:35',NULL,'1','Add New Invoice','1'),
('3579','VR-24-3579','2024-03-06 00:00:00','0','1250.00','1','106.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-06 11:45:02','2024-03-06 11:45:02',NULL,'1','Add New Invoice','1'),
('3580','VR-24-3580','2024-03-06 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-03-06 11:46:11','2024-03-06 11:46:11',NULL,'1','Add New Invoice','1'),
('3581','VR-24-3581','2024-03-06 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-06 11:49:14','2024-03-06 11:55:41',NULL,'1','Update Invoice','1'),
('3582','VR-24-3582','2024-03-06 00:00:00','0','1250.00','1','212.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-06 11:51:35','2024-03-06 11:51:35',NULL,'1','Add New Invoice','1'),
('3583','VR-24-3583','2024-03-07 00:00:00','0','1250.00','1','7542.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-03-07 09:21:52','2024-03-07 09:21:52',NULL,'1','Add New Invoice','1'),
('3584','INV-24-3584','2024-03-07 00:00:00','0','1250.00','1','162.84','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-03-07 12:14:54','2024-03-07 12:14:54',NULL,'1','Add New Invoice','1'),
('3585','VR-24-3585','2024-03-09 00:00:00','0','1250.00','1','43.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-03-09 14:39:56','2024-03-09 14:39:56',NULL,'1','Add New Invoice','1'),
('3586','VR-24-3586','2024-03-09 00:00:00','0','1250.00','1','172.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-03-09 14:46:20','2024-03-09 14:46:20',NULL,'1','Add New Invoice','1'),
('3587','VR-24-3587','2024-03-09 00:00:00','0','1250.00','1','303.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-03-09 14:49:17','2024-03-09 14:49:17',NULL,'1','Add New Invoice','1'),
('3588','VR-24-3588','2024-03-09 00:00:00','0','1250.00','1','171.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-03-09 14:50:02','2024-03-09 14:50:02',NULL,'1','Add New Invoice','1'),
('3589','VR-24-3589','2024-03-09 00:00:00','0','1250.00','1','164.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-03-09 14:59:54','2024-03-09 14:59:54',NULL,'1','Add New Invoice','1'),
('3590','VR-24-3590','2024-03-09 00:00:00','0','1250.00','1','145.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-03-09 15:01:08','2024-03-09 15:01:08',NULL,'1','Add New Invoice','1'),
('3591','VR-24-3591','2024-03-09 00:00:00','0','1250.00','1','204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-09 15:05:20','2024-03-09 15:05:20',NULL,'1','Add New Invoice','1'),
('3592','VR-24-3592','2024-03-09 00:00:00','0','1250.00','1','466.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-03-09 15:08:58','2024-03-10 02:09:32',NULL,'1','Update Invoice','1'),
('3593','VR-24-3593','2024-03-09 00:00:00','0','1250.00','1','176.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-09 15:09:50','2024-03-09 15:09:50',NULL,'1','Add New Invoice','1'),
('3594','VR-24-3594','2024-03-09 00:00:00','0','1250.00','1','27.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-09 15:12:58','2024-03-09 15:12:58',NULL,'1','Add New Invoice','1'),
('3595','VR-24-3595','2024-03-09 00:00:00','0','1250.00','1','254.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-03-09 15:42:01','2024-03-09 15:42:01',NULL,'1','Add New Invoice','1'),
('3596','VR-24-3596','2024-03-09 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-03-09 15:44:37','2024-03-09 15:44:37',NULL,'1','Add New Invoice','1'),
('3597','VR-24-3597','2024-03-09 00:00:00','0','1250.00','1','66.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-09 16:12:49','2024-03-09 16:12:49',NULL,'1','Add New Invoice','1'),
('3598','VR-24-3598','2024-03-09 00:00:00','0','1250.00','1','281.41','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-09 16:16:02','2024-03-10 02:08:44',NULL,'1','Update Invoice','1'),
('3599','VR-24-3599','2024-03-10 00:00:00','0','1250.00','1','11915.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-10 09:37:49','2024-03-10 09:37:49',NULL,'1','Add New Invoice','1'),
('3600','VR-24-3600','2024-03-10 00:00:00','0','1250.00','1','7146.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-10 10:22:17','2024-03-10 10:22:17',NULL,'1','Add New Invoice','1'),
('3601','VR-24-3601','2024-03-10 00:00:00','0','1250.00','1','7478.23','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-10 12:20:17','2024-03-15 01:40:36',NULL,'1','Update Invoice','1'),
('3602','VR-24-3602','2024-03-10 00:00:00','0','1250.00','1','118.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-10 13:59:55','2024-03-10 13:59:55',NULL,'1','Add New Invoice','1'),
('3603','INV-24-3603','2024-03-10 00:00:00','0','1250.00','1','69.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-10 02:32:43','2024-03-10 02:32:43',NULL,'1','Add New Invoice','1'),
('3604','VR-24-3604','2024-03-10 00:00:00','0','1250.00','1','6855.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2024-03-10 14:50:47','2024-03-10 14:50:47',NULL,'1','Add New Invoice','1'),
('3605','VR-24-3605','2024-03-11 00:00:00','0','1250.00','1','790.74','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-11 11:31:52','2024-03-11 11:31:52',NULL,'1','Add New Invoice','1'),
('3606','VR-24-3606','2024-03-11 00:00:00','0','1250.00','1','154.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-03-11 12:08:04','2024-03-11 12:08:04',NULL,'1','Add New Invoice','1'),
('3607','VR-24-3607','2024-03-11 00:00:00','0','1250.00','1','351.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-11 15:28:38','2024-03-11 15:28:38',NULL,'1','Add New Invoice','1'),
('3608','VR-24-3608','2024-03-11 00:00:00','0','1250.00','1','594.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-03-11 15:30:01','2024-03-11 15:30:01',NULL,'1','Add New Invoice','1'),
('3609','INV-24-3609','2024-03-11 00:00:00','0','1250.00','1','31.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-03-11 04:21:16','2024-03-11 04:21:16',NULL,'1','Add New Invoice','1'),
('3610','INV-24-3610','2024-03-11 00:00:00','0','1250.00','1','117.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-11 04:23:20','2024-03-11 04:23:20',NULL,'1','Add New Invoice','1'),
('3611','INV-24-3611','2024-03-11 00:00:00','0','1250.00','1','188.80','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-11 04:25:43','2024-03-11 04:25:43',NULL,'1','Add New Invoice','1'),
('3612','INV-24-3612','2024-03-11 00:00:00','0','1250.00','1','22.92','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-11 04:28:16','2024-03-11 04:28:16',NULL,'1','Add New Invoice','1'),
('3613','VR-24-3613','2024-03-12 00:00:00','0','1250.00','1','334.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2024-03-12 10:42:15','2024-03-12 03:42:55',NULL,'1','Update Invoice','1'),
('3614','VR-24-3614','2024-03-12 00:00:00','0','1250.00','1','209.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-12 10:46:53','2024-03-12 04:42:44',NULL,'1','Update Invoice','1'),
('3615','VR-24-3615','2024-03-12 00:00:00','0','1250.00','1','67.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-03-12 10:50:41','2024-03-12 10:50:41',NULL,'1','Add New Invoice','1'),
('3616','VR-24-3616','2024-03-12 00:00:00','0','1250.00','1','147.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-03-12 15:41:28','2024-03-12 15:41:28',NULL,'1','Add New Invoice','1'),
('3617','VR-24-3617','2024-03-12 00:00:00','0','1250.00','1','283.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-12 15:48:01','2024-03-12 15:48:01',NULL,'1','Add New Invoice','1'),
('3618','VR-24-3618','2024-03-12 00:00:00','0','1250.00','1','106.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-03-12 15:50:05','2024-03-12 15:50:05',NULL,'1','Add New Invoice','1'),
('3619','VR-24-3619','2024-03-12 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-12 16:03:15','2024-03-12 16:03:15',NULL,'1','Add New Invoice','1'),
('3620','VR-24-3620','2024-03-12 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','1','2024-03-12 16:04:18','2024-03-12 16:04:18','2024-03-12 04:04:29','1','Delete Invoice','1'),
('3621','VR-24-3621','2024-03-12 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-03-12 16:04:51','2024-03-12 16:04:51',NULL,'1','Add New Invoice','1'),
('3622','VR-24-3622','2024-03-12 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-03-12 16:06:05','2024-03-12 16:06:05',NULL,'1','Add New Invoice','1'),
('3623','VR-24-3623','2024-03-12 00:00:00','0','1250.00','1','178.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-12 16:07:52','2024-03-12 16:07:52',NULL,'1','Add New Invoice','1'),
('3624','VR-24-3624','2024-03-13 00:00:00','0','1250.00','1','322.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-03-13 12:41:40','2024-03-14 11:42:59',NULL,'1','Update Invoice','1'),
('3625','VR-24-3625','2024-03-13 00:00:00','0','1250.00','1','314.11','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-13 14:36:01','2024-03-13 14:36:01',NULL,'1','Add New Invoice','1'),
('3626','VR-24-3626','2024-03-13 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-03-13 14:38:34','2024-03-13 14:38:34',NULL,'1','Add New Invoice','1'),
('3627','VR-24-3627','2024-03-13 00:00:00','0','1250.00','1','262.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-03-13 14:56:22','2024-03-14 09:44:46',NULL,'1','Update Invoice','1'),
('3628','VR-24-3628','2024-03-13 00:00:00','0','1250.00','1','1266.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-13 15:04:57','2024-03-13 15:04:57',NULL,'1','Add New Invoice','1'),
('3629','VR-24-3629','2024-03-14 00:00:00','0','1250.00','1','144.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-14 13:20:44','2024-03-14 13:20:44',NULL,'1','Add New Invoice','1'),
('3630','VR-24-3630','2024-03-14 00:00:00','0','1250.00','1','98.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-03-14 13:29:30','2024-03-14 13:29:30',NULL,'1','Add New Invoice','1'),
('3631','VR-24-3631','2024-03-14 00:00:00','0','1250.00','1','503.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-14 13:31:27','2024-03-16 04:20:24',NULL,'1','Update Invoice','1'),
('3632','VR-24-3632','2024-03-14 00:00:00','0','1250.00','1','115.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-14 13:32:07','2024-03-14 13:32:07',NULL,'1','Add New Invoice','1'),
('3633','VR-24-3633','2024-03-14 00:00:00','0','1250.00','1','523.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-03-14 13:40:44','2024-03-14 13:40:44',NULL,'1','Add New Invoice','1'),
('3634','VR-24-3634','2024-03-14 00:00:00','0','1250.00','1','260.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-14 13:46:11','2024-03-28 12:39:42',NULL,'1','Update Invoice','1'),
('3635','VR-24-3635','2024-03-14 00:00:00','0','1250.00','1','319.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-14 13:48:20','2024-03-14 13:48:20',NULL,'1','Add New Invoice','1'),
('3636','VR-24-3636','2024-03-14 00:00:00','0','1250.00','1','230.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-03-14 13:58:54','2024-03-14 13:58:54',NULL,'1','Add New Invoice','1'),
('3637','VR-24-3637','2024-03-14 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-03-14 14:01:27','2024-03-14 14:01:27',NULL,'1','Add New Invoice','1'),
('3638','VR-24-3638','2024-03-14 00:00:00','0','1250.00','1','28.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-14 14:07:58','2024-03-14 14:07:58',NULL,'1','Add New Invoice','1'),
('3639','INV-24-3639','2024-03-16 00:00:00','0','1250.00','1','78.97','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-16 02:52:44','2024-03-16 02:52:44',NULL,'1','Add New Invoice','1'),
('3640','VR-24-3640','2024-03-17 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-03-17 10:05:14','2024-03-17 10:05:14',NULL,'1','Add New Invoice','1'),
('3641','VR-24-3641','2024-03-17 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-03-17 10:07:39','2024-03-17 10:07:39',NULL,'1','Add New Invoice','1'),
('3642','VR-24-3642','2024-03-17 00:00:00','0','1250.00','1','362.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-03-17 10:35:41','2024-03-17 10:35:41',NULL,'1','Add New Invoice','1'),
('3643','VR-24-3643','2024-03-17 00:00:00','0','1250.00','1','539.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-17 13:03:25','2024-03-17 13:03:25',NULL,'1','Add New Invoice','1'),
('3644','VR-24-3644','2024-03-17 00:00:00','0','1250.00','1','86.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-17 14:42:05','2024-03-17 14:42:05',NULL,'1','Add New Invoice','1'),
('3645','VR-24-3645','2024-03-17 00:00:00','0','1250.00','1','39.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-17 14:43:29','2024-03-17 14:43:29',NULL,'1','Add New Invoice','1'),
('3646','VR-24-3646','2024-03-17 00:00:00','0','1250.00','1','173.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-17 14:45:21','2024-03-17 14:45:21',NULL,'1','Add New Invoice','1'),
('3647','VR-24-3647','2024-03-17 00:00:00','0','1250.00','1','4624.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-03-17 15:12:18','2024-03-17 04:09:17',NULL,'1','Update Invoice','1'),
('3648','INV-24-3648','2024-03-18 00:00:00','0','1250.00','1','39.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-03-18 11:29:07','2024-03-18 11:29:07',NULL,'1','Add New Invoice','1'),
('3649','VR-24-3649','2024-03-19 00:00:00','0','1250.00','1','323.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-19 10:59:48','2024-03-19 10:59:48',NULL,'1','Add New Invoice','1'),
('3650','VR-24-3650','2024-03-19 00:00:00','0','1250.00','1','165.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-03-19 11:13:28','2024-03-19 11:13:28',NULL,'1','Add New Invoice','1'),
('3651','VR-24-3651','2024-03-19 00:00:00','0','1250.00','1','1220.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','112','0','2024-03-19 11:55:35','2024-03-19 12:25:37',NULL,'1','Update Invoice','1'),
('3652','VR-24-3652','2024-03-20 00:00:00','0','1250.00','1','248.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-20 14:23:59','2024-03-20 14:23:59',NULL,'1','Add New Invoice','1'),
('3653','VR-24-3653','2024-03-20 00:00:00','0','1250.00','1','140.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-03-20 14:28:37','2024-03-20 14:28:37',NULL,'1','Add New Invoice','1'),
('3654','VR-24-3654','2024-03-20 00:00:00','0','1250.00','1','412.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-03-20 14:30:28','2024-03-20 02:58:57',NULL,'1','Update Invoice','1'),
('3655','VR-24-3655','2024-03-20 00:00:00','0','1250.00','1','1374.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-20 14:36:52','2024-03-20 14:36:52',NULL,'1','Add New Invoice','1'),
('3656','VR-24-3656','2024-03-20 00:00:00','0','1250.00','1','720.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-20 14:40:17','2024-03-21 09:24:13',NULL,'1','Update Invoice','1'),
('3657','VR-24-3657','2024-03-20 00:00:00','0','1250.00','1','544.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-03-20 15:16:21','2024-03-20 15:16:21',NULL,'1','Add New Invoice','1'),
('3658','VR-24-3658','2024-03-21 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-03-21 13:07:13','2024-03-21 13:07:13',NULL,'1','Add New Invoice','1'),
('3659','VR-24-3659','2024-03-21 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-21 13:10:07','2024-03-21 13:10:07',NULL,'1','Add New Invoice','1'),
('3660','VR-24-3660','2024-03-21 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-03-21 13:11:09','2024-03-21 13:11:09',NULL,'1','Add New Invoice','1'),
('3661','VR-24-3661','2024-03-21 00:00:00','0','1250.00','1','46.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-03-21 13:13:04','2024-03-21 13:13:04',NULL,'1','Add New Invoice','1'),
('3662','VR-24-3662','2024-03-21 00:00:00','0','1250.00','1','152.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','1','2024-03-21 13:15:27','2024-03-23 10:34:54','2024-03-23 12:41:50','1','Delete Invoice','1'),
('3663','VR-24-3663','2024-03-21 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','1','2024-03-21 13:16:39','2024-03-21 13:16:39','2024-03-23 10:34:36','1','Delete Invoice','1'),
('3664','VR-24-3664','2024-03-21 00:00:00','0','1250.00','1','114.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-21 13:19:13','2024-03-21 01:23:38',NULL,'1','Update Invoice','1'),
('3665','VR-24-3665','2024-03-21 00:00:00','0','1250.00','1','14.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','1','2024-03-21 13:20:00','2024-03-21 13:20:00','2024-03-21 01:20:14','1','Delete Invoice','1'),
('3666','VR-24-3666','2024-03-21 00:00:00','0','1250.00','1','184.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-03-21 13:22:32','2024-03-21 13:22:32',NULL,'1','Add New Invoice','1'),
('3667','VR-24-3667','2024-03-21 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-03-21 13:25:37','2024-03-21 13:25:37',NULL,'1','Add New Invoice','1'),
('3668','VR-24-3668','2024-03-21 00:00:00','0','1250.00','1','66.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-03-21 13:26:38','2024-03-21 13:26:38',NULL,'1','Add New Invoice','1'),
('3669','VR-24-3669','2024-03-23 00:00:00','0','1250.00','1','397.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-23 14:09:58','2024-03-23 14:09:58',NULL,'1','Add New Invoice','1'),
('3670','VR-24-3670','2024-03-23 00:00:00','0','1250.00','1','331.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-03-23 14:15:57','2024-03-23 14:15:57',NULL,'1','Add New Invoice','1'),
('3671','VR-24-3671','2024-03-23 00:00:00','0','1250.00','1','1240.46','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-23 14:18:53','2024-03-23 14:18:53',NULL,'1','Add New Invoice','1'),
('3672','VR-24-3672','2024-03-23 00:00:00','0','1250.00','1','24.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-03-23 14:20:13','2024-03-23 14:20:13',NULL,'1','Add New Invoice','1'),
('3673','VR-24-3673','2024-03-23 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-03-23 14:21:08','2024-03-23 14:21:08',NULL,'1','Add New Invoice','1'),
('3674','VR-24-3674','2024-03-24 00:00:00','0','1250.00','1','1717.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-03-24 13:51:12','2024-03-24 02:11:39',NULL,'1','Update Invoice','1'),
('3675','VR-24-3675','2024-03-24 00:00:00','0','1250.00','1','349.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-24 14:09:35','2024-03-24 14:09:35',NULL,'1','Add New Invoice','1'),
('3676','VR-24-3676','2024-03-24 00:00:00','0','1250.00','1','92.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-03-24 14:24:38','2024-03-24 14:24:38',NULL,'1','Add New Invoice','1'),
('3677','VR-24-3677','2024-03-24 00:00:00','0','1250.00','1','135.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-24 14:27:14','2024-03-24 03:58:21',NULL,'1','Update Invoice','1'),
('3678','VR-24-3678','2024-03-24 00:00:00','0','1250.00','1','969.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-24 15:34:05','2024-03-24 15:34:05',NULL,'1','Add New Invoice','1'),
('3679','VR-24-3679','2024-03-24 00:00:00','0','1250.00','1','181.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-03-24 15:36:09','2024-03-24 15:36:09',NULL,'1','Add New Invoice','1'),
('3680','VR-24-3680','2024-03-24 00:00:00','0','1250.00','1','45.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-24 15:39:08','2024-03-24 15:39:08',NULL,'1','Add New Invoice','1'),
('3681','VR-24-3681','2024-03-24 00:00:00','0','1250.00','1','140.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-03-24 15:40:52','2024-03-26 03:34:59',NULL,'1','Update Invoice','1'),
('3682','VR-24-3682','2024-03-26 00:00:00','0','1250.00','1','518.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-26 14:10:44','2024-03-26 14:10:44',NULL,'1','Add New Invoice','1'),
('3683','VR-24-3683','2024-03-27 00:00:00','0','1250.00','1','96.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-03-27 12:06:22','2024-03-27 12:06:22',NULL,'1','Add New Invoice','1'),
('3684','VR-24-3684','2024-03-27 00:00:00','0','1250.00','1','173.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-03-27 12:07:21','2024-03-27 12:07:21',NULL,'1','Add New Invoice','1'),
('3685','VR-24-3685','2024-03-27 00:00:00','0','1250.00','1','504.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-03-27 12:08:58','2024-03-27 12:08:58',NULL,'1','Add New Invoice','1'),
('3686','VR-24-3686','2024-03-27 00:00:00','0','1250.00','1','500.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-27 12:16:11','2024-03-27 12:16:11',NULL,'1','Add New Invoice','1'),
('3687','VR-24-3687','2024-03-27 00:00:00','0','1250.00','1','3275.92','0.00','87','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-03-27 12:46:59','2024-03-27 12:46:59',NULL,'1','Add New Invoice','1'),
('3688','VR-24-3688','2024-03-27 00:00:00','0','1250.00','1','182.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-27 13:07:46','2024-03-27 13:07:46',NULL,'1','Add New Invoice','1'),
('3689','VR-24-3689','2024-03-27 00:00:00','0','1250.00','1','59.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-27 13:52:13','2024-03-27 13:52:13',NULL,'1','Add New Invoice','1'),
('3690','VR-24-3690','2024-03-27 00:00:00','0','1250.00','1','92.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-03-27 14:17:09','2024-03-27 14:17:09',NULL,'1','Add New Invoice','1'),
('3691','VR-24-3691','2024-03-27 00:00:00','0','1250.00','1','159.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-27 14:21:35','2024-03-27 14:21:35',NULL,'1','Add New Invoice','1'),
('3692','INV-24-3692','2024-03-27 00:00:00','0','1250.00','1','26.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-27 02:24:24','2024-03-27 02:24:24',NULL,'1','Add New Invoice','1'),
('3693','VR-24-3693','2024-03-27 00:00:00','0','1250.00','1','261.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-03-27 15:48:37','2024-03-27 15:48:37',NULL,'1','Add New Invoice','1'),
('3694','VR-24-3694','2024-03-27 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-03-27 15:51:35','2024-03-27 15:51:35',NULL,'1','Add New Invoice','1'),
('3695','VR-24-3695','2024-03-28 00:00:00','0','1250.00','1','2215.86','0.00','320  280  بلاك','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-03-28 10:56:19','2025-08-07 05:16:11',NULL,'1','Update Invoice','1'),
('3696','VR-24-3696','2024-03-30 00:00:00','0','1250.00','1','147.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-03-30 10:43:14','2024-03-30 10:43:14',NULL,'1','Add New Invoice','1'),
('3697','VR-24-3697','2024-03-30 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-03-30 10:47:05','2024-03-30 10:47:05',NULL,'1','Add New Invoice','1'),
('3698','VR-24-3698','2024-03-30 00:00:00','0','1250.00','1','171.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','96','0','2024-03-30 10:52:13','2024-03-30 10:52:13',NULL,'1','Add New Invoice','1'),
('3699','VR-24-3699','2024-03-30 00:00:00','0','1250.00','1','97.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-03-30 10:52:55','2024-03-30 10:52:55',NULL,'1','Add New Invoice','1'),
('3700','VR-24-3700','2024-03-30 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-03-30 10:55:59','2024-03-30 10:55:59',NULL,'1','Add New Invoice','1'),
('3701','VR-24-3701','2024-03-30 00:00:00','0','1250.00','1','91.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-30 14:52:09','2024-04-08 12:27:16',NULL,'1','Update Invoice','1'),
('3702','VR-24-3702','2024-03-30 00:00:00','0','1250.00','1','126.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-03-30 15:03:52','2024-03-30 15:03:52',NULL,'1','Add New Invoice','1'),
('3703','VR-24-3703','2024-03-31 00:00:00','0','1250.00','1','417.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-03-31 14:10:21','2024-03-31 03:50:27',NULL,'1','Update Invoice','1'),
('3704','VR-24-3704','2024-03-31 00:00:00','0','1250.00','1','798.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-03-31 14:24:21','2024-04-08 12:26:38',NULL,'1','Update Invoice','1'),
('3705','VR-24-3705','2024-03-31 00:00:00','0','1250.00','1','24.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-03-31 14:51:57','2024-03-31 14:51:57',NULL,'1','Add New Invoice','1'),
('3706','VR-24-3706','2024-03-31 00:00:00','0','1250.00','1','148.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-03-31 14:58:24','2024-03-31 14:58:24',NULL,'1','Add New Invoice','1'),
('3707','VR-24-3707','2024-03-31 00:00:00','0','1250.00','1','45.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-03-31 15:03:28','2024-03-31 15:03:28',NULL,'1','Add New Invoice','1'),
('3708','VR-24-3708','2024-03-31 00:00:00','0','1250.00','1','126.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-03-31 15:32:14','2024-03-31 15:32:14',NULL,'1','Add New Invoice','1'),
('3709','VR-24-3709','2024-03-31 00:00:00','0','1250.00','1','38.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-03-31 15:47:22','2024-03-31 15:47:22',NULL,'1','Add New Invoice','1'),
('3710','VR-24-3710','2024-03-31 00:00:00','0','1250.00','1','358.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','124','0','2024-03-31 15:54:16','2024-03-31 15:54:16',NULL,'1','Add New Invoice','1'),
('3711','INV-24-3711','2024-04-01 00:00:00','0','1250.00','1','173.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-01 12:07:17','2024-04-01 12:07:17',NULL,'1','Add New Invoice','1'),
('3712','VR-24-3712','2024-04-01 00:00:00','0','1250.00','1','132.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-01 14:00:52','2024-04-01 14:00:52',NULL,'1','Add New Invoice','1'),
('3713','VR-24-3713','2024-04-01 00:00:00','0','1250.00','1','1042.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-04-01 15:02:56','2024-04-01 15:02:56',NULL,'1','Add New Invoice','1'),
('3714','VR-24-3714','2024-04-01 00:00:00','0','1250.00','1','682.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-04-01 15:08:09','2024-04-01 15:08:09',NULL,'1','Add New Invoice','1'),
('3715','VR-24-3715','2024-04-01 00:00:00','0','1250.00','1','627.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-04-01 15:39:28','2024-04-01 04:35:36',NULL,'1','Update Invoice','1'),
('3716','VR-24-3716','2024-04-01 00:00:00','0','1250.00','1','466.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-01 15:54:46','2024-04-01 15:54:46',NULL,'1','Add New Invoice','1'),
('3720','VR-24-3717','2024-04-02 00:00:00','0','1250.00','1','15554.49','0.00','5','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-02 11:28:00','2024-04-02 11:28:00',NULL,'1','Add New Invoice','1'),
('3721','VR-24-3721','2024-04-02 00:00:00','0','1250.00','1','135.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-02 12:12:04','2024-04-02 12:12:04',NULL,'1','Add New Invoice','1'),
('3722','VR-24-3722','2024-04-02 00:00:00','0','1250.00','1','140.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-04-02 12:18:34','2024-04-02 12:18:34',NULL,'1','Add New Invoice','1'),
('3723','VR-24-3723','2024-04-03 00:00:00','0','1250.00','1','1357.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-03 14:54:18','2024-04-03 14:54:18',NULL,'1','Add New Invoice','1'),
('3724','VR-24-3724','2024-04-03 00:00:00','0','1250.00','1','2573.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-04-03 15:13:10','2024-04-03 15:13:10',NULL,'1','Add New Invoice','1'),
('3725','VR-24-3725','2024-04-03 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-04-03 15:17:43','2024-04-03 15:17:43',NULL,'1','Add New Invoice','1'),
('3726','VR-24-3726','2024-04-03 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-04-03 15:20:09','2024-04-03 15:20:09',NULL,'1','Add New Invoice','1'),
('3727','VR-24-3727','2024-04-03 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-04-03 15:22:58','2024-04-03 15:22:58',NULL,'1','Add New Invoice','1'),
('3728','VR-24-3728','2024-04-04 00:00:00','0','1250.00','1','94.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-04-04 11:15:05','2024-04-04 11:15:05',NULL,'1','Add New Invoice','1'),
('3729','VR-24-3729','2024-04-04 00:00:00','0','1250.00','1','482.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-04 11:21:46','2024-04-04 11:21:46',NULL,'1','Add New Invoice','1'),
('3730','VR-24-3730','2024-04-04 00:00:00','0','1250.00','1','509.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-04 11:34:57','2024-04-04 11:34:57',NULL,'1','Add New Invoice','1'),
('3731','VR-24-3731','2024-04-04 00:00:00','0','1250.00','1','1745.56','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-04-04 12:47:31','2024-04-04 12:47:31',NULL,'1','Add New Invoice','1'),
('3732','VR-24-3732','2024-04-04 00:00:00','0','1250.00','1','307.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-04 15:53:23','2024-04-04 15:53:23',NULL,'1','Add New Invoice','1'),
('3733','VR-24-3733','2024-04-04 00:00:00','0','1250.00','1','99.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-04-04 15:54:39','2024-04-04 15:54:39',NULL,'1','Add New Invoice','1'),
('3734','VR-24-3734','2024-04-04 00:00:00','0','1250.00','1','328.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-04 15:56:05','2024-04-04 15:56:05',NULL,'1','Add New Invoice','1'),
('3735','VR-24-3735','2024-04-04 00:00:00','0','1250.00','1','45.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-04-04 15:57:31','2024-04-07 01:22:22',NULL,'1','Update Invoice','1'),
('3736','VR-24-3736','2024-04-04 00:00:00','0','1250.00','1','154.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-04-04 15:58:09','2024-04-04 15:58:09',NULL,'1','Add New Invoice','1'),
('3737','VR-24-3737','2024-04-04 00:00:00','0','1250.00','1','145.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-04-04 15:58:46','2024-04-04 15:58:46',NULL,'1','Add New Invoice','1'),
('3738','VR-24-3738','2024-04-04 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-04-04 15:59:34','2024-04-04 15:59:34',NULL,'1','Add New Invoice','1'),
('3739','VR-24-3739','2024-04-04 00:00:00','0','1250.00','1','263.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-04-04 16:03:11','2024-04-04 16:03:11',NULL,'1','Add New Invoice','1'),
('3740','VR-24-3740','2024-04-04 00:00:00','0','1250.00','1','65.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-04-04 16:04:42','2024-04-04 04:05:16',NULL,'1','Update Invoice','1'),
('3741','VR-24-3741','2024-04-04 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-04-04 16:06:15','2024-04-04 16:06:15',NULL,'1','Add New Invoice','1'),
('3742','VR-24-3742','2024-04-04 00:00:00','0','1250.00','1','73.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-04-04 16:08:47','2024-04-04 16:08:47',NULL,'1','Add New Invoice','1'),
('3743','VR-24-3743','2024-04-04 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-04-04 16:10:56','2024-04-04 16:10:56',NULL,'1','Add New Invoice','1'),
('3744','VR-24-3744','2024-04-04 00:00:00','0','1250.00','1','27.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-04-04 16:12:38','2024-04-04 16:12:38',NULL,'1','Add New Invoice','1'),
('3745','VR-24-3745','2024-04-04 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-04 16:20:02','2024-04-04 16:20:02',NULL,'1','Add New Invoice','1'),
('3746','VR-24-3746','2024-04-06 00:00:00','0','1250.00','1','253.00','0.00','ط','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-04-06 11:51:01','2024-04-06 11:51:01',NULL,'1','Add New Invoice','1'),
('3747','INV-24-3747','2024-04-06 00:00:00','0','1250.00','1','137.01','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-06 03:19:40','2024-04-06 03:19:40',NULL,'1','Add New Invoice','1'),
('3748','INV-24-3748','2024-04-06 00:00:00','0','1250.00','1','143.29','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-04-06 03:22:13','2024-04-06 03:22:13',NULL,'1','Add New Invoice','1'),
('3749','INV-24-3749','2024-04-06 00:00:00','0','1250.00','1','77.33','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-06 03:24:50','2024-04-06 03:24:50',NULL,'1','Add New Invoice','1'),
('3750','INV-24-3750','2024-04-06 00:00:00','0','1250.00','1','280.80','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-06 03:33:36','2024-04-06 03:33:36',NULL,'1','Add New Invoice','1'),
('3751','VR-24-3751','2024-04-06 00:00:00','0','1250.00','1','138.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-04-06 15:43:18','2024-04-06 15:43:18',NULL,'1','Add New Invoice','1'),
('3752','VR-24-3752','2024-04-06 00:00:00','0','1250.00','1','594.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-04-06 15:57:28','2024-04-06 15:57:28',NULL,'1','Add New Invoice','1'),
('3753','VR-24-3753','2024-04-06 00:00:00','0','1250.00','1','354.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-06 16:06:57','2024-04-06 16:06:57',NULL,'1','Add New Invoice','1'),
('3754','VR-24-3754','2024-04-06 00:00:00','0','1250.00','1','417.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-06 16:10:10','2024-04-06 16:10:10',NULL,'1','Add New Invoice','1'),
('3755','VR-24-3755','2024-04-06 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-04-06 16:11:41','2024-04-06 16:11:41',NULL,'1','Add New Invoice','1'),
('3756','VR-24-3756','2024-04-06 00:00:00','0','1250.00','1','148.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-06 16:13:09','2024-04-06 16:13:09',NULL,'1','Add New Invoice','1'),
('3757','VR-24-3757','2024-04-06 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-04-06 16:14:37','2024-04-07 01:22:32',NULL,'1','Update Invoice','1'),
('3758','VR-24-3758','2024-04-06 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-04-06 20:10:15','2024-04-06 20:10:15',NULL,'1','Add New Invoice','1'),
('3759','VR-24-3759','2024-04-07 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-04-07 14:54:53','2024-04-07 14:54:53',NULL,'1','Add New Invoice','1'),
('3760','VR-24-3760','2024-04-07 00:00:00','0','1250.00','1','48.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-04-07 16:03:53','2024-04-07 16:03:53',NULL,'1','Add New Invoice','1'),
('3761','VR-24-3761','2024-04-07 00:00:00','0','1250.00','1','282.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-07 16:05:01','2024-04-07 16:05:01',NULL,'1','Add New Invoice','1'),
('3762','VR-24-3762','2024-04-07 00:00:00','0','1250.00','1','115.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-07 16:06:42','2024-04-07 16:06:42',NULL,'1','Add New Invoice','1'),
('3763','VR-24-3763','2024-04-07 00:00:00','0','1250.00','1','235.87','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','124','0','2024-04-07 16:08:50','2024-04-07 16:08:50',NULL,'1','Add New Invoice','1'),
('3764','VR-24-3764','2024-04-07 00:00:00','0','1250.00','1','55.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-04-07 16:26:27','2024-04-07 16:26:27',NULL,'1','Add New Invoice','1'),
('3765','VR-24-3765','2024-04-07 00:00:00','0','1250.00','1','367.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-07 16:31:19','2024-04-07 16:31:19',NULL,'1','Add New Invoice','1'),
('3766','VR-24-3766','2024-04-07 00:00:00','0','1250.00','1','45.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-04-07 16:33:38','2024-04-07 16:33:38',NULL,'1','Add New Invoice','1'),
('3767','VR-24-3767','2024-04-07 00:00:00','0','1250.00','1','22.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-07 16:40:09','2024-04-07 16:40:09',NULL,'1','Add New Invoice','1'),
('3768','VR-24-3768','2024-04-08 00:00:00','0','1250.00','1','59.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-04-08 12:24:05','2024-04-08 12:24:05',NULL,'1','Add New Invoice','1'),
('3769','VR-24-3769','2024-04-08 00:00:00','0','1250.00','1','10.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-04-08 12:24:39','2024-04-08 12:24:39',NULL,'1','Add New Invoice','1'),
('3770','VR-24-3770','2024-04-08 00:00:00','0','1250.00','1','648.67','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-04-08 12:42:32','2024-04-08 12:42:32',NULL,'1','Add New Invoice','1'),
('3771','VR-24-3771','2024-04-08 00:00:00','0','1250.00','1','159.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-08 12:48:30','2024-04-08 12:48:30',NULL,'1','Add New Invoice','1'),
('3772','VR-24-3772','2024-04-14 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-04-14 13:30:43','2024-04-14 13:30:43',NULL,'1','Add New Invoice','1'),
('3773','VR-24-3773','2024-04-14 00:00:00','0','1250.00','1','143.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-14 15:20:56','2024-04-14 15:20:56',NULL,'1','Add New Invoice','1'),
('3774','VR-24-3774','2024-04-14 00:00:00','0','1250.00','1','31.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-14 15:39:14','2024-04-14 15:39:14',NULL,'1','Add New Invoice','1'),
('3775','VR-24-3775','2024-04-14 00:00:00','0','1250.00','1','1010.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-04-14 16:33:57','2024-04-14 16:33:57',NULL,'1','Add New Invoice','1'),
('3776','VR-24-3776','2024-04-16 00:00:00','0','1250.00','1','1019.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-16 13:20:13','2024-04-17 02:58:24',NULL,'1','Update Invoice','1'),
('3777','VR-24-3777','2024-04-16 00:00:00','0','1250.00','1','237.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-16 16:17:55','2024-04-16 16:17:55',NULL,'1','Add New Invoice','1'),
('3778','VR-24-3778','2024-04-16 00:00:00','0','1250.00','1','152.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-16 16:39:46','2024-04-16 16:39:46',NULL,'1','Add New Invoice','1'),
('3779','VR-24-3779','2024-04-16 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-04-16 16:41:00','2024-04-16 16:41:00',NULL,'1','Add New Invoice','1'),
('3780','VR-24-3780','2024-04-16 00:00:00','0','1250.00','1','321.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-04-16 16:44:59','2024-04-22 03:08:48',NULL,'1','Update Invoice','1'),
('3781','VR-24-3781','2024-04-16 00:00:00','0','1250.00','1','210.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-04-16 16:47:43','2024-04-16 16:47:43',NULL,'1','Add New Invoice','1'),
('3782','VR-24-3782','2024-04-16 00:00:00','0','1250.00','1','256.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-16 16:50:00','2024-04-16 16:50:00',NULL,'1','Add New Invoice','1'),
('3783','VR-24-3783','2024-04-16 00:00:00','0','1250.00','1','260.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-04-16 16:51:36','2024-04-16 16:51:36',NULL,'1','Add New Invoice','1'),
('3784','VR-24-3784','2024-04-17 00:00:00','0','1250.00','1','182.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-17 12:54:26','2024-04-17 12:54:26',NULL,'1','Add New Invoice','1'),
('3785','VR-24-3785','2024-04-17 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-17 17:04:14','2024-04-17 17:04:14',NULL,'1','Add New Invoice','1'),
('3786','VR-24-3786','2024-04-17 00:00:00','0','1250.00','1','363.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-17 17:11:54','2024-04-17 17:11:54',NULL,'1','Add New Invoice','1'),
('3787','VR-24-3787','2024-04-18 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-04-18 12:10:07','2024-04-18 12:10:07',NULL,'1','Add New Invoice','1'),
('3788','VR-24-3788','2024-04-18 00:00:00','0','1250.00','1','603.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-18 12:39:02','2024-08-05 04:39:56',NULL,'1','Update Invoice','1'),
('3789','VR-24-3789','2024-04-18 00:00:00','0','1250.00','1','4200.01','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-18 15:13:39','2024-04-18 15:13:39',NULL,'1','Add New Invoice','1'),
('3790','VR-24-3790','2024-04-18 00:00:00','0','1250.00','1','12.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-18 15:39:17','2024-04-18 15:39:17',NULL,'1','Add New Invoice','1'),
('3791','VR-24-3791','2024-04-18 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-04-18 15:45:03','2024-04-18 15:45:03',NULL,'1','Add New Invoice','1'),
('3792','INV-24-3792','2024-04-18 00:00:00','0','1250.00','1','108.16','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-18 04:28:05','2024-04-18 04:28:05',NULL,'1','Add New Invoice','1'),
('3793','VR-24-3793','2024-04-20 00:00:00','0','1250.00','1','85.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-20 09:06:02','2024-04-20 09:06:02',NULL,'1','Add New Invoice','1'),
('3794','VR-24-3794','2024-04-20 00:00:00','0','1250.00','1','86.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-04-20 09:24:54','2024-04-20 09:24:54',NULL,'1','Add New Invoice','1'),
('3795','VR-24-3795','2024-04-20 00:00:00','0','1250.00','1','50.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-04-20 09:26:07','2024-04-20 09:26:07',NULL,'1','Add New Invoice','1'),
('3796','VR-24-3796','2024-04-20 00:00:00','0','1250.00','1','57.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-04-20 09:30:00','2024-04-20 09:30:00',NULL,'1','Add New Invoice','1'),
('3797','VR-24-3797','2024-04-20 00:00:00','0','1250.00','1','17.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-04-20 09:35:03','2024-04-20 09:35:03',NULL,'1','Add New Invoice','1'),
('3798','VR-24-3798','2024-04-20 00:00:00','0','1250.00','1','1865.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-20 10:43:46','2024-04-20 10:43:46',NULL,'1','Add New Invoice','1'),
('3799','VR-24-3799','2024-04-21 00:00:00','0','1250.00','1','1281.76','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-21 09:39:22','2024-04-21 09:39:22',NULL,'1','Add New Invoice','1'),
('3800','VR-24-3800','2024-04-21 00:00:00','0','1250.00','1','52.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-04-21 17:08:14','2024-04-21 17:08:14',NULL,'1','Add New Invoice','1'),
('3801','VR-24-3801','2024-04-21 00:00:00','0','1250.00','1','1200.00','0.00','320','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-04-21 17:09:16','2025-08-07 05:16:45',NULL,'1','Update Invoice','1'),
('3802','VR-24-3802','2024-04-21 00:00:00','0','1250.00','1','383.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-04-21 17:10:52','2024-04-22 12:26:15',NULL,'1','Update Invoice','1'),
('3803','VR-24-3803','2024-04-21 00:00:00','0','1250.00','1','296.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-04-21 17:12:39','2024-04-21 17:12:39',NULL,'1','Add New Invoice','1'),
('3804','VR-24-3804','2024-04-21 00:00:00','0','1250.00','1','312.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-21 17:13:51','2024-04-21 17:13:51',NULL,'1','Add New Invoice','1'),
('3805','VR-24-3805','2024-04-21 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-04-21 17:14:55','2024-04-21 17:14:55',NULL,'1','Add New Invoice','1'),
('3806','VR-24-3806','2024-04-21 00:00:00','0','1250.00','1','126.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-04-21 17:19:29','2024-04-21 17:19:29',NULL,'1','Add New Invoice','1'),
('3807','VR-24-3807','2024-04-22 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-22 11:39:39','2024-04-22 11:39:39',NULL,'1','Add New Invoice','1'),
('3808','VR-24-3808','2024-04-22 00:00:00','0','1250.00','1','1266.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-22 12:35:47','2024-04-22 03:11:13',NULL,'1','Update Invoice','1'),
('3809','VR-24-3809','2024-04-22 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','108','0','2024-04-22 12:37:42','2024-04-22 12:37:42',NULL,'1','Add New Invoice','1'),
('3810','VR-24-3810','2024-04-22 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-04-22 15:03:09','2024-04-22 15:03:09',NULL,'1','Add New Invoice','1'),
('3811','VR-24-3811','2024-04-22 00:00:00','0','1250.00','1','56.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-22 15:04:28','2024-04-22 15:04:28',NULL,'1','Add New Invoice','1'),
('3812','VR-24-3812','2024-04-22 00:00:00','0','1250.00','1','20.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-04-22 15:05:14','2024-04-22 15:05:14',NULL,'1','Add New Invoice','1'),
('3813','VR-24-3813','2024-04-22 00:00:00','0','1250.00','1','100.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-04-22 15:08:07','2024-04-22 15:08:07',NULL,'1','Add New Invoice','1'),
('3814','VR-24-3814','2024-04-22 00:00:00','0','1250.00','1','31.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-04-22 15:10:08','2024-04-22 15:10:08',NULL,'1','Add New Invoice','1'),
('3815','VR-24-3815','2024-04-22 00:00:00','0','1250.00','1','1432.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-22 15:18:20','2024-04-22 15:18:20',NULL,'1','Add New Invoice','1'),
('3816','VR-24-3816','2024-04-22 00:00:00','0','1250.00','1','64.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-04-22 15:22:46','2024-04-22 15:22:46',NULL,'1','Add New Invoice','1'),
('3817','VR-24-3817','2024-04-22 00:00:00','0','1250.00','1','176.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-04-22 15:27:12','2024-04-23 10:01:10',NULL,'1','Update Invoice','1'),
('3818','VR-24-3818','2024-04-22 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-04-22 15:28:57','2024-04-22 15:28:57',NULL,'1','Add New Invoice','1'),
('3819','INV-24-3819','2024-04-23 00:00:00','0','1250.00','1','63.70','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-23 04:10:26','2024-04-23 04:10:26',NULL,'1','Add New Invoice','1'),
('3820','VR-24-3820','2024-04-23 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-24 09:45:59','2024-04-24 09:45:59',NULL,'1','Add New Invoice','1'),
('3821','INV-24-3821','2024-04-24 00:00:00','0','1250.00','1','632.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-24 03:53:33','2024-04-24 03:53:33',NULL,'1','Add New Invoice','1'),
('3822','INV-24-3822','2024-04-24 00:00:00','0','1250.00','1','42.28','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-24 03:55:06','2024-04-24 03:55:06',NULL,'1','Add New Invoice','1'),
('3823','INV-24-3823','2024-04-24 00:00:00','0','1250.00','1','26.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-24 03:57:21','2024-04-24 03:57:21',NULL,'1','Add New Invoice','1'),
('3824','VR-24-3824','2024-04-25 00:00:00','0','1250.00','1','8974.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-04-25 11:15:13','2024-04-25 11:15:13',NULL,'1','Add New Invoice','1'),
('3825','VR-24-3825','2024-04-25 00:00:00','0','1250.00','1','1064.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-04-25 15:31:19','2024-04-25 15:31:19',NULL,'1','Add New Invoice','1'),
('3826','VR-24-3826','2024-04-25 00:00:00','0','1250.00','1','293.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-25 15:37:32','2024-04-25 04:08:05',NULL,'1','Update Invoice','1'),
('3827','VR-24-3827','2024-04-25 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-25 15:39:02','2024-04-25 15:39:02',NULL,'1','Add New Invoice','1'),
('3828','VR-24-3828','2024-04-25 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-04-25 15:55:50','2024-04-25 15:55:50',NULL,'1','Add New Invoice','1'),
('3829','VR-24-3829','2024-04-25 00:00:00','0','1250.00','1','51.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-25 15:58:05','2024-04-25 15:58:05',NULL,'1','Add New Invoice','1'),
('3830','VR-24-3830','2024-04-25 00:00:00','0','1250.00','1','264.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-04-25 16:09:56','2024-04-27 12:02:38',NULL,'1','Update Invoice','1'),
('3831','VR-24-3831','2024-04-27 00:00:00','0','1250.00','1','4973.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-27 14:04:22','2024-04-29 08:46:11',NULL,'1','Update Invoice','1'),
('3832','VR-24-3832','2024-04-27 00:00:00','0','1250.00','1','511.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-04-27 15:16:44','2024-04-27 15:16:44',NULL,'1','Add New Invoice','1'),
('3833','VR-24-3833','2024-04-27 00:00:00','0','1250.00','1','175.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','101','0','2024-04-27 15:38:30','2024-04-27 15:38:30',NULL,'1','Add New Invoice','1'),
('3834','VR-24-3834','2024-04-27 00:00:00','0','1250.00','1','55.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-04-27 16:48:18','2024-04-27 16:48:18',NULL,'1','Add New Invoice','1'),
('3835','VR-24-3835','2024-04-28 00:00:00','0','1250.00','1','153.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-04-28 09:40:25','2024-04-28 09:41:51',NULL,'1','Update Invoice','1'),
('3836','VR-24-3836','2024-04-28 00:00:00','0','1250.00','1','34.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-04-28 09:42:52','2024-04-28 09:42:52',NULL,'1','Add New Invoice','1'),
('3837','VR-24-3837','2024-04-28 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-04-28 09:43:46','2024-04-28 09:43:46',NULL,'1','Add New Invoice','1'),
('3838','INV-24-3838','2024-04-29 00:00:00','0','1250.00','1','91.80','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-29 09:39:02','2024-04-29 09:39:02',NULL,'1','Add New Invoice','1'),
('3839','VR-24-3839','2024-04-29 00:00:00','0','1250.00','1','600.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-04-29 11:20:53','2024-04-29 11:20:53',NULL,'1','Add New Invoice','1'),
('3840','VR-24-3840','2024-04-29 00:00:00','0','1250.00','1','553.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-04-29 12:12:34','2024-04-29 12:12:34',NULL,'1','Add New Invoice','1'),
('3841','VR-24-3841','2024-04-29 00:00:00','0','1250.00','1','270.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-29 12:26:14','2024-04-29 12:26:14',NULL,'1','Add New Invoice','1'),
('3842','VR-24-3842','2024-04-29 00:00:00','0','1250.00','1','523.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-04-29 15:46:46','2024-04-29 15:46:46',NULL,'1','Add New Invoice','1'),
('3843','VR-24-3843','2024-04-29 00:00:00','0','1250.00','1','318.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-04-29 15:50:06','2024-04-29 15:50:06',NULL,'1','Add New Invoice','1'),
('3844','VR-24-3844','2024-04-29 00:00:00','0','1250.00','1','332.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-29 15:55:11','2024-04-29 15:55:11',NULL,'1','Add New Invoice','1'),
('3845','VR-24-3845','2024-04-29 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-04-29 15:56:22','2024-04-29 15:56:22',NULL,'1','Add New Invoice','1'),
('3846','VR-24-3846','2024-04-29 00:00:00','0','1250.00','1','77.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-04-29 15:58:09','2024-04-29 15:58:09',NULL,'1','Add New Invoice','1'),
('3847','VR-24-3847','2024-04-29 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-04-29 15:59:06','2024-04-29 15:59:06',NULL,'1','Add New Invoice','1'),
('3848','INV-24-3848','2024-04-29 00:00:00','0','1250.00','1','15.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-04-29 04:12:53','2024-04-29 04:12:53',NULL,'1','Add New Invoice','1'),
('3849','VR-24-3849','2024-04-29 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-04-29 16:55:30','2024-04-29 16:55:30',NULL,'1','Add New Invoice','1'),
('3850','VR-24-3850','2024-04-29 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-04-29 16:56:33','2024-04-29 16:56:33',NULL,'1','Add New Invoice','1'),
('3851','VR-24-3851','2024-04-29 00:00:00','0','1250.00','1','49.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-04-29 16:57:28','2024-04-29 16:57:28',NULL,'1','Add New Invoice','1'),
('3852','VR-24-3852','2024-04-30 00:00:00','0','1250.00','1','121.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-04-30 12:25:40','2024-04-30 12:25:40',NULL,'1','Add New Invoice','1'),
('3853','VR-24-3853','2024-04-30 00:00:00','0','1250.00','1','1835.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-04-30 12:40:36','2024-04-30 12:40:36',NULL,'1','Add New Invoice','1'),
('3854','VR-24-3854','2024-05-01 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-01 09:26:26','2024-05-01 09:26:26',NULL,'1','Add New Invoice','1'),
('3855','VR-24-3855','2024-05-01 00:00:00','0','1250.00','1','75.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-05-01 09:27:21','2024-05-01 09:27:21',NULL,'1','Add New Invoice','1'),
('3856','VR-24-3856','2024-05-01 00:00:00','0','1250.00','1','265.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-05-01 09:29:14','2024-05-01 09:29:14',NULL,'1','Add New Invoice','1'),
('3857','VR-24-3857','2024-05-01 00:00:00','0','1250.00','1','1872.71','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-05-01 14:49:42','2024-05-01 03:17:00',NULL,'1','Update Invoice','1'),
('3858','VR-24-3858','2024-05-01 00:00:00','0','1250.00','1','19.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-01 15:00:07','2024-05-01 15:00:07',NULL,'1','Add New Invoice','1'),
('3859','VR-24-3859','2024-05-01 00:00:00','0','1250.00','1','62.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-01 15:05:05','2024-05-01 15:05:05',NULL,'1','Add New Invoice','1'),
('3860','VR-24-3860','2024-05-01 00:00:00','0','1250.00','1','273.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-01 15:07:37','2024-05-01 15:07:37',NULL,'1','Add New Invoice','1'),
('3861','VR-24-3861','2024-05-01 00:00:00','0','1250.00','1','425.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-05-01 15:12:03','2024-05-01 15:12:03',NULL,'1','Add New Invoice','1'),
('3862','INV-24-3862','2024-05-02 00:00:00','0','1250.00','1','197.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-05-02 12:43:07','2024-05-02 12:43:07',NULL,'1','Add New Invoice','1'),
('3863','VR-24-3863','2024-05-02 00:00:00','0','1250.00','1','237.51','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-02 14:20:37','2024-05-02 14:20:37',NULL,'1','Add New Invoice','1'),
('3864','VR-24-3864','2024-05-02 00:00:00','0','1250.00','1','176.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-02 15:15:26','2024-05-02 15:15:26',NULL,'1','Add New Invoice','1'),
('3865','VR-24-3865','2024-05-02 00:00:00','0','1250.00','1','271.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-02 15:45:16','2024-05-02 15:45:16',NULL,'1','Add New Invoice','1'),
('3866','VR-24-3866','2024-05-02 00:00:00','0','1250.00','1','494.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-02 15:53:30','2024-05-02 15:53:30',NULL,'1','Add New Invoice','1'),
('3867','VR-24-3867','2024-05-02 00:00:00','0','1250.00','1','62.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-02 16:15:29','2024-05-02 16:15:29',NULL,'1','Add New Invoice','1'),
('3868','VR-24-3868','2024-05-02 00:00:00','0','1250.00','1','513.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-02 16:19:59','2024-05-02 16:19:59',NULL,'1','Add New Invoice','1'),
('3869','VR-24-3869','2024-05-02 00:00:00','0','1250.00','1','168.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-02 16:24:48','2024-05-02 16:24:48',NULL,'1','Add New Invoice','1'),
('3870','VR-24-3870','2024-05-02 00:00:00','0','1250.00','1','127.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-02 16:29:00','2024-05-02 16:29:00',NULL,'1','Add New Invoice','1'),
('3871','VR-24-3871','2024-05-02 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-02 16:33:17','2024-05-02 16:33:17',NULL,'1','Add New Invoice','1'),
('3872','INV-24-3872','2024-05-04 00:00:00','0','1250.00','1','456.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-04 09:18:56','2024-05-04 09:18:56',NULL,'1','Add New Invoice','1'),
('3873','VR-24-3873','2024-05-04 00:00:00','0','1250.00','1','127.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-04 14:03:37','2024-05-04 14:03:37',NULL,'1','Add New Invoice','1'),
('3874','INV-24-3874','2024-05-04 00:00:00','0','1250.00','1','346.15','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-05-04 04:43:37','2024-05-04 04:43:37',NULL,'1','Add New Invoice','1'),
('3875','INV-24-3875','2024-05-04 00:00:00','0','1250.00','1','135.90','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-05-04 04:49:39','2024-05-04 04:49:39',NULL,'1','Add New Invoice','1'),
('3876','VR-24-3876','2024-05-05 00:00:00','0','1250.00','1','493.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-05 10:12:02','2024-05-05 10:12:02',NULL,'1','Add New Invoice','1'),
('3877','VR-24-3877','2024-05-05 00:00:00','0','1250.00','1','347.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-05-05 10:17:53','2024-05-05 10:17:53',NULL,'1','Add New Invoice','1'),
('3878','VR-24-3878','2024-05-05 00:00:00','0','1250.00','1','762.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-05 10:37:40','2024-05-05 10:37:40',NULL,'1','Add New Invoice','1'),
('3879','VR-24-3879','2024-05-05 00:00:00','0','1250.00','1','1976.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-05-05 12:21:30','2024-05-05 12:21:30',NULL,'1','Add New Invoice','1'),
('3880','VR-24-3880','2024-05-05 00:00:00','0','1250.00','1','614.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-05-05 16:26:06','2024-05-05 16:26:06',NULL,'1','Add New Invoice','1'),
('3881','VR-24-3881','2024-05-05 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-05-05 16:28:10','2024-05-05 04:28:50',NULL,'1','Update Invoice','1'),
('3882','VR-24-3882','2024-05-06 00:00:00','0','1250.00','1','325.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-05-06 09:38:59','2024-05-06 09:38:59',NULL,'1','Add New Invoice','1'),
('3883','VR-24-3883','2024-05-06 00:00:00','0','1250.00','1','59.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-06 13:57:17','2024-05-06 13:57:17',NULL,'1','Add New Invoice','1'),
('3884','VR-24-3884','2024-05-06 00:00:00','0','1250.00','1','260.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-05-06 16:38:05','2024-05-06 16:38:05',NULL,'1','Add New Invoice','1'),
('3885','VR-24-3885','2024-05-06 00:00:00','0','1250.00','1','169.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-05-06 16:40:56','2024-05-06 16:40:56',NULL,'1','Add New Invoice','1'),
('3886','VR-24-3886','2024-05-06 00:00:00','0','1250.00','1','71.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-06 16:45:16','2024-05-06 16:45:16',NULL,'1','Add New Invoice','1'),
('3887','VR-24-3887','2024-05-06 00:00:00','0','1250.00','1','256.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-06 16:47:32','2024-05-07 10:25:09',NULL,'1','Update Invoice','1'),
('3888','VR-24-3888','2024-05-06 00:00:00','0','1250.00','1','103.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-05-06 16:49:06','2024-05-06 16:49:06',NULL,'1','Add New Invoice','1'),
('3889','VR-24-3889','2024-05-07 00:00:00','0','1250.00','1','655.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','125','0','2024-05-07 11:37:09','2024-05-07 11:37:09',NULL,'1','Add New Invoice','1'),
('3890','VR-24-3890','2024-05-07 00:00:00','0','1250.00','1','194.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-07 13:59:58','2024-05-07 13:59:58',NULL,'1','Add New Invoice','1'),
('3891','VR-24-3891','2024-05-07 00:00:00','0','1250.00','1','180.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-07 14:01:43','2024-05-07 14:01:43',NULL,'1','Add New Invoice','1'),
('3892','VR-24-3892','2024-05-07 00:00:00','0','1250.00','1','419.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-07 14:03:26','2024-05-07 14:03:26',NULL,'1','Add New Invoice','1'),
('3893','VR-24-3893','2024-05-07 00:00:00','0','1250.00','1','137.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-05-07 14:07:33','2024-05-07 14:07:33',NULL,'1','Add New Invoice','1'),
('3894','VR-24-3894','2024-05-07 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-05-07 14:12:25','2024-05-07 14:12:25',NULL,'1','Add New Invoice','1'),
('3895','VR-24-3895','2024-05-07 00:00:00','0','1250.00','1','149.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-07 15:53:23','2024-05-07 15:53:23',NULL,'1','Add New Invoice','1'),
('3896','VR-24-3896','2024-05-07 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-07 15:58:29','2024-05-07 15:58:29',NULL,'1','Add New Invoice','1'),
('3897','VR-24-3897','2024-05-07 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-05-07 15:59:17','2024-05-07 15:59:17',NULL,'1','Add New Invoice','1'),
('3898','VR-24-3898','2024-05-07 00:00:00','0','1250.00','1','575.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-05-07 16:17:37','2024-05-07 16:17:37',NULL,'1','Add New Invoice','1'),
('3899','VR-24-3899','2024-05-07 00:00:00','0','1250.00','1','40.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-05-07 16:21:40','2024-05-07 16:21:40',NULL,'1','Add New Invoice','1'),
('3900','VR-24-3900','2024-05-07 00:00:00','0','1250.00','1','436.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-07 16:26:03','2024-05-08 09:31:20',NULL,'1','Update Invoice','1'),
('3901','VR-24-3901','2024-05-07 00:00:00','0','1250.00','1','14.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-07 16:32:25','2024-05-07 16:32:25',NULL,'1','Add New Invoice','1'),
('3902','VR-24-3902','2024-05-07 00:00:00','0','1250.00','1','160.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-05-07 16:36:55','2024-05-07 16:36:55',NULL,'1','Add New Invoice','1'),
('3903','VR-24-3903','2024-05-08 00:00:00','0','1250.00','1','416.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-08 11:55:44','2024-05-08 11:55:44',NULL,'1','Add New Invoice','1'),
('3904','VR-24-3904','2024-05-08 00:00:00','0','1250.00','1','267.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-05-08 11:59:24','2024-05-08 11:59:24',NULL,'1','Add New Invoice','1'),
('3905','VR-24-3905','2024-05-08 00:00:00','0','1250.00','1','24.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-08 12:13:22','2024-05-08 12:13:22',NULL,'1','Add New Invoice','1'),
('3906','VR-24-3906','2024-05-08 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-05-08 12:16:10','2024-05-08 12:16:10',NULL,'1','Add New Invoice','1'),
('3907','VR-24-3907','2024-05-08 00:00:00','0','1250.00','1','102.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-08 12:17:16','2024-05-08 12:17:16',NULL,'1','Add New Invoice','1'),
('3908','INV-24-3908','2024-05-08 00:00:00','0','1250.00','1','1152.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-05-08 12:52:51','2024-05-08 12:52:51',NULL,'1','Add New Invoice','1'),
('3909','VR-24-3909','2024-05-08 00:00:00','0','1250.00','1','502.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-05-08 16:44:30','2024-05-08 16:44:30',NULL,'1','Add New Invoice','1'),
('3910','VR-24-3910','2024-05-08 00:00:00','0','1250.00','1','339.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-08 16:45:22','2024-05-08 05:07:14',NULL,'1','Update Invoice','1'),
('3911','VR-24-3911','2024-05-08 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-08 16:58:24','2024-05-11 03:45:35',NULL,'1','Update Invoice','1'),
('3912','VR-24-3912','2024-05-08 00:00:00','0','1250.00','1','202.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-05-08 16:59:15','2024-05-08 16:59:15',NULL,'1','Add New Invoice','1'),
('3913','VR-24-3913','2024-05-08 00:00:00','0','1250.00','1','191.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-08 17:02:13','2024-05-08 17:02:13',NULL,'1','Add New Invoice','1'),
('3914','VR-24-3914','2024-05-08 00:00:00','0','1250.00','1','336.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-05-08 17:08:59','2024-05-09 11:25:05',NULL,'1','Update Invoice','1'),
('3915','VR-24-3915','2024-05-09 00:00:00','0','1250.00','1','85.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-09 14:12:28','2024-05-09 14:12:28',NULL,'1','Add New Invoice','1'),
('3916','VR-24-3916','2024-05-09 00:00:00','0','1250.00','1','40.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','109','0','2024-05-09 14:13:42','2024-05-09 14:13:42',NULL,'1','Add New Invoice','1'),
('3917','VR-24-3917','2024-05-09 00:00:00','0','1250.00','1','16.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-05-09 14:15:35','2024-05-12 10:06:40',NULL,'1','Update Invoice','1'),
('3918','VR-24-3918','2024-05-09 00:00:00','0','1250.00','1','92.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-09 14:16:30','2024-05-11 02:22:38',NULL,'1','Update Invoice','1'),
('3919','VR-24-3919','2024-05-09 00:00:00','0','1250.00','1','207.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-09 14:17:45','2024-05-09 14:17:45',NULL,'1','Add New Invoice','1'),
('3920','VR-24-3920','2024-05-09 00:00:00','0','1250.00','1','184.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-09 14:18:35','2024-05-09 04:00:32',NULL,'1','Update Invoice','1'),
('3921','VR-24-3921','2024-05-09 00:00:00','0','1250.00','1','194.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-09 14:21:31','2024-05-09 14:21:31',NULL,'1','Add New Invoice','1'),
('3922','VR-24-3922','2024-05-09 00:00:00','0','1250.00','1','32.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-09 14:22:56','2024-05-09 14:22:56',NULL,'1','Add New Invoice','1'),
('3923','VR-24-3923','2024-05-09 00:00:00','0','1250.00','1','213.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-09 14:30:03','2024-05-09 14:30:03',NULL,'1','Add New Invoice','1'),
('3924','VR-24-3924','2024-05-09 00:00:00','0','1250.00','1','54.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-05-09 14:31:14','2024-05-09 14:31:14',NULL,'1','Add New Invoice','1'),
('3925','VR-24-3925','2024-05-11 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-05-11 15:06:10','2024-05-11 15:06:10',NULL,'1','Add New Invoice','1'),
('3926','VR-24-3926','2024-05-11 00:00:00','0','1250.00','1','486.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-11 15:08:33','2024-08-05 04:40:16',NULL,'1','Update Invoice','1'),
('3927','VR-24-3927','2024-05-11 00:00:00','0','1250.00','1','64.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-05-11 15:26:33','2024-05-11 15:26:33',NULL,'1','Add New Invoice','1'),
('3928','VR-24-3928','2024-05-11 00:00:00','0','1250.00','1','145.50','0.00','تتو','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-11 15:29:06','2024-05-11 03:45:24',NULL,'1','Update Invoice','1'),
('3929','INV-24-3929','2024-05-12 00:00:00','0','1250.00','1','235.80','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-12 10:23:39','2024-05-12 10:23:39',NULL,'1','Add New Invoice','1'),
('3930','VR-24-3930','2024-05-12 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-12 12:43:06','2024-05-12 12:43:06',NULL,'1','Add New Invoice','1'),
('3931','VR-24-3931','2024-05-12 00:00:00','0','1250.00','1','270.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-12 15:24:27','2024-05-12 15:24:27',NULL,'1','Add New Invoice','1'),
('3932','VR-24-3932','2024-05-12 00:00:00','0','1250.00','1','347.40','0.00','0066','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-12 15:26:18','2024-05-12 15:26:18',NULL,'1','Add New Invoice','1'),
('3933','VR-24-3933','2024-05-12 00:00:00','0','1250.00','1','2108.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-12 16:57:21','2024-05-12 16:57:21',NULL,'1','Add New Invoice','1'),
('3934','VR-24-3934','2024-05-13 00:00:00','0','1250.00','1','518.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2024-05-13 10:57:54','2024-05-13 10:57:54',NULL,'1','Add New Invoice','1'),
('3935','VR-24-3935','2024-05-13 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-13 10:59:53','2024-05-13 10:59:53',NULL,'1','Add New Invoice','1'),
('3936','VR-24-3936','2024-05-13 00:00:00','0','1250.00','1','1680.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-05-13 11:04:03','2025-08-07 05:17:54',NULL,'1','Update Invoice','1'),
('3937','VR-24-3937','2024-05-13 00:00:00','0','1250.00','1','63.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-13 15:25:25','2024-05-13 15:25:25',NULL,'1','Add New Invoice','1'),
('3938','VR-24-3938','2024-05-13 00:00:00','0','1250.00','1','1094.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-05-13 15:27:22','2024-05-13 15:27:22',NULL,'1','Add New Invoice','1'),
('3939','VR-24-3939','2024-05-13 00:00:00','0','1250.00','1','140.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-05-13 16:00:22','2024-05-13 16:00:22',NULL,'1','Add New Invoice','1'),
('3940','VR-24-3940','2024-05-13 00:00:00','0','1250.00','1','1.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-13 16:03:54','2024-05-13 16:03:54',NULL,'1','Add New Invoice','1'); 
INSERT INTO `invoice` VALUES ('3941','VR-24-3941','2024-05-13 00:00:00','0','1250.00','1','624.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-13 16:04:56','2024-05-13 04:45:13',NULL,'1','Update Invoice','1'),
('3942','VR-24-3942','2024-05-13 00:00:00','0','1250.00','1','670.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-13 16:10:56','2024-05-13 16:10:56',NULL,'1','Add New Invoice','1'),
('3943','VR-24-3943','2024-05-13 00:00:00','0','1250.00','1','46.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-05-13 16:25:37','2024-05-13 16:25:37',NULL,'1','Add New Invoice','1'),
('3944','VR-24-3944','2024-05-13 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-05-13 16:27:50','2024-05-13 16:27:50',NULL,'1','Add New Invoice','1'),
('3945','VR-24-3945','2024-05-13 00:00:00','0','1250.00','1','149.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-13 16:30:03','2024-05-13 16:30:03',NULL,'1','Add New Invoice','1'),
('3946','VR-24-3946','2024-05-13 00:00:00','0','1250.00','1','84.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-05-13 16:32:05','2024-05-13 16:32:05',NULL,'1','Add New Invoice','1'),
('3947','INV-24-3947','2024-05-13 00:00:00','0','1250.00','1','157.15','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-13 04:56:34','2024-05-13 04:56:34',NULL,'1','Add New Invoice','1'),
('3948','VR-24-3948','2024-05-14 00:00:00','0','1250.00','1','112.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-14 09:41:43','2024-05-14 09:41:43',NULL,'1','Add New Invoice','1'),
('3949','VR-24-3949','2024-05-14 00:00:00','0','1250.00','1','280.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-05-14 15:43:18','2024-05-14 15:43:18',NULL,'1','Add New Invoice','1'),
('3950','VR-24-3950','2024-05-14 00:00:00','0','1250.00','1','187.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-14 15:46:24','2024-05-14 15:46:24',NULL,'1','Add New Invoice','1'),
('3951','VR-24-3951','2024-05-14 00:00:00','0','1250.00','1','95.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-14 16:01:27','2024-05-14 16:01:27',NULL,'1','Add New Invoice','1'),
('3952','VR-24-3952','2024-05-14 00:00:00','0','1250.00','1','169.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-05-14 16:02:30','2024-05-14 16:02:30',NULL,'1','Add New Invoice','1'),
('3953','VR-24-3953','2024-05-14 00:00:00','0','1250.00','1','112.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-14 16:08:50','2024-05-14 16:08:50',NULL,'1','Add New Invoice','1'),
('3954','VR-24-3954','2024-05-14 00:00:00','0','1250.00','1','129.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-14 16:10:34','2024-05-14 16:10:34',NULL,'1','Add New Invoice','1'),
('3955','VR-24-3955','2024-05-14 00:00:00','0','1250.00','1','105.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','109','0','2024-05-14 16:17:27','2024-05-14 16:17:27',NULL,'1','Add New Invoice','1'),
('3956','VR-24-3956','2024-05-14 00:00:00','0','1250.00','1','300.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-05-14 16:18:46','2024-05-14 16:18:46',NULL,'1','Add New Invoice','1'),
('3957','VR-24-3957','2024-05-14 00:00:00','0','1250.00','1','760.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-14 16:28:26','2024-05-14 16:28:26',NULL,'1','Add New Invoice','1'),
('3958','VR-24-3958','2024-05-14 00:00:00','0','1250.00','1','232.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-14 16:34:29','2024-05-14 04:36:03',NULL,'1','Update Invoice','1'),
('3959','VR-24-3959','2024-05-15 00:00:00','0','1250.00','1','290.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-15 13:37:11','2024-05-15 13:37:11',NULL,'1','Add New Invoice','1'),
('3960','VR-24-3960','2024-05-15 00:00:00','0','1250.00','1','332.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-15 16:11:18','2024-05-15 16:11:18',NULL,'1','Add New Invoice','1'),
('3961','VR-24-3961','2024-05-15 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-15 16:24:28','2024-05-15 16:24:28',NULL,'1','Add New Invoice','1'),
('3962','VR-24-3962','2024-05-16 00:00:00','0','1250.00','1','10060.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','123','0','2024-05-16 09:17:19','2024-05-16 09:17:19',NULL,'1','Add New Invoice','1'),
('3963','VR-24-3963','2024-05-16 00:00:00','0','1250.00','1','127.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-05-16 13:36:39','2024-05-16 13:36:39',NULL,'1','Add New Invoice','1'),
('3964','VR-24-3964','2024-05-16 00:00:00','0','1250.00','1','823.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-05-16 13:43:21','2024-06-06 09:01:02',NULL,'1','Update Invoice','1'),
('3965','VR-24-3965','2024-05-16 00:00:00','0','1250.00','1','983.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-16 13:50:19','2024-05-16 13:50:19',NULL,'1','Add New Invoice','1'),
('3966','VR-24-3966','2024-05-16 00:00:00','0','1250.00','1','120.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-16 13:55:22','2024-05-20 09:40:53',NULL,'1','Update Invoice','1'),
('3967','VR-24-3967','2024-05-16 00:00:00','0','1250.00','1','4540.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-05-16 14:03:23','2024-05-16 14:03:23',NULL,'1','Add New Invoice','1'),
('3968','VR-24-3968','2024-05-16 00:00:00','0','1250.00','1','148.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-16 14:29:53','2024-05-16 03:36:21',NULL,'1','Update Invoice','1'),
('3969','VR-24-3969','2024-05-18 00:00:00','0','1250.00','1','100.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-18 13:13:38','2024-05-18 13:13:38',NULL,'1','Add New Invoice','1'),
('3970','VR-24-3970','2024-05-20 00:00:00','0','1250.00','1','64.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-20 11:30:58','2024-05-20 11:30:58',NULL,'1','Add New Invoice','1'),
('3971','INV-24-3971','2024-05-20 00:00:00','0','1250.00','1','80.10','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-20 11:34:17','2024-05-20 11:34:17',NULL,'1','Add New Invoice','1'),
('3972','VR-24-3972','2024-05-20 00:00:00','0','1250.00','1','419.58','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-05-20 12:00:44','2024-06-04 10:39:37',NULL,'1','Update Invoice','1'),
('3973','VR-24-3973','2024-05-20 00:00:00','0','1250.00','1','63.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-20 13:31:25','2024-08-05 04:41:09',NULL,'1','Update Invoice','1'),
('3974','VR-24-3974','2024-05-20 00:00:00','0','1250.00','1','292.37','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-05-20 14:56:20','2024-05-20 14:56:20',NULL,'1','Add New Invoice','1'),
('3975','VR-24-3975','2024-05-20 00:00:00','0','1250.00','1','35.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-05-20 15:04:04','2024-05-20 15:04:04',NULL,'1','Add New Invoice','1'),
('3976','VR-24-3976','2024-05-20 00:00:00','0','1250.00','1','300.77','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-20 15:08:07','2024-05-20 15:08:07',NULL,'1','Add New Invoice','1'),
('3977','VR-24-3977','2024-05-20 00:00:00','0','1250.00','1','926.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-20 16:43:47','2024-05-25 08:37:31',NULL,'1','Update Invoice','1'),
('3978','VR-24-3978','2024-05-20 00:00:00','0','1250.00','1','444.81','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-20 16:47:54','2024-05-20 16:47:54',NULL,'1','Add New Invoice','1'),
('3979','VR-24-3979','2024-05-21 00:00:00','0','1250.00','1','158.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-21 09:36:28','2024-05-21 09:36:28',NULL,'1','Add New Invoice','1'),
('3980','VR-24-3980','2024-05-21 00:00:00','0','1250.00','1','81.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-21 13:22:17','2024-05-21 13:22:17',NULL,'1','Add New Invoice','1'),
('3981','VR-24-3981','2024-05-21 00:00:00','0','1250.00','1','91.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-21 14:05:18','2024-05-21 14:05:18',NULL,'1','Add New Invoice','1'),
('3982','VR-24-3982','2024-05-21 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-05-21 14:35:05','2024-05-21 14:35:05',NULL,'1','Add New Invoice','1'),
('3983','VR-24-3983','2024-05-21 00:00:00','0','1250.00','1','45.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-21 14:37:40','2024-05-21 14:37:40',NULL,'1','Add New Invoice','1'),
('3984','VR-24-3984','2024-05-21 00:00:00','0','1250.00','1','53.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-21 14:43:40','2024-05-21 14:43:40',NULL,'1','Add New Invoice','1'),
('3985','VR-24-3985','2024-05-21 00:00:00','0','1250.00','1','133.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-21 14:46:05','2024-05-21 14:46:05',NULL,'1','Add New Invoice','1'),
('3986','VR-24-3986','2024-05-21 00:00:00','0','1250.00','1','117.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-05-21 16:10:39','2024-05-21 16:10:39',NULL,'1','Add New Invoice','1'),
('3987','INV-24-3987','2024-05-23 00:00:00','0','1250.00','1','187.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-23 10:09:15','2024-05-23 10:09:15',NULL,'1','Add New Invoice','1'),
('3988','INV-24-3988','2024-05-23 00:00:00','0','1250.00','1','189.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-05-23 10:10:47','2024-05-23 10:10:47',NULL,'1','Add New Invoice','1'),
('3989','VR-24-3989','2024-05-23 00:00:00','0','1250.00','1','390.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-23 13:34:42','2024-05-23 02:25:40',NULL,'1','Update Invoice','1'),
('3990','VR-24-3990','2024-05-23 00:00:00','0','1250.00','1','21.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-05-23 13:36:27','2024-05-23 13:36:27',NULL,'1','Add New Invoice','1'),
('3991','VR-24-3991','2024-05-23 00:00:00','0','1250.00','1','155.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2024-05-23 14:23:10','2024-05-23 14:23:10',NULL,'1','Add New Invoice','1'),
('3992','VR-24-3992','2024-05-23 00:00:00','0','1250.00','1','749.21','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-23 15:02:15','2024-05-23 15:02:15',NULL,'1','Add New Invoice','1'),
('3993','VR-24-3993','2024-05-23 00:00:00','0','1250.00','1','122.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-05-23 15:12:37','2024-05-23 15:12:37',NULL,'1','Add New Invoice','1'),
('3994','VR-24-3994','2024-05-23 00:00:00','0','1250.00','1','63.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-23 15:29:35','2024-05-23 15:29:35',NULL,'1','Add New Invoice','1'),
('3995','VR-24-3995','2024-05-23 00:00:00','0','1250.00','1','176.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-23 16:06:27','2024-05-23 16:06:27',NULL,'1','Add New Invoice','1'),
('3996','VR-24-3996','2024-05-25 00:00:00','0','1250.00','1','27.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','1','2024-05-25 10:21:20','2024-05-25 10:21:20','2024-05-27 10:51:39','1','Delete Invoice','1'),
('3997','VR-24-3997','2024-05-25 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-25 10:28:19','2024-05-25 10:28:19',NULL,'1','Add New Invoice','1'),
('3998','VR-24-3998','2024-05-25 00:00:00','0','1250.00','1','269.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-25 13:40:32','2024-05-25 13:40:32',NULL,'1','Add New Invoice','1'),
('3999','VR-24-3999','2024-05-25 00:00:00','0','1250.00','1','214.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-25 13:45:53','2024-05-25 13:45:53',NULL,'1','Add New Invoice','1'),
('4000','VR-24-4000','2024-05-25 00:00:00','0','1250.00','1','8283.22','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-05-25 14:16:50','2024-05-25 14:16:50',NULL,'1','Add New Invoice','1'),
('4001','VR-24-4001','2024-05-26 00:00:00','0','1250.00','1','7220.29','0.00','تول كالفين','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-26 11:50:37','2024-05-26 12:03:17',NULL,'1','Update Invoice','1'),
('4002','VR-24-4002','2024-05-26 00:00:00','0','1250.00','1','12130.24','0.00','قماس كالفين','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-26 13:37:29','2024-06-06 11:37:52',NULL,'1','Update Invoice','1'),
('4003','VR-24-4003','2024-05-27 00:00:00','0','1250.00','1','330.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-27 14:37:06','2024-05-27 14:37:06',NULL,'1','Add New Invoice','1'),
('4004','VR-24-4004','2024-05-27 00:00:00','0','1250.00','1','152.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-05-27 15:27:02','2024-05-27 15:27:02',NULL,'1','Add New Invoice','1'),
('4005','VR-24-4005','2024-05-27 00:00:00','0','1250.00','1','431.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-27 15:35:00','2024-05-27 03:35:50',NULL,'1','Update Invoice','1'),
('4006','VR-24-4006','2024-05-27 00:00:00','0','1250.00','1','1053.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-27 15:44:24','2024-05-27 15:44:24',NULL,'1','Add New Invoice','1'),
('4007','VR-24-4007','2024-05-27 00:00:00','0','1250.00','1','703.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-27 15:51:32','2024-05-27 15:51:32',NULL,'1','Add New Invoice','1'),
('4008','VR-24-4008','2024-05-27 00:00:00','0','1250.00','1','501.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-05-27 15:58:22','2024-06-04 10:38:57',NULL,'1','Update Invoice','1'),
('4009','VR-24-4009','2024-05-27 00:00:00','0','1250.00','1','602.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-27 16:12:18','2024-05-27 04:54:29',NULL,'1','Update Invoice','1'),
('4010','VR-24-4010','2024-05-28 00:00:00','0','1250.00','1','352.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-28 12:31:34','2024-05-28 12:31:34',NULL,'1','Add New Invoice','1'),
('4011','VR-24-4011','2024-05-28 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-05-28 12:32:57','2024-05-28 12:32:57',NULL,'1','Add New Invoice','1'),
('4012','VR-24-4012','2024-05-28 00:00:00','0','1250.00','1','154.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-05-28 13:33:14','2024-05-28 13:33:14',NULL,'1','Add New Invoice','1'),
('4013','VR-24-4013','2024-05-28 00:00:00','0','1250.00','1','17.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-05-28 15:01:59','2024-05-28 15:01:59',NULL,'1','Add New Invoice','1'),
('4014','VR-24-4014','2024-05-28 00:00:00','0','1250.00','1','79.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-05-28 16:14:29','2024-05-28 16:14:29',NULL,'1','Add New Invoice','1'),
('4015','VR-24-4015','2024-05-29 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-05-29 09:37:14','2024-05-29 09:37:14',NULL,'1','Add New Invoice','1'),
('4016','VR-24-4016','2024-05-29 00:00:00','0','1250.00','1','306.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-05-29 10:50:26','2024-05-29 10:50:26',NULL,'1','Add New Invoice','1'),
('4017','VR-24-4017','2024-05-29 00:00:00','0','1250.00','1','504.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-05-29 11:42:23','2024-05-29 03:14:14',NULL,'1','Update Invoice','1'),
('4018','VR-24-4018','2024-05-29 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-29 11:44:43','2024-05-29 11:44:43',NULL,'1','Add New Invoice','1'),
('4019','VR-24-4019','2024-05-29 00:00:00','0','1250.00','1','217.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-05-29 15:05:55','2024-05-29 15:05:55',NULL,'1','Add New Invoice','1'),
('4020','VR-24-4020','2024-05-29 00:00:00','0','1250.00','1','171.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-05-29 15:07:53','2024-05-29 15:07:53',NULL,'1','Add New Invoice','1'),
('4021','VR-24-4021','2024-05-29 00:00:00','0','1250.00','1','275.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-29 15:25:08','2024-05-30 10:09:40',NULL,'1','Update Invoice','1'),
('4022','VR-24-4022','2024-05-29 00:00:00','0','1250.00','1','43.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-05-29 15:26:49','2024-05-29 15:26:49',NULL,'1','Add New Invoice','1'),
('4023','VR-24-4023','2024-05-29 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-05-29 16:08:16','2024-05-29 16:08:16',NULL,'1','Add New Invoice','1'),
('4024','VR-24-4024','2024-05-29 00:00:00','0','1250.00','1','52.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-05-29 16:09:57','2024-05-29 16:09:57',NULL,'1','Add New Invoice','1'),
('4025','VR-24-4025','2024-05-29 00:00:00','0','1250.00','1','104.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-05-29 16:21:46','2024-05-29 16:21:46',NULL,'1','Add New Invoice','1'),
('4026','VR-24-4026','2024-05-29 00:00:00','0','1250.00','1','77.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-05-29 16:36:13','2024-05-29 16:36:13',NULL,'1','Add New Invoice','1'),
('4027','VR-24-4027','2024-05-29 00:00:00','0','1250.00','1','82.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-05-29 16:38:43','2024-05-29 16:38:43',NULL,'1','Add New Invoice','1'),
('4028','VR-24-4028','2024-05-29 00:00:00','0','1250.00','1','152.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-05-29 16:41:38','2024-05-29 16:41:38',NULL,'1','Add New Invoice','1'),
('4029','VR-24-4029','2024-05-29 00:00:00','0','1250.00','1','129.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-05-29 16:42:21','2024-05-29 04:51:30',NULL,'1','Update Invoice','1'),
('4030','VR-24-4030','2024-05-29 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-05-29 16:43:22','2024-05-29 16:43:22',NULL,'1','Add New Invoice','1'),
('4031','VR-24-4031','2024-05-30 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-05-30 12:39:38','2024-05-30 12:39:38',NULL,'1','Add New Invoice','1'),
('4032','INV-24-4032','2024-06-01 00:00:00','0','1250.00','1','566.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','1','2024-06-01 03:05:43','2024-06-01 03:05:43','2024-06-01 05:15:18','1','Delete Invoice','1'),
('4033','INV-24-4033','2024-06-02 00:00:00','0','1250.00','1','60.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-06-02 09:01:03','2024-06-02 09:01:03',NULL,'1','Add New Invoice','1'),
('4034','INV-24-4034','2024-06-02 00:00:00','0','1250.00','1','161.70','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-06-02 09:04:55','2024-06-02 09:04:55',NULL,'1','Add New Invoice','1'),
('4035','VR-24-4035','2024-06-02 00:00:00','0','1250.00','1','71.91','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-02 15:29:56','2024-06-02 15:29:56',NULL,'1','Add New Invoice','1'),
('4036','VR-24-4036','2024-06-02 00:00:00','0','1250.00','1','264.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-02 15:52:13','2024-06-02 15:52:13',NULL,'1','Add New Invoice','1'),
('4037','VR-24-4037','2024-06-03 00:00:00','0','1250.00','1','102.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-03 15:44:33','2024-06-03 15:44:33',NULL,'1','Add New Invoice','1'),
('4038','VR-24-4038','2024-06-03 00:00:00','0','1250.00','1','159.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-06-03 15:53:02','2024-06-03 15:53:02',NULL,'1','Add New Invoice','1'),
('4039','VR-24-4039','2024-06-03 00:00:00','0','1250.00','1','152.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-06-03 16:00:52','2024-06-03 16:00:52',NULL,'1','Add New Invoice','1'),
('4040','VR-24-4040','2024-06-03 00:00:00','0','1250.00','1','3756.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-06-03 16:57:53','2024-06-04 10:38:19',NULL,'1','Update Invoice','1'),
('4041','VR-24-4041','2024-06-03 00:00:00','0','1250.00','1','5.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-06-03 17:00:10','2024-06-03 17:00:10',NULL,'1','Add New Invoice','1'),
('4042','VR-24-4042','2024-06-03 00:00:00','0','1250.00','1','119.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-03 17:02:51','2024-06-03 17:02:51',NULL,'1','Add New Invoice','1'),
('4043','VR-24-4043','2024-06-03 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','116','0','2024-06-03 17:03:47','2024-06-03 17:03:47',NULL,'1','Add New Invoice','1'),
('4044','VR-24-4044','2024-06-03 00:00:00','0','1250.00','1','2922.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-06-03 17:19:48','2024-06-03 17:19:48',NULL,'1','Add New Invoice','1'),
('4045','VR-24-4045','2024-06-03 00:00:00','0','1250.00','1','194.49','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-06-03 17:26:42','2024-06-03 17:26:42',NULL,'1','Add New Invoice','1'),
('4046','VR-24-4046','2024-06-03 00:00:00','0','1250.00','1','511.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-03 17:34:59','2024-06-03 17:34:59',NULL,'1','Add New Invoice','1'),
('4047','VR-24-4047','2024-06-03 00:00:00','0','1250.00','1','150.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-06-03 17:35:56','2024-06-03 17:35:56',NULL,'1','Add New Invoice','1'),
('4048','VR-24-4048','2024-06-04 00:00:00','0','1250.00','1','502.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-04 09:12:58','2024-06-04 09:12:58',NULL,'1','Add New Invoice','1'),
('4049','VR-24-4049','2024-06-04 00:00:00','0','1250.00','1','30.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-04 09:16:36','2024-06-04 09:16:36',NULL,'1','Add New Invoice','1'),
('4050','VR-24-4050','2024-06-04 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-06-04 10:52:32','2024-06-04 10:52:32',NULL,'1','Add New Invoice','1'),
('4051','INV-24-4051','2024-06-04 00:00:00','0','1250.00','1','160.30','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','1','2024-06-04 11:14:01','2024-06-04 11:14:01','2024-08-04 11:58:08','1','Delete Invoice','1'),
('4052','VR-24-4052','2024-06-04 00:00:00','0','1250.00','1','900.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-06-04 13:30:00','2024-06-04 13:30:00',NULL,'1','Add New Invoice','1'),
('4053','VR-24-4053','2024-06-04 00:00:00','0','1250.00','1','132.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-06-04 14:22:18','2024-06-04 14:22:18',NULL,'1','Add New Invoice','1'),
('4054','VR-24-4054','2024-06-04 00:00:00','0','1250.00','1','94.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-04 14:44:42','2024-06-04 14:44:42',NULL,'1','Add New Invoice','1'),
('4055','VR-24-4055','2024-06-04 00:00:00','0','1250.00','1','82.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-06-04 14:51:35','2024-06-04 14:51:35',NULL,'1','Add New Invoice','1'),
('4056','VR-24-4056','2024-06-04 00:00:00','0','1250.00','1','116.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-06-04 14:53:26','2024-06-04 14:53:26',NULL,'1','Add New Invoice','1'),
('4057','VR-24-4057','2024-06-04 00:00:00','0','1250.00','1','181.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-06-04 14:54:09','2024-06-04 14:54:09',NULL,'1','Add New Invoice','1'),
('4058','VR-24-4058','2024-06-04 00:00:00','0','1250.00','1','680.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-04 14:57:24','2024-06-04 14:57:24',NULL,'1','Add New Invoice','1'),
('4059','VR-24-4059','2024-06-04 00:00:00','0','1250.00','1','661.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-04 16:01:45','2024-06-22 04:18:33',NULL,'1','Update Invoice','1'),
('4060','VR-24-4060','2024-06-05 00:00:00','0','1250.00','1','180.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-06-05 16:22:59','2024-06-05 16:22:59',NULL,'1','Add New Invoice','1'),
('4061','VR-24-4061','2024-06-05 00:00:00','0','1250.00','1','54.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-05 16:25:30','2024-06-05 16:25:30',NULL,'1','Add New Invoice','1'),
('4062','VR-24-4062','2024-06-05 00:00:00','0','1250.00','1','156.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-05 16:27:04','2024-08-05 04:42:06',NULL,'1','Update Invoice','1'),
('4063','VR-24-4063','2024-06-05 00:00:00','0','1250.00','1','99.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-06-05 16:34:27','2024-06-05 16:34:27',NULL,'1','Add New Invoice','1'),
('4064','VR-24-4064','2024-06-05 00:00:00','0','1250.00','1','889.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-06-05 16:51:25','2024-06-05 16:51:25',NULL,'1','Add New Invoice','1'),
('4065','VR-24-4065','2024-06-06 00:00:00','0','1250.00','1','8793.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-06 13:28:42','2024-06-06 13:28:42',NULL,'1','Add New Invoice','1'),
('4066','VR-24-4066','2024-06-06 00:00:00','0','1250.00','1','3479.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-06 14:50:56','2024-06-06 14:50:56',NULL,'1','Add New Invoice','1'),
('4067','VR-24-4067','2024-06-06 00:00:00','0','1250.00','1','977.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-06 14:58:23','2024-06-06 14:58:23',NULL,'1','Add New Invoice','1'),
('4068','VR-24-4068','2024-06-06 00:00:00','0','1250.00','1','370.07','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-06 15:20:22','2024-06-06 15:20:22',NULL,'1','Add New Invoice','1'),
('4069','VR-24-4069','2024-06-06 00:00:00','0','1250.00','1','43.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-06-06 15:52:01','2024-06-06 15:52:01',NULL,'1','Add New Invoice','1'),
('4070','VR-24-4070','2024-06-06 00:00:00','0','1250.00','1','152.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','1','2024-06-06 15:55:52','2024-06-06 15:55:52','2024-06-06 05:37:40','1','Delete Invoice','1'),
('4071','VR-24-4071','2024-06-06 00:00:00','0','1250.00','1','50.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-06-06 15:59:28','2024-06-06 15:59:28',NULL,'1','Add New Invoice','1'),
('4072','VR-24-4072','2024-06-06 00:00:00','0','1250.00','1','330.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-06 17:26:11','2024-06-06 17:26:11',NULL,'1','Add New Invoice','1'),
('4073','VR-24-4073','2024-06-06 00:00:00','0','1250.00','1','35.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-06-06 17:28:38','2024-06-06 17:28:38',NULL,'1','Add New Invoice','1'),
('4074','VR-24-4074','2024-06-08 00:00:00','0','1250.00','1','307.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','76','0','2024-06-08 09:34:47','2024-06-08 01:37:23',NULL,'1','Update Invoice','1'),
('4075','VR-24-4075','2024-06-08 00:00:00','0','1250.00','1','597.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-06-08 13:38:46','2024-07-18 02:45:37',NULL,'1','Update Invoice','1'),
('4076','VR-24-4076','2024-06-08 00:00:00','0','1250.00','1','780.51','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-08 15:19:34','2024-06-08 15:19:34',NULL,'1','Add New Invoice','1'),
('4077','VR-24-4077','2024-06-08 00:00:00','0','1250.00','1','428.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-06-08 16:05:24','2024-06-08 16:05:24',NULL,'1','Add New Invoice','1'),
('4078','VR-24-4078','2024-06-08 00:00:00','0','1250.00','1','156.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-06-08 16:14:07','2024-06-08 16:14:07',NULL,'1','Add New Invoice','1'),
('4079','VR-24-4079','2024-06-08 00:00:00','0','1250.00','1','89.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-08 16:45:19','2024-06-08 16:45:19',NULL,'1','Add New Invoice','1'),
('4080','VR-24-4080','2024-06-08 00:00:00','0','1250.00','1','6029.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-06-08 17:08:16','2024-06-08 05:18:23',NULL,'1','Update Invoice','1'),
('4081','VR-24-4081','2024-06-08 00:00:00','0','1250.00','1','632.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-08 17:14:50','2024-06-08 17:14:50',NULL,'1','Add New Invoice','1'),
('4082','VR-24-4082','2024-06-08 00:00:00','0','1250.00','1','20.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-06-08 17:27:45','2024-06-08 17:27:45',NULL,'1','Add New Invoice','1'),
('4083','INV-24-4083','2024-06-09 00:00:00','0','1250.00','1','508.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-06-09 12:59:47','2024-06-09 12:59:47',NULL,'1','Add New Invoice','1'),
('4084','VR-24-4084','2024-06-09 00:00:00','0','1250.00','1','499.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-09 14:33:25','2024-10-28 09:14:52',NULL,'1','Update Invoice','1'),
('4085','VR-24-4085','2024-06-10 00:00:00','0','1250.00','1','425.18','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-10 12:46:04','2024-06-10 12:46:04',NULL,'1','Add New Invoice','1'),
('4086','VR-24-4086','2024-06-10 00:00:00','0','1250.00','1','1226.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-10 12:50:48','2024-06-10 12:50:48',NULL,'1','Add New Invoice','1'),
('4087','VR-24-4087','2024-06-10 00:00:00','0','1250.00','1','405.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-10 15:04:01','2024-06-22 04:18:57',NULL,'1','Update Invoice','1'),
('4088','VR-24-4088','2024-06-10 00:00:00','0','1250.00','1','738.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-06-10 15:37:47','2024-06-10 15:37:47',NULL,'1','Add New Invoice','1'),
('4089','VR-24-4089','2024-06-10 00:00:00','0','1250.00','1','182.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','127','1','2024-06-10 15:43:03','2024-06-10 15:43:03','2024-06-11 12:03:54','1','Delete Invoice','1'),
('4090','VR-24-4090','2024-06-10 00:00:00','0','1250.00','1','457.19','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-10 15:54:18','2024-06-10 15:54:18',NULL,'1','Add New Invoice','1'),
('4091','VR-24-4091','2024-06-10 00:00:00','0','1250.00','1','56.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-06-10 16:06:43','2024-06-10 16:06:43',NULL,'1','Add New Invoice','1'),
('4092','VR-24-4092','2024-06-10 00:00:00','0','1250.00','1','167.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-06-10 16:13:01','2024-06-10 16:13:01',NULL,'1','Add New Invoice','1'),
('4093','VR-24-4093','2024-06-11 00:00:00','0','1250.00','1','14.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','127','1','2024-06-11 09:23:50','2024-06-11 11:53:31','2024-06-11 12:03:46','1','Delete Invoice','1'),
('4094','VR-24-4094','2024-06-11 00:00:00','0','1250.00','1','131.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-06-11 10:12:13','2024-06-11 10:12:13',NULL,'1','Add New Invoice','1'),
('4095','VR-24-4095','2024-06-11 00:00:00','0','1250.00','1','766.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-06-11 10:25:22','2024-06-11 01:52:47',NULL,'1','Update Invoice','1'),
('4096','VR-24-4096','2024-06-11 00:00:00','0','1250.00','1','127.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-06-11 10:40:49','2024-06-11 10:40:49',NULL,'1','Add New Invoice','1'),
('4097','VR-24-4097','2024-06-11 00:00:00','0','1250.00','1','140.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-11 10:44:56','2024-06-11 10:44:56',NULL,'1','Add New Invoice','1'),
('4098','VR-24-4098','2024-06-11 00:00:00','0','1250.00','1','215.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-06-11 10:46:25','2024-06-11 10:46:25',NULL,'1','Add New Invoice','1'),
('4099','INV-24-4099','2024-06-11 00:00:00','0','1250.00','1','347.30','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-11 12:29:38','2024-06-11 12:29:38',NULL,'1','Add New Invoice','1'),
('4100','VR-24-4100','2024-06-11 00:00:00','0','1250.00','1','284.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-11 13:17:17','2024-06-11 02:45:07',NULL,'1','Update Invoice','1'),
('4101','VR-24-4101','2024-06-11 00:00:00','0','1250.00','1','196.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-11 13:46:32','2024-06-11 13:46:32',NULL,'1','Add New Invoice','1'),
('4102','VR-24-4102','2024-06-11 00:00:00','0','1250.00','1','61.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-06-11 14:05:49','2024-06-11 14:05:49',NULL,'1','Add New Invoice','1'),
('4103','VR-24-4103','2024-06-11 00:00:00','0','1250.00','1','431.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-11 17:15:24','2024-06-11 17:15:24',NULL,'1','Add New Invoice','1'),
('4104','VR-24-4104','2024-06-12 00:00:00','0','1250.00','1','734.03','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-12 12:30:40','2024-06-12 12:30:40',NULL,'1','Add New Invoice','1'),
('4105','VR-24-4105','2024-06-12 00:00:00','0','1250.00','1','212.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-12 12:34:34','2024-06-12 05:15:29',NULL,'1','Update Invoice','1'),
('4106','VR-24-4106','2024-06-12 00:00:00','0','1250.00','1','78.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-12 15:34:41','2024-06-22 04:19:23',NULL,'1','Update Invoice','1'),
('4107','VR-24-4107','2024-06-12 00:00:00','0','1250.00','1','28.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-12 15:36:53','2024-06-12 15:36:53',NULL,'1','Add New Invoice','1'),
('4108','INV-24-4108','2024-06-12 00:00:00','0','1250.00','1','194.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-06-12 03:46:55','2024-06-12 03:46:55',NULL,'1','Add New Invoice','1'),
('4109','INV-24-4109','2024-06-12 00:00:00','0','1250.00','1','165.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-12 03:47:48','2024-06-12 03:47:48',NULL,'1','Add New Invoice','1'),
('4110','INV-24-4110','2024-06-12 00:00:00','0','1250.00','1','76.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-12 03:49:15','2024-06-12 03:49:15',NULL,'1','Add New Invoice','1'),
('4111','INV-24-4111','2024-06-12 00:00:00','0','1250.00','1','381.95','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-12 03:53:39','2024-06-12 03:53:39',NULL,'1','Add New Invoice','1'),
('4112','INV-24-4112','2024-06-12 00:00:00','0','1250.00','1','55.00','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-06-12 03:56:01','2024-06-12 03:56:01',NULL,'1','Add New Invoice','1'),
('4113','VR-24-4113','2024-06-12 00:00:00','0','1250.00','1','69.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-06-12 16:03:58','2024-06-12 16:03:58',NULL,'1','Add New Invoice','1'),
('4114','VR-24-4114','2024-06-12 00:00:00','0','1250.00','1','7.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-06-12 16:06:56','2024-06-12 16:06:56',NULL,'1','Add New Invoice','1'),
('4115','VR-24-4115','2024-06-12 00:00:00','0','1250.00','1','206.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-12 16:49:14','2024-06-12 04:58:16',NULL,'1','Update Invoice','1'),
('4116','VR-24-4116','2024-06-12 00:00:00','0','1250.00','1','117.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-06-12 17:11:16','2024-06-12 17:11:16',NULL,'1','Add New Invoice','1'),
('4117','VR-24-4117','2024-06-12 00:00:00','0','1250.00','1','108.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-06-12 17:12:14','2024-06-12 17:12:14',NULL,'1','Add New Invoice','1'),
('4118','VR-24-4118','2024-06-12 00:00:00','0','1250.00','1','24.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-06-12 17:13:00','2024-06-12 17:13:00',NULL,'1','Add New Invoice','1'),
('4119','VR-24-4119','2024-06-13 00:00:00','0','1250.00','1','199.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-06-13 11:50:46','2024-06-13 11:50:46',NULL,'1','Add New Invoice','1'),
('4120','VR-24-4120','2024-06-13 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-06-13 12:59:52','2024-06-13 12:59:52',NULL,'1','Add New Invoice','1'),
('4121','VR-24-4121','2024-06-13 00:00:00','0','1250.00','1','91.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-06-13 13:46:35','2024-06-13 13:46:35',NULL,'1','Add New Invoice','1'),
('4122','VR-24-4122','2024-06-13 00:00:00','0','1250.00','1','176.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-06-13 13:50:09','2024-06-23 09:14:12',NULL,'1','Update Invoice','1'),
('4123','VR-24-4123','2024-06-13 00:00:00','0','1250.00','1','418.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-06-13 14:44:22','2024-06-13 14:44:22',NULL,'1','Add New Invoice','1'),
('4124','VR-24-4124','2024-06-13 00:00:00','0','1250.00','1','165.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2024-06-13 14:53:17','2024-06-13 14:53:17',NULL,'1','Add New Invoice','1'),
('4125','VR-24-4125','2024-06-13 00:00:00','0','1250.00','1','113.12','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-06-13 14:54:28','2024-06-13 03:05:42',NULL,'1','Update Invoice','1'),
('4126','VR-24-4126','2024-06-13 00:00:00','0','1250.00','1','75.24','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2024-06-13 14:55:45','2024-06-13 14:55:45',NULL,'1','Add New Invoice','1'),
('4127','VR-24-4127','2024-06-13 00:00:00','0','1250.00','1','504.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-13 15:02:32','2024-06-13 15:02:32',NULL,'1','Add New Invoice','1'),
('4128','VR-24-4128','2024-06-13 00:00:00','0','1250.00','1','127.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-13 15:03:27','2024-06-13 15:03:27',NULL,'1','Add New Invoice','1'),
('4129','VR-24-4129','2024-06-13 00:00:00','0','1250.00','1','92.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-06-13 15:12:42','2024-06-13 15:12:42',NULL,'1','Add New Invoice','1'),
('4130','VR-24-4130','2024-06-13 00:00:00','0','1250.00','1','11.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-06-13 15:28:14','2024-06-13 15:28:14',NULL,'1','Add New Invoice','1'),
('4131','VR-24-4131','2024-06-13 00:00:00','0','1250.00','1','22.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-06-13 15:43:54','2024-06-13 15:43:54',NULL,'1','Add New Invoice','1'),
('4132','VR-24-4132','2024-06-22 00:00:00','0','1250.00','1','387.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','1','2024-06-22 14:18:48','2024-06-22 02:57:41','2024-07-13 11:02:28','1','Delete Invoice','1'),
('4133','VR-24-4133','2024-06-22 00:00:00','0','1250.00','1','256.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-22 16:12:43','2024-06-22 16:12:43',NULL,'1','Add New Invoice','1'),
('4134','INV-24-4134','2024-06-22 00:00:00','0','1250.00','1','13.32','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-22 04:57:04','2024-06-22 04:57:04',NULL,'1','Add New Invoice','1'),
('4135','VR-24-4135','2024-06-22 00:00:00','0','1250.00','1','221.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-06-22 17:01:41','2024-06-23 09:13:54',NULL,'1','Update Invoice','1'),
('4136','VR-24-4136','2024-06-22 00:00:00','0','1250.00','1','14.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-06-22 17:08:05','2024-06-22 17:08:05',NULL,'1','Add New Invoice','1'),
('4137','VR-24-4137','2024-06-23 00:00:00','0','1250.00','1','77.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-06-23 15:40:36','2024-06-23 05:21:05',NULL,'1','Update Invoice','1'),
('4138','VR-24-4138','2024-06-23 00:00:00','0','1250.00','1','188.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-06-23 16:19:53','2024-06-23 16:19:53',NULL,'1','Add New Invoice','1'),
('4139','VR-24-4139','2024-06-23 00:00:00','0','1250.00','1','587.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-06-23 16:28:41','2024-06-23 16:28:41',NULL,'1','Add New Invoice','1'),
('4140','VR-24-4140','2024-06-23 00:00:00','0','1250.00','1','361.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-23 16:33:24','2024-06-23 16:33:24',NULL,'1','Add New Invoice','1'),
('4141','VR-24-4141','2024-06-23 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-06-23 16:35:51','2024-06-23 16:35:51',NULL,'1','Add New Invoice','1'),
('4142','INV-24-4142','2024-06-23 00:00:00','0','1250.00','1','25.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-23 05:07:57','2024-06-24 09:57:28',NULL,'1','Update Invoice','1'),
('4143','VR-24-4143','2024-06-23 00:00:00','0','1250.00','1','87.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-23 17:15:32','2024-06-23 17:15:32',NULL,'1','Add New Invoice','1'),
('4144','INV-24-4144','2024-06-23 00:00:00','0','1250.00','1','19.08','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-06-23 05:32:21','2024-06-23 05:32:21',NULL,'1','Add New Invoice','1'),
('4145','INV-24-4145','2024-06-24 00:00:00','0','1250.00','1','17.85','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-06-24 09:58:09','2024-06-24 04:42:38',NULL,'1','Update Invoice','1'),
('4146','VR-24-4146','2024-06-24 00:00:00','0','1250.00','1','6525.44','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-24 10:41:14','2024-06-24 10:41:14',NULL,'1','Add New Invoice','1'),
('4147','VR-24-4147','2024-06-24 00:00:00','0','1250.00','1','128.52','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-24 14:36:25','2024-06-24 14:36:25',NULL,'1','Add New Invoice','1'),
('4148','VR-24-4148','2024-06-24 00:00:00','0','1250.00','1','366.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-06-24 15:41:49','2024-06-24 15:41:49',NULL,'1','Add New Invoice','1'),
('4149','VR-24-4149','2024-06-24 00:00:00','0','1250.00','1','460.14','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-06-24 15:58:07','2024-06-24 03:59:02',NULL,'1','Update Invoice','1'),
('4150','VR-24-4150','2024-06-24 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-06-24 16:24:08','2024-06-24 16:24:08',NULL,'1','Add New Invoice','1'),
('4151','VR-24-4151','2024-06-24 00:00:00','0','1250.00','1','45.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-06-24 16:28:28','2024-06-24 16:28:28',NULL,'1','Add New Invoice','1'),
('4152','VR-24-4152','2024-06-24 00:00:00','0','1250.00','1','552.66','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-24 16:57:05','2024-06-24 16:57:05',NULL,'1','Add New Invoice','1'),
('4153','VR-24-4153','2024-06-24 00:00:00','0','1250.00','1','238.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-24 17:02:35','2024-06-25 05:37:05',NULL,'1','Update Invoice','1'),
('4154','VR-24-4154','2024-06-24 00:00:00','0','1250.00','1','140.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-06-24 17:04:07','2024-06-24 17:04:07',NULL,'1','Add New Invoice','1'),
('4155','VR-24-4155','2024-06-24 00:00:00','0','1250.00','1','36.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-06-24 17:05:22','2024-06-24 05:06:20',NULL,'1','Update Invoice','1'),
('4156','VR-24-4156','2024-06-25 00:00:00','0','1250.00','1','1648.92','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-25 15:11:08','2024-06-25 15:11:08',NULL,'1','Add New Invoice','1'),
('4157','VR-24-4157','2024-06-25 00:00:00','0','1250.00','1','32.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-25 15:36:26','2024-06-25 15:36:26',NULL,'1','Add New Invoice','1'),
('4158','VR-24-4158','2024-06-25 00:00:00','0','1250.00','1','44.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-06-25 16:16:48','2024-06-25 16:16:48',NULL,'1','Add New Invoice','1'),
('4159','VR-24-4159','2024-06-25 00:00:00','0','1250.00','1','301.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-25 17:22:07','2024-06-25 17:22:07',NULL,'1','Add New Invoice','1'),
('4160','VR-24-4160','2024-06-25 00:00:00','0','1250.00','1','87.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-06-25 17:30:14','2024-06-25 17:30:14',NULL,'1','Add New Invoice','1'),
('4161','VR-24-4161','2024-06-26 00:00:00','0','1250.00','1','52.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-06-26 12:53:54','2024-06-26 12:53:54',NULL,'1','Add New Invoice','1'),
('4162','VR-24-4162','2024-06-26 00:00:00','0','1250.00','1','50.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-06-26 17:16:31','2024-06-26 17:16:31',NULL,'1','Add New Invoice','1'),
('4163','VR-24-4163','2024-06-26 00:00:00','0','1250.00','1','264.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-06-26 17:17:46','2024-06-26 17:17:46',NULL,'1','Add New Invoice','1'),
('4164','VR-24-4164','2024-06-26 00:00:00','0','1250.00','1','1151.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-06-26 17:20:07','2024-06-26 17:20:07',NULL,'1','Add New Invoice','1'),
('4165','VR-24-4165','2024-06-26 00:00:00','0','1250.00','1','261.59','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-26 17:26:17','2024-06-26 17:26:17',NULL,'1','Add New Invoice','1'),
('4166','VR-24-4166','2024-06-27 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-06-27 14:37:57','2024-06-27 14:37:57',NULL,'1','Add New Invoice','1'),
('4167','VR-24-4167','2024-06-27 00:00:00','0','1250.00','1','250.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-06-27 18:50:55','2024-06-27 18:50:55',NULL,'1','Add New Invoice','1'),
('4168','VR-24-4168','2024-06-29 00:00:00','0','1250.00','1','576.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-06-29 12:12:45','2024-06-29 12:12:45',NULL,'1','Add New Invoice','1'),
('4169','VR-24-4169','2024-06-29 00:00:00','0','1250.00','1','210.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-29 14:46:10','2024-06-29 14:46:10',NULL,'1','Add New Invoice','1'),
('4170','VR-24-4170','2024-06-29 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-06-29 17:03:22','2024-06-29 17:03:22',NULL,'1','Add New Invoice','1'),
('4171','VR-24-4171','2024-06-29 00:00:00','0','1250.00','1','121.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-29 17:25:13','2024-06-29 17:25:13',NULL,'1','Add New Invoice','1'),
('4172','VR-24-4172','2024-06-29 00:00:00','0','1250.00','1','174.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-06-29 17:26:43','2024-06-29 05:28:13',NULL,'1','Update Invoice','1'),
('4173','VR-24-4173','2024-06-30 00:00:00','0','1250.00','1','13351.59','0.00','كالفين قماش CALVIN','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-06-30 16:55:39','2024-06-30 16:55:39',NULL,'1','Add New Invoice','1'),
('4174','VR-24-4174','2024-06-30 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-06-30 17:01:40','2024-06-30 17:01:40',NULL,'1','Add New Invoice','1'),
('4175','VR-24-4175','2024-06-30 00:00:00','0','1250.00','1','84.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-06-30 17:40:05','2024-06-30 17:40:05',NULL,'1','Add New Invoice','1'),
('4176','VR-24-4176','2024-06-30 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-06-30 17:45:06','2024-06-30 17:45:06',NULL,'1','Add New Invoice','1'),
('4177','VR-24-4177','2024-06-30 00:00:00','0','1250.00','1','151.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-06-30 17:50:18','2024-06-30 17:50:18',NULL,'1','Add New Invoice','1'),
('4178','VR-24-4178','2024-06-30 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-06-30 17:54:20','2024-06-30 17:54:20',NULL,'1','Add New Invoice','1'),
('4179','INV-24-4179','2024-07-01 00:00:00','0','1250.00','1','24.84','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-01 10:21:51','2024-07-01 10:21:51',NULL,'1','Add New Invoice','1'),
('4180','VR-24-4180','2024-07-01 00:00:00','0','1250.00','1','113.85','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-01 11:45:27','2024-07-01 11:45:27',NULL,'1','Add New Invoice','1'),
('4181','VR-24-4181','2024-07-01 00:00:00','0','1250.00','1','7871.46','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-01 14:45:26','2024-07-01 14:45:26',NULL,'1','Add New Invoice','1'),
('4182','VR-24-4182','2024-07-01 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-07-01 16:29:01','2024-07-01 16:29:01',NULL,'1','Add New Invoice','1'),
('4183','VR-24-4183','2024-07-01 00:00:00','0','1250.00','1','330.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-01 16:38:45','2024-07-01 16:38:45',NULL,'1','Add New Invoice','1'),
('4184','VR-24-4184','2024-07-01 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-07-01 16:41:44','2024-07-01 16:41:44',NULL,'1','Add New Invoice','1'),
('4185','VR-24-4185','2024-07-01 00:00:00','0','1250.00','1','156.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-01 16:46:35','2024-07-01 16:46:35',NULL,'1','Add New Invoice','1'),
('4186','VR-24-4186','2024-07-01 00:00:00','0','1250.00','1','67.38','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-01 16:52:36','2024-07-01 16:52:36',NULL,'1','Add New Invoice','1'),
('4187','VR-24-4187','2024-07-02 00:00:00','0','1250.00','1','111.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-07-02 12:03:26','2024-07-02 12:03:26',NULL,'1','Add New Invoice','1'),
('4188','VR-24-4188','2024-07-02 00:00:00','0','1250.00','1','464.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-07-02 13:07:13','2024-07-02 13:07:13',NULL,'1','Add New Invoice','1'),
('4189','VR-24-4189','2024-07-02 00:00:00','0','1250.00','1','101.34','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-02 13:15:12','2024-07-02 13:15:12',NULL,'1','Add New Invoice','1'),
('4190','VR-24-4190','2024-07-02 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-07-02 17:36:51','2024-07-02 17:36:51',NULL,'1','Add New Invoice','1'),
('4191','VR-24-4191','2024-07-03 00:00:00','0','1250.00','1','134.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-03 10:03:50','2024-07-03 10:03:50',NULL,'1','Add New Invoice','1'),
('4192','VR-24-4192','2024-07-03 00:00:00','0','1250.00','1','117.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-07-03 10:14:42','2024-07-03 10:14:42',NULL,'1','Add New Invoice','1'),
('4193','VR-24-4193','2024-07-03 00:00:00','0','1250.00','1','15.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-07-03 11:05:49','2024-07-03 11:05:49',NULL,'1','Add New Invoice','1'),
('4194','VR-24-4194','2024-07-03 00:00:00','0','1250.00','1','146.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-03 14:10:08','2024-07-03 14:10:08',NULL,'1','Add New Invoice','1'),
('4195','VR-24-4195','2024-07-03 00:00:00','0','1250.00','1','636.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-07-03 14:20:42','2024-07-03 14:20:42',NULL,'1','Add New Invoice','1'),
('4196','VR-24-4196','2024-07-03 00:00:00','0','1250.00','1','8801.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-03 15:49:43','2024-07-03 15:49:43',NULL,'1','Add New Invoice','1'),
('4197','VR-24-4197','2024-07-03 00:00:00','0','1250.00','1','339.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-03 15:54:45','2024-07-03 15:54:45',NULL,'1','Add New Invoice','1'),
('4198','VR-24-4198','2024-07-03 00:00:00','0','1250.00','1','318.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-03 16:10:55','2024-07-03 16:10:55',NULL,'1','Add New Invoice','1'),
('4199','VR-24-4199','2024-07-03 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-07-03 16:50:58','2024-07-03 16:50:58',NULL,'1','Add New Invoice','1'),
('4200','VR-24-4200','2024-07-04 00:00:00','0','1250.00','1','17.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','122','0','2024-07-04 13:02:06','2024-07-04 13:02:06',NULL,'1','Add New Invoice','1'),
('4201','VR-24-4201','2024-07-04 00:00:00','0','1250.00','1','60.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-04 14:02:01','2024-07-04 14:02:01',NULL,'1','Add New Invoice','1'),
('4202','VR-24-4202','2024-07-04 00:00:00','0','1250.00','1','138.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-04 14:07:01','2024-07-04 14:07:01',NULL,'1','Add New Invoice','1'),
('4203','VR-24-4203','2024-07-04 00:00:00','0','1250.00','1','204.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-04 14:58:09','2024-07-04 14:58:09',NULL,'1','Add New Invoice','1'),
('4204','VR-24-4204','2024-07-04 00:00:00','0','1250.00','1','192.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-04 17:03:59','2024-07-04 17:03:59',NULL,'1','Add New Invoice','1'),
('4205','VR-24-4205','2024-07-04 00:00:00','0','1250.00','1','229.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-04 17:06:15','2024-07-06 03:26:32',NULL,'1','Update Invoice','1'),
('4206','VR-24-4206','2024-07-06 00:00:00','0','1250.00','1','219.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-07-06 09:29:46','2024-07-06 09:46:06',NULL,'1','Update Invoice','1'),
('4207','VR-24-4207','2024-07-06 00:00:00','0','1250.00','1','334.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-06 09:34:39','2024-08-05 04:22:06',NULL,'1','Update Invoice','1'),
('4208','VR-24-4208','2024-07-06 00:00:00','0','1250.00','1','45.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-07-06 09:37:01','2024-07-06 09:37:01',NULL,'1','Add New Invoice','1'),
('4209','VR-24-4209','2024-07-06 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-07-06 09:48:01','2024-07-06 09:48:01',NULL,'1','Add New Invoice','1'),
('4210','VR-24-4210','2024-07-06 00:00:00','0','1250.00','1','138.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-06 09:57:16','2024-07-06 09:57:16',NULL,'1','Add New Invoice','1'),
('4211','VR-24-4211','2024-07-06 00:00:00','0','1250.00','1','4257.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-07-06 10:59:27','2024-07-06 10:59:27',NULL,'1','Add New Invoice','1'),
('4212','VR-24-4212','2024-07-06 00:00:00','0','1250.00','1','294.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-07-06 11:07:13','2024-07-06 03:23:47',NULL,'1','Update Invoice','1'),
('4213','VR-24-4213','2024-07-06 00:00:00','0','1250.00','1','159.36','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-07-06 11:31:34','2024-07-06 11:31:34',NULL,'1','Add New Invoice','1'),
('4214','VR-24-4214','2024-07-06 00:00:00','0','1250.00','1','183.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','1','2024-07-06 13:58:55','2024-07-06 13:58:55','2024-07-17 04:38:03','1','Delete Invoice','1'),
('4215','VR-24-4215','2024-07-06 00:00:00','0','1250.00','1','140.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-07-06 15:11:06','2024-07-06 15:11:06',NULL,'1','Add New Invoice','1'),
('4216','VR-24-4216','2024-07-06 00:00:00','0','1250.00','1','66.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-07-06 15:14:38','2024-07-06 15:14:38',NULL,'1','Add New Invoice','1'),
('4217','VR-24-4217','2024-07-06 00:00:00','0','1250.00','1','130.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-07-06 15:17:29','2024-07-06 03:30:02',NULL,'1','Update Invoice','1'),
('4218','VR-24-4218','2024-07-06 00:00:00','0','1250.00','1','39.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-06 15:24:46','2024-07-06 15:24:46',NULL,'1','Add New Invoice','1'),
('4219','VR-24-4219','2024-07-06 00:00:00','0','1250.00','1','28.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-06 15:27:37','2024-07-06 15:27:37',NULL,'1','Add New Invoice','1'),
('4220','VR-24-4220','2024-07-08 00:00:00','0','1250.00','1','291.26','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-08 13:57:38','2024-07-08 13:57:38',NULL,'1','Add New Invoice','1'),
('4221','VR-24-4221','2024-07-08 00:00:00','0','1250.00','1','275.97','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-07-08 14:20:04','2024-07-08 14:20:04',NULL,'1','Add New Invoice','1'),
('4222','VR-24-4222','2024-07-08 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-08 15:35:12','2024-07-08 15:35:12',NULL,'1','Add New Invoice','1'),
('4223','VR-24-4223','2024-07-08 00:00:00','0','1250.00','1','2722.41','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-08 16:56:54','2024-07-08 16:56:54',NULL,'1','Add New Invoice','1'),
('4224','VR-24-4224','2024-07-09 00:00:00','0','1250.00','1','1400.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-07-09 09:35:54','2024-07-09 09:35:54',NULL,'1','Add New Invoice','1'),
('4225','VR-24-4225','2024-07-09 00:00:00','0','1250.00','1','55.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-07-09 09:37:31','2024-07-09 09:37:31',NULL,'1','Add New Invoice','1'),
('4226','VR-24-4226','2024-07-09 00:00:00','0','1250.00','1','225.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-07-09 11:33:20','2024-07-09 11:33:20',NULL,'1','Add New Invoice','1'),
('4227','VR-24-4227','2024-07-09 00:00:00','0','1250.00','1','34.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-09 14:09:09','2024-07-09 14:09:09',NULL,'1','Add New Invoice','1'),
('4228','VR-24-4228','2024-07-09 00:00:00','0','1250.00','1','27.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-09 14:22:33','2024-07-09 14:22:33',NULL,'1','Add New Invoice','1'),
('4229','VR-24-4229','2024-07-09 00:00:00','0','1250.00','1','44.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-09 14:24:10','2024-07-09 14:24:10',NULL,'1','Add New Invoice','1'),
('4230','VR-24-4230','2024-07-09 00:00:00','0','1250.00','1','129.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-09 14:26:47','2024-07-09 14:26:47',NULL,'1','Add New Invoice','1'),
('4231','VR-24-4231','2024-07-09 00:00:00','0','1250.00','1','297.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-07-09 14:31:43','2024-07-09 14:31:43',NULL,'1','Add New Invoice','1'),
('4232','VR-24-4232','2024-07-09 00:00:00','0','1250.00','1','64.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-07-09 14:37:49','2024-07-09 14:37:49',NULL,'1','Add New Invoice','1'),
('4233','VR-24-4233','2024-07-09 00:00:00','0','1250.00','1','145.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-09 14:43:53','2024-07-09 14:43:53',NULL,'1','Add New Invoice','1'),
('4234','VR-24-4234','2024-07-09 00:00:00','0','1250.00','1','625.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-09 14:45:46','2024-07-09 14:45:46',NULL,'1','Add New Invoice','1'),
('4235','VR-24-4235','2024-07-10 00:00:00','0','1250.00','1','7693.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-10 12:30:09','2024-07-23 04:20:48',NULL,'1','Update Invoice','1'),
('4236','VR-24-4236','2024-07-10 00:00:00','0','1250.00','1','91.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-07-10 16:51:23','2024-08-24 03:56:11',NULL,'1','Update Invoice','1'),
('4237','VR-24-4237','2024-07-10 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-07-10 17:02:02','2024-07-10 17:02:02',NULL,'1','Add New Invoice','1'),
('4238','VR-24-4238','2024-07-10 00:00:00','0','1250.00','1','70.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-07-10 17:12:08','2024-07-10 17:12:08',NULL,'1','Add New Invoice','1'),
('4239','VR-24-4239','2024-07-10 00:00:00','0','1250.00','1','576.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-10 17:14:44','2024-07-10 17:14:44',NULL,'1','Add New Invoice','1'),
('4240','VR-24-4240','2024-07-10 00:00:00','0','1250.00','1','105.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-10 17:16:58','2024-07-10 17:16:58',NULL,'1','Add New Invoice','1'),
('4241','VR-24-4241','2024-07-11 00:00:00','0','1250.00','1','12175.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','128','0','2024-07-11 09:48:51','2024-07-11 09:48:51',NULL,'1','Add New Invoice','1'),
('4242','VR-24-4242','2024-07-11 00:00:00','0','1250.00','1','15.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-07-11 14:28:42','2024-07-11 14:28:42',NULL,'1','Add New Invoice','1'),
('4243','VR-24-4243','2024-07-11 00:00:00','0','1250.00','1','126.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-11 15:58:45','2024-07-11 15:58:45',NULL,'1','Add New Invoice','1'),
('4244','VR-24-4244','2024-07-11 00:00:00','0','1250.00','1','261.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-11 16:03:55','2024-07-11 16:03:55',NULL,'1','Add New Invoice','1'),
('4245','INV-24-4245','2024-07-11 00:00:00','0','1250.00','1','148.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-11 04:13:03','2024-07-11 04:13:03',NULL,'1','Add New Invoice','1'),
('4246','INV-24-4246','2024-07-11 00:00:00','0','1250.00','1','304.24','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-11 04:21:50','2024-07-11 04:21:50',NULL,'1','Add New Invoice','1'),
('4247','VR-24-4247','2024-07-13 00:00:00','0','1250.00','1','241.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-13 14:41:19','2024-07-13 14:41:19',NULL,'1','Add New Invoice','1'),
('4248','VR-24-4248','2024-07-13 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-07-13 14:45:02','2024-07-13 14:45:02',NULL,'1','Add New Invoice','1'),
('4249','VR-24-4249','2024-07-13 00:00:00','0','1250.00','1','106.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-13 15:12:13','2024-07-13 15:12:13',NULL,'1','Add New Invoice','1'),
('4250','VR-24-4250','2024-07-13 00:00:00','0','1250.00','1','10.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-07-13 16:19:54','2024-07-13 16:19:54',NULL,'1','Add New Invoice','1'),
('4251','VR-24-4251','2024-07-13 00:00:00','0','1250.00','1','4375.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-13 17:07:12','2024-07-16 03:22:12',NULL,'1','Update Invoice','1'),
('4252','VR-24-4252','2024-07-14 00:00:00','0','1250.00','1','53.73','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-14 11:52:32','2024-07-16 03:22:25',NULL,'1','Update Invoice','1'),
('4253','VR-24-4253','2024-07-14 00:00:00','0','1250.00','1','128.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-07-14 11:58:18','2024-07-14 11:58:18',NULL,'1','Add New Invoice','1'),
('4254','VR-24-4254','2024-07-14 00:00:00','0','1250.00','1','1186.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-14 12:07:34','2024-07-14 12:07:34',NULL,'1','Add New Invoice','1'),
('4255','VR-24-4255','2024-07-14 00:00:00','0','1250.00','1','291.68','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-14 12:08:57','2024-07-14 12:08:57',NULL,'1','Add New Invoice','1'),
('4256','VR-24-4256','2024-07-14 00:00:00','0','1250.00','1','90.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-07-14 12:52:03','2024-07-14 12:52:03',NULL,'1','Add New Invoice','1'),
('4257','VR-24-4257','2024-07-14 00:00:00','0','1250.00','1','42.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-07-14 13:09:22','2024-07-14 13:09:22',NULL,'1','Add New Invoice','1'),
('4258','VR-24-4258','2024-07-14 00:00:00','0','1250.00','1','1601.61','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','1','2024-07-14 13:14:08','2024-07-14 13:14:08','2024-07-15 03:27:00','1','Delete Invoice','1'),
('4259','VR-24-4259','2024-07-14 00:00:00','0','1250.00','1','1054.24','0.00','دكتور عباس حلة ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-14 15:17:59','2024-07-14 15:17:59',NULL,'1','Add New Invoice','1'),
('4260','VR-24-4260','2024-07-14 00:00:00','0','1250.00','1','247.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-14 15:20:34','2024-07-14 15:20:34',NULL,'1','Add New Invoice','1'),
('4261','VR-24-4261','2024-07-14 00:00:00','0','1250.00','1','1439.99','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-14 15:23:02','2024-07-14 15:23:02',NULL,'1','Add New Invoice','1'),
('4262','VR-24-4262','2024-07-14 00:00:00','0','1250.00','1','153.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-07-14 15:49:50','2024-07-14 15:49:50',NULL,'1','Add New Invoice','1'),
('4263','VR-24-4263','2024-07-15 00:00:00','0','1250.00','1','2389.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-07-15 11:34:02','2024-07-17 10:08:24',NULL,'1','Update Invoice','1'),
('4264','VR-24-4264','2024-07-15 00:00:00','0','1250.00','1','40.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-15 13:05:32','2024-07-15 13:05:32',NULL,'1','Add New Invoice','1'),
('4265','VR-24-4265','2024-07-15 00:00:00','0','1250.00','1','9751.94','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-15 15:20:15','2024-07-15 15:20:15',NULL,'1','Add New Invoice','1'),
('4266','VR-24-4266','2024-07-15 00:00:00','0','1250.00','1','132.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-07-15 15:31:02','2024-07-15 15:31:02',NULL,'1','Add New Invoice','1'),
('4267','VR-24-4267','2024-07-15 00:00:00','0','1250.00','1','74.82','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-15 15:32:19','2024-07-15 15:32:19',NULL,'1','Add New Invoice','1'),
('4268','VR-24-4268','2024-07-15 00:00:00','0','1250.00','1','162.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-15 15:39:41','2024-07-15 15:39:41',NULL,'1','Add New Invoice','1'),
('4269','VR-24-4269','2024-07-15 00:00:00','0','1250.00','1','17.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-07-15 15:50:18','2024-07-15 15:50:18',NULL,'1','Add New Invoice','1'),
('4270','VR-24-4270','2024-07-15 00:00:00','0','1250.00','1','12.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-15 15:51:29','2024-07-15 15:51:29',NULL,'1','Add New Invoice','1'),
('4271','VR-24-4271','2024-07-16 00:00:00','0','1250.00','1','290.83','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-16 12:18:44','2024-07-16 12:18:44',NULL,'1','Add New Invoice','1'),
('4272','VR-24-4272','2024-07-16 00:00:00','0','1250.00','1','338.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-16 16:22:57','2024-07-16 16:22:57',NULL,'1','Add New Invoice','1'),
('4273','VR-24-4273','2024-07-17 00:00:00','0','1250.00','1','176.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-07-17 10:03:48','2024-07-18 10:50:12',NULL,'1','Update Invoice','1'),
('4274','VR-24-4274','2024-07-17 00:00:00','0','1250.00','1','81.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-17 14:37:58','2024-07-17 14:37:58',NULL,'1','Add New Invoice','1'),
('4275','VR-24-4275','2024-07-17 00:00:00','0','1250.00','1','121.04','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-17 15:04:40','2024-07-18 10:06:52',NULL,'1','Update Invoice','1'),
('4276','VR-24-4276','2024-07-17 00:00:00','0','1250.00','1','154.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-17 15:16:04','2024-07-17 15:16:04',NULL,'1','Add New Invoice','1'),
('4277','VR-24-4277','2024-07-17 00:00:00','0','1250.00','1','478.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-07-17 16:26:04','2024-07-17 16:26:04',NULL,'1','Add New Invoice','1'),
('4278','VR-24-4278','2024-07-17 00:00:00','0','1250.00','1','156.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','105','0','2024-07-17 16:27:55','2024-07-17 16:27:55',NULL,'1','Add New Invoice','1'),
('4279','VR-24-4279','2024-07-17 00:00:00','0','1250.00','1','183.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-17 17:10:42','2024-07-17 17:10:42',NULL,'1','Add New Invoice','1'),
('4280','VR-24-4280','2024-07-18 00:00:00','0','1250.00','1','514.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-18 14:44:33','2024-07-18 14:44:33',NULL,'1','Add New Invoice','1'),
('4281','VR-24-4281','2024-07-18 00:00:00','0','1250.00','1','4325.08','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-18 16:35:30','2024-07-18 16:35:30',NULL,'1','Add New Invoice','1'),
('4282','VR-24-4282','2024-07-18 00:00:00','0','1250.00','1','312.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-07-18 16:46:52','2024-07-18 16:46:52',NULL,'1','Add New Invoice','1'),
('4283','VR-24-4283','2024-07-18 00:00:00','0','1250.00','1','49.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-07-18 16:47:47','2024-07-18 16:47:47',NULL,'1','Add New Invoice','1'),
('4284','VR-24-4284','2024-07-18 00:00:00','0','1250.00','1','439.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-07-18 16:49:01','2024-07-18 04:50:00',NULL,'1','Update Invoice','1'),
('4285','VR-24-4285','2024-07-18 00:00:00','0','1250.00','1','101.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-18 17:05:53','2024-07-18 05:12:36',NULL,'1','Update Invoice','1'),
('4286','VR-24-4286','2024-07-18 00:00:00','0','1250.00','1','319.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-18 17:10:14','2024-07-18 17:10:14',NULL,'1','Add New Invoice','1'),
('4287','VR-24-4287','2024-07-18 00:00:00','0','1250.00','1','284.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-18 17:11:53','2024-07-18 17:11:53',NULL,'1','Add New Invoice','1'),
('4288','VR-24-4288','2024-07-18 00:00:00','0','1250.00','1','228.69','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-18 17:13:56','2024-07-18 17:13:56',NULL,'1','Add New Invoice','1'),
('4289','VR-24-4289','2024-07-18 00:00:00','0','1250.00','1','30.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-07-18 17:17:42','2024-07-18 17:17:42',NULL,'1','Add New Invoice','1'),
('4290','VR-24-4290','2024-07-20 00:00:00','0','1250.00','1','836.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','95','0','2024-07-20 12:38:26','2024-07-20 12:38:26',NULL,'1','Add New Invoice','1'),
('4291','VR-24-4291','2024-07-20 00:00:00','0','1250.00','1','147.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-20 13:58:37','2024-07-20 13:58:37',NULL,'1','Add New Invoice','1'),
('4292','VR-24-4292','2024-07-20 00:00:00','0','1250.00','1','250.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-07-20 15:27:53','2024-07-20 15:27:53',NULL,'1','Add New Invoice','1'),
('4293','VR-24-4293','2024-07-20 00:00:00','0','1250.00','1','135.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-07-20 15:30:14','2024-07-20 15:30:14',NULL,'1','Add New Invoice','1'),
('4294','VR-24-4294','2024-07-20 00:00:00','0','1250.00','1','373.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-20 15:37:40','2024-07-20 15:37:40',NULL,'1','Add New Invoice','1'),
('4295','VR-24-4295','2024-07-21 00:00:00','0','1250.00','1','1186.15','0.00','محمود ستائر القمر ','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-21 11:42:45','2024-08-18 03:08:53',NULL,'1','Update Invoice','1'),
('4296','VR-24-4296','2024-07-23 00:00:00','0','1250.00','1','143.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-23 09:36:05','2024-07-23 09:36:05',NULL,'1','Add New Invoice','1'),
('4297','VR-24-4297','2024-07-23 00:00:00','0','1250.00','1','366.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-23 09:40:39','2024-07-23 09:40:39',NULL,'1','Add New Invoice','1'),
('4298','VR-24-4298','2024-07-23 00:00:00','0','1250.00','1','530.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-23 09:47:40','2024-07-23 09:47:40',NULL,'1','Add New Invoice','1'),
('4299','VR-24-4299','2024-07-23 00:00:00','0','1250.00','1','76.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-07-23 09:49:50','2024-07-23 09:49:50',NULL,'1','Add New Invoice','1'),
('4300','VR-24-4300','2024-07-23 00:00:00','0','1250.00','1','2850.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-07-23 10:13:55','2025-08-07 05:18:28',NULL,'1','Update Invoice','1'),
('4301','VR-24-4301','2024-07-23 00:00:00','0','1250.00','1','293.33','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','128','0','2024-07-23 10:30:12','2024-07-23 10:30:12',NULL,'1','Add New Invoice','1'),
('4302','VR-24-4302','2024-07-23 00:00:00','0','1250.00','1','40.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-07-23 10:34:49','2024-07-23 10:34:49',NULL,'1','Add New Invoice','1'),
('4303','VR-24-4303','2024-07-23 00:00:00','0','1250.00','1','56.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-07-23 10:53:41','2024-07-23 10:53:41',NULL,'1','Add New Invoice','1'),
('4304','INV-24-4304','2024-07-23 00:00:00','0','1250.00','1','199.22','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-07-23 01:29:04','2024-07-23 01:29:04',NULL,'1','Add New Invoice','1'),
('4305','VR-24-4305','2024-07-23 00:00:00','0','1250.00','1','170.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-23 14:30:16','2024-07-23 14:30:16',NULL,'1','Add New Invoice','1'),
('4306','VR-24-4306','2024-07-23 00:00:00','0','1250.00','1','366.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-07-23 15:55:02','2024-07-23 15:55:02',NULL,'1','Add New Invoice','1'),
('4307','VR-24-4307','2024-07-24 00:00:00','0','1250.00','1','148.43','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-07-24 13:24:41','2024-08-05 04:27:01',NULL,'1','Update Invoice','1'),
('4308','VR-24-4308','2024-07-24 00:00:00','0','1250.00','1','49.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-07-24 13:31:09','2024-07-24 13:31:09',NULL,'1','Add New Invoice','1'),
('4309','VR-24-4309','2024-07-24 00:00:00','0','1250.00','1','126.00','0.00','محمود ستائر القمر \n','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-24 13:47:08','2024-08-18 03:09:39',NULL,'1','Update Invoice','1'),
('4310','VR-24-4310','2024-07-24 00:00:00','0','1250.00','1','190.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-07-24 14:36:04','2024-07-24 14:36:04',NULL,'1','Add New Invoice','1'),
('4311','VR-24-4311','2024-07-24 00:00:00','0','1250.00','1','263.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-24 14:38:32','2024-07-24 14:38:32',NULL,'1','Add New Invoice','1'),
('4312','VR-24-4312','2024-07-24 00:00:00','0','1250.00','1','3874.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-07-24 16:56:59','2024-07-28 12:41:14',NULL,'1','Update Invoice','1'),
('4313','VR-24-4313','2024-07-24 00:00:00','0','1250.00','1','115.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-07-24 17:08:12','2024-07-24 17:08:12',NULL,'1','Add New Invoice','1'),
('4314','VR-24-4314','2024-07-25 00:00:00','0','1250.00','1','180.09','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-25 13:54:14','2024-08-03 10:16:43',NULL,'1','Update Invoice','1'),
('4315','VR-24-4315','2024-07-27 00:00:00','0','1250.00','1','218.13','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-27 13:14:59','2024-07-27 13:14:59',NULL,'1','Add New Invoice','1'),
('4316','VR-24-4316','2024-07-27 00:00:00','0','1250.00','1','277.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-07-27 13:15:52','2024-07-27 13:15:52',NULL,'1','Add New Invoice','1'),
('4317','VR-24-4317','2024-07-27 00:00:00','0','1250.00','1','1320.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-07-27 15:09:54','2024-07-27 15:09:54',NULL,'1','Add New Invoice','1'),
('4318','VR-24-4318','2024-07-28 00:00:00','0','1250.00','1','115.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-28 13:42:46','2024-08-03 10:04:19',NULL,'1','Update Invoice','1'),
('4319','VR-24-4319','2024-07-29 00:00:00','0','1250.00','1','129.96','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-29 13:21:57','2024-07-29 13:21:57',NULL,'1','Add New Invoice','1'),
('4320','VR-24-4320','2024-07-29 00:00:00','0','1250.00','1','285.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-29 14:10:24','2024-07-29 14:10:24',NULL,'1','Add New Invoice','1'),
('4321','VR-24-4321','2024-07-30 00:00:00','0','1250.00','1','102.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-07-30 13:01:39','2024-07-30 13:01:39',NULL,'1','Add New Invoice','1'),
('4322','VR-24-4322','2024-07-30 00:00:00','0','1250.00','1','177.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-07-30 13:21:41','2024-07-30 13:21:41',NULL,'1','Add New Invoice','1'),
('4323','VR-24-4323','2024-07-30 00:00:00','0','1250.00','1','441.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-07-30 13:26:50','2024-07-30 13:26:50',NULL,'1','Add New Invoice','1'),
('4324','VR-24-4324','2024-07-30 00:00:00','0','1250.00','1','114.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','26','0','2024-07-30 13:29:56','2024-07-30 13:29:56',NULL,'1','Add New Invoice','1'),
('4325','VR-24-4325','2024-07-30 00:00:00','0','1250.00','1','52.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-30 13:55:07','2024-07-30 13:55:07',NULL,'1','Add New Invoice','1'),
('4326','VR-24-4326','2024-07-30 00:00:00','0','1250.00','1','536.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','125','0','2024-07-30 17:13:31','2024-07-30 17:13:31',NULL,'1','Add New Invoice','1'),
('4327','INV-24-4327','2024-07-30 00:00:00','0','1250.00','1','204.60','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-07-30 05:17:53','2024-07-31 10:20:55',NULL,'1','Update Invoice','1'),
('4328','VR-24-4328','2024-07-31 00:00:00','0','1250.00','1','306.57','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-07-31 14:59:36','2024-08-03 10:17:49',NULL,'1','Update Invoice','1'),
('4329','INV-24-4329','2024-07-31 00:00:00','0','1250.00','1','184.44','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-07-31 04:32:30','2024-07-31 04:32:30',NULL,'1','Add New Invoice','1'),
('4330','VR-24-4330','2024-08-01 00:00:00','0','1250.00','1','263.39','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-01 13:22:29','2024-08-01 13:22:29',NULL,'1','Add New Invoice','1'),
('4331','VR-24-4331','2024-08-01 00:00:00','0','1250.00','1','670.45','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-08-01 15:30:21','2024-08-01 15:30:21',NULL,'1','Add New Invoice','1'),
('4332','VR-24-4332','2024-08-01 00:00:00','0','1250.00','1','128.15','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-01 16:19:41','2024-08-01 16:19:41',NULL,'1','Add New Invoice','1'),
('4333','VR-24-4333','2024-08-01 00:00:00','0','1250.00','1','248.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-01 16:25:04','2024-08-01 16:25:04',NULL,'1','Add New Invoice','1'),
('4334','VR-24-4334','2024-08-01 00:00:00','0','1250.00','1','285.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-01 16:44:51','2024-08-01 16:44:51',NULL,'1','Add New Invoice','1'),
('4335','VR-24-4335','2024-08-01 00:00:00','0','1250.00','1','3271.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-01 16:50:10','2024-08-03 10:59:53',NULL,'1','Update Invoice','1'),
('4336','VR-24-4336','2024-08-01 00:00:00','0','1250.00','1','723.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-08-01 17:17:02','2024-08-01 17:17:02',NULL,'1','Add New Invoice','1'),
('4337','VR-24-4337','2024-08-01 00:00:00','0','1250.00','1','97.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-08-01 17:19:31','2024-08-01 17:19:31',NULL,'1','Add New Invoice','1'),
('4338','VR-24-4338','2024-08-01 00:00:00','0','1250.00','1','11.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-01 17:30:19','2024-08-01 17:30:19',NULL,'1','Add New Invoice','1'),
('4339','INV-24-4339','2024-08-01 00:00:00','0','1250.00','1','28.08','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','126','0','2024-08-01 05:37:19','2024-08-01 05:37:19',NULL,'1','Add New Invoice','1'),
('4340','VR-24-4340','2024-08-03 00:00:00','0','1250.00','1','7140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','93','0','2024-08-03 10:55:21','2024-08-03 10:55:21',NULL,'1','Add New Invoice','1'),
('4341','INV-24-4341','2024-08-04 00:00:00','0','1250.00','1','73.50','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-04 08:51:28','2024-08-04 08:51:28',NULL,'1','Add New Invoice','1'),
('4342','VR-24-4342','2024-08-04 00:00:00','0','1250.00','1','139.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-04 09:42:21','2024-08-04 09:42:21',NULL,'1','Add New Invoice','1'),
('4343','VR-24-4343','2024-08-04 00:00:00','0','1250.00','1','184.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-08-04 10:06:25','2024-08-04 10:06:25',NULL,'1','Add New Invoice','1'),
('4344','VR-24-4344','2024-08-04 00:00:00','0','1250.00','1','132.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-04 10:09:41','2024-08-04 10:09:41',NULL,'1','Add New Invoice','1'),
('4345','VR-24-4345','2024-08-04 00:00:00','0','1250.00','1','81.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-04 10:11:30','2024-08-04 10:11:30',NULL,'1','Add New Invoice','1'),
('4346','VR-24-4346','2024-08-04 00:00:00','0','1250.00','1','271.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','88','0','2024-08-04 13:09:35','2024-08-04 13:09:35',NULL,'1','Add New Invoice','1'),
('4347','VR-24-4347','2024-08-04 00:00:00','0','1250.00','1','885.65','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-08-04 14:25:21','2024-08-04 02:30:24',NULL,'1','Update Invoice','1'),
('4348','VR-24-4348','2024-08-04 00:00:00','0','1250.00','1','100.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-08-04 15:25:36','2024-08-04 15:25:36',NULL,'1','Add New Invoice','1'),
('4349','VR-24-4349','2024-08-04 00:00:00','0','1250.00','1','306.74','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-04 15:31:23','2024-08-04 15:31:23',NULL,'1','Add New Invoice','1'),
('4350','VR-24-4350','2024-08-04 00:00:00','0','1250.00','1','1000.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','129','1','2024-08-04 15:46:43','2024-08-04 15:46:43','2024-08-06 11:02:40','1','Delete Invoice','1'),
('4351','VR-24-4351','2024-08-04 00:00:00','0','1250.00','1','333.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-04 16:44:21','2024-08-04 16:44:21',NULL,'1','Add New Invoice','1'),
('4352','INV-24-4352','2024-08-04 00:00:00','0','1250.00','1','512.40','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-08-04 05:08:11','2024-08-04 05:08:11',NULL,'1','Add New Invoice','1'),
('4353','VR-24-4353','2024-08-04 00:00:00','0','1250.00','1','1188.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-08-04 17:30:12','2025-08-07 05:18:54',NULL,'1','Update Invoice','1'),
('4354','VR-24-4354','2024-08-04 00:00:00','0','1250.00','1','234.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-08-04 17:34:12','2024-08-04 17:34:12',NULL,'1','Add New Invoice','1'),
('4355','VR-24-4355','2024-08-04 00:00:00','0','1250.00','1','85.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','130','0','2024-08-04 17:37:10','2024-08-04 17:37:10',NULL,'1','Add New Invoice','1'),
('4356','VR-24-4356','2024-08-04 00:00:00','0','1250.00','1','68.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-08-04 17:38:01','2024-08-04 17:38:01',NULL,'1','Add New Invoice','1'),
('4357','VR-24-4357','2024-08-04 00:00:00','0','1250.00','1','115.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-08-04 17:50:11','2024-08-04 17:50:11',NULL,'1','Add New Invoice','1'),
('4358','VR-24-4358','2024-08-04 00:00:00','0','1250.00','1','22.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-04 17:50:57','2024-08-04 17:50:57',NULL,'1','Add New Invoice','1'),
('4359','VR-24-4359','2024-08-04 00:00:00','0','1250.00','1','181.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-08-04 17:53:25','2024-08-04 17:53:25',NULL,'1','Add New Invoice','1'),
('4360','VR-24-4360','2024-08-04 00:00:00','0','1250.00','1','175.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-08-04 17:55:14','2024-08-04 17:55:14',NULL,'1','Add New Invoice','1'),
('4361','VR-24-4361','2024-08-04 00:00:00','0','1250.00','1','100.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','91','0','2024-08-04 17:58:35','2024-08-04 17:58:35',NULL,'1','Add New Invoice','1'),
('4362','VR-24-4362','2024-08-04 00:00:00','0','1250.00','1','125.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-08-04 18:01:10','2024-08-04 18:01:10',NULL,'1','Add New Invoice','1'),
('4363','VR-24-4363','2024-08-04 00:00:00','0','1250.00','1','52.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-08-04 18:01:59','2024-08-04 18:01:59',NULL,'1','Add New Invoice','1'),
('4364','VR-24-4364','2024-08-04 00:00:00','0','1250.00','1','304.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-08-04 18:06:16','2024-08-04 18:06:16',NULL,'1','Add New Invoice','1'),
('4365','VR-24-4365','2024-08-05 00:00:00','0','1250.00','1','179.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-05 14:10:12','2024-08-07 11:45:39',NULL,'1','Update Invoice','1'),
('4366','VR-24-4366','2024-08-06 00:00:00','0','1250.00','1','10.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','99','0','2024-08-06 10:20:23','2024-08-06 10:20:23',NULL,'1','Add New Invoice','1'),
('4367','VR-24-4367','2024-08-06 00:00:00','0','1250.00','1','1000.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-08-06 11:03:36','2024-08-06 11:03:36',NULL,'1','Add New Invoice','1'),
('4368','VR-24-4368','2024-08-06 00:00:00','0','1250.00','1','481.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','7','0','2024-08-06 11:04:48','2024-08-06 11:04:48',NULL,'1','Add New Invoice','1'),
('4369','VR-24-4369','2024-08-06 00:00:00','0','1250.00','1','6824.69','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','85','0','2024-08-06 12:39:48','2024-08-06 12:39:48',NULL,'1','Add New Invoice','1'),
('4370','VR-24-4370','2024-08-06 00:00:00','0','1250.00','1','4094.16','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','131','0','2024-08-06 15:59:27','2024-08-06 15:59:27',NULL,'1','Add New Invoice','1'),
('4371','VR-24-4371','2024-08-07 00:00:00','0','1250.00','1','141.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-07 13:43:16','2024-08-07 13:43:16',NULL,'1','Add New Invoice','1'),
('4372','VR-24-4372','2024-08-07 00:00:00','0','1250.00','1','8641.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-08-07 14:42:04','2024-08-12 02:42:14',NULL,'1','Update Invoice','1'),
('4373','VR-24-4373','2024-08-07 00:00:00','0','1250.00','1','148.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','76','0','2024-08-07 15:06:59','2024-08-07 15:06:59',NULL,'1','Add New Invoice','1'),
('4374','VR-24-4374','2024-08-07 00:00:00','0','1250.00','1','273.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-07 15:11:06','2024-08-08 09:26:18',NULL,'1','Update Invoice','1'),
('4375','VR-24-4375','2024-08-07 00:00:00','0','1250.00','1','243.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-08-07 15:30:21','2024-08-07 15:30:21',NULL,'1','Add New Invoice','1'),
('4376','VR-24-4376','2024-08-07 00:00:00','0','1250.00','1','120.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','125','0','2024-08-07 16:06:32','2024-08-07 16:06:32',NULL,'1','Add New Invoice','1'),
('4377','VR-24-4377','2024-08-07 00:00:00','0','1250.00','1','52.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-08-07 16:08:20','2024-08-07 16:08:20',NULL,'1','Add New Invoice','1'),
('4378','VR-24-4378','2024-08-07 00:00:00','0','1250.00','1','1715.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','132','0','2024-08-07 17:12:18','2024-08-07 17:12:18',NULL,'1','Add New Invoice','1'),
('4379','VR-24-4379','2024-08-07 00:00:00','0','1250.00','1','4878.72','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','133','0','2024-08-07 17:25:37','2024-08-07 17:25:37',NULL,'1','Add New Invoice','1'),
('4380','VR-24-4380','2024-08-08 00:00:00','0','1250.00','1','122.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-08 13:07:55','2024-08-08 13:07:55',NULL,'1','Add New Invoice','1'),
('4381','VR-24-4381','2024-08-08 00:00:00','0','1250.00','1','281.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-08 15:08:33','2024-08-08 04:00:55',NULL,'1','Update Invoice','1'),
('4382','VR-24-4382','2024-08-08 00:00:00','0','1250.00','1','378.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','13','0','2024-08-08 15:19:07','2024-08-08 15:19:07',NULL,'1','Add New Invoice','1'),
('4383','VR-24-4383','2024-08-08 00:00:00','0','1250.00','1','292.88','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-08-08 15:26:12','2024-08-08 15:26:12',NULL,'1','Add New Invoice','1'),
('4384','VR-24-4384','2024-08-08 00:00:00','0','1250.00','1','47.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-08-08 16:49:06','2024-08-08 16:49:06',NULL,'1','Add New Invoice','1'),
('4385','VR-24-4385','2024-08-08 00:00:00','0','1250.00','1','186.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-08-08 16:51:38','2024-08-08 16:51:38',NULL,'1','Add New Invoice','1'),
('4386','VR-24-4386','2024-08-08 00:00:00','0','1250.00','1','54.02','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-08-08 16:52:47','2024-08-08 16:52:47',NULL,'1','Add New Invoice','1'),
('4387','VR-24-4387','2024-08-08 00:00:00','0','1250.00','1','72.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-08 16:56:04','2024-08-08 16:56:04',NULL,'1','Add New Invoice','1'),
('4388','VR-24-4388','2024-08-10 00:00:00','0','1250.00','1','921.79','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-10 14:29:51','2024-08-10 14:29:51',NULL,'1','Add New Invoice','1'),
('4389','VR-24-4389','2024-08-10 00:00:00','0','1250.00','1','58.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-10 15:43:43','2024-08-10 15:43:43',NULL,'1','Add New Invoice','1'),
('4390','VR-24-4390','2024-08-10 00:00:00','0','1250.00','1','471.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-10 15:57:39','2024-08-10 03:58:38',NULL,'1','Update Invoice','1'),
('4391','VR-24-4391','2024-08-10 00:00:00','0','1250.00','1','404.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-08-10 16:27:18','2024-08-10 16:27:18',NULL,'1','Add New Invoice','1'),
('4392','VR-24-4392','2024-08-10 00:00:00','0','1250.00','1','159.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-08-10 16:29:16','2024-08-10 16:29:16',NULL,'1','Add New Invoice','1'),
('4393','VR-24-4393','2024-08-10 00:00:00','0','1250.00','1','1644.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-08-10 16:41:46','2024-08-10 16:41:46',NULL,'1','Add New Invoice','1'),
('4394','VR-24-4394','2024-08-10 00:00:00','0','1250.00','1','134.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-08-10 16:45:45','2024-08-10 16:45:45',NULL,'1','Add New Invoice','1'),
('4395','VR-24-4395','2024-08-11 00:00:00','0','1250.00','1','341.51','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-11 15:55:14','2024-08-11 15:55:14',NULL,'1','Add New Invoice','1'),
('4396','VR-24-4396','2024-08-12 00:00:00','0','1250.00','1','3579.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-08-12 14:40:39','2024-08-12 14:40:39',NULL,'1','Add New Invoice','1'),
('4400','VR-24-4397','2024-08-13 00:00:00','0','1250.00','1','13738.86','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-13 15:41:15','2024-08-13 15:41:15',NULL,'1','Add New Invoice','1'),
('4409','VR-24-4401','2024-08-13 00:00:00','0','1250.00','1','6018.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-13 17:02:57','2024-08-13 17:02:57',NULL,'1','Add New Invoice','1'),
('4410','VR-24-4410','2024-08-13 00:00:00','0','1250.00','1','5180.62','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-13 17:18:37','2024-08-13 17:18:37',NULL,'1','Add New Invoice','1'),
('4411','VR-24-4411','2024-08-14 00:00:00','0','1250.00','1','6123.75','0.00','ابو محمد','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2024-08-14 14:06:01','2024-08-14 14:06:01',NULL,'1','Add New Invoice','1'),
('4412','VR-24-4412','2024-08-14 00:00:00','0','1250.00','1','9419.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-08-14 15:06:15','2024-08-14 15:06:15',NULL,'1','Add New Invoice','1'),
('4413','VR-24-4413','2024-08-14 00:00:00','0','1250.00','1','8911.98','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-08-14 16:13:32','2024-09-22 04:30:56',NULL,'1','Update Invoice','1'),
('4414','VR-24-4414','2024-08-14 00:00:00','0','1250.00','1','345.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','110','0','2024-08-14 16:41:19','2024-08-14 16:41:19',NULL,'1','Add New Invoice','1'),
('4415','VR-24-4415','2024-08-14 00:00:00','0','1250.00','1','364.93','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','104','0','2024-08-14 17:09:46','2024-08-14 17:09:46',NULL,'1','Add New Invoice','1'),
('4416','VR-24-4416','2024-08-15 00:00:00','0','1250.00','1','513.35','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-15 10:15:27','2024-08-15 10:15:27',NULL,'1','Add New Invoice','1'),
('4417','VR-24-4417','2024-08-15 00:00:00','0','1250.00','1','860.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-08-15 11:40:01','2024-08-15 11:40:01',NULL,'1','Add New Invoice','1'),
('4418','VR-24-4418','2024-08-15 00:00:00','0','1250.00','1','26.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-08-15 12:12:58','2024-08-15 12:12:58',NULL,'1','Add New Invoice','1'),
('4419','VR-24-4419','2024-08-17 00:00:00','0','1250.00','1','156.42','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-17 10:27:19','2024-08-17 10:27:19',NULL,'1','Add New Invoice','1'),
('4420','VR-24-4420','2024-08-17 00:00:00','0','1250.00','1','141.48','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-08-17 11:32:08','2024-08-17 11:35:22',NULL,'1','Update Invoice','1'),
('4421','VR-24-4421','2024-08-17 00:00:00','0','1250.00','1','1328.47','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-17 11:37:12','2024-08-20 11:33:08',NULL,'1','Update Invoice','1'),
('4422','VR-24-4422','2024-08-17 00:00:00','0','1250.00','1','18.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-17 11:48:40','2024-08-17 11:48:40',NULL,'1','Add New Invoice','1'),
('4423','VR-24-4423','2024-08-17 00:00:00','0','1250.00','1','49.28','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-08-17 11:50:02','2024-08-17 01:48:23',NULL,'1','Update Invoice','1'),
('4424','VR-24-4424','2024-08-17 00:00:00','0','1250.00','1','189.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','87','0','2024-08-17 11:51:32','2024-08-17 11:51:32',NULL,'1','Add New Invoice','1'),
('4425','VR-24-4425','2024-08-17 00:00:00','0','1250.00','1','403.20','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-17 13:16:10','2024-08-17 13:16:10',NULL,'1','Add New Invoice','1'),
('4426','VR-24-4426','2024-08-17 00:00:00','0','1250.00','1','307.84','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-08-17 13:47:36','2024-08-17 13:47:36',NULL,'1','Add New Invoice','1'),
('4427','VR-24-4427','2024-08-17 00:00:00','0','1250.00','1','107.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','10','0','2024-08-17 17:00:12','2024-08-17 17:00:12',NULL,'1','Add New Invoice','1'),
('4428','VR-24-4428','2024-08-18 00:00:00','0','1250.00','1','908.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-08-18 11:06:25','2024-08-18 04:57:33',NULL,'1','Update Invoice','1'),
('4429','VR-24-4429','2024-08-18 00:00:00','0','1250.00','1','33.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','89','0','2024-08-18 11:40:34','2024-08-18 11:40:34',NULL,'1','Add New Invoice','1'),
('4430','VR-24-4430','2024-08-18 00:00:00','0','1250.00','1','187.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-08-18 11:44:27','2024-08-18 11:44:27',NULL,'1','Add New Invoice','1'),
('4431','VR-24-4431','2024-08-18 00:00:00','0','1250.00','1','135.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','11','0','2024-08-18 12:54:47','2024-08-18 12:54:47',NULL,'1','Add New Invoice','1'),
('4432','VR-24-4432','2024-08-18 00:00:00','0','1250.00','1','237.05','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-18 14:56:55','2024-08-18 14:56:55',NULL,'1','Add New Invoice','1'),
('4433','VR-24-4433','2024-08-18 00:00:00','0','1250.00','1','14.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-08-18 15:02:17','2024-08-18 15:02:17',NULL,'1','Add New Invoice','1'),
('4434','VR-24-4434','2024-08-18 00:00:00','0','1250.00','1','29.70','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','16','0','2024-08-18 15:14:57','2024-08-18 15:14:57',NULL,'1','Add New Invoice','1'),
('4435','VR-24-4435','2024-08-18 00:00:00','0','1250.00','1','143.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-18 15:16:41','2024-08-18 04:14:13',NULL,'1','Update Invoice','1'),
('4436','VR-24-4436','2024-08-18 00:00:00','0','1250.00','1','648.63','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-18 16:09:03','2024-08-19 04:15:56',NULL,'1','Update Invoice','1'),
('4437','VR-24-4437','2024-08-19 00:00:00','0','1250.00','1','688.53','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','1','2024-08-19 15:42:14','2024-08-20 03:27:31','2024-08-24 11:59:20','1','Delete Invoice','1'),
('4438','VR-24-4438','2024-08-19 00:00:00','0','1250.00','1','510.55','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-19 15:52:51','2024-08-20 09:52:45',NULL,'1','Update Invoice','1'),
('4439','VR-24-4439','2024-08-19 00:00:00','0','1250.00','1','48.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','14','0','2024-08-19 15:58:17','2024-08-19 15:58:17',NULL,'1','Add New Invoice','1'),
('4440','VR-24-4440','2024-08-19 00:00:00','0','1250.00','1','225.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-19 16:57:10','2024-08-19 16:57:10',NULL,'1','Add New Invoice','1'),
('4441','VR-24-4441','2024-08-19 00:00:00','0','1250.00','1','52.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-19 16:59:34','2024-08-19 16:59:34',NULL,'1','Add New Invoice','1'),
('4442','VR-24-4442','2024-08-20 00:00:00','0','1250.00','1','120.17','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-20 13:02:44','2024-08-20 13:02:44',NULL,'1','Add New Invoice','1'),
('4443','VR-24-4443','2024-08-20 00:00:00','0','1250.00','1','143.40','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','21','0','2024-08-20 15:28:38','2024-08-20 15:28:38',NULL,'1','Add New Invoice','1'),
('4444','VR-24-4444','2024-08-20 00:00:00','0','1250.00','1','294.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-20 15:30:47','2024-08-21 04:22:59',NULL,'1','Update Invoice','1'),
('4445','VR-24-4445','2024-08-21 00:00:00','0','1250.00','1','78.30','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-21 13:27:09','2024-08-21 13:27:09',NULL,'1','Add New Invoice','1'),
('4446','VR-24-4446','2024-08-21 00:00:00','0','1250.00','1','136.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-21 13:30:10','2024-08-21 13:30:10',NULL,'1','Add New Invoice','1'),
('4447','VR-24-4447','2024-08-21 00:00:00','0','1250.00','1','144.95','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','15','0','2024-08-21 13:33:49','2024-08-21 01:36:45',NULL,'1','Update Invoice','1'),
('4448','VR-24-4448','2024-08-21 00:00:00','0','1250.00','1','182.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','23','0','2024-08-21 13:34:50','2024-08-22 01:42:01',NULL,'1','Update Invoice','1'),
('4449','VR-24-4449','2024-08-21 00:00:00','0','1250.00','1','145.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-21 13:35:41','2024-08-21 13:35:41',NULL,'1','Add New Invoice','1'),
('4450','VR-24-4450','2024-08-21 00:00:00','0','1250.00','1','105.60','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-21 13:53:20','2024-08-21 13:53:20',NULL,'1','Add New Invoice','1'),
('4451','VR-24-4451','2024-08-22 00:00:00','0','1250.00','1','87.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','6','0','2024-08-22 12:39:11','2024-08-22 12:39:11',NULL,'1','Add New Invoice','1'),
('4452','VR-24-4452','2024-08-22 00:00:00','0','1250.00','1','38.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-22 13:55:46','2024-08-22 13:55:46',NULL,'1','Add New Invoice','1'),
('4453','VR-24-4453','2024-08-22 00:00:00','0','1250.00','1','352.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','12','0','2024-08-22 14:00:38','2024-08-22 14:00:38',NULL,'1','Add New Invoice','1'),
('4454','VR-24-4454','2024-08-24 00:00:00','0','1250.00','1','140.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','125','0','2024-08-24 09:12:37','2024-08-24 09:12:37',NULL,'1','Add New Invoice','1'),
('4455','VR-24-4455','2024-08-24 00:00:00','0','1250.00','1','144.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','125','0','2024-08-24 09:15:52','2024-08-24 09:15:52',NULL,'1','Add New Invoice','1'),
('4456','VR-24-4456','2024-08-24 00:00:00','0','1250.00','1','83.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','118','0','2024-08-24 14:30:30','2024-08-24 14:30:30',NULL,'1','Add New Invoice','1'),
('4457','VR-24-4457','2024-08-24 00:00:00','0','1250.00','1','1191.87','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','120','0','2024-08-24 16:16:24','2024-08-24 16:16:24',NULL,'1','Add New Invoice','1'),
('4458','VR-24-4458','2024-08-24 00:00:00','0','1250.00','1','185.80','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-24 16:53:33','2024-08-24 16:53:33',NULL,'1','Add New Invoice','1'),
('4459','VR-24-4459','2024-08-24 00:00:00','0','1250.00','1','162.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','114','0','2024-08-24 16:56:54','2024-08-24 16:56:54',NULL,'1','Add New Invoice','1'),
('4460','VR-24-4460','2024-08-24 00:00:00','0','1250.00','1','73.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','19','0','2024-08-24 16:58:11','2024-08-24 16:58:11',NULL,'1','Add New Invoice','1'),
('4461','VR-24-4461','2024-08-25 00:00:00','0','1250.00','1','109.10','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-08-25 14:30:59','2024-08-25 14:30:59',NULL,'1','Add New Invoice','1'),
('4462','VR-24-4462','2024-08-25 00:00:00','0','1250.00','1','894.64','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','22','0','2024-08-25 15:40:18','2024-08-25 15:40:18',NULL,'1','Add New Invoice','1'),
('4463','VR-24-4463','2024-08-25 00:00:00','0','1250.00','1','239.78','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','17','0','2024-08-25 15:45:49','2024-08-25 15:45:49',NULL,'1','Add New Invoice','1'),
('4464','VR-24-4464','2024-08-25 00:00:00','0','1250.00','1','72.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','115','0','2024-08-25 16:19:19','2024-08-25 16:19:19',NULL,'1','Add New Invoice','1'),
('4465','VR-24-4465','2024-08-25 00:00:00','0','1250.00','1','48.75','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','18','0','2024-08-25 16:20:06','2024-08-25 16:20:06',NULL,'1','Add New Invoice','1'),
('4466','VR-24-4466','2024-08-25 00:00:00','0','1250.00','1','13.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','5','0','2024-08-25 16:23:11','2024-08-25 16:23:11',NULL,'1','Add New Invoice','1'),
('4467','INV-24-4467','2024-08-25 00:00:00','0','1250.00','1','70.20','0.00','','1','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','86','0','2024-08-25 04:24:48','2024-08-25 04:24:48',NULL,'1','Add New Invoice','1'),
('4468','VR-24-4468','2024-08-26 00:00:00','0','1250.00','1','271.90','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','8','0','2024-08-26 12:22:08','2024-08-26 12:22:08',NULL,'1','Add New Invoice','1'),
('4469','VR-24-4469','2024-08-26 00:00:00','0','1250.00','1','112.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','102','0','2024-08-26 14:51:52','2024-08-26 14:51:52',NULL,'1','Add New Invoice','1'),
('4470','VR-24-4470','2024-08-26 00:00:00','0','1250.00','1','274.50','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','94','0','2024-08-26 14:53:19','2024-08-26 03:22:06',NULL,'1','Update Invoice','1'),
('4471','VR-24-4471','2024-08-26 00:00:00','0','1250.00','1','330.00','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','121','0','2024-08-26 14:59:17','2024-08-26 14:59:17',NULL,'1','Add New Invoice','1'),
('4472','VR-24-4472','2024-08-26 00:00:00','0','1250.00','1','19.25','0.00','','0','0','1',NULL,'0.00',NULL,NULL,NULL,NULL,NULL,'','90','0','2024-08-26 15:24:11','2024-08-26 15:24:11',NULL,'1','Add New Invoice','1'),
('4473','VR-24-4473','2024-08-26 00:00:00','0','1250.00','