# Print.js

[![Build Status](https://travis-ci.org/crabbly/Print.js.svg?branch=master)](https://travis-ci.org/crabbly/Print.js) [![Software License](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat)](LICENSE) [![Standard - JavaScript Style Guide](https://img.shields.io/badge/code%20style-standard-brightgreen.svg)](http://standardjs.com/)

A tiny javascript library to help printing from the web.

>For documentation and examples please visit: [printjs.crabbly.com](http://printjs.crabbly.com)


## Installation

You can download the latest version of [Print.js on GitHub](https://github.com/crabbly/Print.js/releases/latest) or just use the [Print.js CDN](http://printjs.crabbly.com/#cdn) links available on the documentation page.

To install via npm:

```bash
npm install print.js --save
```

## Documentation

You can find documentation at [printjs.crabbly.com](http://printjs.crabbly.com/#documentation).


## Contributing to Print.js

Contributions to Print.js are welcome and encouraged.


##### Using issues

The [issue tracker](https://github.com/crabbly/Print.js/issues) is the preferred channel for reporting bugs, requesting new features and submitting pull requests.

Keep in mind that we would like to keep this a lightweight library.

Please do not use the issues channel for support requests. For help using Print.js, please ask questions on Stack Overflow and use the tag `print.js`.


##### Reporting bugs

Well structured, detailed bug reports are hugely valuable for the project.

 - Check the issue search to see if it has already been reported
 - Isolate the problem to a simple test case

Please provide any additional details associated with the bug.


##### Pull requests

Clear, concise pull requests are excellent at continuing the project's community driven growth.

 - Please create an issue first:
   - For bugs, we can discuss the fixing approach
   - For enhancements, we can discuss if it is within the project scope and avoid duplicate effort
 - Tabs for indentation, not spaces please
 - Please make your commits in logical sections with clear commit messages


## License

Print.js is available under the [MIT license](https://github.com/crabbly/Print.js/blob/master/LICENSE).
